local addon = LibStub:GetLibrary("NaturCombat");
	assert(addon,"NaturCombatTimers failed to load in 'NaturCombat\addon\parser.lua' on line 1");
LibStub:GetLibrary("LibWombat"):NewParser(addon);
	assert(addon.StartParsing,"LibWombat failed to load in 'NaturCombat\addon\parser.lua' on line 3");
NaturDB = NaturDB or {Height=20,Width=270,Scale=1,FontSize=15,MaxBars=10,Lock=true,Growth="UP",Invert=true,Texture="NaturGlaze",Cooldowns=true,Diminishing=true,Sounds=true};
addon.factor = 1;
local CPAura, KillCounter, KillTimer = false, 0;
local expTime, activeDR = {}, {};
local CDTable = {};
----------------------------------------------------------------------------------------------------
addon:StartParsing("VARIABLES_LOADED", function()
	addon.group = addon.bar:RegisterGroup("NaturCombat", addon.media:Fetch("statusbar", NaturDB.Texture));
	addon.group:SetScale(NaturDB.Scale);
	addon.group:SetWidth(NaturDB.Width);
	addon.group:SetHeight(NaturDB.Height);
	addon.group:SetDisplayGroup("NaturCombat"); -- This redirects every bar to this certain group.
	addon.group:SetAnchorVisible(NaturDB.Lock);
	addon.group:SetGroupFontSize(NaturDB.FontSize);
	addon.group:SetMaxBars(NaturDB.MaxBars);
	addon.group:SetBarGrowth(NaturDB.Growth);
	addon.group:SetInvert(NaturDB.Invert);
	addon.group:SetPoint("CENTER");
	addon.group:RegisterOnFade(addon, "OnFade");
end);
----------------------------------------------------------------------------------------------------
addon:StartParsing("PLAYER_ENTERING_WORLD", function()
	local _, z = IsInInstance();
	if (z == "arena") then -- Player is in an arena, clean bars
		addon.group:UnregisterAllBars();
	end
end);
----------------------------------------------------------------------------------------------------
addon:StartParsing("SPELL_AURA_APPLIED", function(when,what,srcGUID,srcName,srcFlags,dstGUID,dstName,dstFlags,...)
	local spell = addon:GetSpellData(...);
	if (dstGUID == UnitGUID("target") or dstGUID == UnitGUID("focus")) and (dstGUID ~= UnitGUID("player")) then
		if (spell) and (spell.duration) then
			-- Talents?
			if (spell.talent) then
				if (spell.talent[5] == select(2,UnitClass("player"))) then
					local _, _, _, _, rank = GetTalentInfo(spell.talent[1], spell.talent[2]);
					if (rank) and (rank > 0) then
						spell.duration = spell.talent[3] + rank * spell.talent[4];
					end
				end
			end
			-- Set Bar Color
			local color = addon.colors["GREY"];
			if (spell.type == "BUFF") then
				if (CombatLog_Object_IsA(dstFlags, COMBATLOG_FILTER_HOSTILE_PLAYERS)) then
					color = addon.colors["HOSTILEBUFF"];
				elseif (CombatLog_Object_IsA(dstFlags, COMBATLOG_FILTER_FRIENDLY_UNITS)) then
					color = addon.colors["FRIENDLYBUFF"];
				end
			elseif (spell.type == "DEBUFF") then
				if (spell.stun) then
					color = addon.colors["STUN"];
				elseif (spell.dot) then
					color = addon.colors["DOT"];
				else
					color = addon.colors["DEBUFF"];
				end
			end
			-- PVP Duration?
			local duration = 1;
			local guid = strsub(dstGUID, 1 ,5);
			if (spell.pvpdur) and (bit.band(guid, 0x00F) == 0) then -- Player?
				duration = spell.pvpdur;
			else
				duration = spell.duration;
			end
			-- DR? only on target.
			if (dstGUID == UnitGUID("target")) and (spell.drcat) and (NaturDB.Diminishing) then
				addon:ApplyDiminish(spell.id, dstName, dstGUID);
				duration = duration * addon.factor;
			end
			-- Combo?
			if (spell.combo) then CPAura = true; end
			local text = spell.name .. " - " .. addon:StripName(dstName);
			addon.group:RegisterBar(dstGUID..spell.id, text, duration, nil, spell.icon, color.r, color.g, color.b);
		end
	end
end);
----------------------------------------------------------------------------------------------------
-- Deal with cooldowns and instant casts
-- Add cooldown to the CDTable so we can remove/show on target change
addon:StartParsing("SPELL_CAST_SUCCESS", function(when,what,srcGUID,srcName,srcFlags,dstGUID,dstName,dstFlags,...)
	local spell = addon:GetSpellData(...);
	--Quick fix for refreshing spells until 2.4.3 SPELL_AURA_REFRESH
	if (spell) and (spell.duration) then
		if (dstGUID == UnitGUID("target") or dstGUID == UnitGUID("focus")) and (dstGUID ~= UnitGUID("player")) then
			addon.group:SetTime(dstGUID..spell.id, spell.duration);
		end
	end
	-----------
	if (spell.special) and (srcGUID == UnitGUID("player")) then -- show this even tho the player casted it.
		local color = addon.colors["FRIENDLYBUFF"];
		local text = spell.name .. " - " .. srcName;
		addon.group:RegisterBar(srcGUID..spell.id, text, spell.duration, nil, spell.icon, color.r, color.g, color.b);
	end
	if (srcGUID == UnitGUID("player")) then return; end
	if (srcGUID == UnitGUID("target")) then --We don't want to show cooldowns for our focus.. maybe change this if someone requests it.
		if (spell) and (spell.cooldown) then
			if (spell.type == "CAST") and (spell.instant) then
				if (spell.duration) then
					local color;
					if (CombatLog_Object_IsA(srcFlags, COMBATLOG_FILTER_HOSTILE_PLAYERS)) then
						color = addon.colors["HOSTILEBUFF"];
					elseif (CombatLog_Object_IsA(srcFlags, COMBATLOG_FILTER_FRIENDLY_UNITS)) then
						color = addon.colors["FRIENDLYBUFF"];
					end
					local text = spell.name .. " - " .. addon:StripName(srcName);
					addon.group:RegisterBar(srcGUID..spell.id, text, spell.duration, nil, spell.icon, color.r, color.g, color.b);
				end
				if (NaturDB.Cooldowns) then
					local color = addon.colors["COOLDOWN"];
					local text = spell.name .. " [CD] - " .. addon:StripName(srcName);
					addon.group:RegisterBar(srcGUID..spell.id.."CD", text, spell.cooldown, nil, spell.icon, color.r, color.g, color.b);
					--Add to CDTable
					CDTable[srcGUID..spell.id.."CD"] = {srcGUID,spell.cooldown};
				end
			elseif (spell.type == "BUFF") then
				if (NaturDB.Cooldowns) then
					local color = addon.colors["COOLDOWN"];
					local text = spell.name .. " [CD] - " .. addon:StripName(srcName);
					addon.group:RegisterBar(srcGUID..spell.id.."CD", text, spell.cooldown, nil, spell.icon, color.r, color.g, color.b);
					-- Add to DB
					CDTable[srcGUID..spell.id.."CD"] = {srcGUID,spell.cooldown};
				end
			end
		end
	end
end);
----------------------------------------------------------------------------------------------------
addon:StartParsing("SPELL_AURA_REMOVED", function(when,what,srcGUID,srcName,srcFlags,dstGUID,dstName,dstFlags,...)
	local spell = addon:GetSpellData(...);
	if (spell) and (spell.duration) then
		if (spell.combo) then CPAura = false; end
		if (spell.drcat) then
			addon:RemoveDiminish(spell.id, dstName, dstGUID);
		end
		addon.group:UnregisterBar(dstGUID..spell.id);
	end
end);
----------------------------------------------------------------------------------------------------
addon:StartParsing("SPELL_AURA_DISPELLED", function(when,what,srcGUID,srcName,srcFlags,dstGUID,dstName,dstFlags,...)
	local spell = addon:GetSpellData(select(12, ...));
	if (spell) and (spell.duration) then
		addon.group:UnregisterBar(dstGUID..spell.id);
	end
end);
----------------------------------------------------------------------------------------------------
addon:StartParsing("SPELL_INTERRUPT", function(when,what,srcGUID,srcName,srcFlags,dstGUID,dstName,dstFlags,...)
	local spell = addon:GetSpellData(select(12, ...));
	if (spell) and (spell.duration) then
		addon.group:UnregisterBar(dstGUID..spell.id);
	end
end);
----------------------------------------------------------------------------------------------------
addon:StartParsing("SPELL_MISSED", function(when,what,srcGUID,srcName,srcFlags,dstGUID,dstName,dstFlags,...)
	local spell = addon:GetSpellData(...);
	if (spell) and (spell.duration) then
		addon.group:UnregisterBar(dstGUID..spell.id);
	end
end);
----------------------------------------------------------------------------------------------------
addon:StartParsing("SPELL_AURA_APPLIED_DOSE", function(when,what,srcGUID,srcName,srcFlags,dstGUID,dstName,dstFlags,...)
	local spell = addon:GetSpellData(...);
	local stack = select(5, ...);
	if (dstGUID == UnitGUID("player")) then return; end
	if (dstGUID == UnitGUID("target")) or (dstGUID == UnitGUID("focus")) then
		if (spell) and (spell.stacks) and (spell.duration) then
			local text = "(" .. stack .. ") " .. spell.name .. " - " .. addon:StripName(dstName);
			addon.group:SetBarText(dstGUID..spell.id, text);
			addon.group:SetTime(dstGUID..spell.id, spell.duration);
		end
	end
end);
----------------------------------------------------------------------------------------------------
addon:StartParsing("SPELL_AURA_REMOVED_DOSE", function(when,what,srcGUID,srcName,srcFlags,dstGUID,dstName,dstFlags,...)
	local spell = addon:GetSpellData(...);
	local stack = select(5, ...);
	if (dstGUID == UnitGUID("player")) then return; end
	if (dstGUID == UnitGUID("target")) or (dstGUID == UnitGUID("focus")) then
		if (spell) and (spell.stacks) and (spell.duration) then
			local text = "(" .. stack .. ") " .. spell.name .. " - " .. addon:StripName(dstName);
			addon.group:SetBarText(dstGUID..spell.id, text);
		end
	end
end);
----------------------------------------------------------------------------------------------------
addon:StartParsing("UNIT_DIED", function(when,what,srcGUID,srcName,srcFlags,dstGUID,dstName,dstFlags,...)
	if (dstGUID == UnitGUID("player")) then return; end
	for k, v in pairs(addon.spelldata) do
		addon.group:UnregisterBar(dstGUID..k);
		addon.group:UnregisterBar(dstGUID..k.."CD");
		if (addon.spelldata[k].drcat) then
			addon.group:UnregisterBar(dstGUID..addon.spelldata[k].drcat);
		end
		CDTable[dstGUID..k.."CD"] = nil;
	end
end);
----------------------------------------------------------------------------------------------------
addon:StartParsing("UNIT_SPELLCAST_START", function(unitid, spell, ...)
	if (UnitGUID(unitid) == UnitGUID("player")) then return; end
	if (unitid == "target" and spell) or (unitid == "focus" and spell) then
		local color;
		if (UnitReaction(unitid, "player") < 4) then -- Hostile
			color = addon.colors["HOSTILECAST"];
		else
			color = addon.colors["FRIENDLYCAST"];
		end
		local icon, sTime, eTime = select(4, UnitCastingInfo(unitid));
		local text = spell .. " - " .. addon:StripName(UnitName(unitid));
		sTime, eTime = sTime/1000, eTime/1000;
		addon.group:RegisterBar(UnitGUID(unitid).."cast", text, eTime - sTime, nil, icon, color.r, color.g, color.b);
	end
end);
addon:StartParsing("UNIT_SPELLCAST_STOP", function(unitid, ...) -- This is suppose to return the spellname yet fails to do so..
	if (UnitGUID(unitid) == UnitGUID("player")) then return; end
	if (unitid == "target") or (unitid == "focus") then
		addon.group:UnregisterBar(UnitGUID(unitid).."cast");
	end
end);
----------------------------------------------------------------------------------------------------
addon:StartParsing("UNIT_SPELLCAST_CHANNEL_START", function(unitid, spell, ...)
	if (UnitGUID(unitid) == UnitGUID("player")) then return; end
	if (unitid == "target" and spell) or (unitid == "focus" and spell) then
		local color;
		if (UnitReaction(unitid, "player") < 4) then -- Hostile
			color = addon.colors["HOSTILECAST"];
		else
			color = addon.colors["FRIENDLYCAST"];
		end
		local icon, sTime, eTime = select(4, UnitChannelInfo(unitid));
		local text = spell .. " - " .. addon:StripName(UnitName(unitid));
		sTime, eTime = sTime/1000, eTime/1000;
		addon.group:RegisterBar(UnitGUID(unitid).."channel", text, eTime - sTime, nil, icon, color.r, color.g, color.b);
	end
end);
----------------------------------------------------------------------------------------------------
addon:StartParsing("UNIT_SPELLCAST_CHANNEL_STOP", function(unitid, spell, ...)
	if (UnitGUID(unitid) == UnitGUID("player")) then return; end
	if (unitid == "target") or (unitid == "focus") then
		addon.group:UnregisterBar(UnitGUID(unitid).."channel");
	end
end);
----------------------------------------------------------------------------------------------------
-- NOTE: There has to be a better way to deal with combo point abilites :/
addon:StartParsing("UNIT_AURA", function(unitid)
	if (UnitGUID(unitid) == UnitGUID("player")) then return; end
	if (unitid == "target") or (unitid == "focus") then
		local name, duration;
		if (not CPAura) then return; end
		local id = 0;
		while (true) do
			id = id + 1;
			name, _, _, _, _, duration = UnitDebuff(unitid, id);
			if (not name) then break; end
			if (addon.spellkeys[name]) then
				if (addon.spelldata[addon.spellkeys[name]].combo) and (addon.spelldata[addon.spellkeys[name]].duration) then
					local text = name .. " - " .. addon:StripName(UnitName(unitid));
					if (not duration) then
						duration = addon.spelldata[addon.spellkeys[name]].duration;
					end
					addon.group:SetTime(UnitGUID(unitid)..addon.spelldata[addon.spellkeys[name]].id, duration);
					CPAura = false;
				end
			end
		end
	end
end);
----------------------------------------------------------------------------------------------------
addon:StartParsing("PLAYER_TARGET_CHANGED", function()
	-- Remove CD's from old target
	for id, cooldown in pairs(CDTable) do
		if (UnitGUID("target") ~= cooldown[1]) then
			addon.group:HideBar(id);
		else
			addon.group:ShowBar(id, cooldown[2]);
		end
	end
end);
----------------------------------------------------------------------------------------------------
addon:StartParsing("PARTY_KILL", function(when,what,srcGUID,srcName,srcFlags,dstGUID,dstName,dstFlags,...)
	local guid = strsub(dstGUID, 1, 5);
	if (srcGUID == UnitGUID("player")) and (bit.band(guid, 0x00F) == 0) and (NaturDB.Sounds) then
		if (not KillTimer) or (GetTime() - KillTimer > 60) then
			PlaySoundFile(addon.media:Fetch("sound", "First Blood"));
			KillCounter = 0;
		elseif (GetTime() - KillTimer <= 60) then
			KillCounter = KillCounter + 1
			if (KillCounter == 1) then
				PlaySoundFile(addon.media:Fetch("sound", "Dominating"));
			elseif (KillCounter == 2) then
				PlaySoundFile(addon.media:Fetch("sound", "Killing Spree"));
			elseif (KillCounter == 3) then
				PlaySoundFile(addon.media:Fetch("sound", "Unstoppable"));
			elseif (KillCounter == 4) then
				PlaySoundFile(addon.media:Fetch("sound", "Monster Kill"));
			elseif (KillCounter > 4) then
				PlaySoundFile(addon.media:Fetch("sound", "Godlike"));
			end
		end
		KillTimer = GetTime();
	end
end);
----------------------------------------------------------------------------------------------------
-- TODO: Look over DR code and improve it.
-- Massive thanks to Shadowd the author of DR Tracker.
function addon:ApplyDiminish(spellID, dstName, dstGUID)
	local spell = addon:GetSpellData(spellID);
	local id = dstGUID .. spell.drcat;
	local time = GetTime();
	local diminished = 100;
	if (expTime[id] and expTime[id] >= time) then
		diminished = self:GetDR(activeDR[id]);
		addon.factor = select(3, self:GetDR(activeDR[id]));
		activeDR[id] = diminished;
		expTime[id] = GetTime() + 15;
		addon.group:UnregisterBar(id);
	elseif (not expTime[id] or expTime[id] <= time) then
		activeDR[id] = diminished;
		addon.factor = 1;
		expTime[id] = GetTime() + 15;
	end
end;
----------------------------------------------------------------------------------------------------
function addon:RemoveDiminish(spellId, dstName, dstGUID)
	local spell = addon:GetSpellData(spellId);
	local id = dstGUID .. spell.drcat;
	if (activeDR[id]) then
		local text = spell.name .. " [".. spell.drcat .." |cffff2020DR " .. select(2,addon:GetDR(activeDR[id])) .. "/3|r] - " .. addon:StripName(dstName);
		local color = addon.colors["COOLDOWN"];
		addon.group:RegisterBar(id, text, 15, nil, spell.icon, color.r, color.g, color.b);
	end
	expTime[id] = GetTime() + 15;
end;
----------------------------------------------------------------------------------------------------
function addon:GetDR(dr)
	if (dr == 100) then
		return 50, 1, 0.5;
	elseif (dr == 50) then
		return 25, 2, 0.25;
	elseif (dr == 25) then
		return 0, "Immune! 3", 0;
	end
end;
----------------------------------------------------------------------------------------------------
function addon:OnFade(barid)
	if (CDTable[barid]) then
		CDTable[barid] = nil;
	end
end;