local addon = LibStub:GetLibrary("NaturCombat");
assert(addon,"NaturCombat failed to load in 'NaturCombat\addon\generator.lua' on line 1");
addon.bar = LibStub:GetLibrary("GTB-1.0");
assert(addon.bar,"GTB-1.0 failed to load in 'NaturCombat\addon\generator.lua' on line 3");
addon.media = LibStub:GetLibrary("LibSharedMedia-3.0");
assert(addon.media, "LibSharedMedia-3.0 failed to load in 'NaturCombat\addon\generator.lua' on line 5");
----------------------------------------------------------------------------------------------------
addon.colors = {};
addon.colors["HOSTILECAST"] = {r = 1, g = 0, b = 0};
addon.colors["FRIENDLYCAST"] = {r = 0, g= 1, b = 0};
addon.colors["COOLDOWN"] = {r = 0, g = 0, b = 1};
addon.colors["HOSTILEBUFF"] = {r = 0.5, g = 0, b = 0.65};
addon.colors["FRIENDLYBUFF"] = {r = 1, g = 0, b = 1};
addon.colors["STUN"] = {r = 0.5, g = 0.2, b = 0.1};
addon.colors["DOT"] = {r = 0, g = 0.8, b = 0.8};
addon.colors["DEBUFF"] = {r = 0.8, g = 0.8, b = 0};
addon.colors["GREY"] = { r = 0.8, g = 0.8, b = 0.8};
----------------------------------------------------------------------------------------------------
addon.media:Register("statusbar", "NaturGlaze", [[Interface\AddOns\NaturCombat\media\glaze]]);
----------------------------------------------------------------------------------------------------
addon.media:Register("sound", "First Blood", [[Interface\AddOns\NaturCombat\media\sounds\firstblood.mp3]]);
addon.media:Register("sound", "Dominating", [[Interface\AddOns\NaturCombat\media\sounds\dominating.mp3]]);
addon.media:Register("sound", "Killing Spree", [[Interface\AddOns\NaturCombat\media\sounds\killingspree.mp3]]);
addon.media:Register("sound", "Unstoppable", [[Interface\AddOns\NaturCombat\media\sounds\unstoppable.mp3]]);
addon.media:Register("sound", "Monster Kill", [[Interface\AddOns\NaturCombat\media\sounds\monsterkill.mp3]]);
addon.media:Register("sound", "Godlike", [[Interface\AddOns\NaturCombat\media\sounds\godlike.mp3]]);
----------------------------------------------------------------------------------------------------
-- This is to deal with realm names from cross realm battlegroups
function addon:StripName(name)
	name = string.match(name, "[^-]*");
	return name;
end
----------------------------------------------------------------------------------------------------
local f = CreateFrame("Frame", nil, InterfaceOptionsFrame)
f:SetScript("OnShow", function(self) LoadAddOn("NaturOptions"); self:SetScript("OnShow", nil) end);
SlashCmdList["NaturCombat"] = function()
	if (LoadAddOn("NaturOptions")) then
		InterfaceOptionsFrame_OpenToFrame("NaturCombat");
	end
end;
SLASH_NaturCombat1 = "/necb";
SLASH_NaturCombat2 = "/natur";