
--[[--------------------------------------------------------

	By Trysor
	MusicPlayer & MusicPlayerMediaLibrary

	Todo list:
	- GUI
	- Lightweight system
	- Playlist maker (for ingame playlists)
	- Infosenter (sort by, most played, rating(?), etc)
	- Keybindings to each song (like Trinity Bars 2)
	- Queue and Favorites included here instead.

	something else?


--]]--------------------------------------------------------

MPML = {};
MPML.Version = 1;
MPML.Loaded = false;

MPML.Tab = 1;

MPML.SortBy = 1;
MPML.LastSort = 0;
MPML.SortDir = "Up";
MPML.LastSearch = 0;
MPML.FirstNumInSearch = 0;

MPML.PopupSelected = 0;
MPML.PopupRealSelected = 0;
MPML.PopupType = "";
MPML.PopupTable = {};

MPML.Selected = 1;
MPML.RealSelected = 0;

MPML.Playlist = "All Tracks";



------------------------------------------------------------
-- Initialize
------------------------------------------------------------

function MusicPlayerMediaLibrary_OnLoad()
	
	this:RegisterEvent("ADDON_LOADED");
end

function MusicPlayerMediaLibrary_OnEvent(event, ...)

	if event == "ADDON_LOADED" and arg1 == "MusicPlayerMediaLibrary" then
		if MusicPlayer_MPML_Support and MusicPlayer_MPML_Support >= MPML.Version then
			MusicPlayerMediaLibrary_Initialize();

			if MusicPlayer_MPML_Support > MPML.Version then
				MPPC(MPML_Locale_NewVersionAvailible, true,1,1,0);
			end
		else
			MPPC(MPML_Locale_NotCompatible, true, 1,1,0);
		end
	end
end

function MusicPlayerMediaLibrary_Initialize()
	MusicPlayerMediaLibrary_Favorites_LoadCurrentFavorites();

	MusicPlayerMediaLibrary_Tabs_LoadTabs();
	MusicPlayerMediaLibrary_DisplayFrame_SortButtons_LoadButtons();
	MusicPlayerMediaLibrary_DisplayFrame_LoadDetailButtons();
	MusicPlayerMediaLibrary_ButtonsFrame_LoadButtons();

	MusicPlayerMediaLibrary_LoadPlaylists();
	MusicPlayerMediaLibrary_LoadRatings();

	MPML_Popup_LoadListButtons();
	MPML_Popup_LoadFunctionButtons();

	StaticPopupDialogs["MPML_ENQUEUE_REMALL"] = {
		text = MusicPlayer_Enqueue_RemoveAllQuestion,
		button1 = ACCEPT,
		button2 = CANCEL,
		OnAccept = function()
			MusicPlayerMediaLibrary_Enqueue_UnqueueAll();
		end,
		OnHide = function()
		end,

		timeout = 0,
		exclusive = 1,
		whileDead = 1,
		hideOnEscape = 1
	};

	-- HALP HALP HALP MEH!
	MusicPlayerHelpFrame.maxpages = MusicPlayerHelpFrame.maxpages + 1;
	MusicPlayerHelpFrame_HelpTable["Page"..MusicPlayerHelpFrame.maxpages] = {};
	MusicPlayerHelpFrame_HelpTable["Page"..MusicPlayerHelpFrame.maxpages]["Header"] = "MusicPlayerMediaLibrary";
	MusicPlayerHelpFrame_HelpTable["Page"..MusicPlayerHelpFrame.maxpages]["Text"] = MusicPlayer_Help_MediaLibrary;
	MusicPlayerHelpFrame_Update_TableOfContents();

	-- Button to access the frame through the playlist
	local btn = CreateFrame("Button", "MusicPlayer_PlayerFrame_Playlist_ToggleMPML_Button", MusicPlayer_PlayerFrame_Playlist);
	btn:SetWidth(75);
	btn:SetHeight(17);
	btn:SetPoint("TOPLEFT", btn:GetParent(), "TOPLEFT", 3, -3);
	btn.text = btn:CreateFontString();
	btn.text:SetFontObject("GameFontNormalSmall");
	btn.text:SetTextColor(MusicPlayerFrameOptions.Color[1][1], MusicPlayerFrameOptions.Color[1][2], MusicPlayerFrameOptions.Color[1][3]);
	btn.text:SetText("Media Library");
	btn.text:SetWidth(75);
	btn.text:SetHeight(2);
	btn.text:SetJustifyH("LEFT");
	btn.text:SetPoint("LEFT", btn, "LEFT", 6, 0);
	btn:SetScript("OnClick", function() MusicPlayerMediaLibrary_Toggle() end);

	-- Add our slashcommands
	MusicPlayer_SlashCommands["medialibrary"] = function() MusicPlayerMediaLibrary_Toggle() end
	MusicPlayer_SlashCommands["library"] = function() MusicPlayerMediaLibrary_Toggle() end
	MusicPlayer_SlashCommands["ml"] = function() MusicPlayerMediaLibrary_Toggle() end

	MusicPlayerMediaLibrary_Update();
	MPML.Loaded = true;
end

function MusicPlayerMediaLibrary_Toggle()
	if MPML.Loaded then
		if MusicPlayerMediaLibrary:IsVisible() then
			MusicPlayerMediaLibrary:Hide();
		else
			MusicPlayerMediaLibrary:Show();
		end
	end
end


------------------------------------------------------------
-- Update
------------------------------------------------------------


function MusicPlayerMediaLibrary_Update()

	MusicPlayerMediaLibrary_SortButton_SortBy();
	MusicPlayerMediaLibrary_DisplayFrame_SortButtons_UpdateButtons();

	MusicPlayerMediaLibrary_DisplayFrame_ScrollFrame:SetVerticalScroll(0);
	MusicPlayerMediaLibrary_DisplayFrame_UpdateDetailButtons();

	MusicPlayerMediaLibrary_ButtonsFrame_UpdateButtons();
end


------------------------------------------------------------
-- Tabs
------------------------------------------------------------

function MusicPlayerMediaLibrary_Tabs_LoadTabs()
	local tab, lasttab;

	for i = 1,5 do
		tab = CreateFrame("Button", "MPML_Tab"..i, MusicPlayerMediaLibrary_TabRow, "MPML_Tab_Template");
		tab:SetID(i);

		tab:SetWidth(690/5);
		tab:SetHeight(30);


		lasttab = i-1;

		tab:ClearAllPoints();

		if i == 1 then
			tab:SetPoint("LEFT", MusicPlayerMediaLibrary_TabRow, "LEFT");
		else
			tab:SetPoint("LEFT", "MPML_Tab"..lasttab, "RIGHT");
		end
		if i > 3 then
			tab:Disable(); -- Disable as it is not ready yet.
		end

		getglobal("MPML_Tab"..i.."_Text"):SetText(MPML_Tabs[i]);
		tab:Show();
	end

	-- Set tab1 as selected
	getglobal("MPML_Tab1"):SetBackdropColor(MPML_Colors["Tabs"]["Selected"].r, MPML_Colors["Tabs"]["Selected"].g, MPML_Colors["Tabs"]["Selected"].b);
end


function MusicPlayerMediaLibrary_Tab_SelectTab(ID)
	MPML.Tab = ID;
 
	for i = 1,5 do
		if i == ID then
			getglobal("MPML_Tab"..i):SetBackdropColor(MPML_Colors["Tabs"]["Selected"].r, MPML_Colors["Tabs"]["Selected"].g, MPML_Colors["Tabs"]["Selected"].b);
		else
			getglobal("MPML_Tab"..i):SetBackdropColor(MPML_Colors["BG"]["Box"].r, MPML_Colors["BG"]["Box"].g, MPML_Colors["BG"]["Box"].b);
		end
	end

	MPML.LastSort = 0;
	MPML.SortBy = 1;

	MusicPlayerMediaLibrary_Update();
end

------------------------------------------------------------
-- Sort functions
------------------------------------------------------------

function MusicPlayerMediaLibrary_DisplayFrame_SortButtons_LoadButtons()
	local button, lastbutton;

	for i = 1,4 do
		button = CreateFrame("Button", "MPML_SortButton"..i, MusicPlayerMediaLibrary_DisplayFrame, "MPML_SortButton_Template");
		button:SetID(i);

		button:SetWidth(MPML_SortButtonRowWidth[i]);
		button:SetHeight(20);

		lastbutton = i-1;

		button:ClearAllPoints();

		if i == 1 then
			button:SetPoint("TOPLEFT", MusicPlayerMediaLibrary_DisplayFrame, "TOPLEFT");
		else
			button:SetPoint("LEFT", "MPML_SortButton"..lastbutton, "RIGHT");
		end

		getglobal("MPML_SortButton"..i.."_Text"):SetText(MPML_SortButtons[MPML.Tab][i]);
		getglobal("MPML_SortButton"..i.."_SortArrow"):SetVertexColor(0.8,0,0);
		button:Show();
	end
end

function MusicPlayerMediaLibrary_DisplayFrame_SortButtons_UpdateButtons()

	for i = 1,4 do
		getglobal("MPML_SortButton"..i.."_Text"):SetText(MPML_SortButtons[MPML.Tab][i]);
		if i == MPML.SortBy then
			getglobal("MPML_SortButton"..i):SetBackdropColor(MPML_Colors["Tabs"]["Selected"].r, MPML_Colors["Tabs"]["Selected"].g, MPML_Colors["Tabs"]["Selected"].b);
		else
			getglobal("MPML_SortButton"..i):SetBackdropColor(MPML_Colors["BG"]["Box"].r, MPML_Colors["BG"]["Box"].g, MPML_Colors["BG"]["Box"].b);
		end
	end
end

function MusicPlayerMediaLibrary_SortButton_OnClick(ID)
	MPML.LastSort = MPML.SortBy;
	MPML.SortBy = ID;

	for i = 1,4 do
		if i == ID then
			getglobal("MPML_SortButton"..i):SetBackdropColor(MPML_Colors["Tabs"]["Selected"].r, MPML_Colors["Tabs"]["Selected"].g, MPML_Colors["Tabs"]["Selected"].b);
		else
			getglobal("MPML_SortButton"..i):SetBackdropColor(MPML_Colors["BG"]["Box"].r, MPML_Colors["BG"]["Box"].g, MPML_Colors["BG"]["Box"].b);
		end
	end

	MusicPlayerMediaLibrary_SortButton_SortBy()
end

function MusicPlayerMediaLibrary_SortButton_SortBy()
	local sortby = "Title";
	local replaced = nil;
	local titlereplaced = nil;

	MPML.SortedList = {};
	MPML.SortedIndex = {};

	local listtable = {
		[1] = MusicPlayerSongs,
		[2] = MusicPlayerMediaLibrary_Favorites,
		[3] = MusicPlayerSongs,
		[4] = MusicPlayerSongs, -- replace with MusicPlayerMediaLibrary_Playlists[MPML.Playlist]
		[5] = MusicPlayerSongs, -- replace with MusicPlayerMediaLibrary_Ratings
	};


	for k, v in pairs(listtable[MPML.Tab]) do

		if (MusicPlayerSongs[k][MPML_SortButtons[MPML.Tab][MPML.SortBy]] ~= nil) then
			sortby = MPML_SortButtons[MPML.Tab][MPML.SortBy];
		end



		if (MPML.SortBy == 1) then
			if type(v) == "table" then
				replaced = MusicPlayerSongs[k]["Title"];
				replaced = gsub(replaced, "(%d+)", MusicPlayer_SortSongs_fixNumber);

				MPML.SortedList[k] = strlower(replaced.." "..k);
			elseif type(v) == "number" then
				replaced = MusicPlayerSongs[v]["Title"];
				replaced = gsub(replaced, "(%d+)", MusicPlayer_SortSongs_fixNumber);

				MPML.SortedList[k] = strlower(replaced.." "..v);
			end
		elseif (MPML.SortBy == 4) then
			local text = "";
			for queuednr,songnr in pairs(MusicPlayer_EnqueueTable) do
				if type(v) == "table" then
					if songnr == k then
						text = gsub(queuednr, "(%d+)", MusicPlayer_SortSongs_fixNumber);
						break;
					end
				elseif type(v) == "number" then
					if songnr == v then
						text = gsub(queuednr, "(%d+)", MusicPlayer_SortSongs_fixNumber);
						break;
					end
				end
			end
			if text == "" then
				text = "Not Queued";
			end

			if type(v) == "table" then
				replaced = MusicPlayerSongs[k]["Title"];
				replaced = gsub(replaced, "(%d+)", MusicPlayer_SortSongs_fixNumber);

				MPML.SortedList[k] = strlower(text..replaced.." "..k);
			elseif type(v) == "number" then
				replaced = MusicPlayerSongs[v]["Title"];
				replaced = gsub(replaced, "(%d+)", MusicPlayer_SortSongs_fixNumber);

				MPML.SortedList[k] = strlower(text..replaced.." "..v);
			end
			
		else
			if type(v) == "table" then
				replaced = MusicPlayerSongs[k][sortby];
				replaced = gsub(replaced, "(%d+)", MusicPlayer_SortSongs_fixNumber);

				titlereplaced = MusicPlayerSongs[k]["Title"];
				titlereplaced = gsub(titlereplaced, "(%d+)", MusicPlayer_SortSongs_fixNumber);

				MPML.SortedList[k] = strlower(MusicPlayerSongs[k][sortby]..MusicPlayerSongs[k]["Title"].." "..k);
			elseif type(v) == "number" then
				replaced = MusicPlayerSongs[k][sortby];
				replaced = gsub(replaced, "(%d+)", MusicPlayer_SortSongs_fixNumber);

				titlereplaced = MusicPlayerSongs[v]["Title"];
				titlereplaced = gsub(titlereplaced, "(%d+)", MusicPlayer_SortSongs_fixNumber);

				MPML.SortedList[k] = strlower(replaced..titlereplaced.." "..v);
			end
		end
	end

	if (MPML.LastSort == MPML.SortBy and MPML.SortDir == "Up") then
		sort(MPML.SortedList, function(a,b) return a>b end); -- z first
		MPML.SortDir = "Down";
	else
		sort(MPML.SortedList, function(a,b) return a<b end); -- a first
		MPML.SortDir = "Up";
	end


	for k,v in pairs(MPML.SortedList) do
		local a, b, _, Number = strfind(v, "(.+) (%d+)");

		MPML.SortedIndex[tonumber(Number)] = k;
	end

	if getn(MPML.SortedList) > 0 then
		MPML.Selected = 1;
		local a, b, _, Number = strfind(MPML.SortedList[1], "(.+) (%d+)");
		Number = tonumber(Number);
		MPML.RealSelected = Number;
		MPML.LastSearch = 0;
	else
		MPML.Selected = 0;
		MPML.RealSelected = 0;
		MPML.LastSearch = 0;
	end
	MusicPlayerMediaLibrary_Sort_UpdateArrows();
	MusicPlayerMediaLibrary_DisplayFrame_UpdateDetailButtons();
end

function MusicPlayerMediaLibrary_Sort_GetInfo(tab)
	local table = {
		[1] = MusicPlayer_GetSongNum(),
		[2] = MusicPlayerMediaLibrary_Favorites_GetNumFavorites(),
		[3] = MusicPlayer_GetSongNum(),
		[4] = MusicPlayer_GetSongNum(),
		[5] = MusicPlayer_GetSongNum(),
	};
	return table[tab];
end

function MusicPlayerMediaLibrary_Sort_UpdateArrows()
	local btn;
	local arrow;
	for i = 1,4 do
		btn = "MPML_SortButton"..i;
		arrow = getglobal(btn.."_SortArrow");
		if i == MPML.SortBy then
			if MPML.SortDir == "Down" then
				arrow:Show();
				arrow:SetTexCoord(0, 0.5625, 1.0, 0);
				arrow:ClearAllPoints();
				arrow:SetPoint("LEFT", getglobal(btn.."_Text"), "RIGHT", 1, 0);
			else
				arrow:Show();
				arrow:SetTexCoord(0, 0.5625, 0, 1.0);
				arrow:ClearAllPoints();
				arrow:SetPoint("LEFT", getglobal(btn.."_Text"), "RIGHT", 1, -2.25);
			end
		else
			getglobal("MPML_SortButton"..i.."_SortArrow"):Hide();
		end
	end

end



------------------------------------------------------------
-- Display Frame
------------------------------------------------------------

function MusicPlayerMediaLibrary_DisplayFrame_LoadDetailButtons()
	local button, lastbutton;

	for i = 1, 14 do
		button = CreateFrame("Button", "MPML_Display_DetailButton"..i, MusicPlayerMediaLibrary_DisplayFrame, "MPML_DisplayDetail_Template");

		lastbutton = i-1;

		button:SetID(i);

		for t = 1,4 do
			getglobal(button:GetName().."_TextBox"..t):SetWidth(MPML_SortButtonRowWidth[t]);
			getglobal(button:GetName().."_TextBox"..t.."_Text"):SetWidth(MPML_SortButtonRowWidth[t]);
		end

		button:ClearAllPoints();

		if i == 1 then
			button:SetPoint("TOPLEFT", MusicPlayerMediaLibrary_DisplayFrame_ScrollFrame, "TOPLEFT",0,1);
		else
			button:SetPoint("TOPLEFT", "MPML_Display_DetailButton"..lastbutton, "BOTTOMLEFT");
		end
	end
end

function MusicPlayerMediaLibrary_DisplayFrame_UpdateDetailButtons()
	local indexnr;
	local a, b, _, Number;

	FauxScrollFrame_Update(MusicPlayerMediaLibrary_DisplayFrame_ScrollFrame, MusicPlayerMediaLibrary_Sort_GetInfo(MPML.Tab), 14, 20.5);
	for button = 1,14 do
		indexnr = button + FauxScrollFrame_GetOffset(MusicPlayerMediaLibrary_DisplayFrame_ScrollFrame);

		if (indexnr <= MusicPlayerMediaLibrary_Sort_GetInfo(MPML.Tab) and MusicPlayerMediaLibrary_Sort_GetInfo(MPML.Tab) ~= 0) then
			a, b, _, Number = strfind(MPML.SortedList[indexnr], "(.+) (%d+)");

			Number = tonumber(Number);

			for textnr = 1,4 do
				if MusicPlayerSongs[Number][MPML_SortButtons[MPML.Tab][textnr]] then
					getglobal("MPML_Display_DetailButton"..button.."_TextBox"..textnr.."_Text"):SetText(MusicPlayerSongs[Number][MPML_SortButtons[MPML.Tab][textnr]]);
				else
					local text = "";
					for k,v in pairs(MusicPlayer_EnqueueTable) do
						if v == Number then
							text = k;
							break;
						end
					end
					if text == "" then
						text = "Not Queued";
					end
					getglobal("MPML_Display_DetailButton"..button.."_TextBox"..textnr.."_Text"):SetText(text);
				end
			end

			if indexnr == MPML.Selected  then
				getglobal("MPML_Display_DetailButton"..button):SetBackdropColor(MPML_Colors["Tabs"]["Selected"].r, MPML_Colors["Tabs"]["Selected"].g, MPML_Colors["Tabs"]["Selected"].b);
			else
				getglobal("MPML_Display_DetailButton"..button):SetBackdropColor(MPML_Colors["BG"]["Box"].r, MPML_Colors["BG"]["Box"].g, MPML_Colors["BG"]["Box"].b);
			end
			getglobal("MPML_Display_DetailButton"..button):Show();
		else
			getglobal("MPML_Display_DetailButton"..button):Hide();
		end
	end
end

function MusicPlayerMediaLibrary_DisplayFrame_SelectDetail(ID)
	MPML.Selected = ID + FauxScrollFrame_GetOffset(MusicPlayerMediaLibrary_DisplayFrame_ScrollFrame);

	local a, b, _, Number = strfind(MPML.SortedList[MPML.Selected], "(.+) (%d+)");

	Number = tonumber(Number);

	MPML.RealSelected = Number;

	MusicPlayerMediaLibrary_DisplayFrame_UpdateDetailButtons();
end




------------------------------------------------------------
-- Search
------------------------------------------------------------

function MusicPlayerMediaLibrary_UpdateSearchText(searchquery, text)
	local message;
	local startpos, endpos, Text;
	if searchquery and text then
		startpos, endpos, Text = strfind(text, searchquery);
	elseif searchquery then
		message = format(MusicPlayer_CantFindSong, searchquery);
	else
		message = MPML_Locale_Search_LoadMessage;
		MusicPlayerMediaLibrary_Searcher:SetText("");
		MusicPlayerMediaLibrary_Searcher:ClearFocus();
	end

	if startpos then
		text = gsub(text, searchquery, MP_White..searchquery.."|r");
		message = format("%q found in %q, from character %s to %s.", searchquery, text, startpos, endpos);
	end
	MusicPlayerMediaLibrary_AddMessage(message);
end

function MusicPlayerMediaLibrary_Search(text)
	local a, b, _, Number;
	local startpos, endpos, Text;
	local text = strlower(text);
	local searchednum = 0;

	for k, v in pairs(MPML.SortedList) do
		a, b, _, Number = strfind(v, "(.+) (%d+)");
		Number = tonumber(Number);

		if strfind(strlower(MusicPlayerSongs[Number]["Title"]), text) then
			startpos, endpos, Text = strfind(strlower(MusicPlayerSongs[Number]["Title"]), text);	

			if k > MPML.LastSearch then
				if MPML.LastSearch == 0 then
					MPML.FirstNumInSearch = k;
				end

				MPML.Selected = k;
				MPML.RealSelected = Number;

				searchednum = k - 1;

				if (searchednum > (MusicPlayerMediaLibrary_Sort_GetInfo(MPML.Tab) - 14) ) then
					searchednum = MusicPlayerMediaLibrary_Sort_GetInfo(MPML.Tab) - 14;
				end

				MusicPlayerMediaLibrary_DisplayFrame_ScrollFrame:SetVerticalScroll(searchednum*20.5);
				MusicPlayerMediaLibrary_DisplayFrame_ScrollFrame:UpdateScrollChildRect();
				MusicPlayerMediaLibrary_DisplayFrame_UpdateDetailButtons();
				MPML.LastSearch = k;

				MusicPlayerMediaLibrary_UpdateSearchText(text, strlower(MusicPlayerSongs[Number]["Title"]));
				return;
			end
		elseif strfind(strlower(MusicPlayerSongs[Number]["Artist"]), text) then
			startpos, endpos, Text = strfind(strlower(MusicPlayerSongs[Number]["Artist"]), text);	

			if k > MPML.LastSearch then
				if MPML.LastSearch == 0 then
					MPML.FirstNumInSearch = k;
				end

				MPML.Selected = k;
				MPML.RealSelected = Number;

				searchednum = k - 1;

				if (searchednum > (MusicPlayerMediaLibrary_Sort_GetInfo(MPML.Tab) - 14) ) then
					searchednum = MusicPlayerMediaLibrary_Sort_GetInfo(MPML.Tab) - 14;
				end

				MusicPlayerMediaLibrary_DisplayFrame_ScrollFrame:SetVerticalScroll(searchednum*20.5);
				MusicPlayerMediaLibrary_DisplayFrame_ScrollFrame:UpdateScrollChildRect();
				MusicPlayerMediaLibrary_DisplayFrame_UpdateDetailButtons();
				MPML.LastSearch = k;

				MusicPlayerMediaLibrary_UpdateSearchText(text, strlower(MusicPlayerSongs[Number]["Artist"]));
				return;
			end
		end
	end
	if MPML.LastSearch > 0 then

		MPML.Selected = MPML.FirstNumInSearch;
		a, b, _, Number = strfind(MPML.SortedList[MPML.FirstNumInSearch], "(.+) (%d+)");
		Number = tonumber(Number);
		MPML.RealSelected = Number;

		searchednum = MPML.FirstNumInSearch - 1;

		if (searchednum > (MusicPlayerMediaLibrary_Sort_GetInfo(MPML.Tab) - 14) ) then
			searchednum = MusicPlayerMediaLibrary_Sort_GetInfo(MPML.Tab) - 14;
		end

		MusicPlayerMediaLibrary_DisplayFrame_ScrollFrame:SetVerticalScroll(searchednum*20.5);
		MusicPlayerMediaLibrary_DisplayFrame_ScrollFrame:UpdateScrollChildRect();
		MusicPlayerMediaLibrary_DisplayFrame_UpdateDetailButtons();
		MPML.LastSearch = MPML.FirstNumInSearch;

		if strfind(strlower(MusicPlayerSongs[Number]["Title"]), text) then
			MusicPlayerMediaLibrary_UpdateSearchText(text, strlower(MusicPlayerSongs[Number]["Title"]));
		elseif strfind(strlower(MusicPlayerSongs[Number]["Artist"]), text) then
			MusicPlayerMediaLibrary_UpdateSearchText(text, strlower(MusicPlayerSongs[Number]["Artist"]));
		else
			MusicPlayerMediaLibrary_UpdateSearchText(text);
		end
		return;
	end
	MusicPlayerMediaLibrary_UpdateSearchText(text);
end

function MusicPlayerMediaLibrary_AddMessage(msg)
	MusicPlayerMediaLibrary_MessageFrame:AddMessage(msg,1,0,0,1);
end


------------------------------------------------------------
-- Buttons
------------------------------------------------------------

function MusicPlayerMediaLibrary_ButtonsFrame_LoadButtons()
	local button, lastbutton;

	for i = 1,5 do
		button = CreateFrame("Button", "MPML_Button"..i, MusicPlayerMediaLibrary_ButtonsFrame, "MusicPlayer_Button_Template");
		button:SetID(i);

		button:SetWidth(100);
		button:SetHeight(24);

		lastbutton = i-1;

		button:ClearAllPoints();

		if i == 1 then
			button:SetPoint("LEFT", MusicPlayerMediaLibrary_ButtonsFrame, "LEFT",3,0);
		else
			button:SetPoint("LEFT", "MPML_Button"..lastbutton, "RIGHT",3,0);
		end

		button:Show();
		button:SetScript("OnClick", function() MusicPlayerMediaLibrary_ButtonsFrame_ButtonOnClick(i); end);
	end

	button = CreateFrame("Button", "MPML_ButtonSearch", MusicPlayerMediaLibrary_SearchFrame, "MusicPlayer_Button_Template");
	button:SetWidth(70);
	button:SetHeight(24);
	button:ClearAllPoints();
	button:SetPoint("LEFT", MusicPlayerMediaLibrary_SearchFrame, "LEFT",5,0);
	MPML_ButtonSearchText:SetText("Search");
	button:SetScript("OnClick", function()
		if MusicPlayerMediaLibrary_SearchAnchor:IsVisible() then
			MusicPlayerMediaLibrary_SearchAnchor:Hide();
		else
			MusicPlayerMediaLibrary_SearchAnchor:Show();
			MusicPlayerMediaLibrary_UpdateSearchText();
		end
	end);

	button = CreateFrame("Button", "MPML_ButtonClose", MusicPlayerMediaLibrary_SearchFrame, "MusicPlayer_Button_Template");
	button:SetWidth(70);
	button:SetHeight(24);
	button:ClearAllPoints();
	button:SetPoint("RIGHT", MusicPlayerMediaLibrary_SearchFrame, "RIGHT",-5,0);
	MPML_ButtonCloseText:SetText("Close");
	button:SetScript("OnClick", function() this:GetParent():GetParent():Hide(); end);
end

function MusicPlayerMediaLibrary_ButtonsFrame_UpdateButtons()

	for i = 1,5 do
		if i > getn(MPML_Buttons[MPML.Tab]) then
			getglobal("MPML_Button"..i):Hide();
		else
			getglobal("MPML_Button"..i):Show();
			getglobal("MPML_Button"..i.."Text"):SetText(MPML_Buttons[MPML.Tab][i]);
		end
	end
end


------------------------------------------------------------
-- Button functions
------------------------------------------------------------

function MusicPlayerMediaLibrary_ButtonsFrame_ButtonOnClick(ID)
-- teksten til knappen = MPML_Buttons[MPML.Tab][ID];

	local funcArg1 = MPML_Buttons_FuncArgs[MPML.Tab][ID].arg1 or "";
	local funcArg2 = MPML_Buttons_FuncArgs[MPML.Tab][ID].arg2 or "";
	local funcArgs = "";

	if getglobal(funcArg1) then
		funcArg1 = getglobal(funcArg1);
	else
		if funcArg1 == "song" then
			funcArg1 = MPML.RealSelected;

		elseif not getglobal(funcArg1) and type(funcArg1) == "string" and not tonumber(funcArg1) then
			funcArgs = funcArg1;

		elseif funcArg1 == "playlist" then
			funcArg1 = MPML.Playlist;

		elseif funcArg1 == "songtitle" then
			funcArg1 = MusicPlayerSongs[MPML.Selected]["Title"];

		end
	end


	if getglobal(funcArg2) then
		funcArg2 = getglobal(funcArg2);
	else
		if funcArg2 == "playlist" then
			funcArg2 = MPML.Playlist;

		elseif funcArg2 == "song" then
			funcArg2 = MPML.RealSelected;

		elseif funcArg2 == "songtitle" then
			funcArg2 = MusicPlayerSongs[MPML.RealSelected]["Title"];
		end
	end

	if (funcArg1 ~= "" and funcArg2 == "") then
		funcArgs = funcArg1;
		if (type(funcArgs) == "string") then
			funcArgs = '"'..funcArgs..'"';
		end

	elseif (funcArg1 == "" and funcArg2 == "") then
		funcArgs = "";
	else
		funcArgs = funcArg1..", "..funcArg2;
	end

	local funcString = MPML_Buttons_Func[MPML.Tab][ID].."("..funcArgs..")";


	--MPPC("Functionstring: "..funcString);
	RunScript(funcString);
end


------------------------------------------------------------
-- Popup functions
------------------------------------------------------------

function MPML_Popup_LoadListButtons()
	local button, lastbutton;

	for i = 1, 10 do
		button = CreateFrame("Button", "MPML_Popup_List_Button"..i, MPML_Popup_ListFrame, "MPML_Popup_List_Button_Template");

		lastbutton = i-1;

		button:SetID(i);

		button:ClearAllPoints();

		if i == 1 then
			button:SetPoint("TOPLEFT", MPML_Popup_ListFrame_List, "TOPLEFT",0,1);
		else
			button:SetPoint("TOPLEFT", "MPML_Popup_List_Button"..lastbutton, "BOTTOMLEFT");
		end
	end
end

function MPML_Popup_LoadFunctionButtons()
	local button, lastbutton;

	for i = 1,3 do
		button = CreateFrame("Button", "MPML_Popup_FunctionButton"..i, MPML_Popup, "MusicPlayer_Button_Template");
		button:SetID(i);

		button:SetWidth(94);
		button:SetHeight(20);

		lastbutton = i-1;

		button:ClearAllPoints();

		if i == 1 then
			button:SetPoint("BOTTOMLEFT", MPML_Popup, "BOTTOMLEFT",4.5,7);
		else
			button:SetPoint("LEFT", "MPML_Popup_FunctionButton"..lastbutton, "RIGHT",3,0);
		end

		button:Show();
		if i == 3 then
			button:SetScript("OnClick", function() this:GetParent():Hide(); end);
		else
			button:SetScript("OnClick", function() MPML_Popup_FunctionButtons_OnClick(i); end);
		end
	end
end

function MPML_Popup_FunctionButtons_OnClick(ID)
	if MPML.PopupType == "AllTracks" then
		if ID == 1 then
			MusicPlayerMediaLibrary_AddSongToPlaylist("<find song>", "PlaylistName");
		elseif ID == 2 then
			MusicPlayerMediaLibrary_RemoveSongFromPlaylist("<find song>", "PlaylistName");		
		end
	elseif MPML.PopupType == "SavedPlaylists" then
		if ID == 1 then
			MusicPlayerMediaLibrary_SavePlaylist(MPML_Popup_Editbox:GetText());
		elseif ID == 2 then
			-- Del			
		end
	elseif MPML.PopupType == "Favorites" then
		if ID == 1 then
			MusicPlayerMediaLibrary_Favorites_AddSong(MPML.PopupRealSelected);		
		end
	end

	-- Lag en if lkke, er ikke s mye som skal inn her.

	MPML_Popup_SortList();
end

function MPML_Popup_UpdateFunctionButtons()
	for i = 1,3 do
		getglobal("MPML_Popup_FunctionButton"..i.."Text"):SetText(MPML_Popup_FuncButtonTexts[MPML.PopupType][i]);
		getglobal("MPML_Popup_FunctionButton"..i):Show();
		if MPML_Popup_FuncButtonTexts[MPML.PopupType][i] == "" then
			getglobal("MPML_Popup_FunctionButton"..i):Hide();
		end
	end
	MPML_Popup_Text:SetText(MPML_Popup_Texts[MPML.PopupType]);
end

function MPML_Popup_Show(type)
	MPML.PopupType = type;
	MPML_Popup_SortList();
	MPML_Popup_UpdateFunctionButtons();
	MPML_Popup:Show();

end


function MPML_Popup_SortList()
	MPML.PopupTable = {};
	local replaced = nil;
	local titlereplaced = nil;

	if MPML.PopupType == "AllTracks" then
		for k, v in pairs(MusicPlayerSongs) do
			MPML.PopupTable[k] = MusicPlayerSongs[k]["Artist"]..MusicPlayerSongs[k]["Title"].." "..k;
		end

		sort(MPML.PopupTable, function(a,b) return a<b end); -- a first

	elseif MPML.PopupType == "RemainingTracks" then
		for k, v in pairs(MusicPlayerSongs) do
			MPML.PopupTable[k] = MusicPlayerSongs[k]["Artist"]..MusicPlayerSongs[k]["Title"].." "..k;
		end

		sort(MPML.PopupTable, function(a,b) return a<b end); -- a first
	elseif MPML.PopupType == "SavedPlaylists" then
		-- bla bla
	elseif MPML.PopupType == "Favorites" then
		local index = 1;
		for number, table in pairs(MusicPlayerSongs) do

			replaced = MusicPlayerSongs[number]["Artist"];
			replaced = gsub(replaced, "(%d+)", MusicPlayer_SortSongs_fixNumber);

			titlereplaced = MusicPlayerSongs[number]["Title"];
			titlereplaced = gsub(titlereplaced, "(%d+)", MusicPlayer_SortSongs_fixNumber);

			MPML.PopupTable[index] = replaced..titlereplaced.." "..number;


			for _, favnr in pairs(MusicPlayerMediaLibrary_Favorites) do
				if favnr == number then
					MPML.PopupTable[index] = nil;
					-- We want this index to be filled
					index = index - 1;
				end
			end
			index = index + 1;
		end

		sort(MPML.PopupTable, function(a,b) return a<b end); -- a first
		
	end

	MPML.PopupSelected = 1;
	local a, b, _, Number = strfind(MPML.PopupTable[1], "(.+) (%d+)");
	Number = tonumber(Number);
	MPML.PopupRealSelected = Number;
	MPML_Popup_Editbox:SetText(MusicPlayerSongs[Number]["Artist"].." - "..MusicPlayerSongs[Number]["Title"]);

	MPML_Popup_PopulateList();
end


function MPML_Popup_PopulateList()
	local indexnr;
	local a, b, _, Number;
	local count = getn(MPML.PopupTable);

	FauxScrollFrame_Update(MPML_Popup_ListFrame_List, count, 10, 10);
	for button = 1,10 do
		indexnr = button + FauxScrollFrame_GetOffset(MPML_Popup_ListFrame_List);

		if (indexnr <= count) then
			a, b, _, Number = strfind(MPML.PopupTable[indexnr], "(.+) (%d+)");

			Number = tonumber(Number);

			getglobal("MPML_Popup_List_Button"..button.."_Text"):SetText(MusicPlayerSongs[Number]["Artist"].." - "..MusicPlayerSongs[Number]["Title"]);

			if indexnr == MPML.PopupSelected  then
				getglobal("MPML_Popup_List_Button"..button):SetBackdropColor(MPML_Colors["Tabs"]["Selected"].r, MPML_Colors["Tabs"]["Selected"].g, MPML_Colors["Tabs"]["Selected"].b);
			else
				getglobal("MPML_Popup_List_Button"..button):SetBackdropColor(MPML_Colors["BG"]["Box"].r, MPML_Colors["BG"]["Box"].g, MPML_Colors["BG"]["Box"].b);
			end
			getglobal("MPML_Popup_List_Button"..button):Show();
		else
			getglobal("MPML_Popup_List_Button"..button):Hide();
		end
	end
end


function MPML_Popup_SelectListEntry(ID)
	MPML.PopupSelected = ID + FauxScrollFrame_GetOffset(MPML_Popup_ListFrame_List);

	local a, b, _, Number = strfind(MPML.PopupTable[MPML.PopupSelected], "(.+) (%d+)");

	Number = tonumber(Number);

	MPML.PopupRealSelected = Number;

	MPML_Popup_Editbox:SetText(MusicPlayerSongs[Number]["Artist"].." - "..MusicPlayerSongs[Number]["Title"]);
	MPML_Popup_PopulateList();
end

------------------------------------------------------------
-- Playlist functions
------------------------------------------------------------


function MusicPlayerMediaLibrary_LoadPlaylists()
	if not MusicPlayerMediaLibrary_Playlists then

		MusicPlayerMediaLibrary_Playlists = {};
		MusicPlayerMediaLibrary_Playlists["AllTracks"] = MPML.SortedList;
	end
end

function MusicPlayerMediaLibrary_SavePlaylist(name)
	MPPC("Creating Playlist named: "..name);
end

function MusicPlayerMediaLibrary_AddSongToPlaylist(song, playlist)
	MPPC("Adding "..song.." to "..playlist);
end

function MusicPlayerMediaLibrary_RemoveSongFromPlaylist(song, playlist)
	MPPC("Removing "..song.." from "..playlist);
end

function MusicPlayerMediaLibrary_PlaylistGetNumSongs(playlist)
	return getn(MusicPlayerMediaLibrary_Playlists[Playlist])
end


------------------------------------------------------------
-- Rating functions
------------------------------------------------------------

function MusicPlayerMediaLibrary_LoadRatings()
	if not MusicPlayerMediaLibrary_Ratings then
		MusicPlayerMediaLibrary_Ratings = {};
	end
end

function MusicPlayerMediaLibrary_EditRating(song)
	MPPC("Editing rating for "..MusicPlayerSongs[song]["Title"]);
end

function MusicPlayerMediaLibrary_PlayBestRatedSong()
	MPPC("Best rated song is playing... or something");
end


------------------------------------------------------------
-- Favorite functions
------------------------------------------------------------

function MusicPlayerMediaLibrary_Favorites_GetNumFavorites()
	return getn(MusicPlayerMediaLibrary_Favorites);
end

function MusicPlayerMediaLibrary_Favorites_AddSong(nr)
	for artist, artisttable in pairs(MusicPlayer_Favorites) do
		for artistsongindex, song in pairs(artisttable) do
			for number, table in pairs(MusicPlayerSongs) do
				if (table["Artist"] == artist) and (table["Title"] == song) and (nr == number) then
					if MusicPlayerMediaLibrary:IsVisible() then
						MusicPlayerMediaLibrary_AddMessage(format(MusicPlayer_SongAdded, MusicPlayerSongs[k]["Title"]));
					else
						MPPC(MP_Yellow..format(MusicPlayer_SongIsAFavorite, MusicPlayer_CreateChatLink(MusicPlayerSongs[k]["Title"])), 1);
					end
					return;
				end
			end
		end
	end

	if (not MusicPlayer_Favorites[MusicPlayerSongs[nr]["Artist"]]) then
		MusicPlayer_Favorites[MusicPlayerSongs[nr]["Artist"]] = {};
	end
	tinsert(MusicPlayer_Favorites[MusicPlayerSongs[nr]["Artist"]], MusicPlayerSongs[nr]["Title"]);

	MusicPlayerMediaLibrary_Favorites_LoadCurrentFavorites();
	MusicPlayerMediaLibrary_SortButton_SortBy();
	MusicPlayerPlaylistUpdate();

	if MusicPlayerMediaLibrary:IsVisible() then
		MusicPlayerMediaLibrary_AddMessage(format(MusicPlayer_SongAdded, MusicPlayerSongs[nr]["Title"]));
	else
		MPPC(MP_Yellow..format(MusicPlayer_SongAdded, MusicPlayer_CreateChatLink(MusicPlayerSongs[nr]["Title"])), 1);
	end
end

function MusicPlayerMediaLibrary_Favorites_RemoveSong(nr)
	if (nr == 0 or nr == nil) then
		return;
	end

	for number, table in pairs(MusicPlayerSongs) do
		for artist, artisttable in pairs(MusicPlayer_Favorites) do
			for artistsongindex, song in pairs(artisttable) do
				if (table["Artist"] == artist) and (table["Title"] == song) and (nr == number) then
					tremove(MusicPlayer_Favorites[artist], artistsongindex);
					if getn(artisttable) == 0 then
						MusicPlayer_Favorites[artist] = nil;
					end
				end
			end
		end
	end

	MusicPlayerMediaLibrary_Favorites_LoadCurrentFavorites();
	MusicPlayerMediaLibrary_SortButton_SortBy();
	if MPML_Popup:IsVisible() and MPML.PopupType == "Favorites" then
		MPML_Popup_SortList();
	end
	MusicPlayerPlaylistUpdate();

	if MusicPlayerMediaLibrary:IsVisible() then
		MusicPlayerMediaLibrary_AddMessage(format(MusicPlayer_SongRemoved, MusicPlayerSongs[nr]["Title"]));
	else
		MPPC(MP_Yellow..format(MusicPlayer_SongRemoved, MusicPlayer_CreateChatLink(MusicPlayerSongs[nr]["Title"])), 1);
	end
end

function MusicPlayerMediaLibrary_Favorites_AddRemoveSong(nr)
	for artist, artisttable in pairs(MusicPlayer_Favorites) do
		for artistsongindex, song in pairs(artisttable) do
			for number, table in pairs(MusicPlayerSongs) do
				if (table["Artist"] == artist) and (table["Title"] == song) and (nr == number) then
					MusicPlayerMediaLibrary_Favorites_RemoveSong(nr);
					return;
				end
			end
		end
	end
	MusicPlayerMediaLibrary_Favorites_AddSong(nr);
end


function MusicPlayerMediaLibrary_Favorites_LoadCurrentFavorites()

	if (MusicPlayer_Favorites) then
		MusicPlayerMediaLibrary_Favorites = {};

		-- Find favorite's title and make sure they're loaded ingame before adding them to the table
		for number, table in pairs(MusicPlayerSongs) do
			for artist, artisttable in pairs(MusicPlayer_Favorites) do
				for artistsongindex, song in pairs(artisttable) do
					if (song == MusicPlayerSongs[number]["Title"]) and (artist == MusicPlayerSongs[number]["Artist"]) then
						MusicPlayerMediaLibrary_Favorites[getn(MusicPlayerMediaLibrary_Favorites)+1] = number;
					end
				end
			end
		end
	end
end

------------------------------------------------------------
-- Enqueue functions
------------------------------------------------------------

function MusicPlayerMediaLibrary_Enqueue_PlayEnqueued()
	local num = getn(MusicPlayer_EnqueueTable);

	if (num >= 1) then
		MusicPlayer_PlayingEnqueued = 1;
		MusicPlayer_PlaySong(MusicPlayer_EnqueueTable[1]);
		tremove(MusicPlayer_EnqueueTable, 1);
		MusicPlayerPlaylistUpdate();
	else
		MusicPlayer_PlayingEnqueued = 0;


		if MusicPlayerMediaLibrary:IsVisible() then
			MusicPlayerMediaLibrary_AddMessage(MusicPlayer_Enqueue_Empty);
		else
			MPPC(MP_Yellow..MusicPlayer_Enqueue_Empty, 1);
		end

		MP_SongIsPlaying = 0;
		SetCVar("Sound_EnableMusic", MusicPlayerFrameOptions.MusicAfterStop);

		MusicPlayer_SongTime_START = 0;
		MusicPlayer_SongTime_END = 0;

		MusicPlayer_StartStopUpdate("stop");
	end
	MusicPlayerMediaLibrary_SortButton_SortBy();
end


function MusicPlayerMediaLibrary_Enqueue_Enqueue(song)

	if not song then
		song = MPML.RealSelected;
	end

	for k, v in pairs(MusicPlayer_EnqueueTable) do
		if (v == song) then
			tremove(MusicPlayer_EnqueueTable, k);

			if MusicPlayerMediaLibrary:IsVisible() then
				MusicPlayerMediaLibrary_AddMessage(format(MusicPlayer_Enqueue_Add, MusicPlayerSongs[song]["Title"]));
			else
				MPPC(MP_Yellow..format(MusicPlayer_Enqueue_Remove, MusicPlayer_CreateChatLink(MusicPlayerSongs[v]["Title"])), 1);
			end

			MusicPlayerPlaylistUpdate();
			MusicPlayerMediaLibrary_SortButton_SortBy();
			return;
		end
	end

	tinsert(MusicPlayer_EnqueueTable, song);


	if MusicPlayerMediaLibrary:IsVisible() then
		MusicPlayerMediaLibrary_AddMessage(format(MusicPlayer_Enqueue_Add, MusicPlayerSongs[song]["Title"]));
	else
		MPPC(MP_Yellow..format(MusicPlayer_Enqueue_Add, MusicPlayer_CreateChatLink(MusicPlayerSongs[song]["Title"])), 1);
	end



	MusicPlayerPlaylistUpdate();
	MusicPlayerMediaLibrary_SortButton_SortBy();
end


function MusicPlayerMediaLibrary_Enqueue_UnqueueAll()
	MusicPlayer_EnqueueTable = {};
	MusicPlayerMediaLibrary_SortButton_SortBy();
	MusicPlayerPlaylistUpdate();
end

------------------------------------------------------------
-- Tables
------------------------------------------------------------

MPML_Tabs = {
	[1] = MPML_Locale_Tabs_Names_1,
	[2] = MPML_Locale_Tabs_Names_2,
	[3] = MPML_Locale_Tabs_Names_3,
	[4] = MPML_Locale_Tabs_Names_4,
	[5] = MPML_Locale_Tabs_Names_5,
};

MPML_SortButtons = {
	[1] = {
		[1] = MPML_Locale_Sort_Names_Title,
		[2] = MPML_Locale_Sort_Names_Artist,
		[3] = MPML_Locale_Sort_Names_Genre,
		[4] = MPML_Locale_Sort_Names_InQueue,
	},

	[2] = {
		[1] = MPML_Locale_Sort_Names_Title,
		[2] = MPML_Locale_Sort_Names_Artist,
		[3] = MPML_Locale_Sort_Names_Genre,
		[4] = MPML_Locale_Sort_Names_InQueue,
	},
	[3] = {
		[1] = MPML_Locale_Sort_Names_Title,
		[2] = MPML_Locale_Sort_Names_Artist,
		[3] = MPML_Locale_Sort_Names_Genre,
		[4] = MPML_Locale_Sort_Names_InQueue,
	},
	[4] = {
		[1] = MPML_Locale_Sort_Names_Title,
		[2] = MPML_Locale_Sort_Names_Artist,
		[3] = MPML_Locale_Sort_Names_Genre,
		[4] = MPML_Locale_Sort_Names_InQueue,
	},
	[5] = {
		[1] = MPML_Locale_Sort_Names_Title,
		[2] = MPML_Locale_Sort_Names_Artist,
		[3] = MPML_Locale_Sort_Names_Genre,
		[4] = MPML_Locale_Sort_Names_Rated,
	},
};

MPML_SortButtonRowWidth = {
	[1] = 670/4+32.5,
	[2] = 670/4+20,
	[3] = 670/4-10,
	[4] = 670/4-42.5,
};
MPML_Buttons = {
	[1] = { MPML_Locale_Buttons_1_1,MPML_Locale_Buttons_1_2,MPML_Locale_Buttons_1_3 },			 -- All Tracks
	[2] = { MPML_Locale_Buttons_2_1,MPML_Locale_Buttons_2_2,MPML_Locale_Buttons_2_3},			 -- Favorites
	[3] = { MPML_Locale_Buttons_3_1,MPML_Locale_Buttons_3_2,MPML_Locale_Buttons_3_3},			 -- Enqueue
	[4] = { MPML_Locale_Buttons_4_1,MPML_Locale_Buttons_4_2,MPML_Locale_Buttons_4_3, MPML_Locale_Buttons_4_4, MPML_Locale_Buttons_4_5},-- Playlists	
	[5] = { MPML_Locale_Buttons_5_1,MPML_Locale_Buttons_5_2,MPML_Locale_Buttons_5_3 },			 -- Ratings
};

MPML_Popup_FuncButtonTexts = {
	["AllTracks"] = {
		[1] = "Add",
		[2] = "",
		[3] = "Close",
	},
	["RemainingTracks"] = {
		[1] = "Add",
		[2] = "",
		[3] = "Close",
	},
	["SavedPlaylists"] = {
		[1] = "Save",
		[2] = "Delete",
		[3] = "Close",
	},
	["Favorites"] = {
		[1] = "Add",
		[2] = "",
		[3] = "Close",
	},
};

MPML_Popup_Texts = {
	["AllTracks"] = "Add song",
	["RemainingTracks"] = "Add song:",
	["SavedPlaylists"] = "Save as:",
	["Favorites"] = "Add Favorite",
};

MPML_Buttons_Func = {
	[1] = {
		[1] = "MusicPlayer_PlaySong",
		[2] = "MusicPlayerMediaLibrary_Enqueue_Enqueue",
		[3] = "MusicPlayerMediaLibrary_Favorites_AddRemoveSong",
	},
	[2] = {
		[1] = "MusicPlayer_PlaySong",
		[2] = "MPML_Popup_Show",
		[3] = "MusicPlayerMediaLibrary_Favorites_RemoveSong",
	},
	[3] = {
		[1] = "MusicPlayerMediaLibrary_Enqueue_PlayEnqueued",
		[2] = "MusicPlayerMediaLibrary_Enqueue_Enqueue", 
		[3] = "StaticPopup_Show",
	},
	[4] = {
		[1] = "",
		[2] = "",
		[3] = "",
		[4] = "",
		[5] = "",
	},
	[5] = {
		[1] = "MusicPlayerMediaLibrary_EditRating",
		[2] = "MusicPlayer_PlaySong",
		[3] = "MusicPlayerMediaLibrary_PlayBestRatedSong", 
	},
};

MPML_Buttons_FuncArgs = {

	[1] = {
		[1] = { arg1 = "song" },
		[2] = { arg1 = "song" }, 
		[3] = { arg1 = "song" },
	},
	[2] = {
		[1] = { arg1 = "song" },
		[2] = { arg1 = "Favorites" },
		[3] = { arg1 = "song" },
	},
	[3] = {
		[1] = { },
		[2] = { arg1 = "song" },
		[3] = { arg1 = "MPML_ENQUEUE_REMALL" },
	},
	[4] = {
		[1] = { arg1 = "MPML_Popup_Show" },
		[2] = { arg1 = "MPML_Popup_Show" },
		[3] = { arg1 = "MPML_Popup_Show" },
		[4] = { arg1 = "MPML_Popup_Show" },
		[5] = { arg1 = "MPML_Popup_Show" },
	},
	[5] = {
		[1] = { arg1 = "song" },
		[2] = { arg1 = "song" },
		[2] = { },
		
	},
};

MPML_Colors = {
	["BG"] = {
		["Main"] = { r=0, g=0, b=0 },
		["Box"] = { r=0.035, g=0.035, b=0.035 },
		["Border"] = { r=0.356, g=0.356, b=0.356 },
		["Selected"] = { 0.3, g=0, b=0 },
	},
	["Tabs"] = {
		["Selected"] = { r=0.3, g=0, b=0 }, -- BG
		["MouseOver"] = { r=0.356, g=0.356, b=0.356 }, -- Text
	},
};