
function MusicPlayerOptionsFrame_OnLoad()
	this:RegisterEvent("ADDON_LOADED");
	this:SetClampedToScreen(1);
	tinsert(UISpecialFrames, "MusicPlayerOptionsFrame");

	this.fadingframe = "MusicPlayerOptionsFrame_PlayerVisualsFrame";

	MusicPlayerOptionsFrame_PlaylistFormattingFrame:SetAlpha(0);
	MusicPlayerOptionsFrame_PlaylistFormattingFrame:Hide();
end


-- OnEvent event
function MusicPlayerOptionsFrame_OnEvent(event)

	-- Check the current event
	if (event == "ADDON_LOADED" and arg1 == "MusicPlayer") then
		-- Initialize the options frame
		MusicPlayerOptionsFrame_Initialize();
	end

end

-- OnShow event
function MusicPlayerOptionsFrame_OnShow()
	if (MusicPlayerFrameOptions.showFrame == 1) then
		this:SetHeight(480);

		getglobal(this.fadingframe):SetAlpha(1);
		getglobal(this.fadingframe):Show();
	else
		this:SetHeight(280);

		MusicPlayerOptionsFrame_PlaylistFormattingFrame:SetAlpha(0);
		MusicPlayerOptionsFrame_PlaylistFormattingFrame:Hide();

		MusicPlayerOptionsFrame_PlayerVisualsFrame:SetAlpha(0);
		MusicPlayerOptionsFrame_PlayerVisualsFrame:Hide();
	end
end

-- OnHide event
function MusicPlayerOptionsFrame_OnHide()
	this:SetScript("OnUpdate", nil);
end


-- Checkbuttons OnClick
function MusicPlayerOptionsCheckButton_OnClick()

	-- Check if the checkbutton is checked or not
	if (this:GetChecked()) then
		PlaySound("igMainMenuOptionCheckBoxOff");
	else
		PlaySound("igMainMenuOptionCheckBoxOn");
	end
	
	-- Get the ID of the checkbutton
	local checkButtonID = this:GetID();
		
	-- Check which checkbutton was clicked
	if (checkButtonID == 1) then
		MusicPlayerFrameOptions.showFrame = this:GetChecked();

		MusicPlayerOptionsFrame.resize = 1;

		if this:GetChecked() then
			MusicPlayerOptionsFrame:SetScript("OnUpdate", MusicPlayer_OptionsFrame_resize_Show);
		else
			MusicPlayerOptionsFrame:SetScript("OnUpdate", MusicPlayer_OptionsFrame_resize_Hide);
		end

	elseif (checkButtonID == 2) then
		MusicPlayerFrameOptions.lock = this:GetChecked() or 0;
	elseif (checkButtonID == 3) then
		MusicPlayerFrameOptions.ShowSpam = this:GetChecked() or 0;
	elseif (checkButtonID == 4) then
		MusicPlayerFrameOptions.PlayWhenFinished = this:GetChecked() or 0;
	elseif (checkButtonID == 5) then
		MusicPlayerFrameOptions.StatusBar = this:GetChecked() or 0;
	elseif (checkButtonID == 6) then
		MusicPlayerFrameOptions.MinimapButton = this:GetChecked() or 0;
	elseif (checkButtonID == 7) then
		MusicPlayerFrameOptions.playlistformatting["Indexnumber"] = this:GetChecked() or 0;
	elseif (checkButtonID == 8) then
		MusicPlayerFrameOptions.playlistformatting["Duration"] = this:GetChecked() or 0;
	elseif (checkButtonID == 9) then
		MusicPlayerFrameOptions.playlistformatting["Favoritemark"] = this:GetChecked() or 0;
	elseif (checkButtonID == 10) then
		MusicPlayerFrameOptions.playlistformatting["Queuenumber"] = this:GetChecked() or 0;
	elseif (checkButtonID == 11) then
		MusicPlayerFrameOptions.MusicAfterStop = this:GetChecked() or 0;
	elseif (checkButtonID == 12) then
		MusicPlayerFrameOptions.playertooltip = this:GetChecked() or 0;
	end


	-- Update the display
	MusicPlayerFrame_Update_Checkbuttons();
	MusicPlayerPlaylistUpdate();

end

function MusicPlayerOptionsFrame_ResetOptionsButton_OnClick()
	StaticPopup_Show("MUSICPLAYER_RESETOPTIONS");

end

function MusicPlayerOptionsFrame_PlayerVisualsFrame_PlaylistAnchor_DropDown_OnClick()

	-- Save the selected option
	UIDropDownMenu_SetSelectedValue(MusicPlayerOptionsFrame_PlayerVisualsFrame_PlaylistAnchor_DropDown, this.value);
	MusicPlayerFrameOptions.PlaylistLoc = this.value;

	MusicPlayerFrame_UpdateAnchors();

end

function MusicPlayerOptionsFrame_GeneralSettingsFrame_FinishedDropDown_OnClick()

	-- Save the selected option
	UIDropDownMenu_SetSelectedValue(MusicPlayerOptionsFrame_GeneralSettingsFrame_FinishedDropDown, this.value);
	MusicPlayerFrameOptions.WhenFinished = this.value;
end


function MusicPlayerOptionsFrame_PlayerVisualsFrame_FrameStrata_DropDown_OnClick()

	-- Save the selected option
	UIDropDownMenu_SetSelectedValue(MusicPlayerOptionsFrame_PlayerVisualsFrame_FrameStrata_DropDown, this.value);
	MusicPlayerFrameOptions.PlayerFrameStrata = this.value;

	MusicPlayerFrame_UpdateStrata();
end

function MusicPlayerOptionsFrame_PlaylistFormattingFrame_Text1_DropDown_OnClick()

	-- Save the selected option
	UIDropDownMenu_SetSelectedValue(MusicPlayerOptionsFrame_PlaylistFormattingFrame_Text1_DropDown, this.value);
	MusicPlayerFrameOptions.playlistformatting[1] = this.value;

	MusicPlayer_SortSongs();
	MusicPlayerPlaylistUpdate();
end

function MusicPlayerOptionsFrame_PlaylistFormattingFrame_Text2_DropDown_OnClick()

	-- Save the selected option
	UIDropDownMenu_SetSelectedValue(MusicPlayerOptionsFrame_PlaylistFormattingFrame_Text2_DropDown, this.value);
	MusicPlayerFrameOptions.playlistformatting[2] = this.value;

	MusicPlayerPlaylistUpdate();
end

function MusicPlayerOptionsFrame_PlaylistFormattingFrame_Text3_DropDown_OnClick()

	-- Save the selected option
	UIDropDownMenu_SetSelectedValue(MusicPlayerOptionsFrame_PlaylistFormattingFrame_Text3_DropDown, this.value);
	MusicPlayerFrameOptions.playlistformatting[3] = this.value;

	MusicPlayerPlaylistUpdate();
end


--------------------------------------------------------------------------------------------------
-- Initialize functions
--------------------------------------------------------------------------------------------------

-- Initialize the options frame
function MusicPlayerOptionsFrame_Initialize()
	MusicPlayerOptionsFrame_HeaderBox_Text:SetText(MUSICPLAYER_OPTIONS_TITLE);
	MusicPlayerOptionsFrame_GeneralSettingsFrame_HeaderText:SetText(MUSICPLAYER_OPTIONS_HEADER1);
	MusicPlayerOptionsFrame_PlayerSettingsFrame_HeaderText:SetText(MUSICPLAYER_OPTIONS_HEADER2);
	MusicPlayerOptionsFrame_PlayerVisualsFrame_HeaderText:SetText(MUSICPLAYER_OPTIONS_HEADER3);
	MusicPlayerOptionsFrame_PlaylistFormattingFrame_HeaderText:SetText(MUSICPLAYER_OPTIONS_HEADER4);


	-- Initialize the option checkbuttons
	MusicPlayerOptionsFrame_PlayerSettingsFrame_ShowPlayer_CheckButtonText:SetText(MUSICPLAYER_OPTIONS_SHOW_FRAME);
	MusicPlayerOptionsFrame_PlayerSettingsFrame_LockPlayer_CheckButtonText:SetText(MUSICPLAYER_OPTIONS_LOCK);
	MusicPlayerOptionsFrame_PlayerSettingsFrame_ShowTimerBar_CheckButtonText:SetText(MUSICPLAYER_OPTIONS_STATUSBAR);
	MusicPlayerOptionsFrame_PlayerSettingsFrame_ShowSongTooltip_CheckButtonText:SetText(MUSICPLAYER_OPTIONS_SHOWPLAYERTOOLTIP);

	MusicPlayerOptionsFrame_GeneralSettingsFrame_FinishedCheckButtonText:SetText(MUSICPLAYER_OPTIONS_FINISHED_PLAYNEW);
	MusicPlayerOptionsFrame_GeneralSettingsFrame_MusicAfterStop_CheckButtonText:SetText(MUSICPLAYER_OPTIONS_ENABLEMUSICAFTERSTOP);
	MusicPlayerOptionsFrame_GeneralSettingsFrame_ShowSpam_CheckButtonText:SetText(MUSICPLAYER_OPTIONS_SHOWSPAM);
	MusicPlayerOptionsFrame_GeneralSettingsFrame_ShowMinimapButton_CheckButtonText:SetText(MUSICPLAYER_OPTIONS_MINIMAPBUTTON);

	MusicPlayerOptionsFrame_PlayerVisualsFrame_ColorSelect_Text_ButtonText:SetText(MUSICPLAYER_TEXT_ColorButton_Text);
	MusicPlayerOptionsFrame_PlayerVisualsFrame_ColorSelect_BG_ButtonText:SetText(MUSICPLAYER_TEXT_ColorButton_BG);
	MusicPlayerOptionsFrame_PlayerVisualsFrame_ColorSelect_Borders_ButtonText:SetText(MUSICPLAYER_TEXT_ColorButton_Borders);
	MusicPlayerOptionsFrame_PlayerVisualsFrame_ColorSelect_Bars_ButtonText:SetText(MUSICPLAYER_TEXT_ColorButton_Bars);

	MusicPlayerOptionsFrame_PlaylistFormattingFrame_Indexnumber_CheckButtonText:SetText(MusicPlayer_Indexnr_CheckbtnText);
	MusicPlayerOptionsFrame_PlaylistFormattingFrame_Duration_CheckButtonText:SetText(MusicPlayer_Duration_CheckbtnText);
	MusicPlayerOptionsFrame_PlaylistFormattingFrame_Favoritemark_CheckButtonText:SetText(MusicPlayer_Favorites_CheckbtnText);
	MusicPlayerOptionsFrame_PlaylistFormattingFrame_Queuenumber_CheckButtonText:SetText(MusicPlayer_Enqueue_CheckbtnText);
	

	-- Initialize the Help button
	if (MusicPlayerFrameOptions.DisplayHelp == 1) then
		MusicPlayerOptionsFrame_Help_ButtonText:SetText(MUSICPLAYER_HELP..": "..MusicPlayer_On);
	else
		MusicPlayerOptionsFrame_Help_ButtonText:SetText(MUSICPLAYER_HELP..": "..MusicPlayer_Off);
	end


	-- Initialize the options dropdown menus
	UIDropDownMenu_Initialize(MusicPlayerOptionsFrame_PlayerVisualsFrame_PlaylistAnchor_DropDown, MusicPlayerOptionsFrame_PlayerVisualsFrame_PlaylistAnchor_DropDown_Initialize);
	UIDropDownMenu_SetWidth(100, MusicPlayerOptionsFrame_PlayerVisualsFrame_PlaylistAnchor_DropDown);

	UIDropDownMenu_Initialize(MusicPlayerOptionsFrame_GeneralSettingsFrame_FinishedDropDown, MusicPlayerOptionsFrame_GeneralSettingsFrame_FinishedDropDown_Initialize);
	UIDropDownMenu_SetWidth(80, MusicPlayerOptionsFrame_GeneralSettingsFrame_FinishedDropDown);

	UIDropDownMenu_Initialize(MusicPlayerOptionsFrame_PlayerVisualsFrame_FrameStrata_DropDown, MusicPlayerOptionsFrame_PlayerVisualsFrame_FrameStrata_DropDown_Initialize);
	UIDropDownMenu_SetWidth(100, MusicPlayerOptionsFrame_PlayerVisualsFrame_FrameStrata_DropDown);

	UIDropDownMenu_Initialize(MusicPlayerOptionsFrame_PlaylistFormattingFrame_Text1_DropDown, MusicPlayerOptionsFrame_PlaylistFormattingFrame_Text1_DropDown_Initialize);
	UIDropDownMenu_SetWidth(70, MusicPlayerOptionsFrame_PlaylistFormattingFrame_Text1_DropDown);

	UIDropDownMenu_Initialize(MusicPlayerOptionsFrame_PlaylistFormattingFrame_Text2_DropDown, MusicPlayerOptionsFrame_PlaylistFormattingFrame_Text2_DropDown_Initialize);
	UIDropDownMenu_SetWidth(70, MusicPlayerOptionsFrame_PlaylistFormattingFrame_Text2_DropDown);

	UIDropDownMenu_Initialize(MusicPlayerOptionsFrame_PlaylistFormattingFrame_Text3_DropDown, MusicPlayerOptionsFrame_PlaylistFormattingFrame_Text3_DropDown_Initialize);
	UIDropDownMenu_SetWidth(70, MusicPlayerOptionsFrame_PlaylistFormattingFrame_Text3_DropDown);


	local playlistanchor = {
		[1] = MUSICPLAYER_ABOVE,
		[2] = MUSICPLAYER_BELOW,
		[3] = MUSICPLAYER_LEFT,
		[4] = MUSICPLAYER_TOPLEFT,
		[5] = MUSICPLAYER_BOTTOMLEFT,
		[6] = MUSICPLAYER_RIGHT,
		[7] = MUSICPLAYER_TOPRIGHT,
		[8] = MUSICPLAYER_BOTTOMRIGHT,
	};

	MUSICPLAYER_DROPDOWNTEXT = playlistanchor[MusicPlayerFrameOptions.PlaylistLoc];
	playlistanchor = nil

	local finished = {
		[11] = MUSICPLAYER_PLAYNEXT,
		[12] = MUSICPLAYER_RANDOM,
		[13] = MUSICPLAYER_LOOP,
	};

	MUSICPLAYER_DROPDOWNTEXT3 = finished[MusicPlayerFrameOptions.WhenFinished];
	finished = nil

	local strata = {
		[1] = MUSICPLAYER_TEXT_LOW,
		[2] = MUSICPLAYER_TEXT_MEDIUM,
		[3] = MUSICPLAYER_TEXT_HIGH,
	};

	MusicPlayer_PlayerFrame:SetFrameStrata(strata[MusicPlayerFrameOptions.PlayerFrameStrata]);
	MUSICPLAYER_DROPDOWNTEXT4 = strata[MusicPlayerFrameOptions.PlayerFrameStrata];
	strata = nil	


	UIDropDownMenu_SetText(MUSICPLAYER_DROPDOWNTEXT, MusicPlayerOptionsFrame_PlayerVisualsFrame_PlaylistAnchor_DropDown);
	UIDropDownMenu_SetText(MUSICPLAYER_DROPDOWNTEXT3, MusicPlayerOptionsFrame_GeneralSettingsFrame_FinishedDropDown);
	UIDropDownMenu_SetText(MUSICPLAYER_DROPDOWNTEXT4, MusicPlayerOptionsFrame_PlayerVisualsFrame_FrameStrata_DropDown);

	-- PlaylistFormatting dropdowns

	local playlistformatting = {
		[1] = MusicPlayer_Title;
		[2] = MusicPlayer_Album;
		[3] = MusicPlayer_Artist;
		[4] = MusicPlayer_Genre;
		[5] = MusicPlayer_Quality;
		[6] = MusicPlayer_Nothing;
	};


	UIDropDownMenu_SetText(playlistformatting[MusicPlayerFrameOptions.playlistformatting[1]], MusicPlayerOptionsFrame_PlaylistFormattingFrame_Text1_DropDown);
	UIDropDownMenu_SetText(playlistformatting[MusicPlayerFrameOptions.playlistformatting[2]], MusicPlayerOptionsFrame_PlaylistFormattingFrame_Text2_DropDown);
	UIDropDownMenu_SetText(playlistformatting[MusicPlayerFrameOptions.playlistformatting[3]], MusicPlayerOptionsFrame_PlaylistFormattingFrame_Text3_DropDown);

	playlistformatting = nil;


	-- Colorize !

	this:SetBackdropColor(0,0,0);
	this:SetBackdropBorderColor(0.356, 0.356, 0.356);

	MusicPlayerOptionsFrame_GeneralSettingsFrame_FinishedDropDownText:SetTextColor(1,0,0);

	MusicPlayerOptionsFrame_PlayerSettingsFrame_PlaylistButtons_SliderText:SetTextColor(1,0,0);
	MusicPlayerOptionsFrame_PlayerSettingsFrame_PlaylistButtons_SliderHigh:SetTextColor(1,0,0);
	MusicPlayerOptionsFrame_PlayerSettingsFrame_PlaylistButtons_SliderLow:SetTextColor(1,0,0);
	MusicPlayerOptionsFrame_PlayerSettingsFrame_PlaylistButtons_Slider_EditBoxBG:SetBackdropColor(0, 0, 0);
	MusicPlayerOptionsFrame_PlayerSettingsFrame_PlaylistButtons_Slider_EditBoxBG:SetBackdropBorderColor(0.356, 0.356, 0.356);
	MusicPlayerOptionsFrame_PlayerSettingsFrame_PlaylistButtons_Slider_EditBoxBG_EditBox:SetTextColor(1,0,0);

	MusicPlayerOptionsFrame_PlayerVisualsFrame_ColorSelect_Text_ButtonText:SetTextColor(1,0,0);
	MusicPlayerOptionsFrame_PlayerVisualsFrame_ColorSelect_BG_ButtonText:SetTextColor(1,0,0);
	MusicPlayerOptionsFrame_PlayerVisualsFrame_ColorSelect_Borders_ButtonText:SetTextColor(1,0,0);
	MusicPlayerOptionsFrame_PlayerVisualsFrame_ColorSelect_Bars_ButtonText:SetTextColor(1,0,0);

	MusicPlayerOptionsFrame_PlayerVisualsFrame_Alpha_SliderText:SetTextColor(1,0,0);
	MusicPlayerOptionsFrame_PlayerVisualsFrame_Alpha_SliderHigh:SetTextColor(1,0,0);
	MusicPlayerOptionsFrame_PlayerVisualsFrame_Alpha_SliderLow:SetTextColor(1,0,0);
	MusicPlayerOptionsFrame_PlayerVisualsFrame_Alpha_Slider_EditBoxBG:SetBackdropColor(0, 0, 0);
	MusicPlayerOptionsFrame_PlayerVisualsFrame_Alpha_Slider_EditBoxBG:SetBackdropBorderColor(0.356, 0.356, 0.356);
	MusicPlayerOptionsFrame_PlayerVisualsFrame_Alpha_Slider_EditBoxBG_EditBox:SetTextColor(1,0,0);

	MusicPlayerOptionsFrame_PlayerVisualsFrame_Scale_SliderText:SetTextColor(1,0,0);
	MusicPlayerOptionsFrame_PlayerVisualsFrame_Scale_SliderHigh:SetTextColor(1,0,0);
	MusicPlayerOptionsFrame_PlayerVisualsFrame_Scale_SliderLow:SetTextColor(1,0,0);
	MusicPlayerOptionsFrame_PlayerVisualsFrame_Scale_Slider_EditBoxBG:SetBackdropColor(0, 0, 0);
	MusicPlayerOptionsFrame_PlayerVisualsFrame_Scale_Slider_EditBoxBG:SetBackdropBorderColor(0.356, 0.356, 0.356);
	MusicPlayerOptionsFrame_PlayerVisualsFrame_Scale_Slider_EditBoxBG_EditBox:SetTextColor(1,0,0);

	MusicPlayerOptionsFrame_PlayerVisualsFrame_PlaylistWidth_SliderText:SetTextColor(1,0,0);
	MusicPlayerOptionsFrame_PlayerVisualsFrame_PlaylistWidth_SliderHigh:SetTextColor(1,0,0);
	MusicPlayerOptionsFrame_PlayerVisualsFrame_PlaylistWidth_SliderLow:SetTextColor(1,0,0);
	MusicPlayerOptionsFrame_PlayerVisualsFrame_PlaylistWidth_Slider_EditBoxBG:SetBackdropColor(0, 0, 0);
	MusicPlayerOptionsFrame_PlayerVisualsFrame_PlaylistWidth_Slider_EditBoxBG:SetBackdropBorderColor(0.356, 0.356, 0.356);
	MusicPlayerOptionsFrame_PlayerVisualsFrame_PlaylistWidth_Slider_EditBoxBG_EditBox:SetTextColor(1,0,0);

	MusicPlayerOptionsFrame_PlayerVisualsFrame_FrameStrata_DropDownLabel:SetTextColor(1,0,0);
	MusicPlayerOptionsFrame_PlayerVisualsFrame_FrameStrata_DropDownText:SetTextColor(1,0,0);
	MusicPlayerOptionsFrame_PlayerVisualsFrame_PlaylistAnchor_DropDownLabel:SetTextColor(1,0,0);
	MusicPlayerOptionsFrame_PlayerVisualsFrame_PlaylistAnchor_DropDownText:SetTextColor(1,0,0);

	MusicPlayerOptionsFrame_PlaylistFormattingFrame_Text1_DropDownLabel:SetTextColor(1,0,0);
	MusicPlayerOptionsFrame_PlaylistFormattingFrame_Text1_DropDownText:SetTextColor(1,0,0);
	MusicPlayerOptionsFrame_PlaylistFormattingFrame_Text2_DropDownText:SetTextColor(1,0,0);
	MusicPlayerOptionsFrame_PlaylistFormattingFrame_Text3_DropDownText:SetTextColor(1,0,0);
end

function MusicPlayerOptionsFrame_PlayerVisualsFrame_PlaylistAnchor_DropDown_Initialize()

	local info = UIDropDownMenu_CreateInfo();
	info.text = MUSICPLAYER_ABOVE;
	info.func = MusicPlayerOptionsFrame_PlayerVisualsFrame_PlaylistAnchor_DropDown_OnClick;
	info.value = 1;
	UIDropDownMenu_AddButton(info);

	local info = UIDropDownMenu_CreateInfo();
	info.text = MUSICPLAYER_BELOW;
	info.func = MusicPlayerOptionsFrame_PlayerVisualsFrame_PlaylistAnchor_DropDown_OnClick;
	info.value = 2;
	UIDropDownMenu_AddButton(info);

	local info = UIDropDownMenu_CreateInfo();
	info.text = MUSICPLAYER_LEFT;
	info.func = MusicPlayerOptionsFrame_PlayerVisualsFrame_PlaylistAnchor_DropDown_OnClick;
	info.value = 3;
	UIDropDownMenu_AddButton(info);

	local info = UIDropDownMenu_CreateInfo();
	info.text = MUSICPLAYER_TOPLEFT;
	info.func = MusicPlayerOptionsFrame_PlayerVisualsFrame_PlaylistAnchor_DropDown_OnClick;
	info.value = 4;
	UIDropDownMenu_AddButton(info);

	local info = UIDropDownMenu_CreateInfo();
	info.text = MUSICPLAYER_BOTTOMLEFT;
	info.func = MusicPlayerOptionsFrame_PlayerVisualsFrame_PlaylistAnchor_DropDown_OnClick;
	info.value = 5;
	UIDropDownMenu_AddButton(info);

	local info = UIDropDownMenu_CreateInfo();
	info.text = MUSICPLAYER_RIGHT;
	info.func = MusicPlayerOptionsFrame_PlayerVisualsFrame_PlaylistAnchor_DropDown_OnClick;
	info.value = 6;
	UIDropDownMenu_AddButton(info);

	local info = UIDropDownMenu_CreateInfo();
	info.text = MUSICPLAYER_TOPRIGHT;
	info.func = MusicPlayerOptionsFrame_PlayerVisualsFrame_PlaylistAnchor_DropDown_OnClick;
	info.value = 7;
	UIDropDownMenu_AddButton(info);

	local info = UIDropDownMenu_CreateInfo();
	info.text = MUSICPLAYER_BOTTOMRIGHT;
	info.func = MusicPlayerOptionsFrame_PlayerVisualsFrame_PlaylistAnchor_DropDown_OnClick;
	info.value = 8;
	UIDropDownMenu_AddButton(info);
end


function MusicPlayerOptionsFrame_GeneralSettingsFrame_FinishedDropDown_Initialize()

	local info = UIDropDownMenu_CreateInfo();
	info.text = MUSICPLAYER_PLAYNEXT;
	info.func = MusicPlayerOptionsFrame_GeneralSettingsFrame_FinishedDropDown_OnClick;
	info.value = 11;
	UIDropDownMenu_AddButton(info);

	local info = UIDropDownMenu_CreateInfo();
	info.text = MUSICPLAYER_RANDOM;
	info.func = MusicPlayerOptionsFrame_GeneralSettingsFrame_FinishedDropDown_OnClick;
	info.value = 12;
	UIDropDownMenu_AddButton(info);

	local info = UIDropDownMenu_CreateInfo();
	info.text = MUSICPLAYER_LOOP;
	info.func = MusicPlayerOptionsFrame_GeneralSettingsFrame_FinishedDropDown_OnClick;
	info.value = 13;
	UIDropDownMenu_AddButton(info);
end

function MusicPlayerOptionsFrame_PlayerVisualsFrame_FrameStrata_DropDown_Initialize()
	local info = UIDropDownMenu_CreateInfo();
	info.text = MUSICPLAYER_TEXT_LOW;
	info.func = MusicPlayerOptionsFrame_PlayerVisualsFrame_FrameStrata_DropDown_OnClick;
	info.value = 1;
	UIDropDownMenu_AddButton(info);

	local info = UIDropDownMenu_CreateInfo();
	info.text = MUSICPLAYER_TEXT_MEDIUM;
	info.func = MusicPlayerOptionsFrame_PlayerVisualsFrame_FrameStrata_DropDown_OnClick;
	info.value = 2;
	UIDropDownMenu_AddButton(info);

	local info = UIDropDownMenu_CreateInfo();
	info.text = MUSICPLAYER_TEXT_HIGH;
	info.func = MusicPlayerOptionsFrame_PlayerVisualsFrame_FrameStrata_DropDown_OnClick;
	info.value = 3;
	UIDropDownMenu_AddButton(info);
end



function MusicPlayerOptionsFrame_PlaylistFormattingFrame_Text1_DropDown_Initialize()

	local texts = {
		[1] = MusicPlayer_Title;
		[2] = MusicPlayer_Album;
		[3] = MusicPlayer_Artist;
		[4] = MusicPlayer_Genre;
		[5] = MusicPlayer_Quality;
	};

	local dropdown1 = MusicPlayerFrameOptions.playlistformatting[1];
	local dropdown2 = MusicPlayerFrameOptions.playlistformatting[2];
	local dropdown3 = MusicPlayerFrameOptions.playlistformatting[3];

	for i = 1, 5 do
		local info = UIDropDownMenu_CreateInfo();
		info.text = texts[i];
		info.func = MusicPlayerOptionsFrame_PlaylistFormattingFrame_Text1_DropDown_OnClick;
		info.value = i;

		if (dropdown2 == i) or (dropdown3 == i) then
			info.disabled = true;
		end

		UIDropDownMenu_AddButton(info);
	end
end

function MusicPlayerOptionsFrame_PlaylistFormattingFrame_Text2_DropDown_Initialize()

	local texts = {
		[1] = MusicPlayer_Title;
		[2] = MusicPlayer_Album;
		[3] = MusicPlayer_Artist;
		[4] = MusicPlayer_Genre;
		[5] = MusicPlayer_Quality;
		[6] = MusicPlayer_Nothing;
	};

	local dropdown1 = MusicPlayerFrameOptions.playlistformatting[1];
	local dropdown2 = MusicPlayerFrameOptions.playlistformatting[2];
	local dropdown3 = MusicPlayerFrameOptions.playlistformatting[3];

	for i = 1, 6 do
		local info = UIDropDownMenu_CreateInfo();
		info.text = texts[i];
		info.func = MusicPlayerOptionsFrame_PlaylistFormattingFrame_Text2_DropDown_OnClick;
		info.value = i;

		if (dropdown1 == i) or (dropdown3 == i) and (i < 6) then
			info.disabled = true;
		end

		UIDropDownMenu_AddButton(info);
	end
end

function MusicPlayerOptionsFrame_PlaylistFormattingFrame_Text3_DropDown_Initialize()

	local texts = {
		[1] = MusicPlayer_Title;
		[2] = MusicPlayer_Album;
		[3] = MusicPlayer_Artist;
		[4] = MusicPlayer_Genre;
		[5] = MusicPlayer_Quality;
		[6] = MusicPlayer_Nothing;
	};

	local dropdown1 = MusicPlayerFrameOptions.playlistformatting[1];
	local dropdown2 = MusicPlayerFrameOptions.playlistformatting[2];
	local dropdown3 = MusicPlayerFrameOptions.playlistformatting[3];

	for i = 1, 6 do
		local info = UIDropDownMenu_CreateInfo();
		info.text = texts[i];
		info.func = MusicPlayerOptionsFrame_PlaylistFormattingFrame_Text3_DropDown_OnClick;
		info.value = i;

		if (dropdown1 == i) or (dropdown2 == i) and (i < 6) then
			info.disabled = true;
		end

		UIDropDownMenu_AddButton(info);
	end
end

-----------------------------------------------------------------------------------------------

function MusicPlayerOptionsFrame_PlaylistButtons_Slider_EditBox_OnEnterPressed()
	this:ClearFocus();
	local value = this:GetNumber();

	if (value > 30) then
		value = 30;
	elseif (value < 10) then
		value = 10;
	end

	this:SetNumber(value);
	MusicPlayerOptionsFrame_PlayerSettingsFrame_PlaylistButtons_Slider:SetValue(value);
end

function MusicPlayerOptionsFrame_Alpha_Slider_EditBox_OnEnterPressed()
	this:ClearFocus();
	local value = this:GetNumber();

	if (value > 100) then
		value = 100;
	elseif (value < 30) then
		value = 30;
	end

	this:SetNumber(value);
	MusicPlayerOptionsFrame_PlayerVisualsFrame_Alpha_Slider:SetValue(value);
end

function MusicPlayerOptionsFrame_Scale_Slider_EditBox_OnEnterPressed()
	this:ClearFocus();
	local value = this:GetNumber();

	if (value > 150) then
		value = 150;
	elseif (value < 50) then
		value = 50;
	end

	this:SetNumber(value);
	MusicPlayerOptionsFrame_PlayerVisualsFrame_Scale_Slider:SetValue(value);
end

function MusicPlayerOptionsFrame_PlaylistWidth_Slider_EditBox_OnEnterPressed()
	this:ClearFocus();
	local value = this:GetNumber();

	if (value > 450) then
		value = 450;
	elseif (value < 150) then
		value = 150;
	end

	this:SetNumber(value);
	MusicPlayerOptionsFrame_PlayerVisualsFrame_PlaylistWidth_Slider:SetValue(value);
end

--------------------------------------------------------------------------------------------------
-- Display functions
--------------------------------------------------------------------------------------------------




function MusicPlayer_OptionsFrame_resize_Show(self, elapsed)
	local height = self:GetHeight();
	height = floor(height);
	if ( height < 480 ) then
		-- Set Height
		local newHeight = floor(min(height + 400*elapsed, 480));

		if (newHeight > 480) then
			self:SetHeight(480);
		else
			self:SetHeight(newHeight);
		end
	else

		local alpha = getglobal(self.fadingframe):GetAlpha();
		if ( alpha < 1 ) then
			getglobal(self.fadingframe):Show();
			local newAlpha = min(alpha + 1.25*elapsed, 1);
                        
			getglobal(self.fadingframe):SetAlpha(newAlpha);
		else
			-- We're done, disable the function
			self:SetScript("OnUpdate", nil);
		end
	end
end

function MusicPlayer_OptionsFrame_resize_Hide(self, elapsed)
	local alpha = getglobal(self.fadingframe):GetAlpha();
	if ( alpha > 0 ) then
		local newAlpha = min(alpha - 1.25*elapsed, 1);

		getglobal(self.fadingframe):SetAlpha(newAlpha);
	else
		-- We're done, disable the function and start part 2.
		getglobal(self.fadingframe):Hide();
		self:SetScript("OnUpdate", nil);
		if (self.fadingframe == "MusicPlayerOptionsFrame_PlayerVisualsFrame") and (self.resize == 1) then

			self:SetScript("OnUpdate", MusicPlayer_OptionsFrame_resize_Hide2);

		elseif (self.fadingframe == "MusicPlayerOptionsFrame_PlaylistFormattingFrame") and (self.resize == 1) then

			self:SetScript("OnUpdate", MusicPlayer_OptionsFrame_resize_Hide2);

		elseif (self.fadingframe == "MusicPlayerOptionsFrame_PlayerVisualsFrame") then

			self.fadingframe = "MusicPlayerOptionsFrame_PlaylistFormattingFrame";
			self:SetScript("OnUpdate", MusicPlayer_OptionsFrame_resize_Show);

		elseif (self.fadingframe == "MusicPlayerOptionsFrame_PlaylistFormattingFrame") then

			self.fadingframe = "MusicPlayerOptionsFrame_PlayerVisualsFrame";
			self:SetScript("OnUpdate", MusicPlayer_OptionsFrame_resize_Show);
		end
	end
end

function MusicPlayer_OptionsFrame_resize_Hide2(self, elapsed)
	local height = self:GetHeight();
	height = floor(height);

	if ( height > 280 ) then
		-- Set Height
		local newHeight = floor(min(height - 400*elapsed));

		if (newHeight < 280) then
			self:SetHeight(280);
		else
			self:SetHeight(newHeight);
		end

	else
		-- We're done, disable the function
		self.resize = 0;
		self:SetScript("OnUpdate", nil);
	end
end

----------------------------------------------------------------------------

function MusicPlayer_ColorPickerFrame_OnLoad()
	this:SetBackdropColor(0,0,0);
	this:SetBackdropBorderColor(0.356, 0.356, 0.356);
	this:SetClampedToScreen(1);

	MusicPlayer_ColorPickerFrame_Red_BG:SetBackdropColor(0.035, 0.035, 0.035);
	MusicPlayer_ColorPickerFrame_Red_BG:SetBackdropBorderColor(0.356, 0.356, 0.356);

	MusicPlayer_ColorPickerFrame_Green_BG:SetBackdropColor(0.035, 0.035, 0.035);
	MusicPlayer_ColorPickerFrame_Green_BG:SetBackdropBorderColor(0.356, 0.356, 0.356);

	MusicPlayer_ColorPickerFrame_Blue_BG:SetBackdropColor(0.035, 0.035, 0.035);
	MusicPlayer_ColorPickerFrame_Blue_BG:SetBackdropBorderColor(0.356, 0.356, 0.356);

	MusicPlayer_ColorPickerFrame_ColorPickerRedValue:SetTextColor(0.4,0.4,0.4);
	MusicPlayer_ColorPickerFrame_ColorPickerGreenValue:SetTextColor(0.4,0.4,0.4);
	MusicPlayer_ColorPickerFrame_ColorPickerBlueValue:SetTextColor(0.4,0.4,0.4);

	MusicPlayer_ColorPickerFrame_ColorSwatch:SetBackdropBorderColor(0.356, 0.356, 0.356);
end

function MusicPlayer_ColorWheel()
	local button = this;
	local color1 = MusicPlayerFrameOptions.Color[button:GetID()][1];
	local color2 = MusicPlayerFrameOptions.Color[button:GetID()][2];
	local color3 = MusicPlayerFrameOptions.Color[button:GetID()][3];

	MusicPlayer_ColorPickerFrame.button = button:GetName()
	MusicPlayer_ColorPickerFrame.color1 = color1;
	MusicPlayer_ColorPickerFrame.color2 = color2;
	MusicPlayer_ColorPickerFrame.color3 = color3;

	MusicPlayer_ColorPickerFrame_HeaderBox_Text:SetText(getglobal(button:GetName().."_ButtonText"):GetText());
	MusicPlayer_ColorPickerFrame_ColorPicker:SetColorRGB(color1, color2, color3);

	MusicPlayer_ColorPickerFrame:ClearAllPoints();
	MusicPlayer_ColorPickerFrame:SetPoint("CENTER", "UIParent");
	MusicPlayer_ColorPickerFrame:Show();
end

function MusicPlayer_SetColor(button, r, g, b)
	if (not r) then
		local r,g,b = MusicPlayer_ColorPickerFrame_ColorPicker:GetColorRGB();
		MusicPlayer_SetColorSub(button, r, g, b);
	else
		MusicPlayer_SetColorSub(button, r, g, b);
	end
end

function MusicPlayer_SetColorSub(button, r, g, b)
	
	local n = button:GetID();

	button:SetBackdropColor(r, g, b);

	MusicPlayerFrameOptions.Color[n][1] = r;
	MusicPlayerFrameOptions.Color[n][2] = g;
	MusicPlayerFrameOptions.Color[n][3] = b;

	MusicPlayerFrame_UpdateColors();
end

function MusicPlayer_ColorWheel_CancelFunc(func)
	MusicPlayer_ColorPickerFrame_Cancel_Button:SetScript("OnClick", func);
end

function MusicPlayer_ColorWheel_Func(func)
	MusicPlayer_ColorPickerFrame_Okay_Button:SetScript("OnClick", func);
end

----------------------------------------------------------------------------

function MusicPlayerOptionsFrame_ToggleHelp()
	if (MusicPlayerFrameOptions.DisplayHelp == 1) then
		MusicPlayerFrameOptions.DisplayHelp = 0;
		MusicPlayerOptionsFrame_Help_ButtonText:SetText(MUSICPLAYER_HELP..": "..MusicPlayer_Off);
	else
		MusicPlayerFrameOptions.DisplayHelp = 1;
		MusicPlayerOptionsFrame_Help_ButtonText:SetText(MUSICPLAYER_HELP..": "..MusicPlayer_On);
	end
end


----------------------------------------------------------------------------
----------------------------------------------------------------------------


function MusicPlayerHelpFrame_OnLoad()
	tinsert(UISpecialFrames, "MusicPlayerHelpFrame");
	this:SetClampedToScreen(1);

	MusicPlayerHelpFrame_HelpTable = {
		["Page1"] = {
			["Header"] = "Table of Contents",
			["Text"] = "",
		},
		["Page2"] = {
			["Header"] = "Adding Songs",
			["Text"] = MusicPlayer_Help_AddSongs,
		},
		["Page3"] = {
			["Header"] = "Slash Commands",
			["Text"] = MusicPlayer_Help_SlashCommands,
		},
		["Page4"] = {
			["Header"] = "Player Help",
			["Text"] = MusicPlayer_Help_Player,
		},
		["Page5"] = {
			["Header"] = "Support",
			["Text"] = MusicPlayer_Help_Support,
		},
		["Page6"] = {
			["Header"] = "FAQs",
			["Text"] = MusicPlayer_Help_FAQs,
		}, -- Page <this.maxpages + 1> taken by MusicPlayerMediaLibrary, if installed.

	};
	this.maxpages = 6;

	MusicPlayerHelpFrame_Update_TableOfContents();

	this:SetBackdropColor(0,0,0);
	this:SetBackdropBorderColor(0.356, 0.356, 0.356);

	MusicPlayerHelpFrame_MainWindow:SetBackdropColor(0.035, 0.035, 0.035);
	MusicPlayerHelpFrame_MainWindow:SetBackdropBorderColor(0.356, 0.356, 0.356);
	MusicPlayerHelpFrame_MainWindow_HeaderText:SetTextColor(0,0,0,0); -- hidden

	MusicPlayerHelpFrame_HeaderBox_Text:SetText(MUSICPLAYER_HELPFRAME_TITLE);
end

function MusicPlayerHelpFrame_Update_TableOfContents()
	MusicPlayer_Help_TableOfContents = "";
	for i = 1, MusicPlayerHelpFrame.maxpages do
		local page = "Page "..i;
		MusicPlayer_Help_TableOfContents = MusicPlayer_Help_TableOfContents..page.."\n - "..MusicPlayerHelpFrame_HelpTable["Page"..i]["Header"].."\n\n";
	end
	MusicPlayerHelpFrame_HelpTable["Page1"]["Text"] = MusicPlayer_Help_TableOfContents;
end

function MusicPlayerHelpFrame_OnShow()
	if (this.Page == nil) then
		this.Page = 1;
	end

	local page = "Page"..this.Page;

	MusicPlayerHelpFrame_HelpHeaderText:SetText(MusicPlayerHelpFrame_HelpTable[page]["Header"]);
	MusicPlayerHelpFrame_MainText:SetText(MusicPlayerHelpFrame_HelpTable[page]["Text"]);

	MusicPlayerHelpFrame_MainWindow_ScrollFrame:UpdateScrollChildRect();
	MusicPlayerHelpFrame_PageText:SetText(format(MUSICPLAYER_HELP_PAGETEXT, MusicPlayerHelpFrame.Page, MusicPlayerHelpFrame.maxpages));
end

function MusicPlayerHelpFrame_NextPage()
	MusicPlayerHelpFrame.Page = MusicPlayerHelpFrame.Page + 1;
	if (MusicPlayerHelpFrame.Page > MusicPlayerHelpFrame.maxpages) then
		MusicPlayerHelpFrame.Page = MusicPlayerHelpFrame.maxpages;
	end
	MusicPlayerHelpFrame_Update();
end

function MusicPlayerhelpFrame_PrevPage()
	MusicPlayerHelpFrame.Page = MusicPlayerHelpFrame.Page - 1;

	if (MusicPlayerHelpFrame.Page < 1) then
		MusicPlayerHelpFrame.Page = 1;
	end
	MusicPlayerHelpFrame_Update();
end


function MusicPlayerHelpFrame_Update()
	local page = "Page"..MusicPlayerHelpFrame.Page;

	MusicPlayerHelpFrame_HelpHeaderText:SetText(MusicPlayerHelpFrame_HelpTable[page]["Header"]);
	MusicPlayerHelpFrame_MainText:SetText(MusicPlayerHelpFrame_HelpTable[page]["Text"]);

	MusicPlayerHelpFrame_MainWindow_ScrollFrame:UpdateScrollChildRect();
	MusicPlayerHelpFrame_PageText:SetText(format(MUSICPLAYER_HELP_PAGETEXT, MusicPlayerHelpFrame.Page, MusicPlayerHelpFrame.maxpages));
end





