MusicPlayerOptions = { };

function MusicPlayer_Button_Initialize()
	if (MusicPlayerOptions.MusicPlayerButtonPosition == nil) then
		MusicPlayerOptions.MusicPlayerButtonPosition = 25;
	end
end


function MusicPlayer_DropDown_OnLoad()
	UIDropDownMenu_Initialize(this, MusicPlayer_DropDown_InitButtons, "MENU");
end

function MusicPlayer_Button_BeingDragged()
    local xpos,ypos = GetCursorPosition();
    local xmin,ymin = Minimap:GetLeft(), Minimap:GetBottom();
    xpos = xmin-xpos/UIParent:GetScale()+70;
    ypos = ypos/UIParent:GetScale()-ymin-70;
    MusicPlayer_Button_SetPosition(math.deg(math.atan2(ypos,xpos)));
end

function MusicPlayer_Button_OnClick(arg)
	if (arg == "LeftButton") then
		MusicPlayer_ToggleDropDown();
	end
end



function MusicPlayer_Button_OnEnter()
	GameTooltip:SetOwner(this, "ANCHOR_LEFT");
	GameTooltip:SetText(MusicPlayer_BUTTON_TOOLTIP0);
	GameTooltip:AddLine(MusicPlayer_BUTTON_TOOLTIP1);
	GameTooltip:AddLine(MusicPlayer_BUTTON_TOOLTIP2);
	GameTooltip:Show();
end

function MusicPlayer_Button_SetPosition(v)
    if(v < 0) then
        v = v + 360;
    end
    MusicPlayerOptions.MusicPlayerButtonPosition = v;
    MusicPlayer_Button_UpdatePosition();
end

function MusicPlayer_Button_UpdatePosition()
	MusicPlayer_ButtonFrame:SetPoint(
		"TOPLEFT",
		"Minimap",
		"TOPLEFT",
		54 - (78 * cos(MusicPlayerOptions.MusicPlayerButtonPosition)),
		(78 * sin(MusicPlayerOptions.MusicPlayerButtonPosition)) - 55
	);
end

function MusicPlayer_ToggleDropDown()
	ToggleDropDownMenu(1, nil, MusicPlayer_DropDownFrame); --, MusicPlayer_ButtonFrame, -30, 4
end


function MusicPlayer_ToggleMinimapButton()
	if ( MusicPlayerFrameOptions.MinimapButton == 1) then
		MusicPlayer_Button:Show();
	else
		MusicPlayer_Button:Hide();
	end
end

function MusicPlayer_DropDown_InitButtons(level)

	if (level == 1) then

		local info = UIDropDownMenu_CreateInfo();
		info.text = MusicPlayer_LABEL_TITLE2;
		info.isTitle = 2;
		info.justifyH = "CENTER";
		info.notCheckable = 1;
		UIDropDownMenu_AddButton(info);

		local info = UIDropDownMenu_CreateInfo();
		info.text = MusicPlayer_StopSong;
		info.isTitle = nil;
		info.justifyH = "CENTER";
		info.notCheckable = 1;
		info.func = function(msg) MusicPlayerStop(); end;
		UIDropDownMenu_AddButton(info);

		local info = UIDropDownMenu_CreateInfo();
		info.text = MusicPlayer_Next_Song;
		info.isTitle = nil;
		info.justifyH = "CENTER";
		info.notCheckable = 1;
		info.func = function(msg) MusicPlayer_PlayNextSong(); end;
		UIDropDownMenu_AddButton(info);

		local info = UIDropDownMenu_CreateInfo();
		info.text = MusicPlayer_Previous_Song;
		info.isTitle = nil;
		info.justifyH = "CENTER";
		info.notCheckable = 1;
		info.func = function(msg) MusicPlayer_PlayPrevSong(); end;
		UIDropDownMenu_AddButton(info);

		local info = UIDropDownMenu_CreateInfo();
		info.text = MusicPlayer_LABEL_TITLE3;
		info.isTitle = 2;
		info.justifyH = "CENTER";
		info.notCheckable = 1;
		UIDropDownMenu_AddButton(info);

		local info = UIDropDownMenu_CreateInfo();
		info.text = MusicPlayer_LABEL_TITLE3;
		info.isTitle = nil;
		info.justifyH = "CENTER";
		info.notCheckable = 1;
		info.func = function(msg)
			MP_ToggleOptions();
		end;
		UIDropDownMenu_AddButton(info);

		local info = UIDropDownMenu_CreateInfo();
		info.text = MusicPlayer_Queue;
		info.isTitle = nil;
		info.justifyH = "CENTER";
		info.notCheckable = 1;
		info.func = function(msg)
			MusicPlayerEnqueueFrame_Toggle();
		end;
		UIDropDownMenu_AddButton(info);

		local info = UIDropDownMenu_CreateInfo();
		info.text = MusicPlayer_Favorites_Title;
		info.isTitle = nil;
		info.justifyH = "CENTER";
		info.notCheckable = 1;
		info.func = function(msg)
			MusicPlayer_ToggleFavorites();
		end;
		UIDropDownMenu_AddButton(info);

		local info = UIDropDownMenu_CreateInfo();
		info.text = MUSICPLAYER_HELP;
		info.isTitle = nil;
		info.justifyH = "CENTER";
		info.notCheckable = 1;
		info.func = function(msg)
			MP_ToggleHelp();
		end;
		UIDropDownMenu_AddButton(info);


		local info = UIDropDownMenu_CreateInfo();
		info.text = MusicPlayer_LABEL_TITLE4;
		info.isTitle = 2;
		info.justifyH = "CENTER";
		info.notCheckable = 1;
		UIDropDownMenu_AddButton(info);

		local info = UIDropDownMenu_CreateInfo();
		info.text = MusicPlayer_LABEL_TITLE4;
		info.isTitle = nil;
		info.hasArrow = true;
		info.justifyH = "CENTER";
		info.notCheckable = 1;
		info.value = {
			 ["Level1_Key"] = "AfterCurrent";
		};
		UIDropDownMenu_AddButton(info);
	end

	if (level == 2) then
		local Level1_Key = UIDROPDOWNMENU_MENU_VALUE["Level1_Key"];

		if (Level1_Key == "AfterCurrent") then

			local info = UIDropDownMenu_CreateInfo();
			info.text = MusicPlayer_Shuffle;
			info.isTitle = nil;
			info.justifyH = "CENTER";
			info.checked = nil;
			if (MusicPlayerFrameOptions.Shuffle == 1) then
				info.checked = 1;
			end
			info.func = function(msg)
				if (MusicPlayerFrameOptions.Shuffle == 1) then
					MusicPlayerFrameOptions.Shuffle = 0;
				else
					MusicPlayerFrameOptions.Shuffle = 1;
				end
			end;
			UIDropDownMenu_AddButton(info, level);

			local info = UIDropDownMenu_CreateInfo();
			info.text = MUSICPLAYER_PLAYNEXT;
			info.isTitle = nil;
			info.justifyH = "CENTER";
			info.checked = nil;
			if (MusicPlayerFrameOptions.WhenFinished == 11) then
				info.checked = 1;
			end
			info.func = function(msg)
				MusicPlayerFrameOptions.WhenFinished = 11;
				UIDropDownMenu_SetSelectedValue(MusicPlayerOptionsFrame_GeneralSettingsFrame_FinishedDropDown, MusicPlayerFrameOptions.WhenFinished);
			end;
			UIDropDownMenu_AddButton(info, level);

			local info = UIDropDownMenu_CreateInfo();
			info.text = MUSICPLAYER_RANDOM;
			info.isTitle = nil;
			info.justifyH = "CENTER";
			info.checked = nil;
			if (MusicPlayerFrameOptions.WhenFinished == 12) then
				info.checked = 1;
			end
			info.func = function(msg)
				MusicPlayerFrameOptions.WhenFinished = 12;
				UIDropDownMenu_SetSelectedValue(MusicPlayerOptionsFrame_GeneralSettingsFrame_FinishedDropDown, MusicPlayerFrameOptions.WhenFinished);
			end;
			UIDropDownMenu_AddButton(info, level);

			local info = UIDropDownMenu_CreateInfo();
			info.text = MUSICPLAYER_LOOP;
			info.isTitle = nil;
			info.justifyH = "CENTER";
			info.checked = nil;
			if (MusicPlayerFrameOptions.WhenFinished == 13) then
				info.checked = 1;
			end
			info.func = function(msg)
				MusicPlayerFrameOptions.WhenFinished = 13;
				UIDropDownMenu_SetSelectedValue(MusicPlayerOptionsFrame_GeneralSettingsFrame_FinishedDropDown, MusicPlayerFrameOptions.WhenFinished);
			end;
			UIDropDownMenu_AddButton(info, level);
			return;
		end
	end




end
