---------------------------------------------------------------------------------------------------------
------------------------------------------[MusicPlayer]--------------------------------------------------
---------------------------------------------------------------------------------------------------------

---------------------------------------------------------------------------------------------------------
-- Global variables
---------------------------------------------------------------------------------------------------------

MP_SongIsPlaying = 0;
MusicPlayer_SongTime_START = 0;
MusicPlayer_SongTime_END = 0;
MP_OldMasterVolume = GetCVar("Sound_MasterVolume");
MusicPlayer_MusicVolume = GetCVar("Sound_MusicVolume");
MusicPlayer_PlaylistSearch_LastSearch = 0;

-- Update this variable to the version of MPML
-- this version of MusicPlayer is compatible with.
MusicPlayer_MPML_Support = 1;

---------------------------------------------------------------------------------------------------------
-- Function to load a playlist when no playlist exist.
---------------------------------------------------------------------------------------------------------
MusicPlayerSongs = {};
for i = 1,2 do
	MusicPlayerSongs[i] = {};
	MusicPlayerSongs[i]["Title"] = getglobal("MP_DefaultPlaylist_"..i);
	MusicPlayerSongs[i]["Filename"] = "Unknown Filepath";
	MusicPlayerSongs[i]["Duration"] = 3600;
	MusicPlayerSongs[i]["Artist"] = "Unknown Artist";
	MusicPlayerSongs[i]["Album"] = "Unknown Album";
	MusicPlayerSongs[i]["Quality"] = 128;
	MusicPlayerSongs[i]["Genre"] = "Unknown Genre";
end
---------------------------------------------------------------------------------------------------------

function MusicPlayer_PlaySong(songnumber)
	if (songnumber > 0) then
		SetCVar("Sound_EnableMusic", 1);
		PlayMusic(MusicPlayerSongs[songnumber]["Filename"]);


		if MusicPlayerMediaLibrary and MusicPlayerMediaLibrary:IsVisible() then
			MusicPlayerMediaLibrary_AddMessage(format(MusicPlayer_PlayingSong, MusicPlayerSongs[songnumber]["Title"]));
		else
			if (MusicPlayerFrameOptions.ShowSpam == 1) then
				MPPC(MP_Yellow..format(MusicPlayer_PlayingSong, MusicPlayer_CreateChatLink(MusicPlayerSongs[songnumber]["Title"])), 1);
			elseif (MusicPlayerFrameOptions.NotificationOverlay == 1) then
			end
		end

		MP_SongIsPlaying = songnumber;

		MusicPlayer_SongTime_START = 0;
		MusicPlayer_SongTime_END = 0;

		MusicPlayer_StartStopUpdate("start");
	else
		MusicPlayerStop();
	end
end


function MusicPlayer_PlayNextSong()
	local a,b,Song,Number;
	local lastsongnr;
	local firstsongnr;
	local nextsongnr;


	if (MPML and MusicPlayer_PlayingEnqueued == 1) then
		MusicPlayerMediaLibrary_Enqueue_PlayEnqueued();
		return;
	elseif (MusicPlayerFrameOptions["Shuffle"] == 1) then
		MusicPlayer_PlayRandomSong();
		return;
	else
		-- Get the last song.
		a, b, Song, Number = strfind(MusicPlayerSongs_Sorted[MusicPlayer_GetSongNum()], "(.+) (%d+)");
		lastsongnr = tonumber(Number);

		-- Oh, we were playing the last song! Start from song 'one'.
		if (MP_SongIsPlaying == 0) or (MP_SongIsPlaying == lastsongnr) then

			a, b, Song, Number = strfind(MusicPlayerSongs_Sorted[1], "(.+) (%d+)");
			firstsongnr = tonumber(Number);

			MusicPlayer_PlaySong(firstsongnr);
		

		-- Play the next song.
		else
			nextsongnr = MusicPlayer_Songs_NumberConverter(MP_SongIsPlaying) + 1;
			a, b, Song, Number = strfind(MusicPlayerSongs_Sorted[nextsongnr], "(.+) (%d+)");
			nextsongnr = tonumber(Number);
			MusicPlayer_PlaySong(nextsongnr);
		end
	end
end

function MusicPlayer_PlayPrevSong()
	local a,b,Song,Number;
	local lastsongnr;
	local firstsongnr;
	local nextsongnr;


	if (MusicPlayerFrameOptions["Shuffle"] == 1) then
		MusicPlayer_PlayRandomSong();
		return;
	else
		-- Get the first song.
		a, b, Song, Number = strfind(MusicPlayerSongs_Sorted[1], "(.+) (%d+)");
		firstsongnr = tonumber(Number);

		-- Get the last song.
		a, b, Song, Number = strfind(MusicPlayerSongs_Sorted[MusicPlayer_GetSongNum()], "(.+) (%d+)");
		lastsongnr = tonumber(Number);

		-- Oh, we were playing the first song! Start from the end.
		if (MP_SongIsPlaying == 0) or (MP_SongIsPlaying == firstsongnr) then
			MusicPlayer_PlaySong(lastsongnr);
			return;

		-- Play the prev song.
		else
			nextsongnr = MusicPlayer_Songs_NumberConverter(MP_SongIsPlaying) - 1;
			a, b, Song, Number = strfind(MusicPlayerSongs_Sorted[nextsongnr], "(.+) (%d+)");
			nextsongnr = tonumber(Number);
			MusicPlayer_PlaySong(nextsongnr);
		end

	end

end

function MusicPlayer_PlayRandomSong()
	MusicPlayer_PlaySong(random(1, MusicPlayer_GetSongNum()));
end

---------------------------------------------------------------------------------------------------------

function MusicPlayerStop()
	if (MP_SongIsPlaying ~= 0) then
		StopMusic();
		if(MusicPlayerFrameOptions.ShowSpam == 1)then
			MPPC(""..MP_Yellow.."Stop Music.", 1);
		end

		MusicPlayer_SongTime_START = 0;
		MusicPlayer_SongTime_END = 0;

		MP_SongIsPlaying = 0;
		SetCVar("Sound_EnableMusic", MusicPlayerFrameOptions.MusicAfterStop);

		MusicPlayer_StartStopUpdate("stop");
	end
	MusicPlayerPlaylistUpdate();
end

function MusicPlayerMute(input)
	if (input) then
		SetCVar("Sound_MasterVolume", 0)
	else
		SetCVar("Sound_MasterVolume", MP_OldMasterVolume);
	end
end


function MusicPlayer_KeybinidingVolume(dir)

	local volume = GetCVar("Sound_MusicVolume");

	if (dir == "+") then
		if volume + 0.10 > 1 then
			volume = 1;
		else
			volume = volume + 0.10;
		end
		MusicPlayer_SetVolume(volume);
	elseif (dir == "-") then
		if volume - 0.10 < 0 then
			volume = 0;
		else
			volume = volume - 0.10;
		end
		MusicPlayer_SetVolume(volume);
	end
end

function MusicPlayer_SetVolume(volume)

	local volumepercent =  floor(volume * 100 + 0.5);

	SetCVar("Sound_MusicVolume", volume, volume);
	MP_OldMusicVolume = GetCVar("Sound_MusicVolume");


	if MusicPlayerMediaLibrary and MusicPlayerMediaLibrary:IsVisible() then
		MusicPlayerMediaLibrary_AddMessage("Volume: "..volumepercent.."%");
	else
		if(MusicPlayerFrameOptions.ShowSpam == 1)then
			MPPC(MP_Yellow.."Volume: "..volumepercent.."%", 1);
		end
	end
end


-------------------------------------------------------------------------------------
function MusicPlayer_GetSongNum()
	return tonumber(getn(MusicPlayerSongs));
end

function MusicPlayer_Search(text, list)
	local searchnumber = 0;
	local searchednum = 0;
	local a, b, Song, Number;
	local text = strlower(text);



	if (list == "playlist") then
		local first_playlist_searchnumber = 0;
		local first_playlist_searchednum = 0;
		local first_playlist_searchedtext = "";


		for k, v in pairs(MusicPlayerSongs_Sorted) do
			a, b, category, Number = strfind(v, "(.+) (%d+)");
			Number = tonumber(Number);

			local search_sortby = {
				[1] = "Title",
				[2] = "Artist",
				[3] = "Album",
				[4] ="Genre",
				[5] = "Quality",
			};



			if (text == category) then
				searchnumber = Number;
				searchednum = k;
				MusicPlayer_Search_ListsUpdate(searchnumber, searchednum, text, list);
				return;



			elseif (strfind(strlower(MusicPlayerSongs[Number][search_sortby[MusicPlayerFrameOptions.SearchSortBy]]), text)) then
				local startpos, endpos, Text = strfind(strlower(MusicPlayerSongs[Number][search_sortby[MusicPlayerFrameOptions.SearchSortBy]]), text);
				if (startpos and startpos == 1) then

					if (first_playlist_searchedtext ~= text) then
						first_playlist_searchnumber = Number;
						first_playlist_searchednum = k;
						first_playlist_searchedtext = text;
					end

					searchnumber = Number;
					searchednum = k;

					if (k > MusicPlayer_PlaylistSearch_LastSearch) then
						MusicPlayer_Search_ListsUpdate(searchnumber, searchednum, text, list);
						MusicPlayer_PlaylistSearch_LastSearch = k;
						return;
					end
				end
			end
		end


		if (first_playlist_searchedtext == text) then
			MusicPlayer_Search_ListsUpdate(first_playlist_searchnumber, first_playlist_searchednum, text, list);
			MusicPlayer_PlaylistSearch_LastSearch = first_playlist_searchednum;
			return;
		end

	end
	MusicPlayer_Search_ListsUpdate(searchnumber, searchednum, text, list);
end


function MusicPlayer_Search_ListsUpdate(searchnumber, searchednum, text, list)
	if (searchnumber ~= 0) then

		local playlistbtns = tonumber(MusicPlayerFrameOptions["NumPlaylistButtons"]);
		searchednum = searchednum - 1;

		if (searchednum > (MusicPlayer_GetSongNum() - playlistbtns) ) then
			searchednum = MusicPlayer_GetSongNum() - playlistbtns;
		end

		if (list == "playlist") then
			MusicPlayer_PlayerFrame_Playlist_List_ScrollFrame:SetVerticalScroll(searchednum*20);
			MusicPlayer_PlayerFrame_Playlist_List_ScrollFrame:UpdateScrollChildRect();
			MusicPlayerPlaylistUpdate();
		end
	else
		MPPC(MP_Yellow..format(MusicPlayer_CantFindSong, text), 1);
	end
end



function MusicPlayer_PlayerFrame_ToggleSearchBox()
	if (MusicPlayer_PlayerFrame_SearchFrame:IsVisible()) then
		MusicPlayer_PlayerFrame_SearchFrame:Hide();
	else
		MusicPlayer_PlayerFrame_SearchFrame:Show();
	end
end










-------------------------------------------------------------------------------------
function MPPC(msg, prefix, r, g, b)
	if prefix then
		msg = MP_Yellow.."<MusicPlayer> "..msg;
	end
	if not r then
		r,g,b = 1,1,1;
	end

	DEFAULT_CHAT_FRAME:AddMessage(msg, r, g, b);
end

-- Stop the music after a ReloadUI
function MusicPlayer_ReloadUI()
	StopMusic();
	SetCVar("Sound_EnableMusic", MusicPlayerFrameOptions.MusicAfterStop);
end

-- Stop the music after logging out
function MusicPlayer_Logout()
	StopMusic();

	MusicPlayer_SongTime_START = 0;
	MusicPlayer_SongTime_END = 0;

	MP_SongIsPlaying = 0;
	SetCVar("Sound_EnableMusic", MusicPlayerFrameOptions.MusicAfterStop);

	MusicPlayer_StartStopUpdate("stop");
end

-- Show the itemref tooltip when an itemlink from MusicPlayer is found
function MusicPlayer_SetItemRef(link, text, button)
	if (strsub(link, 1, 11) == "musicplayer") then

		if (IsShiftKeyDown()) then
			StaticPopupDialogs["MUSICPLAYER_SONGLINK"].text = format(MusicPlayer_SendSongLinkTo..MP_White, text);
			StaticPopupDialogs["MUSICPLAYER_SONGLINK"].link = text;
			StaticPopup_Show("MUSICPLAYER_SONGLINK");
			return;

		else
			local a, b, mptext, title, artist, album, quality, genre = strfind(link, "(.+):(.+):(.+):(.+):(.+):(.+)");


			MusicPlayer_ShowItemRef(title, artist, album, quality, genre);
			return;
		end
	end

	MusicPlayer_SetItemRef_orig(link, text, button);
end

function MusicPlayer_CreateChatLink(title)
	local artist = "";
	local album = "";
	local quality = "";
	local genre = "";

	for k, v in pairs(MusicPlayerSongs) do
		if MusicPlayerSongs[k]["Title"] == title then
			artist = MusicPlayerSongs[k]["Artist"];
			album = MusicPlayerSongs[k]["Album"];
			quality = MusicPlayerSongs[k]["Quality"];
			genre = MusicPlayerSongs[k]["Genre"];
			break;
		end
	end

	-- Make sure there will be no nil values that gets returned.
	if (artist == nil) then artist = "Unknown Artist"; end
	if (album == nil) then album = "Unknown Album"; end
	if (quality == nil) then quality = "Unknown Quality"; end
	if (genre == nil) then genre = "Unknown Genre"; end

	local link = "|Hmusicplayer:"..title..":"..artist..":"..album..":"..quality..":"..genre.."|h"..MP_Legendary.."["..title.."]|r|h"..MP_Yellow;
	return link;
end

function MusicPlayer_ChatLink_WaitingForReply(self, elapsed)
	this.waiting = this.waiting + elapsed;

	if (this.waiting >= 2) then
		MPPC(MP_Yellow..format(MusicPlayer_UserDidNotReceiveLink, this.receiver, this.link), true, 1,1,0);
		this.waiting = 0;
		this.stop = 0;
		this:SetScript("OnUpdate", nil);
		return;
	elseif (this.stop == 1) then
		this.waiting = 0;
		this.stop = 0;
		this:SetScript("OnUpdate", nil);
		return;
	end
end

function MusicPlayer_Announce(chattype)
	if (MP_SongIsPlaying > 0) then
		chattype = strupper(chattype);		
		if (chattype == "PARTY") or (chattype == "SAY") or (chattype == "RAID") or (chattype == "GUILD") or (chattype == "") then
			-- if chattype == nil then it defaults it to "SAY".
			local title = "'"..MusicPlayerSongs[MP_SongIsPlaying]["Title"].."'";

			local artist = MusicPlayerSongs[MP_SongIsPlaying]["Artist"];
			if (artist == "Unknown Artist") then
				artist = "";
			else
				artist = " by "..artist;
			end


			local genre = MusicPlayerSongs[MP_SongIsPlaying]["Genre"];
			if (genre == "Unknown Genre") then
				genre = "";
			else
				genre = " ("..genre..")";
			end

			-- Default to "SAY" if theres no chattype.
			if (chattype == "") then
				chattype = nil;
			end

			SendChatMessage("Playing "..title..artist..genre, chattype);
			-- Appears as "Playing 'title' by artist (genre)", if all categories exist.
		else
			MPPC(MP_Yellow..MusicPlayer_UnknownChattype, 1);
		end
	end
end

-------------------------------------------------------------------------------------

function MP_Frame_Lock()
	PlaySound("igMainMenuOptionCheckBoxOn");
	MusicPlayerFrameOptions.lock = 1;
end

function MP_Frame_ToggleLock()
	if (MusicPlayerFrameOptions.lock == 1) then
		MusicPlayerFrameOptions.lock = 0;
	else
		MusicPlayerFrameOptions.lock = 1;
	end
end

function MP_Frame_UnLock()
	PlaySound("igMainMenuOptionCheckBoxOff");
	MusicPlayerFrameOptions.lock = 0;
end


-------------------------------------------------------------------------------------


function MusicPlayer_OnLoad()
	this:RegisterEvent("CHAT_MSG_ADDON");
	this:RegisterEvent("ADDON_LOADED");

	-- Voice Chat events
	this:RegisterEvent("VOICE_START");
	this:RegisterEvent("VOICE_STOP");
	this:RegisterEvent("VOICE_PUSH_TO_TALK_STOP");
	this:RegisterEvent("VOICE_PUSH_TO_TALK_START");
	this.VoiceChat = 0;

	-- Blizz, please stop making changes to the soundsystem. This fix is back for the 3rd time now.
	this:RegisterEvent("PLAYER_ENTERING_WORLD");
end

-- Used for UserDidNotReceiveSongLink 
local MusicPlayer_LinkerFrame = CreateFrame("frame");
MusicPlayer_LinkerFrame.waiting = 0;
MusicPlayer_LinkerFrame.stop = 0;

function MusicPlayer_OnEvent(self, event, ...)

	if (event == "ADDON_LOADED" and arg1 == "MusicPlayer") then
		-- Initialize the addon
		MusicPlayerFrame_Initialize();
		hooksecurefunc("SetCVar", MusicPlayer_OnCVarUpdate);
	elseif (event == "PLAYER_ENTERING_WORLD") then
		if (MP_SongIsPlaying ~= 0) then
			StopMusic();
			MusicPlayer_SongTime_START = 0;
			MusicPlayer_SongTime_END = 0;

			MP_SongIsPlaying = 0;
			SetCVar("Sound_EnableMusic", MusicPlayerFrameOptions.MusicAfterStop);

			MusicPlayer_StartStopUpdate("stop");
		end
		MusicPlayerPlaylistUpdate();

	elseif (event == "CHAT_MSG_ADDON") then
		if (arg1 == "MusicPlayer_SendingLink") then
			MPPC(MP_Yellow..format(MusicPlayer_ReceivedSongLink, arg2, arg4), true, 1,1,0);
			SendAddonMessage("MusicPlayer_Reply", arg2, "Whisper", arg4);

		elseif (arg1 == "MusicPlayer_Reply") then
			MPPC(MP_Yellow..format(MusicPlayer_UserReceivedLink, arg4, arg2), true);
			MusicPlayer_LinkerFrame.stop = 1;
		end

	elseif (event == "VOICE_START" or event == "VOICE_PUSH_TO_TALK_START") then
		if (MusicPlayer_Updater.VoiceChat == 0) then
			MusicPlayer_Updater.VoiceChat = 1;
			local newVolume = GetCVar("ChatMusicVolume");
			SetCVar("Sound_MusicVolume", newVolume);
		end

	elseif (event == "VOICE_STOP" or event == "VOICE_PUSH_TO_TALK_STOP") then
		if (MusicPlayer_Updater.VoiceChat == 1) then
			MusicPlayer_Updater.VoiceChat = 0;
			SetCVar("Sound_MusicVolume", MusicPlayer_MusicVolume);
		end
	end
end

function MusicPlayer_OnCVarUpdate()
	if (MusicPlayer_Updater.VoiceChat == 0) then
		MusicPlayer_MusicVolume = GetCVar("Sound_MusicVolume");
	end
	MP_OldMasterVolume = GetCVar("Sound_MasterVolume");
end

-- Real to sorted
function MusicPlayer_Songs_NumberConverter(realnumber)

	if MusicPlayerSongs_Sorted_ValueToIndex[realnumber] then
		return MusicPlayerSongs_Sorted_ValueToIndex[realnumber];
	end

	return nil;
end


function MusicPlayer_UpdateKeybindings()
	BINDING_HEADER_MUSICPLAYER = "MusicPlayer";

	BINDING_NAME_Stop_Music = "Stop Music";
	BINDING_NAME_Next_Song = "Next Song";
	BINDING_NAME_Previous_Song = "Previous Song";
	BINDING_NAME_MusicPlayer_Mute = "Mutes sound when held";
	BINDING_NAME_MusicPlayer_IncreaseVolume = "Increase Music Volume";
	BINDING_NAME_MusicPlayer_DecreaseVolume = "Decrease Music Volume";
end

-------------------------------------------------------------------------------------
-------------------------------------------------------------------------------------

function MusicPlayer_SlashCommandHandler(msg)
	local a, b, command, subcommand = strfind(msg, "([%w_]*)[ ]*(.*)");

	if( command == "" ) then
		MusicPlayerHelpFrame:Show();
		return;
	else
		command = strlower(command);
		if (subcommand) then
			MusicPlayer_SlashCommands["SubCmd"] = strlower(subcommand);
		end
	end

	if MusicPlayer_SlashCommands[command] then
		MusicPlayer_SlashCommands[command]();
	else
		MPPC(MP_Yellow..MusicPlayer_UnknownCommand, 1);
	end
end

--------------------------------------------------------------------------------------------------

function MusicPlayer_OnUpdate(self, elapsed)

	local Status = GetTime();

	if(Status >= MusicPlayer_SongTime_END) then
		MusicPlayer_SongTime_START = Status;
		MusicPlayer_SongTime_END = Status + MusicPlayerSongs[MP_SongIsPlaying]["Duration"];
	end

	local lasted = Status - MusicPlayer_SongTime_START;

	MusicPlayer_SecsRemaining = MusicPlayerSongs[MP_SongIsPlaying]["Duration"] - lasted;


	local secsremaining = format("%d:%02d", MusicPlayer_SecsRemaining / 60, mod(MusicPlayer_SecsRemaining, 60));
	local duration = format("%d:%02d", MusicPlayerSongs[MP_SongIsPlaying]["Duration"] /60, mod(MusicPlayerSongs[MP_SongIsPlaying]["Duration"], 60));


	if (MusicPlayer_FubarPlugin) then
		MusicPlayer_FubarPlugin:SetText(MusicPlayerSongs[MP_SongIsPlaying]["Title"].." ("..secsremaining.." / "..duration..")");
	end
	if (MusicPlayer_TitanPluginLoaded) then
		MusicPlayerTitanText = MusicPlayerSongs[MP_SongIsPlaying]["Title"].." ("..secsremaining.." / "..duration..")";
	end

	if (MusicPlayerFrameOptions.StatusBar == 1) then
		MusicPlayer_PlayerFrame_StatusBar:Show();
		MusicPlayer_PlayerFrame_StatusBar:SetValue(lasted);
		MusicPlayer_PlayerFrame:SetHeight(95);
	else
		MusicPlayer_PlayerFrame_StatusBar:Hide();
		MusicPlayer_PlayerFrame:SetHeight(75);
	end

	MusicPlayer_PlayerFrame_SongName:SetText(MusicPlayerSongs[MP_SongIsPlaying]["Title"]);
	MusicPlayer_PlayerFrame_SongDur:SetText(secsremaining);
	MusicPlayer_PlayerFrame_SongLength:SetText(duration);


	if (floor(MusicPlayer_SecsRemaining + .7) == 0) then

		self:SetScript("OnUpdate", nil);

		if (MusicPlayer_PlayingEnqueued == 1) then
			MusicPlayerMediaLibrary_Enqueue_PlayEnqueued();
		elseif (MusicPlayerFrameOptions.Shuffle == 1) then
			MusicPlayer_PlayRandomSong();
		elseif (MusicPlayerFrameOptions.PlayWhenFinished == 1) then
			if(MusicPlayerFrameOptions.WhenFinished == 11)then
				MusicPlayer_PlayNextSong();
			elseif(MusicPlayerFrameOptions.WhenFinished == 12)then
				MusicPlayer_PlayRandomSong();
			elseif(MusicPlayerFrameOptions.WhenFinished == 13)then
				MusicPlayer_PlaySong(MP_SongIsPlaying);	
			end
		else
			if(MusicPlayerFrameOptions.ShowSpam == 1)then
				MPPC(MP_Yellow.."Song Finished.", 1);
			end
			StopMusic();
			MP_SongIsPlaying = 0;
			SetCVar("Sound_EnableMusic", MusicPlayerFrameOptions.MusicAfterStop);

			MusicPlayer_SongTime_START = 0;
			MusicPlayer_SongTime_END = 0;

			MusicPlayer_StartStopUpdate("stop");
		end
	end

end

function MusicPlayer_StartStopUpdate(update)
	if (update == "start") then

		MusicPlayer_PlayerFrame_StatusBar:SetMinMaxValues(0, MusicPlayerSongs[MP_SongIsPlaying]["Duration"]);
		MusicPlayer_Updater:SetScript("OnUpdate", function(self, elapsed) MusicPlayer_OnUpdate(self, elapsed) end);

		MusicPlayerPlaylistUpdate();
	elseif (update == "stop") then

		MusicPlayer_PlayerFrame_SongName:SetText("MusicPlayer");
		MusicPlayer_PlayerFrame_SongDur:SetText(MP_version);
		MusicPlayer_PlayerFrame_SongLength:SetText("");
		MusicPlayer_PlayerFrame_StatusBar:Hide();
		MusicPlayer_PlayerFrame:SetHeight(75);

		if (MusicPlayer_FubarPlugin) then
			MusicPlayer_FubarPlugin:SetText("MusicPlayer");
		end
		if (MusicPlayer_TitanPluginLoaded) then
			MusicPlayerTitanText = "MusicPlayer";
		end

		MusicPlayer_Updater:SetScript("OnUpdate", nil);
	end
end


--------------------------------------------------------------------------------------------------
-- Initialize functions
--------------------------------------------------------------------------------------------------

-- Initialize the addon
function MusicPlayerFrame_Initialize()

	-- Initialize the options
	MusicPlayerFrame_InitializeOptions();
	
	-- Initialize the display
	MusicPlayerFrame_Update();

	SLASH_MUSICPLAYER1 = "/musicplayer";
	SLASH_MUSICPLAYER2 = "/mp";
	SLASH_MUSICPLAYER3 = "/music";
	SlashCmdList["MUSICPLAYER"] = function(msg)
		MusicPlayer_SlashCommandHandler(msg);
	end

	SLASH_MUSICPLAYERFRAME1 = "/mpf";
	SLASH_MUSICPLAYERFRAME2 = "/musicplayerframe";
	SLASH_MUSICPLAYERFRAME3 = "/mpdisplay";
	SLASH_MUSICPLAYERFRAME4 = "/mpframe";
	SlashCmdList["MUSICPLAYERFRAME"] = function()
		if (MusicPlayerOptionsFrame:IsVisible()) then
			MusicPlayerOptionsFrame:Hide();
			PlaySound("igCharacterInfoClose");
		else
			MusicPlayerOptionsFrame:Show();
			PlaySound("igCharacterInfoOpen");
		end
	end
	MusicPlayer_SlashCommands = {
		["SubCmd"] = "";
		["play"] = function() for i=1,MusicPlayer_GetSongNum() do if (MusicPlayer_SlashCommands["SubCmd"] == strlower(MusicPlayerSongs[i]["Title"]))
			then MusicPlayer_PlaySong(i); return; end end MPPC(MP_Yellow..format(MusicPlayer_CantFindSong, MusicPlayer_SlashCommands[SubCmnd]), 1); end,
		["announce"] = function() MusicPlayer_Announce(MusicPlayer_SlashCommands["SubCmd"]); return; end,
		["enqueue"] = function() for i=1,MusicPlayer_GetSongNum() do if (MusicPlayer_SlashCommands["SubCmd"] == strlower(MusicPlayerSongs[i]["Title"]))
			then tinsert(MusicPlayer_EnqueueTable, i); MPPC(MP_Yellow..format(MusicPlayer_Enqueue_Add, MusicPlayerSongs[i]["Title"]), 1); return; end
			end MPPC(MP_Yellow..format(MusicPlayer_CantFindSong, MusicPlayer_SlashCommands["SubCmd"]), 1); end,
		["volume"] = function() 
			if (MusicPlayer_SlashCommands["SubCmd"] == "up") then
				MusicPlayer_KeybinidingVolume("+");
				return;
			elseif (MusicPlayer_SlashCommands["SubCmd"] == "down") then
				MusicPlayer_KeybinidingVolume("-");
				return;
			end
			if (type(tonumber(MusicPlayer_SlashCommands["SubCmd"])) == "number") then
				MusicPlayer_SlashCommands["SubCmd"] = tonumber(MusicPlayer_SlashCommands["SubCmd"]);
	
				if (MusicPlayer_SlashCommands["SubCmd"] >= 10) then
					MusicPlayer_SlashCommands["SubCmd"] = 1;
				elseif (MusicPlayer_SlashCommands["SubCmd"] >= 1) and (MusicPlayer_SlashCommands["SubCmd"] <= 10) then
					MusicPlayer_SlashCommands["SubCmd"] = MusicPlayer_SlashCommands["SubCmd"] / 10;
				elseif (MusicPlayer_SlashCommands["SubCmd"] < 0) then
					MusicPlayer_SlashCommands["SubCmd"] = 0;
				end
				MusicPlayer_SetVolume(MusicPlayer_SlashCommands["SubCmd"]);
			else
				MPPC(MP_Yellow..MusicPlayer_InsertNumber, 1);
			end end,
		--["vol"] = MusicPlayer_SlashCommands["volume"],
		["help"] = function() MP_ToggleHelp(); MusicPlayerStop(); end,
		["stop"] = function() MusicPlayerStop(); end,
		["next"] = function() MusicPlayer_PlayNextSong() end,
		["prev"] = function() MusicPlayer_PlayPrevSong() end,
		["options"] = function() MP_ToggleOptions() end,
		["togglelock"] = function() MP_Frame_ToggleLock() end,
		["lock"] = function() MP_Frame_Lock() end,
		["unlock"] = function() MP_Frame_UnLock() end,
		["show"] = function() MusicPlayer_PlayerFrame:Show(); MusicPlayerFrameOptions["showFrame"] = 1; end,
		["hide"] = function() MusicPlayer_PlayerFrame:Hide(); MusicPlayerFrameOptions["showFrame"] = 0; end,
		["favecurrent"] = function() if MPML then MusicPlayerMediaLibrary_Favorites_AddSong(MP_SongIsPlaying); else MPPC(MP_Yellow..MusicPlayer_UnknownCommand, 1); end end,
		["playqueue"] = function() if MPML then MusicPlayerMediaLibrary_Enqueue_PlayEnqueued(); else MPPC(MP_Yellow..MusicPlayer_UnknownCommand, 1); end end,
		--["playenqueued"] = MusicPlayer_SlashCommands["playqueue"],
	};





	-- Hooks
	--hooksecurefunc("SetItemRef", function(link, text, button) MusicPlayer_SetItemRef(link, text, button) end);
	hooksecurefunc("ReloadUI", MusicPlayer_ReloadUI);
	hooksecurefunc("Logout", MusicPlayer_Logout);

	MusicPlayer_SetItemRef_orig = SetItemRef;
	SetItemRef = MusicPlayer_SetItemRef;

	--MusicPlayer_ReloadUI_Orig = ReloadUI;
	--ReloadUI = MusicPlayer_ReloadUI;

	--MusicPlayer_Logout_Orig = Logout;
	--Logout = MusicPlayer_Logout_Orig;

	StaticPopupDialogs["MUSICPLAYER_SONGLINK"] = {
		text = "",
		button1 = ACCEPT,
		button2 = CANCEL,
		hasEditBox = 1,
		link = "";
		OnAccept = function()
			if (text ~= "") and (text ~= nil) then
				local text = getglobal(this:GetParent():GetName().."EditBox"):GetText();

				MusicPlayer_LinkerFrame.link = secondArg;
				MusicPlayer_LinkerFrame.receiver = fourthArg;
				MusicPlayer_LinkerFrame:SetScript("OnUpdate", function(self, elapsed) MusicPlayer_ChatLink_WaitingForReply(self, elapsed) end);

				SendAddonMessage( "MusicPlayer_SendingLink", StaticPopupDialogs["MUSICPLAYER_SONGLINK"].link, "Whisper", text);
			end
		end,
		EditBoxOnEnterPressed = function()
			local text = getglobal(this:GetParent():GetName().."EditBox"):GetText();
			if (text ~= "") and (text ~= nil) then

				MusicPlayer_LinkerFrame.link = StaticPopupDialogs["MUSICPLAYER_SONGLINK"].link;
				MusicPlayer_LinkerFrame.receiver = text;
				MusicPlayer_LinkerFrame:SetScript("OnUpdate", function(self, elapsed) MusicPlayer_ChatLink_WaitingForReply(self, elapsed) end);

				SendAddonMessage( "MusicPlayer_SendingLink", StaticPopupDialogs["MUSICPLAYER_SONGLINK"].link, "Whisper", text);
				this:GetParent():Hide();
			end
		end,
		OnHide = function()
			getglobal(this:GetName().."EditBox"):SetText("");
		end,

		timeout = 0,
		exclusive = 1,
		whileDead = 1,
		hideOnEscape = 1
	};
	StaticPopupDialogs["MUSICPLAYER_RESETOPTIONS"] = {
		text = MusicPlayer_ResetOptionsQuestion,
		button1 = ACCEPT,
		button2 = CANCEL,
		OnAccept = function()
			MusicPlayer_Defaults();
			ReloadUI();
		end,
		OnHide = function()
		end,

		timeout = 0,
		exclusive = 1,
		whileDead = 1,
		hideOnEscape = 1
	};
	StaticPopupDialogs["MUSICPLAYER_RESETCOLORS"] = {
		text = MusicPlayer_ResetColorsQuestion,
		button1 = ACCEPT,
		button2 = CANCEL,
		OnAccept = function()
			MusicPlayer_ResetColorsToDefault();
			ReloadUI();
		end,
		OnHide = function()
		end,

		timeout = 0,
		exclusive = 1,
		whileDead = 1,
		hideOnEscape = 1
	};


	MPPC(MusicPlayer_Login_Msg, 1);
end


-- Initialize the options
function MusicPlayerFrame_InitializeOptions()

	-- Load the default playlist
	-- if no playlist is found
	if (MusicPlayer_Playlist == nil) then
		MusicPlayer_Playlist = MusicPlayerSongs;
	else
		MusicPlayerSongs = MusicPlayer_Playlist;
	end

	-- Create the favorite table
	if (not MusicPlayer_Favorites) or (type(MusicPlayer_Favorites[1]) == "number") then
		MusicPlayer_Favorites = {};
	end

	-- Create the queue table
	MusicPlayer_EnqueueTable = {};


	-----------------------------------------------------
	-- Necessary for Reset colors
	MusicPlayer_ColorDefaults = {
		[1] = {
			[1] = 1,
			[2] = 0,
			[3] = 0,
		},
		[2] = {
			[1] = 0,
			[2] = 0,
			[3] = 0,
		},
		[3] = {
			[1] = 0.356,
			[2] = 0.356,
			[3] = 0.356,
		},
		[4] = {
			[1] = 1,
			[2] = 0,
			[3] = 0,
		},
	};


	-- Load the defaults if no table is found.
	if (not MusicPlayerFrameOptions) then
		MusicPlayer_Defaults();
	end


	if not (MusicPlayerFrameOptions.NumPlaylistButtons) then
		MusicPlayerFrameOptions.NumPlaylistButtons = 10;
	end


	-- Sort the lists
	MusicPlayer_SortSongs();

	-- Show the playlist Buttons
	MusicPlayer_SetNumPlaylistButtons(MusicPlayerFrameOptions.NumPlaylistButtons);

	-----------------------------------------------------

	MusicPlayer_PlayerFrame_Playlist_Shuffle:SetChecked(MusicPlayerFrameOptions.Shuffle);

	-----------------------------------------------------

	MusicPlayerOptionsFrame_GeneralSettingsFrame_FinishedCheckButton:SetChecked(MusicPlayerFrameOptions.PlayWhenFinished);

	MusicPlayerOptionsFrame_GeneralSettingsFrame_ShowSpam_CheckButton:SetChecked(MusicPlayerFrameOptions.ShowSpam);

	MusicPlayerOptionsFrame_GeneralSettingsFrame_ShowMinimapButton_CheckButton:SetChecked(MusicPlayerFrameOptions.MinimapButton);

	UIDropDownMenu_SetSelectedValue(MusicPlayerOptionsFrame_GeneralSettingsFrame_FinishedDropDown, MusicPlayerFrameOptions.WhenFinished);

	-----------------------------------------------------

	MusicPlayerOptionsFrame_PlayerSettingsFrame_ShowPlayer_CheckButton:SetChecked(MusicPlayerFrameOptions.showFrame);
	MusicPlayerOptionsFrame_PlayerSettingsFrame_LockPlayer_CheckButton:SetChecked(MusicPlayerFrameOptions.lock);
	MusicPlayerOptionsFrame_PlayerSettingsFrame_ShowTimerBar_CheckButton:SetChecked(MusicPlayerFrameOptions.StatusBar);
	MusicPlayerOptionsFrame_PlayerSettingsFrame_ShowSongTooltip_CheckButton:SetChecked(MusicPlayerFrameOptions.playertooltip);

	MusicPlayerOptionsFrame_PlayerSettingsFrame_PlaylistButtons_Slider:SetValue(MusicPlayerFrameOptions.NumPlaylistButtons);

	---------

	MusicPlayerOptionsFrame_PlayerVisualsFrame_Scale_Slider:SetValue(MusicPlayerFrameOptions.Scale * 100);
	MusicPlayerOptionsFrame_PlayerVisualsFrame_Alpha_Slider:SetValue(MusicPlayerFrameOptions.alpha1 * 100);
	MusicPlayerOptionsFrame_PlayerVisualsFrame_PlaylistWidth_Slider:SetValue(MusicPlayerFrameOptions.PlayerWidth);

	---------

	UIDropDownMenu_SetSelectedValue(MusicPlayerOptionsFrame_PlayerVisualsFrame_FrameStrata_DropDown, MusicPlayerFrameOptions.PlayerFrameStrata);
	UIDropDownMenu_SetSelectedValue(MusicPlayerOptionsFrame_PlayerVisualsFrame_PlaylistAnchor_DropDown, MusicPlayerFrameOptions.PlaylistLoc);

	---------

	MusicPlayerOptionsFrame_PlaylistFormattingFrame_Indexnumber_CheckButton:SetChecked(MusicPlayerFrameOptions.playlistformatting["Indexnumber"]);
	MusicPlayerOptionsFrame_PlaylistFormattingFrame_Duration_CheckButton:SetChecked(MusicPlayerFrameOptions.playlistformatting["Duration"]);
	MusicPlayerOptionsFrame_PlaylistFormattingFrame_Favoritemark_CheckButton:SetChecked(MusicPlayerFrameOptions.playlistformatting["Favoritemark"]);
	MusicPlayerOptionsFrame_PlaylistFormattingFrame_Queuenumber_CheckButton:SetChecked(MusicPlayerFrameOptions.playlistformatting["Queuenumber"]);

	UIDropDownMenu_SetSelectedValue(MusicPlayerOptionsFrame_PlaylistFormattingFrame_Text1_DropDown, MusicPlayerFrameOptions.playlistformatting[1]);
	UIDropDownMenu_SetSelectedValue(MusicPlayerOptionsFrame_PlaylistFormattingFrame_Text2_DropDown, MusicPlayerFrameOptions.playlistformatting[2]);
	UIDropDownMenu_SetSelectedValue(MusicPlayerOptionsFrame_PlaylistFormattingFrame_Text3_DropDown, MusicPlayerFrameOptions.playlistformatting[3]);

	-----------------------------------------------------

	UIDropDownMenu_Initialize(MusicPlayer_PlayerFrame_SearchFrame_SortBy_DropDown, MusicPlayer_PlayerFrame_SearchFrame_SortBy_DropDown_Initialize);
	UIDropDownMenu_SetWidth(80, MusicPlayer_PlayerFrame_SearchFrame_SortBy_DropDown);
	UIDropDownMenu_SetSelectedValue(MusicPlayer_PlayerFrame_SearchFrame_SortBy_DropDown, MusicPlayerFrameOptions.SearchSortBy);


	local search_sortby = {
		[1] = MusicPlayer_Title,
		[2] = MusicPlayer_Artist,
		[3] = MusicPlayer_Album,
		[4] = MusicPlayer_Genre,
		[5] = MusicPlayer_Quality,
	};

	UIDropDownMenu_SetText(search_sortby[MusicPlayerFrameOptions.SearchSortBy], MusicPlayerOptionsFrame_PlayerVisualsFrame_PlaylistAnchor_DropDown);

	search_sortby = nil;

	MusicPlayer_UpdateKeybindings();
end

function MusicPlayer_Defaults()
	MusicPlayerFrameOptions = {};

	MusicPlayerFrameOptions.Shuffle = 0;
	MusicPlayerFrameOptions.ShowSpam = 0;
	MusicPlayerFrameOptions.PlayWhenFinished = 1;
	MusicPlayerFrameOptions.MusicAfterStop = 0;
	MusicPlayerFrameOptions.MinimapButton = 1;
	MusicPlayerFrameOptions.WhenFinished = 11;
	MusicPlayerFrameOptions.showFrame = 1;
	MusicPlayerFrameOptions.lock = 0;
	MusicPlayerFrameOptions.StatusBar = 1;
	MusicPlayerFrameOptions.playertooltip = 0;
	MusicPlayerFrameOptions.DisplayHelp = 1;
	MusicPlayerFrameOptions.Scale = 1.0;
	MusicPlayerFrameOptions.alpha1 = 1.0;
	MusicPlayerFrameOptions.PlayerWidth = 175;
	MusicPlayerFrameOptions.PlayerFrameStrata = 2;
	MusicPlayerFrameOptions.PlaylistLoc = 2;
	MusicPlayerFrameOptions.NumPlaylistButtons = 10;

	MusicPlayerFrameOptions.Color = MusicPlayer_ColorDefaults;

	MusicPlayerFrameOptions.PlaylistSortBy = "Title";

	MusicPlayerFrameOptions.playlistformatting = {};
	MusicPlayerFrameOptions.playlistformatting[1] = 1;
	MusicPlayerFrameOptions.playlistformatting[2] = 6;
	MusicPlayerFrameOptions.playlistformatting[3] = 6;
	MusicPlayerFrameOptions.playlistformatting["Indexnumber"] = 0;
	MusicPlayerFrameOptions.playlistformatting["Duration"] = 1;
	MusicPlayerFrameOptions.playlistformatting["Favoritemark"] = 1;
	MusicPlayerFrameOptions.playlistformatting["Queuenumber"] = 1;

	MusicPlayerFrameOptions.SearchSortBy = 1;
end




function MusicPlayer_PlayerFrame_SearchFrame_SortBy_DropDown_OnClick()

	-- Save the selected option
	UIDropDownMenu_SetSelectedValue(MusicPlayer_PlayerFrame_SearchFrame_SortBy_DropDown, this.value);
	MusicPlayerFrameOptions.SearchSortBy = this.value;
end


function MusicPlayer_PlayerFrame_SearchFrame_SortBy_DropDown_Initialize()

	local info = UIDropDownMenu_CreateInfo();
	info.text = MusicPlayer_Title;
	info.func = MusicPlayer_PlayerFrame_SearchFrame_SortBy_DropDown_OnClick;
	info.value = 1;
	UIDropDownMenu_AddButton(info);

	local info = UIDropDownMenu_CreateInfo();
	info.text = MusicPlayer_Artist;
	info.func = MusicPlayer_PlayerFrame_SearchFrame_SortBy_DropDown_OnClick;
	info.value = 2;
	UIDropDownMenu_AddButton(info);

	local info = UIDropDownMenu_CreateInfo();
	info.text = MusicPlayer_Album;
	info.func = MusicPlayer_PlayerFrame_SearchFrame_SortBy_DropDown_OnClick;
	info.value = 3;
	UIDropDownMenu_AddButton(info);

	local info = UIDropDownMenu_CreateInfo();
	info.text = MusicPlayer_Genre;
	info.func = MusicPlayer_PlayerFrame_SearchFrame_SortBy_DropDown_OnClick;
	info.value = 4;
	UIDropDownMenu_AddButton(info);

	local info = UIDropDownMenu_CreateInfo();
	info.text = MusicPlayer_Quality;
	info.func = MusicPlayer_PlayerFrame_SearchFrame_SortBy_DropDown_OnClick;
	info.value = 5;
	UIDropDownMenu_AddButton(info);
end


function MusicPlayer_ResetColors_OnClick()
	StaticPopup_Show("MUSICPLAYER_RESETCOLORS");
end

function MusicPlayer_ResetColorsToDefault()
	local r, g, b = MusicPlayer_ColorDefaults[1][1], MusicPlayer_ColorDefaults[1][2], MusicPlayer_ColorDefaults[1][3];
	MusicPlayer_SetColorSub(MusicPlayerOptionsFrame_SelectColor_Text, r, g, b);
	local r, g, b = MusicPlayer_ColorDefaults[2][1], MusicPlayer_ColorDefaults[2][2], MusicPlayer_ColorDefaults[2][3];
	MusicPlayer_SetColorSub(MusicPlayerOptionsFrame_SelectColor_BG, r, g, b);
	local r, g, b = MusicPlayer_ColorDefaults[3][1], MusicPlayer_ColorDefaults[3][2], MusicPlayer_ColorDefaults[3][3];
	MusicPlayer_SetColorSub(MusicPlayerOptionsFrame_SelectColor_Borders, r, g, b);
	local r, g, b = MusicPlayer_ColorDefaults[4][1], MusicPlayer_ColorDefaults[4][2], MusicPlayer_ColorDefaults[4][3];
	MusicPlayer_SetColorSub(MusicPlayerOptionsFrame_SelectColor_Bars, r, g, b);
end

function MP_ToggleHelp()
	if MusicPlayerHelpFrame:IsVisible() then
		MusicPlayerHelpFrame:Hide();
	else
		MusicPlayerHelpFrame:Show();
	end
end

function MP_ToggleOptions()
	if (MusicPlayerOptionsFrame:IsVisible()) then
		MusicPlayerOptionsFrame:Hide();
		PlaySound("igCharacterInfoClose");
	else
		MusicPlayerOptionsFrame:Show();
		PlaySound("igCharacterInfoOpen");
	end

end

--------------------------------------------------------------------------------------------------
-- Display functions
--------------------------------------------------------------------------------------------------

function MusicPlayerFrame_UpdateAnchors()
	local playlistanchor = {
		[1] = { "BOTTOM", "MusicPlayer_PlayerFrame", "TOP" },
		[2] = { "TOP", "MusicPlayer_PlayerFrame", "BOTTOM" },
		[3] = { "RIGHT", "MusicPlayer_PlayerFrame", "LEFT" },
		[4] = { "TOPRIGHT", "MusicPlayer_PlayerFrame", "TOPLEFT" },
		[5] = { "BOTTOMRIGHT", "MusicPlayer_PlayerFrame", "BOTTOMLEFT" },
		[6] = { "LEFT", "MusicPlayer_PlayerFrame", "RIGHT" },
		[7] = { "TOPLEFT", "MusicPlayer_PlayerFrame", "TOPRIGHT" },
		[8] = { "BOTTOMLEFT", "MusicPlayer_PlayerFrame", "BOTTOMRIGHT" },
	};

	local searchanchor = {
		[1] = { "BOTTOM", "MusicPlayer_PlayerFrame_Playlist", "TOP" },
		[2] = { "TOP", "MusicPlayer_PlayerFrame_Playlist", "BOTTOM" },
		[3] = { "TOP", "MusicPlayer_PlayerFrame_Playlist", "BOTTOM" },
		[4] = { "TOP", "MusicPlayer_PlayerFrame_Playlist", "BOTTOM" },
		[5] = { "BOTTOM", "MusicPlayer_PlayerFrame_Playlist", "TOP" },
		[6] = { "TOP", "MusicPlayer_PlayerFrame_Playlist", "BOTTOM" },
		[7] = { "TOP", "MusicPlayer_PlayerFrame_Playlist", "BOTTOM" },
		[8] = { "BOTTOM", "MusicPlayer_PlayerFrame_Playlist", "TOP" },
	};


	local num = MusicPlayerFrameOptions.PlaylistLoc;

	MusicPlayer_PlayerFrame_Playlist:ClearAllPoints();
	MusicPlayer_PlayerFrame_Playlist:SetPoint(playlistanchor[num][1], playlistanchor[num][2], playlistanchor[num][3]);

	MusicPlayer_PlayerFrame_SearchFrame:ClearAllPoints();
	MusicPlayer_PlayerFrame_SearchFrame:SetPoint(searchanchor[num][1], searchanchor[num][2], searchanchor[num][3]);
end

function MusicPlayerFrame_UpdateColors()

	-- Player Frame

	MusicPlayer_PlayerFrame:SetBackdropColor(MusicPlayerFrameOptions.Color[2][1], MusicPlayerFrameOptions.Color[2][2], MusicPlayerFrameOptions.Color[2][3]);
	MusicPlayer_PlayerFrame:SetBackdropBorderColor(MusicPlayerFrameOptions.Color[3][1], MusicPlayerFrameOptions.Color[3][2], MusicPlayerFrameOptions.Color[3][3]);

	MusicPlayer_PlayerFrame_Window:SetBackdropBorderColor(MusicPlayerFrameOptions.Color[3][1], MusicPlayerFrameOptions.Color[3][2], MusicPlayerFrameOptions.Color[3][3]);

	MusicPlayer_PlayerFrame_Stop_Text:SetTextColor(MusicPlayerFrameOptions.Color[1][1], MusicPlayerFrameOptions.Color[1][2], MusicPlayerFrameOptions.Color[1][3]);
	MusicPlayer_PlayerFrame_Toggle_Text:SetTextColor(MusicPlayerFrameOptions.Color[1][1], MusicPlayerFrameOptions.Color[1][2], MusicPlayerFrameOptions.Color[1][3]);

	MusicPlayer_PlayerFrame_SongName:SetTextColor(MusicPlayerFrameOptions.Color[1][1], MusicPlayerFrameOptions.Color[1][2], MusicPlayerFrameOptions.Color[1][3]);
	MusicPlayer_PlayerFrame_SongDur:SetTextColor(MusicPlayerFrameOptions.Color[1][1], MusicPlayerFrameOptions.Color[1][2], MusicPlayerFrameOptions.Color[1][3]);
	MusicPlayer_PlayerFrame_SongLength:SetTextColor(MusicPlayerFrameOptions.Color[1][1], MusicPlayerFrameOptions.Color[1][2], MusicPlayerFrameOptions.Color[1][3]);

	MusicPlayer_PlayerFrame_StatusBar:SetStatusBarColor(MusicPlayerFrameOptions.Color[4][1], MusicPlayerFrameOptions.Color[4][2], MusicPlayerFrameOptions.Color[4][3]);

	-- Playlist frame

	MusicPlayer_PlayerFrame_Playlist:SetBackdropColor(MusicPlayerFrameOptions.Color[2][1], MusicPlayerFrameOptions.Color[2][2], MusicPlayerFrameOptions.Color[2][3]);
	MusicPlayer_PlayerFrame_Playlist:SetBackdropBorderColor(MusicPlayerFrameOptions.Color[3][1], MusicPlayerFrameOptions.Color[3][2], MusicPlayerFrameOptions.Color[3][3]);

	MusicPlayer_PlayerFrame_Playlist_SongsText:SetTextColor(MusicPlayerFrameOptions.Color[1][1], MusicPlayerFrameOptions.Color[1][2], MusicPlayerFrameOptions.Color[1][3]);
	MusicPlayer_PlayerFrame_TopBar:SetVertexColor(MusicPlayerFrameOptions.Color[3][1], MusicPlayerFrameOptions.Color[3][2], MusicPlayerFrameOptions.Color[3][3]);
	MusicPlayer_PlayerFrame_BottomBar:SetVertexColor(MusicPlayerFrameOptions.Color[3][1], MusicPlayerFrameOptions.Color[3][2], MusicPlayerFrameOptions.Color[3][3]);

	MusicPlayer_PlayerFrame_Playlist_ShuffleText:SetTextColor(MusicPlayerFrameOptions.Color[1][1], MusicPlayerFrameOptions.Color[1][2], MusicPlayerFrameOptions.Color[1][3]);
	MusicPlayer_PlayerFrame_Playlist_ShuffleNormalTexture:SetVertexColor(MusicPlayerFrameOptions.Color[3][1], MusicPlayerFrameOptions.Color[3][2], MusicPlayerFrameOptions.Color[3][3]);
	MusicPlayer_PlayerFrame_Playlist_ShufflePushedTexture:SetVertexColor(MusicPlayerFrameOptions.Color[1][1], MusicPlayerFrameOptions.Color[1][2], MusicPlayerFrameOptions.Color[1][3]);
	MusicPlayer_PlayerFrame_Playlist_ShuffleCheckedTexture:SetVertexColor(MusicPlayerFrameOptions.Color[1][1], MusicPlayerFrameOptions.Color[1][2], MusicPlayerFrameOptions.Color[1][3]);
	MusicPlayer_PlayerFrame_Playlist_ShuffleHighlightTexture:SetVertexColor(MusicPlayerFrameOptions.Color[1][1], MusicPlayerFrameOptions.Color[1][2], MusicPlayerFrameOptions.Color[1][3]);	

	MusicPlayer_PlayerFrame_Playlist_SongsText:SetTextColor(MusicPlayerFrameOptions.Color[1][1], MusicPlayerFrameOptions.Color[1][2], MusicPlayerFrameOptions.Color[1][3]);
	MusicPlayer_PlayerFrame_Playlist_ToggleSearch_ButtonText:SetTextColor(MusicPlayerFrameOptions.Color[1][1], MusicPlayerFrameOptions.Color[1][2], MusicPlayerFrameOptions.Color[1][3]);	
	if (MusicPlayer_PlayerFrame_Playlist_ToggleMPML_Button) then
		MusicPlayer_PlayerFrame_Playlist_ToggleMPML_Button.text:SetTextColor(MusicPlayerFrameOptions.Color[1][1], MusicPlayerFrameOptions.Color[1][2], MusicPlayerFrameOptions.Color[1][3]);
	end


	for i=1,30 do
		local name = "MusicPlayerPlaylist_Button"..i.."_Name";
		local button = "MusicPlayerPlaylist_Button"..i;
		local time = "MusicPlayerPlaylist_Button"..i.."_Time";
		local button = "MusicPlayerPlaylist_Button"..i.."_BeingPlayedTexture";
		local highlight = "MusicPlayerPlaylist_Button"..i.."_HighlightTexture";

		getglobal(name):SetTextColor(MusicPlayerFrameOptions.Color[1][1], MusicPlayerFrameOptions.Color[1][2], MusicPlayerFrameOptions.Color[1][3]);
		getglobal(time):SetTextColor(MusicPlayerFrameOptions.Color[1][1], MusicPlayerFrameOptions.Color[1][2], MusicPlayerFrameOptions.Color[1][3]);	
		getglobal(button):SetVertexColor(MusicPlayerFrameOptions.Color[4][1], MusicPlayerFrameOptions.Color[4][2], MusicPlayerFrameOptions.Color[4][3]);
		getglobal(highlight):SetVertexColor(MusicPlayerFrameOptions.Color[3][1], MusicPlayerFrameOptions.Color[3][2], MusicPlayerFrameOptions.Color[3][3]);
	end


	-- Search frame

	MusicPlayer_PlayerFrame_SearchFrame:SetBackdropColor(MusicPlayerFrameOptions.Color[2][1], MusicPlayerFrameOptions.Color[2][2], MusicPlayerFrameOptions.Color[2][3]);
	MusicPlayer_PlayerFrame_SearchFrame:SetBackdropBorderColor(MusicPlayerFrameOptions.Color[3][1], MusicPlayerFrameOptions.Color[3][2], MusicPlayerFrameOptions.Color[3][3]);
	MusicPlayer_PlayerFrame_SearchFrame_SearchText:SetTextColor(MusicPlayerFrameOptions.Color[1][1], MusicPlayerFrameOptions.Color[1][2], MusicPlayerFrameOptions.Color[1][3]);
	MusicPlayer_PlayerFrame_SearchFrame_SearchBox:SetTextColor(MusicPlayerFrameOptions.Color[1][1], MusicPlayerFrameOptions.Color[1][2], MusicPlayerFrameOptions.Color[1][3]);
	MusicPlayer_PlayerFrame_SearchFrame_TopBar:SetVertexColor(MusicPlayerFrameOptions.Color[3][1], MusicPlayerFrameOptions.Color[3][2], MusicPlayerFrameOptions.Color[3][3]);
	MusicPlayer_PlayerFrame_SearchFrame_SortBy_DropDownText:SetTextColor(MusicPlayerFrameOptions.Color[1][1], MusicPlayerFrameOptions.Color[1][2], MusicPlayerFrameOptions.Color[1][3]);

end

function MusicPlayerFrame_UpdateWidth()
	for i=1,30 do
		local name = "MusicPlayerPlaylist_Button"..i.."_Name";

		getglobal(name):SetWidth(MusicPlayerFrameOptions.PlayerWidth - 60);

		local time = "MusicPlayerPlaylist_Button"..i.."_Time";
		local button = "MusicPlayerPlaylist_Button"..i.."_BeingPlayedTexture";
		local highlight = "MusicPlayerPlaylist_Button"..i.."_HighlightTexture";

		getglobal("MusicPlayerPlaylist_Button"..i):SetWidth(MusicPlayerFrameOptions.PlayerWidth - 30);
		getglobal("MusicPlayerPlaylist_Button"..i.."_BeingPlayedTexture"):SetWidth(MusicPlayerFrameOptions.PlayerWidth - 30);
		getglobal("MusicPlayerPlaylist_Button"..i.."_HighlightTexture"):SetWidth(MusicPlayerFrameOptions.PlayerWidth - 30);
	end

	MusicPlayer_PlayerFrame_SearchFrame:SetWidth(MusicPlayerFrameOptions.PlayerWidth);
	MusicPlayer_PlayerFrame_SearchFrame_TopBar:SetWidth(MusicPlayerFrameOptions.PlayerWidth - 7.5);
	MusicPlayer_PlayerFrame_SearchFrame_SearchBox:SetWidth(MusicPlayerFrameOptions.PlayerWidth - 10);

	MusicPlayer_PlayerFrame_Playlist:SetWidth(MusicPlayerFrameOptions.PlayerWidth);
	MusicPlayer_PlayerFrame_Playlist_List_ScrollFrame:SetWidth(MusicPlayerFrameOptions.PlayerWidth - 34);
	MusicPlayer_PlayerFrame_TopBar:SetWidth(MusicPlayerFrameOptions.PlayerWidth - 7.5);
	MusicPlayer_PlayerFrame_BottomBar:SetWidth(MusicPlayerFrameOptions.PlayerWidth - 7.5);
end

function MusicPlayerFrame_UpdateStrata()
	if (MusicPlayerFrameOptions.PlayerFrameStrata == 1) then
		MusicPlayer_PlayerFrame:SetFrameStrata("LOW");
	elseif (MusicPlayerFrameOptions.PlayerFrameStrata == 2) then
  		MusicPlayer_PlayerFrame:SetFrameStrata("MEDIUM");
	elseif (MusicPlayerFrameOptions.PlayerFrameStrata == 3) then
		MusicPlayer_PlayerFrame:SetFrameStrata("HIGH");
	end
end

function MusicPlayerFrame_Update_Checkbuttons()
	
	if (MusicPlayerFrameOptions.showFrame) then
		MusicPlayer_PlayerFrame:Show();
	else
		MusicPlayer_PlayerFrame:Hide();
	end

	MusicPlayer_ToggleMinimapButton();
end

function MusicPlayerFrame_Update()
	MusicPlayerFrame_UpdateAnchors();
	MusicPlayerFrame_UpdateColors();
	MusicPlayerFrame_UpdateWidth();
	MusicPlayerFrame_UpdateStrata();
	MusicPlayerFrame_Update_Checkbuttons();
end

function MusicPlayer_PlayerFrame_Shuffle()
	MusicPlayerFrameOptions.Shuffle = this:GetChecked();

	if (MusicPlayerFrameOptions.Shuffle == 1) then
		MP_WhenFinished = 12;
	else
		MP_WhenFinished = MusicPlayerFrameOptions.WhenFinished;
	end
end


------------------------------MusicPlayer Tooltip--------------------------------

function MusicPlayer_ShowTooltip(songnr, frame, tooltiptype, anchor, bgr, bgg, bgb, bgbr, bgbg, bgbb)

	if (type(frame) == "string") then
		frame = getglobal(frame);
	end


	if (not anchor) then
		local x,y = frame:GetCenter()
		local horizontal = (x > UIParent:GetWidth()/2) and "LEFT" or "RIGHT";
		anchor = "ANCHOR_"..horizontal;
	end

	MusicPlayer_Tooltip:SetOwner(frame, anchor);


	local bg_r, bg_g, bg_b = MusicPlayerFrameOptions.Color[2][1], MusicPlayerFrameOptions.Color[2][2], MusicPlayerFrameOptions.Color[2][3];
	local bgborder_r, bgborder_g, bgborder_b = MusicPlayerFrameOptions.Color[3][1], MusicPlayerFrameOptions.Color[3][2], MusicPlayerFrameOptions.Color[3][3];


	if (bgr) then
		bg_r, bg_g, bg_b = bgr, bgg, bgb, bgbr;
		bgborder_r, bgborder_g, bgborder_b = bgbr, bgbg, bgbb;
	end

	MusicPlayer_Tooltip:SetBackdropColor(bg_r, bg_g, bg_b);
	MusicPlayer_Tooltip:SetBackdropBorderColor(bgborder_r, bgborder_g, bgborder_b);

	-- Check if the tooltip comes from the options frame
	local check = strfind(frame:GetName(), "Options");

	if (frame == MusicPlayer_PlayerFrame) then
		MusicPlayer_SetTooltipText("moveplayerframe");
	elseif (check) then
		MusicPlayer_SetTooltipText(frame:GetName());
	else
		MusicPlayer_SetTooltipText("song", tooltiptype, songnr);
	end
	MusicPlayer_Tooltip:Show();
end


function MusicPlayer_SetTooltipText(type, tooltiptype, song)
	local r, g, b;


	tooltip = MusicPlayer_Tooltip;
	r, g, b = MusicPlayerFrameOptions.Color[1][1], MusicPlayerFrameOptions.Color[1][2], MusicPlayerFrameOptions.Color[1][3];


	if (type == "song") then
		tooltip:SetText(MusicPlayerSongs[song]["Title"], r, g, b);

		if MusicPlayerSongs[song]["Artist"] and (MusicPlayerSongs[song]["Album"] ~= "" or MusicPlayerSongs[song]["Album"] ~= nil) then
			tooltip:AddDoubleLine(MusicPlayerSongs[song]["Artist"], MusicPlayerSongs[song]["Album"], r, g, b, r, g, b);
		elseif MusicPlayerSongs[song]["Artist"] then
			tooltip:AddLine(MusicPlayerSongs[song]["Artist"], r, g, b);
		end
		if MusicPlayerSongs[song]["Genre"] then
			tooltip:AddLine(" ");
			tooltip:AddLine("Genre: "..MusicPlayerSongs[song]["Genre"], r, g, b);
		end
		if MusicPlayerSongs[song]["Quality"] and MusicPlayerSongs[song]["Genre"] then
			tooltip:AddLine("Quality: "..MusicPlayerSongs[song]["Quality"].."kbs", r, g, b);
		elseif MusicPlayerSongs[song]["Quality"] then
			tooltip:AddLine(" ");
			tooltip:AddLine("Quality: "..MusicPlayerSongs[song]["Quality"].."kbs", r, g, b);
		end
		for artist, artisttable in pairs(MusicPlayer_Favorites) do
			for artistsongindex, title in pairs(artisttable) do
				if (title == MusicPlayerSongs[song]["Title"]) then
					tooltip:AddLine(" ");
					tooltip:AddLine("Favorite", r, g, b);
				end			
			end
		end

	elseif (type == "moveplayerframe") then
		MusicPlayer_Tooltip:SetText(MusicPlayer_SongNameFrame_Click, r, g, b);
	else
		MusicPlayer_Tooltip:SetText(MusicPlayerHelpTable[type], 1,0,0, 1, 1);
	end
end

function MusicPlayerFrame_OnEnter()
	if (MusicPlayer_PlayerFrame:IsVisible()) then
		if ( MusicPlayerFrameOptions.lock == nil or MusicPlayerFrameOptions.lock == 0 ) then
			MusicPlayer_Tooltip:SetOwner(this, "ANCHOR_LEFT");
			MusicPlayer_ShowTooltip(nil, MusicPlayer_PlayerFrame);
		end
	end
end

function MusicPlayerFrame_Window_OnEnter()
	if (MP_SongIsPlaying > 0) and (MusicPlayerFrameOptions.playertooltip == 1) then
		MusicPlayer_Tooltip:SetOwner(this, "ANCHOR_LEFT");
		MusicPlayer_ShowTooltip(MP_SongIsPlaying, "MusicPlayer_PlayerFrame_Window");
	end
end

function MusicPlayer_PlayerFrame_OnMouseUp(arg)
	if (arg == "LeftButton") then
		MusicPlayer_PlayerFrame:StopMovingOrSizing();
	end
end


function MusicPlayer_ShowItemRef(title, artist, album, quality, genre)


	if (ItemRefTooltipTextLeft1:GetText() == title) then
		ItemRefTooltip:Hide();
		return;
	end

	ItemRefTooltip:SetOwner(UIParent, "ANCHOR_PRESERVE");

	ItemRefTooltip:SetText(title, 1, 0.509, 0);

	if artist and (album ~= "" or album ~= nil) then
		ItemRefTooltip:AddDoubleLine(artist, album, 1, 1, 1, 1, 1, 1);
	elseif artist then
		ItemRefTooltip:AddLine(artist, 1, 1, 1);
	end
	if genre then
		ItemRefTooltip:AddLine(" ");
		ItemRefTooltip:AddLine("Genre: "..genre, 1, 1, 1);
	end
	if quality and genre then
		ItemRefTooltip:AddLine("Quality: "..quality.."kbs", 1, 1, 1);
	elseif quality then
		ItemRefTooltip:AddLine(" ");
		ItemRefTooltip:AddLine("Quality: "..quality.."kbs", 1, 1, 1);
	end

	ItemRefTooltip:Show();
end


------------------------------MusicPlayer PlayList--------------------------------

local numreplacements = {
	[1] = "     ",
	[2] = "    ",
	[3] = "   ",
	[4] = "  ",
	[5] = " ",
	[6] = "",
};

function MusicPlayer_SortSongs_fixNumber(nr)
	return numreplacements[strlen(tostring(nr))]..nr;
end

function MusicPlayer_SortSongs()
	MusicPlayerSongs_Sorted = {};
	MusicPlayerSongs_Sorted_ValueToIndex = {};

	local subtablenames = {
		[1] = "Title",
		[2] = "Album",
		[3] = "Artist",
		[4] = "Genre",
		[5] = "Quality",
	};

	local sortby;
	local replaced = nil;
	local titlereplaced = nil;

	for k, v in pairs(MusicPlayerSongs) do

		sortby = subtablenames[MusicPlayerFrameOptions.playlistformatting[1]];

		replaced = v[sortby];
		replaced = gsub(replaced, "(%d+)", MusicPlayer_SortSongs_fixNumber);

		titlereplaced = v["Title"];
		titlereplaced = gsub(titlereplaced, "(%d+)", MusicPlayer_SortSongs_fixNumber);

		if (sortby == 1) then
			MusicPlayerSongs_Sorted[k] = strlower(replaced.." "..k);
		else
			MusicPlayerSongs_Sorted[k] = strlower(replaced..titlereplaced.." "..k);
		end
	end

	sort(MusicPlayerSongs_Sorted);


	for k,v in pairs(MusicPlayerSongs_Sorted) do
		local a, b, _, Number = strfind(v, "(.+) (%d+)");

		MusicPlayerSongs_Sorted_ValueToIndex[tonumber(Number)] = k;
	end
end

function MusicPlayer_CreatePlaylistButtons()


	local button;
	local lastbuttonnr = 0;

	for i = 1, 30 do
		if not (getglobal("MusicPlayerPlaylist_Button"..i)) then
			button = CreateFrame("Button", "MusicPlayerPlaylist_Button"..i, MusicPlayer_PlayerFrame_Playlist_List, "MusicPlayerPlaylistButtonTemplate");
			button:SetID(i);

			if (i > 1) then
				lastbuttonnr = i - 1;
				button:SetPoint("TOPLEFT", "MusicPlayerPlaylist_Button"..lastbuttonnr, "BOTTOMLEFT");
			elseif (i == 1) then
				button:SetPoint("TOP", "MusicPlayer_PlayerFrame_Playlist_List_ScrollFrame", "TOP", 0.8, 1.3);
			end
		end
	end
end

function MusicPlayer_SetNumPlaylistButtons(num)

	local button;

	local playlistheight = 41 + (num * 20)
	local scrollframeheight = playlistheight - 42
	MusicPlayer_PlayerFrame_Playlist:SetHeight(playlistheight);			--(10 btns = 241)
	MusicPlayer_PlayerFrame_Playlist_List_ScrollFrame:SetHeight(scrollframeheight);	--(10 btns = 199)

	for i = 1, 30 do
		if (i <= num) then
			getglobal("MusicPlayerPlaylist_Button"..i):Show();
		else
			getglobal("MusicPlayerPlaylist_Button"..i):Hide();
		end
	end

	MusicPlayerFrameOptions.NumPlaylistButtons = num;

	FauxScrollFrame_Update(MusicPlayer_PlayerFrame_Playlist_List_ScrollFrame, MusicPlayer_GetSongNum(), num, 20);
	MusicPlayerPlaylistUpdate();
end

function MusicPlayerPlaylistUpdate()
	local songnr;
	local a, b, _, Number;

	FauxScrollFrame_Update(MusicPlayer_PlayerFrame_Playlist_List_ScrollFrame, MusicPlayer_GetSongNum(), MusicPlayerFrameOptions.NumPlaylistButtons, 20);

	for button = 1, MusicPlayerFrameOptions.NumPlaylistButtons do
		indexnr = button + FauxScrollFrame_GetOffset(MusicPlayer_PlayerFrame_Playlist_List_ScrollFrame);
		if (indexnr <= MusicPlayer_GetSongNum()) then

			a, b, _, Number = strfind(MusicPlayerSongs_Sorted[indexnr], "(.+) (%d+)");

			Number = tonumber(Number);
			getglobal("MusicPlayerPlaylist_Button"..button):SetID(Number);

			local texture = "MusicPlayerPlaylist_Button"..button.."_BeingPlayedTexture";
			if (MP_SongIsPlaying == Number) then
				getglobal(texture):Show();
			else
				getglobal(texture):Hide();
			end

			local text = "MusicPlayerPlaylist_Button"..button.."_Name";

			local subtablenames = {
				[1] = "Title";
				[2] = "Album";
				[3] = "Artist";
				[4] = "Genre";
				[5] = "Quality";
			};

			if (MusicPlayerFrameOptions) then

				if (MusicPlayerFrameOptions.playlistformatting["Indexnumber"] == 1) then
					getglobal(text):SetText(indexnr..". ");
				else
					getglobal(text):SetText("");
				end

				if (MusicPlayerFrameOptions.playlistformatting[1]) then
					if (getglobal(text):GetText()) then
						getglobal(text):SetText(getglobal(text):GetText()..MusicPlayerSongs[Number][subtablenames[MusicPlayerFrameOptions.playlistformatting[1]]]);
					else
						getglobal(text):SetText(MusicPlayerSongs[Number][subtablenames[MusicPlayerFrameOptions.playlistformatting[1]]]);
					end

					if (subtablenames[MusicPlayerFrameOptions.playlistformatting[1]] == "Quality") then
						getglobal(text):SetText(getglobal(text):GetText().."kbs");
					end

					if (MusicPlayerFrameOptions.playlistformatting[2] < 6) then
						getglobal(text):SetText(getglobal(text):GetText().." - "..MusicPlayerSongs[Number][subtablenames[MusicPlayerFrameOptions.playlistformatting[2]]]);

						if (subtablenames[MusicPlayerFrameOptions.playlistformatting[2]] == "Quality") then
							getglobal(text):SetText(getglobal(text):GetText().."kbs");
						end

						if (MusicPlayerFrameOptions.playlistformatting[3] < 6) then
							getglobal(text):SetText(getglobal(text):GetText().." - "..MusicPlayerSongs[Number][subtablenames[MusicPlayerFrameOptions.playlistformatting[3]]]);

							if (subtablenames[MusicPlayerFrameOptions.playlistformatting[3]] == "Quality") then
								getglobal(text):SetText(getglobal(text):GetText().."kbs");
							end
						end
					end
				end


				if (MusicPlayer_Favorites and MusicPlayerFrameOptions.playlistformatting["Favoritemark"] == 1) then
					for artist, artisttable in pairs(MusicPlayer_Favorites) do
						for artistsongindex, song in pairs(artisttable) do
							if (song == MusicPlayerSongs[Number]["Title"]) then
								getglobal(text):SetText(getglobal(text):GetText().." *");
							end
						end
					end
				end



				if (MusicPlayer_EnqueueTable and MusicPlayerFrameOptions.playlistformatting["Queuenumber"] == 1) then
					for k, v in pairs(MusicPlayer_EnqueueTable) do
						if (v == Number) then
							getglobal(text):SetText(getglobal(text):GetText().." ("..k..")");
						end
					end
				end

				local text = "MusicPlayerPlaylist_Button"..button.."_Time";
				if (MusicPlayerFrameOptions.playlistformatting["Duration"] == 1) then
					
					if (MusicPlayerSongs[Number]["Duration"] ~= 0 and MusicPlayerSongs[Number]["Duration"] ~= nil) then
						getglobal(text):SetText(string.format("%d:%02d", MusicPlayerSongs[Number]["Duration"] / 60, mod(MusicPlayerSongs[Number]["Duration"], 60)));
					else
						getglobal(text):SetText("00:00");
					end
				else
					getglobal(text):SetText("");
				end
			end
	
			getglobal("MusicPlayerPlaylist_Button"..button):Show();
		else
			getglobal("MusicPlayerPlaylist_Button"..button):Hide();
		end
	end

	if (MusicPlayerSongs_Sorted[MP_SongIsPlaying]) then	
		MusicPlayer_PlayerFrame_Playlist_SongsText:SetText(MusicPlayer_Songs_NumberConverter(MP_SongIsPlaying).." / "..MusicPlayer_GetSongNum());
	else
		MusicPlayer_PlayerFrame_Playlist_SongsText:SetText(MusicPlayer_GetSongNum());
	end
end

function MusicPlayer_PlaylistButton_OnClick()

	local Number = this:GetID();
				
	if (arg1 == "RightButton") then
		MusicPlayer_ShowTooltip(Number, this:GetName());
	elseif (arg1 == "LeftButton") then
		if IsShiftKeyDown() and (not IsControlKeyDown()) then
			if (MPML) then
				MusicPlayerMediaLibrary_Enqueue_Enqueue(Number);
			end
		elseif IsControlKeyDown() and (not IsShiftKeyDown()) then

			if (MPML) then
				MusicPlayerMediaLibrary_Favorites_AddRemoveSong(Number);
			end
		else
			MusicPlayer_PlaySong(Number);
		end
	end
end



---------------------------------