MultiTips =  AceLibrary("AceAddon-2.0"):new("AceConsole-2.0", "AceHook-2.1") 
local MultiTips,self=MultiTips,MultiTips

local frames_tips

local function GetFreeIndex()
	 for i=1,table.getn(frames_tips) do 
	 	if frames_tips[i]:GetItem() == nil then return i end
	 end
	 return -1
end

local function CheckForExistingLink(link)
	for i=1,#frames_tips do 
		local temp=select(2,frames_tips[i]:GetItem())
		if frames_tips[i]:IsVisible() and temp and string.find(temp,link) then return i end
	end
	return 0
end


function MultiTips:OnInitialize()

	local options = { 
    type="group",
    args = {
    	clear= {
    		type="execute",
    		name="Close all Tips",
    		desc="Close all Tips",
    		func=function(v) MultiTips:CloseAllTips() end,
    	},
		}
	}
	MultiTips:RegisterChatCommand({"/multitips"}, options)
end

function MultiTips:OnEnable()
	frames_tips={ItemRefTooltip,ItemRefTooltip2,ItemRefTooltip3,ItemRefTooltip4,ItemRefTooltip5}
	self:Hook("SetItemRef", "SetItemRef", true)
	self:SecureHook("HideUIPanel")
end

function MultiTips:OnDisable()
	self:UnhookAll()
end


function MultiTips:SetItemRef(link, text, button)
	if ( strsub(link, 1, 6) == "player" ) then
		self.hooks["SetItemRef"](link,text,button);
		return
	end

	if ( IsControlKeyDown() ) then
		self.hooks["SetItemRef"](link,text,button);
	elseif ( IsShiftKeyDown() ) then
		self.hooks["SetItemRef"](link,text,button);
	else
		MultiTips:Handler(link, text, button)
	end
end

function MultiTips:HideUIPanel(frame,loop)
	if IsShiftKeyDown() and not loop then 
		for k,v in pairs(frames_tips) do
			HideUIPanel(v,1)
		end
	end
end


function MultiTips:Handler(link, text, button, forcedtip)
    local a=CheckForExistingLink(link)
    if a==0 or forcedtip then
		local i = forcedtip or GetFreeIndex()
		if i==-1 then self:Print("All tips are used. Close a tip before being able to open a new one. (Shift-close to close them all)") return end
		ShowUIPanel(frames_tips[i])
		if ( not frames_tips[i]:IsVisible() ) then
			frames_tips[i]:SetOwner(UIParent, "ANCHOR_PRESERVE");
		end
		frames_tips[i]:SetHyperlink(link);
	else 
		if frames_tips[a]:IsVisible() then HideUIPanel(frames_tips[a]) end
	end
end

function MultiTips:RemoveTip(frame)
	if not frame then return end
	if frame:IsVisible() then HideUIPanel(frame) end
end



function MultiTips:TipClicked(i,tip)
	if not (arg1=="RightButton") then return end
	if ItemRefTooltip:IsVisible() and tip:IsVisible() then 
		
		local blizlink=select(2,ItemRefTooltip:GetItem())
		local tiplink=select(2,tip:GetItem())
		
		local point,relativeTo,relativePoint,xOfs,yOfs = ItemRefTooltip:GetPoint()
		local point2,relativeTo2,relativePoint2,xOfs2,yOfs2 = tip:GetPoint()
		
		tip:SetPoint(point,relativeTo,relativePoint,xOfs,yOfs)
		ItemRefTooltip:SetPoint(point2,relativeTo2,relativePoint2,xOfs2,yOfs2)
		
		
		HideUIPanel(tip)
		HideUIPanel(ItemRefTooltip)
		
		MultiTips:Handler(blizlink, "a", "LeftButton",i)
		MultiTips:Handler(tiplink, "a", "LeftButton",1)
		
	elseif tip:IsVisible() then 
		local tiplink=select(2,frames_tips[i]:GetItem())
		
		local point,relativeTo,relativePoint,xOfs,yOfs = ItemRefTooltip:GetPoint()
		local point2,relativeTo2,relativePoint2,xOfs2,yOfs2 = tip:GetPoint()

		tip:SetPoint(point,relativeTo,relativePoint,xOfs,yOfs)
		ItemRefTooltip:SetPoint(point2,relativeTo2,relativePoint2,xOfs2,yOfs2)
		
		
		if tip:IsVisible() then HideUIPanel(tip) end
		
		MultiTips:Handler(tiplink, "a", "LeftButton",1)					
	end
end

