--[[  MovableBags.lua
			Author: Pos Updated by Edgerin of Illidan
			Version 2.4

			24/12/2004 - Initial Release
			24/12/2004 - Updated to include bank bags
			25/12/2004 - bug fixes and streamlined code
			1/01/2005	 - fix for dead areas on screen
			2/01/2005   - Better Default Positions
			20/01/2005  - Seperate Settings for each character
                        08/12/2006 - Updated for patch and added 11th bag slot
                        26/09/2007  - Updated for patch 2.2
                        13/11/2007  - Updated for patch 2.3
]]

MOVABLEBAGS_NUMBAGS = 13;	--5 bags, 7 bank bags, 1 keyring
MOVABLEBAGS_LOWID = 0;		--does not include keyring, which is -2
MOVABLEBAGS_HIGHID = 11;	--does not include keyring, which is -2

--set current char to the default settings before we get sent a UNIT_NAME_UPDATE for the player
MovableBags_CurrentChar = "_default";

-- 0-4 are the normal bags, 5-11 are bank bags, -2 IS keyring
MovableBags_DefaultPositions = {
	[-2] = { "BOTTOMRIGHT", "UIParent", "BOTTOMRIGHT", 500, 240 },
	[0] = { "BOTTOMRIGHT", "UIParent", "BOTTOMRIGHT", -50, 300 },
	[1] = { "BOTTOMRIGHT", "UIParent", "BOTTOMRIGHT", -250, 300 },
	[2] = { "BOTTOMRIGHT", "UIParent", "BOTTOMRIGHT", -450, 300 },
	[3] = { "BOTTOMRIGHT", "UIParent", "BOTTOMRIGHT", -50, 500 },
	[4] = { "BOTTOMRIGHT", "UIParent", "BOTTOMRIGHT", -250, 500 },
	[5] = { "BOTTOMRIGHT", "UIParent", "BOTTOMRIGHT", -450, 500 },
	[6] = { "BOTTOMLEFT", "UIParent", "BOTTOMLEFT", 250, 300 },
	[7] = { "BOTTOMLEFT", "UIParent", "BOTTOMLEFT", 450, 300 },
	[8] = { "BOTTOMLEFT", "UIParent", "BOTTOMLEFT", 80, 270 },
	[9] = { "BOTTOMLEFT", "UIParent", "BOTTOMLEFT", 280, 270 },
	[10] = { "BOTTOMLEFT", "UIParent", "BOTTOMLEFT", 480, 270 },
        [11] = { "BOTTOMLEFT", "UIParent", "BOTTOMLEFT", 500, 240 },
};
	
function MovableBags_updateContainerFrameAnchors()
	movablebags_oldupdateContainerFrameAnchors();
	
	for i=1, NUM_CONTAINER_FRAMES, 1 do
		local containerFrame = getglobal("ContainerFrame"..i);
		local id = containerFrame:GetID();
		if ( (id >= MOVABLEBAGS_LOWID) and (id <= MOVABLEBAGS_HIGHID) or (id==KEYRING_CONTAINER) ) then
			containerFrame:ClearAllPoints();
			containerFrame:SetPoint("TOPLEFT","Bag"..id.."Mover","TOPLEFT",0,0);
		end
	end
end

--called to update the visibility of the movers, depending on locked status and visibility of the bags
function MovableBags_UpdateVisible()
	local i = 0;
	MovableBags_HideAll();
	
	if(MovableBags_Config[MovableBags_CurrentChar].Mode == "Locked") then
		--no checking if bags are visible to show movers
		return;
	end 
	
	for i=1, NUM_CONTAINER_FRAMES, 1 do
		local containerFrame = getglobal("ContainerFrame"..i);
		local id = containerFrame:GetID();
		if ( (id >= MOVABLEBAGS_LOWID) and (id <= MOVABLEBAGS_HIGHID) or (id==KEYRING_CONTAINER)  ) then
			local mover = getglobal("Bag"..id.."Mover");
			if (containerFrame:IsVisible()) then
				mover:Show();
			end
		end
	end
end

function MovableBags_HideAll()
	for i=MOVABLEBAGS_LOWID,MOVABLEBAGS_HIGHID,1 do
		local mover = getglobal("Bag"..i.."Mover");
		mover:Hide();
	end
	--deal with keyring seperately
	local mover = getglobal("Bag"..KEYRING_CONTAINER.."Mover");
	mover:Hide();
end

--hooks into the containerframes on show/hide, to show/hide the movers
function MovableBags_ContainerFrame_OnHide()
	movablebags_oldContainerFrame_OnHide();
	if ( this:GetID() < MOVABLEBAGS_NUMBAGS ) then
		local mover = getglobal("Bag"..this:GetID().."Mover");
		mover:Hide();
	end
end

function MovableBags_ContainerFrame_OnShow()
	movablebags_oldContainerFrame_OnShow();

	if ( this:GetID() < MOVABLEBAGS_NUMBAGS and MovableBags_Config[MovableBags_CurrentChar].Mode == "Movable") then
		local mover = getglobal("Bag"..this:GetID().."Mover");
		mover:Show();
	end
end

function MovableBags_OnLoad() 
	this:RegisterEvent("VARIABLES_LOADED");
	this:RegisterEvent("UNIT_NAME_UPDATE");
	

end
--checks that the config table exists, migrates config from perv versions if needed and creates per char settings if needed
function MovableBags_InitConfig() 
	if (MovableBags_Config == nil) then
		--new install, init config
		MovableBags_Config = {};
		MovableBags_Config["_default"] = {};
		MovableBags_Config["_default"].Mode = "Movable";
		MovableBags_Config[MovableBags_CurrentChar] = {};
		MovableBags_Config[MovableBags_CurrentChar].Mode = "Movable";
		MovableBags_Config.Version = "1.3"
		--first load message
		DEFAULT_CHAT_FRAME:AddMessage("Movable Bags Loaded");
		DEFAULT_CHAT_FRAME:AddMessage("type /movablebags or /bags for config");
	else
		--version specific setup, migrating settings etc
		if (MovableBags_Config.Version == nil) then
			--pre 1.2 version, setup multiple users
			MovableBags_Config["_default"] = {};
			MovableBags_Config["_default"].Mode = MovableBags_Config.Mode;
			MovableBags_Config[MovableBags_CurrentChar] = {};
			MovableBags_Config[MovableBags_CurrentChar].Mode = MovableBags_Config.Mode;
			MovableBags_Config.Mode = nil;
			MovableBags_Config.Version = "1.3"
		end
	end
	
	--setup config for current char if needed
	if (MovableBags_Config[MovableBags_CurrentChar] == nil) then
		MovableBags_Config[MovableBags_CurrentChar] = {};
		MovableBags_Config[MovableBags_CurrentChar].Mode = MovableBags_Config["_default"].Mode;
	end
end

function MovableBags_OnEvent()
		if (event == "VARIABLES_LOADED") then
			
			SlashCmdList["MOVABLEBAGS"] = MovableBags_SlashHandler;
			SLASH_MOVABLEBAGS1 = "/movablebags";
			SLASH_MOVABLEBAGS2 = "/bags";
			
			MovableBags_InitConfig();
			
			MovableBags_UpdateVisible();
			
			--RegisterForSave("MovableBags_Config");			
			--function hooks
			--hooking in VARIABLES_LOADED so if something else hooks the functions, hopefully they do it before me, so they dont interfere
			movablebags_oldupdateContainerFrameAnchors = updateContainerFrameAnchors;
			updateContainerFrameAnchors = MovableBags_updateContainerFrameAnchors;
			
			movablebags_oldContainerFrame_OnShow = ContainerFrame_OnShow;
			ContainerFrame_OnShow = MovableBags_ContainerFrame_OnShow;
			
			movablebags_oldContainerFrame_OnHide = ContainerFrame_OnHide;
			ContainerFrame_OnHide = MovableBags_ContainerFrame_OnHide;
			return;
	end
	if (event == "UNIT_NAME_UPDATE") then
		if (arg1 == "player") then
			
			MovableBags_CurrentChar = UnitName("player");
			if (MovableBags_CurrentChar == "Unknown Entity") then
				MovableBags_CurrentChar = "_default";
			end
			MovableBags_InitConfig();
		end
		return;
	end
end


function MovableBags_SlashHandler(arg)
	arg = string.lower(arg);
	
	if (arg == "lock") then
		MovableBags_Config[MovableBags_CurrentChar].Mode = "Locked";
		MovableBags_UpdateVisible();
		DEFAULT_CHAT_FRAME:AddMessage("Bags are now LOCKED");
	elseif (arg == "unlock") then
		MovableBags_Config[MovableBags_CurrentChar].Mode = "Movable";
		MovableBags_UpdateVisible();
		DEFAULT_CHAT_FRAME:AddMessage("Bags are now UNLOCKED");
	elseif (arg == "reset") then
		for i=MOVABLEBAGS_LOWID,MOVABLEBAGS_HIGHID,1 do
			local mover = getglobal("Bag"..i.."Mover");
			local pos = MovableBags_DefaultPositions[i];
			mover:ClearAllPoints();
			mover:SetPoint(pos[1],pos[2],pos[3],pos[4],pos[5],pos[6], pos[7]);
		end
	else
		DEFAULT_CHAT_FRAME:AddMessage("Usage: /movablebags unlock | lock | reset");
		DEFAULT_CHAT_FRAME:AddMessage("unlock lets you move the bags around independantly of each other (default)");
		DEFAULT_CHAT_FRAME:AddMessage("lock locks the bags into the position you last moved them to");
		DEFAULT_CHAT_FRAME:AddMessage("Reset will return all bags to the default positions");
		DEFAULT_CHAT_FRAME:AddMessage("Bags are currently "..MovableBags_Config[MovableBags_CurrentChar].Mode);
	end

end