--[[
    Default english localizations for Mount by LordFarlander
    $Revision: 76944 $
]]--

--[[
Copyright (c) 2008, LordFarlander
All rights reserved.

Redistribution and use in source and binary forms, with or without
modification, are permitted provided that the following conditions are met:

    * Redistributions of source code must retain the above copyright notice,
      this list of conditions and the following disclaimer.
    * Redistributions in binary form must reproduce the above copyright notice,
      this list of conditions and the following disclaimer in the documentation
      and/or other materials provided with the distribution.

THIS SOFTWARE IS PROVIDED BY THE COPYRIGHT HOLDERS AND CONTRIBUTORS "AS IS" AND
ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE IMPLIED
WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE ARE
DISCLAIMED. IN NO EVENT SHALL THE COPYRIGHT OWNER OR CONTRIBUTORS BE LIABLE FOR
ANY DIRECT, INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR CONSEQUENTIAL DAMAGES
(INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS OR SERVICES;
LOSS OF USE, DATA, OR PROFITS; OR BUSINESS INTERRUPTION) HOWEVER CAUSED AND ON
ANY THEORY OF LIABILITY, WHETHER IN CONTRACT, STRICT LIABILITY, OR TORT
(INCLUDING NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY OUT OF THE USE OF THIS
SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF SUCH DAMAGE.
]]--

local L = AceLibrary( "AceLocale-2.2" ):new( "Mount" );

--Localised variable names
L:RegisterTranslations( "enUS", function() return {
    ["Summon Mount"] = true,
    ["Mount"] = true,
    
    ["Temple Of Ahn'Qiraj"] = true;
    
    -- Slash sub commands
    ["autoHideButton"] = true,
    ["toggleButton"] = true,
    ["favorFlying"] = true,
    ["lockButton"] = true,
    ["list"] = true,
    ["refresh"] = true,
    ["showModifierItems"] = true,
    ["suggestOnlySoulbound"] = true,

    -- Slash sub command names
    ["Automatically Hide Button"] = true,
    ["Show Mount Button"] = true,
    ["Favor Flying Mounts"] = true,
    ["Lock Button Position"] = true,
    ["List all mounts"] = true,
    ["Refresh mount list"] = true,
    ["Show Modifier Items"] = true,
    ["Suggest Only Soulbound Mounts"] = true,

    -- Slash sub command descriptions
    ["Show a list with all your mounts."] = true,
    ["Force a refresh of the list of all your mounts."] = true,
    ["Hide the button when you can't mount?"] = true,
    ["Show/Hide the Mount Button."] = true,
    ["Toggles if flying mounts should be favored if in an area that allows them."] = true,
    ["Lock the position of the button?"] = true,
    ["Toggles if items that modify mounts (such as Fresh Holly) should be selected when holding Ctrl while mounted."] = true,
    ["Toggles if only mounts that are soulbound to you are to be suggested for use."] = true,

    ["Dismount (if flying hold down shift, ctrl, or alt and click to dismount)"] = true,
    ["Dismount (if flying hold down ctrl or alt and click to dismount)"] = true,
    ["You have no mounts."] = true,

    ["List of your mounts:"] = true,
    ["%s mounts:"] = true,
    ["%i%% speed %s"] = true,
    ["ground"] = true,
    ["flying"] = true,
}
end );
