<?php
// no direct usage
if (!defined('EQDKP_INC'))
{
	die('You cannot access this file directly.');
}

// declare the plugin class
class morgdkp_Plugin_Class extends EQdkp_Plugin
{
	function morgdkp_Plugin_Class($pm)
	{
	    global $eqdkp_root_path, $user, $SID;

		// wire ourselves in
	    $this->eqdkp_plugin($pm);
	    $this->pm->get_language_pack('morgdkp');

		// setup plugin details
	    $this->add_data(array(
	        'name'          => 'MorgDKP',
	        'code'          => 'morgdkp',
	        'path'          => 'morgdkp',
	        'contact'       => 'Morgalm at WOWInterface',
	        'template_path' => 'plugins/morgexport/templates/',
	        'version'       => '1.0.0')
	    );
	    
		// wire in our menus
		$this->add_menu('admin_menu', $this->gen_admin_menu());
	}
	function gen_admin_menu()
	{
		// make sure we are installed
	    if ($this->pm->check(PLUGIN_INSTALLED, 'morgdkp'))
	    {
	        global $db, $user, $SID;
			$admin_menu = array('morgdkp' => array( 0 => $user->lang['morgdkp_adminmenu_title'],
            	1 => array('link' => $eqdkp_root_path . 'plugins/' . $this->get_data('path') . '/Morgexport.php' . $SID, 'text' => $user->lang['morgexport'], 'check' => 'u_raid_list'),
            	2 => array('link' => $eqdkp_root_path . 'plugins/' . $this->get_data('path') . '/Morgimport.php' . $SID, 'text' => $user->lang['morgimport'], 'check' => 'u_raid_list'))
			);
        }
	    return $admin_menu;
	}
}
?>
