<?php 
session_start();
define('EQDKP_INC', true);
define('IN_ADMIN', true);
define('PLUGIN', 'ctrt');

$eqdkp_root_path = './../../';
$admin_path = $eqdkp_root_path . "admin/index.php?s=/";
require($eqdkp_root_path . 'config.php');
require($eqdkp_root_path . 'common.php');
require('Morgfunc.php');

function InsertAliases($alts) {
	foreach ($alts as $tab) {
		if ($tab['alt']) {
			CreateAliasDB($tab['eqdkp'], $tab['prefix']);
			if (mysql_select_db($tab['eqdkp'])) {
				if ($tab['action'] == "ADD") {
					$sql = "INSERT INTO " . $tab['prefix'] . 'ctrt_aliases' . " (alias_id, alias_member_id, alias_name) 
							VALUES ('','" . $tab['id'] . "','" . stripslashes($tab['alt']) . "')";
      					//echo $sql;
      					$result = mysql_query($sql);
      					if ($result) {
      						$GLOBALS['DATAOUT'] .= "Added alias: " . stripslashes($tab['alt']) . " of " . stripslashes($tab['main']) . " to database: " . $tab['eqdkp'] . "\n";                                     
						$log_action = array('header' => '{L_ACTION_CTRT_ALIAS_ADDED}',
										'{L_CTRT_LABEL_ALIAS_NAME}' => $tab['alt'],
										'{L_CTRT_LABEL_MEMBER_NAME}' => $tab['main'],
										'{L_ADDED_BY}' => addslashes($GLOBALS['DKPUSER']));
						LogAction($tab['eqdkp'], $tab['prefix'], $log_action);
					} else mysql_error();
				} 
				if ($tab['action'] == "DELETE") {
					$sql = "DELETE FROM " . $tab['prefix'] . 'ctrt_aliases' . " WHERE alias_name = '"  . stripslashes($tab['alt'] . "'");
					//echo $sql;
      					$result = mysql_query($sql);
      					if ($result) {
      						$GLOBALS['DATAOUT'] .= "Deleted alias: " . stripslashes($tab['alt']) . " of " . stripslashes($tab['main']) . " from database: " . $tab['eqdkp'] . "\n";                                     
						$log_action = array('header' => '{L_ACTION_CTRT_ALIAS_DELETED}',
										'{L_CTRT_LABEL_ALIAS_NAME}' => $tab['alt'],
										'{L_CTRT_LABEL_MEMBER_NAME}' => $tab['main'],
										'{L_ADDED_BY}' => addslashes($GLOBALS['DKPUSER']));
						LogAction($tab['eqdkp'], $tab['prefix'], $log_action);
					} else mysql_error();
				}
			} else mysql_error();
		}
	}
	$GLOBALS['DATAOUT'] .= "\n";                                     
}

function AdjustDKP($changes, $parsedata) {
	foreach ($changes as $changeid=>$change) {
		$change = Arraydiff($parsedata[$changeid], $change);
		$change['members'] = ucwords($change['members']);
		$change['members'] = rtrim($change['members']);
		$change['members'] = explode("\n", $change['members']);
		$change['value'] = $parsedata[$changeid]['value'];
		$change['members'] = CheckAlias($change['members'], $change['eqdkp'], $change['prefix']);
		$change['members'] = array_unique($change['members']);
		if ($change['value']) {
			$user = $GLOBALS['DKPUSER'];
			$grp_key = gen_group_key(time(), stripslashes($change['event']), $change['value']);
			if ($change['name'] == "Group") {
				$counter = 0;
				foreach ($change['members'] as $name) {
					$adjusted = AddMultiAdjustment($name, $change, $change['eqdkp'], $change['prefix'], $grp_key);
					$counter++;
				}
				$log_action = array('header' => '{L_ACTION_INDIVADJ_ADDED}',
								'{L_ADJUSTMENT}' => $change['value'],
								'{L_REASON}' => $change['event'],
								'{L_MEMBERS}' =>  implode(", ", $change['members']),
								'{L_EVENT}' => $change['event'],
								'{L_ADDED_BY}' =>addslashes($user));
				$GLOBALS['DATAOUT'] .= "Added group adjustment to  $counter members by " . $change['value'] . " DKP in database: " . $change['eqdkp'] . "\n";                                     
			} else {
				AddMultiAdjustment($change['name'], $change, $change['eqdkp'], $change['prefix'], $grp_key); 
				$log_action = array('header' => '{L_ACTION_INDIVADJ_ADDED}',
								'{L_ADJUSTMENT}' => $change['value'],
								'{L_REASON}' => $change['event'],
								'{L_MEMBERS}' =>  $change['name'],
								'{L_EVENT}' => $change['event'],
								'{L_ADDED_BY}' =>addslashes($user));
				$GLOBALS['DATAOUT'] .= "Added member adjustment: " . $change['name'] . " by " . $change['value'] . " DKP in database: " . $change['eqdkp'] . "\n";                           
			}
			if ($adjusted) LogAction($change['eqdkp'], $change['prefix'], $log_action);
		}
	}
	$GLOBALS['DATAOUT'] .= "\n";          
}

function UpdateRaidData($parsedata) {
		$RAID = $GLOBALS['RAID'];
		foreach ($RAID as $raidnum => $raid) {
			$GLOBALS['DATAOUT'] .= "Updates to raid database: " . $raid['eqdkp'] . "\n";    
			$eqdkp = $raid['eqdkp'];
			$prefix = $raid['prefix'];
			$oldraids = FetchAllEvents($eqdkp, $prefix);
			$races = FetchAllRaces($eqdkp, $prefix);
			$classes = FetchAllClasses($eqdkp, $prefix);
			$members = FetchAllMembers($eqdkp, $prefix);
			$aliases = FetchAllAliases($eqdkp, $prefix);
			$trashdone = array();
			$trashdone[$raidnum] = false;
			foreach ($raid['attendees'] as $name => $attendees) {
				$isalias = CheckAlias(array('0' => $name), $eqdkp, $prefix);
				if ($name == $isalias[0]) {
					$attendees = CheckRace($attendees);
					if (!$members[$name]) {
						$newmember = array(	'member_name'=>"'" . addslashes($name) . "'",
									'member_firstraid'=>TimestringtoTimestamp($raid['date']),
									'member_lastraid'=>TimestringtoTimestamp($raid['date']),
									'member_raidcount'=>'1',
									'member_adjustment'=>'0');
						if ($attendees['level']) $newmember['member_level'] = $attendees['level'];
						if ($attendees['class']) {
							$newmember['member_class_id'] = $classes[$attendees['class']];
							if (empty($newmember['member_class_id'])) $newmember['member_class_id'] = '0';
						}
						if ($attendees['race']) {
							$newmember['member_race_id'] = $races[$attendees['race']];
							if (empty($newmember['member_race_id'])) $newmember['member_race_id'] = '0';
						}
						if (AddNEWMember($name, $attendees, $newmember, $eqdkp, $prefix)) {
							$GLOBALS['DATAOUT'] .= "Added new member: $name " . $attendees['level'] . " " . $attendees['race'] . " " . $attendees['class'] .  "\n";                                   
						}
					} else {
						if ($races[$attendees['race']] != $members[$name]['member_race_id'] or $classes[$attendees['class']] != $members[$name]['member_class_id'] or $attendees['level'] != $members[$name]['member_level']) {
							$changed = array(	'member_level'=>$attendees['level'],
										'member_class_id'=>$classes[$attendees['class']],
										'member_race_id'=>$races[$attendees['race']]);
							if (UpdateMember($name, $members[$name], $changed, $eqdkp, $prefix, 1)) {
								$GLOBALS['DATAOUT'] .= "Updated member: $name  " . $attendees['level'] . " " . $attendees['race'] . " " . $attendees['class'] .  "\n";                                      
							}
						} 
					}
				}	
			}
			$members = FetchAllMembers($eqdkp, $prefix);
			foreach ($raid['events'] as $eventid => $event) {
				$event_id = $oldraids[$event['name']]['event_id'];
				if ($event_id) {
					$oldraiddata = $oldraids[$event['name']];
					$oldname = $event['name'];
				}
				$event = Arraydiff($parsedata[$raidnum]['events'][$eventid], $event);
				$event['attendees'] = ucwords($event['attendees']);
				$event['attendees'] = rtrim($event['attendees']);
				$event['attendees'] = explode("\n", $event['attendees']);
				$event['attendees'] = CheckAlias($event['attendees'], $eqdkp, $prefix);
				$event['attendees'] = array_unique($event['attendees']);
				$RAID[$raidnum]['events'][$eventid] = $event;
				if (!empty($event['name']) and !empty($event['attendees'][0])) {
					$eventname = stripslashes($event['name']);
					foreach ($event['attendees'] as $anum => $aname) {
						$aname = rtrim($aname);
						if (!$members[$aname]) {
							$newmember = array(	'member_name'=>"'" . addslashes($aname) . "'",
										'member_firstraid'=>TimestringtoTimestamp($raid['date']),
										'member_lastraid'=>TimestringtoTimestamp($raid['date']),
										'member_raidcount'=>'1',
										'member_adjustment'=>'0');
							if (AddNEWMember($aname, '', $newmember, $eqdkp, $prefix)) {
								$GLOBALS['DATAOUT'] .= "Added new member: $aname\n";                                     
							}
						}
					}
					if (empty($event['value'])) $event['value'] = 0;
					if ($oldraids[$eventname]) {
						if ($oldraids[$eventname]['event_value'] != $event['value']) {
							UpdateEvent($eventname, $oldraids[$eventname], $event, $eqdkp, $prefix);
							$GLOBALS['DATAOUT'] .= "Updated event: $eventname to " . $event['value'] . " DKP.\n";                                     
						}
					} else {
						if (!$event_id) {
							CreateEvent($eventname, $event, $eqdkp, $prefix);
							$GLOBALS['DATAOUT'] .= "Created new event: $eventname for " . $event['value'] . " DKP.\n";        
						} else {
							UpdateEvent($eventname, $oldraiddata, $event, $eqdkp, $prefix);
							$GLOBALS['DATAOUT'] .= "Updated event: $oldname to $eventname.\n"; 
						}
					}
					if (!empty($raid['loot'][$event['index']])) {
						$event['zsum'] = 0;
						foreach ($raid['loot'][$event['index']] as $lootid => $eventloot) {
							$parsedindex = $event['index'];
							$eventloot = Arraydiff($parsedata[$raidnum]['loot'][$parsedindex][$lootid], $eventloot);
							$eventloot['ItemName'] = ucwords($eventloot['ItemName']);
							$eventloot['Player'] = ucwords($eventloot['Player']);
							$event['zsum'] += $eventloot['Costs'];
							$raid['loot'][$event['index']][$lootid] = $eventloot;
						}
					}	
					if (!empty($raid['loot']['Trash mob']) and !$trashdone[$raidnum] and $event['trash'] == 2) {
						$raid['zsumtrash'] = 0;
						foreach ($raid['loot']['Trash mob'] as $lootid => $eventloot) {
							$eventloot = Arraydiff($parsedata[$raidnum]['loot']['Trash mob'][$lootid], $eventloot);
							$eventloot['ItemName'] = ucwords($eventloot['ItemName']);
							$eventloot['Player'] = ucwords($eventloot['Player']);
							$raid['zsumtrash'] += $eventloot['Costs'];
							$raid['loot']['Trash mob'][$lootid] = $eventloot;
						}
					}	
					$members = FetchAllMembers($eqdkp, $prefix);
					$oldraids = FetchAllEvents($eqdkp, $prefix);
					$changed = array();
					if ($parsedata[$raidnum]['zsum']) {
						if ($event['zsum'] > 0) {
							$newval = intval($event['zsum']/count($event['attendees']));
							$event['value'] = $newval;
							$RAID[$raidnum]['event'][$eventid]['value'] = $newval;
						} else $event['value'] = 0;
						if (!$trashdone[$raidnum]) {
							$num = count($raid['attendees']);
							$newval = intval($raid['zsumtrash']/$num);
							foreach ($raid['attendees'] as $zname => $attendees) {
								if (!$changed[$zname]['member_earned']) {
									$changed[$zname]['member_earned'] = $members[$zname]['member_earned'] + newval;
								} else $changed[$zname]['member_earned'] += $newval;
							}
							$GLOBALS['DATAOUT'] .= "Added $newval DKP to $num attendees for trash drops.\n"; 
						}
					}
					foreach ($event['attendees'] as $atenname) {
						$atenname = rtrim($atenname);
						$changed[$atenname]['member_lastraid'] = TimestringtoTimestamp($raid['date']);
						$changed[$atenname]['member_raidcount'] = $members[$atenname]['member_raidcount'] + 1;
						if (!$changed[$atenname]['member_earned']) {
							$changed[$atenname]['member_earned'] = $members[$atenname]['member_earned'] + $event['value'];
						} else $changed[$atenname]['member_earned'] += $event['value'];
					}
					$raidid = CreateRaid($event, $raid, $oldraids[$eventname], $eqdkp, $prefix);
					if ($raidid) {
						AddRaidAttendees($raidid, $members, $event['attendees'], $eqdkp, $prefix);
						$GLOBALS['DATAOUT'] .= "Added raid: $eventname worth " .  $event['value'] . " DKP with " . count($event['attendees']) . " attendees.\n"; 
						if ($raid['loot'][$event['index']]) {
							foreach ($raid['loot'][$event['index']] as $lootdata) {
								if (!empty($lootdata['ItemName']) and !empty($lootdata['Player'])) {
									$isalias = CheckAlias(array('0' => $lootdata['Player']), $eqdkp, $prefix);
									$lootdata['Player'] = $isalias[0];
									AddRaidItem($raidid, $lootdata, $lootdata['eqdkp'], $lootdata['prefix']);
									$changed[$lootdata['Player']]['member_spent'] = $members[$lootdata['Player']]['member_spent'] + $lootdata['Costs'];
									$GLOBALS['DATAOUT'] .= "Added item: " . $lootdata['ItemName'] . " worth " .  $lootdata['Costs'] . " DKP to " . $lootdata['Player'] . " Database: " . $lootdata['eqdkp'] . ".\n"; 
								}
							}
						}
						if (!$trashdone[$raidnum] and !empty($raid['loot']['Trash mob']) and $event['trash'] == 2) {
							$trashdone[$raidnum] = true;
							foreach ($raid['loot']['Trash mob'] as $trashid => $trashloot) {
								if (!empty($trashloot['ItemName']) and !empty($trashloot['Player'])) {
									$isalias = CheckAlias(array('0' => $trashloot['Player']), $eqdkp, $prefix);
									$trashloot['Player'] = $isalias[0];
									AddRaidItem($raidid, $trashloot, $trashloot['eqdkp'], $trashloot['prefix']);
									if ($changed[$trashloot['Player']]['member_spent']) {
										$newval = $changed[$trashloot['Player']]['member_spent'] + $trashloot['Costs'];
									} else $newval = $members[$trashloot['Player']]['member_spent'] + $trashloot['Costs'];
									$changed[$trashloot['Player']]['member_spent'] = $newval;
									$GLOBALS['DATAOUT'] .= "Added item: " . $trashloot['ItemName'] . " worth " .  $trashloot['Costs'] . " DKP to " . $trashloot['Player']  . " Database: " . $trashloot['eqdkp'] . ".\n"; 
								}
							}
						}
						foreach ($changed as $cname => $cdata) {
							UpdateMember($cname, $members[$cname], $cdata, $eqdkp, $prefix, 0);
						}		
					}
				}
			}
		$GLOBALS['DATAOUT'] .= "\n";        	
		}
}

global $DKPUSER, $USERID, $DATAOUT, $RAID;
$DKPUSER = $user->data['username'];
$USERID = $user->data['user_id'];
$DATAOUT = "";
$RAID = $_SESSION['RAID'];
if (isset($_POST['altfield'])) {
	$altarray = $_POST['altfield'];
	$newalts = $_SESSION['passalts'];
	$newalts = array_merge_keys($altarray, $newalts);
	InsertAliases($newalts);
}
if (isset($_POST['raidfield'])) {
	$raidfields = $_POST['raidfield'];
	$raidfields = stripslashes_deep($raidfields);
	//echo "<pre>";
	//print_r($RAID);
	//print_r($raidfields);
	//echo "</pre>";
	UpdateRaidData($raidfields);
}
if (isset($_POST['changevalue'])) {
	$needchanged = $_SESSION['dkpchange'];
	$valuearray = $_POST['changevalue'];
	AdjustDKP($needchanged, $valuearray);
}
?>


<html>
<head>
<style type="text/css">
h1 {text-align: right; margin-right: 50px; font-size: 12px}
</style>
</head>
<body style="font-family: Arial; font-size: 16px; background-color: #101030; color: #FDFDFD; text-align: left; padding-left: 50px; padding-top: 20px;">
<h1><a href="<?php echo $admin_path?>" target="_self" style="color: #FDFDFD;">Return to eqDKP Admin</a></h1>
<b><u>MorgDKP Import</u><br>
<br>
<br>
Changes made to eqDKP database:</b>
<pre>
<?php echo $DATAOUT; ?>
</pre>
</body>
</html>