-- ******************************************************************
-- ******************************************************************
-- **                         RaidFunctions			                                  **
-- ******************************************************************
-- ******************************************************************
--

local L = AceLibrary("AceLocale-2.2"):new("MorgDKP")
local dewdrop = AceLibrary("Dewdrop-2.0")
local BC = AceLibrary("Babble-Class-2.2")
local MorgDKP_classes = { [1] = BC["Paladin"], [2] = BC["Warrior"], [3] = BC["Hunter"], [4] = BC["Rogue"], [5] = BC["Druid"], [6] = BC["Mage"], [7] = BC["Warlock"], [8] = BC["Priest"], [9] = BC["Shaman"], [10] = L["All"]}
local MorgDKP_Quality = {[0] = "|c009d9d9d", [1] = "|c00ffffff", [2] = "|c001eff00", [3] = "|c000070dd", [4] = "|c00a335ee", [5] = "|c00ff8000", [6] = "|c00e6cc80"}

StaticPopupDialogs["MorgClearRaids"] = {
	text = TEXT(L["cleardb"]),
	button1 = TEXT(YES),
	button2 = TEXT(NO),
	OnAccept = function()
		MorgDKP:ClearRaidDB()
	end,
	timeout = 0,
	whileDead = 1,
	hideOnEscape = 1,
}

function MorgDKP:ExportRaids() 
	self:OutputRaid(self.db.account.raidlog)
	self.db.account.raidlog.raidexport = L["complete"]
	StaticPopup_Show ("MorgClearRaids")
end

function MorgDKP:ExportCurrentRaid() 
	if not self.raidid then return end
	self:OutputRaid(self.db.account.raidlog, self.raidid)
end

function MorgDKP:ClearRaidDB()
	self.db.account.raidlog = { }
	self.db.account.defaults.raidnum = 0
	 self.db.account.raidlog[self.db.account.defaults.raidnum] = {}
	 self.db.account.raidlog.lootbuffer = { }
	self.db.account.raidlog.raidstart = L["pending"]
	self.db.account.raidlog.raidend = L["pending"]
	self.db.account.raidlog.raidexport = L["pending"]
	self.db.account.raidlog.dkpevents = {}
	 self.db.account.raidlog.aliases = { }
	self.db.account.defaults.InRaid = nil
	DEFAULT_CHAT_FRAME:AddMessage(L["cleared"])
end

function MorgDKP:CustomEvent() 
	if not self:IsRaided() then return end
	if not self.db.account.defaults.InRaid then 
		DEFAULT_CHAT_FRAME:AddMessage(L["noraid"])
		return 
	end
	if not self.db.account.defaults.custom then self.db.account.defaults.custom = L["NEW"] end
	if self.db.account.defaults.custom == L["NONE"] then return end 
	local event = self.db.account.defaults.custom
	if self.db.account.defaults.custom == L["NEW"] then event = event .. " Event"
	else event = event .. " Attempt" end
	self:LogBossKill(date("%m/%d/%y %H:%M:%S"), event, 1, event) 
end

function MorgDKP:RaidTablet()
	if not MorgDKP_Raid:IsShown() then
		PanelTemplates_SetNumTabs(MorgDKP_Raid, 5)
		PanelTemplates_SetTab(MorgDKP_Raid, 1)
		MorgDKP_RaidsPage1:Show()
		MorgDKP_RaidsPage2:Hide()
		MorgDKP_RaidsPage3:Hide()
		MorgDKP_RaidsPage4:Hide()
		MorgDKP_RaidsPage5:Hide()
		MorgDKP_Raid:Show()
	end
	self:ShowDefaultRaid()
 end
 
function MorgDKP:SetupDropMenu()
	local Raidmenu = { }
	for raidindex = 1, self.db.account.defaults.raidnum do
		Raidmenu[raidindex] = "Raid"..raidindex
	end
	Raidmenu[#Raidmenu + 1] = "Close"
	self:CreateDropdownmenu(Raidmenu, 0)
end

function MorgDKP:ShowDropMenu(frame)
	dewdrop:Open(frame,
		'children', function(level, value)
					dewdrop:FeedAceOptionsTable(MorgDKP.Dropdownmenu)
		end,
		 'cursorX', true,
		 'cursorY', true
	)
end

function MorgDKP:ShowDefaultRaid()
	self:ClearRaidFrame()
	if self.db.account.defaults.raidnum == 0 then return end
	MorgDKP_RaidsPage1Raid:SetText("Raid"..self.db.account.defaults.raidnum)
	self:ChangeRaidsFrame(self.db.account.defaults.raidnum) 
end

function MorgDKP:CreateDropdownmenu(menu, action)
	MorgDKP.Dropdownmenu = {
				 type = "text",
				 name = L["ad"],
				 desc = L["ad"],
				get = function(v) return v end,
				set = function(v) self:HandleDropDialogue(v, menu, action) end,
				validate = menu
	}
end

function MorgDKP:ClearRaidFrame()
	MorgDKP_RaidsPage1Name:SetText("")
	MorgDKP_RaidsPage1Name:Hide()
	MorgDKP_RaidsPage1RaidNameLabel:Hide()
	MorgDKP_RaidsPage1Note:SetText("")
	MorgDKP_RaidsPage1Note:Hide()
	MorgDKP_RaidsPage1RaidNoteLabel:Hide()
	MorgDKP_RaidsPage1Value:SetText("")
	MorgDKP_RaidsPage1Value:Hide()
	MorgDKP_RaidsPage1RaidValueLabel:Hide()
	MorgDKP_RaidsPage1Attendees:SetText("")
	MorgDKP_RaidsPage1Attendees:Hide()
	MorgDKP_RaidsPage1RaidAttendeesLabel:Hide()
	MorgDKP_RaidsPage1Delete:Hide()
	MorgDKP_RaidsPage1Update:Hide()
	MorgDKP_RaidsPage1ExportCurrent:Hide()
	MorgDKP_RaidsPage1Add:Hide()
	MorgDKP_RaidsPage1Clear:Hide()
	MorgDKP_RaidsPage1ItemLabel:Hide()
	MorgDKP_RaidsPage1ItemWinner:Hide()
	MorgDKP_RaidsPage1ItemWinnerLabel:Hide()
	MorgDKP_RaidsPage1ItemValue:Hide()
	MorgDKP_RaidsPage1ItemValueLabel:Hide()
	MorgDKP_RaidsPage1DeleteItem:Hide()
	MorgDKP_RaidsPage1EventChoose:Hide()
	self:ScrollBar_Clear(MorgDKP_RaidsPage1)
	self:ScrollBar2_Clear()
	self.editevent = nil
	self.scrolldata2 = nil
end

function MorgDKP:CloseRaidtracker()
	self.scrolldata = nil
	self.scrolldata2 = nil
end

function MorgDKP:HandleDropDialogue(value, data, action)
	dewdrop:Close() 
	if value == "Close" then return end
	if action == 0 then 	--RAIDS
		_, _, raidnum = string.find(value, "Raid(%d+)")
		raidnum = tonumber(raidnum)
		MorgDKP_RaidsPage1Raid:SetText(value)
		self:ClearRaidFrame()
		self:ChangeRaidsFrame(raidnum) 
	elseif action == 2 then --DKP
		MorgDKP_RaidsPage3Members:Hide()
		MorgDKP_RaidsPage3Value:SetText("0")
		MorgDKP_RaidsPage3Members:SetText("")
		self:ChangeDKPFrame(value) 
	elseif action == 3 then --ALIASES
		self:ChangeAliasFrame(value) 
	end	
end

function MorgDKP:ChangeRaidsFrame(raidid)
	MorgDKP_RaidsPage1RaidNameLabel:Show()
	MorgDKP_RaidsPage1Name:Show()
	MorgDKP_RaidsPage1RaidNoteLabel:Show()
	MorgDKP_RaidsPage1Note:Show()
	MorgDKP_RaidsPage1RaidValueLabel:Show()
	MorgDKP_RaidsPage1Value:Show()
	MorgDKP_RaidsPage1RaidAttendeesLabel:Show()
	MorgDKP_RaidsPage1Attendees:Show()
	MorgDKP_RaidsPage1EventChoose:Show()
	if not self.editevent then MorgDKP_RaidsPage1Add:Show() end
	self.raidid = raidid
	self.editevent = nil
	local numevents = #self.db.account.raidlog[raidid].bosskills
	self.scrolldata = { }
	if numevents > 0 then 
		self.maxitems = 9
		for event, eventdata in pairs(self.db.account.raidlog[raidid].bosskills) do
			self.scrolldata[event] =  { name = eventdata.name, value = eventdata.value, time = eventdata.time, attendees = eventdata.attendees, note = eventdata.note, trash = eventdata.trash}
   		end
   		self.scrollframe = MorgDKP_RaidsPage1
   		self:ScrollBar_Update()
   	end
end

function MorgDKP:TextEscapePressed(frame)
	frame:ClearFocus()
end

function MorgDKP:TextEnterPressed(frame)
	local f = frame
	local name = f:GetName()
	f:ClearFocus()
	if name == "MorgDKP_RaidsPage1Note" then 
		if not self.raidid or not self.editevent then return end
		self.db.account.raidlog[self.raidid].bosskills[self.editevent].note = f:GetText() 
		self:ChangeRaidsFrame(self.raidid)
	elseif name == "MorgDKP_RaidsPage1Name" then 
		if not self.raidid or not self.editevent then return end
		self.db.account.raidlog[self.raidid].bosskills[self.editevent].name = f:GetText() 
		self:ChangeRaidsFrame(self.raidid)
	elseif name == "MorgDKP_RaidsPage1Value" then 
		if not self.raidid or not self.editevent then return end
		local newvalue = tonumber(f:GetText()) 
		local oldvalue = self.scrolldata[self.editevent].value
		local attendees = self.scrolldata[self.editevent].attendees
		local POOL = self:GetPool(self.raidid)
		self:AwardDKP(newvalue, oldvalue, POOL, attendees)
		self.db.account.raidlog[self.raidid].bosskills[self.editevent].value = newvalue
		self:ChangeRaidsFrame(self.raidid)
	elseif name == "MorgDKP_RaidsPage1ItemWinner" then 
		local winner = f:GetText() 
		winner = string.upper(string.sub(winner,1,1))..string.lower(string.sub(winner,2,-1))
		local oldwinner = self.scrolldata2[self.edititem].winner
		local cost = self.scrolldata2[self.edititem].value
		local POOL = self:CheckPool(self.db.account.raidlog[self.raidid].loot[self.scrolldata2[self.edititem].index].ID)
		self:AdjustDKPPoints(winner, oldwinner, POOL, cost)
		self.db.account.raidlog[self.raidid].loot[self.scrolldata2[self.edititem].index].Player = winner
		self.scrolldata2[self.edititem].winner = winner
	elseif name == "MorgDKP_RaidsPage1ItemValue" then 
		local newcost = tonumber(f:GetText()) 
		local winner = self.scrolldata2[self.edititem].winner
		local oldcost =  self.scrolldata2[self.edititem].value
		local POOL = self:CheckPool(self.db.account.raidlog[self.raidid].loot[self.scrolldata2[self.edititem].index].ID)
		self:AdjustDKPPoints(winner, winner, POOL, newcost, oldcost)
		if self.db.account.defaults.zerosum then
				local diff = oldcost - newcost
				local addpoints = math.floor((diff/#self.db.account.raidlog[self.raidid].bosskills[self.editevent].attendees) + 0.5)
				self:AwardDKP(0, addpoints, POOL, self.db.account.raidlog[self.raidid].bosskills[self.editevent].attendees)
		end
		self.db.account.raidlog[self.raidid].loot[self.scrolldata2[self.edititem].index].Costs = newcost
		self.scrolldata2[self.edititem].value = newcost
	elseif name == "MorgDKP_RaidsPage2Value" then 
		local value = tonumber(f:GetText()) 
		self.db.account.items[self.edititemid].points = value
		self:UpdateItemValues()
	elseif name == "MorgDKP_RaidsPage5DKP" then self.db.account.defaults.dkpamount = math.floor(tonumber(f:GetText()) + 0.5)
	elseif name == "MorgDKP_RaidsPage5Time" then self.db.account.defaults.dkpsched = math.floor((tonumber(f:GetText()) * 60) + 0.5)
	elseif name == "MorgDKP_RaidsPage5SyncPW" then self.db.account.defaults.dbpassword = f:GetText() 
	elseif name == "MorgDKP_RaidsPage5EventFormat" then self:EventFormat(f:GetText())
	elseif name == "MorgDKP_RaidsPage5StartFormat" then self:StartFormat(f:GetText())
	elseif name == "MorgDKP_RaidsPage5TrashFormat" then self:TrashFormat(f:GetText())
	elseif name == "MorgDKP_RaidsPage5RunTime" then self:SetRunTime(f:GetText())
	elseif name == "MorgDKP_RaidsPage5PTakeNum" then 
		value = tonumber(f:GetText())
		if value >= 0 and value <= 100 then self.db.account.defaults.percent = value end
	elseif name == "MorgDKP_RaidsPage5OverBID" then self.db.account.defaults.overbid = math.floor(tonumber(f:GetText()) + 0.5)
	elseif name == "MorgDKP_RaidsPage5WaitStart" then self.db.account.defaults.waitstart = math.floor(tonumber(f:GetText()) + 0.5)
	elseif name == "MorgDKP_RaidsPage5WaitRun" then self.db.account.defaults.waitrun = math.floor(tonumber(f:GetText()) + 0.5)
	elseif name == "MorgDKP_RaidsPage5WaitBoss" then self.db.account.defaults.waitboss = math.floor(tonumber(f:GetText()) + 0.5)
	elseif name == "MorgDKP_RaidsPage5WaitOtime" then self.db.account.defaults.waitotime = math.floor(tonumber(f:GetText()) + 0.5)
	end
end

function MorgDKP:EditEvent(frame, name)
	if frame:GetName() == "MorgDKP_RaidsPage1" then self:EditRaidEvent(frame, name) 
	elseif frame:GetName() == "MorgDKP_RaidsPage3" then self:EditDKPChange(frame, name) 
	elseif frame:GetName() == "MorgDKP_RaidsPage4" then self:EditAlias(frame, name) 
	end
end

function MorgDKP:EditItem(frame, name)
	if string.find(name, "MorgDKP_RaidsPage2") then self:EditItemDB(name) return end
	local _, _, item = string.find(name, "MorgDKP_RaidsPage1Button(%d+)")
	item = tonumber(item)
	local offset = FauxScrollFrame_GetOffset(MorgDKP_RaidsPage1ScrollBar2)
	item = item - 10 + offset
	self.edititem = item 
	MorgDKP_RaidsPage1ItemWinnerLabel:Show()
	MorgDKP_RaidsPage1ItemValueLabel:Show()
	MorgDKP_RaidsPage1ItemWinner:SetText(self.scrolldata2[item].winner) 
	MorgDKP_RaidsPage1ItemWinner:Show()
	MorgDKP_RaidsPage1ItemValue:SetText(self.scrolldata2[item].value) 
	MorgDKP_RaidsPage1ItemValue:Show()
	MorgDKP_RaidsPage1DeleteItem:Show()
end

function MorgDKP:EditRaidEvent(frame, name) 
	local _, _, event = string.find(name, "MorgDKP_RaidsPage1Button(%d+)")
	event = tonumber(event)
	local offset = FauxScrollFrame_GetOffset(MorgDKP_RaidsPage1ScrollBar)
	event = event + offset
	self.editevent = event
	MorgDKP_RaidsPage1Name:SetText(self.scrolldata[event].name) 
	MorgDKP_RaidsPage1Name:Show()
	MorgDKP_RaidsPage1Note:SetText(self.scrolldata[event].note) 
	MorgDKP_RaidsPage1Note:Show()
	MorgDKP_RaidsPage1Value:SetText(self.scrolldata[event].value) 
	MorgDKP_RaidsPage1Value:Show()
	local attend = ""
	table.sort(self.scrolldata[event].attendees)
	for _, name in pairs(self.scrolldata[event].attendees) do
		attend = attend .. name .."\n"
	end
	MorgDKP_RaidsPage1Attendees:SetText(attend)
	MorgDKP_RaidsPage1Attendees:Show()
	MorgDKP_RaidsPage1Clear:Show()
	MorgDKP_RaidsPage1Add:Hide()
	MorgDKP_RaidsPage1Delete:Show()
	MorgDKP_RaidsPage1Update:Show()
	MorgDKP_RaidsPage1ExportCurrent:Show()
	MorgDKP_RaidsPage1ItemWinner:Hide()
	MorgDKP_RaidsPage1ItemValue:Hide()
	MorgDKP_RaidsPage1DeleteItem:Hide()
	self:UpdateItemList()
end

function MorgDKP:EnterEventData(name, frame) 
	local value = self.db.account.defaults.eqDKP[self.editpool].Events[name].value
	local attendees
	if self.editevent then
		local POOL =  self:GetPool(self.raidid)
		local oldvalue = self.db.account.raidlog[self.raidid].bosskills[self.editevent].value
		attendees = self.db.account.raidlog[self.raidid].bosskills[self.editevent].attendees
		if value ~= oldvalue then self:AwardDKP(value, oldvalue, POOL, attendees) end
		self.db.account.raidlog[self.raidid].bosskills[self.editevent].value = value
		self.db.account.raidlog[self.raidid].bosskills[self.editevent].name = name
		self.db.account.raidlog[self.raidid].bosskills[self.editevent].note = name
		self.scrolldata[self.editevent] =  self.db.account.raidlog[self.raidid].bosskills[self.editevent]
		self:ScrollBar_Update()
	else 
		attendees = self:ArraytoString(self.db.account.defaults.raidmembers)
		MorgDKP_RaidsPage1Attendees:SetText(attendees) 
	end
	MorgDKP_RaidsPage1Name:SetText(name)
	MorgDKP_RaidsPage1Note:SetText(name)
	MorgDKP_RaidsPage1Value:SetText(value) 
end

function MorgDKP:UpdateItemList()
	self.scrolldata2 = { }
	if not self.db.account.raidlog[self.raidid].loot then return end
	for index, itemdata in pairs(self.db.account.raidlog[self.raidid].loot) do
		if self.scrolldata[self.editevent].note == itemdata.Boss then 
			table.insert(self.scrolldata2, {link = itemdata.ItemLink, name = itemdata.ItemName, winner = itemdata.Player, value = itemdata.Costs, quality = MorgDKP_Quality[itemdata.Quality], index = index})
		elseif itemdata.Boss == "Trash mob" and self.scrolldata[self.editevent].trash == 2 then
			table.insert(self.scrolldata2, {link = itemdata.ItemLink, name = itemdata.ItemName, winner = itemdata.Player, value = itemdata.Costs,  quality = MorgDKP_Quality[itemdata.Quality], index = index})
		end
	end
	if #self.scrolldata2 == 0 then	MorgDKP_RaidsPage1ItemLabel:Hide()
	else MorgDKP_RaidsPage1ItemLabel:Show()	end
	MorgDKP_RaidsPage1ItemWinner:Hide()
	MorgDKP_RaidsPage1ItemValue:Hide()
	MorgDKP_RaidsPage1ItemWinnerLabel:Hide()
	MorgDKP_RaidsPage1ItemValueLabel:Hide()
	self.scrollframe2 = MorgDKP_RaidsPage1
	self.maxitems2 = 4
	self:ScrollBar_Update2()
end	

function MorgDKP:AddNewRaid() 
	if not self.raidid then return end
	local name = MorgDKP_RaidsPage1Name:GetText()
	local note = MorgDKP_RaidsPage1Note:GetText()
	local value = MorgDKP_RaidsPage1Value:GetText()
	local attendees = self.db.account.defaults.raidmembers
	if name == "" or  value == "" or not attendees[1] then
		DEFAULT_CHAT_FRAME:AddMessage(L["badformat"])
		return 
	end
	local POOL = self:GetPool(self.raidid)
	local killtime = date("%m/%d/%y %H:%M:%S")
	table.insert(self.db.account.raidlog[self.raidid].bosskills, {
							["name"] = name,
							["note"] = note,
							["time"] = killtime,
							["attendees"] = attendees,					
							["value"] = value,
							["trash"] = 0})
	DEFAULT_CHAT_FRAME:AddMessage(name..L["bosskill"]..killtime.." and "..tostring(#attendees)..L["attadded"])
	if value ~= 0 then self:AwardDKP(nil, value, POOL, attendees) end
	self:ClearRaidFrame()
	self:ChangeRaidsFrame(self.raidid)
end

function MorgDKP:ClearCurrentData() 
	self:ClearRaidFrame()
	MorgDKP_RaidsPage1Raid:SetText("Raid"..self.raidid)
	self:ChangeRaidsFrame(self.raidid) 
end

function MorgDKP:DeleteCurrentRaid()
	if self.editevent then
		local eventname = self.db.account.raidlog[self.raidid].bosskills[self.editevent].name
		local eventnote =  self.db.account.raidlog[self.raidid].bosskills[self.editevent].note
		local eventvalue = self.db.account.raidlog[self.raidid].bosskills[self.editevent].value
		local trash = self.db.account.raidlog[self.raidid].bosskills[self.editevent].trash
		local lootitems = #self.db.account.raidlog[self.raidid].loot
		if lootitems > 0 then
			for i = lootitems, 1, -1  do
				local data = self.db.account.raidlog[self.raidid].loot[i]
				local POOL = self:CheckPool(data.ID)
				if string.find(eventname, data.Boss) or string.find(eventnote, data.Boss) then
					if self.db.account.defaults.zerosum then
						local addpoints = math.floor((data.Costs/#self.db.account.raidlog[self.raidid].bosskills[self.editevent].attendees) + 0.5)
						self:AwardDKP(0, addpoints, POOL, self.db.account.raidlog[self.raidid].bosskills[self.editevent].attendees)
					end
					self:AdjustDKPPoints(data.Player, data.Player, POOL, nil, data.Costs)
					table.remove(self.db.account.raidlog[self.raidid].loot, i)
				end
			end
		end
		local POOL = self:GetPool(self.raidid)
		if not self.db.account.defaults.zerosum then 
			for _, name in pairs(self.db.account.raidlog[self.raidid].bosskills[self.editevent].attendees) do
				self.db.account.info[name][POOL].points = self.db.account.info[name][POOL].points - eventvalue
				self.db.account.info[name][POOL].earned = self.db.account.info[name][POOL].earned - eventvalue
			end
			DEFAULT_CHAT_FRAME:AddMessage(L["removed"]..tostring(eventvalue)..L["dkpword"] ..L["from"]..tostring(#self.db.account.raidlog[self.raidid].bosskills[self.editevent].attendees)..L["attend"])
		end
		if trash == 2 then DEFAULT_CHAT_FRAME:AddMessage(L["runevent"])
		else table.remove(self.db.account.raidlog[self.raidid].bosskills, self.editevent)
		end
		self:ClearRaidFrame()
		self:ChangeRaidsFrame(self.raidid)
	end
end

function MorgDKP:DeleteCurrentRaidItem() 
	if self.edititem then
		local winner = self.scrolldata2[self.edititem].winner
		local cost =  self.scrolldata2[self.edititem].value
		local POOL = self:CheckPool(self.db.account.raidlog[self.raidid].loot[self.scrolldata2[self.edititem].index].ID)
		if self.db.account.defaults.zerosum then
			local addpoints = math.floor((cost/#self.db.account.raidlog[self.raidid].bosskills[self.editevent].attendees) + 0.5)
			self:AwardDKP(0, addpoints, POOL, self.db.account.raidlog[self.raidid].bosskills[self.editevent].attendees)
		end
		self:AdjustDKPPoints(winner, winner, POOL, nil, cost)
		table.remove(self.db.account.raidlog[self.raidid].loot, self.scrolldata2[self.edititem].index)
		MorgDKP_RaidsPage1ItemWinner:Hide()
		MorgDKP_RaidsPage1ItemValue:Hide()
		self:ScrollBar2_Clear()
		self:UpdateItemList()
	end
end

function MorgDKP:UpdateCurrentAttend()
	local oldattend = { }
	local update = self:GetServerTime()
	for _, name in pairs(self.db.account.raidlog[self.raidid].bosskills[self.editevent].attendees) do
		oldattend[name] = true
	end
	local newattend = { }
	local temp = self:AttendtoArray(MorgDKP_RaidsPage1Attendees)
	for _, name in pairs(temp) do
		newattend[name] = true
	end
	local POOL = self:GetPool(self.raidid)
	local eventvalue = self.db.account.raidlog[self.raidid].bosskills[self.editevent].value
	if eventvalue ~= 0 then
		for name, _ in pairs(newattend) do
			if not oldattend[name] then
				self:PlayerinDB(name)
				self.db.account.info[name][POOL].points = self.db.account.info[name][POOL].points + eventvalue
				self.db.account.info[name][POOL].earned = self.db.account.info[name][POOL].earned + eventvalue
				self.db.account.info[name].lastupdate = update
				DEFAULT_CHAT_FRAME:AddMessage(L["add"]..tostring(eventvalue)..L["dkpword"] .."to2 "..name)
			end
		end
		for name, _ in pairs(oldattend) do
			if not newattend[name] then
				self:PlayerinDB(name)
				self.db.account.info[name][POOL].points = self.db.account.info[name][POOL].points - eventvalue
				self.db.account.info[name][POOL].earned = self.db.account.info[name][POOL].earned - eventvalue
				self.db.account.info[name].lastupdate = update
				DEFAULT_CHAT_FRAME:AddMessage(L["removed"]..tostring(eventvalue)..L["dkpword"] ..L["from"]..name)

			end
		end
	end
	self.db.account.raidlog[self.raidid].bosskills[self.editevent].attendees = temp
	self:ChangeRaidsFrame(self.raidid)
end

function MorgDKP:AddTarget(framename) 
	local target = UnitName("target")
	if not target then return end
	if UnitIsFriend("player","target") ~= 1 then return end
	if not self.editevent and framename ~= "MorgDKP_RaidsPage3Target" then return end
	if framename == "MorgDKP_RaidsPage1Target" then
		table.insert(self.db.account.raidlog[self.raidid].bosskills[self.editevent].attendees, target)
		local text = MorgDKP_RaidsPage1Attendees:GetText()
		text = text ..  target .. "\n"
		MorgDKP_RaidsPage1Attendees:SetText(text)
	elseif framename == "MorgDKP_RaidsPage3Target" then
		local olddata = MorgDKP_RaidsPage3Members:GetText()
		if string.len(olddata) > 1 then
			olddata = olddata .. target .."\n"
		else olddata = target .."\n" end
		MorgDKP_RaidsPage3Members:SetText(olddata)
	end
end

function MorgDKP:ShowItemsFrame()
	self:ClearItemsFrame()
	for index, name in pairs(MorgDKP_classes) do
		local classframe = getglobal("MorgDKP_RaidsPage2Class"..index.."Text")
		local altframe = getglobal("MorgDKP_RaidsPage2AltClass"..index.."Text")
		classframe:SetText(name)
		altframe:SetText(name)
	end
	self:UpdateItemsFrame() 
end

function MorgDKP:ClearItemsFrame()
	MorgDKP_RaidsPage2ItemName:Hide()
	MorgDKP_RaidsPage2ValueLabel:Hide()
	MorgDKP_RaidsPage2Value:Hide()
	MorgDKP_RaidsPage2ClassLabel:Hide()
	MorgDKP_RaidsPage2AltClassLabel:Hide()
	MorgDKP_RaidsPage2DeleteItem:Hide()
	MorgDKP_RaidsPage2IgnoreItem:Hide()
	for index = 1,10 do
		local classframe = getglobal("MorgDKP_RaidsPage2Class"..index)
		local altframe = getglobal("MorgDKP_RaidsPage2AltClass"..index)
		classframe:Hide()
		altframe:Hide()
	end
	self:UpdateItemsFrame() 
end

function MorgDKP:ToggleClass(frame)
	local name = frame:GetName()
	local _, _, id = string.find(name, "MorgDKP_RaidsPage2Class(%d+)")
	id = tonumber(id)
	if id and self.edititemid then
		local value = self.db.account.items[self.edititemid].classes[MorgDKP_classes[id]]
		self.db.account.items[self.edititemid].classes[MorgDKP_classes[id]] = not value
		if id == 10 then
			for num = 1 , 9 do
				self.db.account.items[self.edititemid].classes[MorgDKP_classes[num]] = not value
			end
			self:UpdateItemClasses()
		end
	end
end

function MorgDKP:ToggleAltClass(frame)
	local name = frame:GetName()
	local _, _, id = string.find(name, "MorgDKP_RaidsPage2AltClass(%d+)")
	id = tonumber(id)
	if id and self.edititemid then
		local value = self.db.account.items[self.edititemid].altclasses[MorgDKP_classes[id]]
		self.db.account.items[self.edititemid].altclasses[MorgDKP_classes[id]] = not value
		if id == 10 then
			for num = 1 , 9 do
				self.db.account.items[self.edititemid].altclasses[MorgDKP_classes[num]] = not value
			end
			self:UpdateItemClasses()
		end
	end
end

function MorgDKP:UpdateItemClasses()
	for index = 1,10 do
		local classframe = getglobal("MorgDKP_RaidsPage2Class"..index)
		local altframe = getglobal("MorgDKP_RaidsPage2AltClass"..index)
		classframe:SetChecked(self.db.account.items[self.edititemid].classes[MorgDKP_classes[index]])
		altframe:SetChecked(self.db.account.items[self.edititemid].altclasses[MorgDKP_classes[index]])
	end
end

function MorgDKP:UpdateItemsFrame() 
	self.scrolldata2 = { }
	if not self.db.account.items then return end
	for itemid, itemdata in pairs(self.db.account.items) do
		local sName, iLink, iQuality, _, _, _, _, _, _, _ = GetItemInfo(itemid)
		if  iLink then table.insert(self.scrolldata2, {name = sName, link = iLink,  quality = MorgDKP_Quality[iQuality], id = itemid}) end
	end
	table.sort(self.scrolldata2, function(a,b) return a.name<b.name end)
   	self.scrollframe2 = MorgDKP_RaidsPage2
   	self.maxitems2 = 15
   	self:ScrollBar_Update2()
end

function MorgDKP:DeleteCurrentItem()
	if not self.edititemid then return end
	self.db.account.items[self.edititemid] = nil
	self:ClearItemsFrame() 
end

function MorgDKP:IgnoreCurrentItem() 
	if not self.edititem then return end
	table.insert(self.db.account.defaults.ignore, self.scrolldata2[self.edititem].link)
end

function MorgDKP:EditItemDB(name) 
	local _, _, event = string.find(name, "MorgDKP_RaidsPage2Button(%d+)")
	event = tonumber(event)
	local offset = FauxScrollFrame_GetOffset(MorgDKP_RaidsPage2ScrollBar2)
	event = event + offset
	self.edititem = event
	self.edititemid = self.scrolldata2[event].id
	MorgDKP_RaidsPage2ValueLabel:Show()
	MorgDKP_RaidsPage2ClassLabel:Show()
	MorgDKP_RaidsPage2AltClassLabel:Show()
	MorgDKP_RaidsPage2ItemName:SetText(self.scrolldata2[event].quality .. self.scrolldata2[event].name .. "|r")
	MorgDKP_RaidsPage2ItemName:Show()
	MorgDKP_RaidsPage2Value:Show()
	MorgDKP_RaidsPage2DeleteItem:Show()
	MorgDKP_RaidsPage2IgnoreItem:Show()
	for index = 1,10 do
		local classframe = getglobal("MorgDKP_RaidsPage2Class"..index)
		local altframe = getglobal("MorgDKP_RaidsPage2AltClass"..index)
		classframe:Show()
		altframe:Show()
	end
	self:UpdateItemValues()
end	

function MorgDKP:UpdateItemValues()
	for index = 1,10 do
		local classframe = getglobal("MorgDKP_RaidsPage2Class"..index)
		local altframe = getglobal("MorgDKP_RaidsPage2AltClass"..index)
		classframe:SetChecked(self.db.account.items[self.edititemid].classes[MorgDKP_classes[index]])
		altframe:SetChecked(self.db.account.items[self.edititemid].altclasses[MorgDKP_classes[index]])
	end
	MorgDKP_RaidsPage2Value:SetText(self.db.account.items[self.edititemid].points)
end

function MorgDKP:ScrollBar_Update()
	local f = MorgDKP.scrollframe:GetName()
	local line
	local lineplusoffset
	local numevents = #MorgDKP.scrolldata
	local maxevents = MorgDKP.maxitems
	FauxScrollFrame_Update(getglobal(f.."ScrollBar"), numevents, maxevents, 35)
	for line=1,maxevents do
		lineplusoffset = line + FauxScrollFrame_GetOffset(getglobal(f.."ScrollBar"))
		if lineplusoffset <= numevents  then
			getglobal(f.."Button"..line):SetText(MorgDKP.scrolldata[lineplusoffset].name)
			getglobal(f.."Button"..line):Show()
		else
			getglobal(f.."Button"..line):Hide()
		end
	end
end

function MorgDKP:ScrollBar_Update2()
	local f = MorgDKP.scrollframe2:GetName()
	local buttonoffset = 0
	if f == "MorgDKP_RaidsPage1" then buttonoffset = 10 end
	local line
	local lineplusoffset
	local numevents = #MorgDKP.scrolldata2
	local maxevents = MorgDKP.maxitems2
	FauxScrollFrame_Update(getglobal(f.."ScrollBar2"), numevents, maxevents, 35)
	for line=1,maxevents do
		lineplusoffset = line + FauxScrollFrame_GetOffset(getglobal(f.."ScrollBar2"))
		if lineplusoffset <= numevents  then
			getglobal(f.."Button"..line + buttonoffset .."Name"):SetText(MorgDKP.scrolldata2[lineplusoffset].quality .. MorgDKP.scrolldata2[lineplusoffset].name .. "|r")
			getglobal(f.."Button"..line + buttonoffset .."ID"):SetText(MorgDKP.scrolldata2[lineplusoffset].link)
			getglobal(f.."Button"..line + buttonoffset):Show()
		else
			getglobal(f.."Button"..line + buttonoffset):Hide()
		end
	end
end

function MorgDKP:ScrollBar2_Clear()
	local f = MorgDKP_RaidsPage1:GetName()
	for line=1,6 do
		getglobal(f.."Button"..line + 10):Hide()
	end
	local f = MorgDKP_RaidsPage2:GetName()
	for line=1,15 do
		getglobal(f.."Button"..line):Hide()
	end
	MorgDKP_RaidsPage1ScrollBar2:Hide()
end

function MorgDKP:ScrollBar_Clear(frame)
	local f = frame:GetName()
	for line=1,9 do
		getglobal(f.."Button"..line):Hide()
	end
	MorgDKP_RaidsPage1ScrollBar:Hide()
end

function MorgDKP:ShowDKPFrame(frame)
	local DKPmenu  = { } 
	local index = 1
	for poolname, data in pairs(self.db.account.defaults.eqDKP) do
		DKPmenu[index] = poolname
		index = index + 1
	end
	DKPmenu[#DKPmenu + 1] = "Close"
	self:CreateDropdownmenu(DKPmenu, 2)
	self:ChangeDKPFrame(self.db.account.defaults.raid) 
end

function MorgDKP:ChangeDKPFrame(pool) 
	self.editpool = pool
	self.editevent = nil
	MorgDKP_RaidsPage3Pool:SetText(pool)
	local numevents
	if not self.db.account.raidlog.dkpevents then self.db.account.raidlog.dkpevents = { } end
	if not self.db.account.raidlog.dkpevents[pool] then 
		self.db.account.raidlog.dkpevents[pool] = { } 
		numevents = 0
	else numevents = #self.db.account.raidlog.dkpevents[pool] end
	self.scrolldata = { }
	self.maxitems = 15
	if numevents > 0 then
		for event = 1, numevents do
			self.scrolldata[event] =  self.db.account.raidlog.dkpevents[pool][event]
   		end
   	end
   	self.scrollframe = MorgDKP_RaidsPage3
   	self:ScrollBar_Update()
end

function MorgDKP:EditDKPChange(frame, name) 
	local _, _, event = string.find(name, "MorgDKP_RaidsPage3Button(%d+)")
	event = tonumber(event)
	local offset = FauxScrollFrame_GetOffset(MorgDKP_RaidsPage3ScrollBar)
	event = event + offset
	self.editevent = event 
	MorgDKP_RaidsPage3Value:SetText(self.scrolldata[event].value) 
	local attend = ""
	if #self.scrolldata[event].members > 1 then
		table.sort(self.scrolldata[event].members)
		for _, name in pairs(self.scrolldata[event].members) do
			attend = attend .. name .."\n"
		end
	else attend = self.scrolldata[event].members[1] end
	MorgDKP_RaidsPage3Members:SetText(attend)
	MorgDKP_RaidsPage3Members:Show()
end	

function MorgDKP:CustomDrop(frame, menu) 
	MorgDKP.Dropdown = {
				 type = "text",
				 name = L["ad"],
				 desc = L["ad"],
				get = function(v) return v end,
				set = function(v) self:HandleCustomDrop(v, frame) end,
				validate = menu
	}
	dewdrop:Open(frame,
		'children', function(level, value)
					dewdrop:FeedAceOptionsTable(MorgDKP.Dropdown)
		end,
		 'cursorX', true,
		 'cursorY', true
	)
end

function MorgDKP:HandleCustomDrop(value, frame)
	dewdrop:Close() 
	if value == "Close" then return end
	local name = frame:GetName()
	if string.find(name, "MorgDKP_RaidsPage1") then self:EnterEventData(value, frame) 
	elseif string.find(name, "MorgDKP_RaidsPage3") then self:AddMember(value, frame) 
	elseif string.find(name, "MorgDKP_RaidsPage4") then self:ShowAliasUpdate(value, frame)
	end
end

function MorgDKP:IndividualDKPRaid(frame) 
	local playermenu  = { } 
	local index = 1
	for _, name in pairs(self.db.account.defaults.raidmembers) do
		playermenu[index] = name
		index = index + 1
	end
	playermenu[index] = "Close"
	self.addtype = "individual"
	self:CustomDrop(frame, playermenu) 
end

function MorgDKP:AddMember(name, frame)
	if name == "Clear" then MorgDKP_RaidsPage3Members:SetText("") return end
	if name == "Current Raid" then
		local olddata = MorgDKP_RaidsPage3Members:GetText()
		local adds = self:ArraytoString(self.db.account.defaults.raidmembers)
		if string.len(olddata) > 1 then
			olddata = olddata .. adds .."\n"
		else olddata = adds .."\n" end
		MorgDKP_RaidsPage3Members:SetText(olddata)
	else
		local olddata = MorgDKP_RaidsPage3Members:GetText()
		name = string.upper(string.sub(name,1,1))..string.lower(string.sub(name,2,-1))
		if string.len(olddata) > 1 then
			olddata = olddata .. name .."\n"
		else olddata = name .."\n" end
		MorgDKP_RaidsPage3Members:SetText(olddata)
		MorgDKP_RaidsPage3Members:Show()
		if frame:GetName() == "MorgDKP_RaidsPage3Individual" then self:AddMemberData(name, {[1] = name}) end
	end
	MorgDKP_RaidsPage3Members:Show()
end

function MorgDKP:AddMemberData(name, members)
	if not self.db.account.defaults.InRaid then DEFAULT_CHAT_FRAME:AddMessage(L["needraid"]) return end
	 local event = self:GetRunEvent()
	 table.insert(self.db.account.raidlog.dkpevents[self.editpool], {    name = name, 
									value = MorgDKP_RaidsPage3Value:GetText(), 
									members = members, 
									eqdkp = self.db.account.defaults.eqDKP[self.editpool].eqDKPsite,
									prefix = self.db.account.defaults.eqDKP[self.editpool].prefix,
									addtype = self.addtype,
									event = self.db.account.raidlog[self.db.account.defaults.raidnum].bosskills[event].note})
	self:ChangeDKPFrame(self.editpool) 
end

function MorgDKP:GroupDKPRaid(frame) 
	local playermenu  = { } 
	local index = 2
	playermenu[1] = "Current Raid"
	for _, name in pairs(self.db.account.defaults.raidmembers) do
		playermenu[index] = name
		index = index + 1
	end
	playermenu[index] = "Clear"
	playermenu[index + 1] = "Close"
	self.addtype = "Group"
	if frame:GetName() == "MorgDKP_RaidsPage3Decay" then self.addtype = "Decay" end
	self:CustomDrop(frame, playermenu) 
	self:ChangeDKPFrame(self.editpool) 
end

function MorgDKP:DeleteCurrentDKPChange() 
	self:AwardDKP(0, self.db.account.raidlog.dkpevents[self.editpool][self.editevent].value, self.editpool, self.db.account.raidlog.dkpevents[self.editpool][self.editevent].members)
	table.remove(self.db.account.raidlog.dkpevents[self.editpool], self.editevent)
	MorgDKP_RaidsPage3Members:Hide()
	MorgDKP_RaidsPage3Value:SetText("0")
	MorgDKP_RaidsPage3Members:SetText("")
	self:ChangeDKPFrame(self.editpool) 
end

function MorgDKP:AddDKPChange() 
	if self.addtype == "individual" then return end
	local attendees = self:AttendtoArray(MorgDKP_RaidsPage3Members)
	local value = MorgDKP_RaidsPage3Value:GetText()
	self:AddMemberData(self.addtype, attendees)
	MorgDKP_RaidsPage3Members:SetText("")
	self:AwardDKP(nil, value, self.editpool, attendees)
	self:ChangeDKPFrame(self.editpool) 
end

function MorgDKP:AttendtoArray(frame)
	local attends = {self:Explode(frame:GetText(), "\n")}
	local attendees = { }
	local count = 1
	for i = 1, #attends do
		if string.len(attends[i]) > 1 and attends[i] and attends[i] ~= "" then 
			--attends[i] = string.upper(string.sub(attends[i],1,1))..string.lower(string.sub(attends[i],2,-1))
			attendees[count] = attends[i] 
			count = count + 1
		end
	end
	table.sort(attendees)
	return attendees
end

function MorgDKP:ArraytoString(array)
	local attend = ""
	if #array > 1 then
		table.sort(array)
		for _, name in pairs(array) do
			attend = attend .. name .."\n"
		end
	else attend = array[1] end
	return attend
end

function MorgDKP:ShowAliasFrame(frame)
	local DKPmenu  = { } 
	local index = 1
	for poolname, data in pairs(self.db.account.defaults.eqDKP) do
		DKPmenu[index] = poolname
		index = index + 1
	end
	DKPmenu[#DKPmenu + 1] = "Close"
	self:CreateDropdownmenu(DKPmenu, 3)
	self:ChangeAliasFrame(self.db.account.defaults.raid) 
end

function MorgDKP:ChangeAliasFrame(pool) 
	self.editpool = pool
	if not self.db.account.raidlog.aliases then self.db.account.raidlog.aliases = { } end
	if not self.db.account.raidlog.aliases[pool] then self.db.account.raidlog.aliases[pool] = { } end
	self.editevent = nil
	MorgDKP_RaidsPage4Pool:SetText(pool)
	MorgDKP_RaidsPage4Alias:SetText("")
	MorgDKP_RaidsPage4Member:SetText("")
	local numevents
	numevents = #self.db.account.defaults.eqDKP[pool].Aliases
	self.scrolldata = { }
	self.maxitems = 15
	if numevents > 0 then
		for event = 1, numevents do
			self.scrolldata[event] =  {alt = self.db.account.defaults.eqDKP[pool].Aliases[event].alt, main = self.db.account.defaults.eqDKP[pool].Aliases[event].main, name = self.db.account.defaults.eqDKP[pool].Aliases[event].alt}
   		end
   	end
   	self.scrollframe = MorgDKP_RaidsPage4
   	self:ScrollBar_Update()
end

function MorgDKP:EditAlias(frame, name) 
	local _, _, event = string.find(name, "MorgDKP_RaidsPage4Button(%d+)")
	event = tonumber(event)
	local offset = FauxScrollFrame_GetOffset(MorgDKP_RaidsPage4ScrollBar)
	event = event + offset
	self.editevent = event 
	MorgDKP_RaidsPage4Alias:SetText(self.scrolldata[event].alt)
	MorgDKP_RaidsPage4Member:SetText(self.scrolldata[event].main)
end	

function MorgDKP:ChooseAlias(frame) 
	local playermenu  = { } 
	for _, name in pairs(self.db.account.defaults.raidmembers) do
		table.insert(playermenu, name)
	end
	table.sort(playermenu)
	table.insert(playermenu, "Close")
	self:CustomDrop(frame, playermenu) 
end

function MorgDKP:ChooseMember(frame) 
	local playermenu  = { } 
	for name, dkp in pairs(self.db.account.info) do
		if dkp[self.editpool]  then table.insert(playermenu, name) end
	end
	table.sort(playermenu)
	table.insert(playermenu, "Close")
	self:CustomDrop(frame, playermenu) 
end

function MorgDKP:ChooseEvent(frame) 
	if not self.raidid then return end
	local POOL = MorgDKP:GetPool(self.raidid)
	self.editpool = POOL
	local playermenu  = {}
	for event,data in pairs(self.db.account.defaults.eqDKP[POOL].Events) do
		table.insert(playermenu, event)
   	end
   	table.sort(playermenu)
	table.insert(playermenu, "Close")
	self:CustomDrop(frame, playermenu) 
end

function MorgDKP:DeleteCurrentAlias() 
	local main  = MorgDKP_RaidsPage4Member:GetText()
	local alt = MorgDKP_RaidsPage4Alias:GetText()
	if not  self.db.account.raidlog.aliases then  self.db.account.raidlog.aliases = { } end
	if not  self.db.account.raidlog.aliases[self.editpool] then  self.db.account.raidlog.aliases[self.editpool] = { } end
	table.remove(self.db.account.defaults.eqDKP[self.editpool].Aliases, self.editevent)
	table.insert(self.db.account.raidlog.aliases[self.editpool], {	alt = alt, 
									main = main, 
									eqdkp = self.db.account.defaults.eqDKP[self.editpool].eqDKPsite, 
									action = "DELETE"})
	for aliasnum, data in pairs(self.db.account.info[main].aliases) do
		if data.alt == alt and data.raid == self.editpool then
			table.remove(self.db.account.info[main].aliases, aliasnum)
			break
		end
	end
	self.db.account.info[alt] = nil
	self:ChangeAliasFrame(self.editpool) 
end

function MorgDKP:AddAlias() 
	local alt = MorgDKP_RaidsPage4Alias:GetText()
	local main = MorgDKP_RaidsPage4Member:GetText()
	if not self.db.account.info[main] then  DEFAULT_CHAT_FRAME:AddMessage(L["nomain"]) return end
	if not  self.db.account.raidlog.aliases then  self.db.account.raidlog.aliases = { } end
	if not  self.db.account.raidlog.aliases[self.editpool] then  self.db.account.raidlog.aliases[self.editpool] = { } end
	for _, data in pairs(self.db.account.defaults.eqDKP[self.editpool].Aliases) do
		if data.alt == alt then 
			DEFAULT_CHAT_FRAME:AddMessage(L["aliasexists"])
			return
		end
	end
	self:PlayerinDB(alt)
	self:PlayerinDB(main)
	self.db.account.info[alt][self.editpool] = {points = self.db.account.info[main][self.editpool].points,
						 earned = self.db.account.info[main][self.editpool].earned,
						 spent = self.db.account.info[main][self.editpool].spent}
	local update = self:GetServerTime()
	self.db.account.info[alt].lastupdate = update
	DEFAULT_CHAT_FRAME:AddMessage(tostring(self.db.account.info[main][self.editpool].points)..L["dkpp"]..L["transfer"]..main..L["to2"]..alt)
	if not self:DoesAliasExist(main, alt, self.editpool) then table.insert(self.db.account.info[main].aliases, {raid = self.editpool, alt = alt}) end
	table.insert(self.db.account.defaults.eqDKP[self.editpool].Aliases, {alt = alt, main = main})
	table.insert(self.db.account.raidlog.aliases[self.editpool], {	alt = alt, 
									main = main, 
									eqdkp = self.db.account.defaults.eqDKP[self.editpool].eqDKPsite, 
									action = "ADD"})
	self.db.account.info[main].lastupdate = update
	self:ChangeAliasFrame(self.editpool) 
end

function MorgDKP:DoesAliasExist(main, alt, pool)
	local match = nil
	for _, aliasdata in pairs(self.db.account.info[main]["aliases"]) do
		if aliasdata.alt == alt and aliasdata.raid == pool then
			match = true
			break
		end
	end
	return match
end

function MorgDKP:ShowAliasUpdate(name, frame)
	if frame:GetName() == "MorgDKP_RaidsPage4AliasChoose" then MorgDKP_RaidsPage4Alias:SetText(name)
	else MorgDKP_RaidsPage4Member:SetText(name) end
end

function MorgDKP:ShowOptionFrame(frame)
	MorgDKP_RaidsPage5AutozoneText:SetText(L["autozone"])
	self:SetTTScript(MorgDKP_RaidsPage5Autozone, L["autozonedesc"])
	MorgDKP_RaidsPage5StartrunText:SetText(L["startruntrack"])
	self:SetTTScript(MorgDKP_RaidsPage5Startrun, L["startruntrackdesc"])
	MorgDKP_RaidsPage5WhisperText:SetText(L["enablewhisper"])
	self:SetTTScript(MorgDKP_RaidsPage5Whisper, L["enablewhisperdesc"])
	MorgDKP_RaidsPage5MultipoolText:SetText(L["multi"])
	self:SetTTScript(MorgDKP_RaidsPage5Multipool, L["multidesc"])
	MorgDKP_RaidsPage5DkpawardText:SetText(L["dkpaward"])
	self:SetTTScript(MorgDKP_RaidsPage5Dkpaward, L["dkpawarddesc"])
	MorgDKP_RaidsPage5DKP:SetText(self.db.account.defaults.dkpamount)
	MorgDKP_RaidsPage5Time:SetText(self.db.account.defaults.dkpsched/60)
	MorgDKP_RaidsPage5SyncPW:SetText(self.db.account.defaults.dbpassword)
	self:SetTTScript(MorgDKP_RaidsPage5SyncPW, L["syncdbdesc"])
	MorgDKP_RaidsPage5RandomText:SetText(L["enablerandom"])
	self:SetTTScript(MorgDKP_RaidsPage5Random, L["enablerandomdesc"])
	MorgDKP_RaidsPage5ZsumText:SetText(L["enablezerosum"])
	self:SetTTScript(MorgDKP_RaidsPage5Zsum, L["enablezerosumdesc"])
	MorgDKP_RaidsPage5RelationalText:SetText(L["enablerelationaldkp"])
	self:SetTTScript(MorgDKP_RaidsPage5Relational, L["enablerelationaldkpdesc"])
	MorgDKP_RaidsPage5BidwarText:SetText(L["enablebidwar"])
	self:SetTTScript(MorgDKP_RaidsPage5Bidwar, L["enablebidwardesc"])
	MorgDKP_RaidsPage5SilentText:SetText(L["enablesilentauction"])
	self:SetTTScript(MorgDKP_RaidsPage5Silent, L["enablesilentauctiondesc"])
	MorgDKP_RaidsPage5OneRunText:SetText(L["onerun"])
	self:SetTTScript(MorgDKP_RaidsPage5OneRun, L["onerundesc"])
	MorgDKP_RaidsPage5BossAttemptText:SetText(L["bossattemptmode"])
	self:SetTTScript(MorgDKP_RaidsPage5BossAttempt, L["bossattemptmodedesc"])
	MorgDKP_RaidsPage5EventFormat:SetText(self.db.account.defaults.eventformat)
	self:SetTTScript(MorgDKP_RaidsPage5EventFormat, L["eventformatdesc"])
	MorgDKP_RaidsPage5StartFormat:SetText(self.db.account.defaults.startformat)
	self:SetTTScript(MorgDKP_RaidsPage5StartFormat, L["startformatdesc"])
	MorgDKP_RaidsPage5TrashFormat:SetText(self.db.account.defaults.trashformat)
	self:SetTTScript(MorgDKP_RaidsPage5TrashFormat, L["trashformatdesc"])
	MorgDKP_RaidsPage5RunTime:SetText(self.db.account.defaults.runrewardtime/60)
	self:SetTTScript(MorgDKP_RaidsPage5RunTime, L["runrewardtimedesc"])
	MorgDKP_RaidsPage5PTakeNum:SetText(self.db.account.defaults.percent)
	self:SetTTScript(MorgDKP_RaidsPage5PTakeNum, L["enablepercentdesc"])
	MorgDKP_RaidsPage5PTakeText:SetText(L["percenttake"])
	self:SetTTScript(MorgDKP_RaidsPage5PTake, L["percenttakedesc"])
	MorgDKP_RaidsPage5JustEnoughText:SetText(L["enablejustenough"])
	self:SetTTScript(MorgDKP_RaidsPage5JustEnough, L["enablejustenoughdesc"])
	MorgDKP_RaidsPage5OverBID:SetText(self.db.account.defaults.overbid)
	self:SetTTScript(MorgDKP_RaidsPage5OverBID, L["overbidmaxdesc"])
	MorgDKP_RaidsPage5WaitlistText:SetText(L["enablewait"])
	self:SetTTScript(MorgDKP_RaidsPage5Waitlist, L["enablewaitdesc"])
	MorgDKP_RaidsPage5WaitStart:SetText(self.db.account.defaults.waitstart)
	self:SetTTScript(MorgDKP_RaidsPage5WaitStart, L["waitstartamtdesc"])
	MorgDKP_RaidsPage5WaitRun:SetText(self.db.account.defaults.waitrun)
	self:SetTTScript(MorgDKP_RaidsPage5WaitRun, L["waitrunamtdesc"])
	MorgDKP_RaidsPage5WaitBoss:SetText(self.db.account.defaults.waitboss)
	self:SetTTScript(MorgDKP_RaidsPage5WaitBoss, L["waitbossamtdesc"])
	MorgDKP_RaidsPage5WaitOtime:SetText(self.db.account.defaults.waitotime)
	self:SetTTScript(MorgDKP_RaidsPage5WaitOtime, L["waitotimeamtdesc"])
	MorgDKP_RaidsPage5DKPListenText:SetText(L["dkplisten"])
	self:SetTTScript(MorgDKP_RaidsPage5DKPListen, L["dkplistendesc"])
	MorgDKP_RaidsPage5BroadcastLeadText:SetText(L["broadlead"])
	self:SetTTScript(MorgDKP_RaidsPage5BroadcastLead, L["broadleaddesc"])
	MorgDKP:UpdateOptionFrame()
end


function MorgDKP:UpdateOptionFrame()
	MorgDKP_RaidsPage5Autozone:SetChecked(self.db.account.defaults.autozone)
	MorgDKP_RaidsPage5Startrun:SetChecked(self.db.account.defaults.startrun)
	MorgDKP_RaidsPage5Whisper:SetChecked(self.db.account.defaults.whisper)
	MorgDKP_RaidsPage5Multipool:SetChecked(self.db.account.defaults.multiPool)
	MorgDKP_RaidsPage5Dkpaward:SetChecked(self.db.account.defaults.dkpaward)
	MorgDKP_RaidsPage5Random:SetChecked(self.db.account.defaults.random)
	MorgDKP_RaidsPage5Zsum:SetChecked(self.db.account.defaults.zerosum)
	MorgDKP_RaidsPage5Relational:SetChecked(self.db.account.defaults.relational)
	MorgDKP_RaidsPage5Bidwar:SetChecked(self.db.account.defaults.bidwar)
	MorgDKP_RaidsPage5Silent:SetChecked(self.db.account.defaults.silent)
	MorgDKP_RaidsPage5OneRun:SetChecked(self.db.account.defaults.OneEvent)
	MorgDKP_RaidsPage5BossAttempt:SetChecked(self.db.account.defaults.attemptmode)
	MorgDKP_RaidsPage5PTake:SetChecked(self.db.account.defaults.percenttake)
	MorgDKP_RaidsPage5JustEnough:SetChecked(self.db.account.defaults.justenough)
	MorgDKP_RaidsPage5Waitlist:SetChecked(self.db.account.defaults.waitaward)
	MorgDKP_RaidsPage5DKPListen:SetChecked(self.db.account.defaults.dkplistener)
	MorgDKP_RaidsPage5BroadcastLead:SetChecked(self.db.account.defaults.leadbroadcast)
	if self.db.account.defaults.random then 
		MorgDKP_RaidsPage5Multipool:Disable()
		MorgDKP_RaidsPage5Zsum:Disable()
		MorgDKP_RaidsPage5Relational:Disable()
		MorgDKP_RaidsPage5Bidwar:Disable()
		MorgDKP_RaidsPage5PTake:Disable()
	else 
		MorgDKP_RaidsPage5Multipool:Enable()
		MorgDKP_RaidsPage5Zsum:Enable()
		MorgDKP_RaidsPage5Relational:Enable()
		MorgDKP_RaidsPage5Bidwar:Enable()
		MorgDKP_RaidsPage5PTake:Enable()
	end
	if MorgDKP:IsValid() then MorgDKP_RaidsPage5Random:Disable()
	else MorgDKP_RaidsPage5Random:Enable() end
	if self.db.account.defaults.bidwar then 
		MorgDKP_RaidsPage5Silent:Enable()
		MorgDKP_RaidsPage5JustEnough:Enable()
		MorgDKP_RaidsPage5PTake:Disable()
		MorgDKP_RaidsPage5Relational:Disable()
	else 
		MorgDKP_RaidsPage5Silent:Disable()
		MorgDKP_RaidsPage5JustEnough:Disable()
		MorgDKP_RaidsPage5PTake:Enable()
		MorgDKP_RaidsPage5Relational:Enable()
	end
	if self.db.account.defaults.relational then MorgDKP_RaidsPage5Bidwar:Disable()
	else MorgDKP_RaidsPage5Bidwar:Enable() end
	if self.db.account.defaults.percent > 0 then MorgDKP_RaidsPage5Bidwar:Disable()
	elseif not  self.db.account.defaults.random then MorgDKP_RaidsPage5Bidwar:Enable() end
end

function MorgDKP:SetTTScript(frame, text)
	frame:SetScript("OnEnter", function()
					GameTooltip:SetOwner(frame, "ANCHOR_RIGHT")
					GameTooltip:SetText(text, 1, 1, 1, 1, 1)
					GameTooltip:Show()
				end)
end
	
function MorgDKP:ShowEndRaidFrame()
	local id = self:GetRunEvent()
	local runname = self.db.account.raidlog[self.db.account.defaults.raidnum].bosskills[id].note
	attendees = {}
	for name, jointime in pairs(self.db.account.raidlog[self.db.account.defaults.raidnum].join) do
		if not  self.db.account.raidlog.attendancedone or not self.db.account.raidlog.attendancedone[name]  then
			table.insert(attendees, name)
		end
	end
	local num = #attendees
	MorgDKP_EndRaidRaidname:SetText(string.format(L["endraidadd"], runname))
	MorgDKP_EndRaidQmark:Show()
	MorgDKP_EndRaidAttendees:Hide()
	MorgDKP_EndRaidEndstring:Hide()
	MorgDKP_EndRaidYESADD:Hide()
	MorgDKP_EndRaid:SetHeight(100)
	MorgDKP_EndRaid:SetWidth(350)
	if num > 0 then
		attendees = self:ArraytoString(attendees)
		MorgDKP_EndRaidAttendees:SetText(attendees)
		MorgDKP_EndRaidAttendees:Show()
		MorgDKP_EndRaidEndstring:SetText(string.format(L["endandadd"], self.db.account.defaults.runrewardtime/60))
		MorgDKP_EndRaidEndstring:Show()
		MorgDKP_EndRaidYESADD:Show()
		MorgDKP_EndRaid:SetHeight(150 + (num * 10))
		MorgDKP_EndRaidQmark:Hide()
	end
	MorgDKP_EndRaid:Show()
end

function MorgDKP:AddandEnd() 
	local attendees =  self:AttendtoArray(MorgDKP_EndRaidAttendees)
	if attendees then
		local id = self:GetRunEvent()
		local value = 0
		local POOL = self.db.account.defaults.raid
		if self.db.account.defaults.eqDKP[self.db.account.defaults.raid]['Events'][self.db.account.raidlog[self.db.account.defaults.raidnum].bosskills[id].name] then
			value = self.db.account.defaults.eqDKP[self.db.account.defaults.raid]['Events'][self.db.account.raidlog[self.db.account.defaults.raidnum].bosskills[id].name].value
		end
		for num, name in pairs(attendees) do
			if not  self.db.account.raidlog.attendancedone or not self.db.account.raidlog.attendancedone[name]  then
				table.insert(self.db.account.raidlog[self.db.account.defaults.raidnum].bosskills[id].attendees, name)
			end
		end
		if value then self:AwardDKP(nil, value, POOL, attendees, nil, 1) end
	end
	self:EndRaid()
	MorgDKP_EndRaid:Hide()
end
