-- ******************************************************************
-- ******************************************************************
-- **                         MorgDKP                             	 **
-- ******************************************************************
-- ******************************************************************


local L = AceLibrary("AceLocale-2.2"):new("MorgDKP")

function MorgDKP:UpdateRaidlist()
	local temp = {}
	local count = 1
	if not MorgDKP_DKP1 then  self:DefaultDKP() end
	for i = 1,5 do
		local dkp = getglobal("MorgDKP_DKP" .. i)
		if  dkp then temp[count] =  dkp
			count = count + 1
		end
	end
	local skipupdate = 1
	local timestamp
	if not self.db.account.Timestamp or self:TimeStampDiff(temp[1].Timestamp, self.db.account.Timestamp) then
		skipupdate = nil
		timestamp = tostring(temp[1].Timestamp)
		if  string.len(timestamp) < 12 then timestamp = "0" .. timestamp end
		self.db.account.Timestamp = timestamp
		timestamp =  self:GetServerTime()
		DEFAULT_CHAT_FRAME:AddMessage(L["updatedkp"])
	end
	if not skipupdate then
		self.db.account.defaults.eqDKP = { }
		self.db.account.defaults.raidlist = { }
		if not self.db.account.defaults.raid or self.db.account.defaults.raid == "Export your DKP!" then  self.db.account.defaults.raid = temp[1].Pool end
		for i, dkpray in pairs(temp) do
			if dkpray.Pool then
				self.db.account.defaults.raidlist[i] = dkpray.Pool
				self.db.account.defaults.eqDKP[dkpray.Pool]  = { }
				self.db.account.defaults.eqDKP[dkpray.Pool]["eqDKPsite"] = dkpray.eqdkpsite
				self.db.account.defaults.eqDKP[dkpray.Pool]["prefix"] = dkpray.prefix
				if dkpray.Events then
					self.db.account.defaults.eqDKP[dkpray.Pool]["Events"] = { }
					for event, details in pairs(dkpray.Events) do
						self.db.account.defaults.eqDKP[dkpray.Pool]["Events"][event] = { }
						self.db.account.defaults.eqDKP[dkpray.Pool]["Events"][event] = { ["id"] = details.id, ["value"] = details.value}
					end
				end
				if dkpray.Aliases then
					local aliascounter = 1
					self.db.account.defaults.eqDKP[dkpray.Pool]["Aliases"] = { }
					for alias, main in pairs(dkpray.Aliases) do
						self.db.account.defaults.eqDKP[dkpray.Pool]["Aliases"][aliascounter] = { }
						self.db.account.defaults.eqDKP[dkpray.Pool]["Aliases"][aliascounter] = { ["main"] = main, ["alt"] = alias}
						aliascounter = aliascounter + 1
						self:PlayerinDB(main)
						self:PlayerinDB(alias)
						local present = false
						if not self.db.account.info[main].aliases then self.db.account.info[main].aliases = { } end
						for numalias = 1 , #self.db.account.info[main].aliases do
							if self.db.account.info[main].aliases[numalias].alt == alias and self.db.account.info[main].aliases[numalias].raid == dkpray.Pool then
								present = true
							end
						end
						if not present then table.insert(self.db.account.info[main].aliases ,  {raid = dkpray.Pool, alt = alias}) end
					end
					table.sort(self.db.account.defaults.eqDKP[dkpray.Pool].Aliases, function(a,b) return a.alt<b.alt end)
				end
			end
			if dkpray.Points then
				local count = 0
				for name, v in pairs(dkpray.Points) do
					if not self.db.account.info[name] then self.db.account.info[name] = { } end
					self.db.account.info[name][dkpray.Pool] = {earned = v.earn + v.adj, spent = v.spent, points = v.bal }
					if self.db.account.defaults.devmode then self:Print(name.." and "..v.bal) end
					self.db.account.info[name].raidloot = 0
					self.db.account.info[name].lastupdate = timestamp
					count = count + 1
					if self.db.account.info[name].aliases then
						for m = 1, #self.db.account.info[name].aliases do
							if self.db.account.info[name].aliases[m].raid == self.db.account.defaults.raid then
								local alt = self.db.account.info[name].aliases[m].alt
								local mainpoints = self.db.account.info[name][dkpray.Pool].points
								if not self.db.account.info[alt] then self.db.account.info[alt] = { } end
								self.db.account.info[alt][dkpray.Pool] = { 	points = mainpoints,
														earned = self.db.account.info[name][dkpray.Pool].earned,
														spent = self.db.account.info[name][dkpray.Pool].spent }
								self.db.account.info[alt].raidloot = 0
								self.db.account.info[alt].lastupdate = timestamp
								if self.db.account.defaults.devmode then self:Print(L["aliasadd"]..alt.." of "..name.." with "..mainpoints.." DKP.") end
							end
						end
					end
				end
				DEFAULT_CHAT_FRAME:AddMessage(L["add"]..tostring(count)..L["playfrom"]..dkpray.Pool)
			end
		end
		MorgDKP_DKP1 = nil
		MorgDKP_DKP2 = nil
		MorgDKP_DKP3 = nil
		MorgDKP_DKP4 = nil
		MorgDKP_DKP5 = nil
	end
	self:ReclaimPool()
end

function MorgDKP:DefaultDKP()
	local name = UnitName("player")
	MorgDKP_DKP1 = {
		Timestamp = 010120000800,
		Pool = "Export your DKP!",
		eqdkpsite = "aqdkp",
		prefix = "eqdkp_",
		Points = {
			[name] = {earn = 1397.00,spent = 405.00,adj = 0.00,bal = 992}
		},
		Aliases = {
			["TestAlias"] = name
		},
		Events = {
			["Void Reaver"] = {id = 77,value = 3.00}
		},
	}
end

function MorgDKP:ConvertDB()
	local POOL = self.db.account.defaults.raid
	local update = self:GetServerTime()
	if self.db.account.defaults.dbupdated == 0 then return end
	if self.db.account.defaults.dbupdated < 2 then
		for index,v in pairs(self.db.account.info) do
			local temp = { }
			temp.raidloot = 0
			temp.lastupdate = v.lastupdate or update
			temp.aliases = v.aliases
			temp.items = v.items
			temp.class = v.class
			temp[POOL] = {points = 0, earned = 0, spent = 0}
			self.db.account.info[index] = temp
		end
		for id,data in pairs(self.db.account.items) do
			if not data.pool then self.db.account.items[id].pool =  POOL end
		end
		for id,data in pairs(self.db.account.items) do
			if not data.altclasses then self.db.account.items[id].altclasses =  { } end
		end
		if self.db.account.raidlogbackup then self.db.account.raidlogbackup = nil end
	else
		for name,data in pairs(self.db.account.info) do
			local temp = {}
			if data.items then
				for slot, itemdata in pairs(data.items) do
					if itemdata then
						for itemlink, _ in pairs(itemdata) do
							local _, _, ID = strfind(itemlink, "[^:]+:(%d+):")
							ID = tonumber(ID)
							table.insert(temp, ID)
						end
					end
				end
				self.db.account.info[name].items = temp
			end
		end
	end
	DEFAULT_CHAT_FRAME:AddMessage(L["converted"])
	self:ClearRaidDB()
end

function MorgDKP:ImportMorgItems()
	itemcount = self:ImportItemDB(MorgDKP_Items)
	DEFAULT_CHAT_FRAME:AddMessage(string.format(L["syncdone"], itemcount, 0))
	DEFAULT_CHAT_FRAME:AddMessage(L["deleteimportfile"])
	MorgDKP_Items = nil
end

function MorgDKP:ImportItemDB(items)
	local itemcount = 0
	if not self.db.account.items then self.db.account.items = { } end
	for id, data in pairs(items) do
		if not self.db.account.items[id] then
			self.db.account.items[id] = data
			itemcount = itemcount + 1
		end
	end
	return itemcount
end

function MorgDKP:AdjustDKPPoints(new, old, pool, newcost, oldcost)
	local update = self:GetServerTime()
	if new ~= old then
		self.db.account.info[old][pool].points = self.db.account.info[old][pool].points + newcost
		self.db.account.info[old][pool].spent = self.db.account.info[old][pool].spent - newcost
		self.db.account.info[old].raidloot = 0
		self.db.account.info[old].lastupdate = update
		self.db.account.info[new][pool].points = self.db.account.info[new][pool].points - newcost
		self.db.account.info[new][pool].spent = self.db.account.info[new][pool].spent + newcost
		self.db.account.info[new].raidloot = 1
		self.db.account.info[new].lastupdate = update
		DEFAULT_CHAT_FRAME:AddMessage(string.format(L["transferitem"], old, new, newcost))
	else
		local costdiff
		if not newcost then
			costdiff = oldcost
			newcost = 0
			self.db.account.info[old].raidloot = 0
		else costdiff = oldcost - newcost  end
		self.db.account.info[old][pool].points = self.db.account.info[old][pool].points + costdiff
		self.db.account.info[old][pool].spent = self.db.account.info[old][pool].spent - costdiff
		self.db.account.info[old].lastupdate = update
		DEFAULT_CHAT_FRAME:AddMessage(string.format(L["changedcost"], oldcost, newcost, old))
	end
end

function MorgDKP:GetPool(raidid)
	for pool, data in pairs(self.db.account.defaults.eqDKP) do
		if data.eqDKPsite == self.db.account.raidlog[raidid].eqdkp then return pool end
	end
	return self.db.account.defaults.raid
end

function MorgDKP:AwardDKP(new, old, pool, attendees, wait, quiet)
	local update = self:GetServerTime()
	if new == old then return end
	local diff
	if new then
		diff = new - old
	elseif old == 0 then return
	else diff = old end
	local counter = 0
	for _, name in pairs(attendees) do
		self:PlayerinDB(name)
		self:PointsPoolExists(name, pool)
		self.db.account.info[name][pool].points = self.db.account.info[name][pool].points + diff
		self.db.account.info[name][pool].earned = self.db.account.info[name][pool].earned + diff
		self.db.account.info[name].lastupdate = update
		counter = counter + 1
	end
	if not quiet then
		if wait then DEFAULT_CHAT_FRAME:AddMessage(L["add"]..tostring(diff)..L["dkpword"] ..L["to2"].. L["waitlist"] ..L["attend"])
		else
			if #attendees == 1 then DEFAULT_CHAT_FRAME:AddMessage(L["add"]..tostring(diff)..L["dkpword"] ..L["to2"]..attendees[1])
			else DEFAULT_CHAT_FRAME:AddMessage(L["add"]..tostring(diff)..L["dkpword"] ..L["to2"]..tostring(counter)..L["attend"])
			end
		end
	end
end

function MorgDKP:AwardWaitlistDKP(value, POOL, Boss, id)
	if #self.db.account.defaults.Waitlist.members == 0 then return end
	if not id then
		local eventnum
		for num, data in pairs(self.db.account.raidlog[self.db.account.defaults.raidnum].bosskills) do
			if string.find(data.name, Boss) or string.find(data.note, Boss) then eventnum = num break end
		end
		if not eventnum then return end
		if self.db.account.defaults.waitboss == 0 then return end
		if self.db.account.defaults.waitboss == value then
			 for num, name in pairs(self.db.account.defaults.Waitlist.members) do
				table.insert(self.db.account.raidlog[self.db.account.defaults.raidnum].bosskills[eventnum].attendees, name)
			end
		else
			self:AwardWaitotimeDKP(self.db.account.defaults.waitboss, POOL, Boss, self.db.account.defaults.Waitlist.members, "Group", "Group")
		end
		self:AwardDKP(nil, self.db.account.defaults.waitboss, POOL, self.db.account.defaults.Waitlist.members, 1)
	elseif id == 1 then
		if self.db.account.defaults.waitstart == 0 then return end
		if self.db.account.defaults.waitstart == value  then
			 for num, name in pairs(self.db.account.defaults.Waitlist.members) do
				table.insert(self.db.account.raidlog[self.db.account.defaults.raidnum].bosskills[1].attendees, name)
			end
		else
			self:AwardWaitotimeDKP(self.db.account.defaults.waitstart, POOL, Boss, self.db.account.defaults.Waitlist.members, "Group", "Group")
		end
		self:AwardDKP(nil, self.db.account.defaults.waitstart, POOL, self.db.account.defaults.Waitlist.members, 1)
	end
end

function MorgDKP:AwardWaitotimeDKP(value, POOL, eventname, attendees, name, type)
	self:Initialisedkpevents()
	table.insert(self.db.account.raidlog.dkpevents[POOL], {name = name,
											value = value,
											members = attendees,
											eqdkp = self.db.account.defaults.eqDKP[POOL].eqDKPsite,
											prefix = self.db.account.defaults.eqDKP[POOL].prefix,
											addtype = type,
											event = eventname})
end

function MorgDKP:AddIndividualWait(name)
	local POOL = self.db.account.defaults.raid
	local id = self:GetStartEvent()
	if self.db.account.defaults.waitstart > 0 and id then
	 	if self.db.account.defaults.waitstart == self.db.account.raidlog[self.db.account.defaults.raidnum].bosskills[id].value  then
	 		table.insert(self.db.account.raidlog[self.db.account.defaults.raidnum].bosskills[id].attendees, name)
		else self:AwardWaitotimeDKP(self.db.account.defaults.waitstart, POOL, self.db.account.raidlog[self.db.account.defaults.raidnum].bosskills[id].name, {[1] = name}, name, "individual")
		end
		self:AwardDKP(nil, self.db.account.defaults.waitstart, POOL, {[1] = name}, 1)
	end
end

function MorgDKP:TimestamptoTimestring(timestamp)
	local hours,  minutes, day, month, year, result
	minutes = string.sub(timestamp, -2)
	hours = string.sub(timestamp, -4, -3)
	year = string.sub(timestamp, -6, -5)
	month = string.sub(timestamp, -10, -9)
	day = string.sub(timestamp, 1, strlen(timestamp) - 10)
	if strlen(day) == 1 then day = "0" .. day end
	result = month .. "/" .. day .. "/" .. year .. " " .. hours .. ":" .. minutes .. ":00"
	return result
end

function MorgDKP:TimeDiff(time1, time2) --time1 is join time, time2 is current time
	local hours1, hours2, min1, min2, sec1, sec2, day1, day2, total1, total2, timediff

	if time1 and time2 then
		local _, _,  day1, hours1, min1, sec1 = string.find(time1, "%d+/(%d+)/%d+ (%d+):(%d+):(%d+)")
		local _, _,  day2, hours2, min2, sec2 = string.find(time2, "%d+/(%d+)/%d+ (%d+):(%d+):(%d+)")
		--DEFAULT_CHAT_FRAME:AddMessage("d"..day1.."h"..hours1.."m"..min1.."s"..sec1)
		total1 = ((( hours1 * 60 ) + min1) *60) + sec1
		total2 = ((( hours2 * 60 ) + min2) *60) + sec2
		if day2 ~= day1 then
			if day2 > day1 then total2 = total2 + 86400
			else total1 = total1 + 86400 end
		end
    		timediff = total2 - total1
    		return timediff
    	end
    	return 0
end

function MorgDKP:TimeStampDiff(time1, time2)
	local hours1, hours2, min1, min2, day1, day2, month1, month2, year1, year2, total1, total2, timediff

	if time1 and time2 then
		time1 = tostring(time1)
		time2 = tostring(time2)
		if strlen(time1) < 12 then time1 = "0" .. time1 end
		if strlen(time2) < 12 then time2 = "0" .. time2 end
		local _, _,  day1, month1, year1, hours1, min1 = string.find(time1, "(%d%d)(%d%d)(%d%d%d%d)(%d%d)(%d%d)")
		local _, _,  day2, month2, year2, hours2, min2 = string.find(time2, "(%d%d)(%d%d)(%d%d%d%d)(%d%d)(%d%d)")
		total1 = ((((((month1 * 30) + day1) * 24) + hours1) * 60 ) + min1)
		total2 = ((((((month2 * 30) + day2) * 24) + hours2) * 60 ) + min2)
		if year1 > year2 then return true
		elseif total1 > total2 then return true
		else return false
		end
    	end
    	return false
end

function MorgDKP:GetServerTime()
	--get UTC time
	local hour = date("!%H")
	local minute = date("!%M")
	local sec = date("!%S")
	local month = date("!%m")
	local day = date("!%d")
	local year = date("!%y")
	if strlen(day) == 1 then day = "0" .. day end
	if strlen(minute) == 1 then minute = "0" .. minute end
	if strlen(hour) == 1 then hour = "0" .. hour end
	if strlen(sec) == 1 then sec = "0" .. sec end
	local timereturn = month .. "/" .. day .. "/" .. year .. " " .. hour .. ":" .. minute .. ":" .. sec
	if self.db.account.defaults.devmode then self:Print(timereturn) end
	return timereturn
end
