-- ******************************************************************
-- ******************************************************************
-- **                         MorgDKP                              **
-- ******************************************************************
-- ******************************************************************


local L = AceLibrary("AceLocale-2.2"):new("MorgDKP")
local BC = AceLibrary("Babble-Class-2.2")
local dewdrop = AceLibrary("Dewdrop-2.0")
local FuBar = AceLibrary("FuBarPlugin-2.0")

local classes = { [1] = BC["Paladin"], [2] = BC["Warrior"], [3] = BC["Hunter"], [4] = BC["Rogue"], [5] = BC["Druid"], [6] = BC["Mage"], [7] = BC["Warlock"], [8] = BC["Priest"], [9] = BC["Shaman"], [10] = L["All"]}
local classcolors = {[1] = "|c00"..BC:GetHexColor("Paladin"), [2] = "|c00"..BC:GetHexColor("Warrior"), [3] = "|c00"..BC:GetHexColor("Hunter"), [4] = "|c00"..BC:GetHexColor("Rogue"), [5] = "|c00"..BC:GetHexColor("Druid"), [6] = "|c00"..BC:GetHexColor("Mage"), [7] = "|c00"..BC:GetHexColor("Warlock"), [8] = "|c00"..BC:GetHexColor("Priest"), [9] = "|c00"..BC:GetHexColor("Shaman")}
local Quality = {[1] = L["Poor"], [2] = L["Common"], [3] = L["Uncommon"], [4] = L["Rare"], [5] = L["Epic"], [6] = L["Legendary"], [7] = L["Artifact"]}
local BidStep = {[1] = "5", [2] = "10", [3] = "25", [4] = "50", [5] = "100", [6] = "200", [7] = "500"}

function MorgDKP:optGetKey(table, value)
	for k,v in pairs(table) do
		if value == v then 
			return k
		end
	end
end

function MorgDKP:DoOptions()
	local db = MorgDKP.db.account
	
	MorgDKP.classopts = {	
			type = "group",
				args = {
					class1 = {
						type = "toggle",
						name = classcolors[1]..classes[1],
						desc = classcolors[1]..classes[1],
						get = function() return db.items[myid].classes[classes[1]] end,
						set = function(v) db.items[myid].classes[classes[1]] = v end,
						order = 1
					},
					class2 = {
						type = "toggle",
						name = classcolors[2]..classes[2],
						desc = classcolors[2]..classes[2],
						get = function() return db.items[myid].classes[classes[2]] end,
						set = function(v) db.items[myid].classes[classes[2]] = v end,
						order = 2
					},
					class3 = {
						type = "toggle",
						name = classcolors[3]..classes[3],
						desc = classcolors[3]..classes[3],
						get = function() return db.items[myid].classes[classes[3]] end,
						set = function(v) db.items[myid].classes[classes[3]] = v end,
						order = 3
					},
					class4 = {
						type = "toggle",
						name = classcolors[4]..classes[4],
						desc = classcolors[4]..classes[4],
						get = function() return db.items[myid].classes[classes[4]] end,
						set = function(v) db.items[myid].classes[classes[4]] = v end,
						order = 4
					},
					class5 = {
						type = "toggle",
						name = classcolors[5]..classes[5],
						desc = classcolors[5]..classes[5],
						get = function() return db.items[myid].classes[classes[5]] end,
						set = function(v) db.items[myid].classes[classes[5]] = v end,
						order = 5
					},
					class6 = {
						type = "toggle",
						name = classcolors[6]..classes[6],
						desc = classcolors[6]..classes[6],
						get = function() return db.items[myid].classes[classes[6]] end,
						set = function(v) db.items[myid].classes[classes[6]] = v end,
						order = 6
					},
					class7 = {
						type = "toggle",
						name = classcolors[7]..classes[7],
						desc = classcolors[7]..classes[7],
						get = function() return db.items[myid].classes[classes[7]] end,
						set = function(v) db.items[myid].classes[classes[7]] = v end,
						order = 7
					},
					class8 = {
						type = "toggle",
						name = classcolors[8]..classes[8],
						desc = classcolors[8]..classes[8],
						get = function() return db.items[myid].classes[classes[8]] end,
						set = function(v) db.items[myid].classes[classes[8]] = v end,
						order = 8
					},
					class9 = {
						type = "toggle",
						name = classcolors[9]..classes[9],
						desc = classcolors[9]..classes[9],
						get = function() return db.items[myid].classes[classes[9]] end,
						set = function(v) db.items[myid].classes[classes[9]] = v end,
						order = 9
					},
					class10 = {
						type = "toggle",
						name = classcolors[8]..classes[10],
						desc = classcolors[8]..classes[10],
						get = function() return db.items[myid].classes[classes[10]] end,
						set = function(v) 
							db.items[myid].classes[classes[10]] = v 
							for num = 1 , 9 do
								db.items[myid].classes[classes[num]] = v
							end
						end,
						order = 10
					},
					closeit = {
						type = "execute",
						name = L["closemenu"],
						desc = L["closemenu"],
						func = function() dewdrop:Close() end,
						order = 11
					}
				}
	}
	MorgDKP.altclassopts = {	
			type = "group",
				args = {
					class1 = {
						type = "toggle",
						name = classcolors[1]..classes[1],
						desc = classcolors[1]..classes[1],
						get = function() return db.items[myid].altclasses[classes[1]] end,
						set = function(v) db.items[myid].altclasses[classes[1]] = v end,
						order = 1
					},
					class2 = {
						type = "toggle",
						name = classcolors[2]..classes[2],
						desc = classcolors[2]..classes[2],
						get = function() return db.items[myid].altclasses[classes[2]] end,
						set = function(v) db.items[myid].altclasses[classes[2]] = v end,
						order = 2
					},
					class3 = {
						type = "toggle",
						name = classcolors[3]..classes[3],
						desc = classcolors[3]..classes[3],
						get = function() return db.items[myid].altclasses[classes[3]] end,
						set = function(v) db.items[myid].altclasses[classes[3]] = v end,
						order = 3
					},
					class4 = {
						type = "toggle",
						name = classcolors[4]..classes[4],
						desc = classcolors[4]..classes[4],
						get = function() return db.items[myid].altclasses[classes[4]] end,
						set = function(v) db.items[myid].altclasses[classes[4]] = v end,
						order = 4
					},
					class5 = {
						type = "toggle",
						name = classcolors[5]..classes[5],
						desc = classcolors[5]..classes[5],
						get = function() return db.items[myid].altclasses[classes[5]] end,
						set = function(v) db.items[myid].altclasses[classes[5]] = v end,
						order = 5
					},
					class6 = {
						type = "toggle",
						name = classcolors[6]..classes[6],
						desc = classcolors[6]..classes[6],
						get = function() return db.items[myid].altclasses[classes[6]] end,
						set = function(v) db.items[myid].altclasses[classes[6]] = v end,
						order = 6
					},
					class7 = {
						type = "toggle",
						name = classcolors[7]..classes[7],
						desc = classcolors[7]..classes[7],
						get = function() return db.items[myid].altclasses[classes[7]] end,
						set = function(v) db.items[myid].altclasses[classes[7]] = v end,
						order = 7
					},
					class8 = {
						type = "toggle",
						name = classcolors[8]..classes[8],
						desc = classcolors[8]..classes[8],
						get = function() return db.items[myid].altclasses[classes[8]] end,
						set = function(v) db.items[myid].altclasses[classes[8]] = v end,
						order = 8
					},
					class9 = {
						type = "toggle",
						name = classcolors[9]..classes[9],
						desc = classcolors[9]..classes[9],
						get = function() return db.items[myid].altclasses[classes[9]] end,
						set = function(v) db.items[myid].altclasses[classes[9]] = v end,
						order = 9
					},
					class10 = {
						type = "toggle",
						name = classcolors[8]..classes[10],
						desc = classcolors[8]..classes[10],
						get = function() return db.items[myid].altclasses[classes[10]] end,
						set = function(v) 
							db.items[myid].altclasses[classes[10]] = v 
							for num = 1 , 9 do
								db.items[myid].altclasses[classes[num]] = v
							end
						end,
						order = 10
					},
					closeit = {
						type = "execute",
						name = L["closemenu"],
						desc = L["closemenu"],
						func = function() dewdrop:Close() end,
						order = 11
					}
				}
	}
	MorgDKP.MLopts = { 
  				type = "text",
  				name = L["mloot"],
  				desc = L["mlootdesc"],
  				get = function() return self.db.account.defaults.mlooter end,
 				set = function(v)  self.db.account.defaults.mlooter = v end,
				validate = self.db.account.defaults.raidmembers,
				order = 4
	}
	 MorgDKP.DEopts = {
				 type = "text",
				 name = L["denchanter"],
				 desc = L["denchanterdesc"],
				get = function() return self.db.account.defaults.disenchanter end,
				set = function(v) self.db.account.defaults.disenchanter = v  end,
				validate = self.db.account.defaults.raidmembers,
				order = 5
	}
	MorgDKP.RaidDBopts = {
				type = "text",
				name = L["pool"],
				desc = L["pooldesc"],
				get = function() return db.defaults.raid end,
				set = function(v) db.defaults.raid = v end,
				validate = db.defaults.raidlist
	}
	MorgDKP.Poolopts = {
				type = "text",
				name = L["pooluse"],
				desc = L["poolusedesc"],
				get = function() return v end,
				set = function(v) 
					MorgDKP:SetRollPool(v) 
				end,
				validate = db.defaults.raidlist
	}
	
	MorgDKP.dkpsystem = {	
			type = "group",
				args = {
					randomrolls = {
						type = "toggle",
						name = L["enablerandom"],
						desc = L["enablerandomdesc"],
						get = function()
							return db.defaults.random
						end,
						set = function(v)
							db.defaults.random = v
						end,
						disabled = function() return MorgDKP:IsValid() end,
						order = 110
					},
					multipool = {
							type = "toggle",
							name = L["multi"],
							desc = L["multidesc"],
							get = function()
								return db.defaults.multiPool
							end,
							set = function(v)
								db.defaults.multiPool = v
							end,
							disabled = function() return db.defaults.random end,
							order = 111
					},
					zsum = {
						type = "toggle",
						name = L["enablezerosum"],
						desc = L["enablezerosumdesc"],
						get = function()
							return db.defaults.zerosum
						end,
						set = function(v)
							db.defaults.zerosum = v
						end,
						disabled = function() return db.defaults.random or db.defaults.percent > 0 end,
						order = 112
					},
					reldkp = {
						type = "toggle",
						name = L["enablerelationaldkp"],
						desc = L["enablerelationaldkpdesc"],
						get = function()
							return db.defaults.relational
						end,
						set = function(v)
							db.defaults.relational = v
						end,
						disabled = function() return db.defaults.random or db.defaults.bidwar end,
						order = 114
					},
					bwar = {
						type = "toggle",
						name = L["enablebidwar"],
						desc = L["enablebidwardesc"],
						get = function()
							return db.defaults.bidwar
						end,
						set = function(v)
							db.defaults.bidwar = v
						end,
						disabled = function() return db.defaults.random or db.defaults.relational or db.defaults.percent  > 0 end,
						order = 116
					},
					pcnt = {
						type = "range",
						name = L["enablepercent"],
						desc = L["enablepercentdesc"],
						get = function()
							return db.defaults.percent
						end,
						set = function(v)
							db.defaults.percent = v
						end,
						step = 1,
						min = 0,
						max = 100,
						disabled = function() return db.defaults.random or db.defaults.zerosum or db.defaults.bidwar end,
						order = 118
					},
					skall = {
						type = "toggle",
						name = L["enableskall"],
						desc = L["enableskalldesc"],
						get = function()
							return db.defaults.SKall
						end,
						set = function(v)
							db.defaults.SKall = v
						end,
						order = 120
					},
					bossattempt = {
						type = "toggle",
						name = L["bossattemptmode"],
						desc = L["bossattemptmodedesc"],
						get = function()
							return db.defaults.attemptmode
						end,
						set = function(v)
							db.defaults.attemptmode = v
							self:TogglePlayerDies(db.defaults.attemptmode) 
						end,
						order = 122
					}
				}
			}
		
		MorgDKP.qualmenu = {
				type = "text",
				name = L["logquality"],
				desc = L["logqualitydesc"],
				get = function() return Quality[db.defaults.quality+1] end,
				set = function(v) db.defaults.quality = MorgDKP:optGetKey(Quality, v) - 1 end,
				validate = Quality,
				order = 105
		}
		
		MorgDKP.custommenu = {
				type = "text",
				name = L["custom"],
				desc = L["customdesc"],
				get = function() return  db.defaults.custom end,
				set = function(v) db.defaults.custom = v end,
				validate = MorgTracker_ZoneBosses[db.defaults.menuzone]
		}
		
		MorgDKP.opts = {
			type = "group",
				args = {
					header = {
						type = "header",
						name = "|c000070dd"..L["morgtitle"].."  |c00a335ee"..MorgDKP.version,
						icon = "Interface\\GroupFrame\\UI-Group-MasterLooter",
						iconHeight = 15,
						iconWidth = 15,
						handler = MorgDKP,
						order = 1
					}, 
					disable = {
						type = "execute",
						name = L["disablemod"],
						desc = L["disablemoddesc"],
						func = function() MorgDKPFu:DisableMorgDKP() end,
						disabled = "~IsActive",
						order = 2
					},
					mldemode = {
						type = "toggle",
						name = L["enablemlde"],
						desc = L["enablemldedesc"],
						get = function()
							return self.MLmode
						end,
						set = function(v)
							self.MLmode = v
						end,
						disabled = "~IsActive",
						order = 3
					},
					morgbidc = {
						type = "execute",
						name = L["morgbidcheck"],
						desc = L["morgbidcheckdesc"],
						func = function() MorgDKP:MorgBidQuery() end,
						disabled = "~IsActive",
						order = 6
					},
					dkpfunc = {
						type = "group",
						name = L["dkp"],
						desc = L["dkpdesc"],
						order = 7,
							args = {
								load = {
									type = "text",
									name = L["pool"],
									desc = L["pooldesc"],
									get = function() return db.defaults.raid end,
									set = function(v) db.defaults.raid = v end,
									validate = db.defaults.raidlist,
									disabled = "~IsActive",
    									order = 100								
								},
								startrd = {
									type = "execute",
									name = L["startraid"],
									desc = L["startraiddesc"],
									func = function() MorgDKP:BeginRaid() end,
									disabled = "~IsActive",
									order = 101
								},
								endrd = {
									type = "execute",
									name = L["endraid"],
									desc = L["endraiddesc"],
									func = function() MorgDKP:EndRaid() end,
									disabled = "~IsActive",
									order = 102
								},
								runbonus = {
									type = "execute",
									name = L["rundkp"],
									desc = L["rundkpdesc"],
									func = function() MorgDKP:ExportRaids() end,
									disabled = "~IsActive",
									order = 103
								},
								raidtracker = {
									type = "execute",
									name = L["raidtrack"],
									desc = L["raidtrackdesc"],
									func = function() MorgDKP:RaidTablet() end,
									order = 104
								},
								custommenu = {
									type = "text",
									name = L["custom"],
									desc = L["customdesc"],
									get = function() return  db.defaults.custom end,
									set = function(v) 
										db.defaults.custom = v 
										MorgDKP:CustomEvent() 
									end,
									validate =  MorgTracker_ZoneBosses[db.defaults.menuzone],
									disabled = "~IsActive",
									order = 106
								},
								clearraids = {
									type = "execute",
									name = L["clearraid"],
									desc = L["clearraiddesc"],
									func = function() MorgDKP:ClearRaidDB() end,
									order = 107
								},
								syncdb = {
									type = "execute",
									name = L["syncdb"],
									desc = L["syncdbdesc"],
									func = function() MorgDKP:SyncItemDB() end,
									disabled = "~IsActive",
									order = 108
								},
								itemhis = {
									type = "execute",
									name = L["itemhistory"],
									desc = L["itemhistorydesc"],
									func = function() MorgDKP:ItemHistory() end,
									order = 109
								},
								ignore = {
									type = "text",
									name = L["ignorelist"],
									desc = L["ignorelistdesc"],
									get = false,
									set = function(v) 
												for id,link in pairs(db.defaults.ignore) do
													if link == v then table.remove(db.defaults.ignore, id) break end
												end
										end,
									validate = db.defaults.ignore,
									disabled = function() return not db.defaults.ignore[1] end,
									order = 110
								},
								dkptype = {
									type = "group",
									name = L["dkptypes"],
									desc = L["dkptypesdesc"],
									order = 112,
									args = {
										randomrolls = {
											type = "toggle",
											name = L["enablerandom"],
											desc = L["enablerandomdesc"],
											get = function()
												return db.defaults.random
											end,
											set = function(v)
												db.defaults.random = v
											end,
											disabled = function() return MorgDKP:IsValid() end,
											order = 200
										},
										multipool = {
											type = "toggle",
											name = L["multi"],
											desc = L["multidesc"],
											get = function()
												return db.defaults.multiPool
											end,
											set = function(v)
												db.defaults.multiPool = v
											end,
											disabled = function() return db.defaults.random end,
											order = 202
										},
										zsum = {
											type = "toggle",
											name = L["enablezerosum"],
											desc = L["enablezerosumdesc"],
											get = function()
												return db.defaults.zerosum
											end,
											set = function(v)
												db.defaults.zerosum = v
											end,
											disabled = function() return db.defaults.random or db.defaults.percent > 0 end,
											order = 204
										},
										reldkp = {
											type = "toggle",
											name = L["enablerelationaldkp"],
											desc = L["enablerelationaldkpdesc"],
											get = function()
												return db.defaults.relational
											end,
											set = function(v)
												db.defaults.relational = v
											end,
											disabled = function() return db.defaults.random or db.defaults.bidwar end,
											order = 206
										},
										bwar = {
											type = "toggle",
											name = L["enablebidwar"],
											desc = L["enablebidwardesc"],
											get = function()
												return db.defaults.bidwar
											end,
											set = function(v)
												db.defaults.bidwar = v
											end,
											disabled = function() return db.defaults.random or db.defaults.relational or db.defaults.percent > 0 end,
											order = 208
										},
										pcnt = {
											type = "range",
											name = L["enablepercent"],
											desc = L["enablepercentdesc"],
											get = function()
												return db.defaults.percent
											end,
											set = function(v)
												db.defaults.percent = v
											end,
											step = 1,
											min = 0,
											max = 100,
											disabled = function() return db.defaults.random or db.defaults.zerosum or db.defaults.bidwar end,
											order = 210
										},
										skall = {
											type = "toggle",
											name = L["enableskall"],
											desc = L["enableskalldesc"],
											get = function()
												return db.defaults.SKall
											end,
											set = function(v)
												db.defaults.SKall = v
											end,
											order = 120
										},
									},
								},
								otherO = {
									type = "group",
									name = L["otheroptions"],
									desc = L["otheroptionsdesc"],
									order = 114,
									args = {
										bwarwhisper = {
											type = "toggle",
											name = L["enablewhisper"],
											desc = L["enablewhisperdesc"],
											get = function()
												return db.defaults.whisper
											end,
											set = function(v)
												db.defaults.whisper = v
											end,
											order = 200
										},
										azone = {
											type = "toggle",
											name = L["autozone"],
											desc = L["autozonedesc"],
											get = function()
												return db.defaults.autozone
											end,
											set = function(v)
												db.defaults.autozone = v
											end,
											order = 202
										},			
										dkplisten = {
											type = "toggle",
											name = L["dkplisten"],
											desc = L["dkplistendesc"],
											get = function()
												return db.defaults.dkplistener
											end,
											set = function(v)
												db.defaults.dkplistener = v
											end,
											order = 203
										},			
										broadcastlead = {
											type = "toggle",
											name = L["broadlead"],
											desc = L["broadleaddesc"],
											get = function()
												return db.defaults.leadbroadcast
											end,
											set = function(v)
												db.defaults.leadbroadcast = v
											end,
											order = 204
										},			
										starttrack = {
											type = "toggle",
											name = L["startruntrack"],
											desc = L["startruntrackdesc"],
											get = function()
												return db.defaults.startrun
											end,
											set = function(v)
												db.defaults.startrun = v
											end,
											order = 205
										},
										eventname = {
											type = "text",
											name = L["eventformat"],
											desc = L["eventformatdesc"],
											usage = "<char>",
											get = function()
													return db.defaults.eventformat
												end,
											set = function(text) 
													self:EventFormat(text)
												end,
											disabled = "~IsActive",
											order = 206
										},
										startname = {
											type = "text",
											name = L["startformat"],
											desc = L["startformatdesc"],
											usage = "<char>",
											get = function()
													return db.defaults.startformat
												end,
											set = function(text) 
													self:StartFormat(text)
												end,
											disabled = "~IsActive",
											order = 207
										},
										trashname = {
											type = "text",
											name = L["trashformat"],
											desc = L["trashformatdesc"],
											usage = "<char>",
											get = function()
													return db.defaults.trashformat
												end,
											set = function(text) 
													self:TrashFormat(text)
												end,
											disabled = "~IsActive",
											order = 208
										},
										onerun = {
											type = "toggle",
											name = L["onerun"],
											desc = L["onerundesc"],
											get = function()
												return db.defaults.OneEvent
											end,
											set = function(v)
												db.defaults.OneEvent = v
											end,
											order = 209
										},
										percenttake = {
											type = "toggle",
											name = L["percenttake"],
											desc = L["percenttakedesc"],
											get = function()
												return db.defaults.percenttake
											end,
											set = function(v)
												db.defaults.percenttake = v
											end,
											order = 210
										},
										bossattempt = {
											type = "toggle",
											name = L["bossattemptmode"],
											desc = L["bossattemptmodedesc"],
											get = function()
												return db.defaults.attemptmode
											end,
											set = function(v)
												db.defaults.attemptmode = v
												self:TogglePlayerDies(db.defaults.attemptmode) 
											end,
											order = 211
										},
										runtime = {
											type = "text",
											name = L["runrewardtime"],
											desc = L["runrewardtimedesc"],
											usage = "<char>",
											get = function()
													return math.floor(db.defaults.runrewardtime) / 60
												end,
											set = function(text) 
													self:SetRunTime(text)
												end,
											disabled = "~IsActive",
											order = 212
										},
										dkpadd = {
											type = "text",
											name = L["adddkp"],
											desc = L["adddkpdesc"],
											usage = "<char>",
											get = false,
											set = function(text) 
													charstring = text
													adding = 1
													MorgDKP:ChangeDKP()
												end,
											disabled = "~IsActive",
											order = 220
										},
										dkpsub = {
											type = "text",
											name = L["subdkp"],
											desc = L["subdkpdesc"],
											usage = "<char>",
											get = false,
											set = function(text) 
													charstring =  text
													adding = nil
													MorgDKP:ChangeDKP()
												end,
											disabled = "~IsActive",
											order = 221
										},
										devmode = {
											type = "toggle",
											name = L["devmode"],
											desc = L["devmode"],
											get = function()
												return db.defaults.devmode
											end,
											set = function(v)
												db.defaults.devmode = v
											end,
											order = 225
										},
									},
								},								
								waitopts = {
									type = "group",
									name = L["waitlist"],
									desc = L["waitlistdesc"],
									order = 115,
									args = {
										award = {
											type = "toggle",
											name = L["enablewait"],
											desc = L["enablewaitdesc"],
											get = function()
												return db.defaults.waitaward
											end,
											set = function(v)
												db.defaults.waitaward = v
											end,
											order = 200
										},
										waitstart = {
											type = "range",
											name = L["waitstartamt"],
											desc = L["waitstartamtdesc"],
											get = function()
												return db.defaults.waitstart
											end,
											set = function(v)
												db.defaults.waitstart = v
											end,
											step = 1,
											min = 0,
											max = 100,
											disabled = function() return not db.defaults.waitaward end,
											order = 202
										},
										waitrun = {
											type = "range",
											name = L["waitrunamt"],
											desc = L["waitrunamtdesc"],
											get = function()
												return db.defaults.waitrun
											end,
											set = function(v)
												db.defaults.waitrun = v
											end,
											step = 1,
											min = 0,
											max = 100,
											disabled = function() return not db.defaults.waitaward end,
											order = 204
										},
										waitboss = {
											type = "range",
											name = L["waitbossamt"],
											desc = L["waitbossamtdesc"],
											get = function()
												return db.defaults.waitboss
											end,
											set = function(v)
												db.defaults.waitboss = v
											end,
											step = 1,
											min = 0,
											max = 100,
											disabled = function() return not db.defaults.waitaward end,
											order = 204
										},
										waitotime = {
											type = "range",
											name = L["waitotimeamt"],
											desc = L["waitotimeamtdesc"],
											get = function()
												return db.defaults.waitotime
											end,
											set = function(v)
												db.defaults.waitotime = v
											end,
											step = 1,
											min = 0,
											max = 100,
											disabled = function() return not db.defaults.waitaward end,
											order = 206
										},
									},
								},
								bidwarO = {
									type = "group",
									name = L["bidwaroptions"],
									desc = L["bidwaroptionsdesc"],
									order = 116,
									args = {
										silent = {
											type = "toggle",
											name = L["enablesilentauction"],
											desc = L["enablesilentauctiondesc"],
											get = function()
												return db.defaults.silent
											end,
											set = function(v)
												db.defaults.silent = v
											end,
											disabled = function() return not db.defaults.bidwar end,
											order = 200
										},
										bwarstep = {
											type = "text",
											name = L["bwarsteps"],
											desc = L["bwarstepsdesc"],
											get = function() return BidStep[MorgDKP:optGetKey(BidStep, db.defaults.bidstep)] end,
											set = function(v) db.defaults.bidstep = v end,
											validate = BidStep,
											disabled = function() return not db.defaults.bidwar end,
											order = 202
										},
										overbid = {
											type = "text",
											name = L["overbidmax"],
											desc = L["overbidmaxdesc"],
											usage = "<char>",
											get = function() return db.defaults.overbid end,
											set = function(text)  db.defaults.overbid = text end,
											disabled = function() return  not db.defaults.bidwar end,
											order = 204
										},
										jenough = {
											type = "toggle",
											name = L["enablejustenough"],
											desc = L["enablejustenoughdesc"],
											get = function()
												return db.defaults.justenough
											end,
											set = function(v)
												db.defaults.justenough = v
											end,
											disabled = function() return not db.defaults.bidwar end,
											order = 206
										},
									},
								},
							},
					},
					teinly = {
						type = "text",
						name = L["twinks"],
						desc = L["twinksdesc"],
						usage = "<char>",
						get = false,
						set = function(text)  self:AddTwink(text) end,
						disabled = "~IsActive",
						order = 8
					},
					list = {
						type = "text",
						name = L["listdkp"],
						desc = L["listdkpdesc"],
						usage = "<all> <paladin> <rogue> <druid> <...>",
						get = false,
						set = function(text) self:ListDKP(text)  end,
						validate = classes,
						disabled = "~IsActive",
						order = 9
				  	},
				  	boes = { 
						type = "text",
						name = L["giveboe"],
						desc = L["giveboedesc"],
						get = false,
						set = function(text) charstring = text MorgDKP:GiveBOE(myid, mylink) end,
						validate = self.db.account.defaults.raidmembers,
						hidden = function() return  not self.hasitem end,
						disabled = "~IsActive",
						order = 10
					},
					additem = { 
						type = "execute",
						name = L["manualitem"],
						desc = L["manualitemdesc"],
						func = function() MorgDKP:ManualItem(myid, mylink) end,
						hidden = function() return  not self.hasitem end,
						disabled = "~IsActive",
						order = 11
					},
					setpt = {
						type = "text",
						name = L["setitempoints"],
						desc = L["setitempointsdesc"],
						usage = "<char>",
						get = function() return db.items[myid].points end,
						set = function(text) db.items[myid].points = text end,
						hidden = function() return  not self.hasitem  end,
						disabled = "~IsActive",
						order = 12
					},
					qraid = {
						type = "execute",
						name = L["queryraid"],
						desc = L["queryraiddesc"],
						func = function() MorgDKP:StartQuery(myid, mylink) end,
						hidden = function() return  not self.hasitem  end,
						disabled = "~IsActive",
						order = 13
					},
					spacer1 = {
						type = "header",
						order = 20
					},
					class1 = {
						type = "toggle",
						name = classcolors[1]..classes[1],
						desc = classcolors[1]..classes[1],
						get = function() return db.items[myid].classes[classes[1]] end,
						set = function(v) db.items[myid].classes[classes[1]] = v end,
						hidden = function() return  not self.hasitem  end,
						disabled = "~IsActive",
						order = 1000
					},
					class2 = {
						type = "toggle",
						name = classcolors[2]..classes[2],
						desc = classcolors[2]..classes[2],
						get = function() return db.items[myid].classes[classes[2]] end,
						set = function(v) db.items[myid].classes[classes[2]] = v end,
						hidden = function() return  not self.hasitem  end,
						disabled = "~IsActive",
						order = 1002
					},
					class3 = {
						type = "toggle",
						name = classcolors[3]..classes[3],
						desc = classcolors[3]..classes[3],
						get = function() return db.items[myid].classes[classes[3]] end,
						set = function(v) db.items[myid].classes[classes[3]] = v end,
						hidden = function() return  not self.hasitem  end,
						disabled = "~IsActive",
						order = 1004
					},
					class4 = {
						type = "toggle",
						name = classcolors[4]..classes[4],
						desc = classcolors[4]..classes[4],
						get = function() return db.items[myid].classes[classes[4]] end,
						set = function(v) db.items[myid].classes[classes[4]] = v end,
						hidden = function() return  not self.hasitem  end,
						disabled = "~IsActive",
						order = 1006
					},
					class5 = {
						type = "toggle",
						name = classcolors[5]..classes[5],
						desc = classcolors[5]..classes[5],
						get = function() return db.items[myid].classes[classes[5]] end,
						set = function(v) db.items[myid].classes[classes[5]] = v end,
						hidden = function() return  not self.hasitem end,
						disabled = "~IsActive",
						order = 1008
					},
					class6 = {
						type = "toggle",
						name = classcolors[6]..classes[6],
						desc = classcolors[6]..classes[6],
						get = function() return db.items[myid].classes[classes[6]] end,
						set = function(v) db.items[myid].classes[classes[6]] = v end,
						hidden = function() return  not self.hasitem  end,
						disabled = "~IsActive",
						order = 1010
					},
					class7 = {
						type = "toggle",
						name = classcolors[7]..classes[7],
						desc = classcolors[7]..classes[7],
						get = function() return db.items[myid].classes[classes[7]] end,
						set = function(v) db.items[myid].classes[classes[7]] = v end,
						hidden = function() return  not self.hasitem  end,
						disabled = "~IsActive",
						order = 1012
					},
					class8 = {
						type = "toggle",
						name = classcolors[8]..classes[8],
						desc = classcolors[8]..classes[8],
						get = function() return db.items[myid].classes[classes[8]] end,
						set = function(v) db.items[myid].classes[classes[8]] = v end,
						hidden = function() return  not self.hasitem  end,
						disabled = "~IsActive",
						order = 1014
					},
					class9 = {
						type = "toggle",
						name = classcolors[9]..classes[9],
						desc = classcolors[9]..classes[9],
						get = function() return db.items[myid].classes[classes[9]] end,
						set = function(v) db.items[myid].classes[classes[9]] = v end,
						hidden = function() return  not self.hasitem end,
						disabled = "~IsActive",
						order = 1016
					},
					class10 = {
						type = "toggle",
						name = classcolors[8]..classes[10],
						desc = classcolors[8]..classes[10],
						get = function() return db.items[myid].classes[classes[10]] end,
						set = function(v) 
							db.items[myid].classes[classes[10]] = v 
							for num = 1 , 9 do
								db.items[myid].classes[classes[num]] = v
							end
						end,
						hidden = function() return  not self.hasitem end,
						disabled = "~IsActive",
						order = 1018
					},
					Menu = {
						type = "group",
						name = L["Menu"],
						desc = L["Menu"],
						args = FuBar:GetAceOptionsDataTable(MorgDKPFu),
						hidden = function() return  self.hasitem  end,
						order = 300,
					}
			}
	}

	MorgDKP.opts.args.mlootdet = MorgDKP.MLopts
	MorgDKP.opts.args.deer = MorgDKP.DEopts
	MorgDKP.opts.args.dkpfunc.args.logqual = MorgDKP.qualmenu
end
