local L = AceLibrary("AceLocale-2.2"):new("MorgDKP")
local BZ = LibStub("LibBabble-Zone-3.0"):GetLookupTable()
local BC = AceLibrary("Babble-Class-2.2")
local tablet = AceLibrary("Tablet-2.0")
local dewdrop = AceLibrary("Dewdrop-2.0")
local MorgDKP = MorgDKP

MorgDKPFu = AceLibrary("AceAddon-2.0"):new("AceEvent-2.0", "AceDB-2.0", "FuBarPlugin-2.0")
MorgDKPFu.hasIcon = "Interface\\AddOns\\MorgDKP\\Icons\\AquaOFF"
MorgDKPFu.category = "Raid"
MorgDKPFu.title = "MorgDKP"
MorgDKPFu.defaultPosition = "RIGHT"
MorgDKPFu.clickableTooltip = true
MorgDKPFu.overrideMenu = true
MorgDKPFu.hasNoText = true
MorgDKPFu.tooltipHiddenWhenEmpty = true

MorgTracker_ZoneTriggers = {
	[BZ["Molten Core"]] = true,
	[BZ["Blackwing Lair"]] = true,
	[BZ["Zul'Gurub"]]= true,
	[BZ["Onyxia's Lair"]] = true,
	[BZ["Ruins of Ahn'Qiraj"]] = true,
	[BZ["Ahn'Qiraj"]] = true,
	[BZ["Naxxramas"]] = true,
	[BZ["Karazhan"]] = true,
	[BZ["Gruul's Lair"]] = true,
	[BZ["Magtheridon's Lair"]] = true,
	[BZ["Serpentshrine Cavern"]] = true,
	[BZ["Caverns of Time"]] = true,
	[BZ["Black Temple"]] = true,
	[BZ["Tempest Keep"]] = true,
	[BZ["Hyjal Summit"]] = true,
	[BZ["Alliance Base"]] = true,
	[BZ["Horde Encampment"]] = true,
	[BZ["Zul'Aman"]] = true,
	[BZ["Sunwell Plateau"]] = true,
	[L["WorldBoss"]] = true,
}

function MorgDKPFu:OnInitialize()
	self:RegisterDB("MorgDKPFuBarDB")
end

function MorgDKPFu:OnEnable()
	self:RegisterEvent("PLAYER_ENTERING_WORLD", "EnterWorld")
	self:RegisterEvent("ZONE_CHANGED_NEW_AREA", "ZoneChange")
	self:RegisterEvent("CHAT_MSG_WHISPER", "WhisperHandler")
	self:ChangeState()
end

function MorgDKPFu:ChangeState()
	if MorgDKP:IsActive() then
		self:SetIcon("Interface\\AddOns\\MorgDKP\\Icons\\AquaON")
		MorgDKPFu.hint = L["fubarhint"]
	else
		self:SetIcon("Interface\\AddOns\\MorgDKP\\Icons\\AquaOFF")
		MorgDKPFu.hint = L["fubarhintdisabled"]
	end
	self:Update()
end

function MorgDKPFu:EnterWorld()
	self:IsTrackedZone()
end

function MorgDKPFu:ZoneChange()
	if self:IsTrackedZone() then
		if not MorgDKP.db.account.defaults.InRaid and MorgDKP.db.account.defaults.autozone then MorgDKP:BeginRaid() end
	elseif not UnitIsGhost("player") and MorgDKP.db.account.defaults.InRaid and MorgDKP.db.account.defaults.autozone then MorgDKP:ShowEndRaidFrame() 
	end
end

function MorgDKPFu:IsTrackedZone()
	local ZoneName = GetRealZoneText()
	if MorgTracker_ZoneTriggers[ZoneName] then 
		if ZoneName == BZ["Alliance Base"] or ZoneName == BZ["Horde Encampment"] then ZoneName = BZ["Hyjal Summit"] end
		MorgDKP.db.account.defaults.menuzone = ZoneName
		self:ActivateMorgDKP()
		return true
	else
		MorgDKP.db.account.defaults.menuzone = L["WorldBoss"]
		self:DeActivateMorgDKP()
	end
	return false
end

function MorgDKPFu:ActivateMorgDKP()
	if MorgDKP.db.account.defaults.autozone and not UnitIsGhost("player") then
		if not MorgDKP:IsActive() then MorgDKP:ToggleActive(true) end
	end
	MorgDKP:ReclaimZone()
	self:ChangeState()
end

function MorgDKPFu:DeActivateMorgDKP()
	if MorgDKP:IsActive() and  MorgDKP.db.account.defaults.autozone and not UnitIsGhost("player") then MorgDKP:ToggleActive(false) end
	MorgDKP:ReclaimZone()
	self:ChangeState()
end
	 
function MorgDKPFu:DisableMorgDKP()
	MorgDKP:ToggleActive(false)
	self:ChangeState()
end

function MorgDKPFu:WhisperHandler(txt, sender)
	local command = string.upper(string.sub(txt, 1, 4))
	if command ~= "MBID" and command ~= "DKPL" then return end
	local active = MorgDKP:IsActive()
	if not active then 
		MorgDKP:ToggleActive(true) 
		self:ChangeState()
	end
	local raided = nil
	if MorgDKP:CheckRaid(sender) then raided = true end
	if MorgDKP.db.account.info[sender] and MorgDKP.db.account.info[sender].class then pclass = MorgDKP.db.account.info[sender].class end
	if command == "MBID" then 
		MorgDKP:OnBidWhisper(txt, sender)  
		if not active then self:DisableMorgDKP() end
		return
	end
	if command == "DKPL" and string.find(string.upper(txt), "POOLS") then 
		MorgDKP:ShowPools(txt, sender)
		if not active then self:DisableMorgDKP() end
		return
	end
	dkplist = MorgDKP:FillDKPTable(sender, pclass, txt, raided)
	local spaces = "                                                                                                                                    "
	local numspace = {10, 7, 5, 2, 1}
	for i,v in ipairs(dkplist) do
		local message = string.upper(v[1])
		message = message ..string.sub(spaces,1,(45 - MorgDKP:CalcSpaces(string.upper(v[1]))))..string.upper(v[2])
		message = message ..string.sub(spaces,1,(MorgDKP:CalcSpaces(string.upper(v[2]))))..string.sub(spaces,1,numspace[string.len(v[4])])..v[4].."   DKP"
		SendChatMessage(message, "WHISPER", nil, sender)
	end
	if not active then self:DisableMorgDKP() end
end

function MorgDKPFu:OnMenuRequest()
	MorgDKP.hasitem = nil
	dewdrop:FeedAceOptionsTable(MorgDKP.opts)
end

function MorgDKPFu:OnClick()
	if MorgDKP:IsActive() then
		if IsAltKeyDown() then
			MorgDKP.MLmode = not MorgDKP.MLmode
			self:Update()
		elseif IsShiftKeyDown() then
			MorgDKP:ListDKP("All")
			MorgDKP:ShowWaitlist()
		elseif IsControlKeyDown() then
			MorgDKP:RaidTablet()
		else 
			MorgDKP:MorgBidQuery()
		end
	else
		MorgDKP:ToggleActive(true)
		self:ChangeState()
	end
end

function MorgDKPFu:OnTooltipUpdate()
	tablet:SetHint(self.hint)
	if not MorgDKP:IsActive() then return end
	local cat = tablet:AddCategory('columns', 2)
	local colortog = 0
	local inraid = UnitInRaid("player")
	local MLstatustext = L["statusoff"]
	local attstatus = L["pending"]
	local dkpstatus = L["normal"]
	local Quality = {[1] = L["Poor"], [2] = L["Common"], [3] = L["Uncommon"], [4] = L["Rare"], [5] = L["Epic"], [6] = L["Legendary"], [7] = L["Artifact"]}
	if not inraid or not MorgDKP.db.account.defaults.mlooter then colortog = 1 end
	if MorgDKP.MLmode then MLstatustext = L["statuson"] end
	if MorgDKP.db.account.defaults.relational and MorgDKP.db.account.defaults.zerosum then dkpstatus = L["enablerelationaldkp"] .. " & " .. L["enablezerosum"] 
	elseif MorgDKP.db.account.defaults.relational then dkpstatus = L["enablerelationaldkp"]
	elseif MorgDKP.db.account.defaults.zerosum then dkpstatus = L["enablezerosum"] 
	elseif MorgDKP.db.account.defaults.percent > 0 then dkpstatus = L["enablepercent"] end
	if MorgDKP.db.account.defaults.bidwar then dkpstatus = dkpstatus .. " & " .. L["enablebidwar"] end
	if MorgDKP.db.account.defaults.random then dkpstatus = L["enablerandom"] end
	cat:AddLine(
 		'text', L["mloot"],
 		'textR', 0,
 		'textG', 0.7,
 		'textB', 0.8,
 		'text2', MorgDKP.db.account.defaults.mlooter or "NONE",
 		'text2R', 1 and colortog,
 		'text2G', 1,
 		'text2B', 0,
 		'func', function()
			dewdrop:Open(this,
				'children', function(level, value)
					dewdrop:FeedAceOptionsTable(MorgDKP.MLopts)
				end,
				'point', function(parent) return "LEFT", "RIGHT" end, 
				'strata', "HIGH")
			end
 	)
 	local colortog = 0
	if not inraid or not MorgDKP.db.account.defaults.disenchanter then colortog = 1 end
	cat:AddLine(
		'text', L["denchanter"],
		'textR', 0,
		'textG', 0.7,
		'textB', 0.8,
		'text2', MorgDKP.db.account.defaults.disenchanter or "NONE",
		'text2R', 1 and colortog,
		'text2G', 1,
		'text2B', 0,
		'func', function()
			dewdrop:Open(this,
				'children', function(level, value)
					dewdrop:FeedAceOptionsTable(MorgDKP.DEopts)
				end,
				'point', function(parent) return "LEFT", "RIGHT" end, 
				'strata', "HIGH")
			end
	)
	cat:AddLine(
		'text', L["customname"],
		'textR', 0,
		'textG', 0.7,
		'textB', 0.8,
		'text2', MorgDKP.db.account.defaults.custom ,
		'text2R', 0,
		'text2G', 1,
		'text2B', 0,
		'func', function()
			dewdrop:Open(this,
				'children', function(level, value)
					dewdrop:FeedAceOptionsTable(MorgDKP.custommenu)
				end,
				'point', function(parent) return "LEFT", "RIGHT" end, 
				'strata', "HIGH")
			end
	)
	cat:AddLine(
		'text', L["pool"],
		'textR', 0,
		'textG', 0.7,
		'textB', 0.8,
		'text2', MorgDKP.db.account.defaults.raid or "NONE",
		'text2R', 0,
		'text2G', 1,
		'text2B', 0,
		'func', function()
			dewdrop:Open(this,
				'children', function(level, value)
					dewdrop:FeedAceOptionsTable(MorgDKP.RaidDBopts)
				end,
				'point', function(parent) return "LEFT", "RIGHT" end, 
				'strata', "HIGH")
			end
	)
    	cat:AddLine(
		'text', L["mldefunc"],
		'textR', 0,
		'textG', 0.7,
		'textB', 0.8,
		'text2', MLstatustext,
		'text2R', 0,
		'text2G', 1,
		'text2B', 0
	)
	cat:AddLine(
		'text', L["dkpsys"],
		'textR', 0,
		'textG', 0.7,
		'textB', 0.8,
		'text2', dkpstatus,
		'text2R', 0,
		'text2G', 1,
		'text2B', 0,
		'func', function()
			dewdrop:Open(this,
				'children', function(level, value)
					dewdrop:FeedAceOptionsTable(MorgDKP.dkpsystem)
				end,
				'point', function(parent) return "LEFT", "RIGHT" end, 
				'strata', "HIGH")
			end
	)
	cat:AddLine(
		'text', L["logquality"],
		'textR', 0,
		'textG', 0.7,
		'textB', 0.8,
		'text2', Quality[MorgDKP.db.account.defaults.quality+1],
		'func', function()
			dewdrop:Open(this,
				'children', function(level, value)
					dewdrop:FeedAceOptionsTable(MorgDKP.qualmenu)
				end,
				'point', function(parent) return "LEFT", "RIGHT" end, 
				'strata', "HIGH")
			end
	)
	cat:AddLine('text', "\n")
	local colortog = 0
	if not MorgDKP.db.account.defaults.InRaid  then colortog = 1 end
	cat:AddLine(
		'text', L["startraid"],
		'textR', colortog,
		'textG', 1,
		'textB', 0,
		'text2', MorgDKP.db.account.raidlog.raidstart,
		'text2R', colortog,
		'text2G', 1,
		'text2B', 0,
		'func', function() MorgDKP:BeginRaid() end
	)
	local colortog = 0
	if not MorgDKP.db.account.defaults.raidend  then colortog = 1 end
	cat:AddLine(
		'text', L["endraid"],
		'textR', colortog,
		'textG', 1, 
		'textB', 0,
		'text2', MorgDKP.db.account.raidlog.raidend,
		'text2R', colortog,
		'text2G', 1,
		'text2B', 0,
		'func', function() MorgDKP:ShowEndRaidFrame()  end
	)
	local colortog = 0
	if MorgDKP.db.account.raidlog.raidexport ~= L["complete"] then colortog = 1 end
	cat:AddLine(
		'text', L["rundkp"],
		'textR', colortog,
		'textG', 1,
		'textB', 0,
		'text2', MorgDKP.db.account.raidlog.raidexport,
		'text2R', colortog,
		'text2G', 1,
		'text2B', 0,
		'func', function() MorgDKP:ExportRaids() end
	)
	cat:AddLine(
		'text', L["custom"],
		'textR', 0,
		'textG', 1,
		'textB', 0,
		'text2', MorgDKP.db.account.defaults.custom,
		'text2R', 0,
		'text2G', 1,
		'text2B', 0,
		'func', function() MorgDKP:CustomEvent() end
	)
	cat:AddLine('text', "\n")
	if MorgDKP.db.account.defaults.raidnum ~= 0 and MorgDKP.db.account.raidlog[MorgDKP.db.account.defaults.raidnum].loot  then
		for num, loot in pairs(MorgDKP.db.account.raidlog[MorgDKP.db.account.defaults.raidnum].loot) do
  			local name = loot.Player
  			if loot.ID ~= 20725 then
  				local r, g, b = 1, 1, 1
  				if name and MorgDKP.db.account.info[name] and MorgDKP.db.account.info[name].class then r, g, b = BC:GetColor(MorgDKP.db.account.info[name].class) 
  				else name = "UNKNOWN" end
  				if loot.ItemLink then
  					cat:AddLine(
						'text', loot.ItemLink,
						'text2', name,
						'text2R', r,
						'text2G', g,
						'text2B', b,
						'onEnterFunc', function() 
								GameTooltip:SetOwner(this, "ANCHOR_LEFT")
								GameTooltip:SetHyperlink(loot.ItemLink) 
								GameTooltip:Show()
								end,
    						'onLeaveFunc', function() GameTooltip:Hide() end,
    						'func', function() self:FubartabletClick(loot.ID, loot.ItemLink) end
					)
				end
			end
		end
  	end
end

function MorgDKPFu:FubartabletClick(itemID, itemlink)
	if IsShiftKeyDown() then
		ChatFrameEditBox:Insert(itemlink)
	elseif IsControlKeyDown() then
		table.insert(MorgDKP.db.account.defaults.ignore, itemlink)
	else MorgDKP:ManualItem(itemID, itemlink)
	end
end
