-- ******************************************************************
-- ******************************************************************
-- **                         MorgDKP                                      **
-- ******************************************************************
-- ******************************************************************
--

local L = AceLibrary("AceLocale-2.2"):new("MorgDKP")
local BC = AceLibrary("Babble-Class-2.2")
local BZ = LibStub("LibBabble-Zone-3.0"):GetLookupTable()
local BB = LibStub("LibBabble-Boss-3.0"):GetLookupTable()
local dewdrop = AceLibrary("Dewdrop-2.0")
local rosterlib = AceLibrary("Roster-2.1")
local roster = rosterlib.roster
local tablet = AceLibrary("Tablet-2.0")

MorgDKP = AceLibrary("AceAddon-2.0"):new("AceEvent-2.0", "AceHook-2.1", "AceConsole-2.0","AceComm-2.0", "AceDB-2.0")

MorgDKP.version = "7.04"
MorgDKP.commPrefix = "MorgDKP"
MorgDKP.commVersion = 6.2

StaticPopupDialogs["MorgLoot"] = {
	text = TEXT(L["lootquery"]),
	button1 = TEXT(YES),
	button2 = TEXT(NO),
	OnAccept = function()
		MorgDKP:GiveOutLoot()
	end,
	timeout = 0,
	whileDead = 1,
	hideOnEscape = 1,
}

StaticPopupDialogs["BossAttempt"] = {
	text = TEXT(L["recordbossattempt"]),
	button1 = TEXT(YES),
	button2 = TEXT(NO),
	OnAccept = function()
		MorgDKP:CustomEvent()
	end,
	timeout = 0,
	whileDead = 1,
	hideOnEscape = 1,
}

StaticPopupDialogs["MorgAcceptSYNC"] = {
	text = TEXT(L["AcceptSYNC"]),
	button1 = TEXT(YES),
	button2 = TEXT(NO),
	OnAccept = function()
		MorgDKP:AcceptSyncData()
	end,
	OnCancel = function()
		MorgDKP:DenySyncData()
	end,
	timeout = 0,
	whileDead = 1,
	hideOnEscape = 1,
}

StaticPopupDialogs["MorgImport"] = {
	text = TEXT(L["ImportdefaultDB"]),
	button1 = TEXT(YES),
	button2 = TEXT(NO),
	OnAccept = function()
		MorgDKP:ImportMorgItems()
	end,
	timeout = 0,
	whileDead = 1,
	hideOnEscape = 1,
}

StaticPopupDialogs["MorgAcceptLeader"] = {
	text = TEXT(L["AcceptLeaderRequest"]),
	button1 = TEXT(YES),
	button2 = TEXT(NO),
	OnAccept = function()
		MorgDKP:AcceptLeader()
	end,
	OnCancel = function()
		MorgDKP:DenyLeader()
	end,
	timeout = 0,
	whileDead = 1,
	hideOnEscape = 1,
}

MorgTracker_ZoneBosses = {
		[BZ["Molten Core"]] = {[1] = BB["Lucifron"],
						[2] = BB["Magmadar"],
						[3] = BB["Gehennas"],
						[4] = BB["Garr"],
						[5] = BB["Baron Geddon"],
						[6] = BB["Shazzrah"],
						[7] = BB["Sulfuron Harbinger"],
						[8] = BB["Golemagg the Incinerator"],
						[9] = BB["Majordomo Executus"],
						[10] = BB["Ragnaros"]},
		[BZ["Blackwing Lair"]] = {[1] = BB["Razorgore the Untamed"],
						[2] = BB["Vaelastrasz the Corrupt"],
						[3] = BB["Broodlord Lashlayer"],
						[4] = BB["Firemaw"],
						[5] = BB["Ebonroc"],
						[6] = BB["Flamegor"],
						[7] = BB["Chromaggus"],
						[8] = BB["Nefarian"]},
		[BZ["Zul'Gurub"]] = {[1] = BB["High Priestess Jeklik"],
						[2] = BB["High Priest Venoxis"],
						[3] = BB["High Priestess Mar'li"],
						[4] = BB["High Priest Thekal"],
						[5] = BB["High Priestess Arlokk"],
						[6] = BB["Hakkar"],
						[7] = BB["Bloodlord Mandokir"],
						[8] = BB["Jin'do the Hexxer"],
						[9] = BB["Gahz'ranka"],
						[10] = BB["Hazza'rah"],
						[11] = BB["Gri'lek"],
						[12] = BB["Renataki"],
						[13] = BB["Wushoolay"]},
		[BZ["Ruins of Ahn'Qiraj"]] = {[1] = BB["Kurinnaxx"],
						[2] = BB["General Rajaxx"],
						[3] = BB["Ayamiss the Hunter"],
						[4] = BB["Buru the Gorger"],
						[5] = BB["Moam"],
						[6] = BB["Ossirian the Unscarred"]},
		[BZ["Ahn'Qiraj"]] = { [1] = BB["The Prophet Skeram"],
						[2] = BB["Fankriss the Unyielding"],
						[3] = BB["Battleguard Sartura"],
						[4] = BB["Princess Huhuran"],
						[5] = BB["Emperor Vek'lor"],
						[6] = BB["Emperor Vek'nilash"],
						[7] = BB["C'Thun"],
						[8] = BB["Vem"],
						[9] = BB["Princess Yauj"],
						[10] = BB["Lord Kri"],
						[11] = BB["Viscidus"],
						[12] = BB["Ouro"]},
		[BZ["Naxxramas"]] = {[1] = BB["Patchwerk"],
						[2] = BB["Grobbulus"],
						[3] = BB["Gluth"],
						[4] = BB["Thaddius"],
						[5] = BB["Instructor Razuvious"],
						[6] = BB["Gothik the Harvester"],
						[7] = BB["Highlord Mograine"],
						[8] = BB["Thane Korth'azz"],
						[9] = BB["Lady Blaumeux"],
						[10] = BB["Sir Zeliek"],
						[11] = BB["Noth the Plaguebringer"],
						[12] = BB["Heigan the Unclean"],
						[13] = BB["Loatheb"],
						[14] = BB["Anub'Rekhan"],
						[15] = BB["Grand Widow Faerlina"],
						[16] = BB["Maexxna"],
						[17] = BB["Sapphiron"],
						[18] = BB["Kel'Thuzad"]},
		[BZ["Karazhan"]] = {[1] = BB["Attumen the Huntsman"],
						[2] = BB["Moroes"],
						[3] = BB["Maiden of Virtue"],
						[4] = BB["Netherspite"],
						[5] = BB["Nightbane"],
						[6] = BB["Prince Malchezaar"],
						[7] = BB["Shade of Aran"],
						[8] = BB["Terestian Illhoof"],
						[9] = BB["The Curator"],
						[10] = BB["Romulo & Julianne"],
						[11] = BB["The Big Bad Wolf"],
						[12] = BB["The Crone"],
						[13] = BB["Chess Event"],
						[14] = BB["Rokad the Ravager"],
						[15] = BB["Hyakiss the Lurker"],
						[16] = BB["Shadikith the Glider"]},
		[BZ["Serpentshrine Cavern"]] = {[1] = BB["Hydross the Unstable"],
						[2] = BB["Fathom-Lord Karathress"],
						[3] = BB["The Lurker Below"],
						[4] = BB["Morogrim Tidewalker"],
						[5] = BB["Leotheras the Blind"],
						[6] = BB["Lady Vashj"]},
		[BZ["Tempest Keep"]] = {[1] = BB["Al'ar"],
						[2] = BB["Void Reaver"],
						[3] = BB["High Astromancer Solarian"],
						[4] = BB["Kael'thas Sunstrider"]},
		[BZ["Hyjal Summit"]] = {[1] = BB["Rage Winterchill"],
						[2] = BB["Anetheron"],
						[3] = BB["Kaz'rogal"],
						[4] = BB["Azgalor"],
						[5] = BB["Archimonde"]},
		[BZ["Black Temple"]] = { [1] = BB["High Warlord Naj'entus"],
						[2] = BB["Supremus"],
						[3] = BB["Gurtogg Bloodboil"],
						[4] = BB["Teron Gorefiend"],
						[5] = BB["Shade of Akama"],
						[6] = BB["Reliquary of Souls"],
						[7] = BB["Mother Shahraz"],
						[8] = BB["Illidari Council"],
						[9] = BB["Illidan Stormrage"]},
		[BZ["Zul'Aman"]] = {[1] = BB["Akil'zon"],
						[2] = BB["Halazzi"],
						[3] = BB["Jan'alai"],
						[4] = BB["Hex Lord Malacrass"],
						[5] = BB["Nalorakk"],
						[6] = BB["Zul'jin"]},
		[L["WorldBoss"]] = {    [1] = BB["Emeriss"],
						[2] = BB["Lethon"],
						[3] = BB["Ysondre"],
						[4] = BB["Taerar"],
						[5] = BB["Azuregos"],
						[6] = BB["Doom Lord Kazzak"],
						[7] = BB["Doomwalker"]},
		[BZ["Onyxia's Lair"]] = {[1] = BB["Onyxia"]},
		[BZ["Gruul's Lair"]] = {[1] = BB["High King Maulgar"],[2] = BB["Gruul the Dragonkiller"]},
		[BZ["Magtheridon's Lair"]] = {[1] = BB["Magtheridon"]},
		[BZ["Sunwell Plateau"]]  = {    [1] = BB["Kalecgos"],
						[2] = BB["Brutallus"],
						[3] = BB["Felmyst"],
						[4] = BB["The Eredar Twins"],
						[5] = BB["M'uru"],
						[6] = BB["Kil'jaeden"]}
}

function MorgDKP:OnInitialize()
	MorgDKP:RegisterDB("MorgDKPDB")
	MorgDKP:RegisterDefaults('account', {
   		items = { },
    		info = { },
		defaults = {
				zerosum = nil,
				bidwar = nil,
				whisper = nil,
				relational = nil,
				random = nil,
				silent = nil,
				InRaid = nil,
   				raidend = nil,
   				quality = 4,
   				raidnum = 0,
   				bidstep = 5,
   				startrun = 1,
				raidnum = 0,
				raidlist = { [1] = L["NONE"] },
				raidmembers = {[1] = UnitName("player")},
				lootframex = UIParent:GetWidth() / 2,
				lootframey = UIParent:GetHeight() / 2,
				raid = nil,
				custom = L["NEW"],
				menuzone = L["WorldBoss"],
				autozone = 1,
				multiPool = nil,
				dbupdated = 0,
				dkpaward = nil,
				dkpsched = 3600,
				dkpamount = 1,
				dbpassword = "SyncDBPassword",
				overbid = 50,
				justenough = nil,
				OneEvent = nil,
				Waitlist = {members = {}, join = {} },
				waitstart = 2,
				waitrun = 0,
				waitaward = nil,
				waitotime = 0,
				waitboss = 0,
				percent = 0,
				percenttake = nil,
				attemptmode = nil,
				eventformat = "<boss>",
				startformat = "<zone> Start",
				trashformat = "<zone> Run",
				runrewardtime = 1800,
				dkplistener = nil,
				leadbroadcast = nil,
				restoreautozone = nil,
				devmode = nil,
				SKall = nil,
				ignore = { 	[1] = L["VoidCrystal"],
						[2] = L["BadgeofJustice"],
						[3] = L["ElementiumOre"],
						[4] = L["SmallPrismaticShard"],
						[5] = L["LargePrismaticShard"],
						[6] = L["LargeBrilliantShard"],
						[7] = L["CosmicInfuser"],
						[8] = L["Devastation"],
						[9] = L["InfinityBlade"],
						[10] = L["NetherstrandLongbow"],
						[11] = L["StaffofDisintegration"],
						[12] = L["WarpSlicer"],
						[13] = L["PhaseshiftBulwark"],
						[14] = L["BundleofNetherSpikes"],
						[15] = L["NetherSpike"] }
		},
		raidlog = {
				raidstart = L["pending"],
				raidend = L["pending"],
				raidexport = L["pending"],
				playerinfo = { },
				join = { },
				leave = { },
				bosskills = { },
				loot = { }
			}
	})
	self:DoOptions()
	MorgDKP:RegisterChatCommand({L["cmd1"], L["cmd2"]}, MorgDKP.opts)
	self:SetCommPrefix("MorgDKP")
end

function MorgDKP:OnEnable(called)
        if called then self:ToggleActive(false) return end
        self.items = { }
	self.TT = { }
	self.querytooltips = { }
	self.origitempoints = { }
	self.queryneeded = nil
	self.killed = { }
	self.MLmode = true
	self.hasitem = nil
   	self.requestsync = nil
   	self.repliedleader = nil
   	self.random = {}
   	self.given = nil
   	self.Starttime = nil
   	self.Fonts = {
		['GameFontNormal'] = {['Font'] = { GameFontNormal:GetFont() }},
		['GameFontNormalSmall'] = {['Font'] = { GameFontNormalSmall:GetFont() }},
	}
	if self.db.account.defaults.dbupdated ~= 3 then
		self:ConvertDB()
		self.db.account.defaults.dbupdated = 3
	end
	if MorgDKP_Items then 	StaticPopup_Show ("MorgImport")	end
	self:ToggleDKPAward()
	if UnitInRaid("player") and self.db.account.defaults.InRaid then
		if not self:IsEventScheduled("MorgDKP_Attendance") then self:ScheduleRepeatingEvent("MorgDKP_Attendance", self.CheckAttendance, 60, self ) end
	end
	if self.db.account.defaults.restoreautozone then
		self.db.account.defaults.autozone = true
		self.db.account.defaults.restoreautozone = nil
	end
	self:UpdateRaidlist()
	self:PrepareRaidmembers()
	self:TogglePlayerDies(self.db.account.defaults.attemptmode)
	self:RegisterEvent("CHAT_MSG_ADDON", "OnAddonMsg")
	self:RegisterEvent("CHAT_MSG_LOOT", "OnLootMsg")
    	self:RegisterEvent("LOOT_OPENED", "OnOpen")
	self:RegisterEvent("RosterLib_UnitChanged", "ProcessRosterChange")
	self:RegisterEvent("COMBAT_LOG_EVENT_UNFILTERED", "CombatLogEvent")
	self:RegisterEvent("CHAT_MSG_MONSTER_YELL", "HostileYell")
	self:RegisterEvent("CHAT_MSG_MONSTER_EMOTE", "HostileEmote")
	self:RegisterEvent("GUILD_ROSTER_UPDATE", "GuildUpdate")
	self:RegisterEvent("PLAYER_REGEN_DISABLED", "StartCombat")
	self:RegisterComm(self.commPrefix, "GUILD", "OnCommReceive")
	self:RegisterComm(self.commPrefix, "GROUP", "OnCommReceive")
	self:HookStuff()
end

function MorgDKP:OnDisable()
	self:UnhookAll()
	self:TogglePlayerDies()
	if self:IsEventScheduled("MorgDKP_Award") then self:CancelScheduledEvent("MorgDKP_Award") end
	if self:IsEventScheduled("MorgDKP_Attendance") then self:CancelScheduledEvent("MorgDKP_Attendance") end
	MorgDKPFu:ChangeState()
end

function MorgDKP:TogglePlayerDies(switch)
	if switch then self:RegisterEvent("PLAYER_DEAD", "LeaderDied")
	elseif self:IsEventRegistered("PLAYER_DEAD") then self:UnregisterEvent("PLAYER_DEAD") end
end

function MorgDKP:ToggleDKPAward()
	local ON = self:IsEventScheduled("MorgDKP_Award")
	if self.db.account.defaults.InRaid and self.db.account.defaults.dkpaward  then
		if not ON then self:ScheduleRepeatingEvent("MorgDKP_Award", self.RecurrentReward, self.db.account.defaults.dkpsched, self ) end
		self:Print("AWARD ON")
		return
	end
	if ON then self:CancelScheduledEvent("MorgDKP_Award") self:Print("AWARD OFF") end
end

function MorgDKP:StartCombat()
	if not self.db.account.defaults.InRaid then return end
	self.Starttime = date("%m/%d/%y %H:%M:%S")
end

function MorgDKP:IsRaided()
	if not UnitInRaid("player") then
		DEFAULT_CHAT_FRAME:AddMessage(L["needraid"])
		return false
	end
	return true
end

function MorgDKP:IsValid()
	if self.db.account.defaults.random then
		self.db.account.defaults.bidwar = nil
		self.db.account.defaults.relational = nil
		self.db.account.defaults.zerosum = nil
		self.db.account.defaults.multiPool = nil
		self.db.account.defaults.percent = 0
	end
	if self.db.account.defaults.bidwar or self.db.account.defaults.relational or self.db.account.defaults.zerosum or self.db.account.defaults.multiPool or self.db.account.defaults.percent > 0 then return true
	else return false end
end

function MorgDKP:PlayerinDB(playname, playclass)
	if not self.db.account.info[playname] then
		self.db.account.info[playname] = { }
		self.db.account.info[playname][self.db.account.defaults.raid] = {points = 0, earned = 0, spent = 0}
		self.db.account.info[playname].raidloot = 0
		self.db.account.info[playname].lastupdate = self:GetServerTime()
	end
	if not self.db.account.info[playname].aliases then self.db.account.info[playname].aliases = { } end
	if playclass and not self.db.account.info[playname].class then
		self.db.account.info[playname].class = playclass
		self.db.account.info[playname].lastupdate = self:GetServerTime()
	end
end

function MorgDKP:PointsPoolExists(playname, pool)
	self:PlayerinDB(playname)
	if not self.db.account.info[playname][pool] then
		self.db.account.info[playname][pool] = {points = 0, earned = 0, spent = 0}
		self.db.account.info[playname].lastupdate = self:GetServerTime()
	end
end

function MorgDKP:IteminDB(item)
	if not self.db.account.items[item] then
		self.db.account.items[item] = {points = 0, classes = {}, altclasses = {} }
	end
	if not self.db.account.items[item].points then self.db.account.items[item].points = 0 end
	if not self.db.account.items[item].pool then self.db.account.items[item].pool = self.db.account.defaults.raid end
end

function MorgDKP:GiveOutLoot()
	for ci = 1, GetNumRaidMembers() do
		if GetMasterLootCandidate(ci) == Lootwinner then
  			for li = 1, GetNumLootItems() do
  				local lootIcon, lootName, lootQuantity, rarity = GetLootSlotInfo(li)
  				if lootName == Lootitem then
  					GiveMasterLoot(li, ci)
					return
				end
  			end
 		end
 	end
 end

function MorgDKP:MakeDewDropMenu(frame, itemlink)
	if itemlink == nil then return end
	_, _, qid = string.find(itemlink, "Hitem:(%d+)")
	local id = tonumber(qid)
	if( id ) then
		-- make sure it's there
		self:IteminDB(id)

		-- get cursor pos
		local x,y = GetCursorPosition()
		myid, mylink = id,itemlink

		-- build the menu
		self.hasitem = 1
		dewdrop:Open(frame,
				'children', function(level, value)
						dewdrop:FeedAceOptionsTable(MorgDKP.opts)
					end,
				 'cursorX', true,
			   'cursorY', true
		)
	end
end

function MorgDKP:GiveBOE(id, link)
	if not self.db.account.items[id] then DEFAULT_CHAT_FRAME:AddMessage(L["noitem"]); return end
	if not charstring then DEFAULT_CHAT_FRAME:AddMessage(L["validname"]) return end
	if self.MLmode and (charstring == self.db.account.defaults.mlooter or charstring == self.db.account.defaults.disenchanter) then
		DEFAULT_CHAT_FRAME:AddMessage(L["nolootrec"])
		return
	end
	MorgDKP:RecordLoot(link, charstring)
end

function MorgDKP:CheckRaid(namequery)
	for pname, data in pairs(roster) do
		if pname == namequery then
			return true
		end
	end
	return nil
end

function MorgDKP:CheckPool(item)
	local POOL = self.db.account.defaults.raid
	if self.db.account.defaults.multiPool then
		if self.db.account.items[item] then
			POOL = self.db.account.items[item].pool
		end
	end
	return POOL
end

function MorgDKP:AddTwink(twinkstring)
	_, _, twink2, twink1 = string.find(twinkstring, "(%a+) (%a+)")
	if twink1 == nil or twink2 == nil then
		DEFAULT_CHAT_FRAME:AddMessage(L["twinkaltmain"])
		return
	end
	local POOL = self.db.account.defaults.raid
	twinkmain = twink1
	twinkalt = twink2
	mainpoints = 0
	if self.db.account.info[twinkmain] then mainpoints = self.db.account.info[twinkmain][POOL].points
	else DEFAULT_CHAT_FRAME:AddMessage(L["nomain"]) return end
	for _, data in pairs(self.db.account.defaults.eqDKP[self.db.account.defaults.raid].Aliases) do
		if data.alt == twinkalt then
			DEFAULT_CHAT_FRAME:AddMessage(L["aliasexists"])
			return
		end
	end
	local var = nil
	if self.db.account.info[twinkalt] then
		DEFAULT_CHAT_FRAME:AddMessage(tostring(mainpoints)..L["dkpword"]..L["transfer"]..twinkmain..L["to2"]..twinkalt)
		var = 1
	end
	if not var then
		DEFAULT_CHAT_FRAME:AddMessage(L["addnewchar"]..twinkalt.." with "..tostring(mainpoints)..L["dkpp"])
	end
	self:PlayerinDB(twinkalt)
	self.db.account.info[twinkalt][POOL]  =  {	points = mainpoints,
							earned = self.db.account.info[twinkmain][POOL].earned,
							spent = self.db.account.info[twinkmain][POOL].spent}
	self.db.account.info[twinkalt].raidloot = 0
	if not self:DoesAliasExist(twinkmain, twinkalt, self.db.account.defaults.raid) then table.insert(self.db.account.info[twinkmain].aliases, {raid = self.db.account.defaults.raid, alt = twinkalt}) end
	local update = self:GetServerTime()
	self.db.account.info[twinkmain].lastupdate = update
	self.db.account.info[twinkalt].lastupdate = update
	if not self.db.account.raidlog.aliases[self.db.account.defaults.raid] then  self.db.account.raidlog.aliases[self.db.account.defaults.raid] = { } end
	table.insert( self.db.account.raidlog.aliases[self.db.account.defaults.raid], {	alt = twinkalt,
											main = twinkmain,
											eqdkp = self.db.account.defaults.eqDKP[self.db.account.defaults.raid].eqDKPsite,
											action = "ADD" })
	table.insert(self.db.account.defaults.eqDKP[self.db.account.defaults.raid].Aliases, {alt = twinkalt, main = twinkmain})
end

function MorgDKP:EventFormat(formatstring)
	if not formatstring then return end
	if string.find(formatstring, "[zone]") or string.find(formatstring, "[boss]") then
		self.db.account.defaults.eventformat = formatstring
		return
	end
	DEFAULT_CHAT_FRAME:AddMessage(L["eventformatdesc"])
end

function MorgDKP:StartFormat(formatstring)
	if not formatstring then return end
	self.db.account.defaults.startformat = formatstring
end

function MorgDKP:TrashFormat(formatstring)
	if not formatstring then return end
	self.db.account.defaults.trashformat = formatstring
end

function MorgDKP:SetRunTime(amttime)
	local seconds = math.floor(tonumber(amttime) * 60)
	if seconds > 0 and seconds <  21600 then
		self.db.account.defaults.runrewardtime = seconds
	end
end

function MorgDKP:ChangeDKP()
	if not self.db.account.defaults.InRaid then DEFAULT_CHAT_FRAME:AddMessage(L["needraid"]) return end
	local POOL = self.db.account.defaults.raid
	local Runname = self.db.account.raidlog[self.db.account.defaults.raidnum].bosskills[self:GetRunEvent()].note
	local _, _, char, points = string.find(charstring, "(%a+) (%d+)")
	if char == nil or points == nil then
		DEFAULT_CHAT_FRAME:AddMessage(L["charpoints"])
		return
	end
	local character = string.upper(string.sub(char,1,1))..string.sub(char,2,-1)
	local pointval = tonumber(points)
	local type = L["add"]
	if MorgDKP.db.account.info[character] then
		mainpoints = MorgDKP.db.account.info[character][POOL].points
		oldmainpoints = mainpoints
		if adding then mainpoints = mainpoints + pointval
		else mainpoints = mainpoints - pointval
			type = L["sub"]
			pointval = 0 - pointval
		end
		DEFAULT_CHAT_FRAME:AddMessage(type..points..L["dkpp"]..character..L["olddkp"]..tostring(oldmainpoints)..L["newdkp"]..tostring(mainpoints))
		self.db.account.info[character][POOL].points = mainpoints
		self.db.account.info[character].lastupdate = self:GetServerTime()
		if not self.db.account.raidlog.dkpevents[POOL] then self.db.account.raidlog.dkpevents[POOL] = { } end
		table.insert(self.db.account.raidlog.dkpevents[POOL], {    name = character,
												value = pointval,
												members = {[1] = character},
												eqdkp = self.db.account.defaults.eqDKP[self.db.account.defaults.raid].eqDKPsite,
												prefix = self.db.account.defaults.eqDKP[POOL].prefix,
												addtype = "individual",
												event = Runname})
		return
	end
	DEFAULT_CHAT_FRAME:AddMessage(character..L["notexi"])
end

function MorgDKP:GetPlayersNeedItem(item)
	if not UnitInRaid("player") then return end
	local POOL = self:CheckPool(item)
	needquery = self:HasItem(item)
	if not needquery then return end
	reportpoints = { }
	for qname in pairs(needquery) do
		self:PointsPoolExists(qname, POOL)
		table.insert(reportpoints, {name = qname, points = self.db.account.info[qname][POOL].points, priority = needquery[qname].priority})
	end
	table.sort(reportpoints, function(a,b)
				if a.priority == b.priority then
					return a.points>b.points
				else return a.priority < b.priority
				end
				end)
	return reportpoints
end

function MorgDKP:Scan()
	local SLOTS = {
		"HeadSlot",
		"NeckSlot",
		"ShoulderSlot",
		"BackSlot",
		"ChestSlot",
		"WristSlot",
		"HandsSlot",
		"WaistSlot",
		"LegsSlot",
		"FeetSlot",
		"Finger0Slot",
		"Finger1Slot",
		"Trinket0Slot",
		"Trinket1Slot",
		"MainHandSlot",
		"SecondaryHandSlot",
		"RangedSlot"
	}

	for i = 1, GetNumRaidMembers() do
		local name = UnitName("raid"..i)
		local class = UnitClass("raid"..i)
		self:PlayerinDB(name, class)
		if not self.db.account.info[name].items then  self.db.account.info[name].items = { } end
		if CheckInteractDistance(name, 1) then
			NotifyInspect(name)
			for _,slot in pairs(SLOTS) do
				local itemLink = GetInventoryItemLink(name, GetInventorySlotInfo(slot))
				if itemLink then
					local _, _, itemCode = strfind(itemLink, "(%d+):")
					itemCode = tonumber(itemCode)
					if not self:ItemRecorded(itemCode, name) then
						table.insert(self.db.account.info[name].items, itemCode)
						if self.db.account.defaults.devmode then
							self:Print("Added ".. name .. " slot: ".. slot ..";item ".. itemLink ..";ID: " .. itemCode)
						end
					end
				elseif self.db.account.defaults.devmode then self:Print(name.."'s slot: "..slot.."; no item")
				end
			end
			if self.db.account.defaults.devmode then self:Print("Scanned "..name) end
		end
	end
end

function MorgDKP:ItemRecorded(item, name)
	for _, ID in pairs(self.db.account.info[name].items) do
		if item == ID then
			return true
		end
	end
	return false
end

function MorgDKP:OnLootMsg()
	if not UnitInRaid("player") or  not self.db.account.defaults.InRaid then return end
	local sPlayer, sLink;
	local iStart, iEnd, sPlayerName, sItem = string.find( arg1, L["MORGTRACKER_LOOT_RECEIVES1"] )
  	if  sPlayerName then
		_, _, _, _, itemCount = string.find( arg1, L["MORGTRACKER_LOOT_RECEIVES1_COUNT"] )
    		sPlayer = sPlayerName
		sLink = sItem
	else
		local iStart, iEnd, sItem = string.find( arg1, L["MORGTRACKER_LOOT_RECEIVES2"] )
    		if iStart then
			sPlayer = UnitName("player")
			sLink = sItem
			_, _, _, itemCount =  string.find( arg1, L["MORGTRACKER_LOOT_RECEIVES2_COUNT"] )
    		end
	end
	itemCount = tonumber(itemCount)
	if not itemCount then
		itemCount = 1
	end
	-- Make sure there is a link
	if self.MLmode and (sPlayer == self.db.account.defaults.mlooter or sPlayer == self.db.account.defaults.disenchanter) and not self.given then return
	else self.given = nil end
	if not MorgDKP:CheckRaid(sPlayer) then return end
	if sLink and sPlayer then
		MorgDKP:RecordLoot(sLink, sPlayer)
	end
end

-- Code by Kaelten (split & explode)
function MorgDKP:Split(string, sep)
	if (not string) then error("Bad String", 2)     end
	local x = strfind(string , sep) or 0
	return (tonumber(strsub(string, 1, x-1)) or strsub(string, 1, x-1)), (tonumber(strsub(string, x+1)) or strsub(string, x+1))
end

function MorgDKP:Explode(string, sep)
	if (not string) then return nil end
	local a, b = self:Split(string, sep)
	if (not b or b == "") then return a; end
	if (not strfind(b or "", sep)) then return a, b; end
	return a, self:Explode(b, sep)
end

function MorgDKP:RecordLoot(item, player)
	if self.db.account.defaults.raidnum < 1 then DEFAULT_CHAT_FRAME:AddMessage(L["noraid"]) return end
	local _, _, sColor = string.find(item, "|c(%x+)")
	local _,_, itemId = string.find(item, "item:(%d+):")
	itemId = tonumber(itemId)
	local IGNORE = nil
	for _, ignorelink in pairs(self.db.account.defaults.ignore) do
		local _,_, ignoreid = string.find(ignorelink, "item:(%d+):")
		ignoreid = tonumber(ignoreid)
		if ignoreid == itemId then IGNORE = true break end
	end
	if IGNORE then return end
	local sName, iLink, iQuality, _, _, class, subclass, _, iEquipLoc, iconGIF = GetItemInfo(itemId)
	if iQuality < self.db.account.defaults.quality then return end
	local lootTime = date("%m/%d/%y %H:%M:%S")
	local lastboss = self.db.account.raidlog[self.db.account.defaults.raidnum].lastboss
	local lastmob = self.db.account.raidlog[self.db.account.defaults.raidnum].lastmob
	local BossMob
	if self.db.account.raidlog.lootbuffer and self.db.account.raidlog.lootbuffer[sName] ~= nil then
		BossMob = self.db.account.raidlog.lootbuffer[sName]
	else
		if lastboss == lastmob then BossMob = lastboss
		else BossMob = lastmob end
	end
	local match = nil
	for _, bossname in pairs(MorgTracker_ZoneBosses[self.db.account.defaults.menuzone]) do
  		if BossMob == bossname then
  			match = 1
  			break
  		end
  	end
  	if not BossMob or self.db.account.defaults.OneEvent  or not match then BossMob = L["DEFAULTBOSS"]  end
	self:IteminDB(itemId)
	local points
	local POOL = self:CheckPool(itemId)
	self:PointsPoolExists(player, POOL)
	points = self.db.account.info[player][POOL].points
	itempoints =  self.db.account.items[itemId].points or 0
	if self.db.account.defaults.percent > 0 then
		itempoints = math.floor((points * self.db.account.defaults.percent/100)  + 0.5)
		if self.db.account.defaults.percenttake then
			if self.querytooltips[itemId] then
				for  i,v in pairs(self.querytooltips[itemId]) do
					if v[1] == player then
						if v[3] == "TAKE" then	itempoints = self.origitempoints[itemId]  end
						break
					end
				end
			end
		end
	end
	Zone = GetRealZoneText()
	if self.db.account.defaults.SKall then itempoints = points end
	table.insert(self.db.account.raidlog[self.db.account.defaults.raidnum].loot,
					{
						["ItemName"] = sName,
						["ItemLink"] = iLink,
						["Quality"] = iQuality,
						["ID"] = itemId,
						["Icon"] = iconGIF,
						["Class"] = class,
						["SubClass"] = subclass,
						["Color"] = sColor,
						["Count"] = itemCount,
						["Player"] = player,
						["Costs"] = itempoints,
						["Time"] = lootTime,
						["Zone"] = Zone,
						["Boss"] = BossMob,
						["eqdkp"] = self.db.account.defaults.eqDKP[POOL].eqDKPsite,
						["prefix"] = self.db.account.defaults.eqDKP[POOL].prefix
					}
				)
	points = points - itempoints
	self.db.account.info[player][POOL].points = points
	self.db.account.info[player][POOL].spent = self.db.account.info[player][POOL].spent + itempoints
	self.db.account.info[player].raidloot = 1
	self.db.account.info[player].lastupdate = self:GetServerTime()
	if self.db.account.defaults.zerosum and (tonumber(itempoints) > 0) then self:AddZeroSumPoints(itempoints, POOL) end
	DEFAULT_CHAT_FRAME:AddMessage(player..L["receive"]..item.." for "..tostring(itempoints).." DKP")
	if iEquipLoc ~="" then
		if not self.db.account.info[player].items then
			self.db.account.info[player].items = { }
		end
		if not self:ItemRecorded(itemId, player) then
			table.insert(self.db.account.info[player].items, itemId)
		end
	end
	if self.db.account.defaults.bidwar then self.db.account.items[itemId].points = 0 end
end

function MorgDKP:PrepareRaidmembers()
	--Rebuild raid members
	self.db.account.defaults.raidmembers = { }
	local raidmembers = { }
	for name, data in pairs(roster) do
		if (data.class ~= "PET") then table.insert(raidmembers, name) end
	end
	table.sort(raidmembers, function(a,b)
  		if a < b then	return true
			else return false end
		end)
	for _ ,name in pairs(raidmembers) do
		table.insert(self.db.account.defaults.raidmembers, name)
	end
	MorgDKP:ReclaimAll()

	--Update ML
	local lootmethod, masterlooterPartyID, masterlooterRaidID = GetLootMethod()
   	local lootmaster
   	if lootmethod == "master" then
   		if masterlooterPartyID then
   			if masterlooterPartyID == 0 then lootmaster = UnitName("player")
   			else  lootmaster = UnitName("party"..masterlooterPartyID) end
   		else lootmaster = UnitName("raid"..masterlooterRaidID)
   		end
   		self.db.account.defaults.mlooter = lootmaster
   		self.lootmaster = lootmaster
   	else self.db.account.defaults.mlooter = lootmethod
  	end
	self:ReclaimML()
end

function MorgDKP:AddZeroSumPoints(points, pool)
	addpoints = math.floor((points/GetNumRaidMembers()) + 0.5)
	local counter = 0
	local update = self:GetServerTime()
	for name in pairs(roster) do
    		if name and name ~= "" and name ~= "UNKNOWN" then
			local tbl = roster[name]
			if tbl.class ~= "PET" and tbl.oldclass ~= "PET" then
				self.db.account.info[name][pool].points = self.db.account.info[name][pool].points + addpoints
				self.db.account.info[name][pool].earned = self.db.account.info[name][pool].earned + addpoints
				self.db.account.info[name].lastupdate = update
				counter = counter + 1
			end
		end
	end
	DEFAULT_CHAT_FRAME:AddMessage(L["add"]..tostring(addpoints)..L["pointsto"]..tostring(counter)..L["attend"])
end

function MorgDKP:ListDKP(listtext)
	if not listtext then return end
	listtext = "listdkp "..listtext
	dkplist = self:FillDKPTable(nil, nil, listtext, nil)
	local item = "listdkp"
	local title = L["listdkp"]
	local hint = L["Bar_Hint_DKPlist"]
	local id = nil
	self.querytooltips[item] = dkplist
	self:Onlinemembers(true)
	self:CreateQueryTooltip(id, item, title, hint)
end

function MorgDKP:Onlinemembers(skip)
	local Onlinemembers = self:GetOnlineGuildMembers()
	for i = 1, GetNumRaidMembers() do
		local name, _, subgroup, _, _, _, _, online, _, _, _ = GetRaidRosterInfo(i)
		if subgroup and online then Onlinemembers[name] = 2 end
	end
	for index, data in pairs(self.querytooltips["listdkp"]) do
		if Onlinemembers[data[1]] then self.querytooltips["listdkp"][index][2] = Onlinemembers[data[1]]
		else self.querytooltips["listdkp"][index][2] = nil end
	end
	if not skip then tablet:Refresh("listdkp") end
end

function MorgDKP:GetOnlineGuildMembers()
	local numGuildMembers = GetNumGuildMembers()
	local Onlinemembers = { }
	for i = 1, numGuildMembers do
		local name, _, _, _, _, _, _, _, online, _ = GetGuildRosterInfo(i)
		if online then Onlinemembers[name] = 1 end
	end
	return Onlinemembers
end

function MorgDKP:GuildUpdate()
	if not self.querytooltips["listdkp"]  then return end
	self:Onlinemembers()
end

function MorgDKP:FillDKPTable(sender, senderclass, txt, raided)
	local POOL = self.db.account.defaults.raid
	dkplist = { }
	local args = {self:Explode(txt, " ")}
	for _, name in pairs(self.db.account.defaults.raidlist) do
		if string.upper(name) == string.upper(args[2]) then
			POOL = name
		end
	end
	if string.find(string.upper(txt), "ALL") then
		txt = L["localizedclasses"]
	end
	if senderclass then
		if not string.find(string.upper(txt), string.upper(senderclass)) then
			txt = txt .. " "..senderclass
		end
	end
	local args = {self:Explode(txt, " ")}
	numargs = #args
	for i = 2, numargs do
		local class = string.upper(args[i])
		if raided then
			for pname, data in pairs(roster) do
				if data.class ~= "PET" then
					pclass = BC[string.upper(string.sub(data.class,1,1))..string.lower(string.sub(data.class,2,-1))]
					local realClass = BC[string.upper(string.sub(data.class,1,1))..string.lower(string.sub(data.class,2,-1))]
					if string.upper(pclass) == class then
						self:PointsPoolExists(pname, POOL)
						local points = self:PointsFormat(pname, POOL) or 0
						table.insert(dkplist, {pname, pclass, realClass, points})
					end
				end
			end
		else
			for pname, data in pairs(self.db.account.info) do
				if data.class and string.upper(data.class) == class then
					self:PointsPoolExists(pname, POOL)
					local points = self:PointsFormat(pname, POOL) or 0
					table.insert(dkplist, {pname, data.class, data.class, points})
				end
			end
		end
	end
	table.sort(dkplist, function(a,b)
   				if a[4] > b[4] then	return true
				else return false end
			end)
	if sender then SendChatMessage(L["dkpstand"]..POOL..":", "WHISPER", nil, sender) end
	return dkplist
end

function MorgDKP:PointsFormat(name, POOL)
	local points
	if self.db.account.defaults.relational then
		if self.db.account.info[name][POOL].spent  == 0 then self.db.account.info[name][POOL].spent  = 1 end
		if self.db.account.info[name][POOL].earned  == 0 then self.db.account.info[name][POOL].earned  = 1 end
		points = string.format("%.2f", (self.db.account.info[name][POOL].earned /self.db.account.info[name][POOL].spent ))
	else points = self.db.account.info[name][POOL].points end
	return tonumber(points)
end

function MorgDKP:ShowPools(txt, sender)
	SendChatMessage(L["pools"], "WHISPER", nil, sender)
	local counter = 1
	for _, name in pairs(self.db.account.defaults.raidlist) do
		SendChatMessage(tostring(counter)..". "..name, "WHISPER", nil, sender)
		counter = counter + 1
	end
	SendChatMessage(L["whisperformat"], "WHISPER", nil, sender)
end
