-- ******************************************************************
-- ******************************************************************
-- **                         LootTablet				                                  **
-- ******************************************************************
-- ******************************************************************
--

local L = AceLibrary("AceLocale-2.2"):new("MorgDKP")
local dewdrop = AceLibrary("Dewdrop-2.0")

function MorgDKP:OnOpen()
	if not UnitInRaid("player") or not self.db.account.defaults.InRaid then return end
	local numItems = GetNumLootItems()
	if numItems == 0 then return end
      	local nitems = 0
      	self.items = { }
	local needlinks = 1
	local raidlink = {}
	local IGNORE = { }
	local target = UnitName("target")
	for _, ignorelink in pairs(self.db.account.defaults.ignore) do
		local _,_, ignoreid = string.find(ignorelink, "item:(%d+):")
		ignoreid = tonumber(ignoreid)
		IGNORE[ignoreid] = true
	end
	raidlink[1] = (target or "") .. ": "
	for slot = 1, numItems  do
		local link = GetLootSlotLink(slot)
		if link ~= nil and not LootSlotIsCoin(slot) then
	    		local _,_, itemId = string.find(link, "item:(%d+):")
			itemId = tonumber(itemId)
			local lootIcon, lootName, _, rarity = GetLootSlotInfo(slot)
			if rarity >=  self.db.account.defaults.quality and not IGNORE[itemId] then
	    			if nitems == 2 or nitems == 4 or nitems == 6 or nitems == 8 then
	    				needlinks = needlinks + 1
	    				raidlink[needlinks] = ""
	    			end
	    			raidlink[needlinks] = raidlink[needlinks] .. link
	    			nitems = nitems + 1
				self:AddItemforQuery(link, itemId, lootIcon, lootName, nitems)
				self.db.account.raidlog.lootbuffer[lootName] = target
			end
	 	end
      	end
 	if not self.db.account.defaults.dkplistener then
 		if nitems > 0 and not self.f then
 			for _, v in pairs(raidlink) do
 				SendChatMessage(v , "RAID")
 			end
			self:ShowTablet()
		end
	end
end

function MorgDKP:CreateLootFrame()
	self.f = { }
	self.f = CreateFrame("Frame", "MorgDKPLoot", UIParent)
   	local f = self.f
   	f:SetFrameStrata("DIALOG")
   	f:SetFrameLevel(5)
   	f:SetWidth(270)
   	f:SetHeight((#self.items * 50) + 45)
   	f:SetMovable(1)
   	f:EnableMouse(1)
   	f:RegisterForDrag("LeftButton")
   	f:SetScript("OnDragStart", function() f:StartMoving() end)
   	f:SetScript("OnDragStop", function()
   					f:StopMovingOrSizing()
   					self.db.account.defaults.lootframex = f:GetLeft()
   					self.db.account.defaults.lootframey = f:GetTop()
   				end)
	f:ClearAllPoints()
  	f:SetPoint("TOPLEFT", UIParent, "BOTTOMLEFT", self.db.account.defaults.lootframex, self.db.account.defaults.lootframey)

	f.title = f:CreateFontString()
   	f.title:SetPoint("CENTER", f, "TOP", 0, -15)
   	f.title:SetTextColor(1.0, 0.819, 0.0)
   	f.title:SetWidth(150)
   	f.title:SetFontObject(GameFontNormal)
   	f.title:SetText(L["lootdistro"])

   	f.close = CreateFrame("Button", "CloseButton", f)
   	f.close:SetScript("OnClick", function()
   					f:Hide()
   					self.f = nil
					self.items = nil
				 end)
   	f.close:SetWidth(32)
   	f.close:SetHeight(32)
   	f.close:SetNormalTexture("Interface\\Buttons\\UI-Panel-MinimizeButton-Up")
   	f.close:SetPushedTexture("Interface\\Buttons\\UI-Panel-MinimizeButton-Down")
   	f.close:SetHighlightTexture("Interface\\Buttons\\UI-Panel-MinimizeButton-Highlight")
   	f.close:ClearAllPoints()
   	f.close:SetPoint("TOPRIGHT", f, "TOPRIGHT", 3, 3)
   	f.close:SetHitRectInsets(5, 5, 5, 5)
   	f.close:Show()

   	f.menu = CreateFrame("Button", "MenuButton", f)
   	f.menu:SetScript("OnClick", function() self:ShowMainMenu(f) end)
   	f.menu:SetWidth(24)
   	f.menu:SetHeight(24)
   	f.menu:SetNormalTexture("Interface\\Buttons\\UI-PlusButton-Up")
   	f.menu:SetPushedTexture("Interface\\Buttons\\UI-PlusButton-Down")
   	f.menu:SetHighlightTexture("Interface\\Buttons\\UI-PlusButton-Hilight")
   	f.menu:ClearAllPoints()
   	f.menu:SetPoint("TOPLEFT", f, "TOPLEFT", 4, -3)
   	f.menu:SetHitRectInsets(5, 5, 5, 5)
   	f.menu:Show()

   	f:SetBackdrop({ bgFile = "Interface\\Tooltips\\UI-Tooltip-Background", tile = true, tileSize = 16, edgeFile = "Interface\\Tooltips\\UI-Tooltip-Border", edgeSize = 16, insets = { left = 3, right = 3, top = 3, bottom = 3 } })
	f:SetBackdropColor(.25, .25, .25, .75)
	f:SetBackdropBorderColor(1, 1, 1, 1)
end

function MorgDKP:ShowTablet()
	if self.f then return end
	self:CreateLootFrame()
	local f = self.f
	f.class = { }
	f.altclass = { }
	f.icon = { }
	f.value = { }
	f.query = { }
	f.multi = { }
	for item = 1, #self.items do
		f.class[item] = CreateFrame("Button", "LootFrame"..item, f, "UIPanelButtonTemplate")
   		f.class[item]:SetWidth(60)
   		f.class[item]:SetHeight(20)
   		f.class[item]:SetText(L["classmain"])
   		f.class[item]:ClearAllPoints()
		f.class[item]:SetPoint("LEFT", f, "TOPLEFT", 18, -50 * item)
   		f.class[item]:SetScript("OnClick", function() MorgDKP:ShowClassMenu(this:GetParent(), this:GetName()) end)
   		f.class[item]:Show()

   		f.altclass[item] = CreateFrame("Button", "AltClassFrame"..item, f, "UIPanelButtonTemplate")
   		f.altclass[item]:SetWidth(60)
   		f.altclass[item]:SetHeight(20)
   		f.altclass[item]:SetText(L["classalt"])
   		f.altclass[item]:ClearAllPoints()
		f.altclass[item]:SetPoint("TOPLEFT", f.class[item], "BOTTOMLEFT", 0, -2)
   		f.altclass[item]:SetScript("OnClick", function() MorgDKP:ShowAltClassMenu(this:GetParent(), this:GetName()) end)
   		f.altclass[item]:Show()

   		f.icon[item] = CreateFrame("Button", "LootIcon"..item, f)
		f.icon[item]:SetWidth(45)
		f.icon[item]:SetHeight(45)
		f.icon[item]:SetNormalTexture(self.items[item].icon)
		f.icon[item]:ClearAllPoints()
		f.icon[item]:SetPoint("TOPLEFT", f.class[item], "TOPRIGHT", 8, 0)
		f.icon[item]:SetScript("OnEnter", function()
					GameTooltip:SetOwner(this, "ANCHOR_RIGHT")
					GameTooltip:SetHyperlink(self.items[item].link)
					CursorUpdate()
				end)
		f.icon[item]:SetScript("OnLeave", function() GameTooltip:Hide() end)
		f.icon[item]:Show()

		f.value[item] = CreateFrame("Button", "LootValue"..item, f)
		f.value[item]:EnableMouseWheel(1)
		f.value[item]:SetWidth(38)
		f.value[item]:SetHeight(38)
		f.value[item]:ClearAllPoints()
		f.value[item]:SetPoint("LEFT", f.icon[item], "RIGHT", 5, 0)
		f.value[item]:SetNormalTexture("Interface\\Buttons\\ButtonHilight-Square")
		f.value[item]:SetTextFontObject("GameFontNormal")
		f.value[item]:SetTextColor(0,1,0)
		f.value[item]:SetText(self.db.account.items[self.items[item].id].points or 0)
		f.value[item]:SetScript("OnMouseWheel", function() self:SetValue(this:GetParent(), this:GetName(), arg1) end)
		f.value[item]:SetScript("OnMouseDown", function() self:SetValue(this:GetParent(), this:GetName(), arg1) end)
		f.value[item]:SetScript("OnEnter", function()
					GameTooltip:SetOwner(this, "ANCHOR_RIGHT")
					GameTooltip:SetText(L["valuehint"])
				end)
		f.value[item]:SetScript("OnLeave", function() GameTooltip:Hide() end)
		f.value[item]:Show()

		local offset = 0
		if self.db.account.defaults.multiPool then
			f.multi[item] = CreateFrame("Button", "MultiFrame"..item, f, "UIPanelButtonTemplate")
   			f.multi[item]:SetWidth(80)
   			f.multi[item]:SetHeight(20)
   			f.multi[item]:SetText(self.db.account.items[self.items[item].id].pool)
   			f.multi[item]:ClearAllPoints()
			f.multi[item]:SetPoint("LEFT", f.value[item], "RIGHT", 5, 10)
   			f.multi[item]:SetScript("OnClick", function() MorgDKP:ShowPoolMenu(this:GetParent(), this:GetName()) end)
   			f.multi[item]:Show()
   			offset = 10
   		end

		f.query[item] = CreateFrame("Button", "QueryButton"..item, f, "UIPanelButtonTemplate")
   		f.query[item]:SetWidth(60)
   		f.query[item]:SetHeight(20)
   		f.query[item]:SetText(L["query"])
   		f.query[item]:ClearAllPoints()
		f.query[item]:SetPoint("LEFT", f.value[item], "RIGHT", 5, 0  - offset)
   		f.query[item]:SetScript("OnClick", function() MorgDKP:StartItemQuery(this:GetParent(), this:GetName()) end)
   		f.query[item]:Show()
   	end
end

function MorgDKP:ShowMainMenu(frame)
	self.hasitem = nil
	dewdrop:Open(frame,
			'children', function(level, value)
					dewdrop:FeedAceOptionsTable(MorgDKP.opts)
					end,
			 'cursorX', true,
			 'cursorY', true
			)
end

function MorgDKP:ShowClassMenu(frame, name)
	_, _, index = string.find(name, "LootFrame(%d+)")
	index = tonumber(index)
	if not self.items[index] then return end
	myid = self.items[index].id
	dewdrop:Open(frame.class[index],
			'children', function(level, value)
					dewdrop:FeedAceOptionsTable(MorgDKP.classopts)
					end,
			 'cursorX', true,
			 'cursorY', true
			)
end

function MorgDKP:ShowAltClassMenu(frame, name)
	_, _, index = string.find(name, "AltClassFrame(%d+)")
	index = tonumber(index)
	if not self.items[index] then return end
	myid = self.items[index].id
	dewdrop:Open(frame.altclass[index],
			'children', function(level, value)
					dewdrop:FeedAceOptionsTable(MorgDKP.altclassopts)
					end,
			 'cursorX', true,
			 'cursorY', true
			)
end

function MorgDKP:ShowPoolMenu(frame, name)
	_, _, index = string.find(name, "MultiFrame(%d+)")
	index = tonumber(index)
	self.poolindex = index
	dewdrop:Open(frame.multi[index],
			'children', function(level, value)
					dewdrop:FeedAceOptionsTable(MorgDKP.Poolopts)
					end,
			 'cursorX', true,
			 'cursorY', true
			)
end

function MorgDKP:SetRollPool(pool)
	self.f.multi[self.poolindex]:SetText(pool)
	self.db.account.items[self.items[self.poolindex].id].pool = pool
end

function MorgDKP:SetValue(frame, name, button)
	_, _, index = string.find(name, "LootValue(%d+)")
	index = tonumber(index)
	local value = self.db.account.items[self.items[index].id].points
	local step = 5
	if IsShiftKeyDown() then step = 1 end
	if IsAltKeyDown() then step = 20 end
	if button == 1 then value = value + step
	elseif button == -1 then value = value - step
	elseif button == "LeftButton" then value = value + step
	elseif button == "RightButton" then value = value - step
	end
	frame.value[index]:SetText(value)
	self.db.account.items[self.items[index].id].points = value
	if self.db.account.raidlog.loot then
		for num, loot in pairs(self.db.account.raidlog.loot) do
			if loot.ID == self.items[index].id then
				loot.Costs = value
				loot.Note = string.gsub(loot.Note, "%d+.00 DKP", tostring(value)..".00 DKP")
			end
		end
  	end
end

function MorgDKP:StartItemQuery(frame, name)
	_, _, index = string.find(name, "QueryButton(%d+)")
	index = tonumber(index)
	if not self.items[index] then return end
	id = self.items[index].id
	link = self.items[index].link
	if IsShiftKeyDown() then
		self.random[id] = true
	end
	self:StartQuery(id, link)
	table.remove(self.items, index)
	if #self.items > 0 then
		self.f:Hide()
		self.f = nil
		self:ShowTablet()
		return
	end
	self.f:Hide()
	self.f = nil
	self.items = nil
end

function MorgDKP:ManualItem(id, link)
	local index
	if not self.items then
		self.items = { }
		index = 1
	else index = #self.items + 1 end
	local sName, _, _, _, _, _, _, _, _, iconGIF = GetItemInfo(id)
	self:AddItemforQuery(link, id, iconGIF, sName, index)
	if self.f then
		self.f:Hide()
		self.f = nil
	end
	self:ShowTablet()
end

function MorgDKP:AddItemforQuery(link, id, icon, name, index)
	self:IteminDB(id)
	self.items[index] = {
				name = name,
				id = id,
				link = link,
				icon = icon
	}
end
