-- ******************************************************************
-- ******************************************************************
-- **                         MorgDKP                              **
-- ******************************************************************
-- ******************************************************************
--
--  All code courtesy Fryguy:) Thanks
--

local L = AceLibrary("AceLocale-2.2"):new("MorgDKP")

---------------
-- tooltip parsing (Stolen from Mendeleev)
---------------
local linkFuncs = {
	SetAuctionItem		= GetAuctionItemLink,
	SetBagItem		= GetContainerItemLink,
	SetCraftItem		= function(skill, id) return (id) and GetCraftReagentItemLink(skill, id) or GetCraftItemLink(skill) end,
	SetHyperlink		= function(link) return link end,
	SetInventoryItem	= function(type, slot) return (type) and GetInventoryItemLink(type, slot) or GetContainerItemLink(BANK_CONTAINER,this:GetID()) end,
	SetLootItem		= GetLootSlotLink,
	SetMerchantItem	= GetMerchantItemLink,
	SetQuestItem		= GetQuestItemLink,
	SetQuestLogItem	= GetQuestLogItemLink,
	SetTradePlayerItem	= GetTradePlayerItemLink,
	SetTradeSkillItem	= function(skill, id) return (id) and GetTradeSkillReagentItemLink(skill, id) or GetTradeSkillItemLink(skill) end,
	SetTradeTargetItem	= GetTradeTargetItemLink,
	SetLootRollItem	= function(index) return GetLootRollItemLink(index) end,
}
function MorgDKP:SetItemRef(link, text, button)
	self.hooks.SetItemRef(link, text, button)
	if not strfind(link, "item") or IsControlKeyDown() or IsShiftKeyDown() then return end
	self:ParseTooltip(ItemRefTooltip, link)
end

function MorgDKP:HookStuff()
	self:HookTooltips()
  	--self:SecureHook("SetItemRef")
  	self:Hook("ContainerFrameItemButton_OnModifiedClick", true)
  	hooksecurefunc("HandleModifiedItemClick",  MorgDKP.HandleModifiedItemClick)
end

function MorgDKP:HookTooltips()
	for key, value in pairs(linkFuncs) do
		local orig, linkFunc = key,value -- I cant leave this out, dont ask me why.
		local func = function(tooltip,a,b,c)
		self:ParseTooltip(tooltip,linkFunc(a,b,c))
		return
	end
	self:SecureHook(GameTooltip,orig,func)
	end
	self:SecureHook("SetItemRef")
end

function MorgDKP:ParseTooltip(frame,link,id)
	if link == nil then return end

	local _, _, tid = string.find(link, "item:(%d+):%d+:%d+:%d+")
	local id = tonumber(tid)

	if link == self.link then
		self:DrawTooltip(frame)
		return
	elseif tid == nil then
		--self:debug("malformed link")
		return
	else
		self.link = link
		--self.compost:Reclaim(self.TT, 1)
		--self.TT = self.compost:Acquire()
		self.TT = { }
	end

	MorgDKP:DoTooltip(frame,link,id)

	self:DrawTooltip(frame)
end

function MorgDKP:DrawTooltip(frame)
	for _,z in ipairs(self.TT) do
		if (KC_Items and KC_Items.tooltip) then
  			--KC_Tooltip:AddTextLine(frame, z.Stringa, z.Stringb, " ", "|cffffffff")
  			KC_Items.tooltip:AddTextLine(frame, z.Stringa, z.Stringb, " ", "|cffffffff")
		else
			frame:AddDoubleLine(z.Stringa,z.Stringb,1,1,1,1,1,1)
		end
	end
	frame:Show()
end

function MorgDKP:DoTooltip(frame,link,id)
	local players = self:GetPlayersNeedItem(id)
	if not players then return end
	local ct = 0
	for i,v in ipairs(players) do
		--DEFAULT_CHAT_FRAME:AddMessage("#" .. i .. " " .. v.name .. "(" .. v.points .. ") ")
		ct = ct + 1
		if ct == 5 then return end
		self:AddLine("|cffffffcf#" .. i .. "  " .. v.name, "|cfcffffcf("..v.points..")")
		--DEFAULT_CHAT_FRAME:AddMessage("#" .. i .. " " .. v.name .. "(" .. v.points .. ") ")
	end
	--self:AddLine("test", "Test!")
end

function MorgDKP:AddLine(Stringa,Stringb)
	local i = #self.TT + 1
	local t = { } --self.compost:Acquire()
	t.Stringa = Stringa
	t.Stringb = Stringb
	table.insert(self.TT, t)
end

------------------
-- item setting stuffs
------------------
function MorgDKP:HandleModifiedItemClick(button)
	if IsAltKeyDown() and IsShiftKeyDown() then
		local index = this:GetID()
		if LootSlotIsItem(index) then
			local iteminfo = GetLootSlotLink(index)
			MorgDKP:MakeDewDropMenu(UIParent, iteminfo)
			return
		end
	end
	--return self.hooks.HandleModifiedItemClick(button)
end

function MorgDKP:SetItemRef(link, text, button)
	-- make sure it's an item
	if strsub(link, 1, 6) ~= "player"  then
		if IsAltKeyDown() and IsShiftKeyDown() and button=="LeftButton" then
			self:MakeDewDropMenu(this, text)
		end
	end

	return
	--self.hooks.SetItemRef(link, text, button)
end

function MorgDKP:ContainerFrameItemButton_OnModifiedClick(button)
	if IsShiftKeyDown() and IsAltKeyDown() and button=="LeftButton" then
		self:OpenItemOptions(this)
	else
		--return self:CallHook("ContainerFrameItemButton_OnClick", button, ignoreModifiers)
		return self.hooks.ContainerFrameItemButton_OnModifiedClick(button)
	end
end

function MorgDKP:OpenItemOptions(frame, slot)
	local bag = slot and frame or frame:GetParent():GetID()
	slot = slot or frame:GetID()
	local itemlink = GetContainerItemLink(bag, slot)
	self:MakeDewDropMenu(frame, itemlink)
end
