-- ******************************************************************
-- ******************************************************************
-- **                         MorgDKP                              **
-- ******************************************************************
-- ******************************************************************


local L = AceLibrary("AceLocale-2.2"):new("MorgDKP")
local BC = AceLibrary("Babble-Class-2.2")
local BB = LibStub("LibBabble-Boss-3.0"):GetLookupTable()
local rosterlib = AceLibrary("Roster-2.1")
local roster = rosterlib.roster
local tablet = AceLibrary("Tablet-2.0")

function MorgDKP:BeginRaid()
	if not self:IsRaided() then return end
	self:RequestLeader()
	local StartDate = date("%m/%d/%y %H:%M:%S")
	local ZoneName = GetRealZoneText()
	local Startname, Runname, Startnote, Runnote
	self:Scan()
	self.waitlistdone = {}
	self.db.account.raidlog.attendancedone = {}
	if not self.db.account.defaults.raidnum then self.db.account.defaults.raidnum = 0 end
	self.db.account.defaults.raidnum = self.db.account.defaults.raidnum + 1
	self.db.account.raidlog[self.db.account.defaults.raidnum] = { }
	self.db.account.raidlog[self.db.account.defaults.raidnum].playerinfo = { }
	self.db.account.raidlog[self.db.account.defaults.raidnum].join = { }
	self.db.account.raidlog[self.db.account.defaults.raidnum].leave = { }
	self.db.account.raidlog[self.db.account.defaults.raidnum].bosskills = { }
	self.db.account.raidlog[self.db.account.defaults.raidnum].loot = { }
	self.db.account.raidlog[self.db.account.defaults.raidnum].zone = ZoneName
	self.db.account.raidlog[self.db.account.defaults.raidnum].raidstart = StartDate
	self.db.account.raidlog.lootbuffer = { }
	if not self.db.account.raidlog.dkpevents then self.db.account.raidlog.dkpevents = { } end
	if not self.db.account.raidlog.aliases then self.db.account.raidlog.aliases = { } end
	for name, _ in pairs(self.db.account.info) do
		self.db.account.info[name].raidloot = 0
	end
	self.db.account.raidlog[self.db.account.defaults.raidnum].eqdkp = self.db.account.defaults.eqDKP[self.db.account.defaults.raid].eqDKPsite
	self.db.account.raidlog[self.db.account.defaults.raidnum].prefix = self.db.account.defaults.eqDKP[self.db.account.defaults.raid].prefix
	self.db.account.raidlog.raidstart = StartDate
	self.db.account.raidlog.raidend = L["pending"]
	self.db.account.raidlog.raidexport = L["pending"]
	if self.db.account.defaults.startrun then
		Startnote = string.gsub(self.db.account.defaults.startformat, "<zone>", ZoneName, 1)
		Startname = self:GetEventName(Startnote)
		self:LogBossKill(StartDate, Startname, 1, Startnote, nil, 1) 
	end
	Runnote = string.gsub(self.db.account.defaults.trashformat, "<zone>", ZoneName, 1)
	Runname = self:GetEventName(Runnote)
	self:LogBossKill(StartDate, Runname, 1, Runnote, 1, 2) 
	self.db.account.defaults.InRaid = 1
	self.db.account.defaults.raidend = nil
	if self.db.account.defaults.dkpaward then self:ScheduleRepeatingEvent("MorgDKP_Award", self.RecurrentReward, self.db.account.defaults.dkpsched, self ) end 
	self:ScheduleRepeatingEvent("MorgDKP_Attendance", self.CheckAttendance, 60, self )	--600
	local attendees = { }
	local counter = 0
	for name in pairs(roster) do
    		tbl = roster[name]
    		if tbl.oldclass ~= "PET" and tbl.class ~= "PET" then 
    			local raidID = tbl.unitid
    			local _, race = UnitRace(raidID)
    			local level = UnitLevel(raidID)
			local guild, _, _ = GetGuildInfo(raidID)
			local class = BC[string.upper(string.sub(tbl.class,1,1))..string.lower(string.sub(tbl.class,2,-1))]
			if name and name ~= "" and name ~= "UNKNOWN" then
				if not attendees[name] then attendees[name] = { } end
				if class then attendees[name].class = class end
				if race then attendees[name].race = race end
				if level > 0 then attendees[name].level = level end
				if guild then attendees[name].guild = guild end
			end
			self.db.account.raidlog[self.db.account.defaults.raidnum].join[name] = StartDate
			counter = counter + 1
		end
	end
	self.db.account.raidlog[self.db.account.defaults.raidnum].playerinfo = attendees
	DEFAULT_CHAT_FRAME:AddMessage(L["add"]..tostring(counter)..L["raidstartadd"])
end	

function MorgDKP:EndRaid()
	if not self.db.account.defaults.InRaid then DEFAULT_CHAT_FRAME:AddMessage(L["noraid"]) return end
	if self:IsEventScheduled("MorgDKP_Award") then self:CancelScheduledEvent("MorgDKP_Award") end
	if self:IsEventScheduled("MorgDKP_Attendance") then self:CancelScheduledEvent("MorgDKP_Attendance") end
	local EndTime = date("%m/%d/%y %H:%M:%S")
	self.db.account.raidlog.raidend = EndTime
	self.db.account.defaults.raidend = 1
	self.db.account.defaults.InRaid = nil
	counter = 0
	for name in pairs(roster) do
    		local tbl = roster[name]
    		local raidID = tbl.unitid
    		if tbl.oldclass ~= "PET" and tbl.class ~= "PET" then 
    			if name and name ~= "" and name ~= "UNKNOWN" then
				self.db.account.raidlog[self.db.account.defaults.raidnum].leave[name] = EndTime
			end
			counter = counter + 1
		end
	end
	self.db.account.defaults.Waitlist = {members = {}, join = {}}
	self.db.account.raidlog.attendancedone = {}
	self.db.account.defaults.custom = L["NEW"]
	DEFAULT_CHAT_FRAME:AddMessage(L["removed"]..tostring(counter)..L["raidatt"])
  end

function  MorgDKP:GetEventName(boss)
	local zone = GetRealZoneText()
	local note
	local event = self.db.account.defaults.eventformat
	event = string.gsub(event, "<zone>", zone)
	event = string.gsub(event, "<boss>", boss)
	return event
end

function MorgDKP:FillDKPChanges()
	local temp = { }
	for pool, data in pairs(self.db.account.raidlog.dkpevents) do
		for index, changes in pairs(data) do
			if changes.addtype == "Decay" then
				for key, name in pairs(changes.members) do
					name = self:CheckforAlias(name, pool)
					self:PointsPoolExists(name, pool)
					local value = 0 - (math.floor((self.db.account.info[name][pool].points * changes.value/100) + 0.5))
					table.insert(temp, {    name = name, 
									value = value, 
									members = {[1] = name},
									eqdkp = changes.eqdkp,
									prefix = changes.prefix,
									addtype = "individual",
									event = changes.event})
				end
			else table.insert(temp, changes)
			end
		end
	end
	return temp
end

function MorgDKP:CheckforAlias(name, pool)
	for _, data in pairs(self.db.account.defaults.eqDKP[pool].Aliases) do
		if data.alt == name then return data.main end
	end
	return name
end

function MorgDKP:OutputRaid(raidlog, raidid)
	local DKPChanges = self:FillDKPChanges()
	local link = "<MorgDKP>"
	if raidlog.aliases then
		link = link.."<Aliases>"
		local index = 1
		for pool, data in pairs(raidlog.aliases) do
			table.sort(data, function (a, b) return a.alt < b.alt end)
			for _, data2 in pairs(data) do
				link = link.."<key"..index..">"	
				link = link.."<alt>"..data2.alt.."</alt>"
				link = link.."<main>"..data2.main.."</main>"
				link = link.."<eqdkp>"..data2.eqdkp.."</eqdkp>"
				link = link.."<prefix>"..self.db.account.defaults.eqDKP[pool].prefix.."</prefix>"
				link = link.."<action>"..data2.action.."</action>"
				link = link.."</key"..index..">"
				index = index + 1
			end
		end
		link = link.."</Aliases>"
	end
	if DKPChanges then
		link = link.."<DKPChanges>"
		for key, data in pairs(DKPChanges) do
			link = link.."<key"..key..">"	
			link = link.."<name>"..data.name.."</name>"
			link = link.."<value>"..data.value.."</value>"
			link = link.."<eqdkp>"..data.eqdkp.."</eqdkp>"
			link = link.."<prefix>"..data.prefix.."</prefix>"
			link = link.."<event>"..data.event.."</event>"
			link = link.."<addtype>"..data.addtype.."</addtype>"
			link = link.."<members>"
			for key2, val2 in pairs(data.members) do
				link = link.."<key"..key2..">" ..val2.. "</key"..key2..">"
			end
			link = link.."</members>"
			link = link.."</key"..key..">"
		end
		link = link.."</DKPChanges>"
	end
	link = link.."<Raids>"
	if self.db.account.defaults.raidnum > 0 then
		for raidindex = 1, self.db.account.defaults.raidnum do
			if not raidid or raidindex == raidid then
				local raiddata = raidlog[raidindex]
				link = link.."<key"..raidindex..">"
				link = link.."<zone>"..raiddata.zone.."</zone>"
				link = link.."<date>"..raiddata.raidstart.."</date>"
				link = link.."<eqdkp>"..raiddata.eqdkp.."</eqdkp>"
				link = link.."<prefix>"..raiddata.prefix.."</prefix>"
				link = link.."<Attendees>"
				local index = 1
				for key, _ in pairs(raiddata.playerinfo) do
					link = link.."<key"..index..">"
					link = link.."<name>"..key.."</name>"
					for key2, val2 in pairs(raiddata.playerinfo[key]) do
						link = link.."<"..key2..">"..val2.."</"..key2..">"
					end
					link = link.."</key"..index..">"
					index = index + 1
				end
				link = link.."</Attendees>"
				link = link.."<Bosskills>"
				for key, data in pairs(raiddata.bosskills) do
					link = link.."<key"..key..">"
					link = link.."<name>"..data.name.."</name>"
					link = link.."<note>"..data.note.."</note>"
					link = link.."<time>"..data.time.."</time>"
					link = link.."<value>"..data.value.."</value>"
					link = link.."<trash>"..data.trash.."</trash>"
					link = link.."<attendees>"
					for key2, val2 in pairs(data.attendees) do
						link = link.."<key"..key2..">" ..val2.. "</key"..key2..">"
					end
					link = link.."</attendees>"
					link = link.."</key"..key..">"
				end
				link = link.."</Bosskills>"
				link = link.."<Loot>"
				for key, data in pairs(raiddata.loot) do
					link = link.."<key"..key..">"
					for key2, val2 in pairs(data) do
						link = link.."<"..key2..">"..val2.."</"..key2..">"
					end
					link = link.."</key"..key..">"
				end
				link = link.."</Loot>"
				link = link.."</key"..raidindex..">"
				raidindex = raidindex + 1
			end
		end
	end
	link = link.."</Raids>"
	link = link.."</MorgDKP>"	
	MorgDKP:OutputLink(link) 
end

function MorgDKP:OutputLink(link)
	URLFrameEditBox:SetText(link)
	URLFrameEditBox:HighlightText()
	URLFrame:Show()
end

function MorgDKP:CombatLogEvent(timestamp, eventtype, srcGUID, srcName, srcFlags, dstGUID, dstName, dstFlags, ...)
	if not UnitInRaid("player") or not self.db.account.defaults.InRaid then return end
	--DEFAULT_CHAT_FRAME:AddMessage(eventtype..","..(srcName or "nil")..","..(srcFlags or "nil")..","..(dstName or "nil")..","..(dstFlags or "nil"))
	if eventtype == "UNIT_DIED" or eventtype == "UNIT_DESTROYED" then self:HostileDeath(dstName, dstGUID) end
end

function MorgDKP:HostileDeath(mobName, GUID)
	local killTime    = date("%m/%d/%y %H:%M:%S")
	if not L["MorgTracker_IgnoreMobs"][mobName] then self.db.account.raidlog[self.db.account.defaults.raidnum].lastmob = mobName end
 	if mobName ~= nil  then
  		local Boss
   		if mobName == L["Romulo"] or mobName == L["Julianne"] then 
   			Boss = L["RomuloandJulianne"] 
 			self.killed[Boss] = self.killed[Boss] + 1 
  			if self.killed[Boss] < 4 or self.db.account.raidlog[self.db.account.defaults.raidnum].lastboss == Boss then return end
  		elseif mobName == BB["Essence of Anger"] then Boss = BB["Reliquary of Souls"]
  		elseif mobName == BB["Lady Sacrolash"] or mobName == BB["Grand Warlock Alythess"] then
  			Boss = BB["Eredar Twins"]
  			self.killed[Boss] = self.killed[Boss] + 1
  			if self.killed[Boss] < 2 then return end
  		else
  			for _, bossname in pairs(MorgTracker_ZoneBosses[self.db.account.defaults.menuzone]) do
  				if mobName == bossname then Boss = mobName break end
  			end
  		end
  		if Boss then 
  			local Eventname = self:GetEventName(Boss)
  			self:LogBossKill(killTime, Eventname, nil, Boss) 
  		end
  	end
end

function MorgDKP:LogBossKill(killTime, Boss, notboss, Note, quiet, id)
	if not self.db.account.defaults.OneEvent or id == 2 then
		local attendees = { }
		if id ~= 2 then
			counter = 0
			for name in pairs(roster) do
    				if name and name ~= "" and name ~= "UNKNOWN" then
					local tbl = roster[name]
					if tbl.class ~= "PET" and tbl.oldclass ~= "PET" then 
						table.insert(attendees, name)
						counter = counter + 1
					end
				end
			end
		end
		local value = 0
		if self.db.account.defaults.eqDKP[self.db.account.defaults.raid]["Events"][Boss] then value = self.db.account.defaults.eqDKP[self.db.account.defaults.raid]['Events'][Boss].value end
		table.insert(self.db.account.raidlog[self.db.account.defaults.raidnum].bosskills,
						{
							["name"] = Boss,
							["note"] = Note,
							["time"] = killTime,
							["attendees"] = attendees,					
							["value"] = value,
							["trash"] = id or 0
						}
					)
		local POOL = self.db.account.defaults.raid
		if not quiet then
			DEFAULT_CHAT_FRAME:AddMessage(Note..L["bosskill"]..killTime.." and "..tostring(counter)..L["attadded"])
			if id ~= 1 and self.Starttime then
				local totaltime = self:TimeDiff(self.Starttime, killTime)
				local min = math.floor(totaltime/60)
				local sec = totaltime - (min * 60)
				if sec < 10 then sec = "0"..sec end
				DEFAULT_CHAT_FRAME:AddMessage(Note..string.format(L["bosstime"], min, sec))
			end
			self:AwardDKP(nil, value, POOL, attendees)
			if self.db.account.defaults.waitaward then self:AwardWaitlistDKP(value, POOL, Boss, id) end
		end
	end
	if not notboss then 
		self.db.account.raidlog[self.db.account.defaults.raidnum].lastboss = Boss
	end
	if Boss == BB["Rage Winterchill"] or Boss == BB["Anetheron"] or Boss == BB["Kaz'rogal"] then self:ChangeLootMethod("group") end
end

function MorgDKP:HostileYell()
	if not UnitInRaid("player") or not self.db.account.defaults.InRaid then return end
	if arg1 == L["MORGTRACKER_MAJORDOMO_YELL"]  then
  		local killTime = date("%m/%d/%y %H:%M:%S")
  		local Boss = BB["Majordomo Executus"]
  		local Eventname = self:GetEventName(Boss)
 		self:LogBossKill(killTime, Eventname, nil, Boss)
  	elseif arg1 == L["MORGTRACKER_ROMULO_YELL"] then
   		self.killed[L["RomuloandJulianne"]] = 0
   	elseif arg1 == L["MORGTRACKER_ERADOR_YELL"] then
   		self.killed[BB["Eredar Twins"]] = 0
  	elseif arg1 == L["MORGTRACKER_LADYVASHJP2_YELL"] then self:ChangeLootMethod("freeforall") 
  	elseif arg1 == L["MORGTRACKER_LADYVASHJP3_YELL"] then self:ChangeLootMethod("master") 
  	elseif arg1 == L["MORGTRACKER_RAGEENTERS_YELL"] then self:ChangeLootMethod("master") 
  	elseif arg1 == L["MORGTRACKER_ANETHERONENTERS_YELL"] then self:ChangeLootMethod("master") 
  	elseif arg1 == L["MORGTRACKER_KAZROGALENTERS_YELL"] then self:ChangeLootMethod("master") 
  	elseif arg1 == L["MORGTRACKER_AZGALORENTERS_YELL"] then self:ChangeLootMethod("master") 
  	end
end

function MorgDKP:HostileEmote()
	if not UnitInRaid("player") or not self.db.account.defaults.InRaid then return end
	if  arg1 == L["MORGTRACKER_CHESS_EMOTE"]  then
  		local killTime = date("%m/%d/%y %H:%M:%S")
 		local Boss = BB["Chess Event"]
 		self.db.account.raidlog[self.db.account.defaults.raidnum].lastmob = BB["Chess Event"]
 		local Eventname = self:GetEventName(Boss)
 		self:LogBossKill(killTime, Eventname, nil, Boss)
  	end
  end
  
function MorgDKP:LeaderDied()
	if not self.db.account.defaults.InRaid then return end
	StaticPopup_Show ("BossAttempt", self.db.account.defaults.custom)
end

function MorgDKP:ChangeLootMethod(method)
	self:PrepareRaidmembers()
	if not self.lootmaster then self.lootmaster = UnitName("player") end
	if method == "master" then SetLootMethod("master", self.lootmaster) 
  	else SetLootMethod(method) end
end

function MorgDKP:ProcessRosterChange(unitid, name, class, subgroup, rank, oldname, oldunitid, oldclass, oldsubgroup, oldrank)
	if not UnitInRaid("player") then return end 
	self:PrepareRaidmembers()
	if not self.db.account.defaults.InRaid and not self.querytooltips["listdkp"] then return end
	local ttime = date("%m/%d/%y %H:%M:%S")
	if not name then
		if oldclass ~= "PET" and class ~= "PET" then 
			if self.oldname ~= oldname then
				if name ~= UnitName("player") and not UnitCanAttack("player", oldunitid) then
					if not self.db.account.raidlog[self.db.account.defaults.raidnum].leave then self.db.account.raidlog[self.db.account.defaults.raidnum].leave = { } end
					self.db.account.raidlog[self.db.account.defaults.raidnum].leave[oldname] = ttime
					DEFAULT_CHAT_FRAME:AddMessage(oldname..L["leftraid"]..ttime)
					self.oldname = oldname
				end
			end
		end
	elseif not oldname then
		if oldclass ~= "PET" and class ~= "PET" then 
			if self.name ~= name then
				local _, race = UnitRace(unitid)
    				local level = UnitLevel(unitid)
				local guild = GetGuildInfo(unitid)
				local classtrue = BC[string.upper(string.sub(class,1,1))..string.lower(string.sub(class,2,-1))]
				if not self.db.account.raidlog[self.db.account.defaults.raidnum].playerinfo then self.db.account.raidlog[self.db.account.defaults.raidnum].playerinfo = { } end
				if not self.db.account.raidlog[self.db.account.defaults.raidnum].playerinfo[name] then self.db.account.raidlog[self.db.account.defaults.raidnum].playerinfo[name] = { } end
				if classtrue then self.db.account.raidlog[self.db.account.defaults.raidnum].playerinfo[name].class = classtrue end
				if race then self.db.account.raidlog[self.db.account.defaults.raidnum].playerinfo[name].race = race end
				if level > 0 then self.db.account.raidlog[self.db.account.defaults.raidnum].playerinfo[name].level = level end
				if guild then self.db.account.raidlog[self.db.account.defaults.raidnum].playerinfo[name].guild = guild end
				if not self.db.account.raidlog[self.db.account.defaults.raidnum].join then self.db.account.raidlog[self.db.account.defaults.raidnum].join = { } end
				if not self.db.account.raidlog[self.db.account.defaults.raidnum].join[name] then 
					self.db.account.raidlog[self.db.account.defaults.raidnum].join[name] = ttime 
					if self.db.account.raidlog[self.db.account.defaults.raidnum].leave then
						if self.db.account.raidlog[self.db.account.defaults.raidnum].leave[name] then self.db.account.raidlog[self.db.account.defaults.raidnum].leave[name] = nil end
					end
					DEFAULT_CHAT_FRAME:AddMessage(name..L["joinraid"]..ttime)
					if not self:IsEventScheduled("MorgDKP_Attendance") then self:ScheduleRepeatingEvent("MorgDKP_Attendance", self.CheckAttendance, 60, self ) end
				end
				self:PlayerinDB(name , classtrue)
				self.name = name
				for num,waitname in pairs(self.db.account.defaults.Waitlist.members) do
					if waitname == name then
						self:SubWait(name)
					end
				end
				if self.querytooltips["waitlist"] then 
					tablet:Refresh("waitlist") 
				end
			end
		end
	end
	if self.querytooltips["listdkp"] then self:Onlinemembers() end
	self:RequestLeader()
end

function MorgDKP:ReclaimAll()
	MorgDKP.opts.args.deer.validate = self.db.account.defaults.raidmembers
	MorgDKP.opts.args.boes.validate = self.db.account.defaults.raidmembers
	MorgDKP.DEopts.validate = self.db.account.defaults.raidmembers
end

function MorgDKP:ReclaimML()
	MorgDKP.opts.args.mlootdet.validate = self.db.account.defaults.raidmembers
	MorgDKP.MLopts.validate = self.db.account.defaults.raidmembers
end

function MorgDKP:ReclaimZone()
	MorgDKP.opts.args.dkpfunc.args.custommenu.validate = MorgTracker_ZoneBosses[self.db.account.defaults.menuzone]
	MorgDKP.custommenu.validate  = MorgTracker_ZoneBosses[self.db.account.defaults.menuzone]
end

function MorgDKP:ReclaimPool()
	MorgDKP.opts.args.dkpfunc.args.load.validate = self.db.account.defaults.raidlist
	MorgDKP.RaidDBopts.validate = self.db.account.defaults.raidlist
end

function MorgDKP:RecurrentReward()
	if not UnitInRaid("player") then return end 
	if not self.db.account.defaults.dkpaward or not self.db.account.defaults.InRaid then return end
	local POOL = self.db.account.defaults.raid
	local award = self.db.account.defaults.dkpamount
	local currtime = date("%m/%d/%y %H:%M:%S")
	local attendees = { }
	local counter = 0
	local Runname = self.db.account.raidlog[self.db.account.defaults.raidnum].bosskills[self:GetRunEvent()].note
	for i = 1, GetNumRaidMembers() do
		local name = UnitName("raid"..i)
		local jointime = self.db.account.raidlog[self.db.account.defaults.raidnum].join[name]
		if self:TimeDiff(jointime, currtime)  >= self.db.account.defaults.dkpsched then
			self.db.account.info[name][POOL].points = self.db.account.info[name][POOL].points + award
			self.db.account.info[name][POOL].earned = self.db.account.info[name][POOL].earned + award
			table.insert(attendees, name)
			counter = counter + 1
		end
	end
	if counter > 0 then
		self:AwardWaitotimeDKP(award, POOL, Runname, attendees, "Group", "Group")
		DEFAULT_CHAT_FRAME:AddMessage(L["add"]..tostring(award)..L["dkpword"] .."to "..tostring(counter)..L["attend"])
	end
	if self.db.account.defaults.waitaward and self.db.account.defaults.waitotime ~= 0 and #self.db.account.defaults.Waitlist.members ~= 0 then
		self:AwardWaitotimeDKP(self.db.account.defaults.waitotime, POOL, Runname, self.db.account.defaults.Waitlist.members, "Group", "Group") 
		self:AwardDKP(nil, self.db.account.defaults.waitotime, POOL, self.db.account.defaults.Waitlist.members, 1)
	end
end	

function MorgDKP:Initialisedkpevents()
	local POOL = self.db.account.defaults.raid
	if not self.db.account.raidlog.dkpevents then self.db.account.raidlog.dkpevents = { } end
	if not self.db.account.raidlog.dkpevents[POOL] then self.db.account.raidlog.dkpevents[POOL] = { } end
end

function MorgDKP:CheckAttendance()
	if not UnitInRaid("player") or not self.db.account.defaults.InRaid then return end 
	if self.db.account.defaults.devmode then self:Print("Checking attendees...") end
	local POOL = self.db.account.defaults.raid
	local currtime = date("%m/%d/%y %H:%M:%S")
	local value = 0
	local id = self:GetRunEvent()
	if self.db.account.defaults.eqDKP[self.db.account.defaults.raid]['Events'][self.db.account.raidlog[self.db.account.defaults.raidnum].bosskills[id].name] then
		value = self.db.account.defaults.eqDKP[self.db.account.defaults.raid]['Events'][self.db.account.raidlog[self.db.account.defaults.raidnum].bosskills[id].name].value
	end
	for name, jointime in pairs(self.db.account.raidlog[self.db.account.defaults.raidnum].join) do
		if not self.db.account.raidlog.attendancedone[name] and not self.db.account.raidlog[self.db.account.defaults.raidnum].leave[name] then
			if self:TimeDiff(jointime, currtime)  >= self.db.account.defaults.runrewardtime then	
				table.insert(self.db.account.raidlog[self.db.account.defaults.raidnum].bosskills[id].attendees, name)
				self.db.account.raidlog.attendancedone[name]  = true
				if self.db.account.defaults.devmode then self:Print("Added "..name.." to run.") end
				if value then self:AwardDKP(nil, value, POOL, {[1] = name}, nil, 1) end
			end
		end
	end
	local attdone = true
	for name, jointime in pairs(self.db.account.raidlog[self.db.account.defaults.raidnum].join) do
		if not self.db.account.raidlog.attendancedone[name] then attdone = nil end
	end
	if attdone and self:IsEventScheduled("MorgDKP_Attendance") then self:CancelScheduledEvent("MorgDKP_Attendance") end
	if self.db.account.defaults.waitrun == 0 or not self.waitlistdone then return end
	local temp = {}
	for _,  name in pairs(self.db.account.defaults.Waitlist.members) do
		if not self.waitlistdone[name] then
			if self:TimeDiff(self.db.account.defaults.Waitlist.join[name], currtime)  >= self.db.account.defaults.runrewardtime then	
				table.insert(temp, name)
				if self.db.account.defaults.devmode then self:Print("Added "..name.." to run.") end
				self.waitlistdone[name] = true
			end
		end
	end
	if #temp > 0 then
		if self.db.account.defaults.waitrun == value then
		 	for _, name in pairs(temp) do
		 		table.insert(self.db.account.raidlog[self.db.account.defaults.raidnum].bosskills[id].attendees, name)
		 	end
		else 
			self:AwardWaitotimeDKP(self.db.account.defaults.waitrun, POOL, self.db.account.raidlog[self.db.account.defaults.raidnum].bosskills[id].name, temp, "Group", "Group") 
		end
		self:AwardDKP(nil, self.db.account.defaults.waitrun, POOL, temp, 1, 1)
	end
end

function MorgDKP:GetRunEvent()
	for id, event in pairs(self.db.account.raidlog[self.db.account.defaults.raidnum].bosskills) do
		if event.trash == 2 then return id end
	end
	return false
end

function MorgDKP:GetStartEvent()
	for id, event in pairs(self.db.account.raidlog[self.db.account.defaults.raidnum].bosskills) do
		if event.trash == 1 then return id end
	end
	return false
end
