local L = AceLibrary("AceLocale-2.2"):new("MorgDKP")
local BC = AceLibrary("Babble-Class-2.2")
local tablet = AceLibrary("Tablet-2.0")
local dewdrop = AceLibrary("Dewdrop-2.0")
local rosterlib = AceLibrary("Roster-2.1")
local roster = rosterlib.roster

MorgBid_Version = "3.6"
local qso
local MaxBid = { }
local AuctionStatus = { }

function MorgDKP:StartQuery(id, link)
	if not self:IsRaided() then return end
	self:Scan()
	local itempoints = self.db.account.items[id].points or 0
	self.origitempoints[id] = itempoints
	needquery = self:HasItem(id)
	if not self.queryneeded then DEFAULT_CHAT_FRAME:AddMessage(L["noquery"]) return end
	AuctionStatus[id] = 1
	local POOL = self:CheckPool(id)
	for qname in pairs(needquery) do
		self:PointsPoolExists(qname, POOL)
		local dkppoints = self:PointsFormat(qname, POOL)
		if self.db.account.defaults.random or self.random[id] then dkppoints = "NONE" end
		if self.db.account.defaults.bidwar then
			MaxBid[id] = 0
			BidWarDone = nil
			SendAddonMessage("MORGBID", "BIDWAR "..id.." "..itempoints.." "..qname.." "..self.db.account.info[qname][POOL].points .." "..self.db.account.defaults.bidstep.." "..self.db.account.defaults.overbid, "RAID")
		else SendAddonMessage("MORGBID", "QUERY "..id.." "..itempoints.." "..qname.." "..dkppoints, "RAID")
		end
		if self.db.account.defaults.whisper then
			SendChatMessage(string.format(L["morgbidwhisper"], link, id, itempoints), "WHISPER", nil, qname)
		end
	end
	DEFAULT_CHAT_FRAME:AddMessage(L["querysent"]..id.." "..itempoints)
	local t = { }
  	local points
	local mainstring = L["classmain"] .. ": "
	local altstring = L["classalt"] .. ": "
	local isaltstring = nil
	for mclass, value in pairs(self.db.account.items[id].classes) do
		if mclass ~= "All" and value then mainstring = mainstring .. mclass .. ", " end
	end
	for aclass, value in pairs(self.db.account.items[id].altclasses) do
		if aclass ~= "All" and value then
			altstring = altstring .. aclass .. ", "
			isaltstring = 1
		end
	end
	for qname in pairs(needquery) do
  		qclass = needquery[qname].class
		self:PointsPoolExists(qname, POOL)
		local points
		local priority = needquery[qname].priority
		if not self.db.account.defaults.bidwar then points = self:PointsFormat(qname, POOL) end
  		if self.db.account.defaults.bidwar or self.db.account.defaults.random or self.random[id] then points = 0 end
		table.insert(t, {qname, qclass, "PENDING", points, priority})
 	end
  	if self.db.account.defaults.bidwar then
		SendChatMessage(string.format(L["auctionbegin"], link, id), "RAID")
		SendChatMessage(L["bidformat"], "RAID")
	else
		SendChatMessage(string.format(L["rollingbegin"], link, id, itempoints), "RAID")
		 mainstring = string.sub(mainstring, 1, -3)
		SendChatMessage(mainstring, "RAID")
		if isaltstring then
			altstring = string.sub(altstring, 1, -3)
			SendChatMessage(altstring, "RAID")
		end
	end
  	self.querytooltips[id] = t
	local sName, _, _, _, _, _, _, _, _, _ = GetItemInfo(id)
	local item = "item"..id
	if self.db.account.defaults.bidwar then local hint = L["BidWarBar_Hint"]
	else local hint = L["Bar_Hint"] end
	qso = { PENDING = 2, NEED = 4, TAKE = 3, PASS = 1 }
	self:CreateQueryTooltip(id, item, sName, hint)
end

function MorgDKP:MorgBidQuery()
	--if not self:IsRaided() then return end
	SendAddonMessage("MORGBID", "CHECK", "RAID")
	self:Scan()
	local POOL = self.db.account.defaults.raid
	local t = { }
  	for name, data in pairs(roster) do
  		if data.class ~= "PET" then
  			local class = BC[data.class]
  			self:PointsPoolExists(name, POOL)
  			points = self:PointsFormat(name, self.db.account.defaults.raid)
  			table.insert(t, {name, class, "NONE", points})
  		end
  	end
  	local title = L["mvquery"]
	local item = "version"
	local hint = L["Bar_Hint_Version"]
	local id = nil
	self.querytooltips[item] = t
  	qso = { [3.7] = 1, [3.6] = 2, [3.5] = 3, [3.4] = 4,  [3.3] = 5, [3.2] = 6, [2.9] = 7, [2.8] = 8, [2.6] = 9, [2.5] = 10, ["NONE"] = 11}
  	self:CreateQueryTooltip(id, item, title, hint)
end

function MorgDKP:ItemHistory()
	if self.db.account.defaults.raidnum < 1 then return end
	local t = nil
	t = { }
 	for num, loot in pairs(self.db.account.raidlog[self.db.account.defaults.raidnum].loot) do
  		name = loot.Player
  		local class = "Unknown"
		if self.db.account.raidlog[self.db.account.defaults.raidnum].playerinfo[name] then class = self.db.account.raidlog[self.db.account.defaults.raidnum].playerinfo[name].class end
  		ItemLink = "|c"..loot.Color.."[|Hitem:"..loot.ItemID.."|h"..loot.ItemName.."|h]|r"
		points = loot.Costs
  		table.insert(t, {ItemLink, class, name, points})
  	end
  	if #t < 1 then DEFAULT_CHAT_FRAME:AddMessage("The item history is empty.") return end
	local zone = "UNKNOWN"
	if self.db.account.raidlog[self.db.account.defaults.raidnum].zone then zone = self.db.account.raidlog[self.db.account.defaults.raidnum].zone end
	local title = L["itemhistory"]..": "..zone
	local item = "history"
	local hint = L["rightclickclose"]
	local id = nil
	self.querytooltips[item] = t
  	self:CreateQueryTooltip(id, item, title, hint)
end

function MorgDKP:CreateQueryTooltip(id, item, title, hint)
	if not tablet:IsRegistered(item) then
		local x,y
		local xoffset = { 0, -240, -480, 240, 480}
		local numitems = 0
		if self.items then numitems = #self.items end
		if id then
			if numitems < 6 then x = xoffset[numitems]
			else x = 0 end
			y = 60
		elseif item == "waitlist" then x ,y = -500,50
		elseif item == "listdkp" then x,y = -240,100
		else x,y = 0,0 end
		tablet:Register(item,
			'detachedData', { offsetx = x, offsety= y  },
			'children', function()
						tablet:SetTitle(title)
						tablet:SetHint(hint)
						self:UpdateQueryTooltip(id, item)
					end,
			'clickable', true,
			'cantAttach', true,
			'showTitleWhenDetached', true,
		 	'showHintWhenDetached', true,
		 	'hideWhenEmpty', true,
		 	'strata', "HIGH",
    			'menu', function()
		 			dewdrop:Close()
		 			if id then
		 				self.querytooltips[id] = nil
		 				tablet:Attach("item"..id)
		 			else
		 				tablet:Attach(item)
		 				self.querytooltips[item] = nil
		 			end
				end
		)
	end
	if tablet:IsAttached(item) then tablet:Detach(item) end
end

function MorgDKP:UpdateQueryTooltip(id, item)
	local cat = tablet:AddCategory('columns', 3)
	if id then t = self.querytooltips[id]
	else t = self.querytooltips[item] end
	if item ~= "history" and item ~= "listdkp" and item ~= "waitlist" and item ~= "sync" then
    		table.sort(t, function(a,b)
    			local ao = qso[a[3]] or 0
    			local bo = qso[b[3]] or 0
    			if  ao == bo then
    				if a[5] == b[5] then
    					if a[4] == b[4] then
    						return a[2]>b[2]
    					else
    						return a[4]>b[4]
					end
				else
					return a[5]<b[5]
				end
			else
				return  ao>bo
			end
		end)
  	end
	for i,v in ipairs(t) do
  		if item == "history" then
  			r,g,b = 0,0,0
  			r2,g2,b2 = BC:GetColor(v[2])
  			r3,g3,b3 = 0,1,0
  		elseif item == "listdkp" then
  			if v[2] == 2 then r,g,b = 1,1,1
  			elseif v[2] == 1 then r,g,b = 0,1,0
  			else r,g,b = 1,0,0 end
  			r2,g2,b2 = BC:GetColor(v[3])
  		elseif item == "waitlist" then
  			if v[2] then
  				r,g,b = BC:GetColor(v[3])
  				r2,g2,b2 = r,g,b
  			else
  				r,g,b = 1,1,1
  				r2,g2,b2 = r,g,b
  			end
  			r3,g3,b3 = 0,1,0
  		elseif item == "sync" then
  			r,g,b = 1,1,1
  			if v[3] == "PW" then r2,g2,b2 = 0,1,0
  			else r2,g2,b2 = 1,0,0 end
  			if v[4] < self.version then r3,g3,b3 = 1,1,0
  			else  r3,g3,b3 = 0,1,0 end
  		else
  			r,g,b = BC:GetColor(v[2])
  			r3,g3,b3 = MorgDKP.db.account.info[v[1]].raidloot, MorgDKP.db.account.info[v[1]].raidloot and 1, 0
  			if (v[3] == "NONE") or (v[3] == "PENDING") then r2,g2,b2 = 1,1,0
  			elseif (v[3] == "PASS") then r2,g2,b2 = 1,0,0
  			else r2,g2,b2 = 0,1,0 end
  		end
    		local colortog = 0
    		if (v[3] == "NONE") or (v[3] == "PASS") or (v[3] == "PENDING") then colortog = 1 end
    		cat:AddLine(
    			'text', v[1],
    			'textR', r,
    			'textG', g,
    			'textB', b,
    			'text2', string.format("%s",v[3]),
    			'text2R', r2,
    			'text2G', g2,
    			'text2B', b2,
    			'text3', v[4],
    			'text3R', r3,
    			'text3G', g3,
    			'text3B', b3,
    			'func', function() self:ShowResults(id, item, v[1])  end,
    			'onEnterFunc', function()
    						GameTooltip:SetOwner(this, "ANCHOR_LEFT")
    						self:ShowTooltip(id, item, v[1])
    					end,
    			'onLeaveFunc', function() GameTooltip:Hide() end
    		)
	end
end

function MorgDKP:ShowResults(id, item, historyitem)
	if id and self.db.account.defaults.bidwar then
		SendChatMessage(L["endbidding"], "RAID")
		SendAddonMessage("MORGBID","CLOSE "..id, "RAID")
		AuctionStatus[id] = nil
	end
	if id then self:OutputResults(id, item, historyitem) end
	if item == "version" then
		for num , data in ipairs(self.querytooltips[item]) do
			if data[3] == "NONE" or (tonumber(data[3]) or 1) < tonumber(MorgBid_Version) then SendChatMessage(L["updatemorgbid"], "WHISPER", nil, data[1]) end
		end
	elseif item == "listdkp" then
		if IsShiftKeyDown() then
			SendChatMessage(L["dkpstand"]..self.db.account.defaults.raid..":", "RAID")
			local spaces = "                                                                                                                                    "
			local numspace = {10, 7, 5, 2, 1}
			for num, v in ipairs(self.querytooltips[item]) do
				local message = string.upper(v[1])
				message = message ..string.sub(spaces,1,(45 - self:CalcSpaces(string.upper(v[1]))))..string.upper(v[3])
				message = message ..string.sub(spaces,1,(self:CalcSpaces(string.upper(v[3]))))..string.sub(spaces,1,numspace[string.len(v[4])])..v[4].."   DKP"
				SendChatMessage(message, "RAID")
			end
		elseif IsControlKeyDown() then
			self.db.account.info[historyitem] = nil
			for num, v in ipairs(self.querytooltips[item]) do
				if v[1] == historyitem then
					table.remove(self.querytooltips[item], num)
					break
				end
			end
			DEFAULT_CHAT_FRAME:AddMessage(string.format(L["deletechar"], historyitem))
			tablet:Refresh("listdkp")
		elseif IsAltKeyDown() then
			self:AddWait(historyitem)
		else
			InviteUnit(historyitem)
		end
	elseif item == "waitlist" then
		if IsControlKeyDown() then
			self:SubWait(historyitem)
		else
			local Onlinemembers = self:GetOnlineGuildMembers()
			if not Onlinemembers[historyitem] then self:InformOnlineAlias(historyitem, Onlinemembers)
			else InviteUnit(historyitem) end
		end
	elseif item == "sync" then
		if IsShiftKeyDown() then
			self:SyncDB("all")
		else self:SyncDB(historyitem)
		end
	elseif item == "history" then
		local _,_, ItemID = string.find(historyitem, "item:(%d+):")
		ItemID = tonumber(ItemID)
		self:ManualItem(ItemID, historyitem)
  	end
end

function MorgDKP:OnAddonMsg(prefix, message, type, sender)
	if not UnitInRaid("player") then return end
	if prefix == "MORGBID" then
		local args = {self:Explode(message, " ")}
		if args[1] == "PASS" or args[1] == "TAKE" or args[1] == "NEED" then
			local item = tonumber(args[2])
			if self.db.account.defaults.devmode then self:Print("From "..sender..": "..args[1]) end
			if not self.querytooltips[item] then
				if self.db.account.defaults.devmode then self:Print("No query for "..args[2]) end
				return
			end
			for i,v in ipairs(self.querytooltips[item]) do
				if v[1] == sender then
					v[3] = args[1]
					if self.db.account.defaults.bidwar and args[1] ~= "PASS" then
						local bid = tonumber(args[3])
						local overbid = self.db.account.info[sender][self.db.account.items[item].pool].points +  self.db.account.defaults.overbid
						if bid > overbid then
							bid = overbid
							SendChatMessage(string.format(L["exceedoverbid"], self.db.account.defaults.overbid), "WHISPER", nil, sender)
						end
						v[4] = bid
						if bid > MaxBid[item] and AuctionStatus[item] then
							MaxBid[item] = bid
							self:BidWarQueryNeeded(item, sender)
						elseif bid == MaxBid[item] and AuctionStatus[item] then
							self:BidWarQueryNeeded(item, " ")
						end
					end
					if (self.db.account.defaults.random or self.random[item]) and args[1] ~= "PASS" then v[4] = math.random(100) end
					break
				end
			end
			tablet:Refresh("item"..item)
		elseif args[1] == "REPLY" then
			if not self.querytooltips["version"] then
				if self.db.account.defaults.devmode then self:Print("No version query.") end
				return
			end
			for i,v in ipairs(self.querytooltips["version"]) do
				if v[1] == sender then v[3] = args[3] break end
			end
			tablet:Refresh("version")
		end
	end
end

function MorgDKP:OnCommReceive(prefix, sender, distribution, version, password, command, morgdkpdata, items, dkpinfo)
	if tonumber(version) < self.commVersion then return end
	if command == "REQUESTSYNC" then
		self:SendCommMessage(distribution, self.commVersion, self.db.account.defaults.dbpassword,  "SYNCINFO", self.version, #self.db.account.items)
		DEFAULT_CHAT_FRAME:AddMessage(string.format(L["syncrequest"], sender))
	elseif command == "SYNCINFO" then
		if not self.requestsync then return end
		local pass = "PW"
		local needtab = nil
		if password ~= self.db.account.defaults.dbpassword then pass = "Bad PW!" end
		if not self.querytooltips["sync"] then
			self.querytooltips['sync'] = { }
			needtab = true
		end
		local match = nil
		for _, data in pairs(self.querytooltips["sync"]) do
			if data[1] == sender then match = true break end
		end
		if not match then
			table.insert(self.querytooltips['sync'], {sender, items, pass, morgdkpdata})
		end
		if needtab then
			local title = L["syncquery"]
			local item = "sync"
			local hint = L["Bar_Hint_Sync"]
			local id = nil
			self:CreateQueryTooltip(id, item, title, hint)
		end
		tablet:Refresh("sync")
	elseif command == "SYNCREQUESTDATA" then
		if morgdkpdata ~= UnitName("player") then return end
		local temp = { }
		for name, data in pairs(self.db.account.info) do
			temp[name] = { }
			for item, itemdata in pairs(data) do
				if item ~= "items" and  item ~= "raidloot" then
					if item == "aliases" then
						if #itemdata > 0 then temp[name][item] = itemdata end
					else temp[name][item] = itemdata end
				end
			end
		end
		local defaults = self.db.account.defaults
		self:SendCommMessage(distribution, self.commVersion, self.db.account.defaults.dbpassword, "SYNCDATA", defaults, self.db.account.items, temp)
		DEFAULT_CHAT_FRAME:AddMessage(string.format(L["sentsync"], sender))
	elseif command == "SYNCDATA" then
		if not self.requestsync then return end
		self.syncitems = items
		self.syncdkp = dkpinfo
		self.defaults = morgdkpdata
		StaticPopup_Show ("MorgAcceptSYNC", sender)
	elseif command == "REQUESTLEAD" then
		if morgdkpdata == UnitName("player") or self.repliedleader then return end
		StaticPopup_Show ("MorgAcceptLeader", morgdkpdata)
	end
end

function MorgDKP:SyncDB(name)
	local distro = "GUILD"
	if UnitInRaid("player") then distro = "GROUP" end
	if name == "all" then
		for num, v in ipairs(self.querytooltips["sync"]) do
			if v[3] == "PW" then
				self:SendCommMessage(distro, self.commVersion, self.db.account.defaults.dbpassword, "SYNCREQUESTDATA", v[1])
				DEFAULT_CHAT_FRAME:AddMessage(string.format(L["syncwait"], v[1]))
			end
		end
	else
		for num, v in ipairs(self.querytooltips["sync"]) do
			if v[1] == name and v[3] == "PW" then
				self:SendCommMessage(distro, self.commVersion, self.db.account.defaults.dbpassword, "SYNCREQUESTDATA", name)
				DEFAULT_CHAT_FRAME:AddMessage(string.format(L["syncwait"], name))
				break
			end
		end
	end
end

function MorgDKP:AcceptSyncData()
	if self.defaults.eqDKP then self.db.account.defaults.eqDKP = self.defaults.eqDKP end
	self.db.account.defaults.raid = self.defaults.raid
	self.db.account.defaults.raidlist = self.defaults.raidlist
	local itemcount = self:ImportItemDB(self.syncitems)
	local membercount = 0
	if not self.db.account.info then self.db.account.info = { } end
	for name, data in pairs(self.syncdkp) do
		if not self.db.account.info[name] then
			self.db.account.info[name] = data
			membercount = membercount + 1
			if self.db.account.info[name].aliases then self:IsNewAlias(name) end
		else
			if self:TimeDiff(self.db.account.info[name].lastupdate, data.lastupdate) > 0 then
				for item, itemdata in pairs(data) do
					if item == "aliases" then
						if #self.db.account.info[name]["aliases"] > 0 then
							for newnum, newaliasdata in pairs(itemdata) do
								local match = nil
								for accountnum, aliasdata in pairs(self.db.account.info[name]["aliases"]) do
									if aliasdata.alt == newaliasdata.alt and aliasdata.raid == newaliasdata.raid then
										match = true
										break
									end
								end
								if not match then
									table.insert(self.db.account.info[name]["aliases"], newaliasdata)
									table.insert(self.db.account.defaults.eqDKP[self.db.account.defaults.raid].Aliases, {alt = newaliasdata.alt, main = name})
								end
							end
						else
							self.db.account.info[name][item] = itemdata
						end
					else self.db.account.info[name][item] = itemdata
					end
				end
				membercount = membercount + 1
			end
		end
	end
	self.syncdkp = nil
	self.syncitems = nil
	self.defaults = nil
	self.requestsync = nil
	self:ClearRaidDB()
	DEFAULT_CHAT_FRAME:AddMessage(string.format(L["syncdone"], itemcount, membercount))
end

function MorgDKP:IsNewAlias(name)
	if #self.db.account.info[name]["aliases"] > 0 then
		for _, newaliasdata in pairs(self.db.account.info[name]["aliases"]) do
			local match = nil
			for _, aliasdata in pairs(self.db.account.defaults.eqDKP[self.db.account.defaults.raid].Aliases) do
				if aliasdata.alt == newaliasdata.alt then
					match = true
					break
				end
			end
			if not match then
				table.insert(self.db.account.defaults.eqDKP[self.db.account.defaults.raid].Aliases, {alt = newaliasdata.alt, main = name})
			end
		end
	end
end

function MorgDKP:DenySyncData()
	self.syncitems = nil
	self.syncdkp = nil
	self.requestsync = nil
end

function MorgDKP:SyncItemDB()
	local distro = "GUILD"
	if UnitInRaid("player") then distro = "GROUP" end
	self.requestsync = true
	self:SendCommMessage(distro, self.commVersion, self.db.account.defaults.dbpassword, "REQUESTSYNC")
	DEFAULT_CHAT_FRAME:AddMessage(string.format(L["syncstart"], distro))
end

function MorgDKP:RequestLeader()
	if not UnitInRaid("player") or not self.db.account.defaults.leadbroadcast then return end
	self:SendCommMessage("GROUP", self.commVersion, self.db.account.defaults.dbpassword, "REQUESTLEAD", UnitName("player"))
end

function MorgDKP:AcceptLeader()
	 self.db.account.defaults.restoreautozone = self.db.account.defaults.autozone
   	self.db.account.defaults.autozone = nil
   	if self.db.account.defaults.InRaid then self:EndRaid() end
   	MorgDKPFu:DisableMorgDKP()
	self.repliedleader = true
end

function MorgDKP:DenyLeader()
	self.repliedleader = true
end

function MorgDKP:OutputResults(dkpitem, tabletname, clickedname)
	Lootitem, ItemLink, iQuality, _, _, _, _, _, _, _ = GetItemInfo(dkpitem)
	local itempoints = self.db.account.items[dkpitem].points
	SendAddonMessage("MORGBID","CLOSE "..dkpitem, "RAID")
	AuctionStatus[dkpitem] = nil
	local spaces = "                                                                                                                                      "
	local numspace = {9, 7, 5, 3, 1}
	Lootwinner = nil
	if self.db.account.defaults.bidwar then
		if self.db.account.defaults.justenough and #self.querytooltips[dkpitem] > 1 then
			if self.querytooltips[dkpitem][2][4] > 0 then
				itempoints = self.querytooltips[dkpitem][2][4]
				self.querytooltips[dkpitem][1][4] = itempoints
			end
		else  itempoints = self.querytooltips[dkpitem][1][4]
		end
		self.db.account.items[dkpitem].points = itempoints
	end
	if ItemLink and itempoints then
		if self.db.account.defaults.random or self.random[dkpitem] then SendChatMessage(L["doresult"]..ItemLink, "RAID")
		else SendChatMessage(L["doresult"]..ItemLink.."   DKP= "..itempoints, "RAID") end
	end
	for i,v in ipairs(self.querytooltips[dkpitem]) do
		if i == 1 then
			if v[3] ~= "PASS" then Lootwinner = string.upper(string.sub(v[1],1,1))..string.sub(v[1],2,-1)  end
		end
		local message =  string.upper(v[1])
		message = message ..string.sub(spaces,1,(40 - self:CalcSpaces(string.upper(v[1]))))..string.upper(v[2])
		message = message ..string.sub(spaces,1,(self:CalcSpaces(string.upper(v[2]))))..string.upper(v[3])
		message = message ..string.sub(spaces,1,(self:CalcSpaces(string.upper(v[3]))))..string.sub(spaces,1,numspace[string.len(v[4])])..v[4]
		SendChatMessage(message , "RAID")
		if i == 10 then break end
		if self.db.account.defaults.silent and self.db.account.defaults.bidwar and i == 1 then break end
	end
	self.given = true
	if not Lootwinner then
		Lootwinner = self.db.account.defaults.disenchanter
		self.given = nil
	elseif Lootwinner ~= clickedname then Lootwinner = clickedname
	end
	if (GetNumLootItems()>0) and Lootitem and Lootwinner then
		StaticPopup_Show ("MorgLoot", ItemLink, Lootwinner)
  	end
end

function MorgDKP:HasItem(id)
	if not self.db.account.items[id] then return end
	local classes = self.db.account.items[id].classes
	local altclasses = self.db.account.items[id].altclasses
	local _, _, _, _, _, _, _, _, iEquipLoc, _ = GetItemInfo(id)
	needquery = { }
	self.queryneeded = nil
	for pname, data in pairs(roster) do
		if data.class ~= "PET" then
			local playerClass = BC[string.upper(string.sub(data.class,1,1))..string.lower(string.sub(data.class,2,-1))]
			local realClass = BC[data.class]
			hasitem = nil
			if classes[playerClass] or altclasses[playerClass] then
				if self.db.account.info[pname] then
					if self.db.account.info[pname].items then
						local items = self.db.account.info[pname].items
						if items then
							for _,ID in pairs(items) do
								id = tonumber(id)
								if ID == id and (id ~= 19147 or id ~= 19140 or id ~= 17071) then
									hasitem = 1
								end
							end
						end
					end
				end
				if not hasitem then
					needquery[pname] = { }
					needquery[pname].class = realClass
					if classes[playerClass] then needquery[pname].priority = 1
					else  needquery[pname].priority = 2 end
					self.queryneeded = 1
				end
			end
		end
	end
	return needquery
end

function MorgDKP:CalcSpaces(word)
	local Letters = {["A"] = 2, ["B"] = 1.5, ["C"] = 1.8, ["D"] = 2, ["E"] = 1.5, ["F"] = 1.5, ["G"] = 2, ["H"] = 2, ["I"] =.9, ["J"] = 1, ["K"] = 1.8, ["L"] = 1.5, ["M"] = 2.3, ["N"] = 2.2, ["O"] = 2.3, ["P"] = 1.5, ["Q"] = 2.3, ["R"] = 1.8, ["S"] = 1.5, ["T"] = 1.8, ["U"] = 2, ["V"] = 1.7, ["W"] = 2.2, ["X"] = 1.7, ["Y"] = 1.7, ["Z"] = 1.7}
	if L["classcount"][word] then return L["classcount"][word] end
	local l = string.len(word)
	local count = 0
	for i = 1, l do
		let = string.sub(word,i,i)
		val = Letters[let] or 0
		count = count + val
	end
	return count
end

function MorgDKP:OnWaitWhisper(sender, action, member)
	action = string.upper(action)
	if member and string.upper(sender) == string.upper(member) then member = nil end
	local POOL = self.db.account.defaults.raid
	local main = self:CheckforAlias(sender, POOL)
	if action == "WAIT" or action == "WAIT+" then
		if member then
			main = string.upper(string.sub(member,1,1))..string.lower(string.sub(member,2,-1))
			self:AddTwink(sender .. " " .. main)
		end
		self:AddWait(main)
		SendChatMessage(L["waitadd"], "WHISPER", nil, sender)
	elseif action == "WAIT-" then
		self:SubWait(main)
		SendChatMessage(L["waitsub"], "WHISPER", nil, sender)
	end
end

function MorgDKP:OnBidWhisper(txt, sender)
	local args = {self:Explode(txt, " ")}
	if string.upper(args[1])  ~= "MBID" then return end
	if string.find(string.upper(args[2]), "WAIT") then self:OnWaitWhisper(sender, args[2], args[3])  return end
	if #args < 3 then SendChatMessage(L["invalidformat"], "WHISPER", nil, sender) return end
	local item = tonumber(args[2])
	if not AuctionStatus[item] then
		SendChatMessage(L["noauction"], "WHISPER", nil, sender)
		return
	end
	if not self.querytooltips[item] then
		SendChatMessage(L["invalidformat"], "WHISPER", nil, sender)
		return
	end
	args[3] = string.upper(args[3])
	if args[3] == "PASS" or args[3] == "TAKE" or args[3] == "NEED" then
		for i,v in ipairs(self.querytooltips[item]) do
			if v[1] == sender then
				v[3] = args[3]
				SendChatMessage(string.format(L["bidaccepted"], v[3]), "WHISPER", nil, sender)
				if (self.db.account.defaults.random or self.random[item]) and args[3] ~= "PASS" then v[4] = math.random(100) end
			end
		end
	else
		if self.db.account.defaults.bidwar then
			local bid = tonumber(args[3])
			if bid and bid > 0 then
				for i,v in ipairs(self.querytooltips[item]) do
					if v[1] == sender then
						if self.db.account.defaults.silent and tonumber(v[4]) ~= 0 then
							SendChatMessage(L["alreadybid"], "WHISPER", nil, sender)
							return
						end
						v[3] = "TAKE"
						local overbid = self.db.account.info[sender][self.db.account.items[item].pool].points +  self.db.account.defaults.overbid
						if bid > overbid then
							bid = overbid
							SendChatMessage(string.format(L["exceedoverbid"], self.db.account.defaults.overbid), "WHISPER", nil, sender)
						end
						v[4] = bid
						if bid > MaxBid[item] then
							MaxBid[item] = bid
							SendChatMessage(string.format(L["bidaccepted"], bid), "WHISPER", nil, sender)
							self:BidWarQueryNeeded(item, sender)
						elseif bid == MaxBid[item] then
							SendChatMessage(string.format(L["bidaccepted"], bid), "WHISPER", nil, sender)
							self:BidWarQueryNeeded(item, " ")
						end
					end
				end
			end
		end
	end
	tablet:Refresh("item"..item)
end

function MorgDKP:BidWarQueryNeeded(id, bidder)
	self.db.account.items[id].points = MaxBid[id]
	local POOL = self.db.account.items[id].pool
	if self.db.account.defaults.silent then return end
	local _, Link, _, _, _, _, _, _,_, _ = GetItemInfo(id)
	SendChatMessage(string.format(L["highbidder"], Link, bidder, MaxBid[id]), "RAID")
	for i,v in ipairs(self.querytooltips[id]) do
		if v[3] == "TAKE" and v[1] ~= bidder then
			v[3] = "PENDING"
			SendAddonMessage("MORGBID", "BIDWAR "..id.." "..MaxBid[id].." "..v[1].." "..self.db.account.info[v[1]][POOL].points.." "..self.db.account.defaults.bidstep.." "..self.db.account.defaults.overbid, "RAID")
		end
	end
	tablet:Refresh("item"..id)
end

function MorgDKP:ShowTooltip(itemid, tooltiptype, itemlink)
	if tooltiptype == "history" then
		GameTooltip:SetHyperlink(itemlink)
		GameTooltip:Show()
	elseif itemid ~= nil then
		if self.db.account.info[itemlink].raidloot == 0 then return end
		GameTooltip:AddLine(itemlink.."'s Loot:", 0, 0, 1)
		GameTooltip:AddLine("\n", 0, 0, 1)
		for num, loot in pairs(self.db.account.raidlog[self.db.account.defaults.raidnum].loot) do
  			local name = loot.Player
  			if name == itemlink then
  				GameTooltip:AddLine(loot.ItemLink)
  			end
  		end
  		GameTooltip:Show()
  	end
end

function MorgDKP:ShowWaitlist()
	if #self.db.account.defaults.Waitlist.members == 0 then return end
	local waitlist = { }
	local POOL = self.db.account.defaults.raid
	local class
	for index, name in pairs(self.db.account.defaults.Waitlist.members) do
		class = nil
		if self.db.account.info[name].class then class = self.db.account.info[name].class end
		table.insert(waitlist, {name, class, class or "Unknown", (self.db.account.info[name][POOL].points or 0)})
	end
	local item = "waitlist"
	local title = L["waitlist"]
	local hint = L["Bar_Hint_Waitlist"]
	local id = nil
	self.querytooltips[item] = waitlist
	self:CreateQueryTooltip(id, item, title, hint)
end

function MorgDKP:AddWait(addname)
	if UnitInRaid(addname) then return end
	local wait = nil
	local POOL = self.db.account.defaults.raid
	local class = nil
	local ttime = date("%m/%d/%y %H:%M:%S")
	if not self.db.account.defaults.Waitlist then self.db.account.defaults.Waitlist = {members = {}, join = {} } end
	for num, name in pairs(self.db.account.defaults.Waitlist.members) do
		if name == addname then wait = true break end
	end
	if not wait then
		table.insert(self.db.account.defaults.Waitlist.members, addname)
		self.db.account.defaults.Waitlist.join[addname] = ttime
		DEFAULT_CHAT_FRAME:AddMessage(L["add"] .. addname .. L["to"] .. L["waitlist"])
		self:PlayerinDB(addname)
		if self.db.account.defaults.InRaid then self:AddIndividualWait(addname) end
		if self.querytooltips["waitlist"]  then
			if self.db.account.info[addname].class then class = self.db.account.info[addname].class end
			table.insert(self.querytooltips["waitlist"], {addname, class, class or "Unknown", (self.db.account.info[addname][POOL].points or 0)})
			tablet:Refresh("waitlist")
		end
	end
end

function MorgDKP:SubWait(subname)
	for num,name in pairs(self.db.account.defaults.Waitlist.members) do
		if name == subname then
			table.remove(self.db.account.defaults.Waitlist.members, num)
			self.db.account.defaults.Waitlist.join[subname] = nil
			break
		end
	end
	DEFAULT_CHAT_FRAME:AddMessage(L["removed"] .. subname)
	if self.querytooltips["waitlist"]  then
		for num, v in pairs(self.querytooltips["waitlist"]) do
			if v[1] == subname then
				table.remove(self.querytooltips["waitlist"], num)
				break
			end
		end
		tablet:Refresh("waitlist")
	end
end

function MorgDKP:InformOnlineAlias(main, Onlinemembers)
	local pool = self.db.account.defaults.raid
	for _, data in pairs(self.db.account.defaults.eqDKP[pool].Aliases) do
		if data.main == main then
			if Onlinemembers[data.alt] then SendChatMessage(L["waitmain"], "WHISPER", nil, data.alt) break end
		end
	end
end
