local options = { 
    type='group',
    args = {
	    config = {
			type='group',
			name='Config Group',
			desc='Config stuff',
			args = {
				amount = {
					type = 'text',
					name = 'targetGold',
					desc = 'Sets the target amount of gold to reach. (in gold!)',
					usage = '<amount>',
					get = "GetAmount",
					set = "SetAmount"
					},
				showInChat = {
					type = 'toggle',
					name = 'Show in Chat',
					desc = 'If set, your message will be displayed in the General chat window.',
					get = "IsShowInChat",
					set = "ToggleShowInChat"
				},
				showOnScreen = {
					type = 'toggle',
					name = 'Show on Screen',
					desc = 'If set, your message will be displayed on the screen near the top of the game field.',
					get = "IsShowOnScreen",
					set = "ToggleShowOnScreen"
				},
				w = {
					type='text',
					name='Bar width',
					desc='Width of the bar and frame.',
					usage='<pixels>',
					get="GetMyWidth",
					set="SetMyWidth"
				},
				h = {
					type='text',
					name='Bar height',
					desc='Height of the bar and frame.',
					usage='<pixels>',
					get="GetMyHeight",
					set="SetMyHeight"
				},
				layout = {
					type='text',
					name='Layout style',
					desc='Choose a layout number (1-2).',
					usage='<nr>',
					get="GetMyLayout",
					set="SetMyLayout"
				},
				showPercent = {
					type = 'toggle',
					name = 'Show the percentage',
					desc = 'You can toggle showing the percentage text.',
					get = "IsPercentageShown",
					set = "TogglePercentageShown"
				},
				barColor = {
					type='text',
					name='Bar color',
					desc='Type a litteral name of one of these colors (cyan or yellow for example)',
					usage='<colorname>',
					get="GetBarColor",
					set="SetBarColor"
				}
			}
		},
		show = {
			type='execute',
			name='Show Frame',
			desc='Show the frame with your progress',
			func="ToggleFrame"
		},
		print = {
			type='execute',
			name='Print amount',
			desc='Print the progress to the target amount',
			func="ShowAmount"
		},
		lock = {
			type='toggle',
			name='Lock frame',
			desc='Locks the frame in its current place',
			get="IsLocked",
			set="ToggleLocked"
		}
    }
}

local perc, b, f, fs = nil

MoneyProgress = AceLibrary("AceAddon-2.0"):new("AceConsole-2.0", "AceEvent-2.0", "AceDB-2.0")
MoneyProgress:RegisterChatCommand("/moneyprogress", "/mp", options)

MoneyProgress:RegisterDB("MoneyProgressDB", "MoneyProgressDBPC")
MoneyProgress:RegisterDefaults("profile", {
    showInChat = false,
    showOnScreen = false,
	frameShown = true,
	percentageShown = true,
    lock = false,
	layout = "1",
    w = 80,
    h = 35,
    amount = 9000000,
	xpos = 200,
    ypos = 200,
	barColor = "yellow"
} )

function MoneyProgress:ShowFrame()
	-- Basic Frame
	f=CreateFrame("FRAME","testaddon_Frame",UIParent);
	f:SetBackdrop({
	  bgFile="Interface\\Tooltips\\UI-Tooltip-Background", 
	  edgeFile="Interface\\Tooltips\\UI-Tooltip-Border", 
	  tile=1, tileSize=10, edgeSize=10, 
	  insets={left=3, right=3, top=3, bottom=3}
	});
	f:SetBackdropColor(0.4,0.4,0.5,0.7)
	f:EnableMouse(not self.db.profile.lock)
	f:SetMovable(not self.db.profile.lock)
	f:RegisterForDrag("LeftButton")
	f:SetScript("OnDragStart", function() f:StartMoving() end)
   	f:SetScript("OnDragStop", function() f:StopMovingOrSizing() MoneyProgress:SavePos(f) end)
	f:SetClampedToScreen( true )

	
	
	
	-- ProgressBar
	b=CreateFrame("STATUSBAR","$parentHealthBar",f,"TextStatusBar")
	b:EnableMouse(false)
	b:SetStatusBarTexture("Interface\\TargetingFrame\\UI-StatusBar")
	b:SetMinMaxValues(0,self.db.profile.amount)
	b:SetValue(GetMoney())
	
	-- Text Label
	ff=CreateFrame("FRAME","text_Frame",f);
	fs = ff:CreateFontString("$parentText","ARTWORK","GameFontNormal")
	
	
	MoneyProgress:SetBarColor(self.db.profile.barColor)
	
 	MoneyProgress:LayoutNr(self.db.profile.layout)
end

function MoneyProgress:LayoutNr(nr)
	if nr=="1" then
		MoneyProgress:DisplayHorizontal()
	elseif nr=="2" then
		MoneyProgress:DisplayVertical()
	end
	MoneyProgress:LayoutPercentText()
end

function MoneyProgress:LayoutPercentText()
	if self.db.profile.percentageShown then
		fs:Show()
	else
		fs:Hide()
	end
end

function MoneyProgress:DisplayHorizontal()
	-- Frame
	f:SetWidth(self.db.profile.w + 10)
	f:SetHeight(self.db.profile.h)
	f:ClearAllPoints()
	f:SetPoint("BOTTOMLEFT",UIParent,"BOTTOMLEFT",self.db.profile.xpos,self.db.profile.ypos)
	
	-- Progressbar
	b:SetOrientation("HORIZONTAL")
	b:SetWidth(self.db.profile.w)
	b:SetHeight(10)
	b:ClearAllPoints()
	b:SetPoint("BOTTOM",f,"BOTTOM",0,5)
	
	-- Text Label
	fs:ClearAllPoints()
	fs:SetPoint("TOP",f,"TOP",0,-3)
	fs:SetText(MoneyProgress:GetProgress().."%")

end

function MoneyProgress:DisplayVertical()
	-- Frame
	f:SetWidth(self.db.profile.w); 
	f:SetHeight(self.db.profile.h +10)
	f:ClearAllPoints()
	f:SetPoint("BOTTOMLEFT",UIParent,"BOTTOMLEFT",self.db.profile.xpos,self.db.profile.ypos)
	
	-- Progressbar
	b:SetOrientation("VERTICAL")
	b:SetWidth(15); 
	b:SetHeight(self.db.profile.h);
	b:ClearAllPoints()
	b:SetPoint("RIGHT",f,"RIGHT",-5,0)
	
	-- Text Label
	fs:ClearAllPoints()
	fs:SetPoint("LEFT",f,"LEFT",5,0)
	fs:SetText(MoneyProgress:GetProgress().."%")
end

function MoneyProgress:SavePos(frame)
	self.db.profile.xpos=frame:GetLeft()
	self.db.profile.ypos=frame:GetBottom()
end

function MoneyProgress:OnEnable()
    -- Called when the addon is enabled
    self:RegisterEvent("PLAYER_MONEY")
    -- Load frame
    MoneyProgress:ToggleFrame()
end

function MoneyProgress:PLAYER_MONEY()
    b:SetValue(GetMoney())
    fs:SetText(MoneyProgress:GetProgress().."%")
end

function MoneyProgress:GetProgress()
	local resultaat = ""
	resultaat  = (GetMoney() / self.db.profile.amount)
	resultaat  = resultaat  * 100
	shift = 10 ^ 2
        resultaat = floor( resultaat *shift + 0.5 ) / shift
	return resultaat
end

function MoneyProgress:ShowAmount()
	local tempval = GetMoney()
      if self.db.profile.showInChat then
          self:Print("You are "..MoneyProgress:GetProgress().."% on your way to richess!")
      end
      if self.db.profile.showOnScreen then
          UIErrorsFrame:AddMessage("You are "..MoneyProgress:GetProgress().."% on your way to richess!", 1.0, 1.0, 1.0, 5.0)
      end
end

function MoneyProgress:ToggleFrame()
	if f==nil then 
		if not self.db.profile.frameShown then
			MoneyProgress:ShowFrame()
			f:Hide()
		else
			MoneyProgress:ShowFrame()
		end
	else
		if self.db.profile.frameShown then
			f:Hide()
		else
			f:Show()
		end
		self.db.profile.frameShown = not self.db.profile.frameShown	
	end
end

function MoneyProgress:GetAmount()
    return self.db.profile.amount
end

function MoneyProgress:SetAmount(newValue)
    self.db.profile.amount = 10000 * newValue
    fs:SetText(MoneyProgress:GetProgress().."%")
    b:SetMinMaxValues(0,self.db.profile.amount)
end

function MoneyProgress:IsShowInChat()
    return self.db.profile.showInChat
end

function MoneyProgress:ToggleShowInChat()
    self.db.profile.showInChat = not self.db.profile.showInChat
end

function MoneyProgress:IsShowOnScreen()
    return self.db.profile.showOnScreen
end

function MoneyProgress:ToggleShowOnScreen()
    self.db.profile.showOnScreen = not self.db.profile.showOnScreen
end
function MoneyProgress:IsPercentageShown()
	return self.db.profile.percentageShown
end

function MoneyProgress:TogglePercentageShown()
	self.db.profile.percentageShown = not self.db.profile.percentageShown
	if self.db.profile.percentageShown then
		fs:Show()
	else
		fs:Hide()
	end
end
function MoneyProgress:IsLocked()
	return self.db.profile.lock
end

function MoneyProgress:ToggleLocked()
	if self.db.profile.lock then
		f:SetMovable(true)
		f:EnableMouse(true)
	else
		f:SetMovable(false)
		f:EnableMouse(false)
	end
	self.db.profile.lock = not self.db.profile.lock
end

function MoneyProgress:GetMyWidth()
	return self.db.profile.w
end

function MoneyProgress:SetMyWidth(newValue)
	self.db.profile.w = newValue
	MoneyProgress:LayoutNr(self.db.profile.layout)
end

function MoneyProgress:GetMyHeight()
	return self.db.profile.h
end

function MoneyProgress:SetMyHeight(newValue)
	self.db.profile.h = newValue
	MoneyProgress:LayoutNr(self.db.profile.layout)
end

function MoneyProgress:SetMyLayout(newValue)
	self.db.profile.layout = newValue
	MoneyProgress:LayoutNr(newValue)
end

function MoneyProgress:GetMyLayout()
	return self.db.profile.layout
end

function MoneyProgress:GetBarColor()
	return self.db.profile.barColor
end

function MoneyProgress:SetBarColor(newValue)
	local rc,gc,bc
	if newValue=="blue" then
		rc=0;gc=0;bc=255;
	elseif newValue=="green" then
		rc=0;gc=255;bc=0;
	elseif newValue=="red" then
		rc=255;gc=0;bc=0;
	elseif newValue=="yellow" then
		rc=255;gc=255;bc=0;
	elseif newValue=="cyan" then
		rc=0;gc=255;bc=255;
	elseif newValue=="magenta" then
		rc=255;gc=0;bc=255;
	elseif newValue=="orange" then
		rc=255;gc=128;bc=0;
	elseif newValue=="white" then
		rc=255;gc=255;bc=255;
	elseif newValue=="black" then
		rc=0;gc=0;bc=0;
	else
		rc=255;gc=255;bc=0;
	end
	
	b:SetStatusBarColor(rc,gc,bc,0.8)
	self.db.profile.barColor = newValue
end
