MGV_Fubar = AceLibrary("AceAddon-2.0"):new("AceEvent-2.0", "AceConsole-2.0", "FuBarPlugin-2.0")
local MGV = MobileVault

local L = AceLibrary("AceLocale-2.2"):new("MobileVault")


MGV_Fubar.hasIcon = true
MGV_Fubar:SetIcon("Interface\\Addons\\MobileVault\\icon")
MGV_Fubar.hasNoColor = true
MGV_Fubar.cannotDetachTooltip = true
MGV_Fubar.blizzardTooltip = true
MGV_Fubar.hideWithoutStandby = true
MGV_Fubar.independentProfile = true
MGV_Fubar.clickableTooltip = false

function MGV_Fubar:OnInitialize()
	self.db = MGV:AcquireDBNamespace("fubar")
	
	MGV.options.args.fubarblank = {
		order = 8,
		type = 'header',
	}
	MGV.options.args.fubar = {
		order = 9,
		type = 'group',
		name = L["FuBar Options"],
		desc = L["Display options for the FuBar plugin."],
		args = {},
	}
	
	AceLibrary("AceConsole-2.0"):InjectAceOptionsTable(self, MGV.options.args.fubar)
	self.OnMenuRequest = MGV.options
	self:UpdateText()
end

function MGV_Fubar:OnClick()
	MGV:ToggleFrame()
end

function MGV_Fubar:OnTooltipUpdate()
	GameTooltip:AddLine("|cffffff00"..L["Click|r to toggle the MobileVault Frame"])
end

function MGV_Fubar:OnTextUpdate()
   self:SetText("MGV")
 end
 