local L = AceLibrary("AceLocale-2.2"):new("MobileVault")
local DD = AceLibrary("Dewdrop-2.0")
local vaultopts = {}

function MobileVault:Dummy()
	f = CreateFrame("FRAME", nil, UIParent)
	f.clicked = true
	
	f:Hide()
	return f
end

function MobileVault:CreateSplashScreen()
	local f = CreateFrame("FRAME", nil, MobileVault.anchor)
		
	f:ClearAllPoints()
	f:SetAllPoints(self.anchor.bg)
	
	
	f:EnableMouse(true)
	
	f.text = f:CreateFontString(nil, "OVERLAY")
	f.text:SetFontObject(GameFontNormal)
	f.text:ClearAllPoints()
	f.text:SetTextColor(self.db.profile.Tred, self.db.profile.Tgreen, self.db.profile.Tblue, 1)
	f.text:SetHeight(40)
	f.text:SetPoint("LEFT", f, "LEFT", 0, -55)
	f.text:SetPoint("RIGHT", f, "RIGHT", 0, -55)
	f.text:SetJustifyH("CENTER")
	f.text:SetJustifyV("MIDDLE")
	f.text:SetText(L["Welcome to Mobile Vault! \nPlease select a tab."])
	f.text:SetAlpha(self.db.profile.alpha)
	
	f:Show()
	
	return f
end

function MobileVault:CreateBottomBar()
	local f = CreateFrame("BUTTON", nil, MobileVault.anchor)
	f:SetWidth(725)
	f:SetHeight(25)
	
	f:SetPoint("TOP", self.anchor, "BOTTOM", 0, -365)
		
	f:SetBackdropColor(self.db.profile.red, self.db.profile.green, self.db.profile.blue, 1)
	
	f.scan = f:CreateFontString(nil, "OVERLAY")
	f.scan:SetFontObject(GameFontNormal)
	f.scan:ClearAllPoints()
	f.scan:SetTextColor(self.db.profile.Tred, self.db.profile.Tgreen, self.db.profile.Tblue, 1)
	f.scan:SetHeight(20)
	f.scan:SetPoint("LEFT", f, "LEFT", 6, 0)
	f.scan:SetPoint("RIGHT", f, "RIGHT")
	f.scan:SetJustifyH("LEFT")
	f.scan:SetJustifyV("MIDDLE")
	f.scan:SetText(L["Last Scan:"].." ")
	f.scan:SetAlpha(self.db.profile.alpha)
	
	f.gold = f:CreateFontString(nil, "OVERLAY")
	f.gold:SetFontObject(GameFontNormal)
	f.gold:ClearAllPoints()
	f.gold:SetTextColor(self.db.profile.Tred, self.db.profile.Tgreen, self.db.profile.Tblue, 1)
	f.gold:SetHeight(20)
	f.gold:SetPoint("LEFT", f, "LEFT")
	f.gold:SetPoint("RIGHT", f, "RIGHT", -6, 0)
	f.gold:SetJustifyH("RIGHT")
	f.gold:SetJustifyV("MIDDLE")
	f.gold:SetText("xxxg  xxs xxc")
	f.gold:SetAlpha(self.db.profile.alpha)
	
	f:Show()
	
	return f
end

function MobileVault:CreateAnchor()
	local f = CreateFrame("BUTTON", "MGV_Main_Anchor", UIParent)
	
	table.insert(UISpecialFrames, "MGV_Main_Anchor")
	
	f.close = CreateFrame("BUTTON", nil, f, "UIPanelCloseButton")
	f.close:SetPoint("TOPRIGHT", f, "TOPRIGHT", -2, -1)
	
	f:SetWidth(725)
	f:SetHeight(55)
	
	f:SetFrameStrata("LOW")
	f.owner = self
	
	if MobileVault.db.profile.position.x and MobileVault.db.profile.position.y and MobileVault.db.profile.position.anchor and MobileVault.db.profile.position.point then
		f:ClearAllPoints()
		f:SetPoint(MobileVault.db.profile.position.point, UIParent, MobileVault.db.profile.position.anchor, MobileVault.db.profile.position.x, MobileVault.db.profile.position.y)
	else
		f:SetPoint("CENTER", UIParent, "CENTER", 0, 175)
	end
	
	f:SetScript("OnDragStart", function() this:StartMoving() end )
	f:SetScript("OnDragStop",
		function ()
			this:StopMovingOrSizing()
			local point, _, anchor, x, y = this:GetPoint()
			this.owner.db.profile.position.x = math.floor(x)
			this.owner.db.profile.position.y = math.floor(y)
			this.owner.db.profile.position.anchor = anchor
			this.owner.db.profile.position.point = point
		end)
	
	f:EnableMouse(true)
	f:SetMovable(true)
	f:RegisterForDrag("LeftButton")
	f:SetClampedToScreen(true)
	
	f.bg = CreateFrame("FRAME", nil, f)
	f.bg:SetWidth(725)
	f.bg:SetHeight(25)
	f.bg:SetBackdrop({
		bgFile = [[Interface\Buttons\WHITE8X8]],
		edgeFile = [[Interface\Tooltips\UI-Tooltip-Border]],
		tile = false, tileSize = 16, edgeSize = 16,
		insets = { left = 3, right = 3, top = 0, bottom = 3 }
	})
	
	f.bg:SetBackdropColor(self.db.profile.red, self.db.profile.green, self.db.profile.blue, self.db.profile.alpha)
	f.bg:SetBackdropBorderColor(1, 1, 1, self.db.profile.alpha)
	
	f:SetBackdrop({
		bgFile = [[Interface\Buttons\WHITE8X8]],
		edgeFile = [[Interface\Tooltips\UI-Tooltip-Border]],
		tile = false, tileSize = 16, edgeSize = 16,
		insets = { left = 3, right = 3, top = 3, bottom = 0 }
	})
	
	f:SetBackdropColor(self.db.profile.red, self.db.profile.green, self.db.profile.blue, self.db.profile.alpha)
	f:SetBackdropBorderColor(1, 1, 1, self.db.profile.alpha)
	
	f.bg:SetPoint("TOP", f, "TOP", 0, -45)
	f.bg:Show()
	
	f.text = f.bg:CreateFontString(nil, "OVERLAY")
	f.text:SetFontObject(GameFontNormal)
	f.text:ClearAllPoints()
	f.text:SetTextColor(self.db.profile.Tred, self.db.profile.Tgreen, self.db.profile.Tblue, 1)
	f.text:SetWidth(725)
	f.text:SetHeight(20)
	f.text:SetPoint("TOP", f, "TOP")
	f.text:SetJustifyH("CENTER")
	f.text:SetJustifyV("MIDDLE")
	f.text:SetText(L["Mobile Guild Vault"])
	f.text:SetAlpha(self.db.profile.alpha)
	
	f.subtext = f.bg:CreateFontString(nil, "OVERLAY")
	f.subtext:SetFontObject(GameFontNormal)
	f.subtext:ClearAllPoints()
	f.subtext:SetTextColor(self.db.profile.Tred, self.db.profile.Tgreen, self.db.profile.Tblue, 1)
	f.subtext:SetWidth(725)
	f.subtext:SetHeight(20)
	f.subtext:SetPoint("TOP", f, "TOP", 0, -22)
	f.subtext:SetJustifyH("CENTER")
	f.subtext:SetJustifyV("MIDDLE")
	f.subtext:SetAlpha(self.db.profile.alpha)
	
	f.actionbutton = CreateFrame("BUTTON", nil, f, "UIPanelButtonTemplate")
	f.actionbutton:SetWidth(100)
	f.actionbutton:SetHeight(22)
	f.actionbutton:SetText(L["Guilds"])
	f.actionbutton:SetPoint("TOPLEFT", f, "TOPLEFT", 15, -15)
	f.actionbutton:SetScript("OnClick", function() self:ShowVaultMenu() end)
	f.actionbutton:Show()
	f.actionbutton:SetAlpha(self.db.profile.alpha)
	
	f:Hide()
	
	return f
end

function MobileVault:CreateTabs()
	local storage = {}
	local padding = self.db.profile.tab_spacing
	
	for i = 1, 6 do
		local a = CreateFrame("BUTTON", nil, MobileVault.anchor)
		a.tab = a:CreateTexture(nil, "BORDER")
		a.tab:SetWidth(30)
		a.tab:SetHeight(30)
		a.tab:SetTexCoord(0, 1, 0, 1)
		a.tab:SetAlpha(self.db.profile.alpha)
		
		a:SetWidth(40)
		a:SetHeight(40)
		a:ClearAllPoints()
		if i == 1 then
			a:SetPoint("LEFT", self.anchor, "RIGHT", 5, -10)
		else
			a:SetPoint("TOP", storage[i-1], "BOTTOM", 0, -padding)
		end
		a.tab:SetPoint("CENTER", a, "CENTER")
		
		a:SetBackdrop({
			bgFile = [[Interface\Buttons\WHITE8X8]],
			edgeFile = [[Interface\Tooltips\UI-Tooltip-Border]],
			tile = false, tileSize = 16, edgeSize = 15,
			insets = { left = 5, right = 5, top = 5, bottom = 5 }
		})
		
		a:SetBackdropColor(self.db.profile.red, self.db.profile.green, self.db.profile.blue, self.db.profile.alpha)
		a:SetBackdropBorderColor(self.db.profile.Bred, self.db.profile.Bgreen, self.db.profile.Bblue, self.db.profile.alpha)
		a:EnableMouse(true)
		a:RegisterForClicks("LeftButtonUp")
		
		a:SetScript("OnEnter", function()
			GameTooltip:SetOwner(this)
			GameTooltip:ClearLines()
			GameTooltip:AddLine("|cffffffff"..L["Page"].." "..i)
			GameTooltip:Show()
		
			a:SetBackdropBorderColor(self.db.profile.Hred, self.db.profile.Hgreen, self.db.profile.Hblue, self.db.profile.alpha)
		end)
		a:SetScript("OnLeave", function()
			GameTooltip:Hide()
			if a.clicked then
				a:SetBackdropBorderColor(self.db.profile.Cred, self.db.profile.Cgreen, self.db.profile.Cblue, self.db.profile.alpha)
			else
				a:SetBackdropBorderColor(self.db.profile.Bred, self.db.profile.Bgreen, self.db.profile.Bblue, self.db.profile.alpha)
			end
		end)
		a:SetScript("OnClick", function()
			if arg1 == "LeftButton" then
				for k, v in pairs(self.pages) do
					if k == self.activePage then
						self:TriggerEvent("MGV_PAGESWITCH", i)
						self.pages[k]:Hide()
						self.pages[i]:Show()
						self.tab_buttons[k].clicked = false
						self.tab_buttons[i].clicked = true
						self.tab_buttons[k]:SetBackdropBorderColor(self.db.profile.Bred, self.db.profile.Bgreen, self.db.profile.Bblue, self.db.profile.alpha)
						self.tab_buttons[i]:SetBackdropBorderColor(self.db.profile.Cred, self.db.profile.Cgreen, self.db.profile.Cblue, self.db.profile.alpha)
						self.activePage = i
					end
				end
			end
		end)
		
		a:Hide()
		
		a.clicked = false
		
		table.insert(storage, a)
	end
	
	return storage
end

function MobileVault:CreatePage()
	local f = CreateFrame("FRAME", nil, MobileVault.anchor)
	f:SetWidth(725)
	f:SetHeight(320)
	
	f:ClearAllPoints()
	f:SetPoint("TOP", MobileVault.anchor, "BOTTOM", 0, 0)
	
	f:EnableMouse(true)
	
	f.subframes = self:CreateSubFrames(f)
	
	f:Hide()
	
	return f
end

function MobileVault:CreateSubFrames(parent)
	local storage = {}
	local spacing = self.db.profile.spacing
	local padding = self.db.profile.padding
	for i = 1, 7 do
		local a = CreateFrame("FRAME", nil, parent)
		a:SetWidth(80 + padding)
		
		a:ClearAllPoints()
		if i == 1 then
			a:SetPoint("LEFT", parent, "LEFT")
			a:SetPoint("TOP", parent, "TOP")
			a:SetPoint("BOTTOM", parent, "BOTTOM")
		else
			a:SetPoint("LEFT", storage[i-1], "RIGHT", spacing, 0)
			a:SetPoint("TOP", parent, "TOP")
			a:SetPoint("BOTTOM", parent, "BOTTOM")
		end
		
		a:EnableMouse(true)
	
		a.slots = self:CreateSlots(a)
	
		a:Show()
		
		table.insert(storage, a)
	end
	
	return storage
end

function MobileVault:CreateSlots(parent)
	local storage = {}
	local padding = self.db.profile.padding
	for i = 1, 14 do
		local a = CreateFrame("BUTTON", nil, parent)
		a.item = a:CreateTexture(nil, "BORDER")
		a.item:SetWidth(32)
		a.item:SetHeight(32)
		a.item:SetAlpha(self.db.profile.alpha)
		
		a.count = a:CreateFontString(nil, "BORDER")
		a.count:SetWidth(32)
		a.count:SetHeight(32)
		a.count:SetFontObject(NumberFontNormalSmallGray)
		a.count:SetTextColor(1, 1, 1, 1)
		a.count:SetJustifyH("RIGHT")
		a.count:SetJustifyV("BOTTOM")
		a.count:SetAlpha(self.db.profile.alpha)
		
		a:SetWidth(40)
		a:SetHeight(40)
		
		a:ClearAllPoints()
		if i == 1 then
			a:SetPoint("TOPLEFT", parent, "TOPLEFT")
		elseif i > 1 and i <= 7 then
			a:SetPoint("TOP", storage[i-1], "BOTTOM", 0, -padding)
		elseif i == 8 then
			a:SetPoint("LEFT", storage[1], "RIGHT", padding, 0)
		elseif i > 8 then
			a:SetPoint("TOP", storage[i-1], "BOTTOM", 0, -padding)
		end
		
		a:SetBackdrop({
		bgFile = nil,
		edgeFile = [[Interface\Tooltips\UI-Tooltip-Border]],
		tile = false, tileSize = 16, edgeSize = 14,
		insets = { left = 3, right = 3, top = 3, bottom = 3 }
		})
		
		a:SetBackdropBorderColor(self.db.profile.Bred, self.db.profile.Bgreen, self.db.profile.Bblue, self.db.profile.alpha)
		a:EnableMouse(true)
		
		a:SetScript("OnEnter", function()
			a:SetBackdropBorderColor(self.db.profile.Hred, self.db.profile.Hgreen, self.db.profile.Hblue, self.db.profile.alpha)
		end)
		a:SetScript("OnLeave", function()
			a:SetBackdropBorderColor(self.db.profile.Bred, self.db.profile.Bgreen, self.db.profile.Bblue, self.db.profile.alpha)
		end)
	
		a:Show()
		
		table.insert(storage, a)
	end
	
	return storage
end

function MobileVault:ToggleFrame()
	if self.anchor:IsVisible() then
		self.anchor:Hide()
	else
		if not self.setup then
			self:SetupDBTables()
		end
		if self.GuildName then
			if self.db.realm.guilds[self.GuildName].hasData then
				self:Unpopulate(6)
				self:Populate(self.GuildName)
				self.currentGuild = self.GuildName
			end
		end
		self.anchor:Show()
	end
end

function MobileVault:UpdateFrame()
	local spacing, padding = self.db.profile.spacing, self.db.profile.padding
	for page = 1, 6 do
		for subframe = 1, 7 do
			if subframe == 1 then
				self.pages[page].subframes[subframe]:SetPoint("LEFT", self.pages[page], "LEFT")
			else
				self.pages[page].subframes[subframe]:SetPoint("LEFT", self.pages[page].subframes[subframe-1], "RIGHT", spacing, 0)
			end
			for slot = 1, 14 do
				if slot == 1 then
					self.pages[page].subframes[subframe].slots[slot]:SetPoint("TOPLEFT", self.pages[page].subframes[subframe], "TOPLEFT")
				elseif slot > 1 and slot <= 7 then
					self.pages[page].subframes[subframe].slots[slot]:SetPoint("TOP", self.pages[page].subframes[subframe].slots[slot-1], "BOTTOM", 0, -padding)
				elseif slot == 8 then
					self.pages[page].subframes[subframe].slots[slot]:SetPoint("LEFT", self.pages[page].subframes[subframe].slots[1], "RIGHT", padding, 0)
				elseif slot > 8 then
					self.pages[page].subframes[subframe].slots[slot]:SetPoint("TOP", self.pages[page].subframes[subframe].slots[slot-1], "BOTTOM", 0, -padding)
				end
			end
			self.pages[page].subframes[subframe]:SetWidth(80 + padding)
		end
	end
	
	for page = 1, 6 do
		self.pages[page]:SetWidth((7 * (80 + padding)) + (spacing * 6))
		self.pages[page]:SetHeight((40 * 7) + (padding)* 6)
	end
	self.anchor:SetWidth((7 * (80 + padding)) + (spacing * 6))
	self.Bottom:SetWidth((7 * (80 + padding)) + (spacing * 6))
	self.Bottom:SetPoint("TOP", self.anchor, "BOTTOM", 0, -((40 * 7) + (padding * 6) - 5))
	self.anchor.bg:SetWidth(self.anchor:GetWidth())
	self.anchor.bg:SetHeight(self.Bottom:GetHeight() + self.pages[1]:GetHeight() + 10)
end

function MobileVault:ShowVaultMenu()
	vaultopts = {
		type = 'group',
		args = {
			header = {
				type = 'header',
				name = L["Guilds"],
				order = 1,
			},
		},
	}
	
	for k, v in pairs(self.guildList) do
		vaultopts.args[v] = {
			type = 'execute',
			name = v,
			desc = string.format(L["View the %s vault."], v),
			func = function()
				self:Unpopulate(6)
				self:Populate(v)
				self.currentGuild = v
				DD:Close()
			end,
		}
	end
 
	DD:Open(self.anchor.actionbutton, 'children', vaultopts, 'point', "TOP", 'relativePoint', "TOP")
 end
