﻿--[[
MobileVault - Copyright (C) 2008 Michael Joseph Murray aka Starinnia of Lothar aka Lyte of Lothar
$Revision: 66 $
$Date: 2008-10-01 13:18:49 +0000 (Wed, 01 Oct 2008) $
contact: codemaster2010 AT gmail DOT com
]]

MobileVault = AceLibrary("AceAddon-2.0"):new("AceEvent-2.0", "AceConsole-2.0", "AceDB-2.0")
local DD = AceLibrary("Dewdrop-2.0")
local L = AceLibrary("AceLocale-2.2"):new("MobileVault")
local copper_COLOR = "|cffeda55f"
local silver_COLOR = "|cffc7c7cf"
local gold_COLOR = "|cffffd700"

BINDING_HEADER_MOBILEVAULT = "Mobile Vault"
BINDING_NAME_MGVTOGGLE = L["Toggle Frame"]

function MobileVault:OnInitialize()	
	local defaults = {
		position = {},
		guildTooltips = {},
		spacing = 0,
		padding = 0,
		tab_spacing = 15,
		red = 0.1,
		green = 0.1,
		blue = 1.0,
		alpha = 1.0,
		Bred = 1.0,
		Bgreen = 1.0,
		Bblue = 1.0,
		Hred = 0.0,
		Hgreen = 0.0,
		Hblue = 1.0,
		Cred = 0.0,
		Cgreen = 0.0,
		Cblue = 0.0,
		Tred = 1.0,
		Tgreen = 1.0,
		Tblue = 1.0,
		TTcolor = "eda55f"
	}
	
	self:RegisterDB("MobileVaultDB")
	self:RegisterDefaults('profile', defaults)
	self:RegisterDefaults('realm', {
		guilds = {},
	})
	
	self.guildList = {}
	for k in pairs(self.db.realm.guilds) do
		table.insert(self.guildList, k)
	end
	
	self.options = {
		type='group',
		args = {
			show = {
				type = 'execute',
				name = L["Toggle Frame"],
				desc = L["Show or Hide the Guild Vault Image Frame"],
				func = "ToggleFrame",
				order = 7,
			},
			tooltips = {
				type = 'group',
				name = L["Tooltips"],
				desc = L["Options for the Mobile Guild Vault toolips."],
				order = 6,
				args = {
					guilds = {
						type = 'text',
						name = L["Guilds"],
						desc = L["Choose which guild bank counts you want in the tooltips."],
						get = function(key) return self.db.profile.guildTooltips[key] end,
						set = function(key, value) self.db.profile.guildTooltips[key] = value end,
						validate = self.guildList,
						multiToggle = true,
						usage = " ",
					},
					color = {
						type = 'color',
						name = L["Text Color"],
						desc = L["Set the text color for the tooltips."],
						get = function()
							local r, g, b = self:HexToRGBPerc(self.db.profile.TTcolor)
							return r, g, b
						end,
						set = function(r, g, b) self.db.profile.TTcolor = self:RGBPercToHex(r, g, b) end,
					},
				},
			},
			delete = {
				type = 'text',
				name = L["Delete"],
				desc = L["Delete the specified guild's data table"],
				usage = L["<name of guild>"],
				get = false,
				set = function(text)
					if self.db.realm.guilds[text] then
						if text == self.GuildName then
							self:Unpopulate(6)
						end
						self.db.realm.guilds[text] = nil
						self:Print(text.." "..L["has been cleared from the Database."])
					else
						self:Print(text.." "..L["does not have any data stored with MGV."])
					end
				end,
				order = 4,
			},
			printDB = {
				type = 'execute',
				name = L["Print DB Names"],
				desc = L["Print out a list of all populated guild databases."],
				func = function()
					for k, v in pairs(self.db.realm.guilds) do
						self:Print(k)
					end
				end,
				order = 3,
			},
			visuals = {
				type = 'group',
				name = L["Visuals"],
				desc = L["Options for the visual aspects of the addon."],
				order = 5,
				args = {
					spacing = {
						type = 'range',
						name = L["Column Spacing"],
						desc = L["Set the column spacing"],
						get = function() return self.db.profile.spacing end,
						set = function(v) 
							self.db.profile.spacing = v
							self:UpdateFrame()
						end,
						min = -25,
						max = 15,
						step = 1,
						order = 1,
					},
					padding = {
						type = 'range',
						name = L["Slot Padding"],
						desc = L["Set the amount of space between the slots in a column"],
						get = function() return self.db.profile.padding end,
						set = function(v)
							self.db.profile.padding = v
							self:UpdateFrame()
						end,
						min = -5,
						max = 15,
						step = 1,
						order = 2,
					},
					tabpad = {
						type = 'range',
						name = L["Tab Button Spacing"],
						desc = L["Set the amount of space between the tab buttons"],
						get = function() return self.db.profile.tab_spacing end,
						set = function(v)
							self.db.profile.tab_spacing = v
							for i = 1, 6 do
								if i == 1 then
									self.tab_buttons[i]:SetPoint("LEFT", self.anchor, "RIGHT", 5, -10)
								else
									self.tab_buttons[i]:SetPoint("TOP", self.tab_buttons[i-1], "BOTTOM", 0, -v)
								end
							end
						end,
						min = -10,
						max = 25,
						step = 1,
						order = 3,
					},
					textcolor = {
						type = 'color',
						name = L["Text Color"],
						desc = L["Set the text color."],
						get = function() return self.db.profile.Tred, self.db.profile.Tgreen, self.db.profile.Tblue end,
						set = function(r, g, b)
							self.db.profile.Tred, self.db.profile.Tgreen, self.db.profile.Tblue = r, g, b
							self.anchor.text:SetTextColor(r, g, b, self.db.profile.alpha)
							if self.SplashScreen then
								self.SplashScreen.text:SetTextColor(r, g, b, self.db.profile.alpha)
							end
							self.Bottom.scan:SetTextColor(r, g, b, self.db.profile.alpha)
							self.Bottom.gold:SetTextColor(r, g, b, self.db.profile.alpha)
						end,
					},
					color = {
						type = 'color',
						name = L["Frame Color"],
						desc = L["Set the color of the image frame"],
						get = function() return self.db.profile.red, self.db.profile.green, self.db.profile.blue end,
						set = function(r, g, b)
							self.db.profile.red, self.db.profile.green, self.db.profile.blue = r, g, b
							self.anchor:SetBackdropColor(r, g, b, self.db.profile.alpha)
							self.anchor.bg:SetBackdropColor(r, g, b, self.db.profile.alpha)
							for tab = 1, 6 do
								self.tab_buttons[tab]:SetBackdropColor(r, g, b, self.db.profile.alpha)
							end
						end,
					},
					alpha = {
						type = 'range',
						name = L["Frame Alpha"],
						desc = L["Set the frame alpha"],
						get = function() return self.db.profile.alpha end,
						set = function(v)
							self.db.profile.alpha = v
							self.anchor.bg:SetBackdropColor(self.db.profile.red, self.db.profile.green, self.db.profile.blue, v)
							self.anchor.bg:SetBackdropBorderColor(1, 1, 1, v)
							self.anchor.text:SetAlpha(v)
							self.anchor.subtext:SetAlpha(v)
							self.anchor.actionbutton:SetAlpha(v)
							self.anchor.close:SetAlpha(v)
							self.Bottom.scan:SetAlpha(v)
							self.Bottom.gold:SetAlpha(v)
							for tab = 1, 6 do
								self.tab_buttons[tab]:SetBackdropColor(self.db.profile.red, self.db.profile.green, self.db.profile.blue, v)
								self.tab_buttons[tab]:SetBackdropBorderColor(self.db.profile.Bred, self.db.profile.Bgreen, self.db.profile.Bblue, v)
								self.tab_buttons[tab].tab:SetAlpha(v)
								self.tab_buttons[tab]:SetScript("OnLeave", function()
									GameTooltip:Hide()
									if self.tab_buttons[tab].clicked then
										self.tab_buttons[tab]:SetBackdropBorderColor(self.db.profile.Cred, self.db.profile.Cgreen, self.db.profile.Cblue, v)
									else
										self.tab_buttons[tab]:SetBackdropBorderColor(self.db.profile.Bred, self.db.profile.Bgreen, self.db.profile.Bblue, v)
									end
								end)
								self.tab_buttons[tab]:SetScript("OnClick", function()
									if arg1 == "LeftButton" then
										for k, v in pairs(self.pages) do
											if k == self.activePage then
												self:TriggerEvent("MGV_PAGESWITCH", tab)
												self.pages[k]:Hide()
												self.pages[tab]:Show()
												self.tab_buttons[k].clicked = false
												self.tab_buttons[tab].clicked = true
												self.tab_buttons[k]:SetBackdropBorderColor(self.db.profile.Bred, self.db.profile.Bgreen, self.db.profile.Bblue, v)
												self.tab_buttons[tab]:SetBackdropBorderColor(self.db.profile.Cred, self.db.profile.Cgreen, self.db.profile.Cblue, v)
												self.activePage = tab
											end
										end
									end
								end)
							end
							self.pages[0].text:SetAlpha(v)
							self:Populate(self.GuildName)
						end,
						min = .1,
						max = 1,
						step = .01,
					},
					border = {
						type = 'color',
						name = L["Border Color"],
						desc = L["Set the Slot Border Color"],
						get = function() return self.db.profile.Bred, self.db.profile.Bgreen, self.db.profile.Bblue end,
						set = function(r, g, b)
							self.db.profile.Bred, self.db.profile.Bgreen, self.db.profile.Bblue = r, g, b
							for page = 1, 6 do
								for subframe = 1, 7 do
									for slot = 1, 14 do
										self.pages[page].subframes[subframe].slots[slot]:SetBackdropBorderColor(r, g, b, self.db.profile.alpha)
									end
								end
							end
						end,
					},
					clicked = {
						type = 'color',
						name = L["Clicked Color"],
						desc = L["Sets the color for the active tab button"],
						get = function() return self.db.profile.Cred, self.db.profile.Cgreen, self.db.profile.Cblue end,
						set = function (r, g, b) self.db.profile.Cred, self.db.profile.Cgreen, self.db.profile.Cblue = r, g, b end,
					},
					highlight = {
						type = 'color',
						name = L["Highlight Color"],
						desc = L["Set the Slot Hightlight Color"],
						get = function() return self.db.profile.Hred, self.db.profile.Hgreen, self.db.profile.Hblue end,
						set = function(r, g, b) self.db.profile.Hred, self.db.profile.Hgreen, self.db.profile.Hblue = r, g, b end,
					},
				},
			},
		},
	}
	
	self.options.args.config = {
		type = "execute",
		name = L["Configuration"],
		desc = L["Show the GUI configuration menu."],
		guiHidden = true,
		func = function() DD:Open(UIParent, 'children', self.options, 'cursorX', true, 'cursorY', true) end,
	}

	MobileVault:RegisterChatCommand(L["Slash-Commands"], self.options)
	
	--anchor, tabs, and pages created
	self.anchor = self:CreateAnchor()
	self.pages = {}
	for i = 1, 6 do
		table.insert(self.pages, self:CreatePage())
	end
	self.tab_buttons = self:CreateTabs()
	self.tab_buttons[0] = self:Dummy()
	self.Bottom = self:CreateBottomBar()
	self.pages[0] = self:CreateSplashScreen()
	
	--set the default page and clicked boolean for the tab buttons
	self.activePage = 0
	
	self:UpdateFrame()
	
	DD:Register(self.anchor, "children", self.options, 'cursorX', true, 'cursorY', true)	
end

function MobileVault:OnEnable()
	--the needed Blizzard events
	self:RegisterEvent("GUILDBANKFRAME_OPENED")
	self:RegisterEvent("GUILDBANKBAGSLOTS_CHANGED", "ScanPage")
	self:RegisterEvent("PLAYER_GUILD_UPDATE", "GuildCheck")
	
	--MGV Events for Scanning and Setting Page texts
	self:RegisterEvent("MGV_PAGESWITCH", "PageSwitch")
end

function MobileVault:TableSearch(haystack, needle)
	for k, v in pairs(haystack) do
		if v == needle then
			return true
		end
	end
	
	return false
end

function MobileVault:GuildCheck()
	if not IsInGuild() then
		self:Unpopulate()
		self.noVault = true
		for k, v in pairs(self.guildList) do
			if v == self.GuildName then
				k = nil
			end
		end
		self.GuildName = nil
	else
		self.noVault = false
		self.GuildName = GetGuildInfo("player")
		if not self.db.realm.guilds[self.GuildName] then
			self.db.realm.guilds[self.GuildName] = {}
			table.insert(self.guildList, self.GuildName)
			self.db.profile.guildTooltips[self.GuildName] = false
		end
	end
end

function MobileVault:SetupDBTables()
	if IsInGuild() then
		self.GuildName = GetGuildInfo("player")
	
	
		if not self.db.realm.guilds[self.GuildName] then self.db.realm.guilds[self.GuildName] = {} end
		if not self.db.realm.guilds[self.GuildName].links then self.db.realm.guilds[self.GuildName].links = {} end
		if not self.db.realm.guilds[self.GuildName].info then self.db.realm.guilds[self.GuildName].info = {} end
		if not self.db.realm.guilds[self.GuildName].tabs then self.db.realm.guilds[self.GuildName].tabs = {} end
		if not self.db.realm.guilds[self.GuildName].tabs.textures then self.db.realm.guilds[self.GuildName].tabs.textures = {} end
		if not self.db.realm.guilds[self.GuildName].tabs.names then self.db.realm.guilds[self.GuildName].tabs.names = {} end
		
		self.db.realm.guilds[self.GuildName].numtabs = GetNumGuildBankTabs()
	end
end

function MobileVault:PageSwitch(page)
	if self.db.realm.guilds[self.currentGuild] then
		self.anchor.subtext:SetText(self.db.realm.guilds[self.currentGuild].tabs.names[page])
	end
end

function MobileVault:GUILDBANKFRAME_OPENED()
	if not self.setup then
		self:SetupDBTables()
	end
	self.db.realm.guilds[self.GuildName].guildfunds = self:Money()
	self.Bottom.gold:SetText(self:Money())
	self.db.realm.guilds[self.GuildName].hasData = true
	self.db.realm.guilds[self.GuildName].numtabs = GetNumGuildBankTabs()
	
	if not self:TableSearch(self.guildList, self.GuildName) then
		table.insert(self.guildList, self.GuildName)
		self.db.profile.guildTooltips[self.GuildName] = false
	end
end

function MobileVault:Money()
	local money = GetGuildBankMoney()
	local gold = (money - (money % 10000)) / 10000
	money = money % 10000
	local silver = (money - (money % 100)) / 100
	money = money % 100
	
	return gold..gold_COLOR..L["g |r"]..silver..silver_COLOR..L["s |r"]..money..copper_COLOR..L["c"]
end

function MobileVault:TimeStamp()
	local hour, minute = GetGameTime()
	if minute < 10 then
		minute = "0"..minute
	end
	
	if hour == 0 then
		return " 12:"..minute..L[" AM"]
	elseif hour == 12 then
		return " 12:"..minute..L[" PM"]
	elseif hour > 12 then
		return " "..(hour-12)..":"..minute..L[" PM"]
	else
		return " "..hour..":"..minute..L[" AM"]
	end
end

local num, found, itemString
function MobileVault:ScanPage()
	if GuildBankFrame then
		if GuildBankFrame:IsVisible() then
			if not self.setup then
				self:SetupDBTables()
			end
			local page = GetCurrentGuildBankTab()
			--setup the tables if they don't already exist
			if not self.db.realm.guilds[self.GuildName].links[page] then self.db.realm.guilds[self.GuildName].links[page] = {} end
			if not self.db.realm.guilds[self.GuildName].info[page] then self.db.realm.guilds[self.GuildName].info[page] = {} end
			--98 slots to go through....
			for slot = 1, 98 do
				--see if slot is empty or not
				if GetGuildBankItemLink(page, slot) then
					--if there is link, parse the ID and place that in table w/ key = slot
					found, _, itemString = string.find(GetGuildBankItemLink(page, slot), "^|c%x+|H(.+)|h%[.+%]")
					self.db.realm.guilds[self.GuildName].links[page][slot] = itemString
					
					--get item info too, need for stack sizes in image
					_, num = GetGuildBankItemInfo(page, slot)
					self.db.realm.guilds[self.GuildName].info[page][slot] = num
				else
					--if there is no link, slot is empty... fill slot w/ empty string
					--needed to keep consistent tables with keys from 1 to 98
					self.db.realm.guilds[self.GuildName].links[page][slot] = "empty"
					self.db.realm.guilds[self.GuildName].info[page][slot] = "empty"
				end	
				
				--nil out the locals... weird values appear if we don't
				found, itemString, num = nil, nil, nil
			end
			
			self.db.realm.guilds[self.GuildName].lastScan = date(L["date_format"]).." "..L["at"]..self:TimeStamp()
			self.Bottom.scan:SetText(L["Last Scan:"].." "..date(L["date_format"]).." "..L["at"]..self:TimeStamp())
			
			local name, icon = GetGuildBankTabInfo(page)
			self.db.realm.guilds[self.GuildName].tabs.textures[page] = icon
			self.db.realm.guilds[self.GuildName].tabs.names[page] = name
		end
	end
end

--function Unpopulate
--[[
removes item textures and associated counts to clear the GUI for a new data push
additionally clears the associated scripts from each slot to avoid mis-matched tooltips

	outer loop moves through each page
	next loop moves through each subframe
	inner loop moves through each slot
]]--
function MobileVault:Unpopulate(tabs)
	local numtabs = tabs or 6
	
	self.anchor.subtext:SetText("")
	self.Bottom.scan:SetText("")
	self.Bottom.gold:SetText("")
	
	for i = 1, numtabs do
		self.tab_buttons[i].tab:SetTexture(nil)
		self.tab_buttons[i]:SetScript("OnEnter", function()		
			self.tab_buttons[i]:SetBackdropBorderColor(self.db.profile.Hred, self.db.profile.Hgreen, self.db.profile.Hblue, self.db.profile.alpha)
		end)
		if self.tab_buttons[i]:IsVisible() then
			self.tab_buttons[i]:Hide()
		end
	end
	
	if numtabs >= 1 then
		for page = 1, numtabs do
			for subframe = 1, 7 do
				for slot = 1, 14 do
					self.pages[page].subframes[subframe].slots[slot].item:SetTexture(nil)
					self.pages[page].subframes[subframe].slots[slot].count:SetText("")
					self.pages[page].subframes[subframe].slots[slot]:SetScript("OnEnter", function() 
						self.pages[page].subframes[subframe].slots[slot]:SetBackdropBorderColor(self.db.profile.Hred, self.db.profile.Hgreen, self.db.profile.Hblue, self.db.profile.alpha)
					end)
					self.pages[page].subframes[subframe].slots[slot]:SetScript("OnLeave", function() 
						self.pages[page].subframes[subframe].slots[slot]:SetBackdropBorderColor(self.db.profile.Bred, self.db.profile.Bgreen, self.db.profile.Bblue, self.db.profile.alpha)
					end)
				end
			end
		end
	end
end

--function Populate
--[[
imports data from saved file or recent scan to the GUI
sets the texture, tooltip and count for each slot

	outer loop moves through each page
	next loop moves through each subframe
	inner loop moves through each slot
]]--
function MobileVault:Populate(guild)
	if not guild then return end
	
	local numtabs = self.db.realm.guilds[guild].numtabs
	
	if self.db.realm.guilds[guild].lastScan then
		self.Bottom.scan:SetText(L["Last Scan: "]..self.db.realm.guilds[guild].lastScan)
	end
	if self.db.realm.guilds[guild].guildfunds then
		self.Bottom.gold:SetText(self.db.realm.guilds[guild].guildfunds)
	end
	self.anchor.subtext:SetText(self.db.realm.guilds[guild].tabs.names[1])
	for i = 1, numtabs do
		if self.db.realm.guilds[guild].links[i] then
			self.tab_buttons[i].tab:SetTexture(self.db.realm.guilds[guild].tabs.textures[i])
			self.tab_buttons[i]:SetScript("OnEnter", function() 
				GameTooltip:SetOwner(this)
				GameTooltip:ClearLines()
				GameTooltip:AddLine("|cffffffff"..self.db.realm.guilds[guild].tabs.names[i])
				GameTooltip:Show()
		
				self.tab_buttons[i]:SetBackdropBorderColor(self.db.profile.Hred, self.db.profile.Hgreen, self.db.profile.Hblue, self.db.profile.alpha)
			end)
			if not self.tab_buttons[i]:IsVisible() then
				self.tab_buttons[i]:Show()
			end
		end
	end
	
	local count
	if numtabs >= 1 then
		for page = 1, numtabs do
			if self.db.realm.guilds[guild].links[page] then
				count = 0
				for subframe = 1, 7 do
					for slot = 1, 14 do
						self.pages[page].subframes[subframe].slots[slot]:SetBackdropBorderColor(self.db.profile.Bred, self.db.profile.Bgreen, self.db.profile.Bblue, self.db.profile.alpha)
						count = count + 1
						if self.db.realm.guilds[guild].links[page][count] ~= "empty" then
							local itemName, itemString, _, _, _, _, _, _, _, itemTexture = GetItemInfo(self.db.realm.guilds[guild].links[page][count])
							self.pages[page].subframes[subframe].slots[slot].item:SetTexture(itemTexture)
							self.pages[page].subframes[subframe].slots[slot].item:SetPoint("CENTER", self.pages[page].subframes[subframe].slots[slot], "CENTER")
							self.pages[page].subframes[subframe].slots[slot].item:SetTexCoord(0, 1, 0, 1)
							self.pages[page].subframes[subframe].slots[slot].item:SetAlpha(self.db.profile.alpha)
							
							if self.db.realm.guilds[guild].info[page][count] > 1 then
								self.pages[page].subframes[subframe].slots[slot].count:ClearAllPoints()
								self.pages[page].subframes[subframe].slots[slot].count:SetPoint("BOTTOMRIGHT", self.pages[page].subframes[subframe].slots[slot].item, "BOTTOMRIGHT", 2, 2)
								self.pages[page].subframes[subframe].slots[slot].count:SetText(self.db.realm.guilds[guild].info[page][count])
								self.pages[page].subframes[subframe].slots[slot].count:SetAlpha(self.db.profile.alpha)
							end
							
							self.pages[page].subframes[subframe].slots[slot]:SetScript("OnEnter", function()
								if not this:IsVisible() then return end
								GameTooltip:SetOwner(this)
								GameTooltip:ClearLines()
								GameTooltip:SetHyperlink(itemString)
								GameTooltip:Show()
								self.pages[page].subframes[subframe].slots[slot]:SetBackdropBorderColor(self.db.profile.Hred, self.db.profile.Hgreen, self.db.profile.Hblue, self.db.profile.alpha)
							end)
							self.pages[page].subframes[subframe].slots[slot]:SetScript("OnLeave", function()
								GameTooltip:Hide()
								self.pages[page].subframes[subframe].slots[slot]:SetBackdropBorderColor(self.db.profile.Bred, self.db.profile.Bgreen, self.db.profile.Bblue, self.db.profile.alpha)
							end)
							self.pages[page].subframes[subframe].slots[slot]:SetScript("OnClick", function()
								if IsShiftKeyDown() then
									ChatFrameEditBox:Insert(itemString)
								end
							end)
						end
					end
				end
			end
		end
	end
end

----------------------------------------------------------------------------------------------
--						COLOR FUNCTIONS				--
----------------------------------------------------------------------------------------------
function MobileVault:HexToRGBPerc(hex)
	local rhex, ghex, bhex = string.sub(hex, 1, 2), string.sub(hex, 3, 4), string.sub(hex, 5, 6)
	return tonumber(rhex, 16)/255, tonumber(ghex, 16)/255, tonumber(bhex, 16)/255
end

function MobileVault:RGBPercToHex(r, g, b)
	r = r <= 1 and r >= 0 and r or 0
	g = g <= 1 and g >= 0 and g or 0
	b = b <= 1 and b >= 0 and b or 0
	return string.format("%02x%02x%02x", r*255, g*255, b*255)
end


----------------------------------------------------------------------------------------------
--						TOOLTIP STUFF					--
----------------------------------------------------------------------------------------------

function MobileVault:GetCounts(frame, itemString, guild, tabs)
	local gBankCount = 0
	for pages = 1, tabs do
		if self.db.realm.guilds[guild].links[pages] then
			for k, v in pairs(self.db.realm.guilds[guild].links[pages]) do
				if v == itemString then
					gBankCount = gBankCount + self.db.realm.guilds[guild].info[pages][k]
				end
			end
		end
	end
	
	if gBankCount and (gBankCount ~= '' or gBankCount ~= 0) then
		frame:AddDoubleLine("|cff"..self.db.profile.TTcolor..guild, "|cff"..self.db.profile.TTcolor..L["Vault:"].." "..gBankCount)
	end
end

function MobileVault:AddItemCounts(frame, iLink)
	if IsInGuild() then --hopefully stop nil ref errors when not guilded
		local vaultId
		local _, _, itemString = string.find(iLink, "^|c%x+|H(.+)|h%[.+%]")
		if itemString then
			local _, itemId = strsplit(":", itemString)
			for key, value in pairs(self.db.profile.guildTooltips) do
				if self.db.realm.guilds[key] then
					if value and self.db.realm.guilds[key].numtabs then
						local found = false
						for pages = 1, self.db.realm.guilds[key].numtabs do
							if self.db.realm.guilds[key].links[pages] then
								for k, v in pairs(self.db.realm.guilds[key].links[pages]) do
									_, vaultId = strsplit(":", v)
									if vaultId == itemId and (not found) then
										found = true
										self:GetCounts(frame, self.db.realm.guilds[key].links[pages][k], key, self.db.realm.guilds[key].numtabs)
										break
									end
								end
							end
						end
					end
				end
			end
		end
	end
	
	frame:Show()
end


--fun with hooking!
local SetItem = GameTooltip:GetScript('OnTooltipSetItem')
GameTooltip:SetScript('OnTooltipSetItem', function(self, ...)
	if SetItem then
		SetItem(self, ...)
	end

	local itemLink = select(2, self:GetItem())
	if itemLink then
		MobileVault:AddItemCounts(self, itemLink)
	end
end)

local SetItem = ItemRefTooltip:GetScript('OnTooltipSetItem')
ItemRefTooltip:SetScript('OnTooltipSetItem', function(self, ...)
	if SetItem then
		SetItem(self, ...)
	end

	local itemLink = select(2, self:GetItem())
	if itemLink then
		MobileVault:AddItemCounts(self, itemLink)
	end
end)
