
MoBuffs = AceLibrary("AceAddon-2.0"):new("AceConsole-2.0","AceDB-2.0","AceEvent-2.0", "FuBarPlugin-2.0")
local T = AceLibrary("Tablet-2.0")
local G = AceLibrary("Gratuity-2.0")
local RL = AceLibrary("Roster-2.1")
local L =  AceLibrary("AceLocale-2.2"):new("MoBuffs")

local TQ = LibStub:GetLibrary("LibTalentQuery-1.0")

local BabbleSpell = LibStub:GetLibrary("LibBabble-Spell-3.0")
local BS = BabbleSpell:GetLookupTable()

local options = {
  type = "group",
  args = {
    shadprot = {
      order = 300,
      name = L["Skip Shadow Prot Buff"],
      desc = L["Skip check for priest Shadow Protection Buff"],
      type = "toggle",
      get = function() return MoBuffs.db.profile.shadprot end,
      set = function() MoBuffs.db.profile.shadprot = not MoBuffs.db.profile.shadprot end,
    },
    weapbuff = {
      order = 301,
      name = L["Skip Weapon Buff"],
      desc = L["Skip check for Weapon Buffs"],
      type = "toggle",
      get = function() return MoBuffs.db.profile.weapbuff end,
      set = function() MoBuffs.db.profile.weapbuff = not MoBuffs.db.profile.weapbuff end,
    },
    foodbuff = {
      order = 302,
      name = L["Skip Food Buff"],
      desc = L["Skip check for Food Buffs"],
      type = "toggle",
      get = function() return MoBuffs.db.profile.foodbuff end,
      set = function() MoBuffs.db.profile.foodbuff = not MoBuffs.db.profile.foodbuff end,
    },
  },
}

-- FuBar stuff
MoBuffs.name = L["MoBuffs"]
MoBuffs.hasIcon = "Interface\\Icons\\Spell_Holy_GreaterBlessingofKings"
MoBuffs.title = L["MoBuffs"]
MoBuffs.clickableTooltip = true
MoBuffs.defaultMinimapPosition = 220
MoBuffs.cannotDetachTooltip = true
MoBuffs.independentProfile = true
MoBuffs.OnMenuRequest = options

-- global list of tanks (name -- not unitid)
local tankList = '|'

-- pre-build class color strings
local classColors = {}
for k, v in pairs(RAID_CLASS_COLORS) do
	classColors[k] = ("|cff%02x%02x%02x"):format(v.r * 255, v.g * 255, v.b * 255)
end

function MoBuffs:OnInitialize()
	-- AceDB stuff
	self:RegisterDB("MoBuffsDB")
	self:RegisterChatCommand({"/mobuffs"})

	TQ.RegisterCallback(self, "TalentQuery_Ready")

	self:RegisterBucketEvent("RosterLib_RosterUpdated", 2, "RosterUpdate")

	if oRA then
		self:RegisterEvent("oRA_MainTankUpdate", "UpdateExternalTankList")
	elseif CT_RA_MainTanks then
		hooksecurefunc("CT_RAOptions_UpdateMTs", function() self:UpdateExternalTankList() end)
	end

end

-- credit for this code goes to Peragor and GridLayoutPlus
function MoBuffs:UpdateExternalTankList()
	-- oRa2 and CT raid integration: get list of unitids for configured tanks
	local tankTable = nil
	
	tankList = '|'
	if oRA and oRA.maintanktable then
		tankTable = oRA.maintanktable
	elseif CT_RA_MainTanks then
		tankTable = CT_RA_MainTanks
	end
	if tankTable then
		for key, val in pairs(tankTable) do
			local unitid = RL:GetUnitIDFromName(val)
			if unitid and UnitExists(unitid) and UnitPlayerOrPetInRaid(unitid) then
				tankList = tankList .. val .. '|'
			end
		end
	end
end

function MoBuffs:OnEnable()
	-- for now, nothing
end

------------------------------------------------------------------------------------------
-- return color format string based on class
------------------------------------------------------------------------------------------
local function GetUnitClassColor(unitid)
	local _, sysclass = UnitClass(unitid)
	if sysclass then
		return classColors[sysclass] .. "%s|r"
	else
		return "|cff00ff00%s|r"
	end
end

------------------------------------------------------------------------------------------
-- handle callback when talents are ready
------------------------------------------------------------------------------------------
function MoBuffs:TalentQuery_Ready(_, name)
	if (name) then
		local unit = RL:GetUnitObjectFromName(name)
		if (unit) then
			unit.mobuffs_hunter_marksmanship = -1
			unit.mobuffs_priest_discipline = -1
			for tab = 1, GetNumTalentTabs(true) do
				local treename, _, pointsspent = GetTalentTabInfo(tab, true)
				--DEFAULT_CHAT_FRAME:AddMessage(unit.name .. ' ' .. treename .. ' ' .. pointsspent)
				if ((not pointsspent) or (pointsspent < 1)) then pointsspent = -1 end
				if (treename == L["Marksmanship"]) then 
					unit.mobuffs_hunter_marksmanship = pointsspent
				elseif (treename == L["Discipline"]) then
					unit.mobuffs_priest_discipline = pointsspent
				end
			end
		end
	end
	self:RosterUpdate()
end

------------------------------------------------------------------------------------------
-- check roster and get talents for buffers
------------------------------------------------------------------------------------------
function MoBuffs:RosterUpdate()
	for unit in RL:IterateRoster(false) do
		if (   ((unit.class == 'HUNTER') and (not unit.mobuffs_hunter_marksmanship))
		    or ((unit.class == 'PRIEST') and (not unit.mobuffs_priest_discipline))) then
			TQ:Query(unit.unitid)
		end
	end
end

------------------------------------------------------------------------------------------
-- check unit for the following temporary weapon/shield buffs
-- (Lesser|Greater) Ward of Shielding
-- Sharpened (+\d+ Damage)
-- Weighted (+\d+ Damage)
-- Anesthetic Poison
-- Deadly Poison [IVX]*
-- Crippling Poison [IVX]*
-- Wound Poison [IVX]*
-- Instant Poison [IVX]*
-- Mind-numbing Poison [IVX]*
-- (Minor|Superior|Brillant|Blessed) (Mana|Wizard) Oil
-- Wizard Oil
-- Frost Oil
-- Shadow Oil
-- (Blessed|Righteous) Weapon Coating
-- TODO:
-- [Adamantite Sharpening Stone]  +12 Weapon damage and +14 Critical strike
-- [Adamantite Weightstone]  +12 Weapon damage and +14 Critical strike  60  
-- [Consecrated Sharpening Stone]  +100 Attack power against Undead

------------------------------------------------------------------------------------------
local function GetTempWeapBuffs(unitid)
	--DEFAULT_CHAT_FRAME:AddMessage("GetTempWeapBuffs for " .. unitid)

	local buffed = false
	local tempBuffs = {}

	for i = 16, 17 do
		G:SetInventoryItem(unitid, i)

		local _, _, tmpbuff
		if (not tmpbuff) then
			_, _, tmpbuff = G:Find(L["^([%a]+ Ward of Shielding)"])
		end
		if (not tmpbuff) then
			_, _, tmpbuff = G:Find(L["^(Weighted %(%+%d+ [^%)]+%))"])
		end
		if (not tmpbuff) then
			_, _, tmpbuff = G:Find(L["^(Sharpened %(%+%d+ [^%)]+%))"])
		end
		if (not tmpbuff) then
			_, _, tmpbuff = G:Find(L["^([%a-]+ Poison ?[IVX]*)"])
		end
		if (not tmpbuff) then
			_, _, tmpbuff = G:Find(L["^([%a]+ Mana Oil)"])
		end
		if (not tmpbuff) then
			_, _, tmpbuff = G:Find(L["^([%a]+ Wizard Oil)"])
		end
		if (not tmpbuff) then
			_, _, tmpbuff = G:Find(L["^(Wizard Oil)"])
		end
		if (not tmpbuff) then
			_, _, tmpbuff = G:Find(L["^(Frost Oil)"])
		end
		if (not tmpbuff) then
			_, _, tmpbuff = G:Find(L["^(Shadow Oil)"])
		end
		if (not tmpbuff) then
			_, _, tmpbuff = G:Find(L["^([%a]+ Weapon Coating)"])
		end
		if (tmpbuff) then
			--DEFAULT_CHAT_FRAME:AddMessage("tmpbuff " .. tmpbuff)
		end
		
		if (tmpbuff) then
			tempBuffs[i - 15] = true
			buffed = true
		else
			tempBuffs[i - 15] = false
		end
	end
	--return tempBuffs
	return buffed
end

------------------------------------------------------------------------------------------
-- If player in not same zone as you, assume they are not active in raid (wait list, alt, etc.) and therefore not a source of buffs.
-- If the raid has a warlock, at least one person should be soulstoned.  
-- Warn if more than one raid member has soulstone.
-- If the raid has a mage, everyone (with mana bar) should have arcane int/bril.
-- If the raid has a druid, everyone should have mark/gift of the wild.
-- If the raid has a priest, everyone should have fortitude.
-- If the raid has a priest, and "Check Shad Prot" option enabled, everyone should have shadow protection.
-- If the raid has a priest with 21 points in Discipline, then everyone (with mana bar) should have divine spirit.
-- If the raid has a paladin, everyone should have one blessing (not picky on which) per paladin in raid.
-- If the party has a paladin, everyone should have one aura (not picky which, except crusader) per paladin in party.
-- No player should have shadow resist aura if priest in raid.
-- No player should have crusader aura.
-- If the party has a hunter (with 31 marksmanship), everyone in party should have trueshot aura.
-- If player is hunter, should have an aspect up (not picky which - except beast/pack).
-- No player should have Aspect of the Beast or Aspect of the Pack.
-- If player is hunter, should have pet out (not picky which).
-- If player is mage, should have armor up (not picky which - mana, frost, ice, etc.)
-- If player is warlock, should have armor up (not picky which - fel, demon, etc.)
-- If player is warlock, should have pet out (not picky which).
-- If player is priest, should have Inner Fire up.
-- If player is does not have mana bar, should not have Blessing of Wisdom.
-- If player is Priest, Mage, or Lock, and there are less than 4 paladins in raid, he should not have Blessing of Might.
-- If player marked as 'maintank' through UI, assume player is a TANK.
-- If player marked as tank through oRA2 or CT_RA interface, assume player is a TANK.
-- If player is in "defensive stace", or in "bear form", or has "righteous fury", assume player is a TANK.
-- If player is TANK, should not have Blessing Of Salvation.
-- If player is TANK, and raid has a druid, he should have thorns (careful, this can break CC).
-- If player is TANK, and player is a paladin, should have righteous fury.
-- Everyone should have a battle and guardian elixir -or flask- up (not picky which).
-- Everyone should have a food buff up (not picky which).
-- Everyone should have a weapon buff (not picky which) like oil or sharpening stone.
--
-- TODO:
	-- Check that every slot is equipped.
	-- Check for warlock demonic sacrifice buff if not pet.
	-- Druid's Omen of Clarity (talent)
	-- Shaman's Earth/Lightning/Water Shield 
	-- allow debug toggle
	-- dead
	-- check right zone for zone flasks (unstable, shat)
	-- check that SS on rezzer (priest, paladin, shaman)
	-- check that TANK has chest buff
	-- non-mana users should not have flask of restoration, etc.
	-- check for appropriate weapon buff (no mana regen if no mana bar, etc.)
	-- check for appropriate food buff (no mana regen if no mana bar, etc.)
	-- prob. not aspect of the cheetah (this is situational, some hunters use for pulling/kiting)
	-- nature resist options
	-- better self buff checks (max rank, etc.)
	-- add 2.4 stuff (weapon coatings)
------------------------------------------------------------------------------------------
function MoBuffs:OnTooltipUpdate()
	--DEFAULT_CHAT_FRAME:AddMessage("checking raid")

	T:SetTitle(L["MoBuffs"] .. ' (' .. L["missing"] .. ')')

	-- make this an option
	--T:SetHint("Click player line to send them a whisper of missing buffs.")

	local cat = T:AddCategory("columns", 2)
	cat:AddLine()

	-- init class counts (group 0 is totals)
	local party = { }
	for i = 0, 8 do
		party[i] = { }
		party[i]['WARRIOR'] = 0
		party[i]['PRIEST'] = 0
		party[i]['DRUID'] = 0
		party[i]['PALADIN'] = 0
		party[i]['MAGE'] = 0
		party[i]['WARLOCK'] = 0
		party[i]['ROGUE'] = 0
		party[i]['SHAMAN'] = 0
		party[i]['HUNTER'] = 0
		party[i].count = 0;              -- count of people in party/raid
		party[i].countManaUsers = 0;     -- count of people in party/raid with mana bars
		party[i].maxPaladinAuras = 0;    -- count of max auras on any one person in party
		party[i].countDivineSpirits = 0; -- count of people in mana users in party/raid with DS
		party[i].countShadProt = 0;      -- count of people in party/raid with shadow protection
		party[i].countSoulstones = 0;    -- count of people in party/raid with soulstone
		party[i].countPriestsDS = 0;     -- count of priests in party/raid with 21 discipline talents
	end

	-- get the name of the current zone for zone checks
	local currentZone = GetRealZoneText()
	local isInBg = 0;
	
	local inInstance, instanceType = IsInInstance()
	if (    (inInstance)
	    and (   (instanceType == 'arena') 
	         or (instanceType == 'pvp'))) then
		isInBG = -1;
	end

	-- get class counts for raid and parties (init role/zone if possible)
	for unit in RL:IterateRoster(false) do
	
		-- init zone and role if possible
		unit.mobuffs_zone = nil
		unit.mobuffs_role = nil
		if (UnitExists(unit.unitid) and UnitInRaid(unit.unitid)) then
			local _, _, prefix, index = string.find(unit.unitid, "(%a+)(%d*)")
			if (prefix and index and (prefix == 'raid')) then
				_, _, _, _, _, _, unit.mobuffs_zone, _, _, unit.mobuffs_role = GetRaidRosterInfo(index)
			end
		end

		-- see if this unit.name is on our tank list
		if (unit.name) then
			if (string.find(tankList, '|' .. unit.name .. '|')) then
				 unit.mobuffs_role = 'maintank'
			end
		end
		
		-- BGs sometimes have different zone names for different areas (like starting cave, etc.)
		-- so ignoring zone checking when in BG
		if (isInBG == -1) then unit.mobuffs_zone = nil end

		-- skip people out of zone (assume they are on wait list, etc.)
		-- these guys are not considered buff sources or buff targets.
		if (unit.mobuffs_zone and (unit.mobuffs_zone ~= currentZone)) then
			--DEFAULT_CHAT_FRAME:AddMessage("!Zone")

		elseif (unit.subgroup and unit.class) then

			-- if we don"t know their talent spec, query for it
			if (   ((unit.class == 'HUNTER') and (not unit.mobuffs_hunter_marksmanship))
			    or ((unit.class == 'PRIEST') and (not unit.mobuffs_priest_discipline))) then
				TQ:Query(unit.unitid)
			end

			-- get class counts
			party[0][unit.class] = party[0][unit.class] + 1
			party[unit.subgroup][unit.class] = party[unit.subgroup][unit.class] + 1
			party[0].count = party[0].count + 1
			party[unit.subgroup].count = party[unit.subgroup].count + 1
			
			-- keep track of priests with 21 points in discipline (for Divine Spirit)
			if (unit.mobuffs_priest_discipline and (unit.mobuffs_priest_discipline > 20)) then
				party[0].countPriestsDS = party[0].countPriestsDS + 1
				party[unit.subgroup].countPriestsDS = party[unit.subgroup].countPriestsDS + 1
			end
		end
	end

	for unit in RL:IterateRoster(false) do
		local missing = ''
		
		if (unit.mobuffs_zone and (unit.mobuffs_zone ~= currentZone)) then
			-- not in current zone, so assume not active in raid (wait list?)
			-- these guys are not considered buff sources or buff targets.
			missing = missing .. ' !' .. L["Zone"]

		elseif (unit.name and unit.class) then

			local countBlessings = 0;     -- number of paladin blessings on this person
			local countPaladinAuras = 0;  -- number of paladin auras on this person

			local hasInt = 0
			local hasWild = 0
			local hasFort = 0
			local hasSpirit = 0
			local hasShadProt = 0
			local hasCrusader = 0
			local hasShadResist = 0
			local hasBattle = 0
			local hasGuardian = 0
			local hasFood = 0
			local hasTrueshot = 0
			local hasAspect = 0
			local hasArmor = 0
			local hasInnerFire = 0
			local hasSalv = 0
			local hasWis = 0
			local hasMight = 0
			local hasThorns = 0
			local hasPet = 0
			local hasRFury = 0
			local hasDStance = 0
			local hasBearForm = 0
			local hasAoBeast = 0
			local hasAoPack = 0
			local hasWeapBuff = 0
			local hasPvp = 0

			-- check for unit"s (current) power type
			local powerType = UnitPowerType(unit.unitid)
			if (powerType == nil) then powerType = -1 end

			-- currently 24 buff slots per person
			for j = 1, 24 do
				local buffName, buffRank, buffTexture, buffApplications = UnitBuff(unit.unitid, j)
				if (buffName) then

					--DEFAULT_CHAT_FRAME:AddMessage("buffName " .. buffName)

					-- get description for buff
					--DEFAULT_CHAT_FRAME:AddMessage("checking description for " .. buffName)
					G:SetUnitBuff(unit.unitid, j)

					-- special handling here for battle/guardian/flask buffs
					if (G:Find(L["Battle and Guardian Elixir"])) then
						--DEFAULT_CHAT_FRAME:AddMessage(buffName .. " (Flask) found")
						hasBattle = -1
						hasGuardian = -1
					elseif (G:Find(L["Battle Elixir"])) then
						--DEFAULT_CHAT_FRAME:AddMessage(buffName .. " (Battle) found")
						hasBattle = -1
					elseif (G:Find(L["Guardian Elixir"])) then
						--DEFAULT_CHAT_FRAME:AddMessage(buffName .. " (Guardian) found")
						hasGuardian = -1
					end
					
					if (   (buffName == L["Well Fed"])                -- Most Foods
						 or (buffName == L["\"Well Fed\""])            -- Brew Fest
						 or (buffName == L["Increased Stamina"])       -- Dirge"s Kickin" Chimaerok Chops
						 or (buffName == L["Electrified"])             -- Stormchops
						 or (buffName == L["Rumsey Rum Black Label"])  -- Rumsey Rum Black Label
						 or (buffName == L["Enlightened"])) then       -- Skullfish Soup
						--DEFAULT_CHAT_FRAME:AddMessage(buffName .. " (Food) found")
						hasFood = -1
					elseif (buffName == BS["Righteous Fury"]) then
						--DEFAULT_CHAT_FRAME:AddMessage(BS["Righteous Fury"] .. " found")
						hasRFury = -1
					elseif (buffName == BS["Defensive Stance"]) then
						--DEFAULT_CHAT_FRAME:AddMessage(["Defensive Stance"] .. " found")
						hasDStance = -1
					elseif (buffName == BS["Crusader Aura"]) then
						--DEFAULT_CHAT_FRAME:AddMessage(BS["Crusader Aura"] .. " found")
						hasCrusader = -1
						countPaladinAuras = countPaladinAuras + 1
					elseif (buffName == BS["Shadow Resistance Aura"]) then
						--DEFAULT_CHAT_FRAME:AddMessage(BS["Shadow Resistance Aura"] .. " found")
						hasShadResist = -1
						countPaladinAuras = countPaladinAuras + 1
					elseif (   (buffName == BS["Devotion Aura"]) 
							  or (buffName == BS["Retribution Aura"])
							  or (buffName == BS["Concentration Aura"])
							  or (buffName == BS["Frost Resistance Aura"])
							  or (buffName == BS["Fire Resistance Aura"])
							  or (buffName == BS["Sanctity Aura"])
							 ) then
						--DEFAULT_CHAT_FRAME:AddMessage(buffName .. " (Aura) found")
						countPaladinAuras = countPaladinAuras + 1
					elseif (buffName == BS["Trueshot Aura"]) then
						--DEFAULT_CHAT_FRAME:AddMessage(BS["Trueshot Aura"] .. " found")
						hasTrueshot = -1
					elseif (   (buffName == BS["Divine Spirit"])
							  or (buffName == BS["Prayer of Spirit"])) then
						--DEFAULT_CHAT_FRAME:AddMessage(buffName .. " (Spirit) found")
						hasSpirit = -1
						-- special: only increment count if mana user
						if (powerType == 0) then 
							party[0].countDivineSpirits = party[0].countDivineSpirits + 1
							party[unit.subgroup].countDivineSpirits = party[unit.subgroup].countDivineSpirits + 1 
						end
					elseif (   (buffName == BS["Shadow Protection"])
							  or (buffName == BS["Prayer of Shadow Protection"])) then
						--DEFAULT_CHAT_FRAME:AddMessage(buffName .. " (ShadProt) found")
						hasShadProt = -1
						party[0].countShadProt = party[0].countShadProt + 1
						party[unit.subgroup].countShadProt = party[unit.subgroup].countShadProt + 1
					elseif (buffName == BS["Soulstone Resurrection"]) then
						--DEFAULT_CHAT_FRAME:AddMessage(BS["Soulstone Resurrection"] .. " (Soulstone) found")
						party[0].countSoulstones = party[0].countSoulstones + 1
						party[unit.subgroup].countSoulstones = party[unit.subgroup].countSoulstones + 1
					elseif (   (buffName == BS["Arcane Brilliance"]) 
							  or (buffName == BS["Arcane Intellect"])) then
						--DEFAULT_CHAT_FRAME:AddMessage(buffName .. " (Int) found")
						hasInt = -1
					elseif (buffName == BS["Thorns"]) then
						--DEFAULT_CHAT_FRAME:AddMessage(buffName .. "(Thorns) found" )
						hasThorns = -1
					elseif (   (buffName == BS["Mark of the Wild"]) 
							  or (buffName == BS["Gift of the Wild"])) then
						--DEFAULT_CHAT_FRAME:AddMessage(buffName .. " (Wild) found")
						hasWild = -1
					elseif (   (buffName == BS["Blessing of Salvation"]) 
							  or (buffName == BS["Greater Blessing of Salvation"])) then
						--DEFAULT_CHAT_FRAME:AddMessage(buffName .. " (Salv) found")
						countBlessings = countBlessings + 1
						hasSalv = -1
					elseif (   (buffName == BS["Blessing of Wisdom"]) 
							  or (buffName == BS["Greater Blessing of Wisdom"])) then
						--DEFAULT_CHAT_FRAME:AddMessage(buffName .. " (Wis) found")
						countBlessings = countBlessings + 1
						hasWis = -1
					elseif (   (buffName == BS["Blessing of Might"]) 
							  or (buffName == BS["Greater Blessing of Might"])) then
						--DEFAULT_CHAT_FRAME:AddMessage(buffName .. " (Might) found")
						countBlessings = countBlessings + 1
						hasMight = -1
					elseif (   (buffName == BS["Blessing of Kings"]) 
							  or (buffName == BS["Blessing of Light"])
							  or (buffName == BS["Blessing of Sanctuary"])
							  or (buffName == BS["Greater Blessing of Kings"])
							  or (buffName == BS["Greater Blessing of Light"])
							  or (buffName == BS["Greater Blessing of Sanctuary"])) then
							countBlessings = countBlessings + 1
					elseif (buffName == BS["Inner Fire"]) then
						--DEFAULT_CHAT_FRAME:AddMessage(buffName .. " (InnerFire) found")
						hasInnerFire = -1
					elseif (   (buffName == BS["Prayer of Fortitude"]) 
							  or (buffName == BS["Power Word: Fortitude"])
							  or (buffName == BS["Improved Power Word: Fortitude"])) then  --!!!is this possible
						--DEFAULT_CHAT_FRAME:AddMessage(buffName .. " (Fort) found")
						hasFort = -1
					elseif (buffName == BS["Aspect of the Beast"]) then
						--DEFAULT_CHAT_FRAME:AddMessage(buffName .. "(AoBeast) found")
						hasAoBeast = -1
					elseif (buffName == BS["Aspect of the Pack"]) then
						--DEFAULT_CHAT_FRAME:AddMessage(buffName .. "(AoPack) found ")
						hasAoPack = -1
					elseif (   (buffName == BS["Aspect of the Cheetah"]) 
							  or (buffName == BS["Aspect of the Hawk"])
							  or (buffName == BS["Aspect of the Monkey"])
							  or (buffName == BS["Aspect of the Viper"])
							  or (buffName == BS["Aspect of the Wild"])
							  or (buffName == BS["Improved Aspect of the Hawk"])          --!!!is this possible
							  or (buffName == BS["Improved Aspect of the Monkey"])) then  --!!!is this possible
						--DEFAULT_CHAT_FRAME:AddMessage(buffName .. " (Aspect) found")
						hasAspect = -1
					--!!! do we want to add armor checks for the following?
					--	["Demon Skin"] = true, -- warlock demonology spec precursor to demon armor
					--	["Natural Armor"] = true, -- pet skill
					--	["Mana Shield"] = true, -- mage arcane spec - lasts 1 min
					--	["Improved Mana Shield"] = true, -- mage arcane spec - lasts 1 min
					elseif (   (buffName == BS["Demon Armor"]) 
							  or (buffName == BS["Fel Armor"])
							  or (buffName == BS["Frost Armor"])
							  or (buffName == BS["Ice Armor"])
							  or (buffName == BS["Mage Armor"])
							  or (buffName == BS["Molten Armor"])) then
						--DEFAULT_CHAT_FRAME:AddMessage(buffName .. " (Armor) found")
						hasArmor = -1
					-- flasks should be caught by "battle and guardian" check above... but in case
					-- they are not, perform a double check.  we use regex's here for most flasks,
					-- and specific buff names for those that don't match the flask name
					--!!! this will need to be moved earlier when we add zone check for valid flags.
					elseif (   (string.find(buffName, L["^Unstable Flask of the "]))
							  or (string.find(buffName, L["^Shattrath Flask of "]))
							  or (string.find(buffName, L["^Flask of "]))
							  or (buffName == L["Chromatic Resistance"])
							  or (buffName == L["Chromatic Wonder"])
							  or (buffName == L["Distilled Wisdom"])
							  or (buffName == L["Supreme Power"])
							  or (buffName == L["Relentless Assault of Shattrath"])
							  or (buffName == L["Fortification of Shattrath"])
							  or (buffName == L["Mighty Restoration of Shattrath"])
							  or (buffName == L["Supreme Power of Shattrath"])
							  or (buffName == L["Blinding Light of Shattrath"])
							  or (buffName == L["Pure Death of Shattrath"])
							 ) then
						--DEFAULT_CHAT_FRAME:AddMessage(buffName .. " (Flask) found")
						hasBattle = -1
						hasGuardian = -1
					end
				end
			end -- for j (loop over all unit buffs)

			-- check for pvp flag
			if (UnitIsPVP(unit.unitid)) then
				--DEFAULT_CHAT_FRAME:AddMessage("(Pvp) found")
				hasPvp = -1
			end

			-- check for weapon buff
			if (GetTempWeapBuffs(unit.unitid)) then
				--DEFAULT_CHAT_FRAME:AddMessage("(WeapBuff) found")
				hasWeapBuff = -1
			end

			-- check for druid bear form
			if ((powerType == 1) and (unit.class == 'DRUID')) then
				--DEFAULT_CHAT_FRAME:AddMessage("(BearForm) found")
				hasBearForm = -1
			end
			
			-- check if has pet out
			local _, _, prefix, index = string.find(unit.unitid, "(%a+)(%d*)")
			if (prefix and index) then
				if (UnitExists(prefix .. 'pet' .. index)) then hasPet = -1 end
			elseif (prefix and (prefix == 'player')) then
				if (UnitExists('pet')) then hasPet = -1 end
			elseif (prefix) then -- target? focus?
				if (UnitExists(prefix .. 'pet')) then hasPet = -1 end
			end

			-- keep track of mana users for party/raid
			if (powerType == 0) then 
				party[0].countManaUsers = party[0].countManaUsers + 1
				party[unit.subgroup].countManaUsers = party[unit.subgroup].countManaUsers + 1
			end

			-- keep track of maximum number of paladin auras seen on any one party member
			--DEFAULT_CHAT_FRAME:AddMessage("countPaladinAuras " .. countPaladinAuras .. ' ' .. party[unit.subgroup]['PALADIN'])
			if (countPaladinAuras > party[unit.subgroup].maxPaladinAuras) then
				party[unit.subgroup].maxPaladinAuras = countPaladinAuras
			end

			-- if player has righteous fury or is in defensive stance or is in bear form, assume TANK
			if ((hasRFury == -1) or (hasDStance == -1) or (hasBearForm == -1)) then
				 unit.mobuffs_role = 'maintank'
			end

			----------------------------------------
			-- check if each person missing anything
			----------------------------------------

			if (hasBattle == 0) then missing = missing .. ' ' .. L["Battle"] end
			if (hasGuardian == 0) then missing = missing .. ' ' .. L["Guardian"] end
			if ((not MoBuffs.db.profile.foodbuff) and (hasFood == 0)) then missing = missing .. ' ' .. L["Food"] end
			if ((not MoBuffs.db.profile.weapbuff) and (hasWeapBuff == 0)) then missing = missing .. ' ' .. L["WeapBuff"] end

			if ((not MoBuffs.db.profile.shadprot) and (hasShadProt == 0) and (party[0]['PRIEST'] > 0)) then missing = missing .. ' ' .. L["ShadProt"] end
			if ((hasFort == 0) and (party[0]['PRIEST'] > 0)) then missing = missing .. ' ' .. L["Fort"] end
			-- spirit is spec specific
			if ((hasSpirit == 0) and (party[0].countPriestsDS > 0) and (powerType == 0)) then missing = missing .. ' ' .. L["Spirit"] end
			if ((hasWild == 0) and (party[0]['DRUID'] > 0)) then missing = missing .. ' ' .. L["Wild"] end
			if ((hasInt == 0) and (party[0]['MAGE'] > 0) and (powerType == 0)) then missing = missing .. ' ' .. L["Int"] end

			-- hunter self buffs
			if ((unit.class == 'HUNTER') and (hasPet == 0)) then missing = missing .. ' ' .. L["Pet"] end
			if ((unit.class == 'HUNTER') and (hasAspect == 0)) then missing = missing .. ' ' .. L["Aspect"] end
			-- trueshot aura is spec specific
			if ((unit.class == 'HUNTER') and (hasTrueshot == 0) and unit.mobuffs_hunter_marksmanship and (unit.mobuffs_hunter_marksmanship > 30)) then missing = missing .. ' ' .. L["Trueshot"] end

			-- warlock self buffs
			if ((unit.class == 'WARLOCK') and (hasPet == 0)) then missing = missing .. ' ' .. L["Pet"] end
			if ((unit.class == 'WARLOCK') and (hasArmor == 0)) then missing = missing .. ' ' .. L["Armor"] end

			-- mage self buffs
			if ((unit.class == 'MAGE') and (hasArmor == 0)) then missing = missing .. ' ' .. L["Armor"] end

			-- priest self buffs
			if ((unit.class == 'PRIEST') and (hasInnerFire == 0)) then missing = missing .. ' ' .. L["InnerFire"] end

			-- not many raid situations where Crusader aura is useful
			if (hasCrusader == -1) then missing = missing .. ' !' .. L["Crusader"] end
			-- if you have a priest in raid, you don't need shadow resistance aura
			if ((hasShadResist == -1) and (party[0]['PRIEST'] > 0)) then missing = missing .. ' !' .. L["ShadResist"] end
			-- not many raid situations where Aspect of the Pack is useful...
			if (hasAoPack == -1) then missing = missing .. ' !' .. L["AoPack"] end
			-- Aspect of the Beast usually only useful for PvP.
			if ((hasPvp == 0) and (hasAoBeast == -1)) then missing = missing .. ' !' .. L["AoBeast"] end

			-- should only be pvp flagged in bg or arena
			if ((hasPvp == -1) and (isInBG == 0)) then missing = missing .. ' !' .. L["Pvp"] end

			-- check that number of blessings on person is greater than or equal to number of paladins in raid
			--DEFAULT_CHAT_FRAME:AddMessage("countBlessings " .. countBlessings .. ' ' .. party[0]['PALADIN'])
			if (countBlessings < party[0]['PALADIN']) then missing = missing .. ' ' .. L["Blessings"] .. '(' .. (party[0]['PALADIN']-countBlessings) .. ')' end

			-- players without a mana bar should not have BoWisdom
			if ((hasWis == -1) and (powerType ~= 0)) then missing = missing .. ' !' .. L["Wis"] end

			-- If player is Priest, Mage, or Lock, and there are less than 4 paladins in raid, he should not have Blessing of Might.
			-- Salvation, Wisdom, and Light (and Kings or Sanctuary if available) would all be better choices.
			if ((hasMight == -1) and ((unit.class == 'PRIEST') or (unit.class == 'MAGE') or (unit.class == 'WARLOCK')) and (4 > party[0]['PALADIN'])) then missing = missing .. ' !' .. L["Might"] end

			-- tank specific checking
			if (unit.mobuffs_role and (unit.mobuffs_role == 'maintank')) then

				-- no TANK should have salv
				if (hasSalv == -1) then missing = missing .. ' !' .. L["Salv"] end

				-- paladin TANK should have righteous fury
				if ((unit.class == 'PALADIN') and (hasRFury == 0)) then
					missing = missing .. ' ' .. L["RFury"]
				end

				-- TANK should have thorns
				if ((hasThorns == 0) and (party[0]['DRUID'] > 0)) then 
					missing = missing .. ' ' .. L["Thorns"] 
				end
			end
			
		end

		if (missing ~= '') then
			--DEFAULT_CHAT_FRAME:AddMessage("|cffffff00" .. "<MoBuffs> " .. unit.name .. " missing" .. missing)

			local colortext = GetUnitClassColor(unit.unitid)
			local func1 = function(name, missing) ChatFrame_OpenChat("/w " .. name .. " You are missing:" .. missing) end
			cat:AddLine("text",  format(colortext, unit.name), 
							"text2", missing, 
							"func", func1, 
							"arg1", unit.name,
							"arg2", missing)
		end

	end  -- for unit

	------------------------------------------------------------------------------------
	-- check each party for missing paladin auras, divine spirit, and shadow protection
	------------------------------------------------------------------------------------

	for i = 1, 8 do
		local missing = ''

		-- if max auras on anyone person in party is less than number of paladins in party
		if (party[i].maxPaladinAuras < party[i]['PALADIN']) then
			missing = missing .. ' ' .. L["Aura"] .. '(' .. (party[i]['PALADIN']-party[i].maxPaladinAuras) .. ')'
		end

		-- if at least one priest, report groups missing shad prot
		if (not MoBuffs.db.profile.shadprot and (party[0]['PRIEST'] > 0) and (party[i].count > party[i].countShadProt)) then
			missing = missing .. ' ' .. L["ShadProt"] .. '(' .. (party[i].count-party[i].countShadProt) .. ')'
		end

		-- if anyone has priests with divine spirit talent, 
		-- then everyone with mana bar should have it. report groups missing it.
		if ((party[0].countPriestsDS > 0) and (party[i].countManaUsers > party[i].countDivineSpirits)) then
			missing = missing .. ' ' .. L["Spirit"] .. '(' .. (party[i].countManaUsers-party[i].countDivineSpirits) .. ')'
		end

		if (missing ~= '') then
			--DEFAULT_CHAT_FRAME:AddMessage("|cffffff00<MoBuffs> Party " .. i .. " missing" .. missing)

			cat:AddLine("text",  L["Party"] .. ' ' .. i, 
							"text2", missing)
		end

	end

	------------------------------------------------------------------------------------
	-- check raid for missing items.
	------------------------------------------------------------------------------------

	-- check raid for missing soulstone.  the raid should have at least 1 if there are any warlocks.
	if ((party[0].countSoulstones == 0) and (party[0]['WARLOCK'] > 0)) then 
		--DEFAULT_CHAT_FRAME:AddMessage("|cffffff00<MoBuffs> Raid missing Soulstone")

		missing = L["Soulstone"]
		cat:AddLine("text",  L["Raid"], 
						"text2", missing)
	end
	
	-- check for extra soulstones.  the raid should usually only have 1 soulstone up.
	if ((party[0].countSoulstones > 1) and (party[0]['WARLOCK'] > 1)) then
		--DEFAULT_CHAT_FRAME:AddMessage("|cffffff00<MoBuffs> Raid has multiple Soulstones")
		missing = '!' .. L["Soulstone"]
		cat:AddLine("text",  L["Raid"], 
						"text2", missing)
	end
	
	--DEFAULT_CHAT_FRAME:AddMessage("done checking raid")
end
