﻿--[[
Name: LibSpecialEvents-Mount-4.0
Revision: $Revision: 90 $
Author: LordFarlander
Original Author: Tekkub Stoutwrithe (tekkub@gmail.com)
Website: http://www.wowace.com/
Description: Special events for mounting
Dependencies: LibStub, CallbackHandler-1.0, LibSpecialEvents-Aura-4.0
]]--

--[[
Copyright (c) 2008, LordFarlander
All rights reserved.

Redistribution and use in source and binary forms, with or without
modification, are permitted provided that the following conditions are met:

    * Redistributions of source code must retain the above copyright notice,
      this list of conditions and the following disclaimer.
    * Redistributions in binary form must reproduce the above copyright notice,
      this list of conditions and the following disclaimer in the documentation
      and/or other materials provided with the distribution.

THIS SOFTWARE IS PROVIDED BY THE COPYRIGHT HOLDERS AND CONTRIBUTORS "AS IS" AND
ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE IMPLIED
WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE ARE
DISCLAIMED. IN NO EVENT SHALL THE COPYRIGHT OWNER OR CONTRIBUTORS BE LIABLE FOR
ANY DIRECT, INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR CONSEQUENTIAL DAMAGES
(INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS OR SERVICES;
LOSS OF USE, DATA, OR PROFITS; OR BUSINESS INTERRUPTION) HOWEVER CAUSED AND ON
ANY THEORY OF LIABILITY, WHETHER IN CONTRACT, STRICT LIABILITY, OR TORT
(INCLUDING NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY OUT OF THE USE OF THIS
SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF SUCH DAMAGE.
]]--

local vmajor, vminor = "LibSpecialEvents-Mount-4.0", tonumber(("$Revision: 90 $"):match("(%d+)")) + 90000

if( not LibStub( "LibSpecialEvents-Aura-4.0", true ) ) then
    error( vmajor .. " requires LibSpecialEvents-Aura-4.0" );
    return;
end--if

if( not LibStub( "LibGratuity-3.0", true ) ) then
    error( vmajor .. " requires LibGratuity-3.0" );
    return;
end--if

local lib, oldMinor = LibStub:NewLibrary( vmajor, vminor );
if( not lib ) then
    return;
end--if

local mountSpeed, flightSpeed;

do
    local locale = GetLocale();
    
    mountSpeed = ( ( locale == "deDE" ) and "Erh\195\182\ht Tempo um (.+)%%" ) or
        ( ( locale == "koKR" ) and "이동 속도 ([60|100]+)%%만큼 증가" ) or
        ( ( locale == "frFR" ) and "Augmente la vitesse de (%d+)%%" ) or
        ( ( locale == "esES" ) and "Aumenta la velocidad en un (.+)%%" ) or
        ( ( locale == "zhCN" ) and "^速度提高(.+)%%" ) or
        ( ( locale == "zhTW" ) and "速度提高(.+)%%" ) or
        "Increases speed by (.+)%%";

    flightSpeed = ( ( locale == "esES" ) and "Aumenta la velocidad de vuelo en un (.+)%%" ) or
        ( ( locale == "deDE" ) and "Fluggeschwindigkeit um (.+)%% erh\195\182ht." ) or
        ( ( locale == "frFR" ) and "Augmente la vitesse de vol de (.+)%%" ) or
        ( ( locale == "koKR" ) and "비행 속도 (.+)%%만큼 증가" ) or
        ( ( locale == "zhCN" ) and "^飞行速度提高(.+)%%" ) or
        ( ( locale == "zhTW" ) and "飛行速度提高(.+)%%" ) or
        "Increases flight speed by (.+)%%";
end--do

if( not lib.vars ) then
    lib.vars = {};
end--if

for buff, i in LibStub( "LibSpecialEvents-Aura-4.0" ):BuffIter( "player" ) do
    lib:PlayerBuffGained( nil, buff, i );
end--for

local CallbackHandler = LibStub:GetLibrary( "CallbackHandler-1.0" );

if( lib.callbacks ) then
    lib:UnregisterAll( lib );
else
    lib.callbacks = LibStub( "CallbackHandler-1.0" ):New( lib, nil, nil, "UnregisterAll" );
end--if

function lib:PlayerBuffGained( _, buff, i )
    if( UnitOnTaxi( "player" ) or self.vars.mounted ) then
        return;
    end--if

    local gratuity = LibStub( "LibGratuity-3.0" );

    gratuity:SetUnitBuff( "player", i );

    local txt = gratuity:GetLine( 2 );

    if( not txt ) then
        return;
    end--if

    local speed = txt:match( mountSpeed );

    if( speed ) then
        self.vars.mounted, self.vars.mountspeed, self.vars.flying = buff, speed, false;

        lib.callbacks:Fire( "Mounted", buff, speed, i, false );
    else
        speed = txt:match( flightSpeed );
        if(  speed and ( not self.vars.mounted ) ) then
            self.vars.mounted, self.vars.mountspeed, self.vars.flying = buff, speed, true;
            lib.callbacks:Fire( "Mounted", buff, speed, i, true );
        end--if
    end--if
end--lib:PlayerBuffGained( _, buff, i )


function lib:PlayerBuffLost( _, buff )
    if( buff == self.vars.mounted ) then
        lib.callbacks:Fire( "Dismounted", buff, self.vars.mountspeed, self.vars.flying );
        self.vars.mounted, self.vars.mountspeed, self.vars.flying = nil, nil, nil;
    end--if
end--lib:PlayerBuffLost( _, buff )


-----------------------------
--      Query Methods      --
-----------------------------

function lib:PlayerMounted()
    return self.vars.mounted, self.vars.mountspeed;
end--lib:PlayerMounted()

function lib:PlayerFlying()
    return self.vars.flying;
end--lib:PlayerFlying()

LibStub( "LibSpecialEvents-Aura-4.0" ).RegisterCallback( lib, "PlayerBuffGained" );
LibStub( "LibSpecialEvents-Aura-4.0" ).RegisterCallback( lib, "PlayerBuffLost" );