local minimizeAfterCombat=false
local slashOpts={}
local chan={}
local channelsRcvdByWindow={}
local msgsRcvdByWindow={}
local lower={}
local mouseWasOverChatWindow={false,false,false,false,false,false,false}
local animating={false,false,false,false,false,false,false}
local locked={false,false,false,false,false,false,false}

MiniChat=AceLibrary("AceAddon-2.0"):new("AceConsole-2.0","AceEvent-2.0","AceDB-2.0","AceHook-2.1")
MiniChat:RegisterDB("MiniChatDB")
MiniChat:RegisterDefaults("profile",{
 ChatHeight={0,0,0,0,0,0,0},
 ChatLeft={0,0,0,0,0,0,0},
 ChatBottom={0,0,0,0,0,0,0},
 IsAttachedToTop={0,0,0,0,0,0,0},
 EnabledFor={true,true,true,true,true,true,true},
 Minimized={false,false,false,false,false,false,false},
 Alpha=1.0,
 ChatAlphaEnabled=false,
 ChatMinAlpha=1.0,
 ChatMaxAlpha=1.0,
 ClampToScreen=true,
 MinimizeOnStart=true,
 Scale=1.0,
 Padding=0,
 Unlock=false,
 CustomX={0,0,0,0,0,0,0},
 CustomY={0,0,0,0,0,0,0},
 Direction="down",
 Position={"topright","topright","topright","topright","topright","topright","topright"},
 AnimationSpeed=0,
 SmartMinimize=true,
 LinesWhenMinimized=1,
 MaximizeOnMouseOver=false,
 MinimizeOnMouseOut=false,
 AutoMinimize=false,
 AutoMinimizeAfter=60,
 AutoMaximizeEnabled=false,
 AutoMaximizeIgnoreIfInCombat=false,
 AutoMaximizeIgnoreSelf=false,
 AutoMaximizeOnLoot=false,
 AutoMaximizeOnYell=false,
 AutoMaximizeOnSay=false,
 AutoMaximizeOnSystem=false,
 AutoMaximizeOnWhisper=false,
 AutoMaximizeOnGuild=false,
 AutoMaximizeOnParty=false,
 AutoMaximizeOnRaid=false,
 AutoMaximizeOnBattleground=false,
 AutoMaximizeOnOfficer=false,
 AutoMaximizeOnChannel={false,false,false,false,false,false,false,false,false,false}
})
local dewdrop=AceLibrary("Dewdrop-2.0")

function MiniChat:UpdateOptions()
 slashOpts={
  type='group',
  name='MiniChat',
  args={
   alpha={
    type='range',
    name='Alpha value of MiniChat buttons',
    desc='Adjusts transparency of the MiniChat buttons.',
    usage="(0.0-1.0), 0=invisible, 1=opaque. Note: The buttons will always be opaque on mouse over.",
    step=0.05,
    handler=self,
    get=function() return self.db.profile.Alpha end,
    set="SetAlpha"
   },
   padding={
    type='range',
    name='Space between attached windows',
    desc='Allows you to adjust the space between attached windows in pixels.',
    usage="(0-50)",
    min=0,
    max=50,
    step=1,
    handler=self,
    get=function() return self.db.profile.Padding end,
    set="SetPadding"
   },
   clampToScreen={
    type='toggle',
    name='Clamp chat windows to screen',
    desc='Clamps chat windows to the screen so it won\'t happen that they minimize or maximize out of it.',
    handler=self,
    get=function() return self.db.profile.ClampToScreen end,
    set="SetClampToScreen"
   },
   maximizeOnMouseOver={
    type='toggle',
    name='Maximize chat windows on mouse over',
    desc='Chat windows will be maximized when the mouse pointer touches them.',
    handler=self,
    get=function() return self.db.profile.MaximizeOnMouseOver end,
    set="SetMaximizeOnMouseOver"
   },
   minimizeOnStart={
    type='toggle',
    name='Minimize chat window on login',
    desc='Chat windows will be minimized when you log in.',
    get=function() return self.db.profile.MinimizeOnStart end,
    set=function(x) self.db.profile.MinimizeOnStart=x end
   },
   minimizeOnMouseOut={
    type='toggle',
    name='Minimize chat windows on mouse out',
    desc='Chat windows will be minimized when the mouse pointer leaves them.',
    handler=self,
    get=function() return self.db.profile.MinimizeOnMouseOut end,
    set="SetMinimizeOnMouseOut"
   },
   direction={   
    type='text',
    name='Direction to minimize to',
    desc='Determines in which direction the chat windows minimize. WARNING: This will delete all attachments and sometimes needs chat tabs to be relocated afterwards.',
    usage="(down|up)",
    get=function() return self.db.profile.Direction end,
    set=function(newVal) self:SetDirection(newVal) end,
    validate={"down","up"}
   },
   scale={
    type='range',
    name='Size of MiniChat buttons',
    desc='Adjusts the sizes of the MiniChat buttons.',
    usage='(0.1-2.0)',
    min=0.1,
    max=2.0,
    step=0.1,
    handler=self,
    get=function() return self.db.profile.Scale end,
    set="SetScale"
   },
   unlock={
    type='toggle',
    name='Unlock the MiniChat buttons',
    desc='Move the MiniChat buttons with your mouse. Note: Once moved, the button will never change it\'s position on min-/maximization until Position is set again.',
    get=function() return self.db.profile.Unlock end,
    set=function(x) self.db.profile.Unlock=x end
   },
   animationSpeed={
    type='range',
    name='Speed for min-/maximizing (0=no animation)',
    desc='Defines the speed for min-/maximizing the chat windows.',
    usage='(0-100)',
    min=0,
    max=100,
    step=1,
    get=function() return self.db.profile.AnimationSpeed end,
    set=function(x) self.db.profile.AnimationSpeed=x end
   },
   linesWhenMinimized={
    type='range',
    name='Lines when minimized',
    desc='Show the last x messages or lines (depending on Smart minimize) when chat window is minimized.',
    usage='(1-5)',
    min=1,
    max=5,
    step=1,
    get=function() return self.db.profile.LinesWhenMinimized end,
    set=function(x) self.db.profile.LinesWhenMinimized=x end
   },
   smartMinimize={
    type='toggle',
    name='Smart minimize',
    desc='On minimization, the chat window heights will be set to the height of the last message instead of the height of one line.',
    get=function() return self.db.profile.SmartMinimize end,
    set=function(x)
     self.db.profile.SmartMinimize=x
     if(x) then self:ScheduleRepeatingEvent("minichat_smartminimize","MINICHAT_SMARTMINIMIZE",0.15)
     else self:CancelScheduledEvent("minichat_smartminimize") end
    end
   },
   autoMinimize={
    type='group',
    name='Auto minimize',
    desc='Minimizes the chat windows after x seconds.',
    args={
     enabled={
      type='toggle',
      name='Auto minimize',
      desc='Minimizes the chat windows automatically.',
      get=function() return self.db.profile.AutoMinimize end,
      set=function(x) self.db.profile.AutoMinimize=x end
     },
     autoMinimizeAfter={
      type='range',
      name='Auto minimize after',
      desc='Minimizes the chat windows after x seconds.',
      usage="(5-600)",
      min=5,
      max=600,
      step=1,
      bigstep=10,
      get=function() return self.db.profile.AutoMinimizeAfter end,
      set=function(x) self.db.profile.AutoMinimizeAfter=x end
     }
    }
   },
   enabledFor={
    type='group',
    name='Enabled for ...',
    desc='Lets you disable min-/maximization for your chat windows.',
    args={
     cf1={
      type='toggle',
      name='1. '..GetChatWindowInfo(1),
      desc='Enable MiniChat for the default chat window.',
      get=function() return self.db.profile.EnabledFor[1] end,
      set=function(newVal) self:SetEnabledFor(1,newVal) end,
     },
     cf2={
      type='toggle',
      name='2. '..GetChatWindowInfo(2),
      desc='Enable MiniChat for chat window 2.',
      get=function() return self.db.profile.EnabledFor[2] end,
      set=function(newVal) self:SetEnabledFor(2,newVal) end,
     },
     cf3={
      type='toggle',
      name='3. '..GetChatWindowInfo(3),
      desc='Enable MiniChat for chat window 3.',
      get=function() return self.db.profile.EnabledFor[3] end,
      set=function(newVal) self:SetEnabledFor(3,newVal) end,
     },
     cf4={
      type='toggle',
      name='4. '..GetChatWindowInfo(4),
      desc='Enable MiniChat for chat window 4.',
      get=function() return self.db.profile.EnabledFor[4] end,
      set=function(newVal) self:SetEnabledFor(4,newVal) end,
     },
     cf5={
      type='toggle',
      name='5. '..GetChatWindowInfo(5),
      desc='Enable MiniChat for chat window 5.',
      get=function() return self.db.profile.EnabledFor[5] end,
      set=function(newVal) self:SetEnabledFor(5,newVal) end,
     },
     cf6={
      type='toggle',
      name='6. '..GetChatWindowInfo(6),
      desc='Enable MiniChat for chat window 6.',
      get=function() return self.db.profile.EnabledFor[6] end,
      set=function(newVal) self:SetEnabledFor(6,newVal) end,
     },
     cf7={
      type='toggle',
      name='7. '..GetChatWindowInfo(7),
      desc='Enable MiniChat for chat window 7.',
      get=function() return self.db.profile.EnabledFor[7] end,
      set=function(newVal) self:SetEnabledFor(7,newVal) end,
     }
    }
   },
   position={
    type='group',
    name='Button positions',
    desc='Sets the positions of the MiniChat buttons.',
    args={
     button1={
      type='text',
      name='Button 1',
      desc='Sets the position of the MiniChat button 1.',
      usage="(topright|bottomright|bottomleft|topleft)",
      get=function() return self.db.profile.Position[1] end,
      set=function(newVal) self:SetPosition(1,newVal) end,
      validate={"topright","bottomright","bottomleft","topleft"}
     },
     button2={
      type='text',
      name='Button 2',
      desc='Sets the position of the MiniChat button 2.',
      usage="(topright|bottomright|bottomleft|topleft)",
      get=function() return self.db.profile.Position[2] end,
      set=function(newVal) self:SetPosition(2,newVal) end,
      validate={"topright","bottomright","bottomleft","topleft"}
     },
     button3={
      type='text',
      name='Button 3',
      desc='Sets the position of the MiniChat button 3.',
      usage="(topright|bottomright|bottomleft|topleft)",
      get=function() return self.db.profile.Position[3] end,
      set=function(newVal) self:SetPosition(3,newVal) end,
      validate={"topright","bottomright","bottomleft","topleft"}
     },
     button4={
      type='text',
      name='Button 4',
      desc='Sets the position of the MiniChat button 4.',
      usage="(topright|bottomright|bottomleft|topleft)",
      get=function() return self.db.profile.Position[4] end,
      set=function(newVal) self:SetPosition(4,newVal) end,
      validate={"topright","bottomright","bottomleft","topleft"}
     },
     button5={
      type='text',
      name='Button 5',
      desc='Sets the position of the MiniChat button 5.',
      usage="(topright|bottomright|bottomleft|topleft)",
      get=function() return self.db.profile.Position[5] end,
      set=function(newVal) self:SetPosition(5,newVal) end,
      validate={"topright","bottomright","bottomleft","topleft"}
     },
     button6={
      type='text',
      name='Button 6',
      desc='Sets the position of the MiniChat button 6.',
      usage="(topright|bottomright|bottomleft|topleft)",
      get=function() return self.db.profile.Position[6] end,
      set=function(newVal) self:SetPosition(6,newVal) end,
      validate={"topright","bottomright","bottomleft","topleft"}
     },
     button7={
      type='text',
      name='Button 7',
      desc='Sets the position of the MiniChat button 7.',
      usage="(topright|bottomright|bottomleft|topleft)",
      get=function() return self.db.profile.Position[7] end,
      set=function(newVal) self:SetPosition(7,newVal) end,
      validate={"topright","bottomright","bottomleft","topleft"}
     }
    }
   },
   chatAlpha={
    type='group',
    name='Chat Alpha',
    desc='Sets the alpha values of the chat windows for minimized and maximized states. Note: This will affect the font, too.',
    args={
     enabled={
      type='toggle',
      name='Enabled',
      desc='Enables different alpha values.',
      handler=self,
      get=function() return self.db.profile.ChatAlphaEnabled end,
      set="SetChatAlphaEnabled"
     },
     minAlpha={
      type='range',
      name='Alpha value for minimized state',
      desc='The chat windows will take on this alpha value when minimized.',
      usage="(0.0-1.0), 0=invisible, 1=opaque.",
      step=0.05,
      handler=self,
      get=function() return self.db.profile.ChatMinAlpha end,
      set="SetChatMinAlpha"
     },
     maxAlpha={
      type='range',
      name='Alpha value for maximized state',
      desc='The chat windows will take on this alpha value when maximized.',
      usage="(0.0-1.0), 0=invisible, 1=opaque.",
      step=0.05,
      handler=self,
      get=function() return self.db.profile.ChatMaxAlpha end,
      set="SetChatMaxAlpha"
     }
    }
   },
   autoMaximize={
    type='group',
    name='Auto maximize',
    desc='Maximizes the chat windows if certain message types are received. Note: This does not ignore messages from muted channels.',
    args={
     enabled={
      type='toggle',
      name='Enabled',
      desc='Enables autoMaximize.',
      get=function() return self.db.profile.AutoMaximizeEnabled end,
      set=function(x)
       self.db.profile.AutoMaximizeEnabled=x
       if(x) then self:RegisterAutoMax()
       else
        if(self:IsEventRegistered("CHAT_MSG_CHANNEL")) then self:UnregisterEvent("CHAT_MSG_CHANNEL") end
        if(self:IsEventRegistered("CHAT_MSG_OFFICER")) then self:UnregisterEvent("CHAT_MSG_OFFICER") end
        if(self:IsEventRegistered("CHAT_MSG_BG_SYSTEM_ALLIANCE")) then self:UnregisterEvent("CHAT_MSG_BG_SYSTEM_ALLIANCE") end
        if(self:IsEventRegistered("CHAT_MSG_BG_SYSTEM_HORDE")) then self:UnregisterEvent("CHAT_MSG_BG_SYSTEM_HORDE") end
        if(self:IsEventRegistered("CHAT_MSG_BG_SYSTEM_NEUTRAL")) then self:UnregisterEvent("CHAT_MSG_BG_SYSTEM_NEUTRAL") end
        if(self:IsEventRegistered("CHAT_MSG_BATTLEGROUND")) then self:UnregisterEvent("CHAT_MSG_BATTLEGROUND") end
        if(self:IsEventRegistered("CHAT_MSG_BATTLEGROUND_LEADER")) then self:UnregisterEvent("CHAT_MSG_BATTLEGROUND_LEADER") end
        if(self:IsEventRegistered("CHAT_MSG_PARTY")) then self:UnregisterEvent("CHAT_MSG_PARTY") end
        if(self:IsEventRegistered("CHAT_MSG_RAID")) then self:UnregisterEvent("CHAT_MSG_RAID") end
        if(self:IsEventRegistered("CHAT_MSG_RAID_LEADER")) then self:UnregisterEvent("CHAT_MSG_RAID_LEADER") end
        if(self:IsEventRegistered("CHAT_MSG_GUILD")) then self:UnregisterEvent("CHAT_MSG_GUILD") end
        if(self:IsEventRegistered("CHAT_MSG_SAY")) then self:UnregisterEvent("CHAT_MSG_SAY") end
        if(self:IsEventRegistered("CHAT_MSG_SYSTEM")) then self:UnregisterEvent("CHAT_MSG_SYSTEM") end
        if(self:IsEventRegistered("CHAT_MSG_WHISPER")) then self:UnregisterEvent("CHAT_MSG_WHISPER") end
        if(self:IsEventRegistered("CHAT_MSG_WHISPER_INFORM")) then self:UnregisterEvent("CHAT_MSG_WHISPER_INFORM") end
        if(self:IsEventRegistered("CHAT_MSG_LOOT")) then self:UnregisterEvent("CHAT_MSG_LOOT") end
        if(self:IsEventRegistered("CHAT_MSG_YELL")) then self:UnregisterEvent("CHAT_MSG_YELL") end
        if(self:IsEventRegistered("PLAYER_REGEN_ENABLED")) then self:UnregisterEvent("PLAYER_REGEN_ENABLED") end
       end
      end
     },
     ignoreSelf={
      type='toggle',
      name='Ignore your messages',
      desc='Don\'t maximize if messages are sent by you.',
      get=function() return self.db.profile.AutoMaximizeIgnoreSelf end,
      set=function(x)
       self.db.profile.AutoMaximizeIgnoreSelf=x
       if(x) then self:RegisterEvent("PLAYER_REGEN_ENABLED")
       else
        if(self:IsEventRegistered("PLAYER_REGEN_ENABLED")) then self:UnregisterEvent("PLAYER_REGEN_ENABLED") end
       end
      end
     },
     ignoreIfInCombat={
      type='toggle',
      name='Suppress maximization while in combat.',
      desc='Chat won\'t maximize while in combat but maximization will be scheduled if important events happen during combat.',
      get=function() return self.db.profile.AutoMaximizeIgnoreIfInCombat end,
      set=function(x) self.db.profile.AutoMaximizeIgnoreIfInCombat=x end
     },
     onLoot={
      type='toggle',
      name='on loot',
      desc='Maximizes the chat windows when someone receives loot. This will maximize all chat windows',
      get=function() return self.db.profile.AutoMaximizeOnLoot end,
      set=function(x)
       self.db.profile.AutoMaximizeOnLoot=x
       if(x) then self:RegisterEvent("CHAT_MSG_LOOT")
       else
        if(self:IsEventRegistered("CHAT_MSG_LOOT")) then self:UnregisterEvent("CHAT_MSG_LOOT") end
       end
      end
     },
     onYell={
      type='toggle',
      name='on yell',
      desc='Maximizes the chat windows when a yell (/y) is received.',
      get=function() return self.db.profile.AutoMaximizeOnYell end,
      set=function(x)
       self.db.profile.AutoMaximizeOnYell=x
       if(x) then self:RegisterEvent("CHAT_MSG_YELL")
       else
        if(self:IsEventRegistered("CHAT_MSG_YELL")) then self:UnregisterEvent("CHAT_MSG_YELL") end
       end
      end
     },
     onSay={
      type='toggle',
      name='on say',
      desc='Maximizes the chat windows whenever a message (/s) is received.',
      get=function() return self.db.profile.AutoMaximizeOnSay end,
      set=function(x)
       self.db.profile.AutoMaximizeOnSay=x
       if(x) then self:RegisterEvent("CHAT_MSG_SAY")
       else
        if(self:IsEventRegistered("CHAT_MSG_SAY")) then self:UnregisterEvent("CHAT_MSG_SAY") end
       end
      end
     },
     onSystem={
      type='toggle',
      name='on system',
      desc='Maximizes the chat windows whenever a system message (server shutdown, friends etc.) is received.',
      get=function() return self.db.profile.AutoMaximizeOnSystem end,
      set=function(x)
       self.db.profile.AutoMaximizeOnSystem=x
       if(x) then self:RegisterEvent("CHAT_MSG_SYSTEM")
       else
        if(self:IsEventRegistered("CHAT_MSG_SYSTEM")) then self:UnregisterEvent("CHAT_MSG_SYSTEM") end
       end
      end
     },
     onWhisper={
      type='toggle',
      name='on whisper',
      desc='Maximizes the chat windows whenever a whisper (/w) is received.',
      get=function() return self.db.profile.AutoMaximizeOnWhisper end,
      set=function(x)
       self.db.profile.AutoMaximizeOnWhisper=x
       if(x) then
        self:RegisterEvent("CHAT_MSG_WHISPER")
        self:RegisterEvent("CHAT_MSG_WHISPER_INFORM")
       else
        if(self:IsEventRegistered("CHAT_MSG_WHISPER")) then self:UnregisterEvent("CHAT_MSG_WHISPER") end
        if(self:IsEventRegistered("CHAT_MSG_WHISPER_INFORM")) then self:UnregisterEvent("CHAT_MSG_WHISPER_INFORM") end
       end
      end
     },
     onGuild={
      type='toggle',
      name='on guild',
      desc='Maximizes the chat windows whenever a guild message (/g) is received.',
      get=function() return self.db.profile.AutoMaximizeOnGuild end,
      set=function(x)
       self.db.profile.AutoMaximizeOnGuild=x
       if(x) then self:RegisterEvent("CHAT_MSG_GUILD")
       else
        if(self:IsEventRegistered("CHAT_MSG_GUILD")) then self:UnregisterEvent("CHAT_MSG_GUILD") end
       end
      end
     },
     onParty={
      type='toggle',
      name='on party',
      desc='Maximizes the chat windows whenever a party message (/p) is received.',
      get=function() return self.db.profile.AutoMaximizeOnParty end,
      set=function(x)
       self.db.profile.AutoMaximizeOnParty=x
       if(x) then self:RegisterEvent("CHAT_MSG_PARTY")
       else
        if(self:IsEventRegistered("CHAT_MSG_PARTY")) then self:UnregisterEvent("CHAT_MSG_PARTY") end
       end
      end
     },
     onRaid={
      type='toggle',
      name='on raid',
      desc='Maximizes the chat windows whenever a raid message (/ra) is received.',
      get=function() return self.db.profile.AutoMaximizeOnRaid end,
      set=function(x)
       self.db.profile.AutoMaximizeOnRaid=x
       if(x) then
        self:RegisterEvent("CHAT_MSG_RAID")
        self:RegisterEvent("CHAT_MSG_RAID_LEADER")
       else
        if(self:IsEventRegistered("CHAT_MSG_RAID")) then self:UnregisterEvent("CHAT_MSG_RAID") end
        if(self:IsEventRegistered("CHAT_MSG_RAID_LEADER")) then self:UnregisterEvent("CHAT_MSG_RAID_LEADER") end
       end
      end
     },
     onBattleground={
      type='toggle',
      name='on battleground',
      desc='Maximizes the chat windows whenever a battleground message (/bg or battleground system message) is received.',
      get=function() return self.db.profile.AutoMaximizeOnBattleground end,
      set=function(x)
       self.db.profile.AutoMaximizeOnBattleground=x
       if(x) then
        self:RegisterEvent("CHAT_MSG_BG_SYSTEM_ALLIANCE")
        self:RegisterEvent("CHAT_MSG_BG_SYSTEM_HORDE")
        self:RegisterEvent("CHAT_MSG_BG_SYSTEM_NEUTRAL")
        self:RegisterEvent("CHAT_MSG_BATTLEGROUND")
        self:RegisterEvent("CHAT_MSG_BATTLEGROUND_LEADER")
       else
        if(self:IsEventRegistered("CHAT_MSG_BG_SYSTEM_ALLIANCE")) then self:UnregisterEvent("CHAT_MSG_BG_SYSTEM_ALLIANCE") end
        if(self:IsEventRegistered("CHAT_MSG_BG_SYSTEM_HORDE")) then self:UnregisterEvent("CHAT_MSG_BG_SYSTEM_HORDE") end
        if(self:IsEventRegistered("CHAT_MSG_BG_SYSTEM_NEUTRAL")) then self:UnregisterEvent("CHAT_MSG_BG_SYSTEM_NEUTRAL") end
        if(self:IsEventRegistered("CHAT_MSG_BATTLEGROUND")) then self:UnregisterEvent("CHAT_MSG_BATTLEGROUND") end
        if(self:IsEventRegistered("CHAT_MSG_BATTLEGROUND_LEADER")) then self:UnregisterEvent("CHAT_MSG_BATTLEGROUND_LEADER") end
       end
      end
     },
     onOfficer={
      type='toggle',
      name='on officer',
      desc='Maximizes the chat windows whenever an officer message (/o) is received.',
      get=function() return self.db.profile.AutoMaximizeOnOfficer end,
      set=function(x)
       self.db.profile.AutoMaximizeOnOfficer=x
       if(x) then self:RegisterEvent("CHAT_MSG_OFFICER")
       else
        if(self:IsEventRegistered("CHAT_MSG_OFFICER")) then self:UnregisterEvent("CHAT_MSG_OFFICER") end
       end
      end
     },
     onChannel={
      type='group',
      name='on channel',
      desc='Maximizes the chat windows whenever a message is received in custom channels.',
      args={
       channel01={
        type='toggle',
        name='01: '..tostring(chan[1]),
        desc='Enables autoMaximize for channel01. This will maximize all chat windows',
        get=function() return self.db.profile.AutoMaximizeOnChannel[1] end,
        set=function(newVal) self:SetAutoMaximizeOnChannel(1,newVal) end
       },
       channel02={
        type='toggle',
        name='02: '..tostring(chan[2]),
        desc='Enables autoMaximize for channel02. This will maximize all chat windows',
        get=function() return self.db.profile.AutoMaximizeOnChannel[2] end,
        set=function(newVal) self:SetAutoMaximizeOnChannel(2,newVal) end
       },
       channel03={
        type='toggle',
        name='03: '..tostring(chan[3]),
        desc='Enables autoMaximize for channel03. This will maximize all chat windows',
        get=function() return self.db.profile.AutoMaximizeOnChannel[3] end,
        set=function(newVal) self:SetAutoMaximizeOnChannel(3,newVal) end
       },
       channel04={
        type='toggle',
        name='04: '..tostring(chan[4]),
        desc='Enables autoMaximize for channel04',
        get=function() return self.db.profile.AutoMaximizeOnChannel[4] end,
        set=function(newVal) self:SetAutoMaximizeOnChannel(4,newVal) end
       },
       channel05={
        type='toggle',
        name='05: '..tostring(chan[5]),
        desc='Enables autoMaximize for channel05',
        get=function() return self.db.profile.AutoMaximizeOnChannel[5] end,
        set=function(newVal) self:SetAutoMaximizeOnChannel(5,newVal) end
       },
       channel06={
        type='toggle',
        name='06: '..tostring(chan[6]),
        desc='Enables autoMaximize for channel06',
        get=function() return self.db.profile.AutoMaximizeOnChannel[6] end,
        set=function(newVal) self:SetAutoMaximizeOnChannel(6,newVal) end
       },
       channel07={
        type='toggle',
        name='07: '..tostring(chan[7]),
        desc='Enables autoMaximize for channel07',
        get=function() return self.db.profile.AutoMaximizeOnChannel[7] end,
        set=function(newVal) self:SetAutoMaximizeOnChannel(7,newVal) end
       },
       channel08={
        type='toggle',
        name='08: '..tostring(chan[8]),
        desc='Enables autoMaximize for channel08',
        get=function() return self.db.profile.AutoMaximizeOnChannel[8] end,
        set=function(newVal) self:SetAutoMaximizeOnChannel(8,newVal) end
       },
       channel09={
        type='toggle',
        name='09: '..tostring(chan[9]),
        desc='Enables autoMaximize for channel09',
        get=function() return self.db.profile.AutoMaximizeOnChannel[9] end,
        set=function(newVal) self:SetAutoMaximizeOnChannel(9,newVal) end
       },
       channel10={
        type='toggle',
        name='10: '..tostring(chan[10]),
        desc='Enables autoMaximize for channel10',
        get=function() return self.db.profile.AutoMaximizeOnChannel[10] end,
        set=function(newVal) self:SetAutoMaximizeOnChannel(10,newVal) end
       }
      }
     }
    }
   }
  }
 }
 self:RegisterChatCommand({"/mc","/minichat"}, slashOpts)
 if AceLibrary:HasInstance("Waterfall-1.0") then
  AceLibrary("Waterfall-1.0"):Register('MiniChat GUI','aceOptions',slashOpts,'title')
  self:RegisterChatCommand({"/mc","/minichat"}, function() AceLibrary("Waterfall-1.0"):Open('MiniChat GUI') end)
 elseif AceLibrary:HasInstance("Dewdrop-2.0") then
  self:RegisterChatCommand({"/mc","/minichat"}, function()
   AceLibrary("Dewdrop-2.0"):Open('MiniChat','children',function() AceLibrary("Dewdrop-2.0"):FeedAceOptionsTable(slashOpts) end)
  end)
 end
end

function MiniChat:FCF_OnUpdate()
 for i=1,NUM_CHAT_WINDOWS do
  if(MouseIsOver(getglobal("ChatFrame"..i)) and not mouseWasOverChatWindow[i]) then
   mouseWasOverChatWindow[i]=true
   if(self.db.profile.MaximizeOnMouseOver and self.db.profile.Minimized[i]) then
    self:MiniMax(i)
   end
  end
  if(mouseWasOverChatWindow[i] and not MouseIsOver(getglobal("ChatFrame"..i))) then
   mouseWasOverChatWindow[i]=false
   if(self.db.profile.MinimizeOnMouseOut and not self.db.profile.Minimized[i]) then
    self:MiniMax(i)
   end
  end
 end
end

function MiniChat:FCF_ValidateChatFramePosition(chatFrame)
 local i=tonumber(string.sub(chatFrame:GetName(),10))
 self.db.profile.ChatLeft[i]=chatFrame:GetLeft()
 self.db.profile.ChatBottom[i]=chatFrame:GetBottom()
end

local MiniB={}
for i=1,NUM_CHAT_WINDOWS do
 MiniB[i]=CreateFrame("Button",nil,UIParent)
end

function MiniChat:OnInitialize()
 for i=1,10 do
  local _,channelname=GetChannelName(i)
  if(channelname==nil) then
   chan[i]="-"
  else
   chan[i]=channelname
  end
 end
 self:UpdateOptions()
end

function MiniChat:OnDisable()
 for i=1,NUM_CHAT_WINDOWS do MiniB[i]:Hide() end
 if(self:IsHooked("FCF_ValidateChatFramePosition")) then self:Unhook("FCF_ValidateChatFramePosition") end
 if(self:IsHooked("FCF_OnUpdate")) then  self:Unhook("FCF_OnUpdate") end
end

function MiniChat:OnEnable()
 self:Clamping()

 self:Hook("FCF_ValidateChatFramePosition",true)
 if(self.db.profile.MaximizeOnMouseOver or self.db.profile.MinimizeOnMouseOut) then
  self:SecureHook("FCF_OnUpdate")
 end

 for i=1,NUM_CHAT_WINDOWS do
  channelsRcvdByWindow[i]={GetChatWindowChannels(getglobal("ChatFrame"..i):GetID())}
  msgsRcvdByWindow[i]={GetChatWindowMessages(getglobal("ChatFrame"..i):GetID())}
  lower[i]=self:GetLastMsgHeight(i)
 end

 for i=1,NUM_CHAT_WINDOWS do
  MiniB[i]:SetFrameStrata("High")
  MiniB[i]:SetWidth(15*self.db.profile.Scale)
  MiniB[i]:SetHeight(15*self.db.profile.Scale)
  MiniB[i]:SetAlpha(self.db.profile.Alpha)
  self:UpdateButtonTexture(i)
 end

 self:RegisterEvent("MINICHAT_SMARTMINIMIZE")
 self:RegisterEvent("MINICHAT_SMOOTHING")
 if(self.db.profile.AutoMinimize) then self:RegisterEvent("MINICHAT_AUTOMINIMIZE") end
 self:RegisterEvent("CHAT_MSG_CHANNEL_NOTICE")
 self:RegisterAutoMax()

 if(self.db.profile.Direction=="down") then
  for i=1,NUM_CHAT_WINDOWS do
   if(self.db.profile.IsAttachedToTop[i]==0) then
    getglobal("ChatFrame"..i):ClearAllPoints()
    getglobal("ChatFrame"..i):SetPoint("BOTTOMLEFT",UIParent,"BOTTOMLEFT",self.db.profile.ChatLeft[i],self.db.profile.ChatBottom[i])
   else
    self:Attach(i,self.db.profile.IsAttachedToTop[i])
   end
  end
 else
  for i=1,NUM_CHAT_WINDOWS do
   getglobal("ChatFrame"..i):ClearAllPoints()
   getglobal("ChatFrame"..i):SetPoint("TOPLEFT",UIParent,"TOPLEFT",self.db.profile.ChatLeft[i],self.db.profile.ChatBottom[i]+self.db.profile.ChatHeight[i]-GetScreenHeight())
  end
 end
  
 if(self.db.profile.MinimizeOnStart and not self.db.profile.Minimized[i]) then
  self:MiniMax(i)
 end

 for i=1,NUM_CHAT_WINDOWS do
  if(self.db.profile.Position[i]=="custom") then
   MiniB[i]:SetPoint("TOPLEFT",UIParent,"BOTTOMLEFT",self.db.profile.CustomX[i],self.db.profile.CustomY[i])
  else
   MiniB[i]:SetPoint(self.db.profile.Position[i],getglobal("ChatFrame"..i),self.db.profile.Position[i])
  end
  MiniB[i]:SetMovable(true)
  if(getglobal("ChatFrame"..i):IsVisible()==1 and self.db.profile.EnabledFor[i]) then
   MiniB[i]:Show()
  else
   MiniB[i]:Hide()
  end
  MiniB[i]:RegisterForClicks("LeftButtonUp","RightButtonUp","MiddleButtonUp")
 end

 if(self.db.profile.SmartMinimize) then self:ScheduleRepeatingEvent("minichat_smartminimize","MINICHAT_SMARTMINIMIZE",0.15) end

 for i=1,NUM_CHAT_WINDOWS do
  -- MouseDown on button
  MiniB[i]:SetScript("OnMouseDown",function()
   if(self.db.profile.Unlock) then
    MiniB[i]:StartMoving()
    self.db.profile.Position[i]="custom"
   end
  end)
   -- MouseUp on button
  MiniB[i]:SetScript("OnMouseUp",function()
   MiniB[i]:StopMovingOrSizing()
   self.db.profile.CustomX[i]=MiniB[i]:GetLeft()
   self.db.profile.CustomY[i]=MiniB[i]:GetTop()
  end)
 end

 for i=1,NUM_CHAT_WINDOWS do
  -- Button clicked
  MiniB[i]:SetScript("OnClick",function()
   if(arg1=="MiddleButton") then
    locked[i]=not locked[i]
    self:UpdateButtonTexture(i)
   elseif(arg1=="RightButton") then
    if(not AceLibrary:HasInstance("Dewdrop-2.0")) then
     self:Print("Dewdrop-2.0 has to be installed and enabled.")
     return
    end
    local menu={}
    menu[1]={
     text="Attach to top of ...",
     isTitle=true
    }
    for j=1,NUM_CHAT_WINDOWS do    
     if(i~=j) then
      local name,_,_,_,_,_,shown=GetChatWindowInfo(j)
      menu[j+1]={
       text=j..". "..name,
       disabled=not shown,
       func=function() self:Attach(i,j) end
      }
     end
    end
    menu[NUM_CHAT_WINDOWS+2]={
     text="None (unattach)",
     disabled=(self.db.profile.IsAttachedToTop[i]==0),
     func=function() self:Unattach(i) end
    }
    dewdrop:Register(MiniB[i],'children',function() dewdrop:FeedTable(menu) end)
    dewdrop:Open(MiniB[i])
   elseif(arg1=="LeftButton") then
    self:MiniMax(i)
   end
  end)
 end

 for i=1,NUM_CHAT_WINDOWS do
  -- Mouse leaves button 
  MiniB[i]:SetScript("OnLeave",function()
   MiniB[i]:SetAlpha(self.db.profile.Alpha)
  end)
   -- Mouse is moved over button
  MiniB[i]:SetScript("OnEnter",function()
   MiniB[i]:SetAlpha(1)
  end)
 end
end

function MiniChat:GetLastMsgHeight(i)
 if(not self.db.profile.SmartMinimize) then
  local _,fontheight=getglobal("ChatFrame"..i):GetFont()
  return fontheight*self.db.profile.LinesWhenMinimized
 end
 local newSize=0
 local lines={getglobal("ChatFrame"..i):GetRegions()}
 for j=2,self.db.profile.LinesWhenMinimized+1 do
  if(lines[j]) then newSize=newSize+lines[j]:GetHeight() end
 end
 --lines=nil
 if(newSize>0) then
  return newSize
 else
  local _,fontheight=getglobal("ChatFrame"..i):GetFont()
  return fontheight*self.db.profile.LinesWhenMinimized
 end
end

function MiniChat:RegisterAutoMax()
 for i=0,NUM_CHAT_WINDOWS do
  if(self.db.profile.AutoMaximizeOnChannel[i]) then
   self:RegisterEvent("CHAT_MSG_CHANNEL")
   break
  end
 end
 if(self.db.profile.AutoMaximizeOnOfficer) then self:RegisterEvent("CHAT_MSG_OFFICER") end
 if(self.db.profile.AutoMaximizeOnBattleground) then
  self:RegisterEvent("CHAT_MSG_BG_SYSTEM_ALLIANCE")
  self:RegisterEvent("CHAT_MSG_BG_SYSTEM_HORDE")
  self:RegisterEvent("CHAT_MSG_BG_SYSTEM_NEUTRAL")
  self:RegisterEvent("CHAT_MSG_BATTLEGROUND")
  self:RegisterEvent("CHAT_MSG_BATTLEGROUND_LEADER")
 end
 if(self.db.profile.AutoMaximizeOnParty) then self:RegisterEvent("CHAT_MSG_PARTY") end
 if(self.db.profile.AutoMaximizeOnRaid) then
  self:RegisterEvent("CHAT_MSG_RAID")
  self:RegisterEvent("CHAT_MSG_RAID_LEADER")
 end
 if(self.db.profile.AutoMaximizeOnGuild) then self:RegisterEvent("CHAT_MSG_GUILD") end
 if(self.db.profile.AutoMaximizeOnSay) then self:RegisterEvent("CHAT_MSG_SAY") end
 if(self.db.profile.AutoMaximizeOnSystem) then self:RegisterEvent("CHAT_MSG_SYSTEM") end
 if(self.db.profile.AutoMaximizeOnWhisper) then
  self:RegisterEvent("CHAT_MSG_WHISPER")
  self:RegisterEvent("CHAT_MSG_WHISPER_INFORM")
 end
 if(self.db.profile.AutoMaximizeOnLoot) then self:RegisterEvent("CHAT_MSG_LOOT") end
 if(self.db.profile.AutoMaximizeOnYell) then self:RegisterEvent("CHAT_MSG_YELL") end
 if(self.db.profile.AutoMaximizeIgnoreIfInCombat) then self:RegisterEvent("PLAYER_REGEN_ENABLED") end
end

function MiniChat:Clamping()
 for i=1,NUM_CHAT_WINDOWS do getglobal("ChatFrame"..i):SetClampedToScreen(self.db.profile.ClampToScreen) end
end

function MiniChat:UpdateButtonTexture(i)
 if(locked[i]) then
  MiniB[i]:SetNormalTexture("Interface\\Addons\\MiniChat\\textures\\button-locked.tga")
  MiniB[i]:SetPushedTexture("Interface\\Addons\\MiniChat\\textures\\button-locked.tga")
  return
 end
 if(self.db.profile.Minimized[i] and self.db.profile.Direction=="down" or
    not self.db.profile.Minimized[i] and self.db.profile.Direction=="up") then
  MiniB[i]:SetNormalTexture("Interface\\Addons\\MiniChat\\textures\\button-up.tga")
  MiniB[i]:SetPushedTexture("Interface\\Addons\\MiniChat\\textures\\button-up-pushed.tga")
 else
  MiniB[i]:SetNormalTexture("Interface\\Addons\\MiniChat\\textures\\button-down.tga")
  MiniB[i]:SetPushedTexture("Interface\\Addons\\MiniChat\\textures\\button-down-pushed.tga")
 end
end

function MiniChat:Unattach(i)
 self.db.profile.IsAttachedToTop[i]=0
 getglobal("ChatFrame"..i):ClearAllPoints()
 getglobal("ChatFrame"..i):SetPoint("BOTTOMLEFT",UIParent,"BOTTOMLEFT",self.db.profile.ChatLeft[i],self.db.profile.ChatBottom[i])
end
function MiniChat:IsAttachedTo(j,i)
 local _,_,_,_,_,_,_,_,docked=GetChatWindowInfo(j)
 if(docked==nil) then docked=0 end
 if(self.db.profile.IsAttachedToTop[j]==i or docked>1) then
  return true
 end
 for k=1,NUM_CHAT_WINDOWS do
  if(self.db.profile.IsAttachedToTop[k]==i) then
   if(self:IsAttachedTo(j,k)) then
    return true
   end
  end
 end
 return false
end
function MiniChat:Attach(i,j)
 if(i==1) then self:Print("Can\'t attach the default chat window to something.") return
 elseif(self:IsAttachedTo(j,i)) then self:Print("Can\'t attach chat window because of dependencies.") return
 elseif(self.db.profile.Direction=="up") then self:Print("Can\'t attach chat window when Direction is set to \"up\".") return end
 getglobal("ChatFrame"..i):ClearAllPoints()
 getglobal("ChatFrame"..i):SetPoint("BOTTOMLEFT",getglobal("ChatFrame"..j),"TOPLEFT",0,10+self.db.profile.Padding)
 getglobal("ChatFrame"..i):SetPoint("BOTTOMRIGHT",getglobal("ChatFrame"..j),"TOPRIGHT",0,10+self.db.profile.Padding)
 self.db.profile.IsAttachedToTop[i]=j
end

function MiniChat:UpdateChatAlpha(i)
 local _,_,_,_,_,_,_,_,docked=GetChatWindowInfo(i)
 local j=i
 if(docked) then j=1 end
 if(self.db.profile.ChatAlphaEnabled) then
  getglobal("ChatFrame"..i):SetAlpha(
   (getglobal("ChatFrame"..j):GetHeight()-lower[i])/(self.db.profile.ChatHeight[j]-lower[i])*self.db.profile.ChatMaxAlpha
   +
   (1.0-(getglobal("ChatFrame"..j):GetHeight()-lower[i])/(self.db.profile.ChatHeight[j]-lower[i]))*self.db.profile.ChatMinAlpha
  )
 end
end

function MiniChat:ScanTable(string,table)
 for i=1,#table do
  if(string==table[i]) then
   return true
  end
 end
 return false
end

function MiniChat:SetDirection(newDirection)
 self.db.profile.Direction=newDirection
 if(newDirection=="up") then
  for i=1,NUM_CHAT_WINDOWS do
   local _,_,_,_,_,_,_,_,docked=GetChatWindowInfo(i)
   if(not docked) then
    self:Unattach(i)
    local tmp=getglobal("ChatFrame"..i):GetHeight()
    getglobal("ChatFrame"..i):ClearAllPoints()
    getglobal("ChatFrame"..i):SetPoint("TOPLEFT",UIParent,"TOPLEFT",self.db.profile.ChatLeft[i],-GetScreenHeight()+self.db.profile.ChatBottom[i]+tmp)
   end
  end
 else
  for i=1,NUM_CHAT_WINDOWS do
   local _,_,_,_,_,_,_,_,docked=GetChatWindowInfo(i)
   if(not docked) then
    getglobal("ChatFrame"..i):ClearAllPoints()
    getglobal("ChatFrame"..i):SetPoint("BOTTOMLEFT",UIParent,"BOTTOMLEFT",self.db.profile.ChatLeft[i],self.db.profile.ChatBottom[i])
   end
  end
 end
end

function MiniChat:SetAlpha(newAlpha)
 self.db.profile.Alpha=newAlpha
 for i=1,NUM_CHAT_WINDOWS do
  MiniB[i]:SetAlpha(newAlpha)
 end
end

function MiniChat:SetEnabledFor(i,newEnabledFor)
 self.db.profile.EnabledFor[i]=newEnabledFor
 if(newEnabledFor and getglobal("ChatFrame"..i):IsVisible()) then
  MiniB[i]:Show()
 else
  MiniB[i]:Hide()
 end
end

function MiniChat:SetPadding(newPadding)
 self.db.profile.Padding=newPadding
 if(self.db.profile.Direction=="down") then 
  for i=1,NUM_CHAT_WINDOWS do
   if(self.db.profile.IsAttachedToTop[i]>0) then
    self:Attach(i,self.db.profile.IsAttachedToTop[i])
   end
  end
 end
end

function MiniChat:SetChatAlphaEnabled(newChatAlphaEnabled)
 self.db.profile.ChatAlphaEnabled=newChatAlphaEnabled
 if(newChatAlphaEnabled) then
  for i=1,NUM_CHAT_WINDOWS do
   if(self.db.profile.Minimized[i]) then
    getglobal("ChatFrame"..i):SetAlpha(self.db.profile.ChatMinAlpha)
   else
    getglobal("ChatFrame"..i):SetAlpha(self.db.profile.ChatMaxAlpha)
   end
  end 
 end
end
function MiniChat:SetChatMinAlpha(newChatMinAlpha)
 self.db.profile.ChatMinAlpha=newChatMinAlpha
 for i=1,NUM_CHAT_WINDOWS do
  if(self.db.profile.ChatAlphaEnabled and self.db.profile.Minimized[i]) then
   getglobal("ChatFrame"..i):SetAlpha(newChatMinAlpha)
  end
 end
end
function MiniChat:SetChatMaxAlpha(newChatMaxAlpha)
 self.db.profile.ChatMaxAlpha=newChatMaxAlpha
 for i=1,NUM_CHAT_WINDOWS do
  if(self.db.profile.ChatAlphaEnabled and not self.db.profile.Minimized[i]) then
   getglobal("ChatFrame"..i):SetAlpha(newChatMaxAlpha)
  end
 end
end


function MiniChat:SetScale(newScale)
 self.db.profile.Scale=newScale
 for i=1,NUM_CHAT_WINDOWS do
  MiniB[i]:SetWidth(15*newScale)
  MiniB[i]:SetHeight(15*newScale)
 end
end


function MiniChat:SetClampToScreen(newClampToScreen)
 self.db.profile.ClampToScreen=newClampToScreen
 self:Clamping()
end


function MiniChat:SetPosition(i,newPosition)
 self.db.profile.Unlock=false
 self.db.profile.Position[i]=newPosition
 MiniB[i]:ClearAllPoints()
 MiniB[i]:SetPoint(newPosition,getglobal("ChatFrame"..i),newPosition)
end

function MiniChat:SetMaximizeOnMouseOver(newMaximizeOnMouseOver)
 self.db.profile.MaximizeOnMouseOver=newMaximizeOnMouseOver
 if(newMaximizeOnMouseOver and not self:IsHooked("FCF_OnUpdate")) then
  self:SecureHook("FCF_OnUpdate")
 end
end
function MiniChat:SetMinimizeOnMouseOut(newMinimizeOnMouseOut)
 self.db.profile.MinimizeOnMouseOut=newMinimizeOnMouseOut
 if(newMinimizeOnMouseOut and not self:IsHooked("FCF_OnUpdate")) then
  self:SecureHook("FCF_OnUpdate")
 end
end

function MiniChat:SetAutoMaximizeOnChannel(i,newAutoMaximizeOnChannel)
 self.db.profile.AutoMaximizeOnChannel[i]=newAutoMaximizeOnChannel
 if(newAutoMaximizeOnChannel and not self:IsEventRegistered("CHAT_MSG_CHANNEL")) then self:RegisterEvent("CHAT_MSG_CHANNEL") end
end


function MiniChat:MiniMax(i)
 if(not self.db.profile.EnabledFor[i] or locked[i]) then return end
 local _,_,_,_,_,_,_,_,docked=GetChatWindowInfo(i)
 if(docked==nil) then docked=0 end
 if(animating[i] or docked>1) then
  return
 end
 lower[i]=self:GetLastMsgHeight(i)
 if(not self.db.profile.Minimized[i]) then -- maximized
  self.db.profile.ChatHeight[i]=getglobal("ChatFrame"..i):GetHeight()
  if(self.db.profile.AnimationSpeed==0) then
   getglobal("ChatFrame"..i):SetHeight(lower[i])
   self:UpdateChatAlpha(i)
  end
  self:CancelScheduledEvent("minichatautominimize"..i)
 else -- minimized
  if(self.db.profile.AnimationSpeed==0) then
   getglobal("ChatFrame"..i):SetHeight(self.db.profile.ChatHeight[i])
   self:UpdateChatAlpha(i)
  end
  if(self.db.profile.AutoMinimize) then
   self:ScheduleEvent("minichatautominimize"..i,"MINICHAT_AUTOMINIMIZE",self.db.profile.AutoMinimizeAfter,i)
  end
 end
 if(self.db.profile.Direction=="down") then
  getglobal("ChatFrame"..i):ClearAllPoints()
  if(self.db.profile.IsAttachedToTop[i]==0) then
   getglobal("ChatFrame"..i):SetPoint("BOTTOMLEFT",UIParent,"BOTTOMLEFT",self.db.profile.ChatLeft[i],self.db.profile.ChatBottom[i])
  else
   self:Attach(i,self.db.profile.IsAttachedToTop[i])
  end
 else
  getglobal("ChatFrame"..i):ClearAllPoints()
  getglobal("ChatFrame"..i):SetPoint("TOPLEFT",UIParent,"TOPLEFT",self.db.profile.ChatLeft[i],self.db.profile.ChatBottom[i]+self.db.profile.ChatHeight[i]-GetScreenHeight())
 end
 if(self.db.profile.AnimationSpeed>0) then
  self:ScheduleEvent("minichatsmoothing"..i,"MINICHAT_SMOOTHING",0,i,self.db.profile.Minimized[i])
 else
  self.db.profile.Minimized[i]=not self.db.profile.Minimized[i]
  getglobal("ChatFrame"..i):ScrollDown()
  self:UpdateButtonTexture(i)
 end
end

function MiniChat:CHAT_MSG_CHANNEL_NOTICE()
 if(arg1=="YOU_JOINED") then
  chan[arg8]=arg9
 else -- "YOU_LEFT"
  local _,channelname=GetChannelName(arg8)
  if(channelname==nil) then
   chan[arg8]="-"
  else
   chan[arg8]=arg9
  end
 end
 self:UpdateOptions()
end

function MiniChat:PLAYER_REGEN_ENABLED()
 if(maximizeAfterCombat) then
  maximizeAfterCombat=false
  for i=1,NUM_CHAT_WINDOWS do
   if(self.db.profile.Minimized[i]) then
    self:MiniMax(i)
   end
  end
 end
end

function MiniChat:CHAT_MSG_CHANNEL(_,author,_,_,_,_,_,nr)
 if(self.db.profile.AutoMaximizeIgnoreSelf and author==UnitName("player")) then return end
 local _,channelname=GetChannelName(nr)
 for i=1,NUM_CHAT_WINDOWS do
  if(self.db.profile.AutoMaximizeOnChannel[nr] and (self:ScanTable(channelname,channelsRcvdByWindow[i]) or nr<4)) then
   self:CatchMessage(i)
  end
 end
end
function MiniChat:CHAT_MSG_LOOT()
 for i=1,NUM_CHAT_WINDOWS do self:CatchMessage(i) end
end
function MiniChat:CHAT_MSG_YELL(_,author)
 if(self.db.profile.AutoMaximizeIgnoreSelf and author==UnitName("player")) then return end
 for i=1,NUM_CHAT_WINDOWS do
  if(self:ScanTable("YELL",msgsRcvdByWindow[i])) then
   self:CatchMessage(i)
  end
 end
end
function MiniChat:CHAT_MSG_SAY(_,author)
 if(self.db.profile.AutoMaximizeIgnoreSelf and author==UnitName("player")) then return end
 for i=1,NUM_CHAT_WINDOWS do
  if(self:ScanTable("SAY",msgsRcvdByWindow[i])) then
   self:CatchMessage(i)
  end
 end
end
function MiniChat:CHAT_MSG_SYSTEM()
 for i=1,NUM_CHAT_WINDOWS do
  if(self:ScanTable("SYSTEM",msgsRcvdByWindow[i])) then
   self:CatchMessage(i)
  end
 end
end
function MiniChat:CHAT_MSG_WHISPER(_,author)
 if(self.db.profile.AutoMaximizeIgnoreSelf and author==UnitName("player")) then return end
 for i=1,NUM_CHAT_WINDOWS do
  if(self:ScanTable("WHISPER",msgsRcvdByWindow[i])) then
   self:CatchMessage(i)
  end
 end
end
function MiniChat:CHAT_MSG_WHISPER_INFORM()
 if(self.db.profile.AutoMaximizeIgnoreSelf) then
  return
 end
 for i=1,NUM_CHAT_WINDOWS do
  if(self:ScanTable("WHISPER",msgsRcvdByWindow[i])) then
   self:CatchMessage(i)
  end
 end
end
function MiniChat:CHAT_MSG_GUILD(_,author)
 if(self.db.profile.AutoMaximizeIgnoreSelf and author==UnitName("player")) then return end
 for i=1,NUM_CHAT_WINDOWS do
  if(self:ScanTable("GUILD",msgsRcvdByWindow[i])) then
   self:CatchMessage(i)
  end
 end
end
function MiniChat:CHAT_MSG_PARTY(_,author)
 if(self.db.profile.AutoMaximizeIgnoreSelf and author==UnitName("player")) then return end
 for i=1,NUM_CHAT_WINDOWS do
  if(self:ScanTable("PARTY",msgsRcvdByWindow[i])) then
   self:CatchMessage(i)
  end
 end
end
function MiniChat:CHAT_MSG_RAID(_,author)
 if(self.db.profile.AutoMaximizeIgnoreSelf and author==UnitName("player")) then return end
 for i=1,NUM_CHAT_WINDOWS do
  if(self:ScanTable("PARTY",msgsRcvdByWindow[i])) then
   self:CatchMessage(i)
  end
 end
end
function MiniChat:CHAT_MSG_RAID_LEADER(_,author)
 if(self.db.profile.AutoMaximizeIgnoreSelf and author==UnitName("player")) then return end
 for i=1,NUM_CHAT_WINDOWS do
  if(self:ScanTable("PARTY",msgsRcvdByWindow[i])) then
   self:CatchMessage(i)
  end
 end
end
function MiniChat:CHAT_MSG_BATTLEGROUND(_,author)
 if(self.db.profile.AutoMaximizeIgnoreSelf and author==UnitName("player")) then return end
 for i=1,NUM_CHAT_WINDOWS do
  if(self:ScanTable("PARTY",msgsRcvdByWindow[i])) then
   self:CatchMessage(i)
  end
 end
end
function MiniChat:CHAT_MSG_BATTLEGROUND_LEADER(_,author)
 if(self.db.profile.AutoMaximizeIgnoreSelf and author==UnitName("player")) then return end
 for i=1,NUM_CHAT_WINDOWS do
  if(self:ScanTable("PARTY",msgsRcvdByWindow[i])) then
   self:CatchMessage(i)
  end
 end
end
function MiniChat:CHAT_MSG_BG_SYSTEM_ALLIANCE()
 for i=1,NUM_CHAT_WINDOWS do
  if(self:ScanTable("SYSTEM",msgsRcvdByWindow[i])) then
   self:CatchMessage(i)
  end
 end
end
function MiniChat:CHAT_MSG_BG_SYSTEM_HORDE()
 for i=1,NUM_CHAT_WINDOWS do
  if(self:ScanTable("SYSTEM",msgsRcvdByWindow[i])) then
   self:CatchMessage(i)
  end
 end
end
function MiniChat:CHAT_MSG_BG_SYSTEM_NEUTRAL()
 for i=1,NUM_CHAT_WINDOWS do
  if(self:ScanTable("SYSTEM",msgsRcvdByWindow[i])) then
   self:CatchMessage(i)
  end
 end
end
function MiniChat:CHAT_MSG_OFFICER(_,author)
 if(self.db.profile.AutoMaximizeIgnoreSelf and author==UnitName("player")) then return end
 for i=1,NUM_CHAT_WINDOWS do
  if(self:ScanTable("GUILD",msgsRcvdByWindow[i])) then
   self:CatchMessage(i)
  end
 end
end
function MiniChat:CatchMessage(i)
 if(self.db.profile.AutoMaximizeEnabled) then
  if(self.db.profile.AutoMaximizeIgnoreIfInCombat and UnitAffectingCombat("player")) then
   maximizeAfterCombat=true
   return
  end
  if(self.db.profile.AutoMinimize) then
    if(self:IsEventScheduled("minichatautominimize"..i)) then
     self:CancelScheduledEvent("minichatautominimize"..i)
    end
    self:ScheduleEvent("minichatautominimize"..i,"MINICHAT_AUTOMINIMIZE",self.db.profile.AutoMinimizeAfter,i)
  end
  if(self.db.profile.Minimized[i] and getglobal("ChatFrame"..i):IsVisible()) then
   self:MiniMax(i)
  end
 end
end

function MiniChat:MINICHAT_SMARTMINIMIZE()
 for i=1,NUM_CHAT_WINDOWS do
  if(self.db.profile.Minimized[i] and not animating[i]) then
   getglobal("ChatFrame"..i):SetHeight(self:GetLastMsgHeight(i))
  end
  self:UpdateChatAlpha(i)
 end
end

function MiniChat:MINICHAT_AUTOMINIMIZE(i)
 if(locked[i]) then
  self:ScheduleEvent("minichatautominimize"..i,"MINICHAT_AUTOMINIMIZE",1,i)
 elseif(not self.db.profile.Minimized[i]) then
  self:MiniMax(i)
 end
end

function MiniChat:MINICHAT_SMOOTHING(i,expand)
 animating[i]=true
 if(expand) then
  getglobal("ChatFrame"..i):SetHeight(getglobal("ChatFrame"..i):GetHeight()+2+self.db.profile.AnimationSpeed*getglobal("ChatFrame"..i):GetHeight()/120)
 else
  getglobal("ChatFrame"..i):SetHeight(getglobal("ChatFrame"..i):GetHeight()-2-self.db.profile.AnimationSpeed*getglobal("ChatFrame"..i):GetHeight()/120)
 end
 self:UpdateChatAlpha(i)
 if(getglobal("ChatFrame"..i):GetHeight()<=lower[i] and not expand
    or
    getglobal("ChatFrame"..i):GetHeight()>=self.db.profile.ChatHeight[i] and expand) then
  if(expand) then
   getglobal("ChatFrame"..i):SetHeight(self.db.profile.ChatHeight[i])
  else
   getglobal("ChatFrame"..i):SetHeight(lower[i])
  end
  self:UpdateChatAlpha(i)
  getglobal("ChatFrame"..i):ScrollDown()
  self.db.profile.Minimized[i]=not self.db.profile.Minimized[i]
  self:UpdateButtonTexture(i)
  animating[i]=false
 else
  self:ScheduleEvent("minichatsmoothing"..i,"MINICHAT_SMOOTHING",0.025,i,expand)
 end
end