﻿-------------------------------------------------------------------------------
-- Title: MSBT Options Russian Localization
-- Author: Mik
-- Russain Translation by: Eritnull (Шептун)
-------------------------------------------------------------------------------

-- Don't do anything if the locale isn't Russian.
if (GetLocale() ~= "ruRU") then return; end

-- Local reference for faster access.
local L = MikSBT.translations;

-------------------------------------------------------------------------------
-- Russian Localization
-------------------------------------------------------------------------------


------------------------------
-- Interface messages
------------------------------

L.MSG_NEW_PROFILE					= "Новый Профиль";
L.MSG_PROFILE_ALREADY_EXISTS		= "Профиль уже существует.";
L.MSG_INVALID_PROFILE_NAME			= "Неверное название профиля.";
L.MSG_NEW_SCROLL_AREA				= "Новая область прокрутки";
L.MSG_SCROLL_AREA_ALREADY_EXISTS	= "Название области прокрутки уже существует.";
L.MSG_INVALID_SCROLL_AREA_NAME		= "Неверное название области прокрутки.";
L.MSG_ACKNOWLEDGE_TEXT				= "Вы уверены что хотите выполнить данное действие?";
L.MSG_NORMAL_PREVIEW_TEXT			= "Нормальный";
L.MSG_INVALID_SOUND_FILE			= "Звуки должны быть в .mp3 или .wav формате.";
L.MSG_NEW_TRIGGER					= "Новый триггер";
L.MSG_TRIGGER_CLASSES				= "Триггер классы";
L.MSG_MAIN_EVENTS					= "Главные события";
L.MSG_TRIGGER_EXCEPTIONS			= "Триггер исключения";
L.MSG_EVENT_CONDITIONS				= "Условие события";
L.MSG_SKILLS						= "Навыки";
L.MSG_SKILL_ALREADY_EXISTS			= "Название навыка уже существует.";
L.MSG_INVALID_SKILL_NAME			= "Неверное название навыка.";
L.MSG_HOSTILE						= "Вражеский";
L.MSG_ANY							= "Любой";
L.MSG_CONDITION						= "Условие";
L.MSG_CONDITIONS					= "Условия";


------------------------------
-- Class Names.
------------------------------

local obj = L.CLASS_NAMES;
obj["DRUID"]	= "Друид";
obj["HUNTER"]	= "Охотник";
obj["MAGE"]		= "Маг";
obj["PALADIN"]	= "паладин";
obj["PRIEST"]	= "Жрец";
obj["ROGUE"]	= "Разбойник";
obj["SHAMAN"]	= "Шаман";
obj["WARLOCK"]	= "Чернокнижник";
obj["WARRIOR"]	= "Воин";


------------------------------
-- Interface tabs
------------------------------

obj = L.TABS;
obj[1] = { label="Основной", tooltip="Основные настройки."};
obj[2] = { label="Область прокрутки", tooltip="Настройки областей прокрутки, создание, удаление и т.д.\n\nНаведите мышь на иконки кнопок для большей информации."};
obj[3] = { label="События", tooltip="Настройки входящих, исходящих, и извещающих событиях.\n\nНаведите мышь на иконки кнопок для большей информации."};
obj[4] = { label="Триггеры", tooltip="Настройки системы триггеров.\n\nНаведите мышь на иконки кнопок для большей информации."};
obj[5] = { label="Контроль спама", tooltip="Настройки спам контроля."};
obj[6] = { label="Срок действия", tooltip="Настройки отображения в извещениях срока действий заклинаний."};
obj[7] = { label="Иконки навыков", tooltip="Настройки иконок навыков."};


------------------------------
-- Interface checkboxes
------------------------------

obj = L.CHECKBOXES;
obj["enableMSBT"]				= { label="Вкл/Выкл Mik's Scrolling Battle Text", tooltip="Вкл/Выкл MSBT."};
obj["stickyCrits"]				= { label="Закреплённый крит", tooltip="Отображение критов используя стиль закрепления."};
obj["gameDamage"]				= { label="Стандартный урон", tooltip="Отображение урона по умолчанию в клиенте над головой противника."};
obj["gameHealing"]				= { label="Стандартное лечение", tooltip="Отображение лечения по умолчанию в клиенте над головой противника."};
obj["enableSounds"]				= { label="Вкл/Выкл звуки", tooltip="Проигрывать звуки заданные в событиях и триггерах."};
obj["colorPartialEffects"]		= { label="Цвет частичных эффектов", tooltip="Применяет установленные цвета для частичных эффектов."};
obj["crushing"]					= { label="Сокрушительные удары", tooltip="Отображение трейлера сокрушительных ударов."};
obj["glancing"]					= { label="Скользящие удары", tooltip="Отображение трейлера скользящих ударов."};
obj["absorb"]					= { label="Частичный Absorbs", tooltip="Отображение значения частичных поглощении."};
obj["block"]					= { label="Частичный Блоки", tooltip="Отображение значения частичных блоков."};
obj["resist"]					= { label="Частичный Resists", tooltip="Отображение значения частичной невосприимчивости."};
obj["vulnerability"]			= { label="Бонус уязвимости", tooltip="Отображение значения бонуса уязвимости."};
obj["overheal"]					= { label="Переисциление", tooltip="Отображение значений переисциления."};
obj["colorDamageAmounts"]		= { label="Цвет урона по значимости", tooltip="Позволяет установить цвета окраски урона по его значимости."};
obj["colorDamageEntry"]			= { tooltip="Вкл/Выкл цвет для этого типа урона."};
obj["enableScrollArea"]			= { tooltip="Вкл/Выкл область прокрутки."};
obj["inheritField"]				= { label="Перенять", tooltip="Перенять значения полей. Снимите галку для отмены."};
obj["stickyEvent"]				= { label="Всегда закреплённый", tooltip="Всегда отображать используя стиль закрепления."};
obj["enableTrigger"]			= { tooltip="Вкл/Выкл триггер."};
obj["allPowerGains"]			= { label="Получ. ВСЕХ Энергий", tooltip="Отображение всех получении энергии включая даже те что не отображаются в списке боя.\n\nПРЕДУПРЕЖДЕНИЕ: Эта опция очень спамит и игнорирует все пороги энергии и механику регуляторов.\n\nНЕ РЕКОМЕНДУЕТСЯ."};
obj["hyperRegen"]				= { label="Активная Регенерация", tooltip="Отображение получения энергии во время быстрой регенерации способностями такими как Озарение и Захват духа.\n\nЗАМЕТКА: Отображаемые получения не будут регулироваться."};
obj["abbreviateSkills"]			= { label="Cокращать навыки", tooltip="Cокращать названия навыков (Только английские).\n\nThis can be overriden by each event with the %sl event code."};
obj["hideSkills"]				= { label="Скрыть навыки", tooltip="Не отображать названия навыков в входящих и исходящих событиях.\n\nYou will give up some customization capability at the event level if you choose to use this option since it causes the %s event code to be ignored."};
obj["hideNames"]				= { label="Скрыть Имена", tooltip="Не отображать названия юнитов в входящих и исходящих событиях.\n\nYou will give up some customization capability at the event level if you choose to use this option since it causes the %n event code to be ignored."};
obj["allClasses"]				= { label="Все классы"};
obj["enableCooldowns"]			= { label="Вкл/Выкл перезарядку", tooltip="Выводит предупреждения когда заканчиваются перезарядки."};
obj["enableIcons"]				= { label="Вкл/Выкл иконки навыков", tooltip="Отображение иконок для событий если это возможно и они существуют."};
obj["exclusiveSkills"]			= { label="Особенные названия навыков", tooltip="Показывает только названия навыков когда иконки не доступны."};


------------------------------
-- Interface dropdowns
------------------------------

obj = L.DROPDOWNS;
obj["profile"]				= { label="Текущий профиль:", tooltip="Установить текущий профиль."};
obj["normalFont"]			= { label="Шрифт - Обычный:", tooltip="Установить какой будет использоваться шрифт для не-критов."};
obj["critFont"]				= { label="Шрифт - Крита:", tooltip="Установить какой будет использоваться шрифт для критов."};
obj["normalOutline"]		= { label="Контур - Обычный:", tooltip="Установить какой будет использоваться стиль контура для не-критов."};
obj["critOutline"]			= { label="Контур - Крита:", tooltip="Установить какой будет использоваться стиль контура для критов."};
obj["scrollArea"]			= { label="Область прокрутки:", tooltip="Для настройки выберите желаемую облость прокрутки."};
obj["sound"]				= { label="Звук:", tooltip="Выберите какой проигрывать звук при выполнении события."};
obj["animationStyle"]		= { label="Стиль анимации:", tooltip="Стиль анимации для не-закрепленной анимации в области прокрутки."};
obj["stickyAnimationStyle"]	= { label="Стиль закрепления:", tooltip="Стиль анимации для закрепления в области прокрутки."};
obj["direction"]			= { label="Направление:", tooltip="Направление анимации."};
obj["behavior"]				= { label="Поведение:", tooltip="Поведение анимации."};
obj["textAlign"]			= { label="Выравнивание текста:", tooltip="Выравнивание текста анимации."};
obj["eventCategory"]		= { label="Категория события:", tooltip="Для настройки событий выберите желаемую категорию."};
obj["outputScrollArea"]		= { label="Область вывода:", tooltip="Выберите область прокрутки для вывода информации."};
obj["mainEvent"]			= { label="Главные события:"};
obj["triggerCondition"]		= { label="Условие:", tooltip="Условие для теста."};
obj["triggerRelation"]		= { label="Отношение:"};
obj["triggerParameter"]		= { label="Параметр:"};


------------------------------
-- Interface buttons
------------------------------

obj = L.BUTTONS;
obj["copyProfile"]				= { label="Скопировать", tooltip="Скопировать профиль в новый профиль с вами установленным названием."};
obj["resetProfile"]				= { label="Сброс", tooltip="Сброс профиля на стандартные установки."};
obj["deleteProfile"]			= { label="Удалить", tooltip="Удалить профиль."};
obj["masterFont"]				= { label="Основной шрифт", tooltip="Позволяет вам установить основной шрифт который будет использоваться всеми областями прокрутки текста боя и всеми событиями, пока не будет изменён в настройках областей и событий."};
obj["partialEffects"]			= { label="Частичные Эффекты", tooltip="Позволяет настроить отображение частичных эффектов"};
obj["damageColors"]				= { label="Цвета урона", tooltip="Позволяет вам установить цвет не взирая на то что установлены цвета по значимости и типу урона на текущий цвет."};
obj["inputOkay"]				= { label=OKAY, tooltip="Применить ввод."};
obj["inputCancel"]				= { label="Отмена", tooltip="Отменить ввод."};
obj["genericSave"]				= { label=SAVE, tooltip="Сохранить изменения."};
obj["genericCancel"]			= { label="Отмена", tooltip="Отменить изменения."};
obj["addScrollArea"]			= { label="Добавить область", tooltip="Добавить новую область прокрутки, события и триггеры также могут быть установлены на неё."};
obj["configScrollAreas"]		= { label="Настройка области", tooltip="Настройка местонахождения области прокрутки, ширины/высоты прокрутки,выравнивание текста,стиля закрепления анимации и обычного."};
obj["editScrollAreaName"]		= { tooltip="Кликните для редактирования названия области прокрутки."};
obj["scrollAreaFontSettings"]	= { tooltip="Кликните для редактирования настроек шрифта в области прокрутки который будет присвоен всем событиям в этой области прокрутки"};
obj["deleteScrollArea"]			= { tooltip="Кликните для удаление области прокрутки."};
obj["scrollAreasPreview"]		= { label="Предпросмотр", tooltip="Предпросмотр изменений."};
obj["toggleAll"]				= { label="Переключить ВСЕ", tooltip="Вкл/Выкл ВСЕ события в выбранной категории."};
obj["moveAll"]					= { label="Переместить ВСЕ", tooltip="Переместить ВСЕ события в выбранной категории в указанную область прокрутки."};
obj["eventFontSettings"]		= { tooltip="Кликните для редактирования настройки шрифта для события."};
obj["eventSettings"]			= { tooltip="Кликните для редактирования настроек события, области вывода, исходящие сообщения, звуки, и т.д."};
obj["customSound"]				= { tooltip="Кликните для вставки пользовательского звукового файла." };
obj["addTrigger"]				= { label="Добавить триггер", tooltip="Добавить новый триггер."};
obj["playSound"]				= { label="Воспр.", tooltip="Нажмите для воспроизведения выбранного звука."};
obj["triggerSettings"]			= { tooltip="Кликните для настройки условий триггера."};
obj["deleteTrigger"]			= { tooltip="Кликните для удаления триггера."};
obj["editTriggerClasses"]		= { tooltip="Кликните для редактирования классов к которым будет задействован данный триггер."};
obj["addMainEvent"]				= { label="Добавить событие", tooltip="Когда случаются КАКИЕ-НИБУДЬ события и их условия действительны, триггер просигналит.\n\nЗа исключением если одно из установленных исключений не будет действительно."};
obj["addTriggerException"]		= { label="Добавить исключение", tooltip="Когда КАКОЕ-НИБУДЬ исключение будет действительно, триггер не просигналит."};
obj["editEventConditions"]		= { tooltip="Кликните для редактирования условий события."};
obj["deleteMainEvent"]			= { tooltip="Кликните для удаления события."};
obj["addEventCondition"]		= { label="Добавить условие", tooltip="Когда КАКОЕ-НИБУДЬ условие будет действительно для выбранного события, триггер просигналит если не будет не одного действительного исключения."};
obj["editCondition"]			= { tooltip="Кликните для редактирования условия."};
obj["deleteCondition"]			= { tooltip="Кликните для удаления условия."};
obj["throttleList"]				= { label="Список регулировок", tooltip="Установка индивидуального времени для определённых навыков."};
obj["mergeExclusions"]			= { label="Слияние исключение", tooltip="Предотвращать слияние определённых навыков."};
obj["skillSuppressions"]		= { label="Блокир-ка навыков", tooltip="Скрывать навыки по их названиям."};
obj["skillSubstitutions"]		= { label="Замена навыков", tooltip="Заменить название навыка на пользовательское значение."};
obj["addSkill"]					= { label="Добавить навык", tooltip="Добавить новый навык в список."};
obj["deleteSkill"]				= { tooltip="Кликните для удаления навыка."};
obj["cooldownExclusions"]		= { label="Исключение перезарядки", tooltip="Запись навыков у которых не будут отслеживаться время перезарядки."};


------------------------------
-- Interface editboxes
------------------------------

obj = L.EDITBOXES;
obj["copyProfile"]		= { label="Новое название профиля:", tooltip="Название нового профиля в который будет скопирован выбранный профиль."};
obj["scrollAreaName"]	= { label="Новое названия области прокрутки:", tooltip="Новое название для области прокрутки."};
obj["xOffset"]			= { label="X смещение:", tooltip="Смещение по X в выбранной области прокрутки."};
obj["yOffset"]			= { label="Y смещение:", tooltip="Смещение по Y в выбранной области прокрутки."};
obj["eventMessage"]		= { label="Сообщение вывода:", tooltip="Сообщение которое будет отображаться при свершении события."};
obj["soundFile"]		= { label="Звуковой файл:", tooltip="Название звукового файла который будет проигрываться при свершении события."};
obj["iconSkill"]		= { label="Иконка навыка:", tooltip="Название или идентификатор заклинания чья иконка должна отображаться при свершении события.\n\nMSBT будет автоматически пробовать найти подходящую иконку если нет назначенной.\n\nПРИМЕЧАНИЕ: Если навык не может быть найден в книге заклинаний играющего класса в момент свершения событий то идентификатор заклинания должен использоваться вместо названия.  Может быть использовано для поиска большинство онлайновых баз данных таких как wowhead."};
obj["skillName"]		= { label="Название навыка:", tooltip="Название навыка который будет добавлен."};
obj["substitutionText"]	= { label="Текст замещения:", tooltip="текст который будет заменять название навыка."};


------------------------------
-- Interface sliders
------------------------------

obj = L.SLIDERS;
obj["animationSpeed"]		= { label="Скорость анимации", tooltip="Установка основной скорости анимации.\n\nКаждая область прокрутки также может быть настроена в независимости от основной скорости."};
obj["normalFontSize"]		= { label="Обычный размер шрифта", tooltip="Установка размера шрифта для обычного текста."};
obj["normalFontOpacity"]	= { label="Прозрачность текста", tooltip="Установка прозрачности для обычного текста."};
obj["critFontSize"]			= { label="Размер шрифта Крита", tooltip="Установка размера шрифта для критических ударов."};
obj["critFontOpacity"]		= { label="Прозрачность Крита", tooltip="Установка прозрачности для критических ударов."};
obj["scrollHeight"]			= { label="Высота прокрутки", tooltip="Регулировка высоты области прокрутки."};
obj["scrollWidth"]			= { label="Ширина прокрутки", tooltip="Регулировка ширины области прокрутки."};
obj["scrollAnimationSpeed"]	= { label="Скорость анимации", tooltip="Регулировка скорости анимации в области прокрутки."};
obj["powerThreshold"]		= { label="Порог. вел. энергии", tooltip="Порог величины энергии, привысев который она будет отображаться."};
obj["healThreshold"]		= { label="Порог. вел. исцеления", tooltip="Порог величины исцеления, привысев который она будет отображаться."};
obj["damageThreshold"]		= { label="Порог. вел. урона", tooltip="Порог величины урона, привысев который она будет отображаться."};
obj["dotThrottleTime"]		= { label="Регулятор УзВ", tooltip="Число секунд, чтобы замедлить отображение Урона за Время."};
obj["hotThrottleTime"]		= { label="Регулятор ИзВ", tooltip="Число секунд, чтобы замедлить отображение Исцеления за Время."};
obj["powerThrottleTime"]	= { label="Регулятор времени энергии", tooltip="Число секунд, чтобы замедлить отображение изменения энергии."};
obj["skillThrottleTime"]	= { label="Регулятор время", tooltip="Число секунд, чтобы замедлить отображение навыков."};
obj["cooldownThreshold"]	= { label="Порог. вел. перезарядки", tooltip="Навыки с перезарядкой меньший чем установленное число секунд не будут отображаться."};


------------------------------
-- Event categories
------------------------------
obj = L.EVENT_CATEGORIES;
obj[1] = "Входящий - Игрок";
obj[2] = "Входящий - Питомец";
obj[3] = "Исходящий - Игрок";
obj[4] = "Исходящий - Питомец";
obj[5] = "Извещения";


------------------------------
-- Event codes
------------------------------

obj = L.EVENT_CODES;
obj["DAMAGE_TAKEN"]			= "%a - Значение получаемого урона.\n";
obj["HEALING_TAKEN"]		= "%a - Значение получаемого лечения.\n";
obj["DAMAGE_DONE"]			= "%a - Значение нанесённого урона.\n";
obj["HEALING_DONE"]			= "%a - Значение нанесённого лечения.\n";
obj["ENERGY_AMOUNT"]		= "%a - Значение энергии.\n";
obj["CP_AMOUNT"]			= "%a - Значение сколько приёмов в серии.\n";
obj["HONOR_AMOUNT"]			= "%a - Значение чести.\n";
obj["REP_AMOUNT"]			= "%a - Значение репутации.\n";
obj["SKILL_AMOUNT"]			= "%a - Значение очков полученного навыка.\n";
obj["EXPERIENCE_AMOUNT"]	= "%a - Значение полученного опыта.\n";
obj["ATTACKER_NAME"]		= "%n - Имя атакующего.\n";
obj["HEALER_NAME"]			= "%n - Имя лекаря.\n";
obj["ATTACKED_NAME"]		= "%n - Имя атакующего юнита.\n";
obj["HEALED_NAME"]			= "%n - Имя исцеляющего юнита.\n";
obj["BUFFED_NAME"]			= "%n - Имя юнита с положительным эффектом.\n";
obj["SKILL_NAME"]			= "%s - Название навыка.\n";
obj["SPELL_NAME"]			= "%s - Название заклинания.\n";
obj["DEBUFF_NAME"]			= "%s - Название отрицательного эффекта.\n";
obj["BUFF_NAME"]			= "%s - Название положительного эффектов\n";
obj["ITEM_BUFF_NAME"]		= "%s - Название предмета с положительным эффектом.\n";
obj["EXTRA_ATTACKS"]		= "%s - Название навыка предоставляющий дополнительную атаку.\n";
obj["SKILL_LONG"]			= "%sl - Длинный от %s. Используется для замены сокращений событий.\n";
obj["DAMAGE_TYPE_TAKEN"]	= "%t - Типа полученного урона.\n";
obj["DAMAGE_TYPE_DONE"]		= "%t - Типа нанесенного урона.\n";
obj["ENVIRONMENTAL_DAMAGE"]	= "%e - Название источника урона (падение, утопление, лава, т.д. и т.п...)\n";
obj["FACTION_NAME"]			= "%e - Название фракции.\n";
obj["UNIT_KILLED"]			= "%e - Название убитого юнита.\n";
obj["SHARD_NAME"]			= "%e - Локализованное название камня душ.\n";
obj["EMOTE_TEXT"]			= "%e - текст эмоций.\n";
obj["MONEY_TEXT"]			= "%e - Текст получения денег.\n";
obj["COOLDOWN_NAME"]		= "%e - Название готового навыка.\n"
obj["POWER_TYPE"]			= "%p - Тип энергии (энергия, ярость, мана).\n";


------------------------------
-- Incoming events
------------------------------

obj = L.INCOMING_PLAYER_EVENTS;
obj[1]	= { label="Ближний Удар", tooltip="Вкл/Выкл входящие ближние удары."};
obj[2]	= { label="Ближний Крит", tooltip="Вкл/Выкл входящие ближние критические удары."};
obj[3]	= { label="Ближний Промах", tooltip="Вкл/Выкл входящие ближние промахи."};
obj[4]	= { label="Ближний Уклон.", tooltip="Вкл/Выкл входящие ближние уклонения."};
obj[5]	= { label="Ближний Парир.", tooltip="Вкл/Выкл входящие ближние парирования."};
obj[6]	= { label="Ближний Блок", tooltip="Вкл/Выкл входящие ближние блоки."};
obj[7]	= { label="Ближний Поглот.", tooltip="Вкл/Выкл входящие поглощения ближнего урона."};
obj[8]	= { label="Ближний Невоспр.", tooltip="Вкл/Выкл входящий ближний урон к которому вы невосприимчевы."};
obj[9]	= { label="Удар Заклинания", tooltip="Вкл/Выкл входящие удары заклинания."};
obj[10]	= { label="Крит Заклинания", tooltip="Вкл/Выкл входящие критические удары заклинания."};
obj[11]	= { label="УзВ Заклинания", tooltip="Вкл/Выкл входящий урон за время заклинанием."};
obj[12]	= { label="Промах Заклинания", tooltip="Вкл/Выкл входящие промахи заклинания."};
obj[13]	= { label="Уклон. Заклинания", tooltip="Вкл/Выкл входящие уклонения от заклинания."};
obj[14]	= { label="Парир. Заклинания", tooltip="Вкл/Выкл входящие парирования заклинания."};
obj[15]	= { label="Блок Заклинания", tooltip="Вкл/Выкл входящие блоки заклинания."};
obj[16]	= { label="Сопрот. Заклинания", tooltip="Вкл/Выкл входящие сопротивления заклинания."};
obj[17]	= { label="Поглот. Заклинания", tooltip="Вкл/Выкл входящие поглощения урона от нанесённых вам заклинаний."};
obj[18]	= { label="Невоспр. Заклинания", tooltip="Вкл/Выкл входящий урон от заклинаний к которому вы невосприимчевы."};
obj[19]	= { label="Отраж. Заклинания", tooltip="Вкл/Выкл входящий урон заклинаний которые вы отразили."};
obj[20]	= { label="Прерв. Заклинания", tooltip="Вкл/Выкл входящие прерывания заклинаний."};
obj[21]	= { label="Исцеление", tooltip="Вкл/Выкл входящие исцеления."};
obj[22]	= { label="Крит исцеления", tooltip="Вкл/Выкл входящие критические исцеления."};
obj[23]	= { label="Исцеление за Время", tooltip="Вкл/Выкл входящие Исцеление за Время."};
obj[24]	= { label="Урон окружающей среды", tooltip="Урон окружающей среды (Падение, Утопление, Лава, т.д. и т.п...)."};

obj = L.INCOMING_PET_EVENTS;
obj[1]	= { label="Ближний Удар", tooltip="Вкл/Выкл вашего питомца входящие ближние удары."};
obj[2]	= { label="Ближний Крит", tooltip="Вкл/Выкл вашего питомца входящие ближние критические удары."};
obj[3]	= { label="Ближний Промах", tooltip="Вкл/Выкл вашего питомца входящие ближние промахи."};
obj[4]	= { label="Ближний Уклон.", tooltip="Вкл/Выкл вашего питомца входящие ближние уклонения."};
obj[5]	= { label="Ближний Парир.", tooltip="Вкл/Выкл вашего питомца входящие ближние парирования."};
obj[6]	= { label="Ближний Блок", tooltip="Вкл/Выкл вашего питомца входящие ближние блоки."};
obj[7]	= { label="Ближний Поглот.", tooltip="Вкл/Выкл поглощения вашем питомцем входящего ближнего урона."};
obj[8]	= { label="Ближний Невоспр.", tooltip="Вкл/Выкл входящий ближний урон к которому имуннен питомец."};
obj[9]	= { label="Удар Заклинания", tooltip="Вкл/Выкл вашего питомца входящие удары заклинания."};
obj[10]	= { label="Крит Заклинания", tooltip="Вкл/Выкл вашего питомца входящие критические удары заклинания."};
obj[11]	= { label="УзВ Заклинания", tooltip="Вкл/Выкл вашего питомца входящий урон за время заклинанием."};
obj[12]	= { label="Промах Заклинания", tooltip="Вкл/Выкл вашего питомца входящие промахи заклинания."};
obj[13]	= { label="Уклон. Заклинания", tooltip="Вкл/Выкл вашего питомца входящие уклонения от заклинания."};
obj[14]	= { label="Парир. Заклинания", tooltip="Вкл/Выкл вашего питомца входящие парирования заклинания."};
obj[15]	= { label="Блок Заклинания", tooltip="Вкл/Выкл вашего питомца входящие блоки заклинания."};
obj[16]	= { label="Сопрот. Заклинания", tooltip="Вкл/Выкл вашего питомца входящие сопротивления заклинания."};
obj[17]	= { label="Поглот. Заклинания", tooltip="Вкл/Выкл поглощения урона вашим питомцем от входящих заклинаний."};
obj[18]	= { label="Невоспр. Заклинания", tooltip="Вкл/Выкл входящий урон от заклинаний к которому невоспреимчем ваш питомец."};
obj[19]	= { label="Исцеление", tooltip="Вкл/Выкл вашего питомца входящие исцеления."};
obj[20]	= { label="Крит исцеления", tooltip="Вкл/Выкл вашего питомца входящие критические исцеления."};
obj[21]	= { label="Исцеление за Время", tooltip="Вкл/Выкл вашего питомца входящие исцеления за время."};


------------------------------
-- Outgoing events
------------------------------

obj = L.OUTGOING_PLAYER_EVENTS;
obj[1]	= { label="Ближний Удар", tooltip="Вкл/Выкл исходящие ближние удары."};
obj[2]	= { label="Ближний Крит", tooltip="Вкл/Выкл исходящие ближние критические удары."};
obj[3]	= { label="Ближний Промах", tooltip="Вкл/Выкл исходящие ближние промахи."};
obj[4]	= { label="Ближний Уклон.", tooltip="Вкл/Выкл исходящие ближние уклонения."};
obj[5]	= { label="Ближний Парир.", tooltip="Вкл/Выкл исходящие ближние парирования."};
obj[6]	= { label="Ближний Блок", tooltip="Вкл/Выкл исходящие ближние блоки."};
obj[7]	= { label="Ближний Поглот.", tooltip="Вкл/Выкл исходящие поглощения ближнего урона."};
obj[8]	= { label="Ближний Невоспр.", tooltip="Вкл/Выкл исходящий ближний урон когда враг невосприимчив к нему."};
obj[9]	= { label="Ближний 'Мимо'", tooltip="Вкл/Выкль исходящие ближние evades."};
obj[10]	= { label="Удар Заклинания", tooltip="Вкл/Выкл исходящие удары заклинаний."};
obj[11]	= { label="Крит Заклинания", tooltip="Вкл/Выкл исходящие критические удары заклинаний."};
obj[12]	= { label="УзВ Заклинания", tooltip="Вкл/Выкл исходящие заклинания наносящие урон за время."};
obj[13]	= { label="Промах Заклинания", tooltip="Вкл/Выкл исходящие промахи заклинаний."};
obj[14]	= { label="Уклон. Заклинания", tooltip="Вкл/Выкл исходящие уклонения от заклинаний."};
obj[15]	= { label="Парир. Заклинания", tooltip="Вкл/Выкл исходящие парирования заклинаний."};
obj[16]	= { label="Блок Заклинания", tooltip="Вкл/Выкл исходящие блокирование заклинаний."};
obj[17]	= { label="Сопрот. Заклинания", tooltip="Вкл/Выкл исходящие сопротивление заклинаниям."};
obj[18]	= { label="Поглот. Заклинания", tooltip="Вкл/Выкл исходящие поглощения урона от исходящих заклинаний."};
obj[19]	= { label="Невоспр. Заклинания", tooltip="Вкл/Выкл исходящий урон заклинаний когда враг невосприимчив к нему."};
obj[20]	= { label="Отраж. Заклинания", tooltip="Вкл/Выкл исходящий урон заклинаний отраженный назад на вас."};
obj[21]	= { label="Прерывание заклинания", tooltip="Вкл/Выкл исходящие прерывания заклинаний."};
obj[22]	= { label="'Мимо' Заклинания", tooltip="Вкл/Выкл исходящие 'Мимо' Заклинаний."};
obj[23]	= { label="Исцеление", tooltip="Вкл/Выкл исходящие исцеления."};
obj[24]	= { label="Крит исцеления", tooltip="Вкл/Выкл исходящие критические исцеления."};
obj[25]	= { label="Исцеление за Время", tooltip="Вкл/Выкл исходящие исцеления за время."};
obj[26] = { label="Рассеивания", tooltip="Вкл/Выкл исходящие рассеивания."};

obj = L.OUTGOING_PET_EVENTS;
obj[1]	= { label="Ближний Удар", tooltip="Вкл/Выкл вашего питомца исходящие ближние удары."};
obj[2]	= { label="Ближний Крит", tooltip="Вкл/Выкл вашего питомца исходящие ближние критические удары."};
obj[3]	= { label="Ближний Промах", tooltip="Вкл/Выкл вашего питомца исходящие ближние промахи."};
obj[4]	= { label="Ближний Уклон.", tooltip="Вкл/Выкл вашего питомца исходящие ближние уклонения."};
obj[5]	= { label="Ближний Парир.", tooltip="Вкл/Выкл вашего питомца исходящие ближние парирования."};
obj[6]	= { label="Ближний Блок", tooltip="Вкл/Выкл вашего питомца исходящие ближние блоки."};
obj[7]	= { label="Ближний Поглот.", tooltip="Вкл/Выкл вашего питомца исходящие поглощения ближнего урона."};
obj[8]	= { label="Ближний Невоспр.", tooltip="Вкл/Выкл вашего питомца исходящие ближней урон к которому невосприимчив враг."};
obj[9]	= { label="Ближний 'Мимо'", tooltip="Вкл/Выкл вашего питомца исходящие ближние 'Мимо'."};
obj[10]	= { label="Удар Заклинания", tooltip="Вкл/Выкл вашего питомца исходящие удары заклинаний."};
obj[11]	= { label="Крит Заклинания", tooltip="Вкл/Выкл вашего питомца исходящие критические удары заклинаний."};
obj[12]	= { label="УзВ Заклинания", tooltip="Вкл/Выкл исходящие заклинания наносящие урон за время."};
obj[13]	= { label="Промах Заклинания", tooltip="Вкл/Выкл вашего питомца исходящие промахи заклинаний."};
obj[14]	= { label="Уклон. Заклинания", tooltip="Вкл/Выкл вашего питомца исходящие уклонения от заклинаний."};
obj[15]	= { label="Парир. Заклинания", tooltip="Вкл/Выкл вашего питомца исходящие парирования заклинаний."};
obj[16]	= { label="Блок Заклинания", tooltip="Вкл/Выкл вашего питомца исходящие блокирование заклинаний."};
obj[17]	= { label="Сопрот. Заклинания", tooltip="Вкл/Выкл вашего питомца исходящие сопротивление заклинаниям."};
obj[18]	= { label="Поглот. Заклинания", tooltip="Вкл/Выкл исходящие поглощения урона от исходящих заклинаний."};
obj[19]	= { label="Невоспр. Заклинания", tooltip="Вкл/Выкл исходящий урон от заклинаний к которому невосприимчив враг."};
obj[20]	= { label="'Мимо' Заклинаний", tooltip="Вкл/Выкл исходящие 'Мимо' Заклинаний."};
obj[21] = { label="Рассеивания", tooltip="Вкл/Выкл исходящие рассеивания"};


------------------------------
-- Notification events
------------------------------

obj = L.NOTIFICATION_EVENTS;
obj[1]	= { label="Отриц. Эффекты", tooltip="Вкл/Выкл оповещение о заражении отрицательными эффектами."};
obj[2]	= { label="Полож. Эффекты", tooltip="Вкл/Выкл оповещение о получении положительных эффектов."};
obj[3]	= { label="Полож. Эффекты Предметов", tooltip="Вкл/Выкл оповещение о положительных эффектах полученных вашими предметами."};
obj[4]	= { label="Пропад. отриц. эффектов", tooltip="Вкл/Выкл оповещение о пропадание с вас отрицательных эффектов."};
obj[5]	= { label="Пропад. полож. эффектов", tooltip="Вкл/Выкл оповещение о пропадание с вас положительных эффектов."};
obj[6]	= { label="Пропад. полож. эф. предметов", tooltip="Вкл/Выкл оповещение о пропадание с предметов положительных эффектов."};
obj[7]	= { label="Начало боя", tooltip="Вкл/Выкл оповещение о том когда вы начинаете бой."};
obj[8]	= { label="Выход из боя", tooltip="Вкл/Выкл оповещение о том когда вы выходите из бой."};
obj[9]	= { label="Получ. Энергии", tooltip="Вкл/Выкл оповещение когда вы получаете дополнительную ману, ярость, или энергию."};
obj[10]	= { label="Потеря Энергии", tooltip="Вкл/Выкл оповещение когда теряете ману, ярость, или энергию от похищения."};
obj[11]	= { label="Получ. Приёма в Серии", tooltip="Вкл/Выкл оповещение когда вы получаете приём в серии."};
obj[12]	= { label="Макс. Приёмов в Серии", tooltip="Вкл/Выкл оповещение когда вы достигаете максимального количества приемов в серии."};
obj[13]	= { label="Получ. Чести", tooltip="Вкл/Выкл оповещение когда вы получаете очки чести."};
obj[14]	= { label="Получ. Репутации", tooltip="Вкл/Выкл оповещение когда вы получаете очки репутации."};
obj[15]	= { label="Потеря Репутации", tooltip="Вкл/Выкл оповещение когда вы теряете очки репутации."};
obj[16]	= { label="Получ. Навыков", tooltip="Вкл/Выкл оповещение когда вы получаете очки к навыку."};
obj[17]	= { label="Получ. Опыта", tooltip="Вкл/Выкл оповещение когда вы получаете очки опыта."};
obj[18]	= { label="Игрока Победный удар", tooltip="Вкл/Выкл оповещение когда вы рядом с враждебным игроком получаете Победный удар."};
obj[19]	= { label="НПЦ Победный удар", tooltip="Вкл/Выкл оповещение когда вы рядом с НПЦ получаете Победный удар."};
obj[20]	= { label="Получ. Камня Душ", tooltip="Вкл/Выкл оповещение когда вы получаете  камень душ."};
obj[21]	= { label="Экста Атаки", tooltip="Вкл/Выкл оповещение когда вы получаете дополнительные атаки такие как Ярость ветра, thrash, sword spec, и т.д."};
obj[22]	= { label="Получ. Врагом полож. эффектов", tooltip="Вкл/Выкл оповещение о получении положительных эффектов вашей текущей враждебной цели."};
obj[23]	= { label="Эмоции Монстов", tooltip="Вкл/Выкл эмоции монстров которые в текущий момент в цели."};
obj[24]	= { label="Получ. Денег", tooltip="Вкл/Выкл оповещение когда вы получаете деньги."};


------------------------------
-- Trigger info
------------------------------

-- Main events.
obj = L.TRIGGER_DATA;
obj["SWING_DAMAGE"]				= "Рывок Урон";
obj["RANGE_DAMAGE"]				= "Дальний Урон";
obj["SPELL_DAMAGE"]				= "Урон Навыков";
obj["GENERIC_DAMAGE"]			= "Рывок/Навык/Дальний Урон";
obj["SPELL_PERIODIC_DAMAGE"]	= "Периодический урон навыка (УзВ)";
obj["DAMAGE_SHIELD"]			= "Damage Shield урон";
obj["DAMAGE_SPLIT"]				= "Прерывистый урон";
obj["ENVIRONMENTAL_DAMAGE"]		= "Урон окружающей среды";
obj["SWING_MISSED"]				= "Промах рывка";
obj["RANGE_MISSED"]				= "Дальний промах";
obj["SPELL_MISSED"]				= "Промах навыка";
obj["GENERIC_MISSED"]			= "Рывок/Навык/Дальний промах";
obj["SPELL_PERIODIC_MISSED"]	= "Промах Периодического навыка";
obj["SPELL_DISPEL_FAILED"]		= "Неудачное Рассеивание";
obj["DAMAGE_SHIELD_MISSED"]		= "Промах Damage Shield";
obj["SPELL_HEAL"]				= "Исцеление";
obj["SPELL_PERIODIC_HEAL"]		= "Периодическое исцеление (ИзВ)";
obj["SPELL_ENERGIZE"]			= "Прирост энергии";
obj["SPELL_PERIODIC_ENERGIZE"]	= "Периодический прирост энергии";
obj["SPELL_DRAIN"]				= "Похищение энергии";
obj["SPELL_PERIODIC_DRAIN"]		= "Периодическое похищение энергии";
obj["SPELL_LEECH"]				= "Выпивание энергии";
obj["SPELL_PERIODIC_LEECH"]		= "Периодическое выпивание энергии";
obj["SPELL_INTERRUPT"]			= "Прерывание Навыка";
obj["SPELL_AURA_APPLIED"]		= "Использование Ауры";
obj["SPELL_AURA_REMOVED"]		= "Снятие Аура";
obj["SPELL_AURA_STOLEN"]		= "Хищение Ауры";
obj["SPELL_AURA_DISPELLED"]		= "Рассеивание Ауры";
obj["ENCHANT_APPLIED"]			= "Использование Очарования";
obj["ENCHANT_REMOVED"]			= "Снятие очарования";
obj["SPELL_CAST_START"]			= "Начало Чтения";
obj["SPELL_CAST_SUCCESS"]		= "Успешное Чтение";
obj["SPELL_CAST_FAILED"]		= "Неудачное Чтение";
obj["SPELL_SUMMON"]				= "Призывание   ";
obj["SPELL_CREATE"]				= "Создавание";
obj["PARTY_KILL"]				= "Победный Удар";
obj["UNIT_DIED"]				= "Смерть объекта";
obj["UNIT_DESTROYED"]			= "Ликвидация объекта";
obj["SPELL_EXTRA_ATTACKS"]		= "Экстра Атаки";
obj["UNIT_HEALTH"]				= "Изменение здоровья";
obj["UNIT_MANA"]				= "Изменение маны";
obj["UNIT_ENERGY"]				= "Изменение энергии";
obj["UNIT_RAGE"]				= "Изменение ярости";
obj["SKILL_COOLDOWN"]			= "Завершение перезарядки заклинания";
 
-- Main event conditions.
obj["sourceName"]				= "Название источника";
obj["sourceAffiliation"]		= "Source Unit Affiliation";
obj["sourceReaction"]			= "Source Unit Reaction";
obj["sourceControl"]			= "Source Unit Control";
obj["sourceUnitType"]			= "Тип источника";
obj["recipientName"]			= "Название получателя";
obj["recipientAffiliation"]		= "Recipient Unit Affiliation";
obj["recipientReaction"]		= "Recipient Unit Reaction";
obj["recipientControl"]			= "Recipient Unit Control";
obj["recipientUnitType"]		= "Тип получателя";
obj["skillID"]					= "ID навыка";
obj["skillName"]				= "Название навыка";
obj["skillSchool"]				= "Школа навыка";
obj["extraSkillID"]				= "Экстра ID навыка";
obj["extraSkillName"]			= "Экстра название навыка";
obj["extraSkillSchool"]			= "Экстра школа навыка";
obj["amount"]					= "Значение";
obj["damageType"]				= "Тип урона";
obj["resistAmount"]				= "Значение Сопрот.";
obj["blockAmount"]				= "Значение Блока";
obj["absorbAmount"]				= "Значение Поглот.";
obj["isCrit"]					= "Крит";
obj["isGlancing"]				= "Косые удары";
obj["isCrushing"]				= "Сокрушительный Удар";
obj["extraAmount"]				= "Экстра Значение";
obj["missType"]					= "Тип Промаха";
obj["hazardType"]				= "Тип Опасности";
obj["powerType"]				= "Тип Энергии";
obj["auraType"]					= "Тип Ауры";
obj["threshold"]				= "Порог";
obj["unitID"]					= "ID объекта";
obj["unitReaction"]				= "Unit Reaction";

-- Exception conditions.
obj["buffActive"]				= "Активность заклинания";
obj["currentCP"]				= "Текущие очки энергии";
obj["currentPower"]				= "Текущая сила";
obj["recentlyFired"]			= "Недавно просигналивший триггер";
obj["trivialTarget"]			= "Обычная цель";
obj["unavailableSkill"]			= "Недоступный навык";
obj["warriorStance"]			= "Стоики война";
obj["zoneName"]					= "Название зоны";
obj["zoneType"]					= "Тип зоны";
 
-- Realationships.
obj["eq"]						= "Равен";
obj["ne"]						= "Не равен";
obj["like"]						= "Похожий";
obj["unlike"]					= "Не похожий";
obj["lt"]						= "Меньше чем";
obj["gt"]						= "Больше чем";
 
-- Affiliations.
obj["affiliationMine"]			= "Моё";
obj["affiliationParty"]			= "Участник группы";
obj["affiliationRaid"]			= "Участник рейда";
obj["affiliationOutsider"]		= "Аутсайдер";
obj["affiliationTarget"]		= TARGET;
obj["affiliationFocus"]			= "Фокус";
obj["affiliationYou"]			= YOU;

-- Reactions.
obj["reactionFriendly"]			= "Дружелюбный";
obj["reactionNeutral"]			= "Нейтральный";
obj["reactionHostile"]			= HOSTILE;

-- Control types.
obj["controlServer"]			= "Сервер";
obj["controlHuman"]				= "Человек";

-- Unit types.
obj["unitTypePlayer"]			= PLAYER; 
obj["unitTypeNPC"]				= "НПЦ";
obj["unitTypePet"]				= PET;
obj["unitTypeGuardian"]			= "Страж";
obj["unitTypeObject"]			= "Объект";

-- Aura types.
obj["auraTypeBuff"]				= "Полож. Эффект";
obj["auraTypeDebuff"]			= "Отриц. Эффект";

-- Zone types.
obj["zoneTypeArena"]			= "Арена";
obj["zoneTypePvP"]				= BATTLEGROUND;
obj["zoneTypeParty"]			= "Подземелье на 5-чел";
obj["zoneTypeRaid"]				= "Рейдовое подземелье";

-- Booleans
obj["booleanTrue"]				= "Верный";
obj["booleanFalse"]				= "Неверный";


------------------------------
-- Font info
------------------------------

-- Font outlines.
obj = L.OUTLINES;
obj[1] = "Нету";
obj[2] = "Тонкий";
obj[3] = "Жирный";

-- Text aligns.
obj = L.TEXT_ALIGNS;
obj[1] = "Влево";
obj[2] = "По центру";
obj[3] = "Вправо";


------------------------------
-- Sound info
------------------------------

obj = L.SOUNDS;
obj["LowMana"]		= "Малый запас маны";
obj["LowHealth"]	= "Малый запас здоровья";


------------------------------
-- Animation style info
------------------------------

-- Animation styles
obj = L.ANIMATION_STYLE_DATA;
obj["Horizontal"]	= "Горизонтальный";
obj["Parabola"]		= "Парабола";
obj["Straight"]		= "Прямой";
obj["Static"]		= "Статика";
obj["Pow"]			= "Ручеёк";

-- Animation style directions.
obj["Alternate"]	= "Чередоваться";
obj["Left"]			= "Влево";
obj["Right"]		= "Вправо";
obj["Up"]			= "Вверх";
obj["Down"]			= "Вниз";

-- Animation style behaviors.
obj["GrowUp"]			= "Увеличиваться";
obj["GrowDown"]			= "Уменьшаться";
obj["CurvedLeft"]		= "Изогнутый влево";
obj["CurvedRight"]		= "Изогнутый вправо";
obj["Jiggle"]			= "Тряска";
obj["Normal"]			= "Нормальный";