MementoMori = AceLibrary("AceAddon-2.0"):new("AceEvent-2.0", "AceConsole-2.0", "AceDB-2.0")
local mod = MementoMori

local WatchList = {}
local TakeScreenshot = false

local function get(key)
	return mod.db.profile[key]
end

local function set(key, val)
	mod.db.profile[key] = val
end

local options
options = {
	type = "group",
	args = {
		memberlimit = {
			type = "range",
			name = "Member limit",
			desc = "How many members should be in a raid in order for a screenshot to be taken.",
			min = 5,
			max = 40,
			step = 1,
			get = get,
			set = set,
			passValue = "MemberLimit",
		},
	},
}

function mod:OnInitialize()
	self:RegisterDB("MementoMoriDB")
	self:RegisterDefaults("profile", {
		MemberLimit = 20,
	})
	self:RegisterChatCommand("/mm", "/mementomori", options)
end

function mod:OnEnable()
	self:RegisterEvent("PLAYER_TARGET_CHANGED")
	self:RegisterEvent("UPDATE_MOUSEOVER_UNIT")
	
	self:RegisterEvent("COMBAT_LOG_EVENT_UNFILTERED")
	self:RegisterEvent("PLAYER_REGEN_ENABLED")
end

function mod:UPDATE_MOUSEOVER_UNIT()
	self:CheckTarget("mouseover")
end

function mod:PLAYER_TARGET_CHANGED()
	self:CheckTarget("target")
end

function mod:PLAYER_REGEN_ENABLED()
	if TakeScreenshot then
		self:TakeScreenShot()
	end
end

function mod:COMBAT_LOG_EVENT_UNFILTERED(_, event, _, _, _, _, mob)
	if event ~= "UNIT_DIED" then return end
	if mob and WatchList[mob] then
		TakeScreenshot = true
		WatchList[mob] = nil

		if not InCombatLockdown() then
			self:TakeScreenShot()
		end
	end
end

function mod:TakeScreenShot()
	local instanceType = select(2, IsInInstance())
	if instanceType == "pvp" then return end
	
	if GetNumRaidMembers() >= get("MemberLimit") then
		Screenshot()
		TakeScreenshot = false
	end
end

function mod:CheckTarget(unit)
	local type = UnitClassification(unit)
	if type ~= "worldboss" then 
		return
	end
	
	local name = UnitName(unit)
	if WatchList[name] or UnitIsDead(unit) then
		return
	end
	
	self:Print(("Boss found: %s"):format(name))
	WatchList[name] = true
end