-- MasterLewtlogger 2.04.01 by Everglow

local MLLVer="2.04.01"
local MLLTag="|c00FFFF66MasterLewtLogger "..MLLVer.."|r: "

local lewtLogging = false
local lootBuffer = {}
local currentML

local qNames = {
	[1] = "Common",
	[2] = "Uncommon",
	[3] = "Rare",
	[4] = "Epic",
	[5] = "Legendary",
	[6] = "Artifact",
}

local qColor = {}
for i = 1,6 do
	_, _, _, qColor[i] = GetItemQualityColor(i)
end

local MLLText = 
		"Logging is active whenever you are the Loot Master of a raid.\n"..
		"Logging is disabled whenever any of the following happen:\n"..
		"|c0000FFFF  1. You leave the raid.\n"..
		"  2. Someone else becomes the Loot Master.\n"..
		"  3. The Looting Method is changed."

local function ChatMsg(msg)
	DEFAULT_CHAT_FRAME:AddMessage(msg)
end

local function popUp(msg)
	StaticPopupDialogs["MLL_NOTIFY"]["text"] = msg
	StaticPopup_Show ("MLL_NOTIFY")
end

local function SaveInfo(index)
	local currentIndex = 1
	local instance = GetRealZoneText()
	if (LewtLogDB == nil or LewtLogDB["MasterLooter"] == nil) then
		LewtLogDB = {
			["MasterLooter"] = UnitName("player")
		}
	end
	if LewtLogDB[instance] == nil then
		LewtLogDB[instance] = {}
	end
	for i,v in ipairs(LewtLogDB[instance]) do
		currentIndex = i+1
	end
	LewtLogDB[instance][currentIndex] = lootBuffer[index]
end

local function MLL_SlashCommandHandler(msg)
	if msg == "reset" then
		StaticPopup_Show("MLL_RESET_DATA")
	elseif lewtLogging then
		ChatMsg(MLLTag.." Logging is currently enabled")
	else
		ChatMsg(MLLTag.." Logging is currently disabled")
	end
end

function MasterLewtLogger_OnLoad()
	this:RegisterEvent("PLAYER_ENTERING_WORLD")
	this:RegisterEvent("PARTY_LOOT_METHOD_CHANGED")
	this:RegisterEvent("RAID_ROSTER_UPDATE")
	this:RegisterEvent("LOOT_OPENED")
	this:RegisterEvent("CHAT_MSG_LOOT")

	StaticPopupDialogs["MLL_NOTIFY"] = {
		button1 = "Close",
		timeout = 0,
		whileDead = 1,
		hideOnEscape = 1
	}
	StaticPopupDialogs["MLL_CHECK_FOR_DISENCHANT"] = {
		text = "Will this loot be disenchanted?",
		button1 = "Yes",
		button2 = "No",
		OnCancel = function(index) SaveInfo(index) end,
		timeout = 0,
		whileDead = 0,
		hideOnEscape = 0
	}
	StaticPopupDialogs["MLL_RESET_DATA"] = {
		text = "|c00FF0000Are you sure you want to reset you Lewt Log?|r",
		showAlert = 1,
		button1 = "Yes",
		button2 = "No",
		OnAccept = function() LewtLogDB = {} end,
		timeout = 0,
		whileDead = 1,
		hideOnEscape = 1
	}

	SLASH_MASTERLEWTLOGGER1 = "/mll"
	SlashCmdList["MASTERLEWTLOGGER"] =
	function(msg)
		MLL_SlashCommandHandler(msg)
	end
end

function MasterLewtLogger_OnEvent()
	if (event == "PLAYER_ENTERING_WORLD") then
		ChatMsg(MLLTag.."Loaded.\n"..MLLText)
	elseif (event == "RAID_ROSTER_UPDATE" or event == "PARTY_LOOT_METHOD_CHANGED") then
		if GetNumRaidMembers() > 0 then
			local lootmethod = GetLootMethod()
			local lootMasterName		
			if lootmethod == "master" then
				for i=1,GetNumRaidMembers() do
					if (GetRaidRosterInfo(i) and select(11, GetRaidRosterInfo(i))) then
						lootMasterName = UnitName("raid"..i)
						if lootMasterName ~= currentLM then
							ChatMsg(MLLTag.."lootmaster is now: "..lootMasterName)
						end
						currentLM = lootMasterName
						if lootMasterName == UnitName("player") then
							if(not lewtLogging) then
						popUp("|c0000CCFFYou are now Loot Master.\nLoot logging enabled.\nLoot Threshold: "..qColor[GetLootThreshold()]..qNames[GetLootThreshold()]..
										"\n\n|c0000CCFFIf you want to delete all saved data, type\n|c00FFCC66/mll reset")
								lewtLogging = true
							end
						else
							if(lewtLogging) then
								popUp("|c0000CCFFYou are no longer Loot Master.\nLoot logging disabled")
								lewtLogging = false
							end	
						end
					end
				end
			else
				if(lewtLogging) then
					local eFlag = GetCVar("scriptErrors")
					SetCVar("scriptErrors","1")
					popUp("|c0000CCFFMaster Looting no longer active.\nLoot logging disabled.")
					lewtLogging = false
					SetCVar("scriptErrors",eFlag)
				end
			end
		else
			if(lewtLogging) then
				popUp("|c0000CCFFYou are no longer in a raid.\nLoot logging disabled.")
				lewtLogging = false
			end
		end
	elseif (event == "LOOT_OPENED" and lewtLogging) then
		lootBuffer = {}
		local corpseName = UnitName("target")
		lootBuffer = {}
		local lootNum = 0
		for index = 1, GetNumLootItems() do
			if (LootSlotIsItem(index)) then
				local iteminfo = GetLootSlotLink(index);
				local _, itemId = strsplit(":", iteminfo)
				local spos = string.find(iteminfo,"%[")
				local epos = string.find(iteminfo,"%]")
				local itemname = string.sub(iteminfo,spos,epos)
				local logable = false
				local color = string.sub(iteminfo,1,10)
				for i = GetLootThreshold(), 6 do
					if itemname == "[Badge of Justice]" then
						break
					elseif color == qColor[i] then
						logable = true
						break
					end
				end
				if logable then
					lootNum = lootNum + 1
					lootBuffer[lootNum] = {}
					lootBuffer[lootNum]["item"] = itemname
					lootBuffer[lootNum]["WoWHeadLink"] = "http://www.wowhead.com/?item="..itemId
					if corpseName == nil then
						lootBuffer[lootNum]["droppedBy"] = "container"
					else
						lootBuffer[lootNum]["droppedBy"] = corpseName
					end
				end
			end
		end
	elseif (event == "CHAT_MSG_LOOT" and lewtLogging) then
		local spos, epos = 1, string.find(arg1," ")
		local player = string.sub(arg1,spos,epos-1)
		if (player == "You") then
			player = UnitName("player")
		end
		spos = string.find(arg1,"%[")
		epos = string.find(arg1,"%]")
		item = string.sub(arg1,spos,epos)
		local i = 1
		while lootBuffer[i] do
			if item == lootBuffer[i]["item"] then
				lootBuffer[i]["awardedTo"] = player
				local dialog = StaticPopup_Show ("MLL_CHECK_FOR_DISENCHANT")
				if(dialog) then
					dialog.data = i
				end
				break
			end
			i = i + 1
		end
	end
end
