
local manikin = LibStub("AceAddon-3.0"):GetAddon("Manikin")

local AceLocale = LibStub("AceLocale-3.0")
local L = AceLocale:GetLocale("Manikin")

manikin:AddTrigger(L["Entering Combat"],"entercombat","PLAYER_REGEN_DISABLED",function()
		manikin:Trigger("entercombat",{})
	end,L["MyName, MyLevel"])

manikin:AddTrigger(L["Leaving Combat"],"leavecombat","PLAYER_REGEN_ENABLED",function()
		if UnitIsDeadOrGhost("player") then return end
		manikin:Trigger("leavecombat",{})
	end,L["MyName, MyLevel"])

local schoolName = {
	[1] = "physical",
	[2] = "holy",
	[4] = "fire",
	[8] = "nature",
	[16] = "frost",
	[32] = "shadow",
	[64] = "arcane",
}
local missToTrigger = {
	BLOCK = "blockattack",
	DODGE = "dodgeattack",
	MISS = "enemymissed",
	PARRY = "parryattack",
	ABSORB = "absorbattack",
	RESIST = "resistattack",
}
local missToTrigger2 = {
	BLOCK = "attackblocked",
	DODGE = "attackdodged",
	MISS = "missedenemy",
	PARRY = "attackparried",
	ABSORB = "attackabsorbed",
	RESIST = "attackresisted",
}
local playerGUID
local petGUID
manikin:AddTrigger(L["Receive Damage"],"hitincombat","COMBAT_LOG_EVENT_UNFILTERED",
	function(t,event,source,sourcename,sourceflags,dest,destname,destflags,arg9,arg10,arg11,arg12,arg13,arg14,arg15,arg16,arg17,arg18,arg19)
		if not playerGUID then playerGUID = UnitGUID("player") end
		if dest == playerGUID then
			local subs = {SourceName = sourcename}
			if UnitGUID("target") == dest then
				subs.SourceHealth = UnitHealth("target")
				subs.SourceLevel = UnitLevel("target")
				if subs.SourceLevel < 0 then subs.SourceLevel = UnitLevel("player") + 100 end
			end
			if event == "SWING_DAMAGE" then
				subs.School = schoolName[arg10]
				if arg14 then
					return manikin:Trigger("critincombat",subs)
				else
					return manikin:Trigger("hitincombat",subs)
				end
			end
			if event == "SPELL_DAMAGE" or event == "RANGED_DAMAGE" then
				subs.School = schoolName[arg13]
				subs.Spell = arg10
				if arg17 then
					return manikin:Trigger("critincombat",subs)
				else
					return manikin:Trigger("hitincombat",subs)
				end
			end
			if event == "SWING_MISSED" then
				return manikin:Trigger(missToTrigger[arg9],subs)
			end
			if event == "SPELL_MISSED" or event == "RANGED_MISSED" then
				subs.Spell = arg10
				return manikin:Trigger(missToTrigger[arg12],subs)
			end
			if event == "SPELL_AURA_APPLIED" then
				subs.Aura = arg10
				return manikin:Trigger("gainaura",subs)
			end
			if event == "SPELL_AURA_REMOVED" then
				subs.Aura = arg10
				return manikin:Trigger("lostaura",subs)
			end
			if event == "SPELL_HEAL" then
				subs.School = schoolName[arg11]
				subs.Spell = arg10
				if source == playerGUID then
					if arg13 then
						return manikin:Trigger("crithealedself",subs)
					else
						return manikin:Trigger("healedself",subs)
					end
				else
					if arg13 then
						return manikin:Trigger("crithealed",subs)
					else
						return manikin:Trigger("healed",subs)
					end
				end
			end
		end
		if source == playerGUID then
			local subs = {DestName = destname}
			if UnitGUID("target") == dest then
				subs.DestHealth = UnitHealth("target")
				subs.DestLevel = UnitLevel("target")
				if subs.DestLevel < 0 then subs.DestLevel = UnitLevel("player") + 100 end
			end
			if event == "SWING_DAMAGE" then
				subs.School = schoolName[arg10]
				if arg14 then
					return manikin:Trigger("critenemy",subs)
				else
					return manikin:Trigger("hitenemy",subs)
				end
			end
			if event == "SPELL_DAMAGE" or event == "RANGED_DAMAGE" then
				subs.School = schoolName[arg13]
				if arg17 then
					return manikin:Trigger("critenemy",subs)
				else
					return manikin:Trigger("hitenemy",subs)
				end
			end
			if event == "SWING_MISSED" then
				return manikin:Trigger(missToTrigger2[arg9],subs)
			end
			if event == "SPELL_MISSED" or event == "RANGED_MISSED" then
				subs.Spell = arg10
				return manikin:Trigger(missToTrigger2[arg12],subs)
			end
			if event == "SPELL_HEAL" then
				subs.School = schoolName[arg11]
				subs.Spell = arg10
				if arg13 then
					return manikin:Trigger("critheal",subs)
				else
					return manikin:Trigger("heal",subs)
				end
			end
			if event == "SPELL_CAST_SUCCESS" then
				subs.School = schoolName[arg11]
				subs.Spell = arg10
				return manikin:Trigger("castsuccess",subs)
			end
		end
	end,L["MyName, MyLevel, SourceName, SourceHealth, SourceLevel, School, Spell"])
-- since all of the following share the same event and function as the above function, these need only the trigger name and code.
manikin:AddTrigger(L["Receive Crit"],"critincombat",nil,nil,L["MyName, MyLevel, SourceName, SourceHealth, SourceLevel, School, Spell"])
manikin:AddTrigger(L["Damage Enemy"],"hitenemy",nil,nil,L["MyName, MyLevel, DestName, DestHealth, DestLevel, School, Spell"])
manikin:AddTrigger(L["Crit Enemy"],"critenemy",nil,nil,L["MyName, MyLevel, DestName, DestHealth, DestLevel, School, Spell"])
manikin:AddTrigger(L["Block an Attack"],"blockattack",nil,nil,L["MyName, MyLevel, SourceName, SourceHealth, SourceLevel, Spell"])
manikin:AddTrigger(L["Dodge an Attack"],"dodgeattack",nil,nil,L["MyName, MyLevel, SourceName, SourceHealth, SourceLevel, Spell"])
manikin:AddTrigger(L["Enemy Misses"],"enemymisses",nil,nil,L["MyName, MyLevel, SourceName, SourceHealth, SourceLevel, Spell"])
manikin:AddTrigger(L["Parry an Attack"],"parryattack",nil,nil,L["MyName, MyLevel, SourceName, SourceHealth, SourceLevel, Spell"])
manikin:AddTrigger(L["Absorb an Attack"],"absorbattack",nil,nil,L["MyName, MyLevel, SourceName, SourceHealth, SourceLevel, Spell"])
manikin:AddTrigger(L["Resist an Attack"],"resistattack",nil,nil,L["MyName, MyLevel, SourceName, SourceHealth, SourceLevel, Spell"])
manikin:AddTrigger(L["Enemy Blocked"],"attackblocked",nil,nil,L["MyName, MyLevel, DestName, DestHealth, DestLevel, Spell"])
manikin:AddTrigger(L["Enemy Dodged"],"attackdodged",nil,nil,L["MyName, MyLevel, DestName, DestHealth, DestLevel, Spell"])
manikin:AddTrigger(L["Missed Enemy"],"missedenemy",nil,nil,L["MyName, MyLevel, DestName, DestHealth, DestLevel, Spell"])
manikin:AddTrigger(L["Enemy Parried"],"attackparried",nil,nil,L["MyName, MyLevel, DestName, DestHealth, DestLevel, Spell"])
manikin:AddTrigger(L["Enemy Absorbed"],"attackabsorbed",nil,nil,L["MyName, MyLevel, DestName, DestHealth, DestLevel, Spell"])
manikin:AddTrigger(L["Enemy Resisted"],"attackresisted",nil,nil,L["MyName, MyLevel, DestName, DestHealth, DestLevel, Spell"])
manikin:AddTrigger(L["Gain an Aura"],"gainaura",nil,nil,L["MyName, MyLevel, SourceName, SourceHealth, SourceLevel, Aura"])
manikin:AddTrigger(L["Lose an Aura"],"lostaura",nil,nil,L["MyName, MyLevel, SourceName, SourceHealth, SourceLevel, Aura"])
manikin:AddTrigger(L["Healed Self"],"healedself",nil,nil,L["MyName, MyLevel, SourceName, SourceHealth, SourceLevel, School, Spell"])
manikin:AddTrigger(L["Critically Healed Self"],"crithealedself",nil,nil,L["MyName, MyLevel, SourceName, SourceHealth, SourceLevel, School, Spell"])
manikin:AddTrigger(L["Healed"],"healed",nil,nil,L["MyName, MyLevel, SourceName, SourceHealth, SourceLevel, School, Spell"])
manikin:AddTrigger(L["Critically Healed"],"crithealed",nil,nil,L["MyName, MyLevel, SourceName, SourceHealth, SourceLevel, School, Spell"])
manikin:AddTrigger(L["Healed Other"],"heal",nil,nil,L["MyName, MyLevel, DestName, DestHealth, DestLevel, School, Spell"])
manikin:AddTrigger(L["Critically Healed Other"],"critheal",nil,nil,L["MyName, MyLevel, DestName, DestHealth, DestLevel, School, Spell"])
manikin:AddTrigger(L["Successful Spellcast"],"castsuccess",nil,nil,L["MyName, MyLevel, DestName, DestHealth, DestLevel, School, Spell"])

manikin:AddTrigger(L["Resurrected"],"resurrect","PLAYER_ALIVE",function()
	return manikin:Trigger("resurrect",{})
end,L["MyName, MyLevel"])
-- Likewise, a trigger that needs to fire on multiple events can provide a nil for the first two arguments.
manikin:AddTrigger(nil,nil,"PLAYER_UNGHOST",function()
	return manikin:Trigger("resurrect",{})
end)

manikin:AddTrigger(L["Target Calls for Help"],"callforhelp","CHAT_MSG_MONSTER_EMOTE",function(emote,monster)
	if monster == UnitName("target") then -- this doesn't guarantee that our target is actually the one emoting...
		local sub = {
			SourceName = monster,
			SourceHealth = UnitHealth("target"),
			SourceLevel = UnitLevel("target"),
		}
		if sub.SourceLevel < 0 then sub.SourceLevel = UnitLevel("player") + 100 end
		if emote == "%s calls for help!" then
			return manikin:Trigger("callforhelp",sub)
		elseif emote == "%s attempts to run away in fear!" then
			return manikin:Trigger("runinfear",sub)
		elseif emote == "%s becomes enraged!" then
			return manikin:Trigger("enemyenraged",sub)
		end
	end
end,L["MyName, MyLevel, SourceName, SourceHealth, SourceLevel"])
manikin:AddTrigger(L["Target Runs in Fear"],"runinfear",nil,nil,L["MyName, MyLevel, SourceName, SourceHealth, SourceLevel"])
manikin:AddTrigger(L["Target Becomes Enraged"],"enemyenraged",nil,nil,L["MyName, MyLevel, SourceName, SourceHealth, SourceLevel"])

local followsub
manikin:AddTrigger(L["Following Another"],"followstart","AUTOFOLLOW_BEGIN",function(unit)
	followsub = {
		FollowName = UnitName(unit),
		FollowHealth = UnitHealth(unit),
		FollowLevel = UnitLevel(unit),
	}
	if followsub.FollowLevel < 0 then followsub.FollowLevel = UnitLevel("player") + 100 end
	return manikin:Trigger("followstart",followsub)
end,L["MyName, MyLevel, FollowName, FollowHealth, FollowLevel"])

manikin:AddTrigger(L["Stop Following"],"followstop","AUTOFOLLOW_END",function(unit)
	return manikin:Trigger("followstop",followsub)
end,L["MyName, MyLevel, FollowName, FollowHealth, FollowLevel"])

manikin:AddTrigger(L["Level Up"],"levelup","PLAYER_LEVEL_UP",function()
	return manikin:Trigger("levelup",{})
end,L["MyName, MyLevel"])
