
local manikin = LibStub("AceAddon-3.0"):NewAddon("Manikin", "AceTimer-3.0", "AceEvent-3.0", "AceConsole-3.0")

local random = math.random
math.randomseed(GetTime())
local AceDB = LibStub("AceDB-3.0")
local AceDBOptions = LibStub("AceDBOptions-3.0")
local db
local reg = LibStub("AceConfigRegistry-3.0")
local dialog = LibStub("AceConfigDialog-3.0")

local AceLocale = LibStub("AceLocale-3.0")
local L = AceLocale:GetLocale("Manikin")

local harbor = LibStub("AceAddon-3.0"):GetAddon("Harbor",true)
if harbor then
	function manikin:GetCurrentSideDock()
		local harbordb = harbor:GetDockButtonDB("Manikin")
		return harbordb.curdock
	end

	function manikin:SetCurrentSideDock(dock)
		local harbordb = harbor:GetDockButtonDB("Manikin")
		harbordb.curdock = dock
	end

	function manikin:GetSideDockPriority()
		return 100
	end

	function manikin:GetSideDockWidth()
		return 1
	end

	function manikin:GetSideDockIcon()
		return [[Interface\AddOns\Manikin\icon]]
	end

	function manikin:OnSideDockClick()
		dialog:Open("Manikin")
	end

	function manikin:OnSideDockEnter()
		-- show Tooltip
	end

	function manikin:OnSideDockLeave()
		-- hide tooltip
	end
end

--local AceLocale = LibStub("AceLocale-3.0")
--local L = AceLocale:GetLocale("ButtonFacade")

function manikin:OnInitialize()
	db = AceDB:New("ManikinDB",nil,"Default")
	self.db = db
	self.options.args.profile = AceDBOptions:GetOptionsTable(db)
	db.profile.emdelay = db.profile.emdelay or 0.7
	db.profile.cemdelay = db.profile.cemdelay or 1.2
	db.profile.saydelay = db.profile.saydelay or 1.7
	db.profile.minbetweentriggers = db.profile.minbetweentriggers or 10
end

local mv_fw
local mv_bk
local mv_lf
local mv_rt
local mv_auto
local turn_lf
local turn_rt
local mouse_move
local follow

function manikin:IsMoving()
	mouse_move = IsMouseButtonDown(2)
	return mv_fw or mv_bk or mv_lf or mv_rt or mv_auto or (turn_lf and mouse_move) or (turn_rt and mouse_move)
end

local globalsubs = {}

function manikin:OnEnable()
	-- register the configuration options
	reg:RegisterOptionsTable("Manikin", self.options)
	self:RegisterChatCommand("manikin", function() dialog:Open("Manikin") end)
	dialog:AddToBlizOptions("Manikin","Manikin")
	if harbor then
		local harbordb = harbor:GetDockButtonDB("Manikin")
		harbor:AddDockButton(self,harbordb.curdock)
	end
	hooksecurefunc("MoveBackwardStart",function() mv_bk = true mv_auto = nil end)
	hooksecurefunc("MoveBackwardStop",function() mv_bk = nil end)
	hooksecurefunc("MoveForwardStart",function() mv_fw = true mv_auto = nil end)
	hooksecurefunc("MoveForwardStop",function() mv_fw = nil end)
	hooksecurefunc("StrafeLeftStart",function() mv_lf = true end)
	hooksecurefunc("StrafeLeftStop",function() mv_lf = nil end)
	hooksecurefunc("StrafeRightStart",function() mv_rt = true end)
	hooksecurefunc("StrafeRightStop",function() mv_rt = nil end)
	hooksecurefunc("TurnLeftStart",function() turn_lf = true end)
	hooksecurefunc("TurnLeftStop",function() turn_lf = nil end)
	hooksecurefunc("TurnRightStart",function() turn_rt = true end)
	hooksecurefunc("TurnRightStop",function() turn_rt = nil end)
	hooksecurefunc("ToggleAutoRun",function() turn_auto = not mv_auto end)
	self:ScheduleRepeatingTimer(self.IdleTimer, 10, self)
	self:AddTrigger(nil,nil,"AUTOFOLLOW_BEGIN",function() follow = true end)
	self:AddTrigger(nil,nil,"AUTOFOLLOW_END",function() follow = nil end)
	self:AddTrigger("Idle (While Moving)","idlemoving",nil,nil,L["MyName, MyLevel, InCombat, Flying, Mounted"])
	self:AddTrigger("Idle (While Following)","idlefollowing",nil,nil,L["MyName, MyLevel, InCombat, Flying, Mounted"])
	self:AddTrigger("Idle (While Stationary)","idlestationary",nil,nil,L["MyName, MyLevel, InCombat, Flying, Mounted"])
	self:AddTrigger("Idle (While on a Flight Path)","idletaxi",nil,nil,L["MyName, MyLevel"])
	globalsubs.MyName = UnitName("player")
	globalsubs.MyLevel = UnitLevel("player")
	-- maintain the level.
	self:AddTrigger(nil,nil,"PLAYER_LEVEL_UP",function(newlevel) globalsubs.MyLevel = newlevel end)
end

function manikin:IdleTimer()
	local subs = {}
	if InCombatLockdown() then subs.InCombat = "yes" end
	if IsFlying() then
		subs.Flying = "yes"
	elseif IsMounted() then
		subs.Mounted = "yes"
	end
	if self:IsMoving() then
		-- moving of our own accord.
		self:Trigger("idlemoving",subs)
	elseif follow then
		-- following another player.
		self:Trigger("idlefollowing",subs)
	elseif UnitOnTaxi("player") then
		-- on a flightpath
		self:Trigger("idletaxi",{})
	else
		-- stationary.
		self:Trigger("idlestationary",subs)
	end
end

local trigger = {}
local triggerlist = {}
local triggerhelp = {}

function manikin:AddTrigger(triggername,triggercode,event,func,helptext)
	if func then -- this allows func and event to be nil, so we can use one event handler to process a number of triggers.
		local triggerGroup = trigger[event] or {}
		trigger[event] = triggerGroup
		triggerGroup[#triggerGroup+1] = func
		self:RegisterEvent(event,"FireTrigger")
	end
	if triggername then -- this allows triggername and triggercode to be nil.
		triggerlist[triggercode] = triggername
		if helptext then
			triggerhelp[triggercode] = helptext
		end
	end
end

function manikin:FireTrigger(event,...)
	local triggerGroup = trigger[event]
	for i = 1, #triggerGroup do
		triggerGroup[i](...)
	end
end

local cursubs
local function substitute(s)
	return cursubs[s] or globalsubs[s] or "$"..s.."$"
end

local lastTrigger = 0
function manikin:Trigger(trigger,subs)
	-- this fires the user named trigger, and passes a list of possible substitutions along.
	cursubs = subs
	local emote,emtarget,cemote,say,lang,delay = self:Pick(trigger,subs)
	if emote then self:DelayEmote(emote,emtarget,delay) end
	if cemote then self:DelayCEmote(cemote:gsub("%$(.-)%$",substitute),delay) end
	if say then self:DelaySay(say:gsub("%$(.-)%$",substitute),lang,delay) end
end

local function delayedEmote(t)
	local curtime = GetTime()
	if curtime < lastTrigger + db.profile.minbetweentriggers then return end
	DoEmote(t[1],t[2])
	lastTrigger = curtime
end
function manikin:DelayEmote(emote,emtarget,delay)
	self:ScheduleTimer(delayedEmote,(delay or db.profile.emdelay) + math.random() * 0.5,{emote,emtarget})
end

local function delayedCEmote(text)
	local curtime = GetTime()
	if curtime < lastTrigger + db.profile.minbetweentriggers then return end
	SendChatMessage(text,"EMOTE")
	lastTrigger = curtime
end
function manikin:DelayCEmote(text,delay)
	if text:find("%$") then return end -- if there is a single un-filled substitution, don't allow it.
	self:ScheduleTimer(delayedCEmote,(delay or db.profile.cemdelay) + math.random() * 0.5,text)
end

local function delayedSay(t)
	local curtime = GetTime()
	if curtime < lastTrigger + db.profile.minbetweentriggers then return end
	SendChatMessage(t[1],"SAY",t[2])
	lastTrigger = curtime
end
function manikin:DelaySay(text,lang,delay)
	if text:find("%$") then return end -- if there is a single un-filled substitution, don't allow it.
	self:ScheduleTimer(delayedSay,(delay or db.profile.saydelay) + math.random() * 0.5,{text,lang})
end

function manikin:PickFromDB(trigger)
	local char = db.char[trigger] or {}
	local race = db.race[trigger] or {}
	local class = db.class[trigger] or {}
	local faction = db.faction[trigger] or {}
	local maxr = #char + #race + #class + #faction
	if maxr < 1 then return end
	local r = math.random(maxr)
	if r <= #char then
		return char[r]
	end
	r = r - #char
	if r <= #race then
		return race[r]
	end
	r = r - #race
	if r <= #class then
		return class[r]
	end
	r = r - #class
	return faction[r]
end

function manikin:Pick(trigger,subs)
	local emote,emtarget,cemote,say,lang,delay
	local pick = self:PickFromDB(trigger)
	if not pick then return end
	local r = math.random()
	if math.random() >= (pick.spamrate or 0.9) then
		local picktype = pick.type
		local subeq = pick.subeq
		local subneq = pick.subneq
		local sublt = pick.sublt
		local subgt = pick.subgt
		if (not subeq or (subs[subeq[1]] == subeq[2]:gsub("%$(.-)%$",substitute))) and
			 (not subneq or (subs[subneq[1]] ~= subneq[2]:gsub("%$(.-)%$",substitute))) and
			 (not sublt or (tonumber(subs[sublt[1]]) < tonumber(sublt[2]:gsub("%$(.-)%$",substitute)))) and
			 (not subgt or (tonumber(subs[subgt[1]]) > tonumber(subgt[2]:gsub("%$(.-)%$",substitute)))) then
			if picktype == "emote" then
				emote = pick.emote
				emtarget = pick.emtarget
			elseif picktype == "cemote" then
				cemote = pick.cemote
			else
				say = pick.say
				lang = pick.lang
			end
		end
		delay = pick.delay
	end
	return emote,emtarget,cemote,say,lang,delay
end

-- ace-options table for control of the system.
local configTrigger
local configSource
local configIndex
manikin.options = {
	type = 'group',
	name = L["Manikin"],
	args = {
		settings = {
			type = 'group',
			name = L["Settings"],
			args = {
				-- Settings include the delays for various things, and the percentage chance that a trigger will be reacted to.
				emotedelay = {
					type = 'range',
					name = L["Default Emote Delay"],
					min = 0.1,
					max = 5,
					step = 0.1,
					get = function() return db.profile.emdelay end,
					set = function(info,set) db.profile.emdelay = set end,
					width = "full",
					order = 1,
				},
				cemotedelay = {
					type = 'range',
					name = L["Default Text Emote Delay"],
					min = 0.1,
					max = 5,
					step = 0.1,
					get = function() return db.profile.cemdelay end,
					set = function(info,set) db.profile.cemdelay = set end,
					width = "full",
					order = 2,
				},
				saydelay = {
					type = 'range',
					name = L["Default Say Delay"],
					min = 0.1,
					max = 5,
					step = 0.1,
					get = function() return db.profile.saydelay end,
					set = function(info,set) db.profile.saydelay = set end,
					width = "full",
					order = 3,
				},
				minbetween = {
					type = 'range',
					name = L["Minimum Seconds Between Triggers"],
					min = 0,
					max = 60,
					step = 1,
					get = function() return db.profile.minbetweentriggers end,
					set = function(info,set) db.profile.minbetweentriggers = set end,
					width = "full",
					order = 4,
				},
			},
			order = 1,
		},
		triggers = {
			type = 'group',
			name = L["Triggers"],
			args = {
				trigger = {
					type = 'select',
					name = L["Trigger"],
					values = triggerlist,
					get = function() return configTrigger end,
					set = function(info,set)
						if set ~= configTrigger then
							if configSource then
								local index = manikin.options.args.triggers.args.index
								db[configSource] = db[configSource] or {}
								db[configSource][set] = db[configSource][set] or {}
								index.max = #db[configSource][set]
							end
							configIndex = 1
							configTrigger = set
						end
					end,
					width = "full",
					order = 1,
				},
				source = {
					type = 'select',
					name = L["Response Source"],
					values = {char="Character",class="Class",faction="Faction",race="Race"},
					get = function() return configSource end,
					set = function(info,set)
						if set ~= configSource then
							configIndex = 1
							configSource = set
							if configTrigger then
								local index = manikin.options.args.triggers.args.index
								db[set] = db[set] or {}
								db[set][configTrigger] = db[set][configTrigger] or {}
								index.max = #db[set][configTrigger]
							end
						end
					end,
					width = "full",
					order = 2,
				},
				newindex = {
					type = 'execute',
					name = L["New Response"],
					hidden = function()
						return not (configTrigger and configSource)
					end,
					func = function()
						db[configSource][configTrigger][#db[configSource][configTrigger] + 1] = {
							type = "say",
							spamrate = 0.9, -- this indicates the response will occur Approximately 10% of the time.
						}
						local index = manikin.options.args.triggers.args.index
						index.max = #db[configSource][configTrigger]
					end,
					order = 3,
				},
				index = {
					type = 'range',
					name = L["Response"],
					hidden = function()
						return not (configTrigger and configSource and (manikin.options.args.triggers.args.index.max > 0))
					end,
					min = 1,
					max = 0,
					step = 1,
					get = function() return configIndex end,
					set = function(info,set) configIndex = set end,
					width = "full",
					order = 4,
				},
				restype = {
					type = 'select',
					name = L["Type"],
					hidden = function()
						return not (configTrigger and configSource and (manikin.options.args.triggers.args.index.max > 0))
					end,
					values = {emote=L["Emote"], cemote=L["Text Emote"], say=L["Say"]},
					get = function()
						local response = db[configSource][configTrigger][configIndex]
						return response.type
					end,
					set = function(info,set)
						local response = db[configSource][configTrigger][configIndex]
						response.type = set
						if set == "emote" then
							response.cemote = nil
							response.say = nil
							response.lang = nil
						elseif set == "cemote" then
							response.emote = nil
							response.emtarget = nil
							response.say = nil
							response.lang = nil
						else
							response.emote = nil
							response.emtarget = nil
							response.cemote = nil
						end
					end,
					width = "full",
					order = 5,
				},--[[
				helptext = {
					type = 'description',
					name = function() return L["The following values are available (use $Value$ in emotes and say): "]..triggerhelp[configTrigger] end,
					hidden = function()
						return not (configTrigger and configSource and (manikin.options.args.triggers.args.index.max > 0))
					end,
					order = 6,
				},--]]
				emote = {
					type = 'input',
					name = L["Emote"],
					hidden = function()
						if not (configTrigger and configSource and (manikin.options.args.triggers.args.index.max > 0)) then
							return true
						end
						local response = db[configSource][configTrigger][configIndex]
						return response.type ~= "emote"
					end,
					get = function()
						local response = db[configSource][configTrigger][configIndex]
						return response.emote or ""
					end,
					set = function(info,set)
						local response = db[configSource][configTrigger][configIndex]
						if set == "" then set = nil end
						response.emote = set
					end,
					width = "full",
					order = 7,
				},
				emtarget = {
					type = 'input',
					name = L["Emote Target"],
					hidden = function()
						if not (configTrigger and configSource and (manikin.options.args.triggers.args.index.max > 0)) then
							return true
						end
						local response = db[configSource][configTrigger][configIndex]
						return response.type ~= "emote"
					end,
					get = function()
						local response = db[configSource][configTrigger][configIndex]
						return response.emtarget or ""
					end,
					set = function(info,set)
						local response = db[configSource][configTrigger][configIndex]
						if set == "" then set = nil end
						response.emtarget = set
					end,
					width = "full",
					order = 8,
				},
				cemote = {
					type = 'input',
					name = L["Text Emote"],
					desc = function() return L["The following values are available (use $ValueName$): "]..triggerhelp[configTrigger] end,
					hidden = function()
						if not (configTrigger and configSource and (manikin.options.args.triggers.args.index.max > 0)) then
							return true
						end
						local response = db[configSource][configTrigger][configIndex]
						return response.type ~= "cemote"
					end,
					get = function()
						local response = db[configSource][configTrigger][configIndex]
						return response.cemote or ""
					end,
					set = function(info,set)
						local response = db[configSource][configTrigger][configIndex]
						if set == "" then set = nil end
						response.cemote = set
					end,
					width = "full",
					order = 9,
				},
				say = {
					type = 'input',
					name = L["Say"],
					desc = function() return L["The following values are available (use $ValueName$): "]..triggerhelp[configTrigger] end,
					hidden = function()
						if not (configTrigger and configSource and (manikin.options.args.triggers.args.index.max > 0)) then
							return true
						end
						local response = db[configSource][configTrigger][configIndex]
						return response.type ~= "say"
					end,
					get = function()
						local response = db[configSource][configTrigger][configIndex]
						return response.say or ""
					end,
					set = function(info,set)
						local response = db[configSource][configTrigger][configIndex]
						response.say = set
					end,
					width = "full",
					order = 10,
				},
				lang = {
					type = 'input',
					name = L["Language"],
					hidden = function()
						if not (configTrigger and configSource and (manikin.options.args.triggers.args.index.max > 0)) then
							return true
						end
						local response = db[configSource][configTrigger][configIndex]
						return response.type ~= "say"
					end,
					get = function()
						local response = db[configSource][configTrigger][configIndex]
						return response.lang or ""
					end,
					set = function(info,set)
						local response = db[configSource][configTrigger][configIndex]
						if set == "" then set = nil end
						response.lang = set
					end,
					width = "full",
					order = 11,
				},
				spamrate = {
					type = 'range',
					name = L["Chance to Fire"],
					min = 0,
					max = 1,
					step = 0.05,
					isPercent = true,
					hidden = function()
						return not (configTrigger and configSource and (manikin.options.args.triggers.args.index.max > 0))
					end,
					get = function()
						local response = db[configSource][configTrigger][configIndex]
						return 1 - (response.spamrate or 0.9)
					end,
					set = function(info,set)
						local response = db[configSource][configTrigger][configIndex]
						response.spamrate = 1 - set
					end,
					width = "full",
					order = 12,
				},
				defaultdelay = {
					type = 'toggle',
					name = L["Use Default Delay"],
					hidden = function()
						return not (configTrigger and configSource and (manikin.options.args.triggers.args.index.max > 0))
					end,
					get = function()
						local response = db[configSource][configTrigger][configIndex]
						return not response.delay
					end,
					set = function(info,set)
						local response = db[configSource][configTrigger][configIndex]
						if set then
							response.delay = nil
						elseif response.type == "emote" then
							response.delay = db.profile.emdelay
						elseif response.type == "cemote" then
							response.delay = db.profile.cemdelay
						else
							response.delay = db.profile.saydelay
						end
					end,
					width = "full",
					order = 13,
				},
				delay = {
					type = 'range',
					name = L["Delay"],
					min = 0,
					max = 5,
					step = 0.1,
					hidden = function()
						return not (configTrigger and configSource and (manikin.options.args.triggers.args.index.max > 0))
					end,
					disabled = function()
						local response = db[configSource][configTrigger][configIndex]
						return not response.delay
					end,
					get = function()
						local response = db[configSource][configTrigger][configIndex]
						if response.delay then
							return response.delay
						end
						if response.type == "emote" then
							return db.profile.emdelay
						elseif response.type == "cemote" then
							return db.profile.cemdelay
						else
							return db.profile.saydelay
						end
					end,
					set = function(info,set)
						local response = db[configSource][configTrigger][configIndex]
						response.delay = set
					end,
					width = "full",
					order = 14,
				},
				onlyif1 = {
					type = 'input',
					name = L["Only If"],
					desc = function() return L["The following values are available: "]..triggerhelp[configTrigger] end,
					hidden = function()
						return not (configTrigger and configSource and (manikin.options.args.triggers.args.index.max > 0))
					end,
					get = function()
						local response = db[configSource][configTrigger][configIndex]
						if response.subeq then
							return response.subeq[1]
						end
						return ""
					end,
					set = function(info,set)
						local response = db[configSource][configTrigger][configIndex]
						if set == "" then
							response.subeq = nil
							return
						end
						response.subeq = response.subeq or {}
						response.subeq[1] = set
					end,
					width = "full",
					order = 15,
				},
				subeq = {
					type = 'input',
					name = L["Equals"],
					desc = function() return L["The following values are available (use $ValueName$): "]..triggerhelp[configTrigger] end,
					hidden = function()
						if not (configTrigger and configSource and (manikin.options.args.triggers.args.index.max > 0)) then return true end
						local response = db[configSource][configTrigger][configIndex]
					end,
					get = function()
						local response = db[configSource][configTrigger][configIndex]
						if response.subeq then
							return response.subeq[2]
						end
						return ""
					end,
					set = function(info,set)
						local response = db[configSource][configTrigger][configIndex]
						if set == "" then set = nil end
						response.subeq[2] = set
					end,
					width = "full",
					order = 16,
				},
				onlyif2 = {
					type = 'input',
					name = L["Only If"],
					desc = function() return L["The following values are available: "]..triggerhelp[configTrigger] end,
					hidden = function()
						return not (configTrigger and configSource and (manikin.options.args.triggers.args.index.max > 0))
					end,
					get = function()
						local response = db[configSource][configTrigger][configIndex]
						if response.subneq then
							return response.subneq[1]
						end
						return ""
					end,
					set = function(info,set)
						local response = db[configSource][configTrigger][configIndex]
						if set == "" then
							response.subneq = nil
							return
						end
						response.subneq = response.subneq or {}
						response.subneq[1] = set
					end,
					width = "full",
					order = 17,
				},
				subneq = {
					type = 'input',
					name = L["Is Not Equal To"],
					desc = function() return L["The following values are available (use $ValueName$): "]..triggerhelp[configTrigger] end,
					hidden = function()
						if not (configTrigger and configSource and (manikin.options.args.triggers.args.index.max > 0)) then return true end
						local response = db[configSource][configTrigger][configIndex]
					end,
					get = function()
						local response = db[configSource][configTrigger][configIndex]
						if response.subneq then
							return response.subneq[2]
						end
						return ""
					end,
					set = function(info,set)
						local response = db[configSource][configTrigger][configIndex]
						if set == "" then set = nil end
						response.subneq[2] = set
					end,
					width = "full",
					order = 18,
				},
				onlyif3 = {
					type = 'input',
					name = L["Only If"],
					desc = function() return L["The following values are available: "]..triggerhelp[configTrigger] end,
					hidden = function()
						return not (configTrigger and configSource and (manikin.options.args.triggers.args.index.max > 0))
					end,
					get = function()
						local response = db[configSource][configTrigger][configIndex]
						if response.sublt then
							return response.sublt[1]
						end
						return ""
					end,
					set = function(info,set)
						local response = db[configSource][configTrigger][configIndex]
						if set == "" then
							response.sublt = nil
							return
						end
						response.sublt = response.sublt or {}
						response.sublt[1] = set
					end,
					width = "full",
					order = 19,
				},
				sublt = {
					type = 'input',
					name = L["Is Less Than"],
					desc = function() return L["The following values are available (use $ValueName$): "]..triggerhelp[configTrigger] end,
					hidden = function()
						if not (configTrigger and configSource and (manikin.options.args.triggers.args.index.max > 0)) then return true end
						local response = db[configSource][configTrigger][configIndex]
					end,
					get = function()
						local response = db[configSource][configTrigger][configIndex]
						if response.sublt then
							return response.sublt[2]
						end
						return ""
					end,
					set = function(info,set)
						local response = db[configSource][configTrigger][configIndex]
						if set == "" then set = nil end
						response.sublt[2] = set
					end,
					width = "full",
					order = 20,
				},
				onlyif4 = {
					type = 'input',
					name = L["Only If"],
					desc = function() return L["The following values are available: "]..triggerhelp[configTrigger] end,
					hidden = function()
						return not (configTrigger and configSource and (manikin.options.args.triggers.args.index.max > 0))
					end,
					get = function()
						local response = db[configSource][configTrigger][configIndex]
						if response.subgt then
							return response.subgt[1]
						end
						return ""
					end,
					set = function(info,set)
						local response = db[configSource][configTrigger][configIndex]
						if set == "" then
							response.subgt = nil
							return
						end
						response.subgt = response.subgt or {}
						response.subgt[1] = set
					end,
					width = "full",
					order = 21,
				},
				subgt = {
					type = 'input',
					name = L["Is Greater Than"],
					desc = function() return L["The following values are available (use $ValueName$): "]..triggerhelp[configTrigger] end,
					hidden = function()
						if not (configTrigger and configSource and (manikin.options.args.triggers.args.index.max > 0)) then return true end
						local response = db[configSource][configTrigger][configIndex]
					end,
					get = function()
						local response = db[configSource][configTrigger][configIndex]
						if response.subgt then
							return response.subgt[2]
						end
						return ""
					end,
					set = function(info,set)
						local response = db[configSource][configTrigger][configIndex]
						if set == "" then set = nil end
						response.subgt[2] = set
					end,
					width = "full",
					order = 22,
				},
				delete = {
					type = 'execute',
					name = L["Delete Response"],
					hidden = function()
						return not (configTrigger and configSource and (manikin.options.args.triggers.args.index.max > 0))
					end,
					func = function()
						table.remove(db[configSource][configTrigger],configIndex)
						local index = manikin.options.args.triggers.args.index
						index.max = index.max - 1
						if configIndex > index.max then configIndex = configIndex - 1 end
					end,
					order = 23,
				},
			},
			order = 2,
		},
	},
}
