--MainAssist Version 2.3 by Nargiddley
--Last Update 19/12/2006

MainAssist = AceLibrary("AceAddon-2.0"):new("AceConsole-2.0", "AceDB-2.0", "AceEvent-2.0", "AceDebug-2.0", "FuBarPlugin-2.0")

MainAssist.hasIcon = "Interface\\Icons\\Ability_Hunter_MasterMarksman"
MainAssist.cannotDetachTooltip = false
MainAssist.independentProfile = true
MainAssist.hideWithoutStandby = true

local L = AceLibrary("AceLocale-2.2"):new("MainAssist")
local SharedMedia = AceLibrary("SharedMedia-1.0")
local deformat = AceLibrary("Deformat-2.0")
local dewdrop = AceLibrary("Dewdrop-2.0")
local tablet = AceLibrary("Tablet-2.0")

BINDING_HEADER_MAINASSISTHEADER = L["MAIN_ASSIST"]
BINDING_NAME_MA_TARGET_MAINASSIST = L["TARGET_MAINASSIST"] 
BINDING_NAME_MA_ASSIST_MAINASSIST = L["ASSIST_MAINASSIST"]
BINDING_NAME_MA_TARGET_SECONDARYASSIST = L["TARGET_SECONDARYASSIST"]
BINDING_NAME_MA_ASSIST_SECONDARYASSIST = L["ASSIST_SECONDARYASSIST"]
BINDING_NAME_MAINASSIST_OPTIONS = L["MAINASSIST_OPTIONS"]
BINDING_NAME_ADD_TARGET_TO_CUSTOM = L["ADD_TARGET_TO_CUSTOM"]
BINDING_NAME_CLEAR_CUSTOM_TANKS = L["CLEAR_CUSTOM_TANKS"]

if not ClickCastFrames then ClickCastFrames = {} end

---------------------
-- On___ Functions --
---------------------

function MainAssist:OnInitialize()
	
  SharedMedia:Register("statusbar", "MainAssist", "Interface\\Addons\\MainAssist\\images\\gradient")
	self:RegisterDB("MainAssistDB")
	self:RegisterDefaults('profile', {
		showtot = false,
        showmthealth = false,
		showtargeing = true,
		detailedtooltip  = true,
		tooltipcols = 3,
		scale = 1,
		alpha = 1,
		locked = false,
		hidewhenlocked = false,
		hidewhenempty = false,
		shownumtargeting = true,
		highlightassist = true,
		growup = false,
		bartexture = "MainAssist",
		ctra = {
			enable = true,
			autoparty = false,
		},
		custom = {
			enable = true,
			hidectra = true,
			list = {}
		},
		smartassist = {
			ctra = true,
			custom = true,
			position = "FIRST"
		},
		clickcasting = {
			tank = false,
			target = false,
			targettarget = false
		},
		coloring = "Self",
	})
	self:RegisterDefaults('account', {
			tanks = {
				ctra = {},
				custom = {}
			},
			anchor = {
				x = 200,
				y = 200
			}
	})

	self.opts = {
		type = "group",
		args = {
			Add = {
				guiHidden = true,
				name = L["ADD"],
				type = "text",
				usage = L["ADD_USAGE"],
				desc = L["ADD_DESC"],
				order = 1,
				get = false,
				set = function(name) self:AddCustomTank(name) end
			},
			TankLists = {
				type = "header",
				name = L["TANK_LIST_HEADER"],
				order = 100,
			},
			Custom = {
				type = "group",
				name = L["CUSTOM"],
				desc = L["CUSTOM_DESC"],
				order = 101,
				args = {
					Add = {
						guiName = L["ADDNAME"],
						cmdName = L["ADD"],
						type = "text",
						usage = L["ADD_USAGE"],
						desc = L["ADD_DESC"],
						order = 1,
						get = false,
						set = function(name) self:AddCustomTank(name) end
					},
					AddTar = {
						guiName = L["ADDTARGET"],
						cmdName = L["ADDTARGET_SHORT"],
						type = "execute",
						desc = L["ADDTARGET_DESC"],
						order = 2,
						func = function() self:AddCustomTankFromTarget() end
					},
					Remove = {
						name = L["REMOVE"],
						desc = L["REMOVE_DESC"],
						order = 3,
						type = "text",
						current = "",
						get = function() return "" end,
						validate = self.db.account.tanks.custom,
						set = function(value) self:RemoveCustomTank(value) end
					},
					Arrange = {
						name = L["ARRANGE"],
						desc = L["ARRANGE_DESC"],
						cmdHidden = true,
						order = 4,
						type = "text",
						current = "",
						get = function() return "" end,
						validate = self.db.account.tanks.custom,
						set = 	function(value)	self:MoveCustomTank(value,IsShiftKeyDown()) end
					},
					Clear = {
						name = L["CLEAR"],
						type = "execute",
						desc = L["CLEAR_CUSTOM_DESC"],
						order = 5,
						func = function() self:ClearCustomTanks() end
					},
					HideCTRA = {
						name = L["HIDE_CTRA"],
						type = "toggle",
						desc = L["HIDE_CTRA_DESC"],
						order = 6,
						get = function() return self.db.profile.custom.hidectra end,
						set = function(value) self.db.profile.custom.hidectra = value self:RebuildTankList() end
					},
					Enable = {
						name = L["ENABLE"],
						type = "toggle",
						desc = L["ENABLE_CUSTOM_DESC"],
						order = 7,
						get = function() return self.db.profile.custom.enable end,
						set = function(value) self.db.profile.custom.enable = value self:RebuildTankList() end
					}
				}
			},
			CTRA = {
				type = "group",
				name = L["CTRA"],
				desc = L["CTRA_DESC"],
				order = 102,
				args = {
					Enable = {
						name = L["ENABLE"],
						type = "toggle",
						desc = L["ENABLE_CTRA_DESC"],
						get = function() return self.db.profile.ctra.enable end,
						set = function(value) self.db.profile.ctra.enable = value self:RebuildTankList() end
					},
					AutoParty = {
						name = L["CTRA_AUTOPARTY"],
						type = "toggle",
						desc = L["CTRA_AUTOPARTY_DESC"],
						get = function() return self.db.profile.ctra.autoparty end,
						set = function(value) self.db.profile.ctra.autoparty = value self:RebuildTankList() end
					}, 
					Broadcast = {
						name = L["BROADCAST_NOW"],
						type = "execute",
						hidden = function() return not (IsRaidLeader() or IsRaidOfficer()) end,
						desc = L["BROADCAST_DESC"],
						func = function() self:BroadcastCTRATanks() end,
					},
					Edit = {
						name = L["EDIT"],
						type = "text",
						desc = L["CTRA_EDIT_DESC"],
						hidden = function() return not (IsRaidLeader() or IsRaidOfficer()) end,
						get = false,
						set = function(value) 
						local _,_,num,name = string.find(value,"^(%d+): (.+)$")
							if UnitInRaid("target") and not IsShiftKeyDown() then
								self:SetCTRATank(num,UnitName("target"),true)
							else
								if name ~= L["-NONE-"] then
									self:RemoveCTRATank(name, true)
								end
							end
						end,
						validate = {"1: "..L["-NONE-"],
									"2: "..L["-NONE-"],
									"3: "..L["-NONE-"],
									"4: "..L["-NONE-"],
									"5: "..L["-NONE-"],
									"6: "..L["-NONE-"],
									"7: "..L["-NONE-"],
									"8: "..L["-NONE-"],
									"9: "..L["-NONE-"],
									"10: "..L["-NONE-"]},
					},
					Clear = {
						name = L["CLEAR"],
						type = "execute",
						hidden = function() return not (IsRaidLeader() or IsRaidOfficer()) end,
						desc = L["CLEAR_CTRA_DESC"],
						func = function() self:ClearCTRATanks(true) end
					},
				},				
			},
			Assists = {
				type = "group",
				name = L["ASSISTS"],
				desc = L["ASSISTS_OPTIONS"],
				order = 103,
				args = {
					List = {
						name = L["MAIN_ASSIST_LIST"],
						type = "header",
						order = 1,
					},
					CTRA = {
						name = L["CTRA"],
						type = "toggle",
						order = 2,
						desc = L["CTRA"],
						get = function() return self.db.profile.smartassist.ctra end,
						set = function(value) self.db.profile.smartassist.ctra = value self:RebuildTankList() end
					},
					Custom = {
						name = L["CUSTOM"],
						type = "toggle",
						order = 3,
						desc = L["CUSTOM"],
						get = function() return self.db.profile.smartassist.custom end,
						set = function(value) self.db.profile.smartassist.custom = value self:RebuildTankList() end
					},		
					
					Position = {
						name = L["MAIN_ASSIST_POSITION"],
						type = "header",
						order = 10,

					},
					First = {
						name = L["MAIN_ASSIST_FIRST"],
						type = "toggle",
						desc = L["MAIN_ASSIST_FIRST_DESC"],
						order = 11,
						get = function() return self.db.profile.smartassist.position == "FIRST" end,
						set = function(value) self.db.profile.smartassist.position = "FIRST" self:RebuildTankList() end
					},
					Last = {
						name = L["MAIN_ASSIST_LAST"],
						type = "toggle",
						desc = L["MAIN_ASSIST_LAST_DESC"],
						order = 11,
						get = function() return self.db.profile.smartassist.position == "LAST" end,
						set = function(value) self.db.profile.smartassist.position = "LAST" self:RebuildTankList() end
					}	
					
				}
			},
			ClickCasting = {
				type = "group",
				name = L["CLICKCASTING"],
				desc = L["CLICKCASTING_DESC"],
				order = 104,
				args = {
					Tank = {
						name = L["TANK"],
						type = "toggle",
						desc = L["CLICKCAST_TANK_DESC"],
						order = 1,
						get = function() return self.db.profile.clickcasting.tank end,
						set = function(value) self.db.profile.clickcasting.tank = value 
												if value then 
													self:EnableClickCasting("tank") 
												else 
													self:DisableClickCasting("tank") 
												end 
											end,						
					},
					Target = {
						name = L["TARGET"],
						type = "toggle",
						desc = L["CLICKCAST_TARGET_DESC"],
						order = 2,
						get = function() return self.db.profile.clickcasting.target end,
						set = function(value) self.db.profile.clickcasting.target = value 
												if value then 
													self:EnableClickCasting("target") 
												else 
													self:DisableClickCasting("target") 
												end 
											end,
					},
					TargetTarget = {
						name = L["TARGETTARGET"],
						type = "toggle",
						desc = L["CLICKCAST_TARGETTARGET_DESC"],
						order = 3,
						get = function() return self.db.profile.clickcasting.targettarget end,
						set = function(value) self.db.profile.clickcasting.targettarget = value 
												if value then 
													self:EnableClickCasting("targettarget") 
												else 
													self:DisableClickCasting("targettarget") 
												end 
											end,
					}
				},
			},
			ShowToT = {
				name = L["SHOWTOT_SHORT"],
				guiName = L["SHOWTOT"],
				type = "toggle",
				desc = L["SHOWTOT_DESC"],
				order = 105,
				get = function() return self.db.profile.showtot end,
				set = function(value) self.db.profile.showtot = value self:UpdateToTVisible() end,
			},
            ShowMTHealth = {
                name = L["SHOW_MTHP_SHORT"],
                guiName = L["SHOW_MTHP"],
                type = "toggle",
                desc = L["SHOW_MTHP_DESC"],
                order = 106,
                get = function() return self.db.profile.showmthealth end,
                set = function(value) self.db.profile.showmthealth = value end,
            },
			Tooltips = {
				type = "group",
				name = L["TOOLTIPS"],
				desc = L["TOOLTIPS_DESC"],
				order = 107,
				args = {
					ShowTargeting = {
						name = L["SHOW_TARGETING"],
						type = "toggle",
						desc = L["SHOW_TARGETING_DESC"],
						order = 1,
		                get = function() return self.db.profile.showtargeting end,
		                set = function(value) self.db.profile.showtargeting = value end,
					},
					DetailedTargets = {
						name = L["DETAILED_TOOLIP"],
						type = "toggle",
						desc = L["DETAILED_TOOLTIP_DESC"],
						order = 2,
		                get = function() return self.db.profile.detailedtooltip end,
		                set = function(value) self.db.profile.detailedtooltip = value end,
					},
					DetailedTooltipColumns = {
						name = L["DETAILED_TOOLIP_COLS"],
						type = "range",
						desc = L["DETAILED_TOOLTIP_COLS_DESC"],
						order = 3,
						min = 1,
						max = 3,
						step = 1,
						get = function() return self.db.profile.tooltipcols end,
						set = function(value) self.db.profile.tooltipcols = value end
					},
				}
			},
			HighlightAssist = {
				name = L["HIGHLIGHTASSIST_SHORT"],
				guiName = L["HIGHLIGHTASSIST"],
				type = "toggle",
				desc = L["HIGHLIGHTASSIST_DESC"],
				order = 108,
				get = function() return self.db.profile.highlightassist end,
				set = function(value) self.db.profile.highlightassist = value self:UpdateSmartAssistBindings() end,
			},			
			ShowNumTargeting = {
				name = L["SHOWNUMTARGETING_SHORT"],
				guiName = L["SHOWNUMTARGETING"],
				type = "toggle",
				desc = L["SHOWNUMTARGETING_DESC"],
				order = 109,
				get = function() return self.db.profile.shownumtargeting end,
				set = function(value) self.db.profile.shownumtargeting = value end,
			},
			Coloring = {
				name = L["COLORING"],
				type = "group",
				desc = L["COLORING_DESC"],
				order = 110,
				args = {
					Unique = {
						name = L["UNIQUE"],
						type = "toggle",
						desc = L["UNIQUE_DESC"],
						get = function() return self.db.profile.coloring == "Unique" end,
						set = function() self.db.profile.coloring = "Unique" end,
					},
					Self = {
						name = L["SELF"],
						type = "toggle",
						desc = L["SELF_DESC"],
						get = function() return self.db.profile.coloring == "Self" end,
						set = function() self.db.profile.coloring = "Self" end,
					},
					Class = {
						name = L["CLASS"],
						type = "toggle",
						desc = L["CLASS_DESC"],
						get = function() return self.db.profile.coloring == "Class" end,
						set = function() self.db.profile.coloring = "Class" end,
					},
					TargetClass = {
						name = L["TARGETCLASS"],
						type = "toggle",
						desc = L["TARGETCLASS_DESC"],
						get = function() return self.db.profile.coloring == "TargetClass" end,
						set = function() self.db.profile.coloring = "TargetClass" end,
					},
				},

			},
			BarTexture = {
				name = L["BAR_TEXTURE"],
				type = "text",
				desc = L["BAR_TEXTURE_DESC"],
				order = 111,
				usage = L["BAR_TEXTURE_USAGE"],
				get = function() return self.db.profile.bartexture end,
				set = function(value) self.db.profile.bartexture = value self:ApplyBarTexture() end,
				validate = SharedMedia:List("statusbar"),
			},
			Transparency = {
				name = L["TRANSPARENCY"],
				type = "range",
				desc = L["TRANSPARENCY_DESC"],
				order = 112,
				get = function() return self.db.profile.alpha end,
				set = function(value) self.db.profile.alpha = value self:ApplyAlpha() end,
				min = 0,
				max = 1,
				step = 0.1,
			},
			GrowUp = {
				guiName = L["GROWUP_GUI"],
				cmdName = L["GROWUP_CMD"],
				type = "toggle",
				desc = L["GROWUP_DESC"],
				order = 202,
				get = function() return self.db.profile.growup end,
				set = function(value) self.db.profile.growup = value 	
							self:RebuildTankList()
						end
			},
			spacer1 = {
				type = "header",
				order = 199,
			},
			Options = {
				name = L["OPTIONS"],
				type = "header",
				order = 200,
			},
			Scale = {
				name = L["SCALE"],
				type = "range",
				desc = L["SCALE_DESC"],
				order = 201,
				min = 0.5,
				max = 2,
				step = 0.1,
				get = function() return self.db.profile.scale end,
				set = function(value) self:ChangeScale(value) end
			},
			Lock = {
				name = L["LOCK"],
				type = "toggle",
				desc = L["LOCK_DESC"],
				order = 202,
				get = function() return self.db.profile.locked end,
				set = function(value) self.db.profile.locked = value 	
							self:UpdateAnchorVisible()
						end
			},
			Hide = {
				name = L["HIDELOCKED"],
				guiName = L["HIDELOCKED_GUI"],
				type = "toggle",
				desc = L["HIDELOCKED_DESC"],
				order = 203,
				get = function() return self.db.profile.hidewhenlocked end,
				set = function(value) self.db.profile.hidewhenlocked = value 	
							self:UpdateAnchorVisible()
						end
			},
			HideEmpty = {
				name = L["HIDEEMPTY"],
				guiName = L["HIDEEMPTY_GUI"],
				type = "toggle",
				desc = L["HIDEEMPTY_DESC"],
				order = 204,
				get = function() return self.db.profile.hidewhenempty end,
				set = function(value) self.db.profile.hidewhenempty = value 	
							self:UpdateAnchorVisible()
						end
			},			
			Reset = {
				guiName = L["RESET_GUI"],
				name = L["RESET"],
				desc = L["RESET_DESC"],
				type = "execute",
				order = 204,
				func = function() self.db.account.anchor.x = 200 self.db.account.anchor.y = 200 self:LoadAnchorPosition() end,
			},
			Menu = {
				name = L["MENU"],
				type = "execute",
				desc = L["MENU_DESC"],
				guiHidden = true,
				cmdHidden = false,
				func = function() self:ShowMenu() end
			}
		}
	}
	
	self.OnMenuRequest = self.opts
	
	--self.debugFrame = ChatFrame3
	--self:SetDebugging(true)
	
	self:InitColors()
	
	self.TargetingCounts = {}
	self.CTRAMessageQueue = {}
	self.SecureTankFrames = {}
	self.sortingTable = {}
	
	self:InitUniqueTargetList()
	
	for k, v in pairs(self.db.account.tanks.ctra) do
		self.opts.args.CTRA.args.Edit.validate[k] = k..": "..v
	end
	
	self:RegisterChatCommand({ "/maina" }, self.opts )
end

function MainAssist:OnEnable()
    --initilisation that needs to happen after PLAYER_LOGIN, but only needs to happen once
    if not self.Loaded then
    	self.Loaded = true
    	self:CreateAnchorFrame()
    	self:CreateHeaders()
		self:ApplyAlpha()
    end 
    self:RegisterEvent("CHAT_MSG_ADDON")
	self:RegisterEvent("CHAT_MSG_SYSTEM")
	self:RegisterEvent("PARTY_MEMBERS_CHANGED")
	self:RegisterEvent("PARTY_MEMBER_ENABLE","PARTY_MEMBERS_CHANGED");
	self:RegisterEvent("PARTY_MEMBER_DISABLE","PARTY_MEMBERS_CHANGED");
	self:RegisterEvent("UNIT_PET","PARTY_MEMBERS_CHANGED");
	self:RegisterEvent("PLAYER_PET_CHANGED","PARTY_MEMBERS_CHANGED")
	self:RegisterEvent("PLAYER_REGEN_ENABLED","OnLeaveCombat")
	self:RegisterEvent("UPDATE_BINDINGS","UpdateSmartAssistBindings")
	self:RegisterEvent("SharedMedia_Registered")
  
    self:UpdateToTVisible()
    
	--self:AutoPartyToCTRATanks()
	self:RebuildTankList()
    
    --schedule an update every 500ms
	self:ScheduleRepeatingEvent(function() self:OnUpdate() end, 0.5)
end

function MainAssist:OnLeaveCombat()
	if self.UpdatePending then
		self:RebuildTankList()
		self.UpdatePending = nil
	end
	
	if self.PositionPending then
		self:LoadAnchorPosition()		
		self.PositonPending = nil
	end
	
	if self.ScalePending then
		self:ChangeScale(self.ScalePending)
		self.ScalePending = nil
	end
	
	if self.PartyUpdatePending then
		if MainAssist_CustomPartyHeader:IsVisible() then
			self:InsecurePartyHeader_Update(self.CustomPartyHeader)
		end
	end
	
	if self.AssistBindingPending then
		self:UpdateSmartAssistBindings()
		self.AssistBindingPending = nil
	end
	
	if self.ShowAnchorPending then
		self:ShowAnchor()
	end
	
	if self.HideAnchorPending then
		self:HideAnchor()
	end
    
    if self.ToTUpdatePending then
        self:UpdateToTVisible()
    end
	self:SetAnchorColor(self.Colors["Text"])
end


function MainAssist:PARTY_MEMBERS_CHANGED()
	if InCombatLockdown() then
		self.PartyUpdatePending = true
		self.UpdatePending = true
		self:SetAnchorColor(self.Colors["Text-UpdateNeeded"])
	else
		self:RebuildTankList()
		if MainAssist_CustomPartyHeader:IsVisible() then
			self:InsecurePartyHeader_Update(self.CustomPartyHeader)
		end
	end
end

function MainAssist:OnDisable()
	self:HideAnchor()
end

function MainAssist:OnUpdate()
	self:UpdateTankFrames()
	self:ProcessCTRAMessageQueue()
	if tablet:IsRegistered(self.frame) then
		tablet:Refresh(self.frame)
	end
		
	if self.ScheduledBroadcast then
		self.ScheduledBroadcast = self.ScheduledBroadcast - 0.5
		
		if self.ScheduledBroadcast <= 0 then
			self:BroadcastCTRATanks()
			self.ScheduledBroadcast = nil
		end
	end
end

function MainAssist:SharedMedia_Registered()
	self.opts.args.BarTexture.validate = SharedMedia:List("statusbar")
end

----------------------------
-- Anchor Frame Functions --
----------------------------

function MainAssist:UpdateAnchorVisible()
	local numtanks = self:CountCTRATanks() + self:CountCustomTanks()
	if self.db.profile.ctra.autoparty then
		numtanks = numtanks + GetNumPartyMembers()
	end
	
	if (self.db.profile.locked and self.db.profile.hidewhenlocked) or (self.db.profile.hidewhenempty and numtanks == 0) then
		self:HideAnchor()
	else
		self:ShowAnchor()
	end 
end

function MainAssist:CreateAnchorFrame()

	self.AnchorFrame = CreateFrame("Frame","MainAssist_Anchor",UIParent)
	local f = self.AnchorFrame
	
	f:SetFrameStrata("BACKGROUND")
	f:SetWidth(160)
	f:SetHeight(13)
	
	f.Text = f:CreateFontString(nil,"OVERLAY","GameFontNormalSmall")
	f.Text:SetText("MainAssist")
	f.Text:SetAllPoints(f)
	self:SetAnchorColor(self.Colors["Text"])
	
	f:EnableMouse(true)
	f:SetMovable(true)
	f:SetClampedToScreen(true)
	
	f:SetScript("OnMouseDown",	function() 
									if not self.db.profile.locked then 
										this:StartMoving() 
									end 
								end )

	f:SetScript("OnMouseUp", 	function()
									this:StopMovingOrSizing()
									self:SaveAnchorPosition()
								end )

    dewdrop:Register(f,
   		'children', function()
   			dewdrop:FeedAceOptionsTable(self.opts)
   		end
	)
	f:SetScale(self.db.profile.scale)
	f:Show()
	
	self:LoadAnchorPosition()
	self:UpdateAnchorVisible()

end

function MainAssist:SetAnchorColor(color)
	if color and color.r and color.g and color.b then
		self.AnchorFrame.Text:SetVertexColor(color.r, color.g, color.b)
	end
end

function MainAssist:ApplyAlpha()
	self.CTRAPartyHeader:SetAlpha(self.db.profile.alpha)
	self.CTRARaidHeader:SetAlpha(self.db.profile.alpha)
	self.CustomPartyHeader:SetAlpha(self.db.profile.alpha)
	self.CustomRaidHeader:SetAlpha(self.db.profile.alpha)
	self.AnchorFrame:SetAlpha(self.db.profile.alpha)
end

function MainAssist:CreateHeaders()
	self.CTRAPartyHeader = CreateFrame("Frame","MainAssist_CTRAPartyHeader",self.AnchorFrame,"SecureGroupHeaderTemplate")
	self.CTRARaidHeader = CreateFrame("Frame","MainAssist_CTRARaidHeader",self.AnchorFrame,"SecureGroupHeaderTemplate")
	self.CustomPartyHeader = CreateFrame("Frame","MainAssist_CustomPartyHeader",self.AnchorFrame,"SecureGroupHeaderTemplate")
	self.CustomRaidHeader = CreateFrame("Frame","MainAssist_CustomRaidHeader",self.AnchorFrame,"SecureGroupHeaderTemplate")
	local color = self.Colors["Text"]
	
	local f = self.CTRAPartyHeader
	f:SetAttribute("showParty",true)
	f:SetAttribute("template","MainAssist_TankTemplate")
	f:SetFrameStrata("BACKGROUND")
	f:SetWidth(160)
	f:SetHeight(13)
	f.Text = f:CreateFontString(nil,"OVERLAY","GameFontNormalSmall")
	f.Text:SetText("Party Members")
	f.Text:SetPoint("BOTTOM",f,"TOP",40,0)
	f.Text:SetHeight(13) 
    f.Text:SetWidth(160)    
	f.Text:SetVertexColor(color.r, color.g, color.b)
	
	f:SetPoint("TOPLEFT",self.AnchorFrame,"BOTTOMLEFT",0,-13)
	f:Show()
	f:SetAttribute("minheight",13)
	
	local f = self.CustomPartyHeader
	f:SetAttribute("showParty",true)
	f:SetAttribute("template","MainAssist_TankTemplate")
	f:SetFrameStrata("BACKGROUND")
	f:SetWidth(160)
	f:SetHeight(13)
	f.Text = f:CreateFontString(nil,"OVERLAY","GameFontNormalSmall")
	f.Text:SetText("Custom Tanks")
	f.Text:SetPoint("BOTTOM",f,"TOP",40,0)
	f.Text:SetHeight(13) 
    f.Text:SetWidth(160)    
	f.Text:SetVertexColor(color.r, color.g, color.b)
	
	f:SetPoint("TOPLEFT",self.CTRAPartyHeader,"BOTTOMLEFT",0,-13)
	f:Show()
	f:SetAttribute("minheight",13)
	

	local f = self.CTRARaidHeader
	f:SetAttribute("showRaid",true)
	f:SetAttribute("template","MainAssist_TankTemplate")
	f:SetFrameStrata("BACKGROUND")
	f:SetWidth(160)
	f:SetHeight(13)
	f.Text = f:CreateFontString(nil,"OVERLAY","GameFontNormalSmall")
	f.Text:SetText("CTRA Tanks")
	f.Text:SetPoint("BOTTOM",f,"TOP",40,0)
	f.Text:SetHeight(13) 
    f.Text:SetWidth(160)    
	f.Text:SetVertexColor(color.r, color.g, color.b)
	
	f:SetPoint("TOPLEFT",self.AnchorFrame,"BOTTOMLEFT",0,-13)
	f:Show()
	f:SetAttribute("minheight",13)
	
	local f = self.CustomRaidHeader
	f:SetAttribute("showRaid",true)
	f:SetAttribute("template","MainAssist_TankTemplate")
	f:SetFrameStrata("BACKGROUND")
	f:SetWidth(160)
	f:SetHeight(13)
	f.Text = f:CreateFontString(nil,"OVERLAY","GameFontNormalSmall")
	f.Text:SetText("Custom Tanks")
	f.Text:SetPoint("BOTTOM",f,"TOP",40,0)
	f.Text:SetHeight(13) 
    f.Text:SetWidth(160)     
	f.Text:SetVertexColor(color.r, color.g, color.b)
	
	f:SetPoint("TOPLEFT",self.CTRARaidHeader,"BOTTOMLEFT",0,-13)
	f:Show()
	f:SetAttribute("minheight",13)
	f:SetAttribute("template","MainAssist_TankTemplate")	
	
	--frame to recieve key binding for fallback assist target
	self.SecureAssistFrame = CreateFrame("Button","MainAssist_SecureAssistFrame",UIParent,"SecureUnitButtonTemplate")
	self.SecureAssistFrame:SetAttribute("unit","target")
	self.SecureAssistFrame:SetAttribute("*type*","assist")
end

function MainAssist:ShowAnchor()
	if InCombatLockdown() then
		self.ShowAnchorPending = true
		self.HideAnchorPending = false
		self:SetAnchorColor(self.Colors["Text-UpdateNeeded"])
	else
		self.AnchorFrame.Text:SetText("MainAssist")
		self.AnchorFrame:EnableMouse(true)
	end
end

function MainAssist:HideAnchor()
	if InCombatLockdown() then
		self.ShowAnchorPending = false
		self.HideAnchorPending = true
		self:SetAnchorColor(self.Colors["Text-UpdateNeeded"])
	else
		self.AnchorFrame.Text:SetText("")
		self.AnchorFrame:EnableMouse(false)
	end
end

function MainAssist:SaveAnchorPosition()
	local s = MainAssist.AnchorFrame:GetEffectiveScale()
	self.db.account.anchor.x = this:GetLeft() * s
	self.db.account.anchor.y = this:GetTop() * s
end

function MainAssist:LoadAnchorPosition()		
	if InCombatLockdown() then
		self.PositionPending = true
		self:SetAnchorColor(self.Colors["Text-UpdateNeeded"])
	else
		local s = self.AnchorFrame:GetEffectiveScale()
		self.AnchorFrame:ClearAllPoints()
		self.AnchorFrame:SetPoint("TOPLEFT",UIParent,"BOTTOMLEFT", self.db.account.anchor.x / s, self.db.account.anchor.y / s)
	end
end

function MainAssist:ChangeScale(newscale)
	if InCombatLockdown() then
		self.ScalePending = newscale
		self:SetAnchorColor(self.Colors["Text-UpdateNeeded"])
	else
		self.db.profile.scale = newscale
		self.AnchorFrame:SetScale(newscale)
		self:LoadAnchorPosition()
	end
end
----------------------------------
-- Unique Target List Functions --
----------------------------------
function MainAssist:InitUniqueTargetList()
	self.RaidTargetList = {}
	self.PartyTargetList = {}
	
	local i
	for i = 1,40 do
		self.RaidTargetList["raid"..i] = 0
	end
	for i = 1,4 do	
		self.PartyTargetList["party"..i] = 0
		self.PartyTargetList["partypet"..i] = 0
	end
	self.PartyTargetList["pet"] = 0
	self.PartyTargetList["player"] = 0
end

function MainAssist:UpdateUniqueTargetList()
	local NextID = 1
	if GetNumRaidMembers() > 0 then
		self.UniqueTargets = self.RaidTargetList
	else
		self.UniqueTargets = self.PartyTargetList
	end
	local unitlist = self.UniqueTargets
	local countlist = self.TargetingCounts
	
	--empty the current lists
	for k,v in pairs(unitlist) do
		unitlist[k] = 0
	end
	for k,v in pairs(countlist) do
		countlist[k] = nil
	end
	
	--init the unit list
	for k,v in pairs(self.SecureTankFrames) do
		if v:IsVisible() then
			local unit = SecureButton_GetUnit(v)
			if unit then
				unitlist[unit] = 0
			end
		end
	end
	
	for unit,id in pairs(unitlist) do
		if unitlist[unit] == 0 and UnitExists(unit) and UnitExists(unit.."target") then
			--if unit exists, has a target, and hasnt already been assigned an id
			for unit2,id2 in pairs(unitlist) do
				--if this isnt the same unit but has the same target then tag as the same
				if unit ~= unit2 and UnitIsUnit(unit.."target",unit2.."target") then
					unitlist[unit] = id2
					break
				end
			end
			if unitlist[unit] == 0 then
				unitlist[unit] = NextID
				NextID = NextID + 1
			end
		else
			unitlist[unit] = 0
		end
		if not countlist[unitlist[unit]] then
			countlist[unitlist[unit]] = self:NumTargeting(unit.."target")
		end
	end
end

function MainAssist:NumTargeting(unit) 
	local PartyType = "";
	local NumMembers = 0;
	local Count = 0;
	if GetNumRaidMembers() > 0 then
		PartyType = "raid";
		NumMembers = GetNumRaidMembers();
	else
		PartyType = "party";
		NumMembers = GetNumPartyMembers();
		if UnitIsUnit("target",unit) then
			Count = Count + 1
		end
	end
	
	if NumMembers > 0 then
		for i = 1, NumMembers, 1 do
			if UnitExists(unit) and UnitIsUnit(PartyType..i.."target",unit) then
				Count = Count + 1
			end
		end
	end
	
	return Count
end

-------------------------
-- Tank List Functions --
-------------------------
function MainAssist:HideTankList(header)
	header:SetAttribute("nameList",nil)
	header:SetAttribute("minheight",1)
	header:Hide()
end

function MainAssist:ShowTankList(header,list,anchor)
	self:Debug("Showing tank list")

	header:ClearAllPoints()
	if self.db.profile.growup then
		local offset = 13
		if anchor == self.AnchorFrame then offset = 0 end
		header:SetPoint("BOTTOMLEFT",anchor,"TOPLEFT",0,offset)
	else
		header:SetPoint("TOPLEFT",anchor,"BOTTOMLEFT",0,-13)
	end
	header:Show()
	if list then
		header:SetAttribute("nameList",self:TankListToString(list))
	end
	header:SetAttribute("minheight",13)
	header:Show()
	
end

local tanksortlist = {}

function MainAssist:TankListToString(list)
	if not list then return "" end
	
	for k,v in pairs(tanksortlist) do
		tanksortlist[k] = nil
	end
	
	for k,v in pairs(list) do
		tinsert(tanksortlist,k)
	end
	
	table.sort(tanksortlist)
	
	
	local ret
	for k,v in ipairs(tanksortlist) do
		if ret then
			ret = ret..","..list[v]
		else
			ret = list[v]
		end
	end
	return ret
end

function MainAssist:ApplyBarTexture()
	local path = SharedMedia:Fetch("statusbar",self.db.profile.bartexture)

	for k, v in pairs(self.SecureTankFrames) do
		v.Background:SetTexture(path)
	    v.HPBackground:SetTexture(path)
	    v.HealthBar:SetTexture(path)
		v.TargetFrame.Background:SetTexture(path)
		v.TargetFrame.HealthBar:SetTexture(path)
		v.TargetTargetFrame.Background:SetTexture(path)
		v.TargetTargetFrame.HealthBar:SetTexture(path)

	end	
end

function MainAssist:UpdateToTVisible()
    if InCombatLockdown() then
        self.ToTUpdatePending = true
        self:SetAnchorColor(self.Colors["Text-UpdateNeeded"])
    else
        for k, v in pairs(self.SecureTankFrames) do
            if self.db.profile.showtot then
                v.TargetTargetFrame:Show()
            else
                v.TargetTargetFrame:Hide()
            end
        end	
    end
end

function MainAssist:RebuildTankList()
	local anchor = self.AnchorFrame
	
	if InCombatLockdown() then
		self.UpdatePending = true
		self:SetAnchorColor(self.Colors["Text-UpdateNeeded"])
	else
        self:UpdateAnchorVisible()
		if GetNumRaidMembers() > 0 then
			self:HideTankList(self.CTRAPartyHeader)
			self:HideTankList(self.CustomPartyHeader)
			
			if self:CountCTRATanks() > 0 and self.db.profile.ctra.enable then
				self:ShowTankList(self.CTRARaidHeader, self.db.account.tanks.ctra,anchor)
				anchor = self.CTRARaidHeader
			else
				self:HideTankList(self.CTRARaidHeader)
			end
			
			if self:CountCustomTanks() > 0 and self.db.profile.custom.enable then
				self:ShowTankList(self.CustomRaidHeader, self.db.account.tanks.custom,anchor)
				anchor = self.CustomRaidHeader
			else
				self:HideTankList(self.CustomRaidHeader)
			end
		else
			self:HideTankList(self.CTRARaidHeader)
			self:HideTankList(self.CustomRaidHeader)
			
			if GetNumPartyMembers() > 0 and self.db.profile.ctra.enable then
				if self.db.profile.ctra.autoparty then
					self:ShowTankList(self.CTRAPartyHeader, nil,anchor)
					anchor = self.CTRAPartyHeader
				else
					self:HideTankList(self.CTRAPartyHeader)
				end
			else
				self:HideTankList(self.CTRAPartyHeader)
			end
			
			if self:CountCustomTanks() > 0 and self.db.profile.custom.enable then
				self:ShowTankList(self.CustomPartyHeader, self.db.account.tanks.custom, anchor)
				self:InsecurePartyHeader_Update(self.CustomPartyHeader)
				anchor = self.CustomPartyHeader
			else
				self:HideTankList(self.CustomPartyHeader)
			end
		end
		
		self:UpdateTankFrames()
		self:UpdateSmartAssistBindings()
	end
end

function MainAssist:UpdateTankFrames()
	self:ResetColors()
	self:UpdateUniqueTargetList()

	for k, frame in pairs(self.SecureTankFrames) do
		if frame:IsVisible() then
			self:UpdateSecureTankFrame(frame)
			tablet:Refresh(frame)
		end
	end
end

-------------------------
-- CTRA Tank Functions --
-------------------------

function MainAssist:SetCTRATank(id,name,sendtoraid)
	local unit = self:NameToUnitID(name)
	
	if not (unit and UnitInRaid(unit)) then
		return
	end
	
	if sendtoraid then
		if IsRaidLeader() or IsRaidOfficer() then
			self:SendCTRAMessage("SET "..id.." "..name)							
		else
			self:Debug("Tried to send tank to raid when not promoted")
		end
	end
	self:RemoveCTRATank(name)
	self.db.account.tanks.ctra[tonumber(id)] = name
	self.opts.args.CTRA.args.Edit.validate[tonumber(id)] = id..": "..name
	self:RebuildTankList()
end

function MainAssist:RemoveCTRATank(name,sendtoraid)
	if sendtoraid then
		if IsRaidLeader() or IsRaidOfficer() then
			self:SendCTRAMessage("R "..name)
		end
	end
	for k, v in pairs(self.db.account.tanks.ctra) do
		if v == name then
			self.db.account.tanks.ctra[k] = nil
			self.opts.args.CTRA.args.Edit.validate[k] = k..": "..L["-NONE-"]
		end
	end
	self:RebuildTankList()
end

function MainAssist:ClearCTRATanks(sendtoraid)
	for k, v in pairs(self.db.account.tanks.ctra) do
		self.db.account.tanks.ctra[k] = nil
		self.opts.args.CTRA.args.Edit.validate[k] = k..": "..L["-NONE-"]
		if sendtoraid then
			if IsRaidLeader() or IsRaidOfficer() then
				self:SendCTRAMessage("R "..v)
			end
		end
	end
	self:RebuildTankList()
end

function MainAssist:CountCTRATanks()
	--has to be a better way to do this?
	local count = 0
	for k, v in pairs(self.db.account.tanks.ctra) do
		count = count+1
	end

	return count
end

function MainAssist:CTRAStatusRequest()
	--recieved a status request, send out an update of the ctra tanks in 5 seconds
	self.ScheduledBroadcast = 5
end

function MainAssist:RequestCTRAUpdate()
	self:SendCTRAMessage("SR")
end

function MainAssist:BroadcastCTRATanks()
	----[[
	--only broadcast tanks if you are the leader of the raid
	if IsRaidLeader() then
		for k, v in pairs(self.db.account.tanks.ctra) do
			self:SendCTRAMessage("SET "..k.." "..v) 
		end
	end
	--]]
end

function MainAssist:SendCTRAMessage(msg)
	table.insert(self.CTRAMessageQueue,msg)
end

function MainAssist:ProcessCTRAMessageQueue()
	--send out up to 3 queued messages
	local num = 0
	local sendmsg= nil
	local msg

	repeat
		msg = table.remove(self.CTRAMessageQueue,1)
		if msg then
			if sendmsg then
				sendmsg = sendmsg.."#"..msg
			else
				sendmsg = msg
			end
			num = num+1
		end
	until msg == nil or num == 3
	
	if num > 0 then
		self:Debug("->CTRA "..sendmsg)
		SendAddonMessage("CTRA",sendmsg,"RAID")
	end			
end

function MainAssist:IsPromoted(name)
	local unit = self:NameToUnitID(name)
	
	if not unit then
		return false
	end
	
	if unit == "player" then
		return IsRaidOfficer() or IsRaidLeader()
	end
	
	local _, _, index = string.find(unit, "^raid(%d+)$");
	if not index then 
		return false 
	end
	
	name, rank = GetRaidRosterInfo(index)
	
	return rank >= 1	
end


---------------------------
-- Custom Tank Functions --
---------------------------

function MainAssist:AddCustomTank(name)
	for k, v in pairs(self.db.account.tanks.custom) do
		if v == name then
			return
		end
	end
	table.insert(self.db.account.tanks.custom, name)
	self:RebuildTankList()
end

function MainAssist:AddCustomTankFromTarget()
	if UnitExists("target") then 
		self:AddCustomTank(UnitName("target"))
	end 
end

function MainAssist:RemoveCustomTank(name)
	for k, v in pairs(self.db.account.tanks.custom) do
		if v == name then
			table.remove(self.db.account.tanks.custom, k)
		end
	end
	self:RebuildTankList()
end

function MainAssist:ClearCustomTanks()
	while #self.db.account.tanks.custom > 0 do
		table.remove(self.db.account.tanks.custom)
	end
	self:RebuildTankList()
end

function MainAssist:CountCustomTanks()
	return #self.db.account.tanks.custom
end

--will either swap the positon of the 2 names given
--or if only one is in the list will replace it with the other
function MainAssist:SwapCustomTanks(name1,name2)
	if name1 and name2 then
		for k, v in pairs(self.db.account.tanks.custom) do
			if v == name1 then
				self.db.account.tanks.custom[k] = name2
			end
			if v == name2 then
				self.db.account.tanks.custom[k] = name1
			end
		end
		self:RebuildTankList()
	end
end
--moves the custom tank up(or down if given) one place in the list
function MainAssist:MoveCustomTank(name,down)
	local prev
	local done = false
	if down then
		for k, v in pairs(self.db.account.tanks.custom) do
			if prev == name then
				self:SwapCustomTanks(prev,v)
				done = true
			end
			prev = v
			if done then break end
		end
	else
		for k, v in pairs(self.db.account.tanks.custom) do
			if v == name then
				self:SwapCustomTanks(prev,v)
				done = true
			end
			prev = v
			if done then break end
		end
	end
end

----------------------------
-- Smart Assist Functions --
----------------------------

--sets the smart assist hotkey to the frame specified, or the default if none
function MainAssist:SetSmartAssistBindings(framename1,framename2)
	

	local assistkey1 = GetBindingKey("MA_ASSIST_MAINASSIST")
	local targetkey1 = GetBindingKey("MA_TARGET_MAINASSIST")

	local assistkey2 = GetBindingKey("MA_ASSIST_SECONDARYASSIST")
	local targetkey2 = GetBindingKey("MA_TARGET_SECONDARYASSIST")
	
	local targetframename1
	local targetframename2
	
	ClearOverrideBindings(MainAssist_SecureAssistFrame)
	
	if framename1 then
		targetframename1 = framename1.."Target"
	end
	if framename2 then
		targetframename2 = framename2.."Target"
	end	
	
	if assistkey1 then
		SetOverrideBindingClick(MainAssist_SecureAssistFrame,nil,assistkey1, targetframename1 or "MainAssist_SecureAssistFrame") 
	end	
	if targetkey1 and framename1 then
		SetOverrideBindingClick(MainAssist_SecureAssistFrame,nil,targetkey1, framename1) 
	end	
	
	if assistkey2 then
		SetOverrideBindingClick(MainAssist_SecureAssistFrame,nil,assistkey2, targetframename2 or "MainAssist_SecureAssistFrame") 
	end	
	if targetkey2 and framename2 then
		SetOverrideBindingClick(MainAssist_SecureAssistFrame,nil,targetkey2, framename2) 
	end		

	local textcolor
	for k,frame in pairs(self.SecureTankFrames) do
		if self.db.profile.highlightassist and framename1 == frame:GetName() then
			textcolor = self.Colors["Text-Assist"]
		else
			if self.db.profile.highlightassist and framename2 == frame:GetName() then
				textcolor = self.Colors["Text-Assist2"]
			else
				textcolor = self.Colors["Text"]
			end	
		end
		frame.NameText:SetVertexColor(textcolor.r, textcolor.g, textcolor.b)
	end
	
end

function MainAssist:UpdateSmartAssistBindings()
	if InCombatLockdown() then
		self.AssistBindingPending = true
		self:SetAnchorColor(self.Colors["Text-UpdateNeeded"])
	else
		local frame1, frame2

		--find a custom assist in the visible tank frames
		if self.db.profile.smartassist.customname then
			local found = false
			for k,v in pairs(self.SecureTankFrames) do
				if v:IsVisible() then
					local unit = SecureButton_GetUnit(v)
					if unit then
						local name = UnitName(unit)
						if name == self.db.profile.smartassist.customname then
							frame1 = v:GetName() 
							found = true;
						end
					end
				end
			end

			if not found then
				self:Print(L["RESET_MAINASSIST"])
				self.db.profile.smartassist.customname = nil 
			end
		end
		if self.db.profile.smartassist.customname2 then
			local found = false
			for k,v in pairs(self.SecureTankFrames) do
				if v:IsVisible() then
					local unit = SecureButton_GetUnit(v)
					if unit then
						local name = UnitName(unit)
						if name == self.db.profile.smartassist.customname2 then
							frame2 = v:GetName() 
						end
					end
				end
			end
		end		

		if not self.db.profile.smartassist.customname then
			local comp
			local CustomFrame
			local CustomID
			local CTRAFrame
			local CTRAID
			local ID

			if self.db.profile.smartassist.position == "FIRST" then
				comp = math.min
			else
				comp = math.max
			end

			for k,frame in pairs(self.SecureTankFrames) do
				if frame:IsVisible() then
					if frame.list == "CTRA" then
						ID = tonumber(string.match(frame:GetName(),"^.+(%d+)$"))
						CTRAID = comp(ID,CTRAID or ID)
						if ID == CTRAID then 
							CTRAFrame = frame:GetName() 
						end
					elseif frame.list == "Custom" then
						ID = tonumber(string.match(frame:GetName(),"^.+(%d+)$"))
						CustomID = comp(ID,CustomID or ID)
						if ID == CustomID then 
							CustomFrame = frame:GetName()
						end
					end
				end
			end
			frame1 = CTRAFrame or CustomFrame
		end	
		
		self:SetSmartAssistBindings(frame1,frame2)
	end

	
end

function MainAssist:SetMainAssist(name)
	self.db.profile.smartassist.customname = name
	self:UpdateSmartAssistBindings()
end

function MainAssist:GetMainAssist() 
	return self.db.profile.smartassist.customname
end

function MainAssist:SetSecondaryAssist(name)
	self.db.profile.smartassist.customname2 = name
	self:UpdateSmartAssistBindings()
end

function MainAssist:GetSecondaryAssist()
	return self.db.profile.smartassist.customname2
end

----------------------
-- Color Management --
----------------------

--returns a color, if called again with the same id will return the same color
--returns nil if there aren't enough colors defined
function MainAssist:GetColor(id)
	local c = nil
	for k,v in pairs(self.ColorCache) do
		if v.inUse == nil or v.inUse == id then
			self.ColorCache[k].inUse = id
			c = v.color
			break
		end
	end
	return c
end

--will reset the colors associated with id
function MainAssist:ResetColors()
	for k,v in pairs(self.ColorCache) do
		self.ColorCache[k].inUse = nil
	end
end

function MainAssist:InitColors()
	self.ColorCache = {
	    { color = { r=0.5, g=0.0, b=0.0 }}, --deep red
	    { color = { r=1.0, g=0.0, b=0.0 }}, --red
	    { color = { r=1.0, g=0.5, b=0.0 }}, --orange
	    { color = { r=1.0, g=1.0, b=0.0 }}, --yellow
	    { color = { r=0.0, g=1.0, b=1.0 }}, --teal  
	    { color = { r=0.0, g=0.5, b=1.0 }}, --light blue    
	    { color = { r=0.0, g=0.0, b=1.0 }}, --blue
	    { color = { r=0.0, g=0.0, b=0.5 }}, --dark blue
	    { color = { r=1.0, g=0.0, b=1.0 }}, --magenta   
	    { color = { r=0.5, g=0.0, b=1.0 }}, --deep purple   
	}
	
	self.Colors = {
		["Targeted"]    = { r=0.0, g=1.0, b=0.0 }, --green
    	["NoTarget"]    = { r=0.5, g=0.5, b=0.5 }, --grey
    	["Text"]        = { r=1.0, g=1.0, b=1.0 },
    	["Text-Assist"] = { r=0.2, g=1.0, b=0.2 },
		["Text-Assist2"] = { r=0.4, g=0.4, b=1.0 },
    	["Text-UpdateNeeded"] = { r=1, g=0.2, b=0.2 },
    }
end

function MainAssist:GetColorForAssist(unit)
	
	
		if self.db.profile.coloring == "Unique" then
			if UnitExists(unit.."target") then
				local found = false
				for k,v in pairs(self.SecureTankFrames) do
					if v:IsVisible() then
						local unit2 = SecureButton_GetUnit(v)
						if unit ~= unit2 and UnitIsUnit(unit.."target",unit2.."target") then
							found = true
							break
						end
					end
				end
				if not found then
					return self.Colors["Targeted"]
				else
					return self:GetColor(self.UniqueTargets[unit])
				end
			else
				return self.Colors["NoTarget"]
			end
		elseif self.db.profile.coloring == "Class" then
			local _, class = UnitClass(unit) 
			if class then
				return RAID_CLASS_COLORS[class]
			else
				return self.Colors["NoTarget"]
			end
		elseif self.db.profile.coloring == "TargetClass" then
			local _, class = UnitClass(unit.."target") 
			if class then
				return RAID_CLASS_COLORS[class]
			else
				return self.Colors["NoTarget"]
			end
		else
			if UnitExists(unit.."target") then
				if UnitIsUnit(unit.."target","target") then
					return self.Colors["Targeted"]
				else
					return self:GetColor(self.UniqueTargets[unit])
				end
			else
				return self.Colors["NoTarget"]
			end
		end
end

-----------------------
-- Utility Functions --
-----------------------

--finds a unitid based on a name
--searches the following in order
-- player, party members, pet, target, party pets, party targets
function MainAssist:NameToUnitID(unitName)
    if UnitName("player") == unitName then
    	return "player"
    end

    local PartyType = "";
    local NumMembers = 0;
    if GetNumRaidMembers() > 0 then
        PartyType = "raid";
        NumMembers = GetNumRaidMembers();
    else
        PartyType = "party";
        NumMembers = GetNumPartyMembers();
    end
    
    if NumMembers > 0 then
        for i = 1, NumMembers, 1 do
            if UnitName(PartyType..i) == unitName then
            	return PartyType..i
            end
        end
    end
    
	if UnitName("target") == unitName then
		return "target"
	end
	if UnitName("pet") == unitName then
		return "pet"
    end
    
    if NumMembers > 0 then
		for i = 1, NumMembers, 1 do
			if UnitName(PartyType.."pet"..i) == unitName then
				return PartyType.."pet"..i
			end
		end
		for i = 1, NumMembers, 1 do
			if UnitName(PartyType..i.."target") == unitName then
				return PartyType..i.."target"
			end
        end
   	end
    
    return nil;
end

function MainAssist:ShowMenu()
	dewdrop:Open(self.AnchorFrame)
end

--------------------
-- Event Handlers --
--------------------

function MainAssist:CHAT_MSG_ADDON(prefix,msg,type,sender)
	--CTRA messages, for watching changes to the Tank List
	if prefix == "CTRA" then
		if ( string.find(msg, "#") ) then
			--split the message and process the parts
   			local init, mstart, mend, value = 1;
		   	repeat
				mstart, mend, value = string.find(msg, "([^#]+)", init);
				if ( value ) then
					self:CHAT_MSG_ADDON(prefix,value,type,sender)
					init = mend + 1;
				end
		   	until not value;
		else	
			if self:IsPromoted(sender) then
				--Messages that require the sender to be promoted
				if ( strsub(msg, 1, 4) == "SET " ) then
					self:Debug("CTRA-> "..sender..": "..msg)
					local _, _, id, name = string.find(msg, "^SET (%d+) (.+)$");
					self:SetCTRATank(id, name)
				end

				if ( strsub(msg, 1, 2) == "R " ) then
					self:Debug("CTRA-> "..sender..": "..msg)
					local _, _, name = string.find(msg, "^R (.+)$");
					for k, v in pairs(self.db.account.tanks.ctra) do
						if v == name then
							self:RemoveCTRATank(name)
						end
					end
				end
			end
			
			--messages that anyone can send
			if ( strsub(msg, 1, 2) == "SR" ) then
				self:Debug("CTRA-> "..sender..": "..msg)
				self:CTRAStatusRequest()
			end
		end
	end
end

function MainAssist:CHAT_MSG_SYSTEM(msg)
	local name = deformat(msg, ERR_RAID_MEMBER_REMOVED_S)
	if name then
		self:RemoveCTRATank(name)	
	end
	
	if string.find(msg, ERR_RAID_YOU_LEFT) then
		self:ClearCTRATanks()
		self:ScheduleEvent(function() self:RebuildTankList() end,1)
	end
	
	if string.find(msg, ERR_RAID_YOU_JOINED) then
		self:ClearCTRATanks()
		self:RequestCTRAUpdate()
		self:ScheduleEvent(function() self:RebuildTankList() end,1) 
	end
end


----------------
-- TBC Frames --
----------------

function MainAssist:CreateAssistFrame(frame,parent,width,height)
	local bartexture = SharedMedia:Fetch("statusbar",self.db.profile.bartexture)
	
	frame.FRAME_WIDTH = width
	frame.FRAME_HEIGHT = height
	
	frame:SetWidth(width)
	frame:SetHeight(height)
	
	--Background Texture
	frame.Background = frame:CreateTexture(nil,"BACKGROUND")
	frame.Background:SetTexture(bartexture)
	frame.Background:SetVertexColor(0.2,0.2,0.2,1)
	frame.Background:SetAllPoints(frame)
	
	--HealthBar Texture
	frame.HealthBar = frame:CreateTexture(nil,"OVERLAY")
	frame.HealthBar:SetTexture(bartexture)
	frame.HealthBar:SetVertexColor(0,0.6,0.35,1)
	frame.HealthBar:SetPoint("TOPLEFT",frame,"TOPLEFT",0,0)
	frame.HealthBar:SetPoint("BOTTOMLEFT",frame,"BOTTOMLEFT",0,0)
	frame.HealthBar:SetWidth(frame.FRAME_WIDTH)
	
	--Top line of text showing name
	frame.NameText = frame:CreateFontString(nil,"OVERLAY","GameFontNormalSmall")
	frame.NameText:SetText("")
	frame.NameText:SetPoint("TOPLEFT",frame,"TOPLEFT",0,0)
	frame.NameText:SetPoint("TOPRIGHT",frame,"TOPRIGHT",0,0)
	frame.NameText:SetHeight(frame.FRAME_HEIGHT/2)
	frame.NameText:SetVertexColor(1, 1, 1)
	
	--Bottom line of text for status
	frame.StatusText = frame:CreateFontString(nil,"OVERLAY","GameFontNormalSmall")
	frame.StatusText:SetText("")
	frame.StatusText:SetPoint("BOTTOMLEFT",frame,"BOTTOMLEFT",0,2)
	frame.StatusText:SetPoint("BOTTOMRIGHT",frame,"BOTTOMRIGHT",0,2)
	frame.StatusText:SetHeight(frame.FRAME_HEIGHT/2)
	frame.StatusText:SetVertexColor(1, 1, 1)
end

function MainAssist:CreateTankFrame(frame)	
	local bartexture = SharedMedia:Fetch("statusbar",self.db.profile.bartexture)
	
	frame.FRAME_WIDTH = 80
	frame.FRAME_HEIGHT = 26
		
	frame:SetWidth(frame.FRAME_WIDTH)
	frame:SetHeight(frame.FRAME_HEIGHT)
	
	--Background Texture
	frame.Background = frame:CreateTexture(nil,"BACKGROUND")
	frame.Background:SetTexture(bartexture)
	frame.Background:SetVertexColor(0.2,0.2,0.2,1)
	frame.Background:SetAllPoints(frame)
    
    	--Background Texture
	frame.HPBackground = frame:CreateTexture(nil,"ARTWORK")
	frame.HPBackground:SetTexture(bartexture)
	frame.HPBackground:SetVertexColor(0.2,0.2,0.2,1)
    frame.HPBackground:SetPoint("BOTTOMLEFT",frame,"BOTTOMLEFT",0,0)
    frame.HPBackground:SetPoint("BOTTOMRIGHT",frame,"BOTTOMRIGHT",0,0)
	frame.HPBackground:SetHeight(frame.FRAME_HEIGHT/2)
    frame.HPBackground:SetTexCoord(0,1,0.5,1)
	
	--HealthBar Texture
	frame.HealthBar = frame:CreateTexture(nil,"OVERLAY")
	frame.HealthBar:SetTexture(bartexture)
	frame.HealthBar:SetVertexColor(0,0.6,0.35,1)
	frame.HealthBar:SetPoint("BOTTOMLEFT",frame,"BOTTOMLEFT",0,0)
    frame.HealthBar:SetHeight(frame.FRAME_HEIGHT/2)
	frame.HealthBar:SetWidth(frame.FRAME_WIDTH)
    frame.HealthBar:SetTexCoord(0,1,0.5,1)
	
	--Top line of text showing name
	frame.NameText = frame:CreateFontString(nil,"OVERLAY","GameFontNormalSmall")
	frame.NameText:SetText("")
	frame.NameText:SetPoint("TOPLEFT",frame,"TOPLEFT",0,0)
	frame.NameText:SetPoint("TOPRIGHT",frame,"TOPRIGHT",0,0)
	frame.NameText:SetHeight(frame.FRAME_HEIGHT/2)
	frame.NameText:SetVertexColor(1, 1, 1)

	--Bottom line of text for status
	frame.StatusText = frame:CreateFontString(nil,"OVERLAY","GameFontNormalSmall")
	frame.StatusText:SetText("")
	frame.StatusText:SetPoint("BOTTOMLEFT",frame,"BOTTOMLEFT",0,2)
	frame.StatusText:SetPoint("BOTTOMRIGHT",frame,"BOTTOMRIGHT",0,2)
	frame.StatusText:SetHeight(frame.FRAME_HEIGHT/2)
	frame.StatusText:SetVertexColor(1, 1, 1)
	
	frame:RegisterForClicks("LeftButtonUp", "RightButtonUp", "LeftButtonDown")
	
	frame.TargetFrame = CreateFrame("Button",frame:GetName().."Target",frame,"SecureActionButtonTemplate")
	self:CreateAssistFrame(frame.TargetFrame,frame,frame.FRAME_WIDTH,frame.FRAME_HEIGHT)
	frame.TargetFrame:SetPoint("TOPLEFT",frame,"TOPRIGHT",0,0)
	
	frame.TargetTargetFrame = CreateFrame("Button",frame:GetName().."TargetTarget",frame,"SecureActionButtonTemplate")
	self:CreateAssistFrame(frame.TargetTargetFrame,frame,frame.FRAME_WIDTH,frame.FRAME_HEIGHT)
	frame.TargetTargetFrame:SetPoint("TOPLEFT",frame.TargetFrame,"TOPRIGHT",0,0)
	
	frame.RaidIcon = frame:CreateTexture(nil,"OVERLAY")
	frame.RaidIcon:SetWidth(20);
	frame.RaidIcon:SetHeight(20);
	frame.RaidIcon:Hide();
	frame.RaidIcon:SetPoint("RIGHT",frame,"LEFT",0,0);
	frame.RaidIcon:SetTexture("Interface\\TargetingFrame\\UI-RaidTargetingIcons")
	
	frame:SetAttribute("*type1","target")
	frame:SetAttribute("*type2","OpenDewdrop")
	
	frame.TargetFrame:SetAttribute("useparent-unit", true)
	frame.TargetFrame:SetAttribute("unitsuffix", "target")
	frame.TargetFrame:SetAttribute("*type1","target")
	
	frame.TargetTargetFrame:SetAttribute("useparent-unit", true)
	frame.TargetTargetFrame:SetAttribute("unitsuffix", "targettarget")
	frame.TargetTargetFrame:SetAttribute("*type1","target")					
					
	frame.OpenDewdrop = function(self, unit, button)
							dewdrop:Open(self)		
					    end
					    
	dewdrop:Register(frame,
						'children', function(level, value) MainAssist:CreateAssistContextDD(frame, level, value) end,
						'dontHook', true)
	
	if frame:GetParent() == MainAssist_CTRAPartyHeader or frame:GetParent() == MainAssist_CTRARaidHeader then
		frame.list = "CTRA"
	end
	if frame:GetParent() == MainAssist_CustomPartyHeader or frame:GetParent() == MainAssist_CustomRaidHeader then
		frame.list = "Custom"
	end
	
	frame.FillTargetingTablet = function()
		self:FillTargetingTablet(frame)
	end
	
	self:CreateTargetingTablet(frame)
	
	frame:SetScript("OnEnter",function() 
		if self.db.profile.showtargeting then
			tablet:Open(frame) 
		end
	end)
	frame:SetScript("OnLeave",function() 
		tablet:Close(frame) 
	end)
	
	
	self:RegisterSecureTankFrame(frame)
	self:UpdateToTVisible()
	frame:SetAlpha(frame:GetParent():GetAlpha())
end

function MainAssist:RegisterSecureTankFrame(frame)
	table.insert(self.SecureTankFrames,frame)
	
	if self.db.profile.clickcasting.tank then
		ClickCastFrames[frame] = true
	end
	if self.db.profile.clickcasting.target then
		ClickCastFrames[frame.TargetFrame] = true
	end
	if self.db.profile.clickcasting.targettarget then
		ClickCastFrames[frame.TargetTargetFrame] = true
	end
end

function MainAssist:EnableClickCasting(frametype)
	for k,v in pairs(self.SecureTankFrames) do
		if frametype == "tank" then
			ClickCastFrames[v] = true
		elseif frametype == "target" then
			ClickCastFrames[v.TargetFrame] = true
		elseif frametype == "targettarget" then
			ClickCastFrames[v.TargetTargetFrame] = true
		end
	end
end

function MainAssist:DisableClickCasting(frametype)
	for k,v in pairs(self.SecureTankFrames) do
		if frametype == "tank" then
			ClickCastFrames[v] = nil
		elseif frametype == "target" then
			ClickCastFrames[v.TargetFrame] = nil
		elseif frametype == "targettarget" then
			ClickCastFrames[v.TargetTargetFrame] = nil
		end
	end
end

function MainAssist:CreateAssistContextDD(frame, level, value)
	-- Create drewdrop menu
	local name = UnitName(SecureButton_GetUnit(frame))
	if name then
		if level == 1 then
			dewdrop:AddLine('text', name, 'isTitle', true )
			if frame.list == "Custom" then
				dewdrop:AddLine('text', L["MOVE_UP"],
								'func', function(name) MainAssist:MoveCustomTank(name) end,
								'closeWhenClicked', true,
								'arg1', name )
				dewdrop:AddLine('text', L["MOVE_DOWN"],
								'func', function(name) MainAssist:MoveCustomTank(name,true) end,
								'closeWhenClicked', true,
								'arg1', name )	
				dewdrop:AddLine('text', "", 'isTitle', true )
				dewdrop:AddLine('text', L["REMOVE"],
								'func', function(name) MainAssist:RemoveCustomTank(name) end,
								'closeWhenClicked', true,
								'arg1', name )
				dewdrop:AddLine('text', "", 'isTitle', true )
			end

			if frame.list == "CTRA" and ( IsRaidLeader() or IsRaidOfficer() ) then
				dewdrop:AddLine('text', L["REMOVE"],
											'func', function(name) MainAssist:RemoveCTRATank(name,true) end,
											'closeWhenClicked', true,
								'arg1', name )
				dewdrop:AddLine('text', "", 'isTitle', true )
			end

			if MainAssist:GetMainAssist() == name then
				dewdrop:AddLine('text', L["CLEAR_MAIN_ASSIST"],
								'func', function(name) MainAssist:SetMainAssist(nil) end,
								'closeWhenClicked', true,
								'arg1', name )
			else
				dewdrop:AddLine('text', L["SET_MAIN_ASSIST"],
								'func', function(name) MainAssist:SetMainAssist(name) end,
								'closeWhenClicked', true,
								'arg1', name )
			end
			
			if MainAssist:GetSecondaryAssist() == name then
				dewdrop:AddLine('text', L["CLEAR_SECONDARY_ASSIST"],
								'func', function(name) MainAssist:SetSecondaryAssist(nil) end,
								'closeWhenClicked', true,
								'arg1', name )
			else
				dewdrop:AddLine('text', L["SET_SECONDARY_ASSIST"],
								'func', function(name) MainAssist:SetSecondaryAssist(name) end,
								'closeWhenClicked', true,
								'arg1', name )
			end
		end
	end
end		
	
function MainAssist:UpdateSecureTankFrame(frame)
	local assist = SecureButton_GetUnit(frame)
	local target = SecureButton_GetUnit(frame.TargetFrame)
	local targettarget = SecureButton_GetUnit(frame.TargetTargetFrame)

	if UnitExists(assist) then
		frame.NameText:SetText(UnitName(assist))
		
		local color = self:GetColorForAssist(assist)
		if color then 
			frame.Background:SetVertexColor(color.r,color.g,color.b) 
		end
        local status = nil
        
        if self.db.profile.showmthealth then
            local hp = UnitHealth(assist)/UnitHealthMax(assist)
            hp = max(0,min(hp, 1))
            frame.HPBackground:Show()
            if hp > 0 then
                frame.HealthBar:Show()
                frame.HealthBar:SetWidth( hp * frame.FRAME_WIDTH )
                frame.HealthBar:SetTexCoord(0,hp,0.5,1)
                status = math.floor(hp*100).."%"
            else
                frame.HealthBar:Hide()
            end
        else
            frame.HealthBar:Hide()
            frame.HPBackground:Hide()
        end
		
		
		if UnitIsDead(assist) then
			status = L["STATUS_DEAD"]
		end
		
		local numtargeting
		if self.db.profile.shownumtargeting then
			numtargeting = self.TargetingCounts[self.UniqueTargets[assist]]
		end
		
		if numtargeting then
			if status then
				status = "("..numtargeting..") "..status
			else
				status = "("..numtargeting..")"
			end
		end
		frame.StatusText:SetText(status)
	end

	if UnitExists(target) then
		frame.TargetFrame.NameText:SetText(UnitName(target))

		local hp = UnitHealth(target)/UnitHealthMax(target)
		hp = max(0,min(hp, 1))
		if hp > 0 then
			frame.TargetFrame.HealthBar:Show()
			frame.TargetFrame.HealthBar:SetWidth( hp * frame.FRAME_WIDTH )
			frame.TargetFrame.HealthBar:SetTexCoord(0,hp,0,1)
		else
			frame.TargetFrame.HealthBar:Hide()
		end
		if hp > 0 then
			frame.TargetFrame.StatusText:SetText(math.floor(hp*100).."%")
		else
			frame.TargetFrame.StatusText:SetText(L["STATUS_DEAD"])
		end

		local iconindex = GetRaidTargetIndex(target)
		if iconindex then
			local iconinfo = UnitPopupButtons["RAID_TARGET_"..iconindex];
			if iconinfo then
				frame.RaidIcon:SetTexCoord(iconinfo.tCoordLeft,iconinfo.tCoordRight,iconinfo.tCoordTop,iconinfo.tCoordBottom);
				frame.RaidIcon:Show();
			else
				frame.RaidIcon:Hide();
			end
		else
			frame.RaidIcon:Hide();
		end
	else
		frame.TargetFrame.HealthBar:Hide()
		frame.TargetFrame.StatusText:SetText()
		frame.TargetFrame.NameText:SetText(L["STATUS_NONE"])
	end

	if frame.TargetTargetFrame:IsVisible() then 
		if UnitExists(targettarget) then
			frame.TargetTargetFrame.NameText:SetText(UnitName(targettarget))	

			local hp = UnitHealth(targettarget)/UnitHealthMax(targettarget)
			hp = max(0,min(hp, 1))
			if hp > 0 then
				frame.TargetTargetFrame.HealthBar:Show()
				frame.TargetTargetFrame.HealthBar:SetWidth( hp * frame.FRAME_WIDTH )
				frame.TargetFrame.HealthBar:SetTexCoord(0,hp,0,1)
			else
				frame.TargetTargetFrame.HealthBar:Hide()
			end
			if hp > 0 then
				frame.TargetTargetFrame.StatusText:SetText(math.floor(hp*100).."%")
			else
				frame.TargetTargetFrame.StatusText:SetText(L["STATUS_DEAD"])
			end
		else
			frame.TargetTargetFrame.HealthBar:Hide()
			frame.TargetTargetFrame.StatusText:SetText()
			frame.TargetTargetFrame.NameText:SetText(L["STATUS_NONE"])
		end
	end
end


--------------------------
-- Insecure Party Header--
--------------------------
--Copy of the Secure Raid Header Logic, that will allow nameList to be used on a Party, including yourself and pets
--Doesnt have the advantage of updating dynamically in combat
--but partys shouldn't move around unless its joining, and cant add another name in combat anyway

-- relativePoint, xMultiplier, yMultiplier = getRelativePointAnchor( point )
-- Given a point return the opposite point and which axes the point
-- depends on.
local function getRelativePointAnchor( point )
	point = strupper(point);
	if (point == "TOP") then
		return "BOTTOM", 0, -1;
	elseif (point == "BOTTOM") then
		return "TOP", 0, 1;
	elseif (point == "LEFT") then
		return "RIGHT", 1, 0;
	elseif (point == "RIGHT") then
		return "LEFT", -1, 0;
	elseif (point == "TOPLEFT") then
		return "BOTTOMRIGHT", 1, -1;
	elseif (point == "TOPRIGHT") then
		return "BOTTOMLEFT", -1, -1;
	elseif (point == "BOTTOMLEFT") then
		return "TOPRIGHT", 1, 1;
	elseif (point == "BOTTOMRIGHT") then
		return "TOPLEFT", -1, 1;
	else
		return "CENTER", 0, 0;
	end
end

-- empties tbl and assigns the value true to each key passed as part of ...
local function fillTable( tbl, ... )
	for key in pairs(tbl) do
		tbl[key] = nil;
	end
	for i = 1, select("#", ...), 1 do
		local key = select(i, ...);
		key = tonumber(key) or key;
		tbl[key] = true;
	end
end

-- same as fillTable() except that each key is also stored in 
-- the array portion of the table in order
local function doubleFillTable( tbl, ... )
	fillTable(tbl, ...);
	for i = 1, select("#", ...), 1 do
		tbl[i] = select(i, ...);
	end
end

-- creates child frames and finished configuring them
function MainAssist:InsecurePartyHeader_ConfigureChildren(frame)
	local point = frame:GetAttribute("point") or "TOP"; --default anchor point of "TOP"
	local relativePoint, xOffsetMult, yOffsetMult = getRelativePointAnchor(point);
	local xMultiplier, yMultiplier =  abs(xOffsetMult), abs(yOffsetMult);
	local xOffset = frame:GetAttribute("xOffset") or 0; --default of 0
	local yOffset = frame:GetAttribute("yOffset") or 0; --default of 0
	local sortMethod = frame:GetAttribute("sortMethod") or "INDEX"; --sort by ID by default
	local sortDir = frame:GetAttribute("sortDir") or "ASC"; --sort ascending by default

	local sortingTable = self.sortingTable
	
	if ( sortMethod == "NAME" ) then
		table.sort(sortingTable);
	end
	
	local unitCount = #sortingTable;

	-- ensure there are enough buttons
	local needButtons = max(1, unitCount);
	if not ( frame:GetAttribute("child"..needButtons) ) then
		local buttonTemplate = frame:GetAttribute("template");
		local templateType = frame:GetAttribute("templateType") or "Button";
		local name = frame:GetName();
		if not ( buttonTemplate and name ) then
			frame:Hide();
			return;
		end
		for i = 1, needButtons, 1 do
			if not ( frame:GetAttribute("child"..i) ) then
				local newButton = CreateFrame(templateType, name.."UnitButton"..i, frame, buttonTemplate);
				--SetupUnitButtonConfiguration(frame, newButton);
				frame:SetAttribute("child"..i, newButton);
			end
		end
	end
	
	local loopStart, loopFinish, step = 1, unitCount, 1;
	if ( sortDir == "DESC" ) then
		loopStart, loopFinish, step = unitCount, 1, -1;
	end
	
	local buttonNum = 0;
	local currentAnchor = frame;
	for i = loopStart, loopFinish, step do
		buttonNum = buttonNum + 1;
		
		local unitButton = frame:GetAttribute("child"..buttonNum);
		unitButton:Hide();
		unitButton:ClearAllPoints();
		if ( buttonNum == 1 ) then
			unitButton:SetPoint(point, currentAnchor, point, 0, 0);
		else
			unitButton:SetPoint(point, currentAnchor, relativePoint, xMultiplier * xOffset, yMultiplier * yOffset);
		end
		unitButton:SetAttribute("unit", sortingTable[sortingTable[i]]);
		unitButton:Show();
		
		currentAnchor = unitButton;
	end
	repeat
		buttonNum = buttonNum + 1;
		local unitButton = frame:GetAttribute("child"..buttonNum);
		if ( unitButton ) then
			unitButton:Hide();
			unitButton:SetAttribute("unit", nil);
		end
	until not ( unitButton )
	
	local unitButton = frame:GetAttribute("child1");
	local unitButtonWidth = unitButton:GetWidth();
	local unitButtonHeight = unitButton:GetHeight();
	if ( unitCount > 0 ) then
		frame:SetWidth( xMultiplier * (unitCount - 1) * unitButtonWidth + ( (unitCount - 1) * (xOffset * xOffsetMult) ) + unitButtonWidth );
		frame:SetHeight( yMultiplier * (unitCount - 1) * unitButtonHeight + ( (unitCount - 1) * (yOffset * yOffsetMult) ) + unitButtonHeight );
	else
		local minWidth = frame:GetAttribute("minWidth") or (yMultiplier * unitButtonWidth);
		local minHeight = frame:GetAttribute("minHeight") or (xMultiplier * unitButtonHeight);
		frame:SetWidth( max(minWidth, 0.1) );
		frame:SetHeight( max(minHeight, 0.1) );
	end
end

function MainAssist:InsecurePartyHeader_Update(frame)
	local nameList = frame:GetAttribute("nameList");
	local sortingTable = self.sortingTable
	
	if not ( nameList ) then
		frame:Hide();
		return;
	end
	
	for key in pairs(sortingTable) do
		sortingTable[key] = nil;
	end
	
	if ( nameList ) then
		-- filtering via a list of names
		doubleFillTable(sortingTable, strsplit(",", nameList));
		for i = 1, GetNumPartyMembers(), 1 do
			local name = UnitName("party"..i);
			if ( sortingTable[name] ) then
				sortingTable[name] = "party"..i;
			end
			if UnitExists("partypet"..i) then
				name = UnitName("partypet"..i);
				if ( sortingTable[name] ) then
					sortingTable[name] = "partypet"..i;
				end
			end
		end
		if ( sortingTable[UnitName("player")] ) then
			sortingTable[UnitName("player")] = "player";
		end
		if ( sortingTable[UnitName("pet")] ) then
			sortingTable[UnitName("pet")] = "pet";
		end
		for i = #sortingTable, 1, -1 do
			local name = sortingTable[i];
			if ( sortingTable[name] == true ) then
				tremove(sortingTable, i);
			end
		end
	else
		frame:Hide();
		return;
	end

	self:InsecurePartyHeader_ConfigureChildren(frame);
end

-----------------------------------
-- Who's Targeting Tablets
----------------------------------

function MainAssist:CreateTargetingTablet(frame) 
	tablet:Register(frame,
	    "children", function() frame.FillTargetingTablet() end,
	    "data",{},
	    "point",function() return "TOPRIGHT", "TOPLEFT" end,
	    "dontHook", true)
end

function MainAssist:FillTargetingTablet(frame)
	local unit = frame:GetAttribute("unit")
	local name = UnitName(unit)
	local _, class = UnitClass(unit)
	local color = RAID_CLASS_COLORS[class]	
	local cat = tablet:AddCategory("text",name,"id","Targets","columns",1,"textR",color.r,"textG",color.g,"textB",color.b,"size",14) 
	
	tablet:SetTitle("")
	local numlines = 0
	if unit then 
		local id = self.UniqueTargets[unit]
		for k, v in pairs(self.UniqueTargets) do
			if k ~= unit and  v == id and v ~= 0 then
				name = UnitName(k)
				_, class = UnitClass(k)
				color = RAID_CLASS_COLORS[class]
				cat:AddLine("text",name,"textR",color.r,"textG",color.g,"textB",color.b)
				numlines = numlines + 1
			end
		end
	end     
	if numlines == 0 then
		cat:AddLine("text","*none*")
	end
end

local cats = {}
local tempunits = {}
local names = {}
local colors = {}

function MainAssist:OnTooltipUpdate()
	if not self.db.profile.detailedtooltip then return end
	for k in pairs(cats) do
		cats[k] = nil
	end
	
	local done = false
	local i = 0
	local c = self.Colors["Text"]
	while not done do
		--get a list of every unit on this target
		for k, v in pairs(self.UniqueTargets) do
			if v == i and UnitExists(k) and not string.match(k,"pet") then
				table.insert(tempunits, k)
			end			
		end

		--create a category for this target if someone is targeting it
		if #tempunits > 0 then
			if i == 0 then
				cats[i] = tablet:AddCategory("text","No Target","size",13,"columns", self.db.profile.tooltipcols) 
			else
				cats[i] = tablet:AddCategory("text",UnitName(tempunits[1].."target").." ("..UnitLevel(tempunits[1].."target")..")","size",13,"columns", self.db.profile.tooltipcols) 
			end
			
			--add everyone on this target in 3 columns
			while #tempunits > 0 do
				local unit = table.remove(tempunits,1)
				if unit then
					local name = UnitName(unit)
					local _, class = UnitClass(unit)
					local color = RAID_CLASS_COLORS[class]
					tinsert(names, name)
					tinsert(colors, color)
				end

				if #tempunits == 0 or #names == self.db.profile.tooltipcols then
					cats[i]:AddLine(
						"text",names[1] or "","textR",(colors[1] or c).r,"textG",(colors[1] or c).g,"textB",(colors[1] or c).b,"size",10,
						"text2",names[2] or "","text2R",(colors[2] or c).r,"text2G",(colors[2] or c).g,"text2B",(colors[2] or c).b,"size2",10,
						"text3",names[3] or "" ,"text3R",(colors[3] or c).r,"text3G",(colors[3] or c).g,"text3B",(colors[3] or c).b,"size3",10					
					)
					while #names > 0 do
						tremove(names)
						tremove(colors)
					end
				end					
			end
		else
			if i ~= 0 then done = true end
		end
		i = i + 1
	end
end
