Magnet = LibStub("AceAddon-3.0"):NewAddon("Magnet", "AceConsole-3.0", "AceEvent-3.0")
local L = LibStub("AceLocale-3.0"):GetLocale("Magnet")
local AceConfig = LibStub("AceConfig-3.0")
local AceConfigDialog = LibStub("AceConfigDialog-3.0")

local defaults = {
   char = {
      items = {},
      lootGold = true,
      lootQuest = false,
      lootQuality = { none = true },
	  lootGoods = { none = true },
      verbose = true,
   }
}

local options = {
   type = "group",
   name = "Magnet",
   args = {   
		config = {
			type = "execute",
			name = L["Open GUI"],
			desc = L["Opens the configuration panel"],
         guiHidden = true,
			func = function()
				InterfaceOptionsFrame:Hide()
            AceConfigDialog:SetDefaultSize("Magnet", 420, 520)
				AceConfigDialog:Open("Magnet")
			end
		},
      logo = {
         order = 1,
         type = "description",
         name = "",
         image = [[Interface\Addons\Magnet\magnet]],
         imageWidth = 256,
         imageHeight = 128,
         imageCoords = { 0, 1, 0, 1 },
      },
      verbose = {
         order = 1,
         type = 'toggle',
         width = "full",
         name = L["Show verbose messages on the chat frame"],
         desc = L["Prints verbose messages on the chat frame on what, when and why it loots"],
         get = function() return Magnet.db.char.verbose end,
         set = function(info,v) Magnet.db.char.verbose = v end
      },
      s1 = {
         order = 2,
         type = 'header',
         name = L["Autoloot options"],
      },
      add = {
         order = 3,
         type = 'input',
         name = L["Add item"],
         desc = L["Adds a new item to the autoloot list"],
         usage = "<item name>",
         get  = false,
         set  = function(info,v) Magnet:Print("Adding "..string.lower(v)); Magnet.db.char.items[string.lower(v)] = true end
      },
      list = {
         order = 4,
         type = 'execute',
         name = L["Show item list"],
         desc = L["Shows the list of current items to search and autoloot for"],
         func = function() Magnet:Print("Autoloot list:"); for i in pairs(Magnet.db.char.items) do Magnet:Print(i) end end
      },
      del = {
         order = 5,
         type = 'input',
         name = L["Delete item"],
         desc = L["Deletes an item from the autoloot list"],
         usage = "<item name>",
         get  = false,
         set  = function(info,v) Magnet:Print("Deleting "..string.lower(v)); Magnet.db.char.items[string.lower(v)] = nil end
      },
      clear = {
         order = 6,
         type = 'execute',
         name = L["Clear item list"],
         desc = L["Will clear the list of current items to search and autoloot for. THIS IS NOT UNDOABLE."],
         func = function() Magnet.db.char.items = {}; Magnet:Print("Autoloot list cleared. It's empty now.") end
      },
      lootgold = {
         order = 7,
         type = 'toggle',
         name = L["Loot money"],
         desc = L["Automatically loot money too"],
         get = function() return Magnet.db.char.lootGold end,
         set = function(info,v) Magnet.db.char.lootGold = v end
      },
      lootquest = {
         order = 8,
         type = 'toggle',
         name = L["Loot quest items"],
         desc = L["Automatically loot quest items"],
         get = function() return Magnet.db.char.lootQuest end,
         set = function(info,v) Magnet.db.char.lootQuest = v end
      },
      lootQuality = {
         order = 9,
         type = "multiselect",
         name = L["Loot by item quality"],
         desc = L["Loot items by their quality"],
         values = {
            none= L["Disabled"],
            q0=ITEM_QUALITY_COLORS[0].hex..ITEM_QUALITY0_DESC,
            q1=ITEM_QUALITY_COLORS[1].hex..ITEM_QUALITY1_DESC,
            q2=ITEM_QUALITY_COLORS[2].hex..ITEM_QUALITY2_DESC,
            q3=ITEM_QUALITY_COLORS[3].hex..ITEM_QUALITY3_DESC,
            q4=ITEM_QUALITY_COLORS[4].hex..ITEM_QUALITY4_DESC,
            q5=ITEM_QUALITY_COLORS[5].hex..ITEM_QUALITY5_DESC,
            q6=ITEM_QUALITY_COLORS[6].hex..ITEM_QUALITY6_DESC,
         },
         get = function(info,key) return Magnet.db.char.lootQuality[key] end,
         set = function(info,key,v) Magnet:SetLQ(key,v) end,
      },
	  lootGoods = {
		order = 10,
		type = "multiselect",
		name = L["Loot TradeGoods"],
		desc = L["Loot Leather, Mining, Herbs, Prospect, Disenchant, Cloth, Fish ,Health, Mana, Battleground & Meats Items"],
		values = {
			none = L["Disabled"],
			g0 = L["Leather"],
			g1 = L["Mining"],
			g2 = L["Herbs"],
			g3 = L["Prospect"],
			g4 = L["Enchant"],
			g5 = L["Cloth"],
			g6 = L["Fish"],
			g7 = L["Health"],
			g8 = L["Mana"],
			g9 = L["Battleground"],
			g10 = L["Meat"],
		},
		get = function(info,key) return Magnet.db.char.lootGoods[key] end,
		set = function(info,key,v) Magnet:SetTG(key,v) end,
	  },
   },
}

AceConfig:RegisterOptionsTable("Magnet", options, "magnet")

function Magnet:SetLQ(key,v)
   if (key == "none" and v == true) then
      Magnet.db.char.lootQuality = {}
   else
      Magnet.db.char.lootQuality["none"] = false
   end
   Magnet.db.char.lootQuality[key] = v
   local i = 0
   for k,v in pairs(Magnet.db.char.lootQuality) do
      i = i + 1 
      if(v == false) then i = i - 1 end
   end
   if (i == 0) then
      Magnet.db.char.lootQuality["none"] = true
   end
end

function Magnet:SetTG(key,v)
	if (key == "none" and v == true) then
		Magnet.db.char.lootGoods = {}
	else
		Magnet.db.char.lootGoods["none"] = false
	end
	Magnet.db.char.lootGoods[key] = v
	local i = 0
	for k,v in pairs(Magnet.db.char.lootGoods) do
		i = i + 1
		if (v == false) then i = i - 1 end
	end
	if (i == 0) then
		Magnet.db.char.lootGoods["none"] = true
	end
end

function Magnet:OnInitialize()
   self.db = LibStub("AceDB-3.0"):New("MagnetDB", defaults, "Default")
   AceConfigDialog:AddToBlizOptions("Magnet", "Magnet")
end

function Magnet:OnEnable()
	self:RegisterEvent("LOOT_OPENED")
end

function Magnet:LOOT_OPENED()
   for i=1, GetNumLootItems() do
		local _, itemName, _, itemRarity = GetLootSlotInfo(i)
		local name = string.lower(itemName)
		if (LootSlotIsCoin(i)) then
			if (self.db.char.lootGold == true) then
				if(self.db.char.verbose == true) then self:Print(L["Autolooting money"]) end
				LootSlot(i)
			end
		elseif (LootSlotIsItem(i)) then
			local link = GetLootSlotLink(i)
			if not link then return end
			local _, _, itemRarity, _, _, itemSubType = GetItemInfo(link)
			local itemID = tonumber(link:match("item:(%d+)"))
			if (self.db.char.items[name]) then
				if(self.db.char.verbose == true) then self:Print(L["Autolooting "]..name) end
				LootSlot(i)
			end
			if (self.db.char.lootQuest == true) then
				if(string.lower(itemSubType) == L["quest"]) then
					if(self.db.char.verbose == true) then self:Print(L["Autolooting quest item"]) end
					LootSlot(i)
				end
			end
			if (self.db.char.lootGoods["none"] == false) then
				for k,v in pairs (self.db.char.lootGoods) do
					if (k ~= "none") then
						if (v == true) then
							if (k == "g0" and Magnet_Leathers[itemID]) then
								if(self.db.char.verbose == true) then self:Print(L["Autolooting Leathers"]) end
								LootSlot(i)
							end
							if (k == "g1" and Magnet_Mining[itemID]) then
								if(self.db.char.verbose == true) then self:Print(L["Autolooting Mining Results"]) end
								LootSlot(i)
							end
							if (k == "g2" and Magnet_Herbs[itemID]) then
								if(self.db.char.verbose == true) then self:Print(L["Autolooting Herbs"]) end
								LootSlot(i)
							end
							if (k == "g3" and Magnet_Prospecting[itemID]) then
								if(self.db.char.verbose == true) then self:Print(L["Autolooting Gems and Powders"]) end				
								LootSlot(i)
							end
							if (k == "g4" and Magnet_Enchanting[itemID]) then
								if(self.db.char.verbose == true) then self:Print(L["Autolooting Essences"]) end
								LootSlot(i)
							end
							if (k == "g5" and Magnet_Cloths[itemID]) then
								if(self.db.char.verbose == true) then self:Print(L["Autolooting Cloths"]) end
								LootSlot(i)
							end
							if (k == "g6" and Magnet_Fishs[itemID]) then
								if(self.db.char.verbose == true) then self:Print(L["Autolooting Fishes"]) end
								LootSlot(i)
							end
							if (k == "g7" and Magnet_Healths[itemID]) then
								if(self.db.char.verbose == true) then self:Print(L["Autolooting Health Potions"]) end
								LootSlot(i)
							end
							if (k == "g8" and Magnet_Manas[itemID]) then
								if(self.db.char.verbose == true) then self:Print(L["Autolooting Mana Potions"]) end
								LootSlot(i)
							end
							if (k == "g9" and Magnet_Battleground[itemID]) then
								if(self.db.char.verbose == true) then self:Print(L["Autolooting Battleground Stuff"]) end
								LootSlot(i)
							end
							if (k == "g10" and Magnet_Cooking[itemID]) then
								if(self.db.char.verbose == true) then self:Print(L["Autolooting Meats for Cooking & Pets"]) end
								LootSlot(i)
							end
						end
					end
				end
			end
			if (self.db.char.lootQuality["none"] == false) then
				local quality = nil
				for k,v in pairs(self.db.char.lootQuality) do
					if (k ~= "none") then
						if (v == true) then
							if (k == "q0") then quality = 0
							elseif (k == "q1") then quality = 1
							elseif (k == "q2") then quality = 2
							elseif (k == "q3") then quality = 3
							elseif (k == "q4") then quality = 4
							elseif (k == "q5") then quality = 5
							elseif (k == "q6") then quality = 6
							end
						end
						if(itemRarity ~= nil and quality ~= nil) then
							if (tonumber(itemRarity) == quality) then
								if(self.db.char.verbose == true) then self:Print(L["Autolooting item by quality"]) end
								LootSlot(i)
							end
						end
					end
				end
			end
		end
   end
end

function Magnet:OnDisable()
   self:UnregisterEvent("LOOT_OPENED")
end
