--   MageTaxi ver 1.6.2  --
-- Created by: ChaosInc --

-- INITIAL VARIABLES
debug = false;

-- ONLOAD
function MageTaxi_OnLoad()
	this:RegisterEvent("CHAT_MSG_CHANNEL_NOTICE");
	this:RegisterEvent("PLAYER_ENTERING_WORLD");
	this:RegisterEvent("VARIABLES_LOADED");
	this:RegisterEvent("ADDON_LOADED");
	SLASH_MAGETAXI1 = "/magetaxi";
	SLASH_MAGETAXI2 = "/mtaxi";
	SlashCmdList["MAGETAXI"] = function(msg)
		MageTaxi_SlashCommandHandler(msg);
	end;
	MageTaxi_SetFaction();
end;

-- ONEVENT
function MageTaxi_OnEvent()
	if (event == "CHAT_MSG_CHANNEL_NOTICE") or (event == "PLAYER_ENTERING_WORLD") then
		trade = GetChannelName("Trade - City");
	elseif (event == "VARIABLES_LOADED") then
		this:UnregisterEvent("VARIABLES_LOADED");
		if (not showButton) then
			showButton = true;
		elseif (showButton == "false") then
			MageTaxi_Button:Hide();
		else
		MageTaxi_Button:Show();
		end;
	end;
end;

-- GET COMMANDS
function GetCmd(msg)
 	if (msg) then
 		local von,bis = string.find(msg, "[^%s]+");
 		if (not ( (von == nil) and (bis == nil) ) ) then
 			local cmd = string.lower(string.sub(msg,von,bis))
 			return cmd, string.sub(msg, string.find(cmd,"$")+1);
 		else
 			return "";
 		end;
 	end;
end;
 	
-- SLASH COMMANDS
function MageTaxi_SlashCommandHandler(msg)
	local cmd, subCmd = GetCmd(msg);
	if (cmd == "on") then
		MageTaxiFrame:Show();
	elseif (cmd == "off") then
		MageTaxiFrame:Hide();
	elseif (cmd == "button") then
		if (subCmd == "hide") then
			MageTaxi_Button:Hide();
			showButton = false;
		elseif (subCmd == "show") then
			MageTaxi_Button:Show();
			showButton = true;
		end;	
	end;
end;

-- SET CITIES 
function MageTaxi_SetFaction()
	faction = UnitFactionGroup("player");
	if (faction == "Alliance") then
		CITIES = {
			[1] = "Stormwind",
			[2] = "Ironforge",
			[3] = "Darnassus",
			[4] = "Exodar",
			[5] = "Shattrath",
			[6] = "Theramore",
		};
	else
		CITIES = {
			[1] = "Undercity",
			[2] = "Orgrimmar",
			[3] = "Thunder Bluff",
			[4] = "Silvermoon",
			[5] = "Shattrath",
			[6] = "Stonard",
		};
	end;
		dest = CITIES[1];
end;

-- SPAM
function MageTaxi_Spam()
	currentLoc = GetZoneText();
	spam = "WTS portals to anywhere from ".. currentLoc.. ", 1g.  2g for me to come to another city."; 	-- MESSAGE FOR "ANNOUNCE" BUTTON
	if (debug) then
		trade = GetChannelName("modtest");
	end;
	SendChatMessage(spam, "CHANNEL", nil, trade);
end

-- PORTING -
function MageTaxi_LFM()
	more = "Port requested to ".. dest.. " from ".. currentLoc.. ", Whisper me to be included for 1g."; 	-- MESSAGE FOR "LFM" BUTTON
	SendChatMessage(more, "CHANNEL", nil, trade);
end;

-- LAST CALL
function MageTaxi_LastCall()
	lastCall = "LAST CALL: Porting from ".. currentLoc.. " to ".. dest.. ", Whisper me to be included for 1g.";	-- MESSAGE FOR "LAST CALL" BUTTON
	SendChatMessage(lastCall, "CHANNEL", nil, trade);
end;

-- SET DESTINATION
function MageTaxi_SetLocation(i)
	for num= 1,6 do
		getglobal("MageTaxiFrame_City".. num):SetChecked(0);
	end;
	dest = CITIES[i];
	getglobal("MageTaxiFrame_City".. i):SetChecked(1);
end;

-- GUI OnShow
function MageTaxiButton_OnClick()
	-- DISABLE MEANMAGE IF PRESENT
	if (MeanMage) and (MeanMageSet == "on") then
		MeanMage_SlashHandler("off");
		MeanMageToggled = true;
	end
	
	MageTaxiFrame:Show();
	
	if (faction == "Alliance") then
		MageTaxi_AlliPorts:Show();
	else
		MageTaxi_HordePorts:Show();
	end;	
end;

--GUI OnHide
function MageTaxiFrame_OnHide()
	-- TURN ON MEANMAGE BACK ON
	if (MeanMageToggled) then
		MeanMage_SlashHandler("on");
	end
	MeanMageToggled = false;
end
