MageAnnounce = LibStub("AceAddon-3.0"):NewAddon("MageAnnounce", "AceEvent-3.0", "AceConsole-3.0")

local L = LibStub("AceLocale-3.0"):GetLocale("MageAnnounce")
local db

------------ Main Code ------------
local isInParty, isInRaid, inBG, inInstance
local WarnNum = 1

function MageAnnounce:OnInitialize()
	------------ Slash Commands ------------
		local options = { 
			type = "group",
			desc = L["Options"],
			name = GetAddOnMetadata("MageAnnounce", "Title"),
			args = {
				general = {
					type = "group",
					name = L["General"],
					desc = L["General Options"],
					order = 0,
					args = {
						bgenable = {
							type = "toggle",
							name = L["Enable in BGs"],
							desc = L["Enable messages in Battlegrounds"],
							order = 2,
							get = function() return db.showInBGs end,
							set = function ()db.showInBGs = not db.showInBGs end,
						},
						showoutside = {
							type = "toggle",
							name = L["Enable Outside Instances"],
							desc = L["Enable messages outside Instances"],
							order = 3,
							get = function() return db.showOutside end,
							set = function ()db.showOutside = not db.showOutside end,
						},
						customchan = {
							type = "input",
							name = L["Custom Channel"],
							desc = L["Custom channel to show messages in"],
							usage = L["<Channel>"],
							order = 4,
							get = function() return db.customChan end,
							set = SetCustomChan,
						},
						spamnum = {
							type = "range",
							min = 1,
							max = 5,
							step = 1,
							name = L["Number of Spam Messages"],
							desc = L["Number of Duplicate Messages to Spam"],
							order = 6,
							get = function() return db.spamNum end,
							set = function (info, newValue) db.spamNum = newValue end,
						},
					},
				},
				poly = {
					type = "group",
					name = L["Polymorph Options"],
					desc = L["Show Polymorph Options"],
					order = 5,
					args = {
						polymsg = { -- Options for Polymorph
							type = "input",
							name = L["Message"],
							desc = L["Message to be displayed when polymorphing"],
							usage = L["<Your message>"],
							width = "double",
							order = 1,
							get = function() return db.polyMessage end,
							set = function (info, newValue)db.polyMessage = newValue end,
						},
						focusmacro = { 
							type = "toggle",
							name = L["I use a focus macro"],
							desc = L["Check this if you use a focus macro for sheeping"],
							order = 2,
							get = function() return db.focusMacro end,
							set = function ()db.focusMacro = not db.focusMacro end,
						},
						polyparty = { 
							type = "toggle",
							name = L["Show in Party"],
							desc = L["Toggles the display of polymorph messages in party chat"],
							order = 3,
							get = function() return db.showPolyInParty end,
							set = function ()db.showPolyInParty = not db.showPolyInParty end,
						},
						polyraid = {
							type = "toggle",
							name = L["Show in Raid"],
							desc = L["Toggles the display of polymorph messages in raid chat"],
							order = 4,
							get = function() return db.showPolyInRaid end,
							set = function ()db.showPolyInRaid = not db.showPolyInRaid end,
						},
						polycust = {
							type = "toggle",
							name = L["Show in Custom Channel"],
							desc = L["Toggles the display of polymorph messages in the custom channel"],
							width = "double",
							order = 5,
							get = function() return db.showPolyInCust end,
							set = function ()db.showPolyInCust = not db.showPolyInCust end,
						},
						warnheader = {
							type = "header",
							name = "Warning Options",
							order = 6,
						},
						polywarn = { 
							type = "input",
							name = L["Warning Message"],
							desc = L["Message to be sent to party members who target your target when polymorphing"],
							usage = L["<Your message>"],
							width = "double",
							order = 7,
							get = function() return db.polyWarning end,
							set = function (info, newValue)db.polyWarning = newValue end,
						},
						polywhisper = { 
							type = "toggle",
							name = L["Enable Warning Messages"],
							desc = L["Toggles the sending of polymorph warning via whisper"],
							order = 8,
							get = function() return db.sendPolyWhisper end,
							set = function ()db.sendPolyWhisper = not db.sendPolyWhisper end,
						},
					},
				},
				cs = {
					type = "group",
					name = L["Counterspell Options"],
					desc = L["Show Counterspell Options"],
					order = 6,
					args = {
						csmsg = { -- Options for Counter Spell
							type = "input",
							name = L["Message"],
							desc = L["Message to be displayed when counterspelling"],
							usage = L["<Your message>"],
							width = "double",
							order = 1,
							get = function() return db.csMessage end,
							set = function (info, newValue)db.csMessage = newValue end,
						},
						csparty = { 
							type = "toggle",
							name = L["Show in Party"],
							desc = L["Toggles the display of counterspell messages in party chat"],
							order = 2,
							get = function() return db.showCSInParty end,
							set = function ()db.showCSInParty = not db.showCSInParty end,
						},
						csraid = {
							type = "toggle",
							name = L["Show in Raid"],
							desc = L["Toggles the display of counterspell messages in raid chat"],
							order = 3,
							get = function() return db.showCSInRaid end,
							set = function ()db.showCSInRaid = not db.showCSInRaid end,
						},
						cscust = {
							type = "toggle",
							name = L["Show in Custom Channel"],
							desc = L["Toggles the display of counterspell messages in the custom channel"],
							width = "double",
							order = 4,
							get = function() return db.showCSInCust end,
							set = function ()db.showCSInCust = not db.showCSInCust end,
						},
					},
				},
				slow = {
					type = "group",
					name = L["Slow Options"],
					desc = L["Show Slow Options"],
					order = 7,
					args = {
						slowmsg = { -- Options for Slow
							type = "input",
							name = L["Message"],
							desc = L["Message to be displayed when slowing"],
							usage = L["<Your message>"],
							width = "double",
							order = 1,
							get = function() return db.slowMessage end,
							set = function (info, newValue)db.slowMessage = newValue end,
						},
						slowparty = { 
							type = "toggle",
							name = L["Show in Party"],
							desc = L["Toggles the display of slow messages in party chat"],
							order = 2,
							get = function() return db.showSlowInParty end,
							set = function ()db.showSlowInParty = not db.showSlowInParty end,
						},
						slowraid = {
							type = "toggle",
							name = L["Show in Raid"],
							desc = L["Toggles the display of slow messages in raid chat"],
							order = 3,
							get = function() return db.showSlowInRaid end,
							set = function ()db.showSlowInRaid = not db.showSlowInRaid end,
						},
						slowcust = {
							type = "toggle",
							name = L["Show in Custom Channel"],
							desc = L["Toggles the display of slow messages in the custom channel"],
							width = "double",
							order = 4,
							get = function() return db.showSlowInCust end,
							set = function ()db.showSlowInCust = not db.showSlowInCust end,
						},
					},
				},
				port = {
					type = "group",
					name = L["Portal Options"],
					desc = L["Show Portal Options"],
					order = 8,
					args = {
						portmsg = { 
							type = "input",
							name = L["Message"],
							desc = L["Message to be displayed when opening a portal, %s will be replace with the city name"],
							usage = L["<Your message>"],
							width = "double",
							order = 1,
							get = function() return db.portMessage end,
							set = function (info, newValue)db.portMessage = newValue end,
						},
						portparty = {
							type = "toggle",
							name = L["Show in Party"],
							desc = L["Toggles the display of portal messages in party chat"],
							order = 2,
							get = function() return db.showPortInParty end,
							set = function ()db.showPortInParty = not db.showPortInParty end,
						},
						portraid = {
							type = "toggle",
							name = L["Show in Raid"],
							desc = L["Toggles the display of portal messages in raid chat"],
							order = 3,
							get = function() return db.showPortInRaid end,
							set = function ()db.showPortInRaid = not db.showPortInRaid end,
						},
						portcust = {
							type = "toggle",
							name = L["Show in Custom Channel"],
							desc = L["Toggles the display of portal messages in the custom channel"],
							width = "double",
							order = 4,
							get = function() return db.showPortInCust end,
							set = function ()db.showPortInCust = not db.showPortInCust end,
						},
					},
				},	
			}
		}
	------------ End Slash Commands ------------
	------------ Defaults ------------
	local defaults = {
		profile = {
			polyMessage = L["Now Polymorphing %t"],
			polyWarning = L["I am casting Polymorph on your target. Please stop attacking!"],
			csMessage = L["Counterspelling %t"],
			slowMessage = L["Slowing %t"],
			portMessage = L["Incoming Portal to %s"],
			customChan = "",
			spamNum = 1,  -- # of spam messages
			showInBGs = true,
			showOutside = true,
			showPolyInRaid = true, -- Polymorph
			focusMacro = false,
			showPolyInParty = true,
			showPolyInCust = true,
			sendPolyWhisper = false,
			showCSInRaid = true, -- Counterspell
			showCSInParty = true,
			showCSInCust = true,
			showSlowInRaid = true, -- Slow
			showSlowInParty = true,
			showSlowInCust = true,
			showPortInParty = true, -- Portals
			showPortInRaid = true,
			showPortInCust = true,
		},
	} 
	self.db = LibStub("AceDB-3.0"):New("MageAnnounceDB", defaults)
	db = self.db.profile
	------------ End Defaults ------------
	-- Register our options
	LibStub("AceConfig-3.0"):RegisterOptionsTable("MageAnnounce", options)
	self.optionsFrame = LibStub("AceConfigDialog-3.0"):AddToBlizOptions("MageAnnounce", "MageAnnounce")
	self:RegisterChatCommand("mageannounce", "ChatCommand")
	self:RegisterChatCommand("magea", "ChatCommand")

end


function MageAnnounce:OnEnable()
	self:RegisterEvent("UNIT_SPELLCAST_START")
	self:RegisterEvent("UNIT_SPELLCAST_SUCCEEDED")
	self:RegisterEvent("PARTY_MEMBERS_CHANGED")
	self:RegisterEvent("RAID_ROSTER_UPDATE")
	self:RegisterEvent("ZONE_CHANGED_NEW_AREA")
	MageAnnounce:PARTY_MEMBERS_CHANGED()
	MageAnnounce:RAID_ROSTER_UPDATE()
	MageAnnounce:ZONE_CHANGED_NEW_AREA()
end

function MageAnnounce:PARTY_MEMBERS_CHANGED() -- Check to see if in party
	if GetNumPartyMembers() > 0 then
		isInParty = true
	else
		isInParty = false
	end
end
function MageAnnounce:RAID_ROSTER_UPDATE() -- Check to see if in raid
	if GetNumRaidMembers() > 0 then
		isInRaid = true
	else 
		isInRaid = false
	end
end

function MageAnnounce:ZONE_CHANGED_NEW_AREA()
	inInstance, instanceType = IsInInstance()
	if inInstance and instanceType == "pvp" then
		InBG = true
	elseif not inInstance then
		InBG = false
	end
end

function MageAnnounce:UNIT_SPELLCAST_START()
	caster = arg1
	spellName = arg2
	if caster ~= "player" then 
		return 
	end
	if not inInstance and db.showOutside == false then
		return
	end
	if db.customChan then
		chanid, _ = GetChannelName(db.customChan)
	end
	if spellName then
		if strfind (spellName, L["Polymorph"]) then
			if db.focusMacro then
				target = "focus"
			else
				target = "target"
			end
			sheeped = CheckIfSheeped (target)
			if not sheeped then
				message =  tokenreplace ("%d", db.polyMessage,"target")
				message =  tokenreplace ("%l", message,"target")
				message =  tokenreplace ("%s", message,"target")
				message =  tokenreplace ("%r", message,"target")
				message =  tokenreplace ("%c", message,"target")

				if isInParty and not isInRaid and db.showPolyInParty then -- Polymorph Party Messages
					SpamChatMessage(message , "PARTY", nil, ""); 

				end
				if isInRaid and db.showPolyInRaid and WarnNum == 1 then -- Polymorph Raid Messages
					SpamChatMessage(message , "RAID", nil, "");
					WarnNum = WarnNum + 1
				elseif WarnNum >= 2 then
					WarnNum = 1
				end
				if db.showPolyInCust and (chanid > 0) then -- Custom Channel Message
					SpamChatMessage(message , "CHANNEL", nil, chanid);
				end
				if IsInBG and db.showInBGs then -- Polymorph BG Messages
					SpamChatMessage(message , "BATTLEGROUND", nil, ""); 

				end
				message = ""

				if db.sendPolyWhisper then -- Polymorph Warning Messages
					message =  tokenreplace ("%d", db.polyWarning,target)
					message =  tokenreplace ("%l", message,target)
					message =  tokenreplace ("%s", message,target)
					message =  tokenreplace ("%r", message,target)
					message =  tokenreplace ("%c", message,target)
					for i=0,40 do
						if not UnitIsUnit("Party"..i,"player") then
							if UnitIsUnit("Party"..i.."Target",target) then
								local n,r=UnitName("Party"..i);
								SpamChatMessage(message , "WHISPER" , nil, n);
							end
						end
					end
					
				end
				
				message = ""
			end
		end
		if strfind(spellName, L["Portal"]) then
			city = gsub (spellName, L["Portal"]..": ", "")
			message = gsub (db.portMessage, "%%s", city)
			if isInParty and not isInRaid and db.showPortInRaid then
				SendChatMessage(message, "PARTY", nil, ""); 
			end
			if isInRaid and db.showPortInRaid and WarnNum == 1 then
				SendChatMessage(message, "RAID", nil, ""); 
				WarnNum = WarnNum + 1
			elseif WarnNum >= 2 then
				WarnNum = 1
			end
			if db.showPortInCust and (chanid > 0) then -- Custom Channel Message
				SendChatMessage(message , "CHANNEL", nil, chanid);
			end
			if IsInBG and db.showInBGs then
				SendChatMessage(message, "BATTLEGROUND", nil, ""); 
			end
			message = ""
		end
	end
end
function MageAnnounce:UNIT_SPELLCAST_SUCCEEDED()
	caster = arg1
	spellName = arg2
	if caster ~= "player" then 
		return 
	end
	if not inInstance and db.showOutside == false then
		return
	end
	if strfind (spellName, L["Counterspell"]) then
		message =  tokenreplace ("%d", db.csMessage,"target")
		message =  tokenreplace ("%l", message,"target")
		message =  tokenreplace ("%s", message,"target")
		message =  tokenreplace ("%r", message,"target")
		message =  tokenreplace ("%c", message,"target")

		if isInParty and not isInRaid and db.showCSInParty then -- Counterspell Party Messages
			SpamChatMessage(message, "PARTY", nil, ""); 
		end
		if isInRaid and db.showCSInRaid then -- Counterspell Raid Messages
			SpamChatMessage(message, "RAID", nil, "");
		end
		if db.showCSInCust and (chanid > 0) then -- Custom Channel Message
			SpamChatMessage(message, "CHANNEL", nil, chanid);
		end
		if IsInBG and db.showInBGs then -- Slow BG Messages
			SpamChatMessage(message, "BATTLEGROUND", nil, "");
		end
		message = ""
	end
	if spellName == L["Slow"] then
		message =  tokenreplace ("%d", db.slowMessage,"target")
		message =  tokenreplace ("%l", message,"target")
		message =  tokenreplace ("%s", message,"target")
		message =  tokenreplace ("%r", message,"target")
		message =  tokenreplace ("%c", message,"target")

		if isInParty and not isInRaid and db.showSlowInParty then -- Slow Party Messages
			SpamChatMessage(message, "PARTY", nil, ""); 

		end
		if isInRaid and db.showSlowInRaid then -- Slow Raid Messages
			SpamChatMessage(message, "RAID", nil, "");
		end
		if db.showSlowInCust and (chanid > 0) then -- Custom Channel Message
			SpamChatMessage(message, "CHANNEL", nil, chanid);
		end
		if IsInBG and db.showInBGs then -- Slow BG Messages
			SpamChatMessage(message, "BATTLEGROUND", nil, "");
		end
		message = ""
	end
end
------------ End Main Code ------------

------------ Functions ------------
function MageAnnounce:ChatCommand(input)
	if not input or input:trim() == "" then
		LibStub("AceConfigDialog-3.0"):SetDefaultSize("MageAnnounce", 500, 550)
		LibStub("AceConfigDialog-3.0"):Open("MageAnnounce")
	else
		LibStub("AceConfigCmd-3.0").HandleCommand(MageAnnounce, "magea", "MageAnnounce", input:trim() ~= "help" and input or "")
	end
end

function CheckIfSheeped(unit)
	id = 1
	while id <= 40 do
		local name, _, texture = UnitDebuff(unit, id);
		if not name then
			break;
		end
		if string.match(texture, "Spell_Nature_Polymorph") then
			return true;
		end
		id = id + 1
	end
end



function SetCustomChan(info, newValue) -- Set Custom Channel
	local id, _ = GetChannelName(newValue)
	if newValue and id == 0 then
		JoinChannelByName(newValue)
		ChatFrame_AddChannel(DEFAULT_CHAT_FRAME, newValue)
	end
	db.customChan = newValue
end

-- Sends chat messages multiple times
function SpamChatMessage(message, channel, lang, chanid)
	for i = 1,db.spamNum do
		SendChatMessage(message,channel,lang,chanid)
	end
end

function tokenreplace(token, message, target)
	if token == "%d" then
		local genderTable = { "Unknown", "male", "female" };
		local sex = genderTable[UnitSex(target)]
		local level = UnitLevel(target)
		local tokenrace,tokenraceEn = UnitRace(target)
		local tokenclass,tokenclassEn = UnitClass(target)
		detailstr = level .. "-";
		if UnitIsPlayer(target) then
			detailstr = detailstr .. tokenrace .. "-" .. tokenclass .. "-";
		end
		detailstr = detailstr .. sex;
		newmessage = gsub (message, "%%d", detailstr)
		return newmessage;
	end
	if token == "%s" then
		local genderTable = { "Unknown", "male", "female" };
		local sex = genderTable[UnitSex(target)]
		newmessage = gsub (message, "%%s", sex)
		return newmessage;
	end
	if token == "%l" then
		local level = UnitLevel(target)
		newmessage = gsub (message, "%%l", level)
		return newmessage;
	end
	if token == "%r" then
		local race,raceEN
		if UnitIsPlayer(target) then
			race,raceEn = UnitRace(target);
			else race = "n/a";
		end
		newmessage = gsub (message, "%%r", race)
		return newmessage;
	end
	if token == "%c" then
		local class,classEn
		if UnitIsPlayer(target) then
			class,classEn = UnitClass(target);
			else class = "n/a";
		end
		newmessage = gsub (message, "%%c", class)
		return newmessage;
	end
end
------------ End Functions ------------