--[[
-----------------------------------------
MisdirectionHelper by Akryn, 4/25/07
Announces MD cast and target.

1.5: 3-25-08
Release for 2.4

1.5 Beta 3: 2-17-08
Fixed the check for "Faded" message from the 2.4 combat log
Fixed LUA error on loading the addon for the first time

1.5 Beta 2: 2-12-08
Possible fix (temporary) for StaticPopup:OnHide bug

1.5 Beta 1: 2-11-08
Update to 2.4

1.4: 7-18-07
Added localization support.

1.3.1: 7-12-07
Fixed stupid typo in 1.3, should now ignore all spaces in MisDHLP_Channel.

1.3: 7-11-07
Fixed "no channel named ." bug.

1.2: 6-6-07
Added NONE to the announce types.

1.1: 6-5-07
Added whisper to target
Added announce to party if announce is set to raid, announcing in a party is turned on, and you are in a 5man group

1.0: 5-24-07
Fixed issue with readiness

0.2: 5-16-07
Added custom channel/raid/etc
Added a couple console commands

0.1
Internal release
-----------------------------------------
]]

local loc = MDHLP_Localization

-------
--Globals
-------

MisDHLP_MDSent = nil;
MisDHLP_MDTarget = "";
MisDHLP_LastFade = 0;

MisDHLP_Whisper = false;
MisDHLP_Party = 0;
MisDHLP_Active = true;
MisDHLP_Channel = nil;

-------
--Functions
-------

--aparently static popups were messed with in 2.4?
function MisDHLP_FindEditBox(popup)
	local editBox = getglobal(popup:GetName().."EditBox") or getglobal(popup:GetParent():GetName().."EditBox") or getglobal(popup:GetParent():GetParent():GetName().."EditBox");	
	return editBox;
end


function MisDHLP_Announce(faded)

	if not MisDHLP_Channel then
		return;
	end
	
	if (MisDHLP_Channel ~= " ") then
		MisDHLP_Channel = string.gsub(MisDHLP_Channel, " ", "");
	end
	
	if MisDHLP_Channel == loc.raid or MisDHLP_Channel == loc.warn then
		if (GetNumPartyMembers() * MisDHLP_Party) + GetNumRaidMembers() == 0 then
			return;
		end
	end
	
	if MisDHLP_Channel == loc.guild then
		if not IsInGuild() then
			return;
		end
	end

	local msg = "";	
	
	if faded then
		if GetTime() - MisDHLP_LastFade > 2 then
			msg = loc.expired;
			MisDHLP_LastFade = GetTime();
		end
	elseif MisDHLP_MDTarget and MisDHLP_MDTarget ~= "" then
		msg = loc.announce1 .. MisDHLP_MDTarget .. loc.announce2;
		if MisDHLP_Whisper then
			SendChatMessage(loc.whisper, "WHISPER", nil, MisDHLP_MDTarget);
		end
	end
	
	if MisDHLP_Channel == loc.none then
		return;
	end
	
	if MisDHLP_Channel == loc.raid then
		if GetNumRaidMembers() == 0 then
			SendChatMessage(msg, "PARTY"); 
		else
			SendChatMessage(msg, "RAID"); 
		end
	elseif MisDHLP_Channel == loc.guild then
		SendChatMessage(msg, "GUILD"); 
	elseif MisDHLP_Channel == loc.warn then
		SendChatMessage(msg, "RAID_WARNING"); 	
	else
		local index = GetChannelName(MisDHLP_Channel);
		if index == 0 then
			local i = 1;
			local fail = true;
			while i <= 10 do
				local name = GetChannelName(i);
				if string.lower(name) == string.lower(MisDHLP_Channel) then
					index = i;
					fail = false;
					MisDHLP_Channel = name;
					break;
				end
				i = i + 1;
			end		
			if fail then
				if (MisDHLP_Channel == " " or MisDHLP_Channel == "") then
					MisDHLP_Sendmsg(loc.failnochannel);
					return;
				end
				MisDHLP_Sendmsg(loc.failchannelnoexists1 .. MisDHLP_Channel .. loc.failchannelnoexists2);
				return;
			end
		end
		
		SendChatMessage(msg, "CHANNEL", nil, index); 
		
	end
end

function MisDHLP_SlashCommandHandler(cmd)
	if (string.lower(cmd) == loc.commandchannel) then
		StaticPopup_Show ("MisDHLP_SET_CHANNEL");	
	elseif string.lower(cmd) == loc.commandwhisper then	
		if not MisDHLP_Whisper then
			MisDHLP_Whisper = true;
			MisDHLP_Sendmsg(loc.whisperon);
		else
			MisDHLP_Whisper = false;
			MisDHLP_Sendmsg(loc.whisperoff);
		end
	elseif string.lower(cmd) == loc.commandparty or string.lower(cmd) == loc.commandraid then	
		if MisDHLP_Party == 0 then
			MisDHLP_Party = 1;
			MisDHLP_Sendmsg(loc.partyon);
		else
			MisDHLP_Party = 0;
			MisDHLP_Sendmsg(loc.partyoff);
		end
	elseif string.lower(cmd) == loc.commandon then
		MisDHLP_Active = true;
		MisDHLP_Sendmsg(loc.on);
	elseif string.lower(cmd) == loc.commandoff then
		MisDHLP_Active = false;
		MisDHLP_Sendmsg(loc.off);
	else
		MisDHLP_Sendmsg(loc.help1);
		MisDHLP_Sendmsg(loc.help2);
		MisDHLP_Sendmsg(loc.help3);
	end
end

function MisDHLP_Sendmsg(msg)
	if(DEFAULT_CHAT_FRAME) then
		DEFAULT_CHAT_FRAME:AddMessage(loc.outputprefix .. msg, 0.0, 1.0, 0.0, 1.0);	
	end
end

function MisDHLP_SetChannel(channel)
	MisDHLP_Channel = channel;
end

-------
--OnXX
-------

function MisDHLP_OnEvent()

	if event == "VARIABLES_LOADED" then
		local _, class = UnitClass("player");
		
		if class ~= "HUNTER" then
			MisDHLP_Active = false;
			return;
		end
		
		if MisDHLP_Channel == nil then
			StaticPopup_Show ("MisDHLP_NO_CHANNEL");
		end
		
		if (MisDHLP_Channel and MisDHLP_Channel ~= " ") then
			MisDHLP_Channel = string.gsub(MisDHLP_Channel, " ", "");
		end
		
		MisDHLP_Sendmsg(loc.loaded);
		
		return;
	end

	if (GetNumPartyMembers() * MisDHLP_Party) + GetNumRaidMembers() == 0 or (not MisDHLP_Active) then
		return;
	end

	if event == "UNIT_SPELLCAST_SENT" then
		if arg1 and arg1 == "player" then
			if arg2 and string.find(string.lower(arg2), loc.spellnamelower) then
				MisDHLP_MDTarget = arg4;
				MisDHLP_MDSent = GetTime();
			end
		end
	elseif event == "UNIT_SPELLCAST_SUCCEEDED" then
		if arg1 and arg1 == "player" then
			if arg2 and string.find(string.lower(arg2), loc.spellnamelower) then
				if MisDHLP_MDSent and GetTime() - MisDHLP_MDSent < 20 then
					MisDHLP_Announce();
				end
				
				MisDHLP_MDSent = nil;
				MisDHLP_MDTarget = "";
			end
		end
	elseif event == "COMBAT_LOG_EVENT_UNFILTERED" then		
		if arg7 and arg10 and arg2 and string.find(string.lower(arg10), loc.spellnamelower) and arg2==loc.faded and arg7==UnitName("player") then
			MisDHLP_Announce(1);
		end
	end
end

function MisDHLP_OnLoad()
	
	StaticPopupDialogs["MisDHLP_NO_CHANNEL"] = {
		text = loc.nochanneldialogtext,
		button1 = loc.buttonok,		
		button2 = loc.buttoncancel,
		hasEditBox = 1,
		maxLetters = 12,
		OnAccept = function()
			local editBox = MisDHLP_FindEditBox(this) --getglobal(this:GetParent():GetName().."EditBox");
			local channel = editBox:GetText();
			channel = string.gsub(channel, " ", "");
			if not channel then
				channel = loc.none;
			end
			MisDHLP_SetChannel(channel);
			MisDHLP_Sendmsg(loc.channelsettext1 .. channel .. loc.channelsettext2);
		end,
		OnShow = function()
			MisDHLP_FindEditBox(this):SetFocus();
		end,
		OnHide = function()
			local editBox = MisDHLP_FindEditBox(this) --getglobal(this:GetParent:GetName().."EditBox");
			local channel = editBox:GetText();
			channel = string.gsub(channel, " ", "");
			if not channel then
				MisDHLP_Channel = loc.none;
			end
			if ( ChatFrameEditBox:IsVisible() ) then
				ChatFrameEditBox:SetFocus();
			end
			editBox:SetText("");
		end,
		EditBoxOnEnterPressed = function()
			local editBox = MisDHLP_FindEditBox(this) --getglobal(this:GetParent():GetName().."EditBox");
			local channel = editBox:GetText();
			channel = string.gsub(channel, " ", "");
			if not channel then
				channel = loc.none;
			end
			MisDHLP_SetChannel(channel);
			MisDHLP_Sendmsg(loc.channelsettext1 .. channel .. loc.channelsettext2);
			this:GetParent():Hide();
		end,
		EditBoxOnEscapePressed = function()
			this:GetParent():Hide();
		end,		
		timeout = 0,
		whileDead = 1,
		hideOnEscape = 1
	};
	
	StaticPopupDialogs["MisDHLP_SET_CHANNEL"] = {
		text = loc.setchanneldialogtext,
		button1 = loc.buttonok,		
		button2 = loc.buttoncancel,
		hasEditBox = 1,
		maxLetters = 12,
		OnAccept = function()
			local editBox = MisDHLP_FindEditBox(this) --getglobal(this:GetParent():GetName().."EditBox");
			local channel = editBox:GetText();
			channel = string.gsub(channel, " ", "");
			if not channel then
				channel = loc.none;
			end
			MisDHLP_SetChannel(channel);
			MisDHLP_Sendmsg(loc.channelsettext1 .. channel .. loc.channelsettext2);
		end,
		OnShow = function()
			local editBox = MisDHLP_FindEditBox(this);
			editBox:SetFocus();
			local chan = MisDHLP_Channel;
			chan = string.gsub(chan, " ", "");
			editBox:SetText(chan);
		end,
		OnHide = function()
			if ( ChatFrameEditBox:IsVisible() ) then
				ChatFrameEditBox:SetFocus();
			end
			MisDHLP_FindEditBox(this):SetText("");
		end,
		EditBoxOnEnterPressed = function()
			local editBox = MisDHLP_FindEditBox(this) --getglobal(this:GetParent():GetName().."EditBox");
			local channel = editBox:GetText();
			channel = string.gsub(channel, " ", "");
			if not channel then
				channel = loc.none;
			end
			MisDHLP_SetChannel(channel);
			MisDHLP_Sendmsg(loc.channelsettext1 .. channel .. loc.channelsettext2);
			this:GetParent():Hide();
		end,
		EditBoxOnEscapePressed = function()
			this:GetParent():Hide();
		end,		
		timeout = 0,
		whileDead = 1,
		hideOnEscape = 1
	};

	
	SlashCmdList["MDHLP"] = MisDHLP_SlashCommandHandler;
	SLASH_MDHLP1 = "/mdhlp";

	this:RegisterEvent("UNIT_SPELLCAST_SENT");
	this:RegisterEvent("UNIT_SPELLCAST_SUCCEEDED");
	this:RegisterEvent("COMBAT_LOG_EVENT_UNFILTERED");
	this:RegisterEvent("VARIABLES_LOADED");
end