----------------------------------------------------------------------------------------
-- M1Peng_enUS: english localization for M1Peng
-- Localization files are loaded prior the main file (M1Pengine.lua) and must populate
-- a global table M1PengLocas with entry [LOCA]={locatable}, where LOCA is deDE,enUS...
-- M1Pengine.lua will pick the locatable for current locale, and use it.
----------------------------------------------------------------------------------------
-- Need help to fill this table, since I have no english version!
-- Whereever i don't know the correct entry, I put in a <explanation in parentheses>
-- PATTERN means: a pattern, which will catch that message with strfind (so this can be
-- a unique PART of the message to catch, or use regular expressions (see LUA manual).
---------------------------------------------------------------------------------------- 


if not M1PengLocas then M1PengLocas={} end   -- create table, if we are first locafile


M1PengLocas.enUS = {                      -- add english branch to localizations table

 -- Arathi button texts ................................................................

 ABButex = {
   "estimate win",                        -- tooltip for win-estimate timer
   "hurry to new base and hold it!",      -- said to /bg when clicking "supp!"
   "deff, near flag, say incs!" },        -- said to /bg when clicking "deff!"

 -- Arathi event patterns ..............................................................
 -- The 'bg begins / will begin' messages are different for all BGs (in german version)

 ABEvents = {    
   "will begin in 1 minute",              -- 60 sec before battle begins
   "will begin in 30 seconds",            -- 30 sec before battle begins
   " has begun!",                         -- when battle begins
   "claims the",                          -- when turning of a neutral base starts
   "has assaulted the",                   -- when turning of a ally/horde base starts
   "has defended the",                    -- when turning was interrupted
   "has taken the" },                     -- when turning was completed

 -- Arathi zone names (with grammar for 2-click-messages, and event patterns) ..........
 -- For each of the 5 bases there are 2 entries: 
 -- 1) "<AT,TO>base" will result in "xyz go TO base" and "xyz is AT base" messages later
 -- 2) is the name of the base in WOW's messages (whereas 1) uses player jargon)

 ABZones = {
   "<AT,TO>stables", "stables",
   "<AT,TO>mine", "mine",          -- "has taken the mine", NOT "gold mine" ...
   "<AT,TO>smithy", "blacksmith",
   "<AT,TO>mill", "lumber mill",
   "<AT,TO>farm", "farm" },

 -- Alterac button texts ...............................................................

 AVButex = {
   "say all running timers",    -- tooltip for the little clock icon
   "say complete info" },       -- tooltip for the little i icon

 -- Alterac event patterns .............................................................
 -- The 'bg begins / will begin' messages are different for all BGs (in german version).
 -- The snowfall GY is irrelevant for my addon, so the GY patterns have not to catch the
 -- special message for that GY.

 AVEvents = {
   "1 minute until",                  -- 60 sec before battle begins
   "30 seconds until",                -- 30 sec before battle begins
   " has begun!",                     -- when battle begins
   "Alliance will destroy",           -- when Ally starts to destroy a tower
   "Horde will destroy",              -- when Horde starts to destroy a bunker
   "was destroyed by the Alliance",   -- when Ally has destroyed a tower
   "was destroyed by the Horde",      -- when Horde has destroyed a bunker
   "Alliance will capture",           -- when Ally starts to take a graveyard
   "Horde will capture",              -- when Horde starts to take a graveyard
   "was taken by the Alliance",       -- when Ally takes a gy / defends a bunker
   "was taken by the Horde" },        -- when Horde takes a gy / defends a tower

 -- Alterac messages to recolorize .....................................................
 -- This table recolorizes bg messages: blue = good for Alliance, red = good for Horde.
 -- Format is {action1,pattern1,action2,pattern2,...}. There are 3 actions: 
 -- 1 = good for Alliance, colorize this message blue
 -- 2 = good for Horde, colorize this message red
 -- 3 = swap colors, blue messages become red, and red messages become blue
 -- Order is SIGNIFICANT - messages are compared to patterns from top to down in this
 -- list, the first match determines the color taken.
 -- It is not critical, if this list is incomplete - the coloring will be incomplete...
 -- The 'reinforcement is low' pattern should match for BOTH factions, so don't include
 -- 'Alliance' or 'Horde' in the pattern. For Galvangar's, Balinda's, Drek'thar's and 
 -- Vanndar's yells you will need as many action-pattern pairs as yells you know (you
 -- may even include Mulverick's yells and so on).

 AVColoz = {
   3, "out of reinforcement",                     -- Ally/Horde reinforcem. going low
   1, "Your kind has no place in Alterac Valley", -- Galv/Drek'thar attacked
   1, "I'll never fall for that, fool!",
   1, "Stormpike weaklings",
   1, "Stormpike filth!",
   1, "You seek to draw the General of the Frostwolf",
   2, "Begone, uncouth scum!",                    -- Bali/Vanndar attacked
   2, "Filthy Frostwolf cowards",
   2, "Why don't ya try again",
   2, "Soldiers of Stormpike, your General is under attack",
   2, "You'll never get me out of me",
   2, "It'll take more than you rabble",
   1, "Frostwolf General is dead",                -- when drek'thar died
   2, "Stormpike General is dead",                -- when vanndar died
   1, "Alliance",  -- catches all other messages (mine,gy,tower tapped...), makes blue 
   2, "Horde" },   -- catches all other messages (mine,gy,bunker tapped...), makes red
 
 -- Alterac zone names .................................................................
 -- For each of the zones (gy,tower,bunker,mine or boss) there are 1 or 3 entries: 
 -- 1) "<AT,TO>zone" will result in "xyz go TO zone" and "xyz is AT zone" messages later
 -- 2) abbreviation (need short names to post in chat and to print on timer bars)
 -- 3) is the name of the zone in WOW's messages (names start with uppercases???)
 -- You may wonder about the abbreviation - in 2) - but if the name is too long, it does
 -- not fit in timer bars, and I cannot use smaller font.
 -- I don't know,what the gamers jargon and abbreviations are,so these are placeholders: 

 AVZones = {
   "<AT,TO>vanndar", 
   "<AT,TO>aid station", "Aid", "Aid Station",
   "<AT,TO>north bunker", "N-Bunker", "North Bunker",
   "<AT,TO>south bunker", "S-Bunker", "South Bunker",
   "<AT,TO>north mine",
   "<AT,TO>stormpike gy",
   "<AT,TO>stonehearth gy",
   "<AT,TO>icewing bunker", "Ice-Bunker", "Icewing Bunker",
   "<AT,TO>stonehearth bunker", "Stone-Bunker", "Stonehearth Bunker",
   "<AT,TO>balinda", "Bali", "Balinda",
   "<AT,TO>snowfall gy",
   "<AT,TO>galvangar", "Galv", "Galvangar",
   "<AT,TO>iceblood tower", "Ice-Tower", "Iceblood Tower",
   "<AT,TO>tower point", "Tower-Pt", "Tower Point",
   "<AT,TO>iceblood gy",
   "<AT,TO>frostwolf gy",
   "<AT,TO>south mine",
   "<AT,TO>east tower", "E-Tower", "East Frostwolf Tower",
   "<AT,TO>west tower", "W-Tower", "West Frostwolf Tower",
   "<AT,TO>relief hut", "Hut", "Relief Hut",
   "<AT,TO>drek'thar" },

 -- BG messages to modify or suppress ..................................................
 -- This table can modify or suppress some bg messages. I used it to drop one of the two
 -- messages 'X has joined the battle' and 'X has joined the raid group'.  It is okay to
 -- leave this table empty (but DONT erase the table itself). Format is {old1,new1,old2,
 -- new2,...}. For new#==nil, any bg message containing old# will not appear in chat. 
 -- For new#~=nil, any occurence of old# will replaced by new#, before printing message.

 BGMsgFilter = { " the raid group",nil },

 -- BG name patterns (in uppercase) ....................................................
 -- Lefthand must be AB,AV,ES,WS (my shorthands for the 4 battlegrounds), the righthand
 -- should be a PATTERN, to detect, which bg is meant, in WOW's official names. Must be
 -- in uppercases!
 
 BGNames = { AB="ARATHI", AV="ALTERAC", ES="STORM", WS="GULCH" },

 -- Chat channel types .................................................................
 -- Don't know, whether /w, /y etc. are the same worldwide for all WOW versions ...??

 Chatypes = { -- with 1 space before slash  
   WHISPER = " /w",
   PARTY   = " /p",
   GUILD   = " /g",
   SAY     = " /s",
   YELL    = " /y" },

 -- EOTS button texts ..................................................................

 ESButex = {
   "estimate win",                        -- tooltip for win-estimate timer
   "hurry to new tower and hold it!",     -- said to /bg when clicking "supp!"
   "deff, near by tower, say incs!" },    -- said to /bg when clicking "deff!"

 -- EOTS messages to recolorize ........................................................
 -- See explanation for AVColoz above. This table makes the blue message 'alliance has 
 -- lost control over the x tower' red, and the message 'horde has lost control.." blue.
 -- The 'has lost control' pattern should match for BOTH factions, so don't include 'Al-
 -- liance' or 'Horde' in the pattern.
 
 ESColoz = {
   3, "has lost control of the",          -- when Ally/Horde loses a tower
   3, "flag has been dropped" },          -- when Ally/Horde loses the flag

 -- EOTS event patterns ................................................................
 -- The 'bg begins / will begin' messages are different for all BGs (in german version)
 -- The 'has won flag' and 'has taken/lost tower' patterns should match for BOTH factions, 
 -- so don't include 'Alliance' or 'Horde' in the pattern. The 'has taken/lost tower' pat-
 -- tern should match to any tower, so don't include a tower name in the pattern.
 
 ESEvents = {    
   "begins in 1 minute",       -- 60 sec before battle begins
   "begins in 30 seconds",     -- 30 sec before battle begins
   "battle has begun",         -- when battle begins
   "captured the flag!",       -- when flag won: new win estimation
   "has .+ control of the" },  -- when tower won/lost: new win estimation

 -- EOTS zone names (with grammar for 2-click-messages) ................................
 -- These should be abbreviations for the 4 towers (plus middle zone) in player jargon.

 ESZones = {
   "<AT,TO>mage tower",
   "<AT,TO>draenei",
   "<IN,TO>middle", 
   "<AT,TO>fel reaver", 
   "<AT,TO>blood elf" },

 -- General button texts ...............................................................
 -- These are text building blocks for the 1st click of 2-click-messages. The 2nd click
 -- (a zone) is filled in for # (whereat 2# stands for 'TO zone' and @# stands for 'AT
 -- zone' - the final text is produced by applying Grammar4Say on this (see below).
 -- Since I don't know the player jargon, these are placeholders only.

 GenButex = {
   "help 2# !!!",            -- as you would call help to zone #
   "help 2# ???",            -- as you would query, whether zone # needs help
   "rogue 2# please",        -- as you would ask a friend rogue to target zone #
   "rogue @# !!!",           -- as you would warn of horde rogue, when playing ally
   "rogue @# !!!",           -- as you would warn of ally rogue, when playing horde
   "go 2# please",           -- as you would ask some friend players to target #
   "hordies @# !!!",         -- as you would warn of horde inc, when playing ally
   "allies @# !!!",          -- as you would warn of ally inc, when playing horde
   "many 2# please",         -- as you would ask many friend players to target #
   "many hordies @# !!!",    -- as you would warn of big horde inc, when playing ally
   "many allies @# !!!",     -- as you would warn of big ally inc, when playing horde
   "say timer for #",        -- Timer tooltip for zone #
   "say time until start",   -- Timer tooltip for BG begin
   "Start",                  -- Timer text for BG begin
   "Allywin",                -- a win for Alliance
   "%d:%d or Allywin",       -- a win for Alliance, unless Horde gets x:y bases
   "Hordewin",               -- a win for Horde
   "%d:%d or Hordewin",      -- a win for Horde, unless Alliance gets x:y bases
   "help anybody?" },        -- as you would query, whether help is needed anywhere

 -- Replacings before say to chat: do 2-click-grammatics & some beautifications ........
 -- In 2-click-messages, the 1st click will select a message from GenButex (see above),
 -- and 2nd click will put in a zone (see ABZones,AVZones,ESZones,WSZones) for the #,
 -- and after that,this Grammar4Say will be applied to form the resulting message. The
 -- format of Grammar4Say is {old1,new1,old2,new2...} - this means: we will replace in
 -- the message all occurences of old1 with new1, then old2 with new2 and so on (using
 -- string.gsub, see how LUA handles patterns in the LUA reference). So, the ORDER of
 -- this list is significant!

 Grammar4Say = {
   "@<IN,%u+>","in ",   -- example: "rogue @<IN,TO>tunnel!"  ==> "rogue in tunnel!"
   "@<ON,%u+>","on ",   -- example: "rogue @<ON,TO>roof!"    ==> "rogue on roof!"
   "@<AT,%u+>","at ",   -- example: "rogue @<AT,TO>icebood!" ==> "rogue at iceblood!"
   "2<%u,TO>","to ",    -- example: "please go 2<AT,TO>mine" ==> "please go to mine"
   "<%u+,%u+>","",      -- at last: remove unused grammatics 
   " ~=", " ~ " ,       -- for WS' debuff~
   "(.+) or Allywin(.+)", "Allywin%2- unless it turns to %1 bases",   -- longer for chat
   "(.+) or Hordewin(.+)","Hordewin%2- unless it turns to %1 bases"}, -- longer for chat


 -- Grammar to apply for tooltips ......................................................
 -- A replacement table in the {old1,new1,old2,new2...} format (see Grammar4Say above), 
 -- to make buttons- and zone texts readable in tooltips.

 Grammar4TT = {
   "help 2# !!!", "help to ...!",
   "help 2# %?%?%?", "help to ...?",
   " !!!","",
   ">>> #","is ...",
   "not @#","isn't ...",
   "2#","to ...",
   "@#","at ...",
   "#","...",
   "<%u+,%u+>","... ",
   "for %.%.%.","for" },

 -- Help texts for usage ...............................................................
 -- First line is printed, when addon starts, the other lines, when typing /m1peng

 UsageHelp = {
   "|cffFF2222M1PENG: enhanced bg minimap with command |r/m1peng",
   "|cffFFFFFF/m1peng|cffFFFF33 displays this help",
   "|cffFFFFFF/m1peng helpme|cffFFFF33 calls help to your location",
   "|cffFFFFFF/m1peng timer|cffFFFF33 says running timers" },

 -- Warsong button texts ...............................................................

 WSButex = {
   "say time until debuff", -- tooltip for timer, when debuff is still to come
   "support flag!",         -- said to /bg when clicking "supp!"
   "deff base!",            -- said to /bg when clicking "deff!"
   "where allyflag?",       -- said when clicking the blue-flag-with-? icon
   "where hordeflag?",      -- said when clicking the red-flag-with-? icon
   "allyflag >>> #",        -- said when clicking the blue-flag and then a zone
   "hordeflag >>> #",       -- said when clicking the red-flag and then a zone
   "flag, DON'T go # !!!",  -- your flag carrier should NOT go tunnel etc...
   "allyflag not @#",       -- say 'our flag is not at xyz', when playing ally 
   "hordeflag not @#",      -- say 'our flag is not at xyz', when playing horde
   "50% debuff ~",          -- timer text for waiting for 50% debuff
   "100% debuff ~",         -- timer text for waiting for 100% debuff
   "say debuff" },          -- tooltip for timer, when 100% debuff is active

 -- Warsong messages to recolorize .....................................................
 -- See explanation for AVColoz above. Make 'flag is back in base' red/blue. Since it is
 -- an neutral message originally,we must detect 'Alliance'/'Horde' to make it blue/red. 
 WSColoz = {
   1, "Alliance [Ff]lag .+ its base",  -- ... was returned to / is placed now at ...
   2, "Horde [Ff]lag .+ its base" },   -- ... was returned to / is placed now at ...
 
 -- Warsong event patterns .............................................................
 -- The 'bg begins / will begin' messages are different for all BGs (in german version)

 WSEvents = {    
   "begins in 1 minute",                         -- 60 sec before battle begins
   "begins in 30 seconds",                       -- 30 sec before battle begins
   "Let the battle for Warsong Gulch begin!",    -- when battle begins
   " [Ff]lag", -- for 'flag picked/dropped/returned/won' messages; flag sometimes uppercase
   "have become vulnerable to attack!",                  -- when 50% debuff begins 
   "have become increasingly vulnerable to attack!" },   -- when 100% debuff begins

 -- Warsong zone names (with grammar for 2-click-messages) .............................
 -- These should be the common player jargon, please make it better.

 WSZones = {
   "<IN,TO>base",         -- your own base
   "<IN,TO>horde-base",   -- enemy base, when playing ally
   "<IN,TO>ally-base",    -- enemy base, when playing horde
   "<ON,TO>roof",         -- your own roof 
   "<ON,TO>horde-roof",   -- enemy roof, when playing ally
   "<ON,TO>ally-roof",    -- enemy roof, when playing horde
   "<ON,TO>gy",           -- your own gy
   "<ON,TO>horde-gy",     -- enemy gy, when playing ally
   "<ON,TO>ally-gy",      -- enemy gy, when playing horde
   "<IN,TO>tunnel",       -- your own tunnel
   "<IN,TO>horde-tunnel", -- enemy tunnel, when playing ally
   "<IN,TO>ally-tunnel",  -- enemy tunnel, when playing horde
   "<ON,TO>ramp",         -- your own ramp
   "<ON,TO>horde-ramp",   -- enemy ramp, when playing ally
   "<ON,TO>ally-ramp",    -- enemy ramp, when playing horde
   "<AT,TO>westside",     -- the western stripe of middle area
   "<IN,TO>middle",       -- the central stripe of middle area
   "<AT,TO>eastside" },   -- the eastern stripe of middle area

   }  -- ENDTAB M1PengLocas.enUS
