----------------------------------------------------------------------------------------
-- M1Peng_deDE: german localization for M1Peng
-- Localization files are loaded prior the main file (M1Pengine.lua) and must populate
-- a global table M1PengLocas with entry [LOCA]={locatable}, where LOCA is deDE,enUS...
-- M1Pengine.lua will pick the locatable for current locale, and use it.
----------------------------------------------------------------------------------------

if not M1PengLocas then M1PengLocas={} end   -- create table, if we are first locafile

M1PengLocas.deDE = {                         -- add german branch to localizations table

 -- Arathi button texts ................................................................
 ABButex = {
   "win sch\195\164tzen",
   "schnell zur neuen base und halten!",
   "deffen, nah an fahne, inc ansagen!" },
 -- Arathi event patterns ..............................................................
 ABEvents = {    
   " in 1 Minute beginnen", 
   " in 30 Sekunden beginnen", 
   " hat begonnen!",
   " besetzt!",
   " angegriffen!",
   " verteidigt!",
   " eingenommen!" },
 -- Arathi zone names (with grammar for 2-click-messages, and event patterns) ..........
 ABZones = {
   "<BEIM,ZUM>stall", "St\195\164lle",
   "<BEI,ZUR>mine", "Mine",
   "<BEI,ZUR>schmiede", "Schmiede",
   "<BEI,ZUR>s\195\164ge", "S\195\164gewerk",
   "<BEIM,ZUM>hof", "Hof" },

 -- Alterac button texts ...............................................................
 AVButex = {
   "alle timer durchsagen",
   "\195\188berblick durchsagen" },
 -- Alterac event patterns .............................................................
 AVEvents = {
   "beginnt in 1 Minute", 
   "beginnt in 30 Sekunden", 
   " hat begonnen!",
   "Allianz.+zerst\195\182ren!","Horde.+zerst\195\182ren!",
   "Allianz.+zerst\195\182rt!", "Horde.+zerst\195\182rt!",
   "Allianz.+erobern!", "Horde.+erobern!", 
   "Allianz.+erobert!", "Horde.+erobert!" },
 -- Alterac messages to recolorize .....................................................
 AVColoz = {
   3, "hat kaum noch Verst\195\164rkung",
   1, "F\195\188r Eure Art ist kein Platz",    -- Galvangar def
   1, "Darauf falle ich nicht rein, Dummkopf!",
   2, "Verschwinde, dreckiger Abschaum",       -- Balinda def
   2, "Dreckige feige Frostw\195\182lfe!",     
   1, "einer Burg",                            -- Drek'thar def
   1, "Ahnen begegnen",
   1, "Ihre Geister sind schwach",
   1, "werden Euch die Frostw\195\182lfe mit Gewalt vertreiben",
   1, "kein Gegner f\195\188r die Kraft der Horde",
   1, "General der Frostw\195\182lfe ist tot",
   2, "euer General wird angegriffen",         -- Vanndar def
   2, "mehr als einen Wicht wie Euch",
   2, "Ihr Ungl\195\164ubigen!",
   2, "Besseres habt Ihr nicht drauf",
   2, "General der Allianz ist tot",
   2, "k\195\188mmerliche Allianz",            -- Mulverick
   1, "Allianz",                               -- allg: Mine/FH/Turm getappt...
   2, "Horde" },                               -- allg: Mine/FH/Turm getappt...
 -- Alterac zone names (with grammar for 2-click-messages, and event patterns) .........
 AVZones = {
   "<BEI,ZU>vanndar", 
   "<AM,ZUM>laza","Laza","Lazarett",
   "<IM,ZUM>nordbunker","Nordbunk","Nordbunker",
   "<IM,ZUM>s\195\188dbunker","S\195\188dbunk","S\195\188dbunker",
   "<IN,ZUR>nordmine",
   "<AM,ZUM>sturmlanzen-fh",
   "<AM,ZUM>steinbruch-fh",
   "<IM,ZUM>eisschwingenbunker","Eisbunk","Eisschwingenbunker",
   "<IM,ZUM>steinbruchbunker","Steinbunk","Steinbruchbunker",
   "<BEI,ZU>balinda","Bali","Balinda",
   "<AM,ZUM>schneewehen-fh",
   "<BEI,ZU>galvangar","Galv","Galvangar",
   "<IM,ZUM>eisblutturm","Eisturm","Eisblutturm",
   "<BEI,ZUR>turmstellung","Turmstellg","Turmstellung",
   "<AM,ZUM>eisblut-fh",
   "<AM,ZUM>frostwolf-fh",
   "<IN,ZUR>s\195\188dmine",
   "<IM,ZUM>ostturm","Ostturm","\195\182stliche.+Frostwolfturm",
   "<IM,ZUM>westturm","Westturm","westliche.+Frostwolfturm",
   "<ANDER,ZUR>h\195\188tte","H\195\188tte","Heilerh\195\188tte",
   "<BEI,ZU>drek'thar" },

 -- BG messages to modify or suppress ..................................................
 BGMsgFilter = {
   "Schlachtgruppe",nil, 
   "sind der Schlacht beigetreten",nil, 
   "das Schlachtfeld","die Schlacht" },

 -- BG name patterns (in uppercase) ....................................................
 BGNames = { AB="ARATHI", AV="ALTERAC", ES="STURM", WS="SCHLUCHT" },

 -- Chat channel types .................................................................
 Chatypes = { -- with 1 space before slash  
   WHISPER = " /w",
   PARTY   = " /p",
   GUILD   = " /g",
   SAY     = " /s",
   YELL    = " /y" },

 -- EOTS button texts ..................................................................
 ESButex = {
   "win sch\195\164tzen",
   "schnell zum neuen turm und halten!",
   "deffen, nah am turm, inc ansagen!" },
 -- EOTS messages to recolorize ........................................................
 ESColoz = {
   3, "Kontrolle \195\188ber .+ verloren",
   3, "Flagge wurde fallengelassen" },
 -- EOTS event patterns ................................................................
 ESEvents = {
   "beginnt in 1 Minute", 
   "beginnt in 30 Sekunden", 
   " hat begonnen!",
   "Flagge erobert!",
   "Kontrolle" },
 -- EOTS zone names (with grammar for 2-click-messages) ................................
 ESZones = {
   "<AM,ZUM>mageturm",
   "<AM,ZUM>draenei",
   "<IN,ZUR>mitte", 
   "<AM,ZUM>teufelsh\195\164scher", 
   "<AM,ZUM>blutelf" },

 -- General button texts ...............................................................
 GenButex = {
   "hilfe 2# !!!", "hilfe 2# ???",
   "bitte schurke 2#", "achtung schurke @# !!!", "achtung schurke @# !!!",
   "bitte 2#", "achtung hordis @# !!!", "achtung allys @# !!!",
   "bitte viele 2#", "viele hordis @# !!!", "viele allys @# !!!",
   "timer f\195\188r # durchsagen",
   "zeit bis beginn durchsagen", "Beginn",
   "Allysieg", "%d:%d oder Allysieg", 
   "Hordesieg","%d:%d oder Hordesieg",
   "braucht wer hilfe?" },

 -- Replacings before say to chat: do 2-click-grammatics & some beautifications ........
 Grammar4Say = {
   "@<IN,%u+>","in ",
   "@<IM,%u+>","im ",
   "@<BEIM,%u+>","beim ",
   "@<AUF,%u+>","auf ",
   "@<AM,%u+>","am ", "2<%u+,ZUM>","zum ",
   "@<ANDER,%u+>","an der ", "2<%u+,ZUR>","zur ",
   "@<BEI,%u+>","bei ", "2<%u+,ZU>","zu ",
   "<%u+,%u+>","",
   "debuff ~=", "debuff ungef\195\164hr in ",
   "debuff ~", "debuff ungef\195\164hr jetzt",
   "(.+) oder Allysieg(.+)", "Allysieg%2- falls kein %1 draus wird",   -- longer for chat
   "(.+) oder Hordesieg(.+)","Hordesieg%2- falls kein %1 draus wird"}, -- longer for chat

 -- Replacings for tooltips .............................................................
 Grammar4TT = {
   "hilfe 2# !!!", "hilfe zu ...!",
   "hilfe 2# %?%?%?", "hilfe zu ...?",
   " !!!", "",
   ">>> #", "ist ...",
   "nicht @#", "ist nicht ...",
   "2#", "zu ...",
   "@#", "bei ...",
   "#", "...",
   "<%u+,%u+>", "... ",
   "f\195\188r %.%.%.", "f\195\188r" },

  -- Help texts for usage ...............................................................
 UsageHelp = {
   "|cffFF2222M1PENG: erweiterte BG-Minimap mit dem Befehl |r/m1peng",
   "|cffFFFFFF/m1peng|cffFFFF33 zeigt diese Hilfe an",
   "|cffFFFFFF/m1peng helpme|cffFFFF33 ruft im /bg Hilfe herbei",
   "|cffFFFFFF/m1peng timer|cffFFFF33 sagt im /bg die Timer an" },

 -- Warsong button texts ...............................................................
 WSButex = {
   "zeit bis debuff durchsagen",
   "support flagge!",
   "defft base!",
   "wo allyflagge?",
   "wo hordeflagge?",
   "allyflagge >>> #",
   "hordeflagge >>> #",  
   "flagge, geh NICHT # !!!", "allyflagge nicht @#", "hordeflagge nicht @#",
   "50% debuff ~","100% debuff ~","debuff durchsagen" },
 -- Warsong messages to recolorize .....................................................
 WSColoz = {
   1, "Allianz.+St\195\188tzpunkt",
   2, "Horde.+St\195\188tzpunkt" },
 -- Warsong event patterns .............................................................
 WSEvents = {
   "beginnt in 1 Minute", 
   "beginnt in 30 Sekunden", 
   " beginnen!",
   "Flagge",
   "nun schwerere Verletzungen", 
   "nun sehr schwere Verletzungen" },
 -- Warsong zone names (with grammar for 2-click-messages) .............................
 WSZones = {
   "<IN,ZUR>base", "<IN,ZUR>horde-base", "<IN,ZUR>ally-base",
   "<AUF,ZUM>dach", "<AUF,ZUM>horde-dach", "<AUF,ZUM>ally-dach",
   "<AUF,ZUM>fh", "<AUF,ZUM>horde-fh", "<AUF,ZUM>ally-fh",
   "<IM,ZUM>tunnel", "<IM,ZUM>horde-tunnel", "<IM,ZUM>ally-tunnel",
   "<AUF,ZUR>rampe", "<AUF,ZUR>horde-rampe", "<AUF,ZUR>ally-rampe",
   "<AM,ZUM>westrand",
   "<IN,ZUR>mitte",
   "<AM,ZUM>ostrand" },

   }  -- ENDTAB M1PengLocas.deDE

