function LootFilter.schedule(delay, func, ...)
	local args = {};
	for i = 1, select("#", ...) do
		args[i] = select(i, ...);
	end;
	table.insert(LootFilter.timerArr, {time=(GetTime()+delay), func=func, args=args});
	if (not LootFilter.hooked) then
		LootFilter.hook();
	end;
end;

function LootFilter.hook()
	Original_WorldFrame_OnUpdate= WorldFrame_OnUpdate;
	WorldFrame_OnUpdate= LootFilter.WorldFrame_OnUpdate;
	LootFilter.hooked= true;
end;

function LootFilter.unhook()
	WorldFrame_OnUpdate= Original_WorldFrame_OnUpdate;
	LootFilter.hooked= false;
end;

function LootFilter.WorldFrame_OnUpdate()
	Original_WorldFrame_OnUpdate();
	local curtime= GetTime();
	if (LootFilter.lastUpdate < curtime) then
		if (table.getn(LootFilter.timerArr) == 0) then
			LootFilter.unhook();
			return;
		end;
		for i=1, table.getn(LootFilter.timerArr), 1 do
			if (LootFilter.timerArr[i].time <= curtime) then
				func= LootFilter.timerArr[i].func;
				args= LootFilter.timerArr[i].args;
				table.remove(LootFilter.timerArr,i);
				
				if (func ~= nil) then
					if (table.getn(args) == 0) then
						func();
					elseif (table.getn(args) == 1) then
						func(args[1]);
					elseif (table.getn(args) == 2) then
						func(args[1], args[2]);
					end;
				end;
				return;
			end;
		end;
		LootFilter.lastUpdate= curtime+1;
	end;
end;