function LootFilter.deleteItemFromBag(item)
	if (item ~= nil) then
		PickupContainerItem(item["bag"], item["slot"]);
		if (CursorHasItem()) then
			DeleteCursorItem();
			myTime = GetTime();
			return true;
		end;
	end;
	return false;	
end;


-- get the current amount of items
function LootFilter.getStackSizeOfItem(item)
	local amount;
	_, amount, _, _, _ = GetContainerItemInfo(item["bag"], item["slot"]);
	return amount;
end;

-- get id of an item
function LootFilter.getIdOfItem(itemLink)
	return tonumber(string.match(itemLink, ":(%d+)"));
end;

-- get name of an item
function LootFilter.getNameOfItem(itemLink)
	return string.match(itemLink, "%[(.*)%]");
end;

-- get stack size of an item
function LootFilter.getMaxStackSizeOfItem(item)
	local _, _, _, _, _, _, _, stackSize = GetItemInfo(item["id"])
	return tonumber(stackSize);
end;

-- get value of an item
function LootFilter.getValueOfItem(item)
	local itemValue;
	local itemValueAuctioneer;
	
	-- try and get marketvalue
	if (LootFilter.marketValue) and (LootFilterVars[LootFilter.REALMPLAYER].marketvalue) then
		itemValueAuctioneer = AucAdvanced.API.GetMarketValue(item["id"]);
	end
	if (itemValueAuctioneer == nil) then
		itemValueAuctioneer = 0;
	end;
	itemValueAuctioneer = tonumber(itemValueAuctioneer);

	-- try and get vendor value
	if (GetSellValue) then
		itemValue = GetSellValue(item["id"]);
	end;
 	if (itemValue == nil) then
		itemValue = 0;
	end;
	itemValue = tonumber(itemValue);
	
	-- use the highest value available
	if (itemValue < itemValueAuctioneer) then
		itemValue = itemValueAuctioneer;
	end;
	
	if (itemValue ~= 0) then
		itemValue = tonumber(itemValue/10000);
	end;

	return itemValue;	
end;


-- determine if an item is a container
function LootFilter.openItemIfContainer(item)
	if (LootFilter.itemOpen == nil) or (LootFilter.itemOpen == false) then -- only try and open something once after looting because it locks up if you don't
		for key,value in pairs(LootFilterVars[LootFilter.REALMPLAYER].openList) do
			if (LootFilter.matchItemNames(item, value)) then
				if (LootFilterVars[LootFilter.REALMPLAYER].notifyopen) then
					LootFilter.print(LootFilter.Locale.LocText["LTTryopen"].." "..item["link"].." : "..LootFilter.Locale.LocText["LTNameMatched"].." ("..value..")");
				end;
			
				LootFilter.itemOpen = true;
				UseContainerItem(item["bag"], item["slot"]);
				
				return true;
			end;
		end;
	end;
	return false;	
end;


function LootFilter.findItemWithLock()
	for j=0 , 4 , 1 do
		x = GetContainerNumSlots(j);
		for i=0 , x , 1 do
			local _, _, locked = GetContainerItemInfo(j,i);
			if (locked) then
				local itemlink= GetContainerItemLink(j,i);
				if (itemlink ~= nil) then
					local itemName = GetItemInfo(itemlink);
					return itemName;
				end;
			end;
		end;
	end;
	return "";
end;

-- requires 'link' to be present
function LootFilter.getBasicItemInfo(link)
	local item = nil;
	if (link ~= nil) then
		item = {};
		item["link"] = link;
		item["id"] = LootFilter.getIdOfItem(item["link"]);
		item["name"] = LootFilter.getNameOfItem(item["link"]);
		item["value"] = LootFilter.getValueOfItem(item);
		item["stack"] = LootFilter.getMaxStackSizeOfItem(item);
		item["info"] = LootFilter.getExtendedItemInfo(item);
	end;
	return item;
end;

function LootFilter.getExtendedItemInfo(item)
	if (item["info"] ~= nil) then
		return item["info"];
	end;
	LootFilterScanningTooltip:ClearLines();
	LootFilterScanningTooltip:SetHyperlink(item["link"]);
	local result = "";
	local line = "";
	for i=1,LootFilterScanningTooltip:NumLines() do
		line = getglobal("LootFilterScanningTooltipTextLeft" .. i);
		if (line ~= nil) and (line:GetText() ~= nil) then
			result = result..line:GetText().."\n";
	   	end;
		line = getglobal("LootFilterScanningTooltipTextRight" .. i);
	  	if (line ~= nil) and (line:GetText() ~= nil) then
	  		result = result..line:GetText().."\n";
	  	end;	   
	end
	return result;
end;














