﻿--[[

Author: Sheppe Pharis aka Critters
Version: 1.5.3

Notes:
	Provides a moveable button, and/or a checkbox to the left of the bottom actionbars, which locks and unlocks your actionbars with ease. 
	
	This addon was based on the original Lockbar by Vjeux, but has now grown to encompass much more than its predecessor.
	LockBarII links to the actionbar locking functionality that has been implemented by Blizzard. In other words, if you lock your 
	actionbars using the built-in interface options, LockBar II will reflect the setting correctly. Accordingly, if you use 
	LockBar II to lock your actionbars, the built-in interface will be updated to your selection.
	***
	As of v1.1.0 LockBarII now has support for Telo's SideBar.
	***
	As of v1.3.0 LockBarII now has support for CT_BarMod.
	***
	As of v1.4 LockBarII now has support for Fancy Bar.
	***
	As of v1.5 LockBarII now has support for Bartender3.
	***

	NOTE: The moveable button may need to have its frozen status toggled on, and off initially in order to move it. 
		I'm not sure why it is not defaulting to unfrozen initially, as the code is there to do so. It's not really
		a big deal though.
	
	Type in /lbii for a list of supported commands.
	To move the graphical button, just left click and drag it.
]]

-- The string to display in the key bindings menu.
BINDING_HEADER_LockBarII = "LockBarII";

local lbSideBarLoaded = IsAddOnLoaded("SideBar");
local lbCTBarModLoaded = IsAddOnLoaded("CT_BarMod");
local lbFancyBarLoaded = IsAddOnLoaded("Fancy Bar");
local lbBartender3Loaded = IsAddOnLoaded("Bartender3");
local lbDraggingButton = false;
local lbLockedIcon = "Interface\\AddOns\\LockBarII\\ActionbarsLocked";
local lbUnlockedIcon = "Interface\\AddOns\\LockBarII\\ActionbarsUnlocked";
local lbHighlightIcon = "Interface\\AddOns\\LockBarII\\HighlightButton";
local LBCHECK = "showcheck";
local LBBUTTON = "showbutton";
local LBFREEZE = "freeze";

function LockBarII_OnLoad()
	SlashCmdList["LockBar_SlashCommands"] = LockBarII_SlashCommands;
	SLASH_LockBar_SlashCommands1 = "/lbii";

	-- Trapping both addon loaded and variables loaded. 
	-- Trapping addon loaded to allow for loadondemand support.
	-- Trapping variables loaded because we rely on a global variable (LOCK_ACTIONBAR) that we can only be sure is loaded at the time this event fires.
	this:RegisterEvent("ADDON_LOADED");
	this:RegisterEvent("VARIABLES_LOADED");
	this:RegisterEvent("CVAR_UPDATE"); --Trapping the CVAR_UPDATE event as it is fired when the user makes a change to the interface options.
	
	--Load the default values if they don't exist.
	if(not LockBarII_SavedVars) then LockBarII_SavedVars={}; end
	if(not LockBarII_SavedVars[LBCHECK]) then LockBarII_SavedVars[LBCHECK] = true; end
	if(not LockBarII_SavedVars[LBBUTTON]) then LockBarII_SavedVars[LBBUTTON] = true; end	
	if(not LockBarII_SavedVars[LBFREEZE]) then LockBarII_SavedVars[LBFREEZE] = false; end	

	LockBarII_ShowMessage("LockBar II Loaded. Type in /lbii for a list of commands.");
end

function LockBarII_OnEvent()
	if (event == "ADDON_LOADED" and arg1 == "LockBarII") then
		LockBarII_ShowHideFrames();
	elseif (event == "CVAR_UPDATE" and arg1 == "STATUS_BAR_TEXT") then -- Checking for STATUS_BAR_TEXT because it was the last CVar I saw. This is to prevent the "Actionbars Locked" message from displaying repeatedly after the user changes their UI options.
		LockBarII_SetChecked();
	elseif (event == "VARIABLES_LOADED") then
		LockBarII_SetChecked();
	end
end

function LockBarII_SlashCommands(msg)
	if(msg=="") then
		LockBarII_ShowHelp();
	else
		if(msg==LBCHECK) then 
			LockBarII_SavedVars[LBCHECK] = not LockBarII_SavedVars[LBCHECK];
			LockBarII_ShowHideFrames();
		elseif(msg==LBBUTTON) then 
			LockBarII_SavedVars[LBBUTTON] = not LockBarII_SavedVars[LBBUTTON];
			LockBarII_ShowHideFrames();
		elseif(msg==LBFREEZE) then
			LockBarII_SavedVars[LBFREEZE] = not LockBarII_SavedVars[LBFREEZE];
			if(LockBarII_SavedVars[LBFREEZE]) then
				LockBarII_ShowMessage("LockBar II button is now frozen in place. Type in '/lbii freeze' again to unfreeze it.");
			else
				LockBarII_ShowMessage("LockBar II button is now unfrozen and is moveable. Type in '/lbii freeze' again to freeze it.");
			end
		else
			LockBarII_ShowHelp();
		end
	end
	
end

function LockBarII_ShowHideFrames()
	if(LockBarII_SavedVars[LBCHECK]) then LockBarIICheckButton:Show();
	else LockBarIICheckButton:Hide(); end

	if(LockBarII_SavedVars[LBBUTTON]) then LockBarIIMoveableButton:Show();
	else LockBarIIMoveableButton:Hide(); end
end

function LockBarII_CheckButtonOnClick(arg1)
	if(this:GetChecked()) then
		LockBarII_LockBars(true);
	else
		LockBarII_LockBars(false);
	end
end

function LockBarII_MoveableButtonOnClick(arg1)
	if(LOCK_ACTIONBAR == "0") then
		LockBarII_LockBars(true);
	else
		LockBarII_LockBars(false);
	end
end

function LockBarII_SetChecked()
	if(LOCK_ACTIONBAR ~= "0") then
		LockBarII_LockBars(true);
	else
		LockBarII_LockBars(false);
	end
end

function LockBarII_OnDragStart()
	if(LockBarII_SavedVars[LBFREEZE] == false) then
   		if (not lbDraggingButton) then
   			this:StartMoving();
   			lbDraggingButton = true;
   		end
	end
end

function LockBarII_OnDragStop()
	if(LockBarII_SavedVars[LBFREEZE] == false) then
		if (lbDraggingButton) then
			this:StopMovingOrSizing()
			lbDraggingButton = false;
		end
	end
end

function LockBarII_ShowLockedMsg(locked)
	if(locked) then
		LockBarII_ShowMessage("Actionbars Locked");
	else
		LockBarII_ShowMessage("Actionbars Unlocked");
	end
end

function LockBarII_ToggleLockedStatus()
	if(LOCK_ACTIONBAR == "0") then
		LOCK_ACTIONBAR = "1";
	else
		LOCK_ACTIONBAR = "0";
	end
	
	LockBarII_SetChecked();
end

function LockBarII_ShowHelp()
	LockBarII_ShowMessage("LockBarII supports the following commands:");
	LockBarII_ShowMessage("To show/hide the checkbox: /lbii " ..LBCHECK);
	LockBarII_ShowMessage("To show/hide the moveable button: /lbii " ..LBBUTTON);
	LockBarII_ShowMessage("To freeze/unfreeze the moveable button: /lbii " ..LBFREEZE);
end

function LockBarII_ShowMessage(msg)
	if(DEFAULT_CHAT_FRAME) then
		DEFAULT_CHAT_FRAME:AddMessage(msg);
	end
end

function LockBarII_LockBars(bLock)
	if(bLock) then
		LOCK_ACTIONBAR = "1"
		
		--Check the check button.
		LockBarIICheckButton:SetChecked(1);
		
		--Set the texture of the moveable button to reflect the locked status.
		LockBarIIMoveableButton:SetNormalTexture(lbLockedIcon);

		--If SideBar is loaded then lock it too.
		if(lbSideBarLoaded) then
			SideBarState.Lock = 1;
		end
		
		--If CT_BarMod is loaded then lock it too.
		if(lbCTBarModLoaded) then
			CT_BarModOptions_SetOption(2, true);
		end

		--If Fancy Bar is loaded then lock it too.
		if(lbFancyBarLoaded) then
			FancyBar_Lock = 1;
			FancyBar_SetLock(FancyBar_Lock);
		end
		
		-- If Bartender3 is loaded then lock it too.
		if(lbBartender3Loaded) then
			Bartender3.db.profile.ButtonLock = true;
		end
		
		LockBarII_ShowLockedMsg(true);
	
	else
		LOCK_ACTIONBAR = "0"
		
		--Uncheck the check button.
		LockBarIICheckButton:SetChecked(0);
		
		--Set the texture of the moveable button to reflect the locked status.
		LockBarIIMoveableButton:SetNormalTexture(lbUnlockedIcon);

		--If SideBar is loaded then unlock it too.
		if(lbSideBarLoaded) then
			SideBarState.Lock = nil;
		end
		
		--If CT_BarMod is loaded then unlock it too.
		if(lbCTBarModLoaded) then
			CT_BarModOptions_SetOption(2, false);
		end
		
		--If Fancy Bar is loaded then unlock it too.
		if(lbFancyBarLoaded) then
			FancyBar_Lock = 0;
			FancyBar_SetLock(FancyBar_Lock);
		end

		-- If Bartender3 is loaded then unlock it too.
		if(lbBartender3Loaded) then
			Bartender3.db.profile.ButtonLock = false;
		end

		LockBarII_ShowLockedMsg(false);
	
	end
end