-- Localization

-- single global table to hold everything
-- will be referenced by local LWL in LinkWrangler.lua
LinkWranglerLocal = {}

-- English

-- Bindings (used in bindings.xml)
BINDING_HEADER_LINKWRANGLER = "LinkWrangler"
BINDING_NAME_LINKWRANGLERCLOSE = "Close all LinkWrangler windows"
BINDING_NAME_LINKWRANGLERENABLE = "Enable or Disable LinkWrangler"
BINDING_NAME_LINKWRANGLERMINIMIZE = "Minimize or Maximize all LinkWrangler windows"
BINDING_NAME_LINKWRANGLERCAPTURE = "Open LinkWrangler tooltip from item under mouse"

-- Alternative slash command for localization
-- If provided, LinkWrangler will install this as a third slash command
LinkWranglerLocal.AltSlashCommand = nil

-- used to convert internal code back to displayable option name
LinkWranglerLocal.Display = {
	["LeftButton"] = "leftclick",
	["RightButton"] = "rightclick",
	["MiddleButton"] = "middleclick",
}

-- Tooltips
LinkWranglerLocal.Tooltip = {
	Minimize	= "Minimize this window",
	Close		= "Close this window and its child windows.\n(Shift-Click to close all windows)",
	Close2		= "Close this window.\n(Shift-Click to close all windows)", -- for compare window
	Compare		= "Compare Equipped Items",
	Whisper		= "Whisper to link originator",
	Relink		= "Relink this item",
	Link		= "Link this item",
	Dressup		= "View this item in the Dressing Room",
	Capture		= "Open in a normal Linkwrangler window",
}

--Output Messages
LinkWranglerLocal.Message = {
	ENABLED = "enabled",
	DISABLED = "disabled",
	UNKNOWN = "for help: \'/lw help\'. version: %g : %s",
	LIST = "Using the following AddOns:",
	LISTLINE = "%d. %s: main %s, compare %s",
	STATUS = " version: %g : %s\nConfiguration status:",
	CLICK = "Setting %s:",
	INVALID = "invalid option: %s",
	UNKNOWNADDON = "unknown AddOn: %s",
	CLICKSTATUS = "%s actions :",
	BUTTONS = "Enabled buttons :",
	USAGE = "usage: /lw %s [on|off|toggle]",
	MAXWINDOWS = "All LinkWrangler windows are in use; please close a window before opening a new link.",
	MAXWINDOWSUSAGE = "usage: /lw maxwindows <1-200>",
	SCALEUSAGE = "usage: /lw scale <0.2-2.5>",
	--ALPHAUSAGE = "usage: /lw alpha <0.0-1.0>",
	NODRESSUP = "That item cannot be equipped.",
	RESETCHECK = "Saved variables will be checked when UI is reloaded.",
	DEFAULTSAVED = "Saved variables have been set to defaults.",
	TESTSAVED = "Checking saved variables.",
	RESETSETTING = "Setting will take effect when UI is reloaded.",
	PURGE = "Cleaning out unused Saved Variables settings",
	HELP = {
		"LinkWrangler options summary:", --[1]
		"  enable / disable / toggle",
		"  status",
		"  list",
		"  addons [<enable/disable/enablecomp/disablecomp> <addon name/number>]",
		"  help",
		"  buttons [closeonly/closemin/all/[no]close/[no]minimize/[no]compare/",
		"            [no]whisper/[no]relink/[no]dressup/[no]capture]",
		"  leftclick / rightclick / middleclick / allclick <action>=<command>",
		"    <action> = shift / ctrl / alt / action",
		"    <command> = open / bypass / relink / dressup / openmin",
		"  leftclick / rightclick / middleclick / allclick [default / disable]",
		"  maxwindows <1-100>",
		"  scale <0.2-2.5>",
		"  verbose [on/off/toggle]",
		"  alllinks [on/off/toggle]",
		"  savelayout [on/off/toggle]",
	},
}

-- German/Deutsch
if ( GetLocale() == "deDE" ) then

	-- Tooltips
	LinkWranglerLocal.Tooltip = {
		Minimize	= "Dies Fenster minimieren",
		Close		= "Dies Fenster und alle Unterfenster schlie\195\159en.\n(Shift-Klick um alle Fenster zu schlie\195\159en)",
		Close2		= "Dies Fenster schlie\195\159en.\n(Shift-Klick um alle Fenster zu schlie\195\159en)",
		Compare		= "Vergleiche angelegten Gegenstand",
		Whisper		= "Link-Poster anfl\195\188stern",
		Relink		= "Dies Item erneut verlinken",
		Link		= "Dies Item verlinken",
		Dressup		= "Diesen Gegenstand anprobieren",
		Capture		= "Open in a normal Linkwrangler window",
	}

-- French/Franais
--[[ disabled until we get round to doing it
elseif (GetLocale() == "frFR") then

-- end disabled code ]]

--[[ korean localization? Unknown source, may or may not work correctly...]]
elseif (GetLocale() == "koKR") then

	-- Tooltips
	LinkWranglerLocal.Tooltip = {
		Minimize	= "창을 최소화",
		Close		= "창과 종속된 창을 모두 닫기.\n(Shift-Click 모든 창을 닫기.)",
		Close2		= "창과 종속된 창을 모두 닫기.\n(Shift-Click 모든 창을 닫기.)",
		Compare		= "착용중인 아이템과 비교",
		Whisper		= "링크자에게 귓속말",
		Relink		= "아이템 다시 링크",
		Link		= "아이템 링크",
		Dressup		= "아이템 미리보기",
		Capture		= "Open in a normal Linkwrangler window",
	}

end