--[[ Alias.lua

Defines a global table LinkWranglerAlias
(referenced within linkwrangler.lua by the local variable LWA)
Used to map alternative keywords to ones recognised by linkwrangler.lua ...

enable, disable, toggle, help, status, list, addons, maxwindows, allclick, buttons, alllinks, verbose, savelayout
enablecomp, disablecomp
shift, ctrl, alt, action, relink, open, bypass, openmin
closeonly, closemin, all, close, noclose, minimize, nominimize, compare, nocompare
whisper, nowhisper, relink, norelink, dressup, nodressup, capture, nocapture
default, test, clear, purge
note capitalisation in following: LeftButton, RightButton, MiddleButton
]]
LinkWranglerAlias = {}

LinkWranglerAlias["reset"] = "default"
LinkWranglerAlias["on"] = "enable"
LinkWranglerAlias["off"] = "disable"
LinkWranglerAlias["minimise"] = "minimize"
LinkWranglerAlias["nominimise"] = "nominimize"
LinkWranglerAlias["openminimized"] = "openmin"
LinkWranglerAlias["openminimised"] = "openmin"
LinkWranglerAlias["bothclick"] = "allclick"
LinkWranglerAlias["control"] = "ctrl"
LinkWranglerAlias["nokey"] = "action"
LinkWranglerAlias["nomod"] = "action"
LinkWranglerAlias["leftclick"] = "LeftButton"
LinkWranglerAlias["leftbutton"] = "LeftButton"
LinkWranglerAlias["rightclick"] = "RightButton"
LinkWranglerAlias["rightbutton"] = "RightButton"
LinkWranglerAlias["middleclick"] = "MiddleButton"
LinkWranglerAlias["middlebutton"] = "MiddleButton"

