

-- LilSparky's Workshop -- Addon for WOW Trade Skill frames
-- Lilsparky of Lothar
-- v0.51
-- jan.10.2008


LSW_VERSION = "LSW v0.51";
LSW_VERSION_LONG = "LilSparky's Workshop v0.51"

ATSW_ShowWindow_ORIGINAL = nil;

SkilletFrame_Show_ORIGINAL = nil;
SkilletFrame_Update_ORIGINAL = nil;
SkilletBeforeRecipeButtonShow_ORIGNAL = nil;
SkilletBeforeRecipeButtonHide_ORIGINAL = nil;


TradeSkillFrame_Show_ORIGINAL = nil;
TradeSkillFrame_Update_ORIGINAL = nil;


TradeskillInfoUI_Frame_Update_ORIGINAL = nil;
TradeskillInfoUI_Frame_Show_ORIGINAL = nil;
---

LSW_initialized = false;
LSW_pricingInitialized = false;


LSW_Mode = "TradeSkill";

LSW_AuctioneerHook = "";

LSW_TRADESKILL_INDEX_MAX = 8
LSW_CRAFT_INDEX_MAX = 8

LSW_MINIMUM_REAGENT_AUCTIONS = 10
LSW_MINIMUM_ITEM_AUCTIONS = 1

LSW_itemFateColor={};
LSW_itemFateColor["d"]="ff008000";
LSW_itemFateColor["a"]="ff909050";
LSW_itemFateColor["v"]="ff206080";
LSW_itemFateColor["?"]="ff800000";

LSW_globalSync = 1;
LSW_skillPriceCache={};

LSW_globalFate = 0;
LSW_globalFateMax = 3;
LSW_valueAsPercent = false; 	-- display % for values


-- these could certainly be made language specific if needed
LSW_itemFateList={};
LSW_itemFateList[1]="a";		-- auction
LSW_itemFateList[2]="v";		-- vendor
LSW_itemFateList[3]="d";		-- disenchant

LSW_fateString={};
LSW_fateString["a"]="Auction";
LSW_fateString["v"]="Vendor";
LSW_fateString["d"]="Disenchant";


LSW_skillWidthNarrow = 223;
LSW_skillWidthWide = 243;

LSW_skillWidth = LSW_skillWidthWide;

LSW_itemPriceVendor = nil;
LSW_itemPriceAuction = nil;

LSW_priceSanity = true;

LSW_Tooltip = nil;


LSW_linkCache = {};

LSW_periodicTableLib = nil;

LSW_BOP_STRING = "|cffff0000-BOP-|r"


function LSW_ChatMessage(msg)
	DEFAULT_CHAT_FRAME:AddMessage("|cff80d060"..(msg or "nil"));
end

function LSW_ErrorMessage(msg)
	DEFAULT_CHAT_FRAME:AddMessage("|cffff0000"..(msg or "nil"));
end


function LSW_queryServerInfo(link)
	local id = LSW_findItemID(link);
	
	if (not id) then
		id = LSW_findEnchantID(link)
		
		if ( id) then id = "e"..id end
	end
	
	if (id and not LSW_linkCache[id]) then
		LSW_linkCache[id] = true;
		

		if (not GetItemInfo(link)) then
			LSW_ErrorMessage("no local cache info for "..link);
--			GameTooltip:SetHyperlink(link);
		end
	end
end


function LSW_formatMoney(moneyString,hilight)
	local money = tonumber(moneyString);
	if (money < 0) then return "   --"; end
	
	local GSC_GOLD = "ff807000"
	local GSC_SILVER = "ff808080"
	local GSC_COPPER = "ff643016"

	if (hilight) then
		GSC_GOLD="ffffd100"
		GSC_SILVER="ffe6e6e6"
		GSC_COPPER="ffc8602c"
	end
	
	local g, s, c;
	local digits = 0
	
	g = math.floor(money/10000);
	s = math.fmod(math.floor(money/100),100);
	c = math.fmod(money,100);

	if (money > 0) then
		digits = math.floor(math.log10(money)+1)
	end
	
	if ( digits < 3 ) then
		gsc = string.format("   |c%s%2d|r",  GSC_COPPER, c);
	elseif ( digits < 5 ) then
		gsc = string.format("|c%s%2d|r |c%s%02d|r", GSC_SILVER, s, GSC_COPPER, c)
	elseif ( digits < 7 ) then
		gsc = string.format("|c%s%2d|r |c%s%02d|r", GSC_GOLD, g, GSC_SILVER, s)
	else
		gsc = string.format("|c%s%5d|r", GSC_GOLD, g);
	end

	return gsc
end


function LSW_GetSkillByID(id)
	local skillName;
	local skillLink;
	local skillType;
	local skillID;
		
	if (LSW_Mode == "ATSW") then
		local listpos=ATSW_GetSkillListingPos(id);
		
		if(atsw_skilllisting[listpos]) then
			skillName = atsw_skilllisting[listpos].name;
			skillLink = atsw_skilllisting[listpos].link;
			skillType = atsw_skilllisting[listpos].type;
			skillID =   atsw_skilllisting[listpos].id;
		end
	else
		skillID=id;
		skillName, skillType = LSW_GetTradeSkillInfo(skillID);
		skillLink = LSW_GetTradeSkillItemLink(skillID);
	end
	
	return skillName, skillLink, skillType, skillID;
end


function LSW_GetTradeSkillInfo(index)
	local skillName, skillType, numAvailable, isExpanded;

	if (index > 100000) then
		return TradeskillInfoUI.GetTradeSkillInfo(TradeskillInfoUI,index-100000);
	else	
		if (LSW_Mode == "ATSW") then
			skillName, craftSubSpellName, skillType, numAvailable, isExpanded = ATSW_GetTradeSkillInfo(index);
		elseif (LSW_Mode == "Craft" or (LSW_Mode == "Skillet" and Skillet:IsCraft())) then
			skillName, craftSubSpellName, skillType, numAvailable, isExpanded = GetCraftInfo(index);
		else
			skillName, skillType, numAvailable, isExpanded = GetTradeSkillInfo(index);
		end
	end
	
	return skillName, skillType, numAvailable, isExpanded;
end


function LSW_GetTradeSkillNumMade(index)
	if (index > 100000) then
		local i2 = index - 100000;
		local n = TradeskillInfoUI.GetTradeSkillNumMade(TradeskillInfoUI,i2);
		return n,n;
	else
		if (LSW_Mode == "ATSW") then
			return ATSW_GetTradeSkillNumMade(index);
		elseif (LSW_Mode == "Craft" or (LSW_Mode == "Skillet" and Skillet:IsCraft())) then
			return 1, 1
		else
			return GetTradeSkillNumMade(index);
		end	
	end
end

function LSW_GetTradeSkillNumReagents(index)
	if (index > 100000) then
		local i2 = index - 100000;
		local num = TradeskillInfoUI.GetTradeSkillNumReagents(TradeskillInfoUI,i2);
		return num;
	else
		if (LSW_Mode == "ATSW") then
			return ATSW_GetTradeSkillNumReagents(index);
		elseif (LSW_Mode == "Craft" or (LSW_Mode == "Skillet" and Skillet:IsCraft())) then
			return GetCraftNumReagents(index);
		else
			return GetTradeSkillNumReagents(index);
		end
	end
end


function LSW_bopCheck(link)
	local tooltip = getglobal("LSWParsingTooltip");
	local bop = false;
	
	if tooltip == nil then
		tooltip = CreateFrame("GameTooltip", "LSWParsingTooltip", getglobal("ANCHOR_NONE"), "GameTooltipTemplate");
		tooltip:SetOwner(WorldFrame, "ANCHOR_NONE");
	end

	tooltip:SetHyperlink(link);

	local tiplines = tooltip:NumLines();

	for i=1, tiplines, 1 do
		local lineText = string.lower(getglobal("LSWParsingTooltipTextLeft"..i):GetText() or " ");
		
		if (string.find(lineText, "binds when picked up")) then
			bop = true;
			break;
		end
	end
	
	return bop;
end

function LSW_GetTradeSkillReagentInfo(index, reagentIndex)
	if (index > 100000) then
		local i2 = index - 100000;
		TradeskillInfoUI.GetTradeSkillNumReagents(TradeskillInfoUI,i2)
		return TradeskillInfoUI.GetTradeSkillReagentInfo(TradeskillInfoUI,reagentIndex);
	else
		if (LSW_Mode == "ATSW") then
			return ATSW_GetTradeSkillReagentInfo(index, reagentIndex);
		elseif (LSW_Mode == "Craft" or (LSW_Mode == "Skillet" and Skillet:IsCraft())) then
			return GetCraftReagentInfo(index, reagentIndex);
		else
			return GetTradeSkillReagentInfo(index, reagentIndex);
		end
	end
end

function LSW_GetTradeSkillReagentItemLink(index, reagentIndex)
	if (index > 100000) then
		local i2 = index - 100000;
		TradeskillInfoUI.GetTradeSkillNumReagents(TradeskillInfoUI,i2);
		local name,_,_,link,itemString = TradeskillInfoUI.GetTradeSkillReagentInfo(TradeskillInfoUI, reagentIndex);
		if (link) then
			return link;
		else
			link = "|cffffffff|H"..itemString.."|h["..name.."]|h|r";
			
			return link;
		end
	else	
		if (LSW_Mode == "ATSW") then
			return ATSW_GetTradeSkillReagentItemLink(index, reagentIndex);
		elseif (LSW_Mode == "Craft" or (LSW_Mode == "Skillet" and Skillet:IsCraft())) then
			return GetCraftReagentItemLink(index, reagentIndex);
		else
			return GetTradeSkillReagentItemLink(index, reagentIndex);
		end	
	end
end

function LSW_GetTradeSkillItemLink(index)
	if (index > 100000) then
		local _, link, itemString = TradeskillInfoUI.GetTradeSkillIcon(TradeskillInfoUI,index-100000);
	
		if (not link) then
			local skillName, skillType, isExpanded = TradeskillInfoUI.GetTradeSkillInfo(TradeskillInfoUI,index-100000);
			link = "|cffffffff|H"..itemString.."|h["..skillName.."]|h|r";
		end
		
		return link;
	else		
		if (LSW_Mode == "ATSW") then
			return ATSW_GetTradeSkillItemLink(index)
		elseif (LSW_Mode == "Craft" or (LSW_Mode == "Skillet" and Skillet:IsCraft())) then
			return GetCraftItemLink(index);
		else
			return GetTradeSkillItemLink(index);
		end
	end	
end


function LSW_findItemID(link)
	if ( type(link) ~= 'string' ) then return end
	local i,j,itemID = string.find(link, "|Hitem:(%d+):");		
	return tonumber(itemID); 
end


function LSW_findEnchantID(link)
	if ( type(link) ~= 'string' ) then return end
	local i,j,enchantID = string.find(link, "|Henchant:(%d+):");		
	return tonumber(enchantID); 
end


function LSW_findItemFullID(link)
	local itemID, suffixID = link:match("item:(%-?%d+):(%-?%d+:%-?%d+:%-?%d+:%-?%d+:%-?%d+:%-?%d+:)%-?%d+")
    local fullID = ("%s:%s0"):format(itemID, suffixID)

	return fullID;
end        

function LSW_findItemShortCode(link)    
    return tonumber(link:match("item:(%-?%d+)"))
end




function LSW_itemPriceVendor(link, minSeen)
	return 0, 0, true;
end


function LSW_itemPriceVendorGetSellValue(link)
	local gsv = GetSellValue(link);
	
	if (gsv) then
		return gsv, gsv, false;
	else
		return 0, 0, true;
	end
end



function LSW_itemPriceVendorInformant(link)
	local sell = 0
	local buy = 0
	local itemInfo = nil;
	local quant;
	
	local itemID = LSW_findItemID(link)
	
	if (itemID and itemID > 0) and (Informant) then
		itemInfo = Informant.GetItem(itemID)
	end
	
	if (not itemInfo) then return 0,0, true end

	buy = tonumber(itemInfo.buy) or 0
	sell = tonumber(itemInfo.sell) or 0
	quant = tonumber(itemInfo.quantity) or 0
	
	if (quant > 1) then buy = buy / quant; end
	
	return buy, sell, false
end


function LSW_itemPriceVendorKCItems(link)
	local id = LSW_findItemShortCode(link);
	
	local sell, buy = SellValues:GetValues(id);
	
--LSW_ChatMessage("vendor price: link "..link.." id: "..id.." buy: "..(buy or "nil").." sell: "..(sell or "nil"));
	
	if (buy) then
		return buy, sell, false;
	else
		return 0,0,true;
	end
end




function LSW_itemPrice(link, minSeen)
	return 0, true;
end
	

function LSW_itemPriceKCItems(link, minSeen) -- KC_Items version
	local id = LSW_findItemFullID(link);
	local faction = UnitFactionGroup("player");
	local buyout = -1;
	
--LSW_ChatMessage("ah price: faction:"..faction.." link "..link.." id: "..id);
	
	local mktV, hmktV, avgStkSz, stkSzCfrm, mAvg, hmAvg, mStdDev, mMax, yAvg, hyAvg, yStdDev, yMin, bAvg, hbAvg, bStdDev, bMax = AuctionSpy:GetItemInfo(faction, id)
	if (mktV) then
		buyout = (yAvg - yStdDev); -- dunno how to find the number of items in the database
		
		return buyout, false;
--LSW_ChatMessage("ah price: link "..link.." id: "..id.." buy: "..(buyout or "nil"));
	end
		
	return buyout, true;
--	end
	
--	if (not minSeen) then minSeen = 1; end
	
--	if (seen < minSeen) then
--		return 0, true;	
--	end
	
--	return priceBuyout, false;
end


function LSW_itemPriceAuctioneer(link, minSeen) -- auctioneer version
	if (not Auctioneer or not link) then return 0, true; end

	if (not minSeen) then minSeen = 1 end;
	
-- LSW_ErrorMessage(link);

	local itemKey = Auctioneer.ItemDB.CreateItemKeyFromLink(link);
	local dataMissing = false;
	
	local itemTotals = Auctioneer.HistoryDB.GetItemTotals(itemKey, auctKey);

	local sellPrice=0;
	
	if (not itemTotals) then
		return 0,0,true;
	end

-- LSW_ErrorMessage(itemTotals.seenCount.." seen");
	if (itemTotals.seenCount < minSeen) then
		return 0, true;
	else		
--		sellPrice  = Auctioneer.Statistic.GetMarketPrice(itemKey, auctKey);
		
		sellPrice  = Auctioneer.Statistic.GetHSP(itemKey, auctKey,1);
		dataMissing = false;		
	end
	
	return sellPrice, dataMissing;
end


function LSW_itemPriceAucAdvanced(link, minSeen) -- aucadvanced version (work in progress)
	local numSeen;
	
	if (not link) then return 0, true; end
	
	if (not minSeen) then minSeen = 1; end

	local sellPrice=0;
	sellPrice, numSeen = AucAdvanced.API.GetMarketValue(link, AucAdvanced.GetFaction());
				
	if (not sellPrice or numSeen < minSeen) then
		return 0, true;
	end

	return sellPrice, false;
end


function LSW_itemPriceAuctioneerBoth(link, minSeen) -- use both aucadvanced and auctioneer data
	if (not Auctioneer or not AucAdvanced or not link) then return 0, true; end

	if (not minSeen) then minSeen = 1 end;
	
-- LSW_ErrorMessage(link);

	local itemKey = Auctioneer.ItemDB.CreateItemKeyFromLink(link);
	local dataMissing = false;
	
	local itemTotals = Auctioneer.HistoryDB.GetItemTotals(itemKey, auctKey);
	local sellPrice=0;
	local numSeen=0;
	
	if (itemTotals) then
		numSeen = itemTotals.seenCount;
		
		sellPrice  = Auctioneer.Statistic.GetHSP(itemKey, auctKey,1);
--		dummy, sellPrice  = Auctioneer.Statistic.GetMarketPrice(itemKey, auctKey);

	end

	local sellPriceAdv, numSeenAdv = AucAdvanced.API.GetMarketValue(link, AucAdvanced.GetFaction());
	
	if (sellPriceAdv) then
		sellPrice = (sellPrice * numSeen + sellPriceAdv * numSeenAdv) / (numSeenAdv + numSeen);
		numSeen = numSeenAdv + numSeen;
	end
	
	if (numSeen < minSeen) then
		return 0, true;
	end
	
	return sellPrice, false;
end



function LSW_itemValuation(skillName, skillLink, skillID)	
	if (not LSW_pricingInitialized) then
		LSW_pricingInitialized = true;
		LSW_InitializePricing();
		local minorVersion;
		
		if (LibStub) then
			LSW_periodicTableLib, minorVersion = LibStub:GetLibrary("LibPeriodicTable-3.1", true)
			
			if (LSW_periodicTableLib) then
				LSW_ChatMessage("LilSparky's Workshop using LibPeriodicTable-3.1 ("..minorVersion..") for vendor availablity data");
			end
		end
	end

	if (LSW_itemPrice == nil or LSW_itemPriceVendor == nil) then
		return -1, -1, "?";
	end
	
	if (LSW_skillPriceCache == nil) then return -1, -1, "?" end
	
	if (LSW_skillPriceCache[skillName] == nil) then
		LSW_skillPriceCache[skillName]={}
		LSW_skillPriceCache[skillName].sync = 0
		LSW_skillPriceCache[skillName].valueAmount = {};
	else
		if (LSW_skillPriceCache[skillName].sync == LSW_globalSync) then
			if (LSW_globalFate==0) then
				return LSW_skillPriceCache[skillName].costAmount, LSW_skillPriceCache[skillName].valueAmount[LSW_globalFate], LSW_skillPriceCache[skillName].itemFate;
			else
				return LSW_skillPriceCache[skillName].costAmount, LSW_skillPriceCache[skillName].valueAmount[LSW_globalFate], LSW_itemFateList[LSW_globalFate];
			end
		end
	end

	local cache = LSW_skillPriceCache[skillName];
	cache.synce = LSW_globalSync;
	cache.valueAmount[1] = -1;
	cache.valueAmount[2] = -1;
	cache.valueAmount[3] = -1;
	
	local sell = 0;
	local buy = 0;
	local stacks = 1;
	local itemFate = "?"
	
	local dummy;
	
	local numReagents;
	
	local dePricer=nil;
	
	numReagents = LSW_GetTradeSkillNumReagents(skillID);

-- LSW_ChatMessage(skillID.." "..numReagents);

	if (Enchantrix) then
		dePricer = Enchantrix.Storage.GetItemDisenchantTotals;
	end
	
-- LSW_ChatMessage(skillLink);
	LSW_queryServerInfo(skillLink);
	
	for i=1, numReagents, 1 do
		local reagentName, dummy, reagentCount = LSW_GetTradeSkillReagentInfo(skillID, i);
		local reagentLink = LSW_GetTradeSkillReagentItemLink(skillID, i);
		
		LSW_queryServerInfo(reagentLink);
		
		local sellAtAuction;
		local buyFromVendor;
		local ahDataMissing;
		
		local reagentValue;
		
		
		local vendorSellsItem = false;
		
        if LSW_periodicTableLib then
            vendorSellsItem = LSW_periodicTableLib:ItemInSet(reagentLink,"Tradeskill.Mat.BySource.Vendor")
        end
        
		buyFromVendor = LSW_itemPriceVendor(reagentLink);

		if (vendorSellsItem) then		-- reagent can be purchased from vendor
			reagentValue = buyFromVendor;
		else							-- reagent cannot be purchased from vendor
			sellAtAuction, ahDataMissing = LSW_itemPrice(reagentLink, LSW_MININUM_REAGENT_AUCTIONS);

-- calculate the cost of reagents.  if ah data exists, use it.  if no ah data exists then use the buy from vendor price

			if (ahDataMissing or sellAtAuction < 0) then
				reagentValue = buyFromVendor;
			else
				reagentValue = sellAtAuction;
			end
		end
		
		
-- LSW_ErrorMessage(reagentLink.."  "..reagentValue);
	

		buy = buy + reagentValue * reagentCount;
	end
		
	cache.costAmount = buy;  -- costAmount = how much it would cost to purchase the reagents
	
	if (skillLink and GetItemInfo(skillLink)) then  -- items return info, enchants return nil
		local min,max;
		local data_missing;
		
		min, max = LSW_GetTradeSkillNumMade(skillID); -- unfortunately, blizzard hasn't yet fixed this to return the correct number of items for specialists
		
-- LSW_ErrorMessage(skillName.."  "..min.." "..max);

		stacks = (min+max)/2;
	
		if (skillName == "Small Prismatic Shard") then
			stacks = 3;
		end

		sell, data_missing = LSW_itemPrice(skillLink, LSW_MINIUMUM_ITEM_AUCTIONS);
		if (data_missing == false) then
			cache.valueAmount[1] = sell * stacks;						-- valueAmount[1] = how much an item might auction for

		else
			if (LSW_bopCheck(skillLink)) then
				cache.valueAmount[1] = -2;								-- ah price of -2 = BOP
			end
		end
		
		
		dummy, sell, data_missing = LSW_itemPriceVendor(skillLink);
		if (data_missing == false) then cache.valueAmount[2] = sell * stacks; end -- valueAmount[2] = how much an item would sell to a vendor for
	
		if (LSW_AuctioneerHook == "auctioneer") then -- SELECT ENCHANTRIX CALL BASED ON AUCTIONEER MODULE LOADED
			if (dePricer) then
				sell = dePricer(skillLink); -- auctioneer
			else
				sell = nil;
			end
		else
			if (dePricer) then
				dummy, dummy, dummy, sell = dePricer(skillLink); -- aucadvanced
			else
				sell = nil;
			end
		end
		
		if (sell) then
			cache.valueAmount[3] = sell * stacks;  -- valueAmount[3] = how much an item would sell for if de'd
		end

	end
	
	
	if (cache.valueAmount[1] >= cache.valueAmount[2] and cache.valueAmount[1] >= cache.valueAmount[3]) then
		cache.valueAmount[0] = cache.valueAmount[1];
		cache.itemFate = LSW_itemFateList[1];
	else
		if (cache.valueAmount[2] >= cache.valueAmount[3] and cache.valueAmount[2] >= cache.valueAmount[1]) then
			cache.valueAmount[0] = cache.valueAmount[2];
			cache.itemFate = LSW_itemFateList[2];
		else
			cache.valueAmount[0] = cache.valueAmount[3];
			cache.itemFate = LSW_itemFateList[3];
		end
	end
	
	LSW_skillPriceCache[skillName].sync = LSW_globalSync;
				
	if (LSW_globalFate==0) then
		return LSW_skillPriceCache[skillName].costAmount, LSW_skillPriceCache[skillName].valueAmount[LSW_globalFate], LSW_skillPriceCache[skillName].itemFate;
	else
		return LSW_skillPriceCache[skillName].costAmount, LSW_skillPriceCache[skillName].valueAmount[LSW_globalFate], LSW_itemFateList[LSW_globalFate];
	end
end


function LSW_SortCompareItemLevel(skill,a,b)  -- highest level first
	local skillLinkA, skillNameA;
	local skillLinkB, skillNameB;
	local itemLevelA=0;
	local itemLevelB=0;
	local x;
	
--	LSW_ErrorMessage("compare "..skill);
	
	if (not a) then return false; end
	if (not b) then return true; end
	
	skillLinkA = LSW_GetTradeSkillItemLink(a);
	skillLinkB = LSW_GetTradeSkillItemLink(b);
	
	if (skillLinkA) then		
		x, x, x, x, itemLevelA = GetItemInfo(skillLinkA);
	end
	
	if (skillLinkB) then
		x, x, x, x, itemLevelB = GetItemInfo(skillLinkB);
	end
	
	if (not itemLevelB) then return true; end
	if (not itemLevelA) then return false; end
	
	if (itemLevelA > itemLevelB) then return true; end
	
	return false;
end


function LSW_SortCompareItemValue(skill,a,b)  -- highest value first
	local skillLinkA, skillNameA;
	local skillLinkB, skillNameB;
	local itemValueA=0;
	local itemValueB=0;
	local x;
	
	skillNameA = LSW_GetTradeSkillInfo(a);
	skillLinkA = LSW_GetTradeSkillItemLink(a);
	
	skillNameB = LSW_GetTradeSkillInfo(b);
	skillLinkB = LSW_GetTradeSkillItemLink(b);

	x, itemValueA = LSW_itemValuation(skillNameA, skillLinkA, a);
	x, itemValueB = LSW_itemValuation(skillNameB, skillLinkB, b);
	
	if (itemValueA > itemValueB) then return true; end
	
	return false;
end


function LSW_SortCompareReagentCost(skill,b,a)  -- lowest cost first so i swap b and a
	local skillLinkA, skillNameA;
	local skillLinkB, skillNameB;
	local itemCostA=0;
	local itemCostB=0;
	local x;
	
	skillNameA = LSW_GetTradeSkillInfo(a);
	skillLinkA = LSW_GetTradeSkillItemLink(a);
	
	skillNameB = LSW_GetTradeSkillInfo(b);
	skillLinkB = LSW_GetTradeSkillItemLink(b);

	itemCostA = LSW_itemValuation(skillNameA, skillLinkA, a);
	itemCostB = LSW_itemValuation(skillNameB, skillLinkB, b);
	
	if (itemCostA > itemCostB) then return true; end
	
	return false;
end


function LSW_SortCompareProfit(skill,a,b)  -- highest profit first
	local skillLinkA, skillNameA;
	local skillLinkB, skillNameB;
	local itemCostA, itemValueA, itemProfitA;
	local itemCostB, itemValueB, itemProfitB;

--LSW_ErrorMessage("compare "..a.." to "..b);

	skillNameA = LSW_GetTradeSkillInfo(a);
	skillLinkA = LSW_GetTradeSkillItemLink(a);
	
	skillNameB = LSW_GetTradeSkillInfo(b);
	skillLinkB = LSW_GetTradeSkillItemLink(b);

	itemCostA, itemValueA = LSW_itemValuation(skillNameA, skillLinkA, a);
	itemCostB, itemValueB = LSW_itemValuation(skillNameB, skillLinkB, b);
	
	itemProfitA = itemValueA - itemCostA;
	itemProfitB = itemValueB - itemCostB;
	
	if (itemProfitA > itemProfitB) then return true; end
	
	return false;
end

function LSW_SkillShow(button)
	if (LSW_Mode == "Craft") then
		if (GetCraftName() ~= "Enchanting") then
			return;
		end
	end

	local name = button:GetName();
	local itemLevel = "?";
	local x;
	local id;
	
	local buttonLevel;
	local buttonCost;
	local buttonValue;
	
	if (LSW_Mode == "Skillet") then
		id = string.sub(name,20); -- SkilletScrollButton[id]
		
		buttonValue = getglobal("LSWTradeSkillValue"..id);
		buttonCost = getglobal("LSWTradeSkillCost"..id);
		buttonLevel = getglobal("LSWTradeSkillItemLevel"..id);
		
		if (not buttonValue) then
			buttonValue, buttonCost, buttonLevel = LSW_CreateDynamicButtons(id, name, SkilletFrame);
		end
			
		button:SetWidth(LSW_skillWidth);
	elseif (LSW_Mode == "ATSW") then
		id = string.sub(name,10); -- ATSWSkill[id]
		
		buttonValue = getglobal("LSWTradeSkillValue"..id);
		buttonCost = getglobal("LSWTradeSkillCost"..id);
		buttonLevel = getglobal("LSWTradeSkillItemLevel"..id);
		
		button:SetWidth(LSW_skillWidth);
	elseif (LSW_Mode == "Craft") then
		id = string.sub(name,6); -- Craft[id]
		
		buttonLevel = getglobal("LSWCraftItemLevel"..id);
		buttonCost = getglobal("LSWCraftCost"..id);
		buttonValue = getglobal("LSWCraftValue"..id);
		
		button:SetWidth(LSW_skillWidth);
	else
		id = string.sub(name,16); -- TradeSkillSkill[id]
		
		buttonValue = getglobal("LSWTradeSkillValue"..id);
		buttonCost = getglobal("LSWTradeSkillCost"..id);
		buttonLevel = getglobal("LSWTradeSkillItemLevel"..id);
		
		button:SetWidth(LSW_skillWidth);
	end
	
	if (not buttonValue) then return; end
	
	
	
	local skillName;
	local skillLink;
	local skillType;
	local skillID;
	
	if (LSW_Mode == "ATSW") then
		local tradeSkillID=button:GetID();
		local listpos=ATSW_GetSkillListingPos(tradeSkillID);
	
		if(atsw_skilllisting[listpos]) then
			skillName = atsw_skilllisting[listpos].name;
			skillLink = atsw_skilllisting[listpos].link;
			skillType = atsw_skilllisting[listpos].type;
			skillID =   atsw_skilllisting[listpos].id;
		end
		
--		LSW_ErrorMessage("ATSW: "..skillName.." "..skillLink.." "..skillType.." "..skillID);

	else
		skillID=button:GetID();
		skillName, skillType = LSW_GetTradeSkillInfo(skillID);
		skillLink = LSW_GetTradeSkillItemLink(skillID);
	end
	
	buttonCost:SetID(skillID);
	buttonValue:SetID(skillID);
	buttonLevel:SetID(skillID);
	
	if (skillName and skillType ~= "header") then						
		local costAmount, valueAmount, itemFate = LSW_itemValuation(skillName, skillLink, skillID);
						
		local itemFateString = string.format("|c%s%s|r", LSW_itemFateColor[itemFate], itemFate);
		local hilight = (costAmount < valueAmount);
		local valueText;
					
		
		if (LSW_valueAsPercent) then
			if (costAmount > 0 and valueAmount > 0) then
				local per = valueAmount / costAmount;
				
				per = math.floor(per*1000)/10;
				
				valueText = string.format("%2.1f%%",per);
				
				if (hilight) then
					valueText = "|cffd0d0d0"..valueText..itemFateString;
				else
					valueText = "|cffd02020"..valueText..itemFateString;
				end
				
			elseif (valueAmount > 0) then
				valueText = "inf"..itemFateString;
			else
				if (valueAmount == -2) then
					valueText = LSW_BOP_STRING;
				else
					valueText = "--"..itemFateString;
				end
			end
		else
			if (valueAmount == -2) then
				valueText = LSW_BOP_STRING;
			else
				valueText = LSW_formatMoney(valueAmount,hilight)..itemFateString;
			end
		end

		buttonValue:SetText(valueText);
		buttonCost:SetText(LSW_formatMoney(costAmount,false).."  ");
					
		if (skillLink and skillName and skillName ~= "") then		
			local _, _, quality, _, itemLevel = GetItemInfo(skillLink);	
			
			if (itemLevel) then
				local r,g,b = GetItemQualityColor(quality);
				if (itemLevel <= UnitLevel("player")) then
					buttonLevel:SetTextColor(r,g,b);
				else
--					buttonLevel:SetTextColor(1,.2,.2);
					buttonLevel:SetTextColor(r*.4, g*.4, b*.4);
				end
				
				if (itemLevel == 0) then
					itemLevel = "1"
				end

				buttonLevel:SetText("["..itemLevel.."]");
				
				if (LSW_Mode ~= "Skillet" and LSW_Mode ~= "Craft") then
					buttonLevel:Show();
				else
					buttonLevel:Hide();
				end
				
				buttonValue:Show();
			else
				buttonLevel:SetText("");
				buttonLevel:Hide();
				
				buttonValue:SetText(" ");
				buttonValue:Show();
			end	
		end
							
		buttonCost:Show();
	else
		buttonValue:Hide();
		buttonCost:Hide();
		buttonLevel:Hide();
	end
end



function LSW_SkillShowTSI(button)
	local name = button:GetName();
	local itemLevel = "?";
	local x;
	local idloc = string.find(name,"%d");
	local id = string.sub(name,idloc) + 1000;
	
	local buttonLevel;
	local buttonCost;
	local buttonValue;
	
 --LSW_ChatMessage("Show Button "..name.." ("..id..")");
		
	buttonValue = getglobal("LSWTradeSkillValue"..id);
	buttonCost = getglobal("LSWTradeSkillCost"..id);
	buttonLevel = getglobal("LSWTradeSkillItemLevel"..id);
	
	if (not buttonValue) then return; end
	
	local skillName;
	local skillLink;
	local skillType;
	local skillID = button:GetID();

	button:SetWidth(LSW_skillWidthTSI);

	local tsiID = skillID+100000;
	
	skillName, skillType = TradeskillInfoUI:GetTradeSkillInfo(skillID);
	
 -- LSW_ChatMessage("skill: "..skillName.." "..skillType.." "..(skillLink or "nil"));

	buttonCost:SetID(tsiID);
	buttonValue:SetID(tsiID);
	buttonLevel:SetID(tsiID);
	
	if (skillName and skillType ~= "header") then						
		skillLink = LSW_GetTradeSkillItemLink(tsiID);
		
		local costAmount, valueAmount, itemFate = LSW_itemValuation(skillName, skillLink, tsiID);
						
		local itemFateString = string.format("|c%s%s|r", LSW_itemFateColor[itemFate], itemFate);
		local hilight = (costAmount < valueAmount);
		local valueText;
					
		
		if (LSW_valueAsPercent) then
			if (costAmount > 0 and valueAmount > 0) then
				local per = valueAmount / costAmount;
				
				per = math.floor(per*1000)/10;
				
				valueText = string.format("%2.1f%%",per);
				
				if (hilight) then
					valueText = "|cffd0d0d0"..valueText..itemFateString;
				else
					valueText = "|cffd02020"..valueText..itemFateString;
				end
				
			elseif (valueAmount > 0) then
				valueText = "inf"..itemFateString;
			else
				if (valueAmount == -2) then
					valueText = LSW_BOP_STRING;
				else
					valueText = "--"..itemFateString;
				end
			end
		else
			if (valueAmount == -2) then
				valueText = LSW_BOP_STRING;
			else
				valueText = LSW_formatMoney(valueAmount,hilight)..itemFateString;
			end
		end

		buttonValue:SetText(valueText);
		buttonCost:SetText(LSW_formatMoney(costAmount,false).."  ");
					
		if (skillLink and skillName and skillName ~= "") then		
			local _, _, quality, _, itemLevel = GetItemInfo(skillLink);	
			
			if (itemLevel) then
				local r,g,b = GetItemQualityColor(quality);
				if (itemLevel <= UnitLevel("player")) then
					buttonLevel:SetTextColor(r,g,b);
				else
--					buttonLevel:SetTextColor(1,.2,.2);
					buttonLevel:SetTextColor(r*.4, g*.4, b*.4);
				end
				
				if (itemLevel > 0) then
					buttonLevel:SetText("["..itemLevel.."]");	
				else
					buttonLevel:SetText("");
				end
				
				buttonLevel:Show();
				buttonValue:Show();
			else
				buttonLevel:SetText("");
				buttonLevel:Hide();
				
				buttonValue:SetText(" ");
				buttonValue:Show();
			end	
		end
							
		buttonCost:Show();
	else
		buttonValue:Hide();
		buttonCost:Hide();
		buttonLevel:Hide();
	end
end


function LSW_SkillHide(button)
	local name = button:GetName();
	local idloc = string.find(name,"%d");
	local id = string.sub(name,idloc);
	
	local buttonLevel;
	local buttonCost;
	local buttonValue;
	
	local namebase = string.sub(name,1,idloc-1);

	if (namebase == "TradeskillInfoSkill") then
		id = id + 1000;
	end
	
	buttonValue = getglobal("LSWTradeSkillValue"..id);
	buttonCost = getglobal("LSWTradeSkillCost"..id);
	buttonLevel = getglobal("LSWTradeSkillItemLevel"..id);
		
	if (buttonCost) then buttonCost:Hide(); end
	if (buttonValue) then buttonValue:Hide(); end
	if (buttonLevel) then buttonLevel:Hide(); end
	
--	LSW_ChatMessage("Hide "..name);
end


function LSW_ItemLevelButton_OnEnter()
	LSW_Tooltip:SetOwner(this, "ANCHOR_NONE");
	LSW_Tooltip:SetPoint("BOTTOMRIGHT", "UIParent", "BOTTOMRIGHT", -CONTAINER_OFFSET_X - 13, CONTAINER_OFFSET_Y);
	LSW_Tooltip:SetText("Required level to use crafted item.");
	LSW_Tooltip:Show();
end

function LSW_ItemLevelButton_OnLeave()
	LSW_Tooltip:Hide();
end



function LSW_CostButton_OnEnter()
-- LSW_ErrorMessage("skill cost enter");
	LSW_Tooltip:SetOwner(this, "ANCHOR_NONE");
	LSW_Tooltip:SetPoint("BOTTOMRIGHT", "UIParent", "BOTTOMRIGHT", -CONTAINER_OFFSET_X - 13, CONTAINER_OFFSET_Y);
	
	if (LSW_priceSanity) then	
		local skillName, skillLink, skillType, skillID = LSW_GetSkillByID(this:GetID());
		
		if (skillName and skillType ~= "header") then
			local _, _, quality = GetItemInfo(skillLink);
			local r, g, b = 1,1,1;
			local vendorSellsItem = false;
				
			if (quality) then
				r,g,b = GetItemQualityColor(quality);
			end
			
			LSW_Tooltip:AddLine(skillName, r,g,b, 1.0);					
			local costAmount, valueAmount, itemFate = LSW_itemValuation(skillName, skillLink, skillID);
			local total = 0;
			
			local numReagents;
	
			numReagents = LSW_GetTradeSkillNumReagents(skillID);
	
			for i=1, numReagents, 1 do
				local reagentName, dummy, reagentCount = LSW_GetTradeSkillReagentInfo(skillID, i);
				local reagentLink = LSW_GetTradeSkillReagentItemLink(skillID, i);
		
				local sellAtAuction;
				local buyFromVendor;
				local ahDataMissing;
		
				local reagentValue;
				local reagentSource="a";
				
				local reagentSubTotal;
				
				
				_, _, quality = GetItemInfo(reagentLink);
				if (quality) then
					r, g, b = GetItemQualityColor(quality);
				else
					r = 1
					g = 1
					b = 1
				end
				
				sellAtAuction, ahDataMissing = LSW_itemPrice(reagentLink, LSW_MININUM_REAGENT_AUCTIONS);

				buyFromVendor = LSW_itemPriceVendor(reagentLink);

     		    if LSW_periodicTableLib then
         		   vendorSellsItem = LSW_periodicTableLib:ItemInSet(reagentLink,"Tradeskill.Mat.BySource.Vendor")
        		end
				
-- calculate the cost of reagents.  if ah data exists, use it.  if no ah data exists then use the buy from vendor price
				if (vendorSellsItem) then
					reagentValue = buyFromVendor;
					reagentSource = "v"
				else
					if (ahDataMissing or sellAtAuction < 0) then
						if (buyFromVendor > 0) then
							reagentValue = buyFromVendor;
							reagentSource = "v";
						else
							if (LSW_bopCheck(reagentLink)) then
								reagentValue = "";
								reagentSource = LSW_BOP_STRING;
							else
								reagentValue = ""
								reagentSource = "?";
							end
						end
					else
						reagentValue = sellAtAuction;
					end
				end
				
				if (type(reagentValue) == "number") then
					reagentSubTotal = reagentValue * reagentCount;
					LSW_Tooltip:AddDoubleLine(reagentName.." x "..reagentCount, LSW_formatMoney(reagentSubTotal, true)..reagentSource, r, g, b);
				else
					reagentSubTotal = 0;
					LSW_Tooltip:AddDoubleLine(reagentName.." x "..reagentCount, reagentSource, r, g, b);
				end
			
				
				total = total + reagentSubTotal;
			end
			
			LSW_Tooltip:AddDoubleLine("Total estimated cost: ", LSW_formatMoney(total,true).."  ");
		end
	else
		LSW_Tooltip:SetText("Estimated cost to use skill.");
	end
	
	LSW_Tooltip:Show();
end

function LSW_CostButton_OnLeave()
	LSW_Tooltip:Hide();
end


-- click on the value and toggle the BEST/AUCTION/VENDOR/DE price consideration

function LSW_ValueButton_OnClick(button)

	if (this:GetText() == " ") then return end
	
	local needsUpdate = false;
	
	if(button=="LeftButton") then
		LSW_globalFate = LSW_globalFate + 1;
		
		if (LSW_globalFate > LSW_globalFateMax or (LSW_globalFate == 3 and (LSW_Mode == "Craft" or (LSW_Mode == "Skillet" and Skillet:IsCraft())))) then
			LSW_globalFate = 0;
		end
		
		needsUpdate = true;
	elseif (button=="RightButton") then
		LSW_valueAsPercent = not LSW_valueAsPercent;
		
		needsUpdate = true;
	end
	
	if (needsUpdate) then	
		LSW_ValueButton_OnEnter()
		
		if (LSW_Mode == "Skillet") then
			Skillet:ResortRecipes(true);
			LSW_UpdateWindowSkillet(Skillet);
		elseif (LSW_Mode == "ATSW") then
			ATSWFrame_Update();
		elseif (LSW_Mode == "Craft") then
			LSW_UpdateWindowCraft();
		else
			LSW_UpdateWindowStandard();
		end
	end
end

function LSW_ValueButton_OnEnter()
	if (this:GetText() == " ") then return end
	
	LSW_Tooltip:SetOwner(this, "ANCHOR_NONE");
	LSW_Tooltip:SetPoint("BOTTOMRIGHT", "UIParent", "BOTTOMRIGHT", -CONTAINER_OFFSET_X - 13, CONTAINER_OFFSET_Y);
	
	local skillName, skillLink, skillType, skillID = LSW_GetSkillByID(this:GetID());
	
	if (skillName and skillType ~= "header") then
		local numMade;
		
		if (skillName ~= "Small Prismatic Shard") then
			local min,max = GetTradeSkillNumMade(skillID);
			numMade = (min + max)/2;
		else
			numMade = 3;
		end
		
		local madeText = skillName;
		local _, _, quality = GetItemInfo(skillLink);
		local r, g, b = 1,1,1;
			
		if (quality) then
			r,g,b = GetItemQualityColor(quality);
		end

		if (numMade > 1) then
			madeText = skillName.." (x"..numMade..")";
		end
	
		local itemFate = LSW_skillPriceCache[skillName].itemFate;
		local auctionValue = LSW_formatMoney(LSW_skillPriceCache[skillName].valueAmount[1],(itemFate=="a"));
		local vendorValue = LSW_formatMoney(LSW_skillPriceCache[skillName].valueAmount[2],(itemFate=="v"));
		local disenchantValue = LSW_formatMoney(LSW_skillPriceCache[skillName].valueAmount[3],(itemFate=="d"));
		
		if (LSW_skillPriceCache[skillName].valueAmount[1] == -2) then
			auctionValue = LSW_BOP_STRING;
		end
		
		
		LSW_Tooltip:SetText(madeText,r,g,b);
--		LSW_Tooltip:AddDoubleLine("Item Fate:", "|c"..LSW_itemFateColor[itemFate]..LSW_fateString[itemFate],1,1,1);

		LSW_Tooltip:AddDoubleLine("|cff909040Auction: ",auctionValue);
		LSW_Tooltip:AddDoubleLine("|cff206080Vendor: ",vendorValue);
		
		if (Enchantrix) then
			LSW_Tooltip:AddDoubleLine("|cff008000Disenchant: ",disenchantValue);
		end
		
		local cycleString;
		
		if (LSW_globalFate == 0) then
			cycleString = "[Best Value Shown]"
		else
			cycleString = "["..LSW_fateString[LSW_itemFateList[LSW_globalFate]].." Value Shown]";
		end
		
		LSW_Tooltip:AddLine(cycleString,1,1,1);
		
		LSW_Tooltip:Show();
	end
end

function LSW_ValueButton_OnLeave()
	LSW_Tooltip:Hide();
end


function LSW_ShowWindowATSW()	
	LSW_globalSync = LSW_globalSync + 1;
	LSW_Mode = "ATSW";
	
	ATSW_ShowWindow_ORIGINAL();
	
	local scrollFrame = ATSWListScrollFrame;
	
	if (ATSWListScrollFrame:IsVisible()) then
		LSW_skillWidth = LSW_skillWidthNarrow;
	else
		LSW_skillWidth = LSW_skillWidthWide;
	end
		
	local ATSW_title = ATSWFrameTitleText:GetText();
	ATSWFrameTitleText:SetText(ATSW_title.." (w/ "..LSW_VERSION..")");
	ATSWFrame_Update();
end


function LSW_ShowWindowTSI()	
	LSW_globalSync = LSW_globalSync + 1;
	
	TradeskillInfoUI_Frame_Show_ORIGINAL(TradeskillInfoUI);
	
	local scrollFrame = getglobal("TradeskillInfoListScrollFrame");
	
	if (scrollFrame:IsVisible()) then
		LSW_skillWidthTSI = 223;
	else
		LSW_skillWidthTSI = 243;
	end
		
--	local ATSW_title = ATSWFrameTitleText:GetText();
--	ATSWFrameTitleText:SetText(ATSW_title.." (w/ "..LSW_VERSION..")");
--	ATSWFrame_Update();
end


function LSW_SkilletBeforeRecipeButtonShow(button, tradeskill, skill_index, list_offset)
	LSW_SkillShow(button);
	return button;
end

function LSW_SkilletBeforeRecipeButtonHide(button, tradeskill, skill_index, list_offset)
	LSW_SkillHide(button);
	return button;
end


function LSW_ShowWindowSkillet(obj)	
	LSW_globalSync = LSW_globalSync + 1;
	LSW_Mode = "Skillet";
	
	SkilletFrame_Show_ORIGINAL(obj);
end


function LSW_ShowWindowStandard()
	LSW_globalSync = LSW_globalSync + 1;
	LSW_Mode = "TradeSkill";
		
	TradeSkillFrame_Show_ORIGINAL();

	if (TradeSkillListScrollFrame:IsVisible()) then
		LSW_skillWidth = LSW_skillWidthNarrow;
	else
		LSW_skillWidth = LSW_skillWidthWide;
	end
	
	TradeSkillFrame_Update();	
end


function LSW_UpdateWindowSkillet(obj)
	LSW_Mode = "Skillet";
	
	local width = SkilletSkillListParent:GetWidth()-30;
	
	if (SkilletSkillList:IsVisible()) then
		LSW_skillWidth = width-20 - 60;
	else
		LSW_skillWidth = width - 60;
	end

	SkilletFrame_Update_ORIGINAL(obj);
	
	local title = getglobal("SkilletTitleText");
	
    if (title and Skillet.currentTrade) then
    	title:SetText("Skillet Trade Skills"..": "..Skillet.currentTrade.." ("..LSW_VERSION..")")
    end
end


function LSW_UpdateWindowTSI()
	for i=1, TradeskillInfoUI.cons.skillsDisplayed, 1 do
		local tradeSkillButton = getglobal("TradeskillInfoSkill"..i);
		tradeSkillButton:Hide();
	end
	
	TradeskillInfoUI_Frame_Update_ORIGINAL(TradeskillInfoUI);
	
--	local name = GetTradeSkillLine()
--	TradeSkillFrameTitleText:SetText(name.." ("..LSW_VERSION..")");
end


function LSW_UpdateWindowStandard()
	LSW_Mode = "TradeSkill";

	for i=1, LSW_TRADESKILL_INDEX_MAX, 1 do
		local tradeSkillButton = getglobal("TradeSkillSkill"..i);
		tradeSkillButton:Hide();
		getglobal("LSWTradeSkillValue"..i):Hide();
		getglobal("LSWTradeSkillCost"..i):Hide();
		getglobal("LSWTradeSkillItemLevel"..i):Hide();
	end
	TradeSkillFrame_Update_ORIGINAL()
	local name = GetTradeSkillLine()
	TradeSkillFrameTitleText:SetText(name.." ("..LSW_VERSION..")");
end


function LSW_ShowWindowCraft()
	
	if (GetCraftName() ~= "Enchanting") then
		for i=1, LSW_CRAFT_INDEX_MAX, 1 do
			local craftButton = getglobal("Craft"..i);
			craftButton:SetTextFontObject("GameFontNormal");
			craftButton:SetHighlightFontObject("GameFontHighlight");
			craftButton:SetDisabledFontObject("GameFontDisable");
		end
		
		CraftFrame_Show_ORIGINAL();
--		CraftFrame_Update();
		return;
	else
		for i=1, LSW_CRAFT_INDEX_MAX, 1 do
			local craftButton = getglobal("Craft"..i);
			craftButton:SetTextFontObject("GameFontNormalSmall");
			craftButton:SetHighlightFontObject("GameFontHighlightSmall");
			craftButton:SetDisabledFontObject("GameFontDisableSmall");
		end

	end

	LSW_globalSync = LSW_globalSync + 1;
	LSW_Mode = "Craft";
	
	CraftFrame_Show_ORIGINAL();

	if (CraftListScrollFrame:IsVisible()) then
		LSW_skillWidth = LSW_skillWidthNarrow;
	else
		LSW_skillWidth = LSW_skillWidthWide;
	end
	CraftFrame_Update();
end


function LSW_UpdateWindowCraft()
	if (CraftIsPetTraining()) then
		CraftFrame_Update_ORIGINAL();
		return;
	end
	
	LSW_Mode = "Craft";

	for i=1, LSW_CRAFT_INDEX_MAX, 1 do
		local craftButton = getglobal("Craft"..i);
		craftButton:Hide();
		getglobal("LSWCraftValue"..i):Hide();
		getglobal("LSWCraftCost"..i):Hide();
		getglobal("LSWCraftItemLevel"..i):Hide();
	end
	CraftFrame_Update_ORIGINAL()
	CraftFrameTitleText:SetText(GetCraftName().." ("..LSW_VERSION..")");
end


function LSW_CreateDynamicButtons(id, buttonName, ParentFrame)

--LSW_ErrorMessage("creating button "..id);

	local buttonValue = CreateFrame("Button", "LSWTradeSkillValue"..id, ParentFrame, "LSWTradeSkillValueButtonTemplate");
	buttonValue:SetPoint("TOPLEFT",buttonName,"TOPRIGHT",5,0);
	buttonValue:SetText("00 00");
	buttonValue:Hide();

	if (LSW_Mode == "Skillet") then
		buttonValue:SetWidth(40);
	else
		buttonValue:SetWidth(30);
	end
	
	
	local buttonCost = CreateFrame("Button", "LSWTradeSkillCost"..id, ParentFrame, "LSWTradeSkillCostButtonTemplate");
	buttonCost:SetPoint("TOPLEFT","LSWTradeSkillValue"..id,"TOPRIGHT",15,0);
	buttonCost:SetText("00 00");
	buttonCost:SetWidth(30);
	buttonCost:Hide();
	

	local buttonLevel = CreateFrame("Button", "LSWTradeSkillItemLevel"..id, ParentFrame, "LSWTradeSkillItemLevelTemplate");
	buttonLevel:SetPoint("TOPLEFT",buttonName,"TOPLEFT",5,0);
	buttonLevel:SetText("");
	buttonLevel:Hide();
	
	return buttonValue, buttonCost, buttonLevel;
end


function LSW_ButtonInitTradeskillInfoUI(i)
	local tsiButton = getglobal("TradeskillInfoSkill"..i);
	
	tsiButton:SetScript("OnShow", LSW_SkillShowTSI); -- sadly, i'm reduced to parallel show/hide functions for tsi
	tsiButton:SetScript("OnHide", LSW_SkillHide);
	tsiButton:SetTextFontObject("GameFontNormalSmall");
	tsiButton:SetHighlightFontObject("GameFontHighlightSmall");
	tsiButton:SetDisabledFontObject("GameFontDisableSmall");
	
	LSW_CreateDynamicButtons(i+1000, "TradeskillInfoSkill"..i, TradeskillInfoListFrame); -- 1000+id = hack to make sure tsi buttons don't interfere with skillet/atsw/blizz buttons
end


function LSW_ButtonInitATSW(i)
	local atswButton = getglobal("ATSWSkill"..i);
	atswButton:SetScript("OnShow", LSW_SkillShow);
	atswButton:SetScript("OnHide", LSW_SkillHide);	
	atswButton:SetTextFontObject("GameFontNormalSmall");
	atswButton:SetHighlightFontObject("GameFontHighlightSmall");
	atswButton:SetDisabledFontObject("GameFontDisableSmall");
	
	LSW_CreateDynamicButtons(i, "ATSWSkill"..i, ATSWFrame);
end


function LSW_ButtonInitStandard(i)
	local tradeSkillButton = getglobal("TradeSkillSkill"..i);
	tradeSkillButton:SetScript("OnShow", LSW_SkillShow);
	tradeSkillButton:SetScript("OnHide", LSW_SkillHide);	
	tradeSkillButton:SetTextFontObject("GameFontNormalSmall");
	tradeSkillButton:SetHighlightFontObject("GameFontHighlightSmall");
	tradeSkillButton:SetDisabledFontObject("GameFontDisableSmall");
	tradeSkillButton:SetWidth(LSW_skillWidth);
	
	LSW_CreateDynamicButtons(i, "TradeSkillSkill"..i, TradeSkillFrame);
	
	local craftButton = getglobal("Craft"..i);
	craftButton:SetScript("OnShow", LSW_SkillShow);
	craftButton:SetScript("OnHide", LSW_SkillHide);	
	craftButton:SetTextFontObject("GameFontNormalSmall");
	craftButton:SetHighlightFontObject("GameFontHighlightSmall");
	craftButton:SetDisabledFontObject("GameFontDisableSmall");
	craftButton:SetWidth(LSW_skillWidth);
	
	local buttonValue = getglobal("LSWCraftValue"..i);
	buttonValue:SetParent("CraftFrame");
	buttonValue:SetPoint("TOPLEFT","Craft"..i,"TOPRIGHT",5,0);
	buttonValue:SetText("00 00");
	buttonValue:SetWidth(30);
	buttonValue:Hide();
	
	
	local buttonCost = getglobal("LSWCraftCost"..i);
	buttonCost:SetParent("CraftFrame");
	buttonCost:SetPoint("TOPLEFT","LSWCraftValue"..i,"TOPRIGHT",15,0);
	buttonCost:SetText("00 00");
	buttonCost:SetWidth(30);
	buttonCost:Hide();
	
	local buttonLevel = getglobal("LSWCraftItemLevel"..i);
	buttonLevel:SetParent("CraftFrame");
	buttonLevel:SetPoint("TOPLEFT","Craft"..i,"TOPLEFT",0,0);
	buttonLevel:SetText("");

end


function LSW_OnLoad()
	LSW_initialized = LSW_InitializeFrames();
--	LSW_InitializePricing();
end


function LSW_OnLoad_NO()
	if (IsAddOnLoaded("AdvancedTradeSkillWindow")) then
		LSW_Initialize();
		LSW_initialized = true;
	end
	
	this:RegisterEvent("TRADE_SKILL_SHOW");
	this:RegisterEvent("CRAFT_SHOW");
end


function LSW_OnEvent(event)
	if (LSW_initialized == false) then
		if (event == "CRAFT_SHOW" or event == "TRADE_SKILL_SHOW") then
			LSW_initialized = LSW_Initialize();
		end
	end
end




function LSW_InitializePricing()
	LoadAddOn("Auctioneer");  -- demands Auctioneer load (too hacky?)
--	LoadAddOn("Informant");
--	LoadAddOn("ItemPriceTooltip");
--	LoadAddOn("SellFish");
--	LoadAddOn("Valuation");
--	LoadAddOn("ItemDataCache");


	if (GetSellValue) then
		LSW_itemPriceVendor = LSW_itemPriceVendorGetSellValue;	
	end
	
	if (AucAdvanced and AucAdvanced.Version) then
		LSW_AuctioneerHook = "aucadv"
		
		if (Auctioneer and Auctioneer.Version) then
			LSW_ChatMessage("LilSparky's Workshop has found Auctioneer (v"..Auctioneer.Version..") and AucAdvanced (v"..AucAdvanced.Version..")");		
			LSW_itemPrice = LSW_itemPriceAuctioneerBoth;
		else
			LSW_ChatMessage("LilSparky's Workshop has found AucAdvanced (v"..AucAdvanced.Version..")");		
			LSW_itemPrice = LSW_itemPriceAucAdvanced;
		end
		
		if (Informant) then
			LSW_ChatMessage("LilSparky's Workshop has found Informant");
			LSW_itemPriceVendor = LSW_itemPriceVendorInformant;
		end
		
	elseif (Auctioneer) then
		LSW_ChatMessage("LilSparky's Workshop has found Auctioneer (v"..Auctioneer.Version..")");		

		LSW_AuctioneerHook = "auctioneer"
		LSW_itemPrice = LSW_itemPriceAuctioneer;

		if (Informant) then
			LSW_ChatMessage("LilSparky's Workshop has found Informant");
			LSW_itemPriceVendor = LSW_itemPriceVendorInformant;
		end
	elseif (AuctionSpy and KC_Items) then
		LSW_ChatMessage("LilSparky's Workshop has found KC_Items/AuctionSpy.");	
		
		LSW_itemPrice = LSW_itemPriceKCItems;
		
		if (KC_Items:HasModule("SellValues")) then
			SellValues = KC_Items:GetModule("SellValues");
		
			LSW_ChatMessage("LilSparky's Workshop has found KC_Items/SellValues.");
			LSW_itemPriceVendor = LSW_itemPriceVendorKCItems;
		end
	else
		LSW_ErrorMessage("ERROR: LilSparky's Workshop requires either Auctioneer/AucAdvanced or KC_Items/AuctionSpy to function properly.");
		return false;
	end

	
	if (LSW_itemPriceVendor == nil) then
		LSW_ErrorMessage("ERROR: LilSparky's Workshop cannot find a suitable vendor pricing system.");
		return false;
	elseif (LSW_itemPriceVendor == LSW_itemPriceVendorGetSellValue) then
		LSW_ChatMessage("WARNING: LilSparky's Workshop using vendor pricing plugin that doesn't provide 'buy from vendor' prices.");
	end
	
	
	if (Enchantrix) then
		LSW_globalFateMax = 3
	else
		LSW_ChatMessage("WARNING: LilSparky's Workshop needs Enchantrix to calculate disenchant values.");
		LSW_globalFateMax = 2
	end

	return true;
end	



function LSW_InitializeFrames()
	LSW_ChatMessage(LSW_VERSION_LONG);
	
	if (TradeskillInfoUI and TradeskillInfoUI.version) then
		LSW_ChatMessage("LilSparky's Workshop plugging into TradeskillInfoUI (v"..TradeskillInfoUI.version..")");
		
		TradeskillInfoUI_Frame_Update_ORIGINAL = TradeskillInfoUI.Frame_Update;
		TradeskillInfoUI.Frame_Update = LSW_UpdateWindowTSI;
		
		TradeskillInfoUI_Frame_Show_ORIGINAL = TradeskillInfoUI.Frame_Show;
		TradeskillInfoUI.Frame_Show = LSW_ShowWindowTSI;
		
		LSW_skillWidthTSI = 223;
		
		for i=1, TradeskillInfoUI.cons.skillsDisplayed, 1 do
			LSW_ButtonInitTradeskillInfoUI(i);
		end
	end
	
	if (Skillet and Skillet.version) then
		LSW_Mode = "Skillet"
		
		LSW_ChatMessage("LilSparky's Workshop plugging into Skillet (v"..Skillet.version..")");

		if (Skillet.ShowTradeSkillWindow) then
			SkilletFrame_Show_ORIGINAL = Skillet.ShowTradeSkillWindow;
			Skillet.ShowTradeSkillWindow = LSW_ShowWindowSkillet;
				
			SkilletFrame_Update_ORIGINAL = Skillet.UpdateTradeSkillWindow;
			Skillet.UpdateTradeSkillWindow = LSW_UpdateWindowSkillet;
			
			
			Skillet:AddPreButtonShowCallback(LSW_SkilletBeforeRecipeButtonShow)
			Skillet:AddPreButtonHideCallback(LSW_SkilletBeforeRecipeButtonHide)
		else
			LSW_ChatMessage("ERROR: unable to hook into Skillet Show/Update functions.");
			
			return false;
		end
		
		Skillet:AddRecipeSorter("LSW: Item Value", LSW_SortCompareItemValue)
		Skillet:AddRecipeSorter("LSW: Reagent Cost", LSW_SortCompareReagentCost)
		Skillet:AddRecipeSorter("LSW: Profit", LSW_SortCompareProfit)
		
		LSW_TRADESKILL_INDEX_MAX = 1;				
	elseif (ATSW_ShowWindow) then
		LSW_Mode = "ATSW"
		
		ATSW_ShowWindow_ORIGINAL = ATSW_ShowWindow;
		ATSW_ShowWindow = LSW_ShowWindowATSW;
			
		LSW_ChatMessage("LilSparky's Workshop plugging into AdvancedTradeSkillWindow.");
		
		LSW_TRADESKILL_INDEX_MAX = ATSW_TRADE_SKILLS_DISPLAYED;
		
		LSW_skillWidthNarrow = 223;
		LSW_skillWidthWide = 243;
		
		LSW_skillWidth = LSW_skillWidthNarrow;

		for i=1, LSW_TRADESKILL_INDEX_MAX, 1 do
			LSW_ButtonInitATSW(i);
		end
	else
		LSW_ChatMessage("LilSparky's Workshop plugging into standard Tradeskill/Crafting frames.");

	-- more forced loading, but since i'm pluggin right into the system, i kind of need to
		if (not IsAddOnLoaded("Blizzard_TradeSkillUI")) then
			LoadAddOn("Blizzard_TradeSkillUI");
		end
		
		if (not IsAddOnLoaded("Blizzard_CraftUI")) then
			LoadAddOn("Blizzard_CraftUI");
		end
		
		
		TradeSkillFrame_Show_ORIGINAL = TradeSkillFrame_Show;
		TradeSkillFrame_Show = LSW_ShowWindowStandard;
				
		TradeSkillFrame_Update_ORIGINAL = TradeSkillFrame_Update;
		TradeSkillFrame_Update = LSW_UpdateWindowStandard;
		
		
		CraftFrame_Show_ORIGINAL = CraftFrame_Show;
		CraftFrame_Show = LSW_ShowWindowCraft;
		
		CraftFrame_Update_ORIGINAL = CraftFrame_Update;
		CraftFrame_Update = LSW_UpdateWindowCraft;

		
		LSW_TRADESKILL_INDEX_MAX = TRADE_SKILLS_DISPLAYED;
		LSW_CRAFT_INDEX_MAX = CRAFTS_DISPLAYED;
		
		LSW_skillWidthNarrow = 223;
		LSW_skillWidthWide = 243;
		
		LSW_skillWidth = LSW_skillWidthNarrow;
		
		for i=1, LSW_TRADESKILL_INDEX_MAX, 1 do
			LSW_ButtonInitStandard(i);
		end
	end
	
	LSW_Tooltip = CreateFrame("GameTooltip", "LSW_Tooltip", getglobal("ANCHOR_NONE"), "GameTooltipTemplate");
	LSW_Tooltip:SetScale(0.8);
	return true;
end






