﻿
function Lifebloomer_OnLoad()
	SlashCmdList["LIFEBLOOMER"] = Lifebloomer_SlashCommand;
	SLASH_LIFEBLOOMER1 = "/Lifebloomer";
	SLASH_LIFEBLOOMER2 = "/lifebloomer";
	SLASH_LIFEBLOOMER3 = "/LB";
	SLASH_LIFEBLOOMER4 = "/Lb";
	SLASH_LIFEBLOOMER5 = "/lb";
	LBVplayername, LBVrealm = UnitName("player");
	loc, LBVClass = UnitClass("player");
	LBVLevel = UnitLevel("player");
	LBVersion = "1.5.2";
	
	if LBVClass == "DRUID" then
		LB_GCD = true;
	else
		LB_GCD = false;
	end
	
	if LBSaved then
		if not LBSaved.Bind then
			LBSaved.Bind = nil;
		end
		if not LBSaved.DTPS then
			LBSaved.DTPS = 1;
			LBSaved.Bind = nil;
		end
		if LBSaved.FTar == nil then
			LBSaved.FTar = true;
			LBSaved.LStat = true;
		end
	else
		LBSaved = {};
		LBSaved.DTPS = 2;
		LBSaved.Bind = nil;
		if LBVClass == "DRUID" and LBVLevel > 64 then
			LBSaved.Vis = 1;
		else LBSaved.Vis = nil;
		end
		LBSaved.FTar = true;
		LBSaved.LStat = true;
		LBSaved[1] = {};
		LBSaved[1][1] = {};
		LBSaved[1][1].N = "";
		LBSaved[1][1].T = "target";
		LBSaved[1][1].S = "Target";
		LBSaved[1][2] = {};
		LBSaved[1][2].N = "shift-";
		LBSaved[1][2].T = "target";
		LBSaved[1][2].S = "Target";
		LBSaved[1][3] = {};
		LBSaved[1][3].N = "ctrl-";
		LBSaved[1][3].T = "target";
		LBSaved[1][3].S = "Target";
		LBSaved[1][4] = {};
		LBSaved[1][4].N = "alt-";
		LBSaved[1][4].T = "target";
		LBSaved[1][4].S = "Target";
		LBSaved[2] = {};
		LBSaved[2][1] = {};
		LBSaved[2][1].N = "";
		LBSaved[2][1].T = "target";
		LBSaved[2][1].S = "Target";
		LBSaved[2][2] = {};
		LBSaved[2][2].N = "shift-";
		LBSaved[2][2].T = "target";
		LBSaved[2][2].S = "Target";
		LBSaved[2][3] = {};
		LBSaved[2][3].N = "ctrl-";
		LBSaved[2][3].T = "target";
		LBSaved[2][3].S = "Target";
		LBSaved[2][4] = {};
		LBSaved[2][4].N = "alt-";
		LBSaved[2][4].T = "target";
		LBSaved[2][4].S = "Target";
	end
	if LBSaved.Vis then
		LifebloomerMainFrame:Show();
	end
	if LBColors then
		local i = 1;
		LifebloomerMainFrameUnitFrame1:SetBackdropColor(LBColors[i].R, LBColors[i].G, LBColors[i].B, LBColors[i].A);
		local i = 2;
		LifebloomerMainFrameUnitFrame1HPBar:SetStatusBarColor(LBColors[i].R, LBColors[i].G, LBColors[i].B, LBColors[i].A);
		local i = 3;
		LifebloomerMainFrameUnitFrame1LBBar:SetStatusBarColor(LBColors[i].R, LBColors[i].G, LBColors[i].B, LBColors[i].A);
		local i = 4;
		LifebloomerMainFrameUnitFrame1RejuvBar:SetStatusBarColor(LBColors[i].R, LBColors[i].G, LBColors[i].B, LBColors[i].A);
		local i = 5;
		LifebloomerMainFrameUnitFrame1RegroBar:SetStatusBarColor(LBColors[i].R, LBColors[i].G, LBColors[i].B, LBColors[i].A);
		if LBColors[14] then
			local i = 14;
			LifebloomerMainFrameUnitFrame1LBBarNumber:SetTextColor(LBColors[i].R, LBColors[i].G, LBColors[i].B, LBColors[i].A);
			local i = 15;
			LifebloomerMainFrameUnitFrame1LBBarTimer:SetTextColor(LBColors[i].R, LBColors[i].G, LBColors[i].B, LBColors[i].A);
		else
		--Boarder
			LBColors[6] = {};
			LBColors[6].R = 1;
			LBColors[6].G = 1;
			LBColors[6].B = 1;
			LBColors[6].A = 1;
		--Cursed
			LBColors[7] = {};
			LBColors[7].R = 1;
			LBColors[7].G = 0;
			LBColors[7].B = 1;
			LBColors[7].A = 1;
		--Poisoned
			LBColors[8] = {};
			LBColors[8].R = 0;
			LBColors[8].G = 1;
			LBColors[8].B = 0;
			LBColors[8].A = 1;
		--Curse + Poison
			LBColors[9] = {};
			LBColors[9].R = 1;
			LBColors[9].G = 0;
			LBColors[9].B = 0;
			LBColors[9].A = 1;
		--In Range
			LBColors[10] = {};
			LBColors[10].R = 0;
			LBColors[10].G = 0.1;
			LBColors[10].B = 0;
			LBColors[10].A = 0.5;
		--Out of Range
			LBColors[11] = {};
			LBColors[11].R = 0.5;
			LBColors[11].G = 0;
			LBColors[11].B = 0;
			LBColors[11].A = 1;
		--Has Agro
			LBColors[12] = {};
			LBColors[12].R = 1;
			LBColors[12].G = 1;
			LBColors[12].B = 0;
			LBColors[12].A = 1;
		--No Agro
			LBColors[13] = {};
			LBColors[13].R = 0;
			LBColors[13].G = 1;
			LBColors[13].B = 1;
			LBColors[13].A = 1;
		--LB Count
			LBColors[14] = {};
			LBColors[14].R = 1;
			LBColors[14].G = 1;
			LBColors[14].B = 1;
			LBColors[14].A = 1;
		--LB Timer
			LBColors[15] = {};
			LBColors[15].R = 1;
			LBColors[15].G = 1;
			LBColors[15].B = 1;
			LBColors[15].A = 1;
		end
	else
		LBColors = {};
	--Background
		LBColors[1] = {};
		LBColors[1].R = 1;
		LBColors[1].G = 1;
		LBColors[1].B = 1;
		LBColors[1].A = .25;
	--Health
		LBColors[2] = {};
		LBColors[2].R = 0;
		LBColors[2].G = .8;
		LBColors[2].B = 0;
		LBColors[2].A = 1;
	--Lifebloom
		LBColors[3] = {};
		LBColors[3].R = 0;
		LBColors[3].G = .2;
		LBColors[3].B = .5;
		LBColors[3].A = .8;
	--Rejuv
		LBColors[4] = {};
		LBColors[4].R = .5;
		LBColors[4].G = 0;
		LBColors[4].B = .5;
		LBColors[4].A = 1;
	--Regrowth
		LBColors[5] = {};
		LBColors[5].R = 0;
		LBColors[5].G = 1;
		LBColors[5].B = 0;
		LBColors[5].A = 1;
	--Boarder ******************************************************************
		LBColors[6] = {};
		LBColors[6].R = 1;
		LBColors[6].G = 1;
		LBColors[6].B = 1;
		LBColors[6].A = 1;
	--Cursed
		LBColors[7] = {};
		LBColors[7].R = 1;
		LBColors[7].G = 0;
		LBColors[7].B = 1;
		LBColors[7].A = 1;
	--Poisoned
		LBColors[8] = {};
		LBColors[8].R = 0;
		LBColors[8].G = 1;
		LBColors[8].B = 0;
		LBColors[8].A = 1;
	--Curse + Poison
		LBColors[9] = {};
		LBColors[9].R = 1;
		LBColors[9].G = 0;
		LBColors[9].B = 0;
		LBColors[9].A = 1;
	--In Range
		LBColors[10] = {};
		LBColors[10].R = 0;
		LBColors[10].G = 0.1;
		LBColors[10].B = 0;
		LBColors[10].A = 0.5;
	--Out of Range
		LBColors[11] = {};
		LBColors[11].R = 0.5;
		LBColors[11].G = 0;
		LBColors[11].B = 0;
		LBColors[11].A = 1;
	--Has Agro
		LBColors[12] = {};
		LBColors[12].R = 1;
		LBColors[12].G = 1;
		LBColors[12].B = 0;
		LBColors[12].A = 1;
	--No Agro
		LBColors[13] = {};
		LBColors[13].R = 0;
		LBColors[13].G = 1;
		LBColors[13].B = 1;
		LBColors[13].A = 1;
	--LB Count
		LBColors[14] = {};
		LBColors[14].R = 1;
		LBColors[14].G = 1;
		LBColors[14].B = 1;
		LBColors[14].A = 1;
	--LB Timer
		LBColors[15] = {};
		LBColors[15].R = 1;
		LBColors[15].G = 1;
		LBColors[15].B = 1;
		LBColors[15].A = 1;
	end
	
	if LBDim then
		if LBDim.rej then
		else
			LBDim.rej = 2;
			LBDim.reg = 2;
		end
	else
		LBDim = {};
		LBDim.h = 40;
		LBDim.w = 180;
		LBDim.s = 0;
		LBDim.rej = 2;
		LBDim.reg = 2;
	end
	
	LB_Buffer = {};
	LB_Buffer.Debuff = 0;		-- 0: none, 1: curse, 2: poison, 3: both
	LB_Buffer.Range = 1;		-- 0: out, 1: in
	LB_Buffer.Agro = 0;			-- 0: no, 1: yes
	LB_Buffer.LBBind = {};
	LB_Buffer.LBColors = {};
	LB_Buffer.LBDim = {};
	
	LB_Buffer.LBColors = Lifebloomer_deepcopy(LBColors);
	LB_Buffer.LBDim = Lifebloomer_deepcopy(LBDim);
	
	LifebloomerOptionsBindingsComboBox1Text:SetText(LBSaved[1][1].S);
	LifebloomerOptionsBindingsComboBox2Text:SetText(LBSaved[1][2].S);
	LifebloomerOptionsBindingsComboBox3Text:SetText(LBSaved[1][3].S);
	LifebloomerOptionsBindingsComboBox4Text:SetText(LBSaved[1][4].S);
	LifebloomerOptionsBindingsComboBox5Text:SetText(LBSaved[2][1].S);
	LifebloomerOptionsBindingsComboBox6Text:SetText(LBSaved[2][2].S);
	LifebloomerOptionsBindingsComboBox7Text:SetText(LBSaved[2][3].S);
	LifebloomerOptionsBindingsComboBox8Text:SetText(LBSaved[2][4].S);
	
	LifebloomerMainFrameUnitFrame1.Number = LifebloomerMainFrameUnitFrame1LBBarNumber;
	LifebloomerMainFrameUnitFrame1.Timer = LifebloomerMainFrameUnitFrame1LBBarTimer;
	LifebloomerMainFrameUnitFrame1.LBBar = LifebloomerMainFrameUnitFrame1LBBar;
	LifebloomerMainFrameUnitFrame1.LBBarGCD = LifebloomerMainFrameUnitFrame1LBBarGCD;
	LifebloomerMainFrameUnitFrame1.RejuvBar = LifebloomerMainFrameUnitFrame1RejuvBar;
	LifebloomerMainFrameUnitFrame1.RegroBar = LifebloomerMainFrameUnitFrame1RegroBar;
	LifebloomerMainFrameUnitFrame1.HPBar = LifebloomerMainFrameUnitFrame1HPBar;
	LifebloomerMainFrameUnitFrame1.Name = LifebloomerMainFrameUnitFrame1HPBarName;
	LifebloomerMainFrameUnitFrame1.DTPSlabel = LifebloomerMainFrameUnitFrame1HPBarDTPS;
	LifebloomerMainFrameUnitFrame1.DTPS = 0;
	LifebloomerMainFrameUnitFrame1.Damage = 0;
	LifebloomerMainFrameUnitFrame1.TimeCount = 0;
	LifebloomerMainFrameUnitFrame1.Dmg = {0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0};
	
	ClickCastFrames = ClickCastFrames or {};
	ClickCastFrames[LifebloomerMainFrameUnitFrame1] = true;
	Lifebloomer_SetAttributes(LifebloomerMainFrameUnitFrame1);
	
	LBVFF = 0;
	if LBV and LBSaved.FTar then
		LBV_t = Lifebloomer_deepcopy(LBV);
		LBV = {};
		LBV[1] = {};
		LBV[1].Unitid = "target";
		LBV[1].Name = "target";
		LBV[1].Target2 = "targettargettarget";
		n = getn(LBV_t);
		if n>1 then
			for i = 2, n, 1 do
				Lifebloomer_AddFrame(getglobal("LifebloomerMainFrameUnitFrame"..(i-1)));
			end
		elseif n==0 then
			LBV = {};
			LBV[1] = {};
			LBV[1].Unitid = "target";
			LBV[1].Name = "target";
			LBV[1].Target2 = "targettargettarget";
			Lifebloomer_RemoveFrame(LifebloomerMainFrameUnitFrame1);
		end
		LBV = Lifebloomer_deepcopy(LBV_t);
		for i=1, n, 1 do
			Set_LBTarget(nil, LBV[i].Unitid, getglobal("LifebloomerMainFrameUnitFrame"..i));
		end
	else
		LBV = {};
		LBV[1] = {};
		LBV[1].Unitid = "target";
		LBV[1].Name = "target";
		LBV[1].Target2 = "targettargettarget";
	end
	
	Lifebloomer_SetColors_Sample();
	
	Lifebloomer_AdjustH_Sample();
	Lifebloomer_AdjustW_Sample();
	Lifebloomer_AdjustS_Sample();
	Lifebloomer_AdjustRejuv_Sample();
	Lifebloomer_AdjustRegro_Sample();
	
	Lifebloomer_AdjustH();
	Lifebloomer_AdjustW();
	Lifebloomer_AdjustS();
	Lifebloomer_AdjustRejuv();
	Lifebloomer_AdjustRegro();
	
	if LBSaved.LStat and LBSaved.Lock then
		LBSaved.Lock = nil;
		Lifebloomer_SlashCommand("lock");
	end
	
	DEFAULT_CHAT_FRAME:AddMessage("Lifebloomer Loaded.  Type |cFFFFFFFF/lifebloomer|r for help.", 0, 1, 0);
end

function Lifebloomer_UnitFrame_OnEnter(self)
	if ( SpellIsTargeting() ) then
		SetCursor("CAST_CURSOR");
	end
	local unitid = self:GetAttribute("unit");
	if ( SpellIsTargeting() and not SpellCanTargetUnit(unitid) ) then
		SetCursor("CAST_ERROR_CURSOR");
	end
end

function Set_LBTarget(tar, unit, parent)
	if unit == 0 then
		unit = Lifebloomer_ID_Unit(tar);
	end
	if ( not ( unit == nil ) ) then
		local id = (parent):GetID();
		LBV[id].Unitid = unit;
		if not InCombatLockdown() then
			(parent):SetAttribute("unit", unit);
		end
		if strsub(unit, 1, 6) == "player" or strsub(unit, 1, 6) == "target" or strsub(unit, 1, 5) == "focus" or strsub(unit, 1, 9) == "mouseover" or strsub(unit, 1, 3) == "pet"  then
			LBV[id].Target2 = unit.."targettarget";
		else LBV[id].Target2 = unit.."-target-target"; end
	end
end

function Lifebloomer_UnitFrame_Update(self, elapsed)
	self.TimeSinceLastUpdate = self.TimeSinceLastUpdate + elapsed;
	if self.TimeSinceLastUpdate > 0.05 then
		while self.TimeSinceLastUpdate > 0.05 do
			self.TimeSinceLastUpdate = self.TimeSinceLastUpdate - 0.05;
			self.TimeCount = self.TimeCount + 1;
			if self.TimeCount >= 10 then
				if LBSaved.DTPS == 1 then
					Lifebloomer_DamageTakenUpdate1(self);
				elseif LBSaved.DTPS == 2 then
					Lifebloomer_DamageTakenUpdate2(self);
				end
				self.TimeCount = self.TimeCount - 10;
			end
		end
		
		local unit = LBV[self:GetID()].Unitid;
		local name,_ = UnitName(unit);
		if name then
			self.Name:SetText(name);
			LBV[self:GetID()].Name = name;
		else
			self.Name:SetText(unit);
			LBV[self:GetID()].Name = LBV[self:GetID()].Unitid;
		end
		self.HPBar:SetValue(UnitHealth(unit)/(UnitHealthMax(unit)+0.01)*100);
		if IsSpellInRange(LIFEBLOOMER_Healing_Touch, unit) == 1 then
			self.Name:SetTextColor(LBColors[10].R, LBColors[10].G, LBColors[10].B, LBColors[10].A);
		else
			self.Name:SetTextColor(LBColors[11].R, LBColors[11].G, LBColors[11].B, LBColors[11].A);
		end
		local curse = 0;
		local poison = 0;
		local i = 1;
		local life = 0;
		local rejuv = 0;
		local regro = 0;
		while i > 0 do
			if UnitExists(unit) then
				local name, rank, iconTexture, count, duration, timeLeft = UnitBuff(unit, i, 1);
				if name == nil then
					i = 0;
					break;
				elseif i > 40 then
					i = 0;
					break;
				else
					i = i + 1;
				end
				local down, up, lag = GetNetStats();
				if timeLeft then
					timeLeft = timeLeft - lag/1000;
					if name == LIFEBLOOMER_Lifebloom then
						if timeLeft <= 0 then
							timeLeft = 0;
						elseif timeLeft + lag/1000 < 1 then
							self.LBBar:SetStatusBarColor(.75, 0, 0, LBColors[3].A);
						elseif timeLeft < 1 then
							self.LBBar:SetStatusBarColor(.5, 0, .5, LBColors[3].A);
						else self.LBBar:SetStatusBarColor(LBColors[3].R, LBColors[3].G, LBColors[3].B, LBColors[3].A);
						end
						self.Number:SetText(count);
						self.Timer:SetText(floor(timeLeft*10)/10);
						self.LBBar:SetValue(timeLeft/duration*100);
						self.LBBarGCD:Show();
						life = 1;
					end
					if name == LIFEBLOOMER_Rejuvenation then
						self.RejuvBar:SetValue(timeLeft/duration*100);
						rejuv = 1;
					end
					if name == LIFEBLOOMER_Regrowth then
						self.RegroBar:SetValue(timeLeft/duration*100);
						regro = 1;
					end
				end
			else
				life = 0;
				rejuv = 0;
				i = 0;
			end
		end
		for i=1, 40, 1 do
			if UnitExists(unit) then
				local name, rank, texture, count, debuffType, duration, timeLeft = UnitDebuff(unit, i, 1);
				if name == nil then
					break;
				elseif debuffType == "Curse" then
					curse = 1;
				elseif debuffType == "Poison" then
					poison = 1;
				end
			end
		end
		if life == 0 then
			self.LBBar:SetValue(0);
			self.Number:SetText("");
			self.Timer:SetText("");
			self.LBBarGCD:Hide();
		end
		if rejuv == 0 then
			self.RejuvBar:SetValue(0);
		end
		if regro == 0 then
			self.RegroBar:SetValue(0);
		end
		if curse == 1 and poison == 1 then
			self:SetBackdropBorderColor(LBColors[9].R, LBColors[9].G, LBColors[9].B, LBColors[9].A);
		elseif curse == 1 then
			self:SetBackdropBorderColor(LBColors[7].R, LBColors[7].G, LBColors[7].B, LBColors[7].A);
		elseif poison == 1 then
			self:SetBackdropBorderColor(LBColors[8].R, LBColors[8].G, LBColors[8].B, LBColors[8].A);
		else self:SetBackdropBorderColor(LBColors[6].R, LBColors[6].G, LBColors[6].B, LBColors[6].A);
		end
		local i = 14;
		self.Number:SetTextColor(LBColors[i].R, LBColors[i].G, LBColors[i].B, LBColors[i].A);
		local i = 15;
		self.Timer:SetTextColor(LBColors[i].R, LBColors[i].G, LBColors[i].B, LBColors[i].A);
	end
end

function Lifebloomer_GCDUpdate(self, elapsed)
	self.TimeSinceLastUpdate = self.TimeSinceLastUpdate + elapsed;
	while self.TimeSinceLastUpdate > 0.05 do
		self.TimeSinceLastUpdate = self.TimeSinceLastUpdate - 0.05;
		if LB_GCD then
			local start, duration, e = GetSpellCooldown(LIFEBLOOMER_Healing_Touch);
			local seconds = GetTime();
			self:SetValue((duration-(seconds-start))*100);
		end
	end
end

function Lifebloomer_OnEvent(self, event, arg1, arg2, arg3, arg4, arg5)
	if event == "PLAYER_TARGET_CHANGED" then
		if self:GetAttribute("unit") == "target" then
			self.Dmg = {0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0};
			self.DTPS = 0;
		end
	elseif event == "PLAYER_FOCUS_CHANGED" then
		if self:GetAttribute("unit") == "focus" then
			self.Dmg = {0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0};
			self.DTPS = 0;
		end
	end
end

function Lifebloomer_ID_Unit(unit)
	if not UnitExists(unit) then
		return "target";
	elseif UnitIsUnit(unit, "focus") then
		return "focus";
	elseif UnitIsUnit(unit, "player") then
		return "player";
	elseif UnitIsUnit(unit, "pet") then
		return "pet";
	elseif UnitInRaid(unit) or UnitInParty(unit) then
		local name, realm = UnitName(unit);
		return name
	elseif UnitPlayerOrPetInRaid(unit) then
		for i=1, 40, 1 do
			if UnitIsUnit(unit, "raidpet"..i) then
				local name, realm = UnitName("raid"..i);
				return name.."-pet"
			end
		end
	elseif UnitPlayerOrPetInParty(unit) then
		for i=1, 4, 1 do
			if UnitIsUnit(unit, "partypet"..i) then
				local name, realm = UnitName("party"..i);
				return name.."-pet"
			end
		end
	else return "target" end
end

function Lifebloomer_AddFrame(self)
	local top = LifebloomerMainFrame:GetTop();
	local left = LifebloomerMainFrame:GetLeft();
	
	local n = self:GetParent():GetID() + 1;
	local nt = getn(LBV) + 1;
	if LBVFF == 0 then
		local NewFrame = CreateFrame("Button", "LifebloomerMainFrameUnitFrame"..nt, LifebloomerMainFrame, "LifebloomerUnitTemplate");
		NewFrame:SetID(nt);
		NewFrame:SetPoint("TOP", "LifebloomerMainFrameUnitFrame"..(nt-1), "BOTTOM", 0, -LBDim.s);
		
		NewFrame.Number = getglobal("LifebloomerMainFrameUnitFrame"..nt.."LBBarNumber");
		NewFrame.Timer = getglobal("LifebloomerMainFrameUnitFrame"..nt.."LBBarTimer");
		NewFrame.LBBar = getglobal("LifebloomerMainFrameUnitFrame"..nt.."LBBar");
		NewFrame.LBBarGCD = getglobal("LifebloomerMainFrameUnitFrame"..nt.."LBBarGCD");
		NewFrame.RejuvBar = getglobal("LifebloomerMainFrameUnitFrame"..nt.."RejuvBar");
		NewFrame.RegroBar = getglobal("LifebloomerMainFrameUnitFrame"..nt.."RegroBar");
		NewFrame.HPBar = getglobal("LifebloomerMainFrameUnitFrame"..nt.."HPBar");
		NewFrame.Name = getglobal("LifebloomerMainFrameUnitFrame"..nt.."HPBarName");
		NewFrame.DTPSlabel = getglobal("LifebloomerMainFrameUnitFrame"..nt.."HPBarDTPS");
		NewFrame.DTPS = 0;
		NewFrame.Damage = 0;
		NewFrame.TimeCount = 0;
		NewFrame.Dmg = {0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0};
		
		local i = 1;
		getglobal("LifebloomerMainFrameUnitFrame"..nt):SetBackdropColor(LBColors[i].R, LBColors[i].G, LBColors[i].B, LBColors[i].A);
		local i = 2;
		getglobal("LifebloomerMainFrameUnitFrame"..nt.."HPBar"):SetStatusBarColor(LBColors[i].R, LBColors[i].G, LBColors[i].B, LBColors[i].A);
		local i = 3;
		getglobal("LifebloomerMainFrameUnitFrame"..nt.."LBBar"):SetStatusBarColor(LBColors[i].R, LBColors[i].G, LBColors[i].B, LBColors[i].A);
		local i = 4;
		getglobal("LifebloomerMainFrameUnitFrame"..nt.."RejuvBar"):SetStatusBarColor(LBColors[i].R, LBColors[i].G, LBColors[i].B, LBColors[i].A);
		local i = 5;
		getglobal("LifebloomerMainFrameUnitFrame"..nt.."RegroBar"):SetStatusBarColor(LBColors[i].R, LBColors[i].G, LBColors[i].B, LBColors[i].A);
		
		ClickCastFrames[NewFrame] = true;
		Lifebloomer_SetAttributes(NewFrame);
		if Click2Cast then
			Click2Cast:RegisterFrame(NewFrame);
		end
	else
		local frame = getglobal("LifebloomerMainFrameUnitFrame"..nt);
		frame:Show();
		frame:SetAttribute("unit", "target");
		frame:RegisterEvent("PLAYER_FOCUS_CHANGED");
		frame:RegisterEvent("PLAYER_TARGET_CHANGED");
		frame:RegisterEvent("COMBAT_LOG_EVENT_UNFILTERED");
		LBVFF = LBVFF - 1;
	end
	tinsert(LBV, n, {});
	LBV[n] = {};
	LBV[n].Unitid = "target";
	LBV[n].Name = "target";
	LBV[n].Realm = nil;
	
	for i=n, nt, 1 do
		Set_LBTarget(nil, LBV[i].Unitid, getglobal("LifebloomerMainFrameUnitFrame"..i));
	end
	
	LifebloomerMainFrame:ClearAllPoints();
	LifebloomerMainFrame:SetPoint("TOPLEFT", "UIParent", "BOTTOMLEFT", left, top);
	
	Lifebloomer_AdjustH();
	Lifebloomer_AdjustW();
	Lifebloomer_AdjustRejuv();
	Lifebloomer_AdjustRegro();
	
end

function Lifebloomer_RemoveFrame(parent)
	local top = LifebloomerMainFrame:GetTop();
	local left = LifebloomerMainFrame:GetLeft();
	
	local nt = getn(LBV);
	if nt == 0 then
		LifebloomerMainFrame:Hide();
		DEFAULT_CHAT_FRAME:AddMessage(">> |cFFFFFFFFl|rife|cFFFFFFFFb|rloomer Hidden.", 0, 1, 0);
		return
	end
	local n1 = (parent):GetID();
	tremove(LBV, n1);
	for i=n1, nt-1, 1 do
		Set_LBTarget(nil, LBV[i].Unitid, getglobal("LifebloomerMainFrameUnitFrame"..i));
	end
	getglobal("LifebloomerMainFrameUnitFrame"..nt):Hide();
	getglobal("LifebloomerMainFrameUnitFrame"..nt):UnregisterEvent("PLAYER_FOCUS_CHANGED");
	getglobal("LifebloomerMainFrameUnitFrame"..nt):UnregisterEvent("PLAYER_TARGET_CHANGED");
	getglobal("LifebloomerMainFrameUnitFrame"..nt):UnregisterEvent("COMBAT_LOG_EVENT_UNFILTERED");
	LBVFF = LBVFF + 1;
	
	LifebloomerMainFrame:ClearAllPoints();
	LifebloomerMainFrame:SetPoint("TOPLEFT", "UIParent", "BOTTOMLEFT", left, top);
	LifebloomerMainFrame:SetHeight(LifebloomerMainFrame:GetHeight() - (LBDim.h + LBDim.s));
end

function Lifebloomer_SlashCommand(cmd)
	if cmd == "reset" or cmd == "r" then
		if not InCombatLockdown() then
			DEFAULT_CHAT_FRAME:AddMessage("/|cFFFFFFFFl|rife|cFFFFFFFFb|rloomer |cFFFFFFFFr|reset |cFFFFFFFF - Reset|r", 0, 1, 0);
			LifebloomerMainFrame:ClearAllPoints();
			LifebloomerMainFrame:SetPoint("TOP", "UIParent", "CENTER");
		end
	elseif cmd == "show" or cmd == "s" then
		if not InCombatLockdown() then
			DEFAULT_CHAT_FRAME:AddMessage("/|cFFFFFFFFl|rife|cFFFFFFFFb|rloomer |cFFFFFFFFs|rhow |cFFFFFFFF - Show|r", 0, 1, 0);
			LifebloomerMainFrame:Show();
		end
	elseif cmd == "hide" or cmd == "h" then
		if not InCombatLockdown() then
			DEFAULT_CHAT_FRAME:AddMessage("/|cFFFFFFFFl|rife|cFFFFFFFFb|rloomer |cFFFFFFFFh|ride |cFFFFFFFF - Hide|r", 0, 1, 0);
			LifebloomerMainFrame:Hide();
		end
	elseif cmd == "lock" or cmd == "l" then
		DEFAULT_CHAT_FRAME:AddMessage("/|cFFFFFFFFl|rife|cFFFFFFFFb|rloomer |cFFFFFFFFl|rock |cFFFFFFFF - Lock|r", 0, 1, 0);
		if LBSaved.Lock then
			LBSaved.Lock = nil;
			if not InCombatLockdown() then
				LifebloomerMainFrameText:Show();
				LifebloomerMainFrame:EnableMouse(true);
				LifebloomerMainFrameReduceButton:Show();
				LifebloomerMainFrameIncreaseButton:Show();
				for i=1, #(LBV), 1 do
					getglobal("LifebloomerMainFrameUnitFrame"..i.."TargetButton"):Show();
					getglobal("LifebloomerMainFrameUnitFrame"..i.."ReduceButton"):Show();
					getglobal("LifebloomerMainFrameUnitFrame"..i.."IncreaseButton"):Show();
				end
			end
		else
			LBSaved.Lock = 1;
			if not InCombatLockdown() then
				LifebloomerMainFrameText:Hide();
				LifebloomerMainFrame:EnableMouse(false);
				LifebloomerMainFrameReduceButton:Hide();
				LifebloomerMainFrameIncreaseButton:Hide();
				for i=1, getn(LBV), 1 do
					getglobal("LifebloomerMainFrameUnitFrame"..i.."TargetButton"):Hide();
					getglobal("LifebloomerMainFrameUnitFrame"..i.."ReduceButton"):Hide();
					getglobal("LifebloomerMainFrameUnitFrame"..i.."IncreaseButton"):Hide();
				end
			end
		end
	else
		Lifebloomer_CommandList();
	end
end

function Lifebloomer_CommandList()
	DEFAULT_CHAT_FRAME:AddMessage("Commands:", 1, 1, 1);
	DEFAULT_CHAT_FRAME:AddMessage("/|cFFFFFFFFl|rife|cFFFFFFFFb|rloomer |cFFFFFFFF - Command List|r", 0, 1, 0);
	DEFAULT_CHAT_FRAME:AddMessage("/|cFFFFFFFFl|rife|cFFFFFFFFb|rloomer |cFFFFFFFFs|rhow |cFFFFFFFF - Show|r", 0, 1, 0);
	DEFAULT_CHAT_FRAME:AddMessage("/|cFFFFFFFFl|rife|cFFFFFFFFb|rloomer |cFFFFFFFFh|ride |cFFFFFFFF - Hide|r", 0, 1, 0);
	DEFAULT_CHAT_FRAME:AddMessage("/|cFFFFFFFFl|rife|cFFFFFFFFb|rloomer |cFFFFFFFFr|reset |cFFFFFFFF - Reset|r", 0, 1, 0);
	DEFAULT_CHAT_FRAME:AddMessage("/|cFFFFFFFFl|rife|cFFFFFFFFb|rloomer |cFFFFFFFFl|rock |cFFFFFFFF - Lock|r", 0, 1, 0);
end

function Lifebloomer_SetAttributes(frame)
	if LBSaved.Bind then
		ClickCastFrames[frame] = nil;
		local i = 1;
		while i < 3 do
			local k = 1;
			while k < 5 do
				frame:SetAttribute((LBSaved[i][k].N).."type"..i, LBSaved[i][k].T);
				frame:SetAttribute((LBSaved[i][k].N)..(LBSaved[i][k].T)..i, LBSaved[i][k].S);
				k = k + 1;
			end
			i = i + 1;
		end
	else
		for k = 1, 4, 1 do
			frame:SetAttribute((LBSaved[1][k].N).."type1", "target");
			frame:SetAttribute((LBSaved[1][k].N)..(LBSaved[1][k].T)..1, nil);
		end
		local k = 1;
		while k < 5 do
			frame:SetAttribute((LBSaved[2][k].N).."type2", "none");
			frame:SetAttribute((LBSaved[2][k].N)..(LBSaved[2][k].T)..2, nil);
			k = k + 1;
		end
		ClickCastFrames[frame] = true;
	end
end

function Lifebloomer_SetBindings()
	local i = 1;
	while i < 9 do
		local text = getglobal("LifebloomerOptionsBindingsComboBox"..i.."Text"):GetText();
		if strfind(text, "}") then
		else
			LB_Buffer.LBBind[i] = text;
		end
		i = i + 1;
	end
	
	foreach(LB_Buffer.LBBind, Lifebloomer_BindOne);
	
	local i = getn(LBV) + LBVFF;
	while i > 0 do
		local frame = getglobal("LifebloomerMainFrameUnitFrame"..i);
		Lifebloomer_SetAttributes(frame);
		i = i - 1;
	end
end

function Lifebloomer_BindOne(k, text)
	local Type = "target";
	local Spell = "Target";
	local i = 1;
	if k > 4 then
		k = k - 4;
		i = 2;
	end
	if not (text == "Target") then
		Type = "spell";
		Spell = text;
	end
	LBSaved[i][k].T = Type;
	LBSaved[i][k].S = Spell;
end

function Lifebloomer_SetColors_Sample()
	local i = 1;
	LifebloomerOptionsAppearanceSample:SetBackdropColor(LB_Buffer.LBColors[i].R, LB_Buffer.LBColors[i].G, LB_Buffer.LBColors[i].B, LB_Buffer.LBColors[i].A);
	LifebloomerOptionsDimensionsSample:SetBackdropColor(LB_Buffer.LBColors[i].R, LB_Buffer.LBColors[i].G, LB_Buffer.LBColors[i].B, LB_Buffer.LBColors[i].A);
	local i = 2;
	LifebloomerOptionsAppearanceSampleHPBar:SetStatusBarColor(LB_Buffer.LBColors[i].R, LB_Buffer.LBColors[i].G, LB_Buffer.LBColors[i].B, LB_Buffer.LBColors[i].A);
	LifebloomerOptionsDimensionsSampleHPBar:SetStatusBarColor(LB_Buffer.LBColors[i].R, LB_Buffer.LBColors[i].G, LB_Buffer.LBColors[i].B, LB_Buffer.LBColors[i].A);
	local i = 3;
	LifebloomerOptionsAppearanceSampleLBBar:SetStatusBarColor(LB_Buffer.LBColors[i].R, LB_Buffer.LBColors[i].G, LB_Buffer.LBColors[i].B, LB_Buffer.LBColors[i].A);
	LifebloomerOptionsDimensionsSampleLBBar:SetStatusBarColor(LB_Buffer.LBColors[i].R, LB_Buffer.LBColors[i].G, LB_Buffer.LBColors[i].B, LB_Buffer.LBColors[i].A);
	local i = 4;
	LifebloomerOptionsAppearanceSampleRejuvBar:SetStatusBarColor(LB_Buffer.LBColors[i].R, LB_Buffer.LBColors[i].G, LB_Buffer.LBColors[i].B, LB_Buffer.LBColors[i].A);
	LifebloomerOptionsDimensionsSampleRejuvBar:SetStatusBarColor(LB_Buffer.LBColors[i].R, LB_Buffer.LBColors[i].G, LB_Buffer.LBColors[i].B, LB_Buffer.LBColors[i].A);
	local i = 5;
	LifebloomerOptionsAppearanceSampleRegroBar:SetStatusBarColor(LB_Buffer.LBColors[i].R, LB_Buffer.LBColors[i].G, LB_Buffer.LBColors[i].B, LB_Buffer.LBColors[i].A);
	LifebloomerOptionsDimensionsSampleRegroBar:SetStatusBarColor(LB_Buffer.LBColors[i].R, LB_Buffer.LBColors[i].G, LB_Buffer.LBColors[i].B, LB_Buffer.LBColors[i].A);
	local i = 6 + LB_Buffer.Debuff;
	LifebloomerOptionsAppearanceSample:SetBackdropBorderColor(LB_Buffer.LBColors[i].R, LB_Buffer.LBColors[i].G, LB_Buffer.LBColors[i].B, LB_Buffer.LBColors[i].A);
	LifebloomerOptionsDimensionsSample:SetBackdropBorderColor(LB_Buffer.LBColors[i].R, LB_Buffer.LBColors[i].G, LB_Buffer.LBColors[i].B, LB_Buffer.LBColors[i].A);
	local i = 11 - LB_Buffer.Range;
	LifebloomerOptionsAppearanceSampleHPBarName:SetTextColor(LB_Buffer.LBColors[i].R, LB_Buffer.LBColors[i].G, LB_Buffer.LBColors[i].B, LB_Buffer.LBColors[i].A);
	LifebloomerOptionsDimensionsSampleHPBarName:SetTextColor(LB_Buffer.LBColors[i].R, LB_Buffer.LBColors[i].G, LB_Buffer.LBColors[i].B, LB_Buffer.LBColors[i].A);
	local i = 13 - LB_Buffer.Agro;
	LifebloomerOptionsAppearanceSampleHPBarDTPS:SetTextColor(LB_Buffer.LBColors[i].R, LB_Buffer.LBColors[i].G, LB_Buffer.LBColors[i].B, LB_Buffer.LBColors[i].A);
	LifebloomerOptionsDimensionsSampleHPBarDTPS:SetTextColor(LB_Buffer.LBColors[i].R, LB_Buffer.LBColors[i].G, LB_Buffer.LBColors[i].B, LB_Buffer.LBColors[i].A);
	local i = 14;
	LifebloomerOptionsAppearanceSampleLBBarNumber:SetTextColor(LB_Buffer.LBColors[i].R, LB_Buffer.LBColors[i].G, LB_Buffer.LBColors[i].B, LB_Buffer.LBColors[i].A);
	LifebloomerOptionsDimensionsSampleLBBarNumber:SetTextColor(LB_Buffer.LBColors[i].R, LB_Buffer.LBColors[i].G, LB_Buffer.LBColors[i].B, LB_Buffer.LBColors[i].A);
	local i = 15;
	LifebloomerOptionsAppearanceSampleLBBarTimer:SetTextColor(LB_Buffer.LBColors[i].R, LB_Buffer.LBColors[i].G, LB_Buffer.LBColors[i].B, LB_Buffer.LBColors[i].A);
	LifebloomerOptionsDimensionsSampleLBBarTimer:SetTextColor(LB_Buffer.LBColors[i].R, LB_Buffer.LBColors[i].G, LB_Buffer.LBColors[i].B, LB_Buffer.LBColors[i].A);
	for i=1, 15, 1 do
		getglobal("LifebloomerOptionsAppearanceTexture"..i.."Texture"):SetTexture(LB_Buffer.LBColors[i].R, LB_Buffer.LBColors[i].G, LB_Buffer.LBColors[i].B, LB_Buffer.LBColors[i].A);
	end
end

function Lifebloomer_Color(preval)
	if not preval then
		LB_Buffer.LBColors[LBColorID].R, LB_Buffer.LBColors[LBColorID].G, LB_Buffer.LBColors[LBColorID].B = ColorPickerFrame:GetColorRGB();
	else
		LB_Buffer.LBColors[LBColorID].R, LB_Buffer.LBColors[LBColorID].G, LB_Buffer.LBColors[LBColorID].B, LB_Buffer.LBColors[LBColorID].A = unpack(preval);
	end
	Lifebloomer_SetColors_Sample();
end

function Lifebloomer_Opacity()
	LB_Buffer.LBColors[LBColorID].A = OpacitySliderFrame:GetValue();
	Lifebloomer_SetColors_Sample();
end

function Lifebloomer_SetColors()
	local n = getn(LBV) + LBVFF;
	while n > 0 do
		local i = 1;
		getglobal("LifebloomerMainFrameUnitFrame"..n):SetBackdropColor(LBColors[i].R, LBColors[i].G, LBColors[i].B, LBColors[i].A);
		local i = 2;
		getglobal("LifebloomerMainFrameUnitFrame"..n.."HPBar"):SetStatusBarColor(LBColors[i].R, LBColors[i].G, LBColors[i].B, LBColors[i].A);
		local i = 3;
		getglobal("LifebloomerMainFrameUnitFrame"..n.."LBBar"):SetStatusBarColor(LBColors[i].R, LBColors[i].G, LBColors[i].B, LBColors[i].A);
		local i = 4;
		getglobal("LifebloomerMainFrameUnitFrame"..n.."RejuvBar"):SetStatusBarColor(LBColors[i].R, LBColors[i].G, LBColors[i].B, LBColors[i].A);
		local i = 5;
		getglobal("LifebloomerMainFrameUnitFrame"..n.."RegroBar"):SetStatusBarColor(LBColors[i].R, LBColors[i].G, LBColors[i].B, LBColors[i].A);
		n = n - 1;
	end
end

function Lifebloomer_OptionsAppearance_Accept()
	LBColors = Lifebloomer_deepcopy(LB_Buffer.LBColors);
	Lifebloomer_SetColors();
end

function Lifebloomer_OptionsAppearance_Cancel()
	LB_Buffer.LBColors = Lifebloomer_deepcopy(LBColors);
	Lifebloomer_SetColors_Sample();
end

function Lifebloomer_OptionsAppearance_Default()
--Background
	LB_Buffer.LBColors[1].R = 1;
	LB_Buffer.LBColors[1].G = 1;
	LB_Buffer.LBColors[1].B = 1;
	LB_Buffer.LBColors[1].A = .25;
--Health
	LB_Buffer.LBColors[2].R = 0;
	LB_Buffer.LBColors[2].G = .8;
	LB_Buffer.LBColors[2].B = 0;
	LB_Buffer.LBColors[2].A = 1;
--Lifebloom
	LB_Buffer.LBColors[3].R = 0;
	LB_Buffer.LBColors[3].G = .2;
	LB_Buffer.LBColors[3].B = .5;
	LB_Buffer.LBColors[3].A = .8;
--Rejuv
	LB_Buffer.LBColors[4].R = .5;
	LB_Buffer.LBColors[4].G = 0;
	LB_Buffer.LBColors[4].B = .5;
	LB_Buffer.LBColors[4].A = 1;
--Regrowth
	LB_Buffer.LBColors[5].R = 0;
	LB_Buffer.LBColors[5].G = 1;
	LB_Buffer.LBColors[5].B = 0;
	LB_Buffer.LBColors[5].A = 1;
--Boarder
	LB_Buffer.LBColors[6].R = 1;
	LB_Buffer.LBColors[6].G = 1;
	LB_Buffer.LBColors[6].B = 1;
	LB_Buffer.LBColors[6].A = 1;
--Cursed
	LB_Buffer.LBColors[7].R = 1;
	LB_Buffer.LBColors[7].G = 0;
	LB_Buffer.LBColors[7].B = 1;
	LB_Buffer.LBColors[7].A = 1;
--Poisoned
	LB_Buffer.LBColors[8].R = 0;
	LB_Buffer.LBColors[8].G = 1;
	LB_Buffer.LBColors[8].B = 0;
	LB_Buffer.LBColors[8].A = 1;
--Curse + Poison
	LB_Buffer.LBColors[9].R = 1;
	LB_Buffer.LBColors[9].G = 0;
	LB_Buffer.LBColors[9].B = 0;
	LB_Buffer.LBColors[9].A = 1;
--In Range
	LB_Buffer.LBColors[10].R = 0;
	LB_Buffer.LBColors[10].G = 0.1;
	LB_Buffer.LBColors[10].B = 0;
	LB_Buffer.LBColors[10].A = 0.5;
--Out of Range
	LB_Buffer.LBColors[11].R = 0.5;
	LB_Buffer.LBColors[11].G = 0;
	LB_Buffer.LBColors[11].B = 0;
	LB_Buffer.LBColors[11].A = 1;
--Has Agro
	LB_Buffer.LBColors[12].R = 1;
	LB_Buffer.LBColors[12].G = 1;
	LB_Buffer.LBColors[12].B = 0;
	LB_Buffer.LBColors[12].A = 1;
--No Agro
	LB_Buffer.LBColors[13].R = 0;
	LB_Buffer.LBColors[13].G = 1;
	LB_Buffer.LBColors[13].B = 1;
	LB_Buffer.LBColors[13].A = 1;
--LB Count
	LB_Buffer.LBColors[14].R = 1;
	LB_Buffer.LBColors[14].G = 1;
	LB_Buffer.LBColors[14].B = 1;
	LB_Buffer.LBColors[14].A = 1;
--LB Timer
	LB_Buffer.LBColors[15].R = 1;
	LB_Buffer.LBColors[15].G = 1;
	LB_Buffer.LBColors[15].B = 1;
	LB_Buffer.LBColors[15].A = 1;
--Condition Settings
	LB_Buffer.Debuff = 0;		-- 0: none, 1: curse, 2: poison, 3: both
	LB_Buffer.Range = 1;		-- 0: out, 1: in
	LB_Buffer.Agro = 0;			-- 0: no, 1: yes
	
	Lifebloomer_SetColors_Sample();
end

function Lifebloomer_AdjustH_Sample()
	LifebloomerOptionsDimensionsSample:SetHeight(LB_Buffer.LBDim.h);
end

function Lifebloomer_AdjustH()
	local nv = getn(LBV);
	local n = nv + LBVFF;
	while n > 0 do
		getglobal("LifebloomerMainFrameUnitFrame"..n):SetHeight(LBDim.h);
		getglobal("LifebloomerMainFrameUnitFrame"..n.."TargetButton"):SetHeight((LBDim.h-10)/3);
		getglobal("LifebloomerMainFrameUnitFrame"..n.."TargetButton"):SetWidth((LBDim.h-10)/3);
		getglobal("LifebloomerMainFrameUnitFrame"..n.."ReduceButton"):SetHeight((LBDim.h-10)/3);
		getglobal("LifebloomerMainFrameUnitFrame"..n.."ReduceButton"):SetWidth((LBDim.h-10)/3);
		getglobal("LifebloomerMainFrameUnitFrame"..n.."IncreaseButton"):SetHeight((LBDim.h-10)/3);
		getglobal("LifebloomerMainFrameUnitFrame"..n.."IncreaseButton"):SetWidth((LBDim.h-10)/3);
		n = n - 1;
	end
	LifebloomerMainFrame:SetHeight(16 + (LBDim.h * nv) + (LBDim.s * (nv - 1)));
end

function Lifebloomer_AdjustW_Sample()
	LifebloomerOptionsDimensionsSample:SetWidth(LB_Buffer.LBDim.w);
	LifebloomerOptionsDimensionsSampleLBBarGCD:ClearAllPoints();
	LifebloomerOptionsDimensionsSampleLBBarGCD:SetPoint("TOP", "LifebloomerOptionsDimensionsSampleLBBar", "TOPLEFT", LB_Buffer.LBDim.w*(1.5*(100-GetCombatRatingBonus(20))/100)/7, -1);
	LifebloomerOptionsDimensionsSampleLBBarGCD:SetPoint("BOTTOM", "LifebloomerOptionsDimensionsSampleLBBar", "BOTTOMLEFT", LB_Buffer.LBDim.w*(1.5*(100-GetCombatRatingBonus(20))/100)/7, 1);
end
function Lifebloomer_AdjustW()
	local nv = getn(LBV);
	local n = nv + LBVFF;
	while n > 0 do
		getglobal("LifebloomerMainFrameUnitFrame"..n):SetWidth(LBDim.w);
		getglobal("LifebloomerMainFrameUnitFrame"..n.."LBBarGCD"):ClearAllPoints();
		getglobal("LifebloomerMainFrameUnitFrame"..n.."LBBarGCD"):SetPoint("TOP", "LifebloomerMainFrameUnitFrame"..n.."LBBar", "TOPLEFT", LBDim.w*(1.5*(100-GetCombatRatingBonus(20))/100)/7, -1);
		getglobal("LifebloomerMainFrameUnitFrame"..n.."LBBarGCD"):SetPoint("BOTTOM", "LifebloomerMainFrameUnitFrame"..n.."LBBar", "BOTTOMLEFT", LBDim.w*(1.5*(100-GetCombatRatingBonus(20))/100)/7, 1);
		n = n - 1;
	end
	LifebloomerMainFrame:SetWidth(LBDim.w);
end

function Lifebloomer_AdjustS_Sample()
	local nv = getn(LBV);
	local n = nv + LBVFF;
	while n > 1 do
		getglobal("LifebloomerMainFrameUnitFrame"..n):ClearAllPoints();
		getglobal("LifebloomerMainFrameUnitFrame"..n):SetPoint("TOP", "LifebloomerMainFrameUnitFrame"..(n-1), "BOTTOM", 0, -LB_Buffer.LBDim.s);
		n = n - 1;
	end
	LifebloomerMainFrame:SetHeight(16 + (LBDim.h * nv) + (LB_Buffer.LBDim.s * (nv - 1)));
end

function Lifebloomer_AdjustS()
	local nv = getn(LBV);
	local n = nv + LBVFF;
	while n > 1 do
		getglobal("LifebloomerMainFrameUnitFrame"..n):ClearAllPoints();
		getglobal("LifebloomerMainFrameUnitFrame"..n):SetPoint("TOP", "LifebloomerMainFrameUnitFrame"..(n-1), "BOTTOM", 0, -LBDim.s);
		n = n - 1;
	end
	LifebloomerMainFrame:SetHeight(16 + (LBDim.h * nv) + (LBDim.s * (nv - 1)));
end

function Lifebloomer_AdjustRejuv_Sample()
	local nv = getn(LBV);
	local n = nv + LBVFF;
	if LB_Buffer.LBDim.rej == 0 then
		LifebloomerOptionsDimensionsSampleRejuvBar:Hide();
		LifebloomerOptionsAppearanceSampleRejuvBar:Hide();
	else
		LifebloomerOptionsDimensionsSampleRejuvBar:Show();
		LifebloomerOptionsAppearanceSampleRejuvBar:Show();
		LifebloomerOptionsDimensionsSampleRejuvBar:SetHeight(LB_Buffer.LBDim.rej);
		LifebloomerOptionsAppearanceSampleRejuvBar:SetHeight(LB_Buffer.LBDim.rej);
	end
end

function Lifebloomer_AdjustRejuv()
	local nv = getn(LBV);
	local n = nv + LBVFF;
	while n > 0 do
		if LBDim.rej == 0 then
			getglobal("LifebloomerMainFrameUnitFrame"..n.."RejuvBar"):Hide();
		else
			getglobal("LifebloomerMainFrameUnitFrame"..n.."RejuvBar"):Show();
			getglobal("LifebloomerMainFrameUnitFrame"..n.."RejuvBar"):SetHeight(LBDim.rej);
		end
		n = n - 1;
	end
end

function Lifebloomer_AdjustRegro_Sample()
	local nv = getn(LBV);
	local n = nv + LBVFF;
	if LB_Buffer.LBDim.reg == 0 then
		LifebloomerOptionsDimensionsSampleRegroBar:Hide();
		LifebloomerOptionsAppearanceSampleRegroBar:Hide();
	else
		LifebloomerOptionsDimensionsSampleRegroBar:Show();
		LifebloomerOptionsAppearanceSampleRegroBar:Show();
		LifebloomerOptionsDimensionsSampleRegroBar:SetHeight(LB_Buffer.LBDim.reg);
		LifebloomerOptionsAppearanceSampleRegroBar:SetHeight(LB_Buffer.LBDim.reg);
	end
end

function Lifebloomer_AdjustRegro()
	local nv = getn(LBV);
	local n = nv + LBVFF;
	while n > 0 do
		if LBDim.reg == 0 then
			getglobal("LifebloomerMainFrameUnitFrame"..n.."RegroBar"):Hide();
		else
			getglobal("LifebloomerMainFrameUnitFrame"..n.."RegroBar"):Show();
			getglobal("LifebloomerMainFrameUnitFrame"..n.."RegroBar"):SetHeight(LBDim.reg);
		end
		n = n - 1;
	end
end

function Lifebloomer_OptionsDimensions_Accept()
	LBDim = Lifebloomer_deepcopy(LB_Buffer.LBDim);
	Lifebloomer_AdjustH();
	Lifebloomer_AdjustW();
	Lifebloomer_AdjustS();
	Lifebloomer_AdjustRejuv();
	Lifebloomer_AdjustRegro();
end

function Lifebloomer_OptionsDimensions_Cancel()
	LB_Buffer.LBDim = Lifebloomer_deepcopy(LBDim);
	Lifebloomer_AdjustH();
	Lifebloomer_AdjustW();
	Lifebloomer_AdjustS();
	Lifebloomer_AdjustRejuv();
	Lifebloomer_AdjustRegro();
end

function Lifebloomer_OptionsDimensions_Default()
	LB_Buffer.LBDim.h = 40;
	LB_Buffer.LBDim.w = 180;
	LB_Buffer.LBDim.s = 0
	LB_Buffer.LBDim.rej = 2;
	LB_Buffer.LBDim.reg = 2;
	Lifebloomer_AdjustH_Sample();
	Lifebloomer_AdjustW_Sample();
	Lifebloomer_AdjustS_Sample();
	Lifebloomer_AdjustRejuv_Sample();
	Lifebloomer_AdjustRegro_Sample();
end

function Lifebloomer_DamageTaken(self, timestamp, event, sourceGUID, sourceName, sourceFlags, destGUID, destName, destFlags, spellId, spellName, spellSchool, amount, school, resisted, blocked, absorbed, critical, glancing, crushing)
	if arg2 == "SWING_DAMAGE" then
		self.Damage = self.Damage + spellId;
	elseif arg2 == "ENVIRONMENTAL_DAMAMGE" then
		self.Damage = self.Damage + spellName;
	else
		self.Damage = self.Damage + amount;
	end
end

function Lifebloomer_DamageTakenUpdate1(self)
	self.DTPS = self.DTPS * 0.8 + self.Damage * 0.4;
	self.Damage = 0;
	self.DTPSlabel:SetText(tostring(floor(self.DTPS)));
	if UnitIsUnit(LBV[self:GetID()].Unitid, LBV[self:GetID()].Target2) then
		self.DTPSlabel:SetTextColor(LBColors[12].R, LBColors[12].G, LBColors[12].B, LBColors[12].A);
	else self.DTPSlabel:SetTextColor(LBColors[13].R, LBColors[13].G, LBColors[13].B, LBColors[13].A); end
end


function Lifebloomer_DamageTakenUpdate2(self)
	tinsert(self.Dmg, 1, self.Damage);
	tremove(self.Dmg, 13);
	self.Damage = 0;
	self.DTPS = ( self.Dmg[1] + self.Dmg[2] + self.Dmg[3] + self.Dmg[4] + self.Dmg[5] + self.Dmg[6] + self.Dmg[7] + self.Dmg[8] + self.Dmg[9] + self.Dmg[10] + self.Dmg[11] + self.Dmg[12] ) / 6;
	self.DTPSlabel:SetText(tostring(floor(self.DTPS)));
	if UnitIsUnit(LBV[self:GetID()].Unitid, LBV[self:GetID()].Target2) then
		self.DTPSlabel:SetTextColor(LBColors[12].R, LBColors[12].G, LBColors[12].B, LBColors[12].A);
	else self.DTPSlabel:SetTextColor(LBColors[13].R, LBColors[13].G, LBColors[13].B, LBColors[13].A); end
end

function Lifebloomer_deepcopy(object)
    local lookup_table = {}
    local function _copy(object)
        if type(object) ~= "table" then
            return object
        elseif lookup_table[object] then
            return lookup_table[object]
        end
        local new_table = {}
        lookup_table[object] = new_table
        for index, value in pairs(object) do
            new_table[_copy(index)] = _copy(value)
        end
        return setmetatable(new_table, getmetatable(object))
    end
    return _copy(object)
end
