
local TooltipExtras = _G.TooltipExtras

local moduleOptions = {
  name = function(info) return LazyTown:ApplyStateColor("Tooltip Extras", TooltipExtras.db.enabled) end,
  handler = TooltipExtras,
  disabled = LazyTown.IsDisabled,
  type = 'group',
  childGroups = 'tab',
  args = {
    enabled = {
      name = "Enabled",
      order = 10,
      type = 'toggle',
      set = "SetModuleState",
      get = function(info) return TooltipExtras.db.enabled end,
    },

    general = {
      name = "General",
      order = 50,
      type = 'group',
      args = {
        appearance = {
          name = "Appearance",
          order = 10,
          type = 'group',
          inline = true,
          args = {
            scale = {
              name = "Scale",
              order = 70,
              type = 'range',
              step = 0.01,
              min = 0.4,
              max = 1.6,
              set = function(info, val) TooltipExtras.db.scale = val TooltipExtras:Update('scale') end,
              get = function(info) return TooltipExtras.db.scale end,
            },
            font = {
              name = "Font",
              desc = "Sets the tooltip's font. For more fonts, get the addon 'SharedMedia'",
              order = 50,
              type = 'select',
              dialogControl = 'LSM30_Font',
              values = AceGUIWidgetLSMlists.font,
              set = function(info, val) TooltipExtras.db.font = val TooltipExtras:Update('font') end,
              get = function(info) return TooltipExtras.db.font end,
            },
            border = {
              name = "Border",
              desc = "Sets the tooltip's border. For more borders, get the addon 'SharedMedia'",
              order = 60,
              type = 'select',
              dialogControl = 'LSM30_Border',
              values = AceGUIWidgetLSMlists.border,
              set = function(info, val) TooltipExtras.db.border = val TooltipExtras:Update('backdrop') end,
              get = function(info) return TooltipExtras.db.border end,
            },
            borderColor = {
              name = "Border Color",
              order = 30,
              type = 'color',
              hasAlpha = true,
              set = function(info, r, g, b, a) TooltipExtras.db.borderColor = {r, g, b, a} end,
              get = function(info) return unpack(TooltipExtras.db.borderColor) end,
            },
            backgroundColor = {
              name = "Background Color",
              order = 40,
              type = 'color',
              hasAlpha = true,
              set = function(info, r, g, b, a) TooltipExtras.db.backgroundColor = {r, g, b, a} end,
              get = function(info) return unpack(TooltipExtras.db.backgroundColor) end,
            },
          },
        },
        anchor = {
          name = "Anchor",
          order = 20,
          type = 'group',
          inline = true,
          args = {
            anchorPos = {
              name = "Anchor Position",
              order = 10,
              type = 'select',
              values = {
                default = "Default",
                onMouse = "Stick to mouse",
                atMouse = "Start mouse position",
                custom = "Custom",
              },
              set = function(info, val) TooltipExtras.db.anchor = val TooltipExtras:AnchorSetupIfNeeded() end,
              get = function(info) return TooltipExtras.db.anchor end,
            },
            toggleCustom = {
              name = "Toggle custom anchor",
              order = 20,
              disabled = function(info) return TooltipExtras.db.anchor ~= 'custom' end,
              type = 'execute',
              func = "ToggleCustomAnchor",
            },
          },
        },
      },
    },
    unitExtras = {
      name = "Unit Extras",
      order = 60,
      type = 'group',
      args = {
        barTextures = {
          name = "Healthbar Texture",
          desc = "Sets the tooltip's healthbar texture. For more textures, get the addon 'SharedMedia'",
          order = 10,
          type = 'select',
          dialogControl = 'LSM30_Statusbar',
          values = AceGUIWidgetLSMlists.statusbar,
          set = function(info, val) TooltipExtras.db.barTexture = val TooltipExtras:Update('healthBar') end,
          get = function(info) return TooltipExtras.db.barTexture end,
        },
        healthText = {
          name = "Health Text",
          order = 20,
          type = 'group',
          inline = true,
          args = {
            textEnabled = {
              name = "Text Enabled",
              order = 10,
              type = 'toggle',
              set = function(info, val) TooltipExtras.db.health.enabled = val TooltipExtras:Update('healthText') end,
              get = function(info) return TooltipExtras.db.health.enabled end,
            },
            textFormat = {
              name = "Format",
              order = 20,
              type = 'select',
              values = {
                normal = "Normal",
                missing = "Missing",
                remaining = "Remaining",
              },
              set = function(info, val) TooltipExtras.db.health.format = val TooltipExtras:Update('healthText') end,
              get = function(info) return TooltipExtras.db.health.format end,
            },
            textColor = {
              name = "Color",
              order = 30,
              type = 'color',
              set = function(info, r, g, b, a) TooltipExtras.db.health.textColor = {r, g, b} TooltipExtras:Update('healthText') end,
              get = function(info) return unpack(TooltipExtras.db.health.textColor) end,
            },
            textFont = {
              name = "Font",
              order = 40,
              type = 'select',
              dialogControl = 'LSM30_Font',
              values = AceGUIWidgetLSMlists.font,
              set = function(info, val) TooltipExtras.db.health.font = val TooltipExtras:Update('healthText') end,
              get = function(info) return TooltipExtras.db.health.font end,
            },
          },
        },
        borderColor = {
          name = "Border Color",
          order = 30,
          type = 'select',
          values = {
            none = "No change",
            hos = "Hostility",
            classHos = "Class > Hostility",
            hosClass = "Hostility > Class",
            class = "Class",
          },
          set = function(info, val) TooltipExtras.db.unitBorderStyle = val end,
          get = function(info) return TooltipExtras.db.unitBorderStyle end,
        },
        backgroundColor = {
          name = "Background Color",
          order = 40,
          type = 'select',
          values = {
            none = "No change",
            hos = "Hostility",
            classHos = "Class > Hostility",
            hosClass = "Hostility > Class",
            class = "Class",
          },
          set = function(info, val) TooltipExtras.db.unitBackgroundStyle = val end,
          get = function(info) return TooltipExtras.db.unitBackgroundStyle end,
        },
      },
    },
    itemExtras = {
      name = "Item Extras",
      order = 70,
      type = 'group',
      args = {
        sellValueGroup = {
          name = "Sell Value",
          order = 10,
          type = 'group',
          inline = true,
          args = {
            sellValue = {
              name = "Enable item sell value",
              order = 10,
              type = 'toggle',
              set = function(info, val) TooltipExtras.db.sellValue.enabled = val TooltipExtras:Update('hooks') end,
              get = function(info) return TooltipExtras.db.sellValue.enabled end,
            },
            valueFormat = {
              name = "Format",
              order = 20,
              type = 'select',
              values = {
                collected = "Collected   10g",
                mix = "Mix   5 x 2g",
                individual = "Individual   2g",
                both = "Both   10g  (5 x 2g)"
              },
              set = function(info, val) TooltipExtras.db.sellValue.format = val end,
              get = function(info) return TooltipExtras.db.sellValue.format end,
            },
            visualStyle = {
              name = "Visial Style",
              order = 20,
              type = 'select',
              values = {
                coin = "Coin      " .. ValueToMoneyString(12345),
                upper = "Upper   1G 23S 45C",
                lower = "Lower   1g 23s 45c",
              },
              set = function(info, val) TooltipExtras.db.sellValue.style = val end,
              get = function(info) return TooltipExtras.db.sellValue.style end,
            },
          },
        },
        vSpace1 = LazyTown:OptionTableVSpace(15),
        itemLevel = {
          name = "Item Level",
          order = 20,
          type = 'toggle',
          set = function(info, val) TooltipExtras.db.itemLevel = val TooltipExtras:Update('hooks') end,
          get = function(info) return TooltipExtras.db.itemLevel end,
        },
        itemLevelColor = {
          name = "Text color",
          order = 25,
          type = 'color',
          set = function(info, r, g, b) TooltipExtras.db.itemLevelColor = {r, g, b} end,
          get = function(info) return unpack(TooltipExtras.db.itemLevelColor) end,
        },
        itemID = {
          name = "Item ID",
          order = 30,
          type = 'toggle',
          set = function(info, val) TooltipExtras.db.itemID = val TooltipExtras:Update('hooks') end,
          get = function(info) return TooltipExtras.db.itemID end,
        },
        itemIDColor = {
          name = "Text color",
          order = 35,
          type = 'color',
          set = function(info, r, g, b) TooltipExtras.db.itemIDColor = {r, g, b} end,
          get = function(info) return unpack(TooltipExtras.db.itemIDColor) end,
        },
        stackSize = {
          name = "Stack Size",
          order = 40,
          type = 'toggle',
          set = function(info, val) TooltipExtras.db.stackSize = val TooltipExtras:Update('hooks') end,
          get = function(info) return TooltipExtras.db.stackSize end,
        },
        stackSizeColor = {
          name = "Text color",
          order = 45,
          type = 'color',
          set = function(info, r, g, b) TooltipExtras.db.stackSizeColor = {r, g, b} end,
          get = function(info) return unpack(TooltipExtras.db.stackSizeColor) end,
        },
        vSpace2 = LazyTown:OptionTableVSpace(48),
        borderAsItem = {
          name = "Border as item",
          desc = "Color the border with the same color as the item's quality",
          order = 50,
          type = 'toggle',
          set = function(info, val) TooltipExtras.db.borderAsItem = val end,
          get = function(info) return TooltipExtras.db.borderAsItem end,
        },
        backgroundAsItem = {
          name = "Background as item",
          desc = "Color the background with the same color as the item's quality",
          order = 60,
          type = 'toggle',
          set = function(info, val) TooltipExtras.db.backgroundAsItem = val end,
          get = function(info) return TooltipExtras.db.backgroundAsItem end,
        },
      },
    },
  },
}

LazyTown:AddModuleOptions("tooltipExtrasGroup", moduleOptions)
