
local BlackBoxPanels = _G.BlackBoxPanels

local moduleOptions = {
  name = function(info) return LazyTown:ApplyStateColor("BlackBoxPanels", BlackBoxPanels.db.enabled) end,
  handler = BlackBoxPanels,
  disabled = LazyTown.IsDisabled,
--  hidden = true,
  type = 'group',
  childGroups = 'tab',
  args = {
    enabled = {
      name = "Enabled",
      order = 10,
      width = 'half',
      type = 'toggle',
      set = "SetModuleState",
      get = function(info) return BlackBoxPanels.db.enabled end,
    },
    lock = {
      name = "Locked",
      desc = "Locks all boxes, making them\nnon-interactable",
      order = 15,
      width = 'half',
      type = 'toggle',
      set = function(info, val) BlackBoxPanels.db.locked = val BlackBoxPanels:UpdateAllBoxes() end,
      get = function(info) return BlackBoxPanels.db.locked end,
    },
    selector = {
      name = "Selected box",
      order = 20,
      type = 'select',
      values = function(info) return BlackBoxPanels:GetBoxIDs() end,
      set = function(info, val) BlackBoxPanels.selected = BlackBoxPanels:GetBoxDB(val) end,
      get = function(info) return BlackBoxPanels:GetSelectedProperty('id') end,
    },
    addNewBox = {
      name = "Create new box",
      order = 30,
      type = 'execute',
      func = "NewDBBox",
    },
    removeBox = {
      name = "Delete selected box",
      desc = function(info) return "Deletes " .. (BlackBoxPanels:GetSelectedProperty('name') or "[No box created]") end,
      order = 40,
      type = 'execute',
      func = "RemoveSelectedBox",
    },
    manageAllTab = {
      name = "Manage all boxes",
      order = 50,
      disabled = "HasNoBoxes",
      type = 'group',
      args = {
        backgroundGroup = {
          name = "Set all backgrounds",
          order = 10,
          type = 'group',
          inline = true,
          args = {
            background = {
              name = "Background",
              order = 10,
              type = 'select',
              dialogControl = 'LSM30_Background',
              values = AceGUIWidgetLSMlists.background,
              set = "SetAllBackgrounds",
            },
            backgroundColor = {
              name = "Color",
              order = 20,
              type = 'color',
              hasAlpha = true,
              set = "SetAllBackgroundColors",
              get = function(info) return 1, 1, 1, 1 end,
            },
          },
        },
        borderGroup = {
          name = "Set all borders",
          order = 20,
          type = 'group',
          inline = true,
          args = {
            border = {
              name = "Border",
              order = 10,
              type = 'select',
              dialogControl = 'LSM30_Border',
              values = AceGUIWidgetLSMlists.border,
              set = "SetAllBorders",
            },
            borderColor = {
              name = "Color",
              order = 20,
              type = 'color',
              hasAlpha = true,
              set = "SetAllBorderColors",
              get = function(info) return 1, 1, 1, 1 end,
            },
          },
        },
        vSpace1 = LazyTown:OptionTableVSpace(25),
        showAll = {
          name = "Show all",
          order = 30,
          type = 'execute',
          func = "ShowAllBoxes",
        },
        hideAll = {
          name = "Hide all",
          order = 40,
          type = 'execute',
          func = "HideAllBoxes",
        },
      },
    },
    boxProperties = {
      name = "Box Properties",
      order = 60,
      disabled = "HasNoBoxes",
      type = 'group',
      args = {
        show = {
          name = "Show",
          order = 10,
          width = 'half',
          type = 'toggle',
          set = function(info, val) BlackBoxPanels:SetSelectedProperty('show', val) end,
          get = function(info) return BlackBoxPanels:GetSelectedProperty('show') end,
        },
        boxName = {
          name = "Box name",
          order = 20,
          type = 'input',
          set = function(info, val) BlackBoxPanels:SetSelectedProperty('name', val) end,
          get = function(info) return BlackBoxPanels:GetSelectedProperty('name') end,
        },
        showName = {
          name = "Name",
          order = 15,
          width = 'half',
          type = 'toggle',
          set = function(info, val) BlackBoxPanels:SetSelectedProperty('showName', val) end,
          get = function(info) return BlackBoxPanels:GetSelectedProperty('showName') end,
        },
        dimensionsGroup = {
          name = "Dimensions",
          order = 40,
          type = 'group',
          inline = true,
          args = {
            howMuch = {
              name = "Move / increase by",
              order = 30,
              width = 'double',
              type = 'range',
              step = 0.1,
              min = 0.1,
              max = 100,
              set = function(info, val) BlackBoxPanels:SetSelectedProperty('factor', val) end,
              get = function(info) return BlackBoxPanels:GetSelectedProperty('factor') end,
            },
            moveLeft = {
              name = "Left",
              order = 40,
              width = 'half',
              type = 'execute',
              func = "MoveSelectedLeft",
            },
            moveUp = {
              name = "Up",
              order = 50,
              width = 'half',
              type = 'execute',
              func = "MoveSelectedUp",
            },
            moveDown = {
              name = "Down",
              order = 60,
              width = 'half',
              type = 'execute',
              func = "MoveSelectedDown",
            },
            moveRight = {
              name = "Right",
              order = 70,
              width = 'half',
              type = 'execute',
              func = "MoveSelectedRight",
            },
            increaseWidth = {
              name = "+ width",
              order = 90,
              width = 'half',
              type = 'execute',
              func = "IncreaseSelectedWidth",
            },
            decreaseWidth = {
              name = "- width",
              order = 80,
              width = 'half',
              type = 'execute',
              func = "DecreaseSelectedWidth",
            },
            increaseHeight = {
              name = "+ height",
              order = 110,
              width = 'half',
              type = 'execute',
              func = "IncreaseSelectedHeight",
            },
            decreaseHeight = {
              name = "- height",
              order = 100,
              width = 'half',
              type = 'execute',
              func = "DecreaseSelectedHeight",
            },
          },
        },
        depthGroup = {
          name = "Depth Level",
          order = 50,
          type = 'group',
          inline = true,
          args = {
            frameStrata = {
              name = "Frame strata",
              desc = "Move box deeper or higher",
              order = 10,
              type = 'range',
              step = 1,
              min = 1,
              max = 8,
              set = function(info, val) BlackBoxPanels:SetSelectedProperty('strata', val) end,
              get = function(info) return BlackBoxPanels:GetSelectedProperty('strata') end,
            },
            frameLevel = {
              name = "Frame level",
              desc = "Move box deeper or higher than other frames with the same strata",
              order = 20,
              type = 'range',
              step = 1,
              min = 0,
              max = 129,
              set = function(info, val) BlackBoxPanels:SetSelectedProperty('level', val) end,
              get = function(info) return BlackBoxPanels:GetSelectedProperty('level') end,
            },
          },
        },
      },
    },
    boxVisuals = {
      name = "Box Visuals",
      order = 70,
      disabled = "HasNoBoxes",
      type = 'group',
      args = {
        copyOtherBox = {
          name = "Copy visuals from other box",
          order = 10,
          type = 'select',
          values = function(info) return BlackBoxPanels:GetBoxIDs(true) end,
          set = "CopyFromOtherBox",
        },
        vSpace1 = LazyTown:OptionTableVSpace(15),
        backgroundGroup = {
          name = "Background",
          order = 20,
          type = 'group',
          inline = true,
          args = {
            background = {
              name = "Background",
              order = 20,
              type = 'select',
              dialogControl = 'LSM30_Background',
              values = AceGUIWidgetLSMlists.background,
              set = function(info, val) BlackBoxPanels:SetSelectedProperty('background', val) end,
              get = function(info) return BlackBoxPanels:GetSelectedProperty('background') end,
            },
            backgroundColor = {
              name = "Color",
              order = 30,
              type = 'color',
              hasAlpha = true,
              set = function(info, r, g, b, a) BlackBoxPanels:SetSelectedProperty('backgroundColor', {r, g, b, a}) end,
              get = function(info) return unpack(BlackBoxPanels:GetSelectedProperty('backgroundColor')) end,
            },
          },
        },
        borderGroup = {
          name = "Border",
          order = 30,
          type = 'group',
          inline = true,
          args = {
            border = {
              name = "Border",
              order = 10,
              type = 'select',
              dialogControl = 'LSM30_Border',
              values = AceGUIWidgetLSMlists.border,
              set = function(info, val) BlackBoxPanels:SetSelectedProperty('border', val) end,
              get = function(info) return BlackBoxPanels:GetSelectedProperty('border') end,
            },
            color = {
              name = "Color",
              order = 20,
              type = 'color',
              hasAlpha = true,
              set = function(info, r, g, b, a) BlackBoxPanels:SetSelectedProperty('borderColor', {r, g, b, a}) end,
              get = function(info) return unpack(BlackBoxPanels:GetSelectedProperty('borderColor')) end,
            },
          },
        },
      },
    },
  },
}

LazyTown:AddModuleOptions("boxPanelsGroup", moduleOptions)
