
local LTAutomation = _G.LTAutomation

local moduleOptions = {
  name = function(info) return LazyTown:ApplyStateColor("Automation", LTAutomation.db.enabled) end,
  handler = LTAutomation,
  disabled = LazyTown.IsDisabled,
  type = 'group',
  childGroups = 'tab',
  args = {
    enabled = {
      name = "Enabled",
      order = 10,
      type = 'toggle',
      set = "SetModuleState",
      get = function(info) return LTAutomation.db.enabled end,
    },

    generalGroup = {
      name = "General",
      order = 20,
      type = 'group',
      args = {
        repairGroup = {
          name = "Repair",
          order = 50,
          type = 'group',
          inline = true,
          args = {
            repair = {
              name = "Auto Repair",
              order = 10,
              type = 'toggle',
              set = function(info, val) LTAutomation.db.repair = val LTAutomation:UpdateRepair() end,
              get = function(info) return LTAutomation.db.repair end,
            },
            repairGuild = {
              name = "Use guild funds",
              desc = "Try to use guild funds before your own",
              order = 20,
              disabled = function(info) return not LTAutomation.db.repair end,
              type = 'toggle',
              set = function(info, val) LTAutomation.db.repairGuild = val end,
              get = function(info) return LTAutomation.db.repairGuild end,
            },
            repairPrint = {
              name = "Print repair results",
              desc = "Print the results of the attempted repair and why it failed if it did",
              order = 30,
              disabled = function(info) return not LTAutomation.db.repair end,
              type = 'toggle',
              set = function(info, val) LTAutomation.db.repairPrint = val end,
              get = function(info) return LTAutomation.db.repairPrint end,
            },
          },
        },

        releaseGroup = {
          name = "Release Corpse",
          order = 60,
          type = 'group',
          inline = true,
          args = {
            releaseBG = {
              name = "Release in BGs",
              desc = "Automatically release corpse in battlegrounds",
              order = 10,
              type = 'toggle',
              set = function(info, val) LTAutomation.db.releaseBG = val LTAutomation:UpdateRelease() end,
              get = function(info) return LTAutomation.db.releaseBG end,
            },
            releaseDelay = {
              name = "Release delay in seconds",
              order = 20,
              type = 'range',
              step = 0.05,
              min = 0,
              max = 5,
              set = function(info, val) LTAutomation.db.releaseTime = val end,
              get = function(info) return LTAutomation.db.releaseTime end,
            },
          },
        },
        confirmGroup = {
          name = "Auto confirm",
          order = 70,
          type = 'group',
          inline = true,
          args = {
            confirmRollSolo = {
              name = "Confirm Bind On Pickup",
              order = 10,
              type = 'toggle',
              set = function(info, val) LTAutomation.db.confirmBOP = val LTAutomation:UpdateConfirm() end,
              get = function(info) return LTAutomation.db.confirmBOP end,
            },
            confirmRollParty = {
              name = "Confirm Roll on loot",
              order = 30,
              type = 'toggle',
              set = function(info, val) LTAutomation.db.confirmRoll = val LTAutomation:UpdateConfirm() end,
              get = function(info) return LTAutomation.db.confirmRoll end,
            },
            confirmReplaceEnchant = {
              name = "Replace Enchant",
              order = 20,
              type = 'toggle',
              set = function(info, val) LTAutomation.db.confirmReplace = val LTAutomation:UpdateConfirm() end,
              get = function(info) return LTAutomation.db.confirmReplace end,
            },
            onlyIfSameEnchant = {
              name = "Only if same enchant",
              order = 40,
              disabled = function(info) return not LTAutomation.db.confirmReplace end,
              type = 'toggle',
              set = function(info, val) LTAutomation.db.sameEnchant = val end,
              get = function(info) return LTAutomation.db.sameEnchant end,
            },
          },
        },
      },
    },
    mailGroup = {
    name = "Mail",
    type = 'group',
    args = {
      auctionHouse = {
        name = "Auction house",
        order = 10,
        type = 'group',
        inline = true,
        args = {
          takeSaleGold = {
            name = "Take sale gold",
            order = 10,
            type = 'toggle',
            set = function(info, val) LTAutomation.db.takeSaleGold = val LTAutomation:UpdateMail() end,
            get = function(info) return LTAutomation.db.takeSaleGold end,
          },
          takeOutbidGold = {
            name = "Take outbid gold",
            order = 20,
            type = 'toggle',
            set = function(info, val) LTAutomation.db.takeOutbidGold = val LTAutomation:UpdateMail() end,
            get = function(info) return LTAutomation.db.takeOutbidGold end,
          },
          takeBoughtItems = {
            name = "Take bought items",
            order = 30,
            type = 'toggle',
            set = function(info, val) LTAutomation.db.takeBoughtItems = val LTAutomation:UpdateMail() end,
            get = function(info) return LTAutomation.db.takeBoughtItems end,
          },
          takeExpiredItems = {
            name = "Take expired items",
            order = 40,
            type = 'toggle',
            set = function(info, val) LTAutomation.db.takeExpiredItems = val LTAutomation:UpdateMail() end,
            get = function(info) return LTAutomation.db.takeExpiredItems end,
          },
          takeCancelledItems = {
            name = "Take cancelled items",
            order = 50,
            type = 'toggle',
            set = function(info, val) LTAutomation.db.takeCancelledItems = val LTAutomation:UpdateMail() end,
            get = function(info) return LTAutomation.db.takeCancelledItems end,
          },
        },
      },
      printSummary = {
        name = "Print summary",
        order = 30,
        type = 'toggle',
        set = function(info, val) LTAutomation.db.printSummary = val end,
        get = function(info) return LTAutomation.db.printSummary end,
      },
    },
  },
    questGroup = {
      name = "Quest",
      type = 'group',
      args = {
        autoAccept = {
          name = "Auto Accept",
          order = 10,
          type = 'toggle',
          set = function(info, val) LTAutomation.db.qAccept = val LTAutomation:UpdateQuest() end,
          get = function(info) return LTAutomation.db.qAccept end,
        },
        autoTurnIn = {
          name = "Auto Turn In",
          order = 30,
          type = 'toggle',
          set = function(info, val) LTAutomation.db.qTurnIn = val LTAutomation:UpdateQuest() end,
          get = function(info) return LTAutomation.db.qTurnIn end,
        },
        autoConfirmQuests = {
          name = "Auto Confirm",
          desc = "Automatically confirm joining in on escort quests and similar",
          order = 50,
          type = 'toggle',
          set = function(info, val) LTAutomation.db.qConfirm = val LTAutomation:UpdateQuest() end,
          get = function(info) return LTAutomation.db.qConfirm end,
        },
        objTooltipGroup = {
          name = "Objective Tooltip",
          order = 60,
          type = 'group',
          inline = true,
          args = {
            showObjective = {
              name = "Enable objective tooltip",
              desc = "Displays the quest title and objective in a tooltip for a duration",
              order = 10,
              width = 'double',
              type = 'toggle',
              set = function(info, val) LTAutomation.db.objTooltip.enabled = val LTAutomation:UpdateObjTooltip() end,
              get = function(info) return LTAutomation.db.objTooltip.enabled end,
            },
            tooltipScale = {
              name = "Scale",
              order = 20,
              type = 'range',
              step = 0.01,
              min = 0.4,
              max = 1.6,
              set = function(info, val) LTAutomation.db.objTooltip.scale = val LTAutomation:UpdateObjTooltip() end,
              get = function(info) return LTAutomation.db.objTooltip.scale end,
            },
            tooltipAlpha = {
              name = "Normal Alpha",
              order = 30,
              type = 'range',
              step = 0.01,
              min = 0.25,
              max = 1,
              set = function(info, val) LTAutomation.db.objTooltip.alpha = val LTAutomation:UpdateObjTooltip() end,
              get = function(info) return LTAutomation.db.objTooltip.alpha end,
            },
            tooltipBeforeFade = {
              name = "Time Before Fade",
              desc = "Time before the tooltip starts fading (in seconds)",
              order = 40,
              type = 'range',
              step = 0.2,
              min = 0,
              max = 30,
              set = function(info, val) LTAutomation.db.objTooltip.timeBeforeFade = val end,
              get = function(info) return LTAutomation.db.objTooltip.timeBeforeFade end,
            },
            tooltipFadeTime = {
              name = "Fade Time",
              desc = "Duration of the fading, from visible to invisible (in seconds)",
              order = 50,
              type = 'range',
              step = 0.2,
              min = 0,
              max = 20,
              set = function(info, val) LTAutomation.db.objTooltip.fadeTime = val end,
              get = function(info) return LTAutomation.db.objTooltip.fadeTime end,
            },
          },
        },
      },
    },
    partyGroup = {
      name = "Party & Raid",
      type = 'group',
      args = {
        whoParty = {
          name = "/who on invites",
          desc = "Do a /who on the player inviting you to a party or raid, unless you are friends or in the same guild",
          order = 10,
          type = 'toggle',
          set = function(info, val) LTAutomation.db.whoParty = val end,
          get = function(info) return LTAutomation.db.whoParty end,
        },
        vSpace1 = LazyTown:OptionTableVSpace(15),
        autoAccept = {
          name = "Auto-accept invites from",
          order = 20,
          type = 'multiselect',
          values = function(info)   local t = {}   for k, v in pairs(LTAutomation.db.autoAccept) do   t[k] = k   end   return t   end,
          set = function(info, key, val) if key ~= 'Guild' and key ~= 'Friends' and not val then   val = nil   end   LTAutomation.db.autoAccept[key] = val end,
          get = function(info, key) return LTAutomation.db.autoAccept[key] end,
        },
        nameInput = {
          name = "Add player:",
          desc = "N.B. Input is case sensitive.",
          order = 30,
          type = 'input',
          set = function(info, val) LTAutomation.db.autoAccept[val:match("^%s*(.-)%s*$")] = true end,
          get = function(info) return "" end,
        },
      },
    },
    blockGroup = {
      name = "Block",
      type = 'group',
      args = {
        blockDuels = {
          name = "Block Duels",
          order = 10,
          type = 'toggle',
          set = function(info, val) LTAutomation.db.blockDuels = val LTAutomation:UpdateBlocks() end,
          get = function(info) return LTAutomation.db.blockDuels end,
        },
        duelFilter = {
          name = "Except from",
          order = 15,
          type = 'select',
          values = {
            friendsGuild = "Friends & Guild",
            friends = "Friends",
            noExceptions = "No exceptions",
          },
          set = function(info, val) LTAutomation.db.duelsFilter = val end,
          get = function(info) return LTAutomation.db.duelsFilter end,
        },
        blockTrades = {
          name = "Block Trades*",
          desc = "Warning: You won't be able to initiate trade with these people as well.",
          order = 20,
          type = 'toggle',
          set = function(info, val) LTAutomation.db.blockTrades = val LTAutomation:UpdateBlocks() end,
          get = function(info) return LTAutomation.db.blockTrades end,
        },
        tradeFilter = {
          name = "Except from",
          order = 25,
          type = 'select',
          values = {
            friendsGuild = "Friends & Guild",
            friends = "Friends",
            noExceptions = "No exceptions",
          },
          set = function(info, val) LTAutomation.db.tradesFilter = val end,
          get = function(info) return LTAutomation.db.tradesFilter end,
        },
        blockGuildInvites = {
          name = "Block Guild invites",
          order = 30,
          type = 'toggle',
          set = function(info, val) LTAutomation.db.blockGInvites = val LTAutomation:UpdateBlocks() end,
          get = function(info) return LTAutomation.db.blockGInvites end,
        },
        gInvitesFilter = {
          name = "Except from",
          order = 35,
          type = 'select',
          values = {
            friends = "Friends",
            noExceptions = "No exceptions",
          },
          set = function(info, val) LTAutomation.db.gInvitesFilter = val end,
          get = function(info) return LTAutomation.db.gInvitesFilter end,
        },
        blockGuildPetitions = {
          name = "Block Guild petitions",
          order = 40,
          type = 'toggle',
          set = function(info, val) LTAutomation.db.blockGPetitions = val LTAutomation:UpdateBlocks() end,
          get = function(info) return LTAutomation.db.blockGPetitions end,
        },
        gPetitionsFilter = {
          name = "Except from",
          order = 45,
          type = 'select',
          values = {
            friends = "Friends",
            noExceptions = "No exceptions",
          },
          set = function(info, val) LTAutomation.db.gPetitionsFilter = val end,
          get = function(info) return LTAutomation.db.gPetitionsFilter end,
        },
      },
    },
  },
}

LazyTown:AddModuleOptions("automationGroup", moduleOptions)
