--[[
Name: ItemPrice-1.1
Revision: $Rev: 50 $
Author(s): Bam
Credits: Jerry (helped improve compression technique)
Documentation: http://www.wowace.com/wiki/ItemPrice-1.1
SVN: http://svn.wowace.com/wowace/trunk/ItemPrice-1.1
Description: Library with vendor sell prices for items.
Dependencies: LibStub
License: LGPL v2.1
]]

local Lib = LibStub:NewLibrary("ItemPrice-1.1", tonumber(("$Revision: 50 $"):match("(%d+)")) + 90000)
if not Lib then return end

local _G = getfenv()
local type, tonumber = type, tonumber
local match = string.match

local price_count, get

function Lib:GetPriceById(itemId)
  return get(itemId)
end

function Lib:GetPrice(item)
  local t = type(item)
  if t == "number" then return get(item) end
  if t == "string" then return get(tonumber(item) or tonumber(match(item, "item:(%d+)"))) end
end

function Lib:GetPriceCount()
  return price_count
end

do
  local prices = "\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\7\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\9\0\0\7\0\0\7\0\0\1\0\0\1\0\0\1\0\0\0\0\0\0\0\0\1\0\0\1\0\0\1\0\0\0\0\0\1\0\0\1\0\0\1\0\0\0\0\0\1\0\0\1\0\0\1\0\0\0\0\0\1\0\0\1\0\0\1\0\0\0\0\0\1\0\0\12\0\0\12\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\10\0\0\7\0\0\0\0\0\0\0\0\0\0\0\0\0\0\12\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\1\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\1\0\0\5\0\0\0\0\0\1\0\0\1\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\1\0\0\0\0\0\1\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\1\0\0\1\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\1\0\0\1\0\0\0\0\0\0\0\0\0\0\0\0\0\0\1\0\0\1\0\0\0\0\0\0\0\0\0\0\0\0\0\0\1\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0zzz\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\9\0\0\9\0\0\7\0\0\0\0\0\0\0\0\0\0\0\0\0\1\198\0\1\199\0\1\87\0\0\229\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\12\0\0\9\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\2\47\0\2\49\0\1\166\0\1\26\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\2\199\0\2\133\0\1\232\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\6\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\25\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\87\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\8\0\0\106\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\1\17\136\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\72\0\0\5\0\0\0\0\0\0\0\0\6\0\0\0\0\0\0\0\0\0\0\1\66\0\0\4\0\4\46\0\0\0\0\0\0\0\0\15\0\0\25zzz\0\0\0\0\0\245\0\0\50\0\0\17\0\0\16\0\0\27\0\0\6\0\0\100\0\0\0zzz\0\0\0zzzzzzzzzzzz\0\0\0zzzzzz\0\39\16zzz\0\0\0\0\0\0zzz\0\0\0zzz\0\0\0zzz\0\15\2\0\92\4\0\0\1\0\19\99\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\58\0\0\0\0\0\10\0\0\57\0\0\100\0\0\113\0\0\3\0\1\60\0\0\38zzzzzz\0\0\15\0\0\0\0\22\133\0\0\21\0\0\55\0\0\18zzz\0\0\110zzz\0\0\50\0\0\0\0\0\20\0\0\0\0\0\1\0\0\0\0\7\177\0\7\228\0\27\157\0\0\41\0\0\27\0\0\56\0\0\56\0\0\52\0\0\35\0\0\71\0\0\71\0\0\0\0\0\0\0\0\0\0\0\0\0\9\196\0\0\250\0\0\0\0\0\0\0\0\0\0\152\213\0\176\211\0\211\107\0\222\186\0\0\0\0\0\25\0\0\0\0\1\49\0\0\0\0\0\100\0\0\0\0\3\179\0\0\249\0\0\0\0\0\0\0\0\0\0\0\0\0\2\220\0\3\203\0\0\250zzz\0\0\0\0\0\0\0\0\203\0\109\96\0\0\0\0\0\23\0\0\0\0\0\225\0\0\225\0\0\113\0\0\170zzz\0\0\0\0\0\215\0\0\144\0\1\33\0\1\34\0\1\93\0\1\95\0\1\9\0\0\176\0\1\148\0\1\91\0\1\225\0\2\92\0\0\0\0\3\107\0\9\196\0\0\25\0\0\87\0\0\89\0\0\0\0\149\78\0\35\4\0\37\244\0\19\232\0\65\0\0\20\224\0\84\29\0\72\97\0\84\24\0\115\188\0\9\110\0\85\10\0\0\0\0\0\0\0\0\0\0\0\0\0\0\56\0\0\0\0\10\132\0\0\0\0\0\0\0\0\0zzz\0\8\253\0\11\133\0\0\82\0\3\212zzz\0\13\189\0\0\0\0\1\114\0\0\137\0\0\0\0\0\0\0\0\0\0\3\254\0\0\0\0\4\224\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0zzz\0\12\252\0\0\0\0\0\0\0\10\109zzzzzz\0\0\0\0\4\226\0\0\0\0\11\5zzz\0\9\103\0\6\212\0\8\146\0\6\23\0\7\165\0\5\110\0\7\180\0\0\75\0\0\0\0\0\0\0\2\125\0\9\196\0\41\186\0\6\206\0\45\100\0\56\241zzzzzz\0\49\22\0\0\0\0\17\148\0\167\111\1\57\25\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\50\0\0\37\0\0\0zzz\0\0\0\0\0\0\0\0\0\0\0\2zzz\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0zzz\0\0\0\0\0\21\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0zzz\0\0\0\0\0\144\0\1\234\0\0\99\0\0\80\0\0\0zzz\0\0\0\0\0\24\0\0\0\0\0\100\0\0\0zzz\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0zzz\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\1\235zzz\0\2\138\0\0\25\0\0\0\0\0\0\0\0\78\0\0\50\0\0\150zzz\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0zzzzzz\0\0\0\0\4\226\0\0\0\0\0\0\0\0\0\0\0\0\0\4\51\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\25\0\0\0zzzzzz\0\4\112zzz\0\0\0zzz\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\102\0\23\66\0\3\44\0\0\0\0\0\146\0\0\32\0\0\0\0\0\25\0\0\0\0\0\0\0\0\0\0\0\0\0\0\16\0\0\96\0\165\56\0\73\127\0\0\0\0\0\55\0\3\200\0\0\52\0\0\0\0\0\28\0\0\0\0\0\3\0\0\7\0\0\6\0\0\37\0\0\25\0\0\44\0\0\29\0\0\0\0\0\0\0\0\0\0\4\57\0\0\0\0\2\113\0\1\162\0\0\82\0\0\0\0\1\99\0\0\20\0\0\47\0\1\186\0\2\21\0\2\23\0\0\0\0\0\16\0\0\94\0\1\111\0\91\209\0\49\33\0\0\25\0\1\144\0\38\164zzz\0\0\0\0\0\250\0\1\91\0\0\21\0\0\87\0\3\162\0\1\213\0\0\0\0\0\0\0\8\16\0\3\55\0\7\15zzz\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\8zzz\0\0\0zzz\0\0\0zzzzzz\0\0\0\0\0\0zzzzzz\0\0\111\1\52\216\0\14\87\0\45\255\0\0\0\0\0\0\0\0\0\0\0\0\0\0\213\0\0\0\0\0\0\0\6\120\0\0\8\0\6\132\0\8\172\0\0\0\0\0\0\0\0\0\0\14\112\0\0\0\0\11\9zzzzzz\0\0\0\0\0\0\0\2\191\0\0\185\0\0\0\0\0\0\0\0\0\0\12\228zzzzzz\0\0\0\0\6\145\0\7\246\0\0\0\0\1\134\0\7\62\0\0\0\0\1\6\0\1\162\0\1\23\0\0\0\0\1\96zzz\0\0\0zzz\0\2\203\0\0\0\0\0\0\0\0\0\0\1\106\0\50\200\0\0\0\0\13\172\0\11\250\0\1\206\0\0\0\0\0\0\0\0\68\0\0\0\0\0\0zzz\0\0\10zzz\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0zzz\0\0\0\0\3\0\0\0\0zzz\0\0\0\0\0\201\0\0\0zzzzzz\0\0\19\0\0\42zzzzzz\0\0\0\0\0\8\0\0\0\0\0\2\0\0\2\0\0\2\0\0\4\0\0\2\0\0\0\0\0\2\0\0\0\0\0\3\0\0\0\0\0\4\0\0\1\0\0\1\0\0\0\0\0\4zzz\0\0\24\0\0\25\0\0\11\0\0\0\0\0\32\0\6\42\0\0\14\0\0\58\0\0\0\0\5\112\0\0\0\0\0\0\0\2\228\0\0\1\0\0\1\0\0\0\0\0\0\0\0\12\0\0\0\0\0\14\0\0\0\0\0\0\0\40\66\0\4\160\0\8\31zzzzzzzzzzzz\0\0\68\0\0\49\0\0\55\0\0\97\0\0\72\0\0\72\0\0\65\0\0\9\0\0\19\0\0\18\0\0\28\0\0\6\0\0\19\0\0\0\0\0\37\0\0\0\0\0\29\0\0\0\0\0\7\0\0\7\0\0\20\0\0\0\0\0\14\0\0\43\0\0\0\0\1\202\0\0\0\0\0\70\0\0\0\0\4\206\0\0\0\0\0\0\0\82\133\0\0\0\0\2\72\0\2\56\0\88\247\0\1\149\0\7\83\0\0\0zzz\0\0\0zzz\0\15\97\0\11\115\0\0\0\0\7\58\0\10\63\0\9\76\0\6\232\0\13\59\0\5\26\0\0\0\0\0\71\0\38\97\0\0\0zzz\0\0\28\0\4\156\0\3\107\0\0\0\0\0\0\0\5\217\0\0\0\0\0\82\0\0\6\0\0\87\0\0\62\0\0\47\0\3\186\0\13\9\0\11\148\0\7\233\0\11\106\0\5\130\0\4\178zzz\0\13\51\0\6\17\0\34\206\0\8\159\0\0\0\0\15\82\0\0\0\0\0\59\0\0\0\0\0\71\0\0\57\0\0\51\0\0\0\0\0\80\0\0\60\0\0\109\0\0\32\0\0\48\0\0\51\0\0\123\0\0\0\0\0\59\0\0\150\0\0\194\0\0\194\0\1\37\0\1\38\0\0\196\0\0\237\0\0\0zzzzzz\0\0\71\0\75\5\0\39\240\0\40\21zzz\0\0\0\0\0\0\0\0\0zzz\0\2\188\0\0\0\0\0\0zzz\0\0\0\0\0\0\0\0\0\0\0\0\0\0\62\0\0\0\0\6\36\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\10\235\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\3\151\0\0\0\0\0\0\0\2\1\0\1\12\0\0\0\0\0\0\0\0\0\0\0\0\0\4\108\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0zzz\0\0\0zzz\0\0\0\0\0\0\0\0\0\0\45\165\0\0\0\0\76\8\0\0\0\0\0\0\0\169\156\0\73\252\0\0\0\0\0\0\0\0\0\0\0\0\0\74\195\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\24\28\0\57\162\0\0\0\0\0\0\0\0\0\0\0\0\0\0\66\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0zzz\0\0\0\0\111\44\0\61\21\0\0\0\0\0\0\0\0\0\0\0\0\0\0\100\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\19\136\0\0\0\0\0\0\0\0\0zzz\0\0\0\0\0\0\0\8\88\0\0\0\0\0\0\0\0\0\0\0\0\0\57\103\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\39\109\0\17\229\0\37\163\0\71\58\0\0\0\0\0\0\0\0\0\0\0\0\0\24\106\0\2\221\0\0\243\0\3\38\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\2\94\0\1\189\0\0\0\0\0\0\0\0\0\0\1\120\0\1\64\0\0\81\0\0\0\0\2\88\0\0\86\0\0\62\0\0\50\0\0\0\0\0\125\0\0\75\0\0\62\0\20\230\0\9\231\0\40\61\0\19\203\0\12\36\0\31\104\0\0\0\0\102\97\0\139\231\0\75\207\0\0\0\0\0\0\0\19\136\0\47\151\0\17\210\1\28\232\0\1\244\0\0\48\0\0\92\0\0\73\0\0\88\0\0\39\0\0\89\0\0\0\0\0\139\0\0\147\0\0\255\0\0\97\0\0\112\0\0\129\0\1\43\0\1\4\0\0\198\0\1\76\0\1\46\0\0\232\0\1\7\0\1\42\0\2\164\0\1\30\0\1\183\0\1\103\0\2\85\0\1\182\0\1\227\0\2\22\0\2\220\0\2\97\0\3\124\0\0\0\0\0\0\0\0\113\0\0\0\0\0\131\0\0\101\0\0\217\0\0\163\0\0\143\0\0\0\0\0\247\0\0\0\0\1\25\0\0\212\0\1\1\0\0\222\0\1\81\0\0\0\0\1\233\0\0\0\0\2\30\0\0\247\0\2\34\0\1\208\0\2\171\0\0\102\0\0\177\0\0\136\0\0\93\0\0\90\0\0\208\0\0\207\0\1\21\0\0\235\0\1\144\0\0\161\0\0\223\0\0\211\0\1\223\0\1\162\0\1\81\0\1\209\0\1\222\0\1\95\0\1\210\0\1\132\0\3\88\0\1\184\0\2\136\0\1\195\0\1\197\0\2\11\0\2\91\0\1\110\0\1\230\0\1\245\0\4\197\0\3\0\0\3\195\0\3\220\0\4\72\0\3\11\0\4\80\0\6\12\0\6\229\0\5\2\0\6\73\0\6\27\0\6\247\0\6\254\0\1\106\0\0\0\0\0\0\0\0\6\0\0\6\0\0\0\0\0\0\0\0\37\0\0\37\0\0\0\0\0\0\0\0\145\0\0\145\0\0\175\0\0\176\0\0\0\0\0\0\0\1\21\0\1\22\0\0\0\0\1\80\0\1\82\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0zzz\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\6\239zzz\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\148\0\0\0\0\0\0\0\0\0\0\0\251\0\0\0\0\0\0\0\0\0\0\0\0zzzzzz\0\0\0\0\3\19\0\2\175\0\2\178\0\3\228\0\1\178\0\1\71zzz\0\0\0\0\3\137\0\2\219\0\11\158\0\4\90\0\7\248\0\7\170\0\0\168\0\0\0\0\0\203\0\1\60\0\2\201\0\1\3\0\1\11zzz\0\0\0\0\0\0\0\0\0\0\0\0\0\4\234\0\0\0\0\0\0\0\0\0\0\6\37zzz\0\0\0\0\3\207\0\4\199\0\0\0\0\0\0zzz\0\0\0\0\0\0\0\0\36\0\0\0\0\0\0zzz\0\0\0\0\0\120zzzzzz\0\18\10\0\1\208\0\22\112\0\24\196\0\0\0\0\3\213\0\90\234\0\24\56\0\55\33\0\115\73\0\0\0\0\0\0\0\0\0\0\58\13zzz\0\11\36\0\0\0\0\39\93\0\32\165\0\21\92\0\8\52\0\65\56\0\0\0\0\6\184\0\9\235\0\28\71\0\0\0\0\34\123\0\0\0\0\0\0\0\0\0zzzzzzzzzzzzzzz\0\0\0\0\0\0\0\15\0\0\0\0\0\14\60\0\19\5\0\17\91\0\0\0\0\3\127\0\12\197\0\0\0\0\4\26\0\4\1\0\0\0\0\0\0\0\4\191\0\4\37\0\4\233\0\2\251\0\3\245\0\3\116\0\4\85\0\0\0\0\6\129\0\3\199\0\4\11\0\8\252\0\1\2\0\1\213\0\0\0\0\2\238\0\59\192\0\5\132\0\14\55\0\5\220\0\34\125\0\0\0\0\9\157\0\0\26\0\0\26\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\16\0\0\16\0\0\0\0\0\16\0\16\101\0\3\95\0\0\0\0\0\0\0\0\0\0\0\0\0\0\191\0\0\113\0\0\81\0\0\186\0\0\0\0\0\122\0\0\1\0\0\0\0\17\62\0\2\230\0\4\30\0\1\130\0\0\0\0\19\195\0\4\46\0\3\166\0\25\190\0\0\0\0\0\250\0\0\0\0\22\77\0\0\15\0\0\0\0\0\252\0\2\217\0\4\89\0\0\0\0\0\213\0\0\7\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\11\205\0\175\240\0\95\220\0\0\1\0\0\1\0\0\0\0\0\0\0\0\1\0\0\0\0\0\0\0\0\8\0\0\14\0\0\6\0\0\0\0\0\54zzz\0\0\31\0\0\0\0\0\0\0\0\7\0\0\0\0\0\5\0\0\10\0\0\10\0\0\6\0\0\9\0\0\6\0\0\6\0\0\12\0\0\12\0\0\0\0\0\15\0\0\10\0\0\10\0\0\20\0\0\15\0\0\16\0\0\0zzz\0\0\25\0\0\38\0\0\11\0\1\67\0\4\20\0\2\12\0\3\21\0\2\15\0\2\17\0\3\193\0\0\0\0\2\69\0\3\111\0\2\74\0\2\76\0\4\157\0\4\161zzz\0\0\0\0\2\103\0\0\0\0\1\157\0\3\61\0\3\64zzzzzz\0\182\118\0\105\152\0\0\45\0\3\43\0\1\83\0\1\213\0\7\95\0\0\0\0\0\0\0\0\7\0\0\6\0\0\0\0\10\123\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\6zzzzzz\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\12\204\0\0\25\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\5\212\0\4\109\0\15\121\0\0\0\0\1\222\0\2\218\0\5\143\0\0\3\0\0\7\0\0\16\0\0\24\0\0\182\0\0\81\0\0\210\0\0\243\0\1\245\0\1\201\0\2\7\0\3\142\0\3\237zzz\0\0\24\0\0\183\0\16\22\0\16\37\0\0\0\0\0\0\0\2\202\0\17\34\0\3\45\0\6\154\0\7\14\0\5\1\0\13\58\0\0\75\0\0\60zzz\0\0\121\0\1\152\0\0\0\1\0\247\0\202\146\0\107\244\0\117\48\0\0\0\0\0\0\0\0\91zzz\0\0\12zzz\0\0\0\0\1\250\0\0\0\0\11\180\0\0\189\0\0\83\0\0\75\0\0\106\0\0\0\0\34\42\0\10\59\0\7\165\0\1\221\0\1\223\0\2\199\0\0\146\0\0\0\0\0\0\0\12\183\0\0\0\0\0\0\0\1\33\0\0\0\0\15\253\0\14\36\0\9\22\0\0\0\0\18\220\0\1\44\0\0\139\0\0\140\0\0\211\0\0\0\0\0\0\0\0\6zzz\0\0\87\0\0\75\0\174\36\0\5\54\0\0\0\0\0\0\0\0\70\0\0\50\0\0\0\0\0\0\0\34\53\0\0\192\0\0\0\0\0\29\0\0\71\0\0\15\0\0\0\0\0\0\0\0\243\0\0\214\0\1\12\0\0\89\0\0\150\0\0\181\0\0\200\0\2\231\0\1\51\0\1\70\0\2\177\0\0\15\0\0\50\0\0\2\0\0\25\0\0\0\0\0\0\0\0\6\0\0\250\0\0\29\0\0\36\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\9\0\0\1\0\0\0\0\0\59\0\0\0\0\0\59\0\0\44\0\0\0\0\0\30\0\0\75\0\0\37\0\0\68\0\0\51\0\0\34\0\0\34\0\0\89\0\0\89zzz\0\0\15\0\0\7\0\0\15zzz\0\0\11\0\0\7\0\0\7\0\0\15\0\0\7\0\0\15\0\0\11\0\0\7\0\0\7\0\0\82\0\0\41\0\0\83\0\0\64\0\0\43\0\0\43\0\0\86\0\0\43\0\0\87\0\0\66\0\0\44\0\0\44\0\0\0\0\0\0\0\0\25\0\0\162\0\0\125\0\1\94\0\0\0zzz\0\0\0\0\0\0zzz\0\0\0\0\0\0\0\12\62\0\12\74\0\6\43\0\9\83\0\6\54\0\6\60\0\33\106\0\16\196\0\33\167\0\25\113\0\15\189\0\15\204\0\7\235\0\0\0\0\7\251\0\6\2\0\0\0\0\4\9\0\21\160\0\0\0\0\21\202\0\16\103\0\0\0\0\11\3\0\2\217\0\5\32\0\0\0\0\0\0\0\2\174\0\4\212\0\0\10\0\12\159\0\0\20\0\0\25\0\34\21\0\0\15\0\0\25\0\0\20\0\0\10\0\0\15\0\0\15\0\0\15\0\0\25\0\0\0\0\0\0\0\0\0\0\10\179\0\5\94\0\9\191zzz\0\7\94\0\4\238\0\4\243\0\26\134\0\13\80\0\26\186\0\20\30\0\13\118\0\13\131zzz\0\0\0\0\0\0\0\0\21\0\0\14\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\107\0\0\68\0\0\108\0\0\96\0\0\57\0\0\140\0\0\80\0\0\101\0\0\0\0\0\0\0\0\0\0\0\0\0\0\58\0\0\0\0\0\0\0\0\0\0\0\5\0\0\12\0\0\57\0\1\94\0\0\5\0\0\82\0\0\8\0\1\8zzz\0\0\0\0\0\0zzzzzz\0\0\0\0\0\0zzz\0\19\61\0\24\35\0\17\157\0\22\25\0\14\254\0\20\178\0\15\27\0\22\239\0\40\127\0\50\206\0\40\204\0\43\226\0\41\25\0\47\189\0\35\126\0\48\23zzz\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\7\5\0\0\55\0\0\7zzz\0\19\152\0\0\0\0\0\0\0\0\0\0\0\25\0\0\0\0\0\40\0\0\0\0\0\0\0\0\0\0\0\0zzzzzz\0\2\63zzz\0\26\161\0\12\41\0\5\42\0\9\205\0\0\31\0\0\87\0\0\11\0\0\17\0\0\99\0\0\0\0\0\0\0\0\25\0\0\75\0\0\75\0\0\224\0\0\37\0\0\67\0\0\20\0\0\216\0\1\103\0\0\142\0\2\126\0\0\0\0\0\200\0\0\0\0\0\13\0\0\5\0\0\5\0\0\33\0\0\37\0\1\119\0\1\244\0\0\30\0\0\0\0\0\30\0\0\0\0\0\0\0\0\100\0\0\0\0\0\0\0\0\12\0\0\25zzzzzz\0\0\63zzzzzzzzz\0\0\32\0\0\121\0\0\232\0\3\250\0\2\20\0\8\150\0\20\208zzz\0\11\197\0\9\53\0\10\43\0\13\226\0\15\12zzz\0\0\0\0\0\0zzzzzz\0\0\0\0\0\0\0\2\93\0\0\25zzz\0\0\16zzzzzz\0\0\0zzzzzz\0\0\0\0\0\33\0\0\28\0\0\7\0\0\11\0\0\32\0\0\0\0\0\58\0\0\1\0\0\3\0\0\3\0\0\4\0\0\3\0\0\2\0\0\0\0\0\9\0\3\107zzzzzzzzzzzz\0\34\46\0\34\46\0\0\0\0\0\5zzzzzz\0\0\0\0\0\0\0\0\0zzz\0\0\4\0\0\10\0\0\12\0\0\11zzz\0\0\15zzz\0\0\5\0\0\10\0\0\6\0\0\25\0\0\25\0\0\20\0\0\75\0\0\12\0\0\25\0\0\0\0\0\0\0\0\7\0\0\10\0\0\10\0\0\0\0\2\27\0\0\0zzz\0\0\100\0\0\100\0\0\200\0\0\100\0\1\144zzz\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0zzzzzz\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0zzzzzz\0\7\190zzz\0\0\12zzz\0\1\119\0\0\0\0\0\0\0\1\119\0\0\0\0\1\119\0\0\0\0\1\119\0\0\0\0\1\119\0\1\119\0\0\0\0\0\0\0\1\119\0\0\0\0\1\119\0\0\0\0\1\119\0\0\0\0\1\119\0\1\119\0\0\0\0\0\0\0\1\119\0\1\119\0\1\119\0\1\119\0\0\0\0\0\0\0\0\13\0\0\0zzzzzzzzzzzzzzz\0\0\0\0\0\0\0\0\240\0\1\184\0\3\43\0\6\28\0\0\0\0\0\0\0\0\0\0\0\5\0\0\25\0\0\150\0\0\39\0\0\28\0\0\75\0\1\244\0\0\147\0\0\147zzz\0\1\118\0\1\79\0\2\239\0\2\78zzz\0\4\38\0\4\149\0\0\10zzz\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0zzzzzz\0\0\0zzz\0\0\25\0\0\67\0\5\245\1\99\98\0\6\89\0\0\0\0\0\0\0\7\90zzz\0\9\148\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\77\66\0\28\156\0\0\201\0\1\107\0\14\246\0\18\54\0\4\94\0\5\122\0\6\82\0\125\32\0\57\130\0\0\0\0\0\0zzzzzzzzzzzzzzzzzzzzz\0\0\2\0\0\15zzz\0\0\60zzz\0\0\10\0\0\50\0\0\100zzz\0\0\106\0\0\109zzz\0\0\110\0\4\95\0\4\245\0\5\159\0\0\56\0\0\67\0\0\17\0\0\225zzzzzz\0\0\198zzzzzz\0\0\0\0\0\0\0\0\3\0\0\10\0\2\118\0\3\194\0\2\241\0\0\0\0\3\39\0\7\39\0\11\119\0\0\40zzz\0\0\0zzzzzzzzz\0\33\76\0\20\23\0\12\49\0\0\25\0\0\150\0\1\44\0\1\119\0\0\0zzz\0\0\5\0\0\0\0\0\10\0\0\60\0\0\0\0\0\0\0\0\30\0\0\55\0\0\12\0\0\0\0\0\0\0\0\0\0\0\32\0\0\169\0\0\89\0\0\16\0\5\25\0\2\3\0\2\83\0\0\42\0\7\18\0\6\219\0\5\129zzz\0\4\233\0\2\12\0\26\75\0\4\129\0\0\0\0\215\249\0\17\53\0\2\153\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\16zzzzzz\0\0\0\0\0\5\0\0\0\0\0\12\0\0\250\0\0\0\0\14\166\0\0\7\0\0\0\0\0\0\0\0\0\0\0\0zzz\0\0\43\0\13\224\0\14\79\0\2\25zzz\0\0\0zzzzzz\0\0\0\0\4\15\0\13\148\0\2\144\0\0\0\0\7\65\0\9\181\0\13\121zzz\0\0\119\0\0\94\0\0\32\0\0\22\0\0\155\0\0\120\0\0\41\0\0\36\0\0\189\0\0\146\0\0\66\0\0\34\0\1\125\0\1\77\0\0\109\0\0\72\0\1\228\0\1\136\0\0\128\0\0\172\0\1\220\0\1\159\0\0\157\0\0\209\0\2\136\0\2\54\0\1\24\0\0\215\0\3\54\0\2\206\0\1\152\0\1\58\0\3\233\0\3\165\0\2\193\0\1\152\0\0\0\0\0\0\0\0\0\0\0\40\0\0\100zzzzzz\0\0\119\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\34\0\0\0\0\0\101\0\11\31\0\0\50\0\0\25zzz\0\0\0zzzzzz\0\2\113\0\1\167\0\10\95\0\9\117\0\4\61\0\2\242\0\5\139\0\14\111\0\2\250\0\4\245\0\0\0\0\0\0zzz\0\0\0\0\0\0zzz\0\0\0zzz\0\2\3\0\18\206\0\0\0\0\6\74\0\3\172\0\14\185\0\17\225\0\0\0\0\0\0\0\6\38\0\0\0\0\4\28\0\7\127\0\8\71\0\0\0\0\0\0\0\0\0\0\8\92\0\0\0\0\5\246\0\5\252\0\3\135\0\2\170\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\2\146\0\1\241\0\4\251\0\0\0\0\5\132\0\0\7\0\0\231\0\4\183\0\4\187\0\1\220\0\58\225\0\2\124\0\0\0\0\10\217\0\1\41zzzzzzzzzzzzzzzzzzzzz\0\0\11\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\1\210\0\0\0\0\0\0\0\0\0zzzzzz\0\0\0zzzzzz\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0zzz\0\0\0\0\0\0\0\0\0\0\0\0\0\2\38\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0zzz\0\0\0\0\0\0\0\0\0zzz\0\0\0zzz\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\87\0\0\28\0\0\33\0\4\70zzzzzzzzz\0\0\60\0\0\0\0\1\214\0\1\39zzzzzz\0\0\33zzz\0\1\151\0\0\68\0\0\0\0\0\18\0\0\47\0\0\6\0\0\18\0\0\15\0\0\16\0\0\100\0\0\75\0\0\50\0\0\0\0\0\125\0\0\168\0\0\23\0\1\131zzz\0\5\114\0\31\152\0\17\84\0\58\22\0\3\111\0\0\99\0\0\99\0\18\21\0\1\239\0\8\24\0\9\192\0\5\92\0\5\97\0\36\79\0\10\182\0\8\214\0\0\19\0\17\144\0\2\72\0\21\60\0\2\239\0\0\230\0\17\230\0\0\87\0\99\34\0\26\127\0\21\251\0\1\117\0\3\161\0\0\89\0\0\34\0\0\0\0\0\55\0\0\135zzz\0\0\0\0\0\40\0\0\0\0\0\0\0\1\50\0\0\28\0\0\109\0\0\0\0\10\73\0\4\74\0\1\168\0\3\154\0\4\242\0\0\0\0\0\212zzz\0\1\156zzzzzzzzz\0\0\3\0\0\10\0\0\40\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0zzz\0\0\0zzzzzzzzzzzzzzzzzzzzzzzzzzz\0\0\0\0\0\6\0\0\7\0\0\10\0\0\4zzzzzzzzz\0\0\25\0\0\25\0\0\25\0\0\10\0\0\0\0\0\13\0\0\15\0\0\7\0\0\5\0\0\15\0\0\30\0\0\0\0\0\105\0\0\33\0\0\56\0\0\235\0\1\39\0\0\88\0\0\36\0\0\59\0\0\199\0\0\250\0\0\57\0\0\48\0\0\202\0\0\203\0\0\11\0\0\11\0\0\10\0\0\10zzz\0\0\0\0\0\48\0\0\9\0\0\102\0\1\63\0\0\70\0\0\106\0\1\236\0\2\142\0\0\215\0\0\144\0\1\77\0\1\186\0\0\152\0\0\70\0\2\7\0\0\171\0\1\199\0\0\0zzzzzz\0\0\110\0\0\0\0\0\41\0\0\11\0\0\15\0\4\96\0\0\140\0\0\0\0\0\141\0\0\46\0\0\179\0\1\25\0\0\67\0\0\48\0\0\0\0\0\68\0\0\46\0\15\146zzz\0\0\0zzz\0\0\31\0\6\85\0\0\137\0\1\194\0\0\146\0\10\160\0\0\0zzzzzzzzz\0\0\0\0\0\0\0\4\226zzzzzz\0\0\50\0\0\30\0\0\75\0\0\175\0\0\0\0\2\113\0\0\0\0\0\0\0\0\1\0\0\0\0\0\3\0\0\0\0\0\0\0\0\0\0\0\25\0\0\10\0\0\1\0\0\10\0\0\14\0\0\45\0\0\30\0\0\86\0\0\99\0\0\132\0\0\152\0\1\109\0\1\47\0\0\10\0\0\100\0\0\20\0\0\30\0\0\35\0\0\30\0\0\40\0\0\40\0\0\35\0\0\20\0\6\127\0\0\250\0\0\250\0\0\250\0\0\250zzz\0\0\0\0\0\81\0\10\201\0\0\81\0\2\90\0\1\65\0\0\181zzzzzzzzzzzzzzz\0\0\0zzzzzz\0\12\157\0\15\189\0\14\14\0\8\165\0\18\21zzz\0\0\125\0\4\226\0\0\50\0\1\244\0\19\136\1\232\72zzz\0\3\232\0\5\220\0\0\100\0\2\74\0\43\19\0\5\55\0\0\0\0\0\0\0\0\3\0\0\19\0\0\0\0\0\24\0\0\0\0\0\30\0\2\128\0\0\0\0\0\44\0\0\138\0\0\90\0\0\226\0\2\80\0\0\34\0\0\6\0\0\207\0\1\187\0\2\95\0\9\18\0\0\46\0\0\105\0\0\188\0\24\231\0\1\188\0\1\78\0\0\0zzz\0\3\238\0\8\235\0\0\9\0\0\8\0\0\9\0\1\244zzzzzz\0\0\49\0\0\5\0\0\142\0\0\71\0\1\43\0\0\216\0\85\50zzzzzz\0\0\10\0\0\0\0\2\20\0\5\4\0\5\37\0\3\197\0\6\231\0\5\15\0\0\100\0\5\218\0\2\101\0\3\169\0\10\171\0\10\181\0\17\200\0\13\98\0\0\0zzzzzzzzzzzzzzz\0\0\0\0\0\0zzz\0\0\0\0\0\0zzzzzz\0\0\0zzzzzzzzz\0\0\214\0\0\0\0\0\0zzzzzz\0\0\0zzzzzz\0\0\0zzzzzz\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\25\0\0\57\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0zzzzzzzzzzzzzzz\0\4\8\0\5\5\0\0\0\0\4\20\0\1\217\0\8\54\0\3\127\0\3\55\0\2\45zzz\0\1\24\0\7\231\0\3\154\0\0\0\0\4\238\0\3\71\0\8\70\0\3\204\0\0\212\0\0\212\0\0\200\0\0\35\0\2\88\0\1\84\0\0\0\0\0\0\0\4\22\0\1\59\0\0\57\0\0\0\0\3\185\0\4\10\0\11\46\0\11\57\0\0\115\0\0\115\0\1\163\0\1\164\0\4\71\0\4\75\0\0\4\0\0\4\0\0\216\0\0\217\0\0\4\0\0\4zzz\0\0\29\0\0\29\0\1\244\0\1\244\0\0\29\0\0\29\0\1\244\0\0\25\0\0\50\0\1\244\0\1\244zzzzzzzzzzzzzzzzzzzzz\0\0\0zzzzzzzzz\0\0\0zzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzz\0\0\15\0\0\22\0\0\71\0\0\47\0\0\189\0\0\0\0\1\178\0\0\0\0\0\115\0\0\68\0\1\179\0\1\108\0\1\182\0\1\111\0\3\254\0\8\68zzzzzzzzzzzz\0\0\9\0\0\25\0\0\125\0\0\100\0\0\150\0\0\100\0\0\25zzz\0\0\195\0\0\70\0\0\201zzz\0\0\45\0\0\95\0\0\0\0\0\106\0\0\0\0\0\100\0\0\100\0\1\144\0\1\144\0\1\144\0\1\144zzz\0\0\71\0\0\0\0\0\0zzzzzzzzzzzzzzzzzz\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0zzz\0\1\242\0\0\36zzz\0\0\0zzz\0\0\0zzz\0\0\0zzzzzz\0\0\87\0\0\40zzzzzzzzzzzzzzz\0\3\54zzzzzz\0\0\213\0\0\68\0\0\81\0\0\166\0\0\125\0\0\125\0\1\44\0\1\44\0\0\45\0\0\55\0\3\33\0\4\245\0\1\144\0\1\194\0\1\244\0\2\38\0\0\0\0\4\226\0\9\148\0\3\155\0\11\46\0\9\147\0\0\0zzz\0\0\0\0\4\68\0\5\25\0\5\40\0\8\161\0\10\101\0\2\234\0\6\99\0\5\212\0\21\71\0\0\0\0\0\0\0\7\25\0\4\192\0\5\220\0\12\234\0\0\0\0\26\105\0\12\109\0\18\203\0\0\30\0\0\23\0\0\0\0\0\13\0\0\25\0\0\50zzz\0\0\0\0\0\0\0\0\13\0\0\175\0\0\10\0\6\5\0\11\19\0\7\85\0\12\53\0\13\123\0\11\232\0\16\112\0\14\66\0\15\117\0\16\193\0\0\0\0\0\0\0\0\0\0\0\0\0\2\9\0\2\136\0\3\7\0\3\214\0\1\237\0\6\156\0\3\134\0\5\181\0\4\44\0\4\7\0\2\115\0\4\62\0\2\253\0\4\25\0\4\248\0\4\138\0\3\2\0\3\194\0\4\121\0\4\40\0\3\203\0\6\236\0\7\99\0\5\195\0\8\54\0\6\49\0\0\125\0\0\100\0\0\100\0\0\150\0\25\81\0\0\100\0\0\150\0\0\110\0\0\105\0\0\120\0\0\150\0\0\150\0\1\244\0\2\38\0\2\38\0\0\24\0\0\32\0\4\82\0\11\237\0\17\53zzzzzz\0\10\11\0\12\34\0\11\90\0\15\42\0\22\26\0\25\158\0\15\97\0\19\113\0\5\146\0\21\92\0\28\136\0\24\114\0\32\169\0\39\169\0\55\40\0\43\240\0\55\141\0\0\125\0\0\250\0\0\60\0\1\144\0\0\0zzzzzz\0\3\32\0\0\0\0\3\232\0\3\182\0\4\226\0\4\226\0\2\238\0\3\82\0\3\32\0\4\76\0\4\76\0\4\226zzzzzz\0\0\0zzzzzz\0\0\0\0\0\13\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\6\48\0\7\248\0\9\153\0\17\36\0\21\128\0\23\109\0\0\0\0\0\0zzzzzz\0\0\25zzzzzz\0\5\37\0\0\0zzzzzzzzzzzzzzzzzzzzzzzzzzzzzz\0\24\106zzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzz\0\0\150\0\0\250\0\0\0zzz\0\0\185zzz\0\0\0\0\0\0zzz\0\3\217\0\7\226\0\4\165\0\8\208\0\6\94\0\10\38\0\10\76\0\8\196\0\8\229\0\15\12\0\9\128\0\12\186\0\12\20\0\25\117\0\16\61\0\23\9\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0zzz\0\5\223\0\12\8\0\5\122\0\8\79\0\8\173\0\10\65\0\11\88\0\13\3\0\12\184\0\16\200\0\14\227\0\15\51\0\14\73\0\21\111\0\15\56\0\27\67\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0zzz\0\20\212\0\26\181\0\0\0\0\12\82\0\32\45\0\0\0\0\12\10\0\19\76\0\17\52\0\16\75\0\18\52\0\30\249\0\22\24\0\27\197\0\7\5\0\12\98\0\9\159\0\10\154\0\9\53\0\13\150\0\9\130\0\14\112\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0zzz\0\26\254\0\24\228\0\32\144\0\43\181\0\28\30\0\47\27\0\24\72\0\38\94\0\19\206\0\17\10zzzzzzzzz\0\0\0\0\0\0\0\0\0\0\0\0zzz\0\7\197\0\2\169\0\7\29\0\13\234\0\8\167\0\5\67\0\12\77\0\8\59\0\7\166\0\17\232\0\10\123\0\26\127\0\15\119\0\6\231\0\3\120\0\9\71\0\6\134\0\10\139zzz\0\14\42\0\9\177zzz\0\15\192\0\23\168\0\8\186\0\22\16\0\12\234\0\32\167\0\14\12\0\11\171\0\20\191\0\18\237\0\24\237\0\27\6\0\46\124\0\29\103\0\11\123\0\5\60\0\8\182\0\18\177\0\7\192\0\12\229\0\12\226\0\18\64\0\26\97\0\29\45\0\0\0\0\45\179\0\16\232\0\39\152zzz\0\24\242\0\34\18\0\72\91\0\58\212\0\81\0\0\87\207\0\5\16\0\2\201zzz\0\0\0\0\2\96\0\1\49zzz\0\4\107\0\0\23\0\0\26\0\0\33zzzzzzzzzzzz\0\8\88\0\21\27\0\17\41\0\46\223\0\47\11\0\16\86\0\18\245\0\15\26\0\22\151\0\48\49\0\12\47\0\28\145\0\28\103\0\19\167\0\5\100\0\32\192\0\14\220\0\15\151\0\12\70\0\24\252\0\31\137\0\56\252\0\36\228\0\8\123\0\14\231\0\10\121\0\7\2\0\105\114\0\4\106\0\23\134\0\15\170\0\39\156\0\10\189\0\7\83\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\10\205\0\0\0\0\0\0\0\4\26\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\9\196\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\110\0\0\125\0\0\200\0\0\150\0\0\200\0\0\225\0\0\35\0\0\200\0\0\71\0\1\44\0\1\194\0\1\91\0\1\205\0\2\211\0\7\208\0\0\125\0\4\25\0\3\23\0\2\191\0\2\193\0\4\176\0\5\177\0\3\194\0\4\47\0\9\62\0\13\149\0\5\31\0\6\56\0\7\142\0\9\255\0\0\32\0\10\92\0\0\94\0\10\244\0\2\138\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\25\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\12\0\2\203\0\0\125\0\0\200\0\0\162\0\1\144\0\0\0\0\2\13\0\1\244\0\0\162\0\1\244\0\2\188\0\3\107\0\0\146\0\1\142\0\1\44\0\2\88\0\0\150\0\0\29\0\0\45\0\0\226\0\0\180\0\1\219\0\0\237\0\1\160\0\1\75\0\1\169\0\2\231\0\4\52\0\2\98\0\3\47\0\3\211\0\4\96\0\7\18\0\7\207\0\7\82\0\8\224\0\9\192\0\14\204\0\5\244\0\8\72\0\0\250\0\2\14\0\1\244\0\4\176\0\2\38\0\5\220\0\5\220\0\2\238\0\0\250\0\4\226\0\0\87\0\0\125\0\2\113\0\0\60\0\0\11\0\0\100\0\0\100\0\0\150\0\0\175\0\0\175\0\0\200\0\0\225\0\1\19\0\1\44\0\1\94\0\1\119\0\1\119\0\0\4\0\0\30\0\0\12\0\0\60\0\0\120\0\0\187\0\0\50\0\0\12\0\0\75\0\0\75\0\0\150\0\1\152\0\4\155\0\0\175\0\0\200\0\7\8\0\2\210\0\0\200\0\0\115\0\0\200\0\0\150\0\1\94\0\9\53\0\1\244\0\2\88\0\2\88\0\12\111\0\3\232\0\5\130\0\0\175\0\1\144\0\3\232\0\2\238\0\1\244\0\15\160\0\9\196\0\10\72\0\2\238\0\6\64\0\23\112\0\19\136\0\3\132\0\0\50\0\1\244\0\0\100\0\0\250\0\7\208\0\0\25\0\0\125\0\2\88\0\4\176\0\0\162\0\0\200\0\0\250\0\1\19\0\1\119\0\1\194\0\1\206\0\2\38\0\2\88\0\2\163\0\0\0\0\0\112\0\0\0\0\0\100\0\0\112\0\0\0\0\0\100\0\0\125\0\0\125\0\0\0\0\1\75zzz\0\16\211\0\0\0zzzzzz\0\2\60zzz\0\1\75\0\7\63\0\6\157\0\6\252zzzzzz\0\0\0\0\13\144\0\5\210\0\8\20\0\14\10\0\3\134\0\7\200\0\13\4zzz\0\0\0\0\0\0zzz\0\14\216\0\12\24\0\6\17\0\1\44zzz\0\0\150\0\0\175\0\0\208\0\5\145\0\3\185\0\9\76\0\6\49zzzzzzzzzzzz\0\0\9\0\0\33zzzzzz\0\16\111\0\0\0\0\10\174\0\17\38\0\39\192\0\0\178\0\0\185\0\0\176zzzzzzzzzzzz\0\0\0zzzzzzzzzzzzzzzzzzzzzzzzzzz\0\0\125\0\19\136\0\2\113\0\97\168\0\34\46\0\0\0zzzzzz\0\5\195\0\7\182zzz\0\38\210\0\36\135\0\10\234zzz\0\43\248zzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzz\0\0\0\0\0\0zzzzzzzzzzzzzzzzzzzzzzzzzzz\0\4\149\0\3\114\0\0\1\0\0\6\0\0\25\0\0\50\0\0\1\0\0\6\0\0\25\0\16\2\0\0\50\0\8\154\0\2\21\0\32\127\0\58\180\0\8\44\0\8\44zzz\0\2\18\0\1\155\0\2\196\0\0\155\0\3\135\0\0\225\0\6\29\0\0\0\0\0\37\0\1\53\0\1\42\0\0\110\0\2\98\0\0\38\0\2\119\0\4\25\0\6\159\0\2\100\0\3\154\0\3\211\0\0\0\0\0\0\0\0\0\0\5\207\0\4\160\0\1\101\0\0\0\0\0\0\0\3\19\0\3\94\0\2\233\0\3\44\0\3\169\0\2\71\0\2\201\0\3\39\0\3\132\0\2\18\0\2\143\0\1\157\0\0\1\0\0\4\0\0\6\0\0\75\0\0\25\0\0\250\0\0\212\0\0\100\0\0\85\0\0\100\0\0\100\0\0\4\0\0\1\0\0\6\0\0\25\0\0\50\0\0\100\0\0\250zzz\0\0\50zzzzzzzzzzzz\0\0\3\0\0\0\0\0\0\0\0\0\0\0\0zzzzzz\0\1\119\0\2\38\0\0\250zzzzzzzzzzzzzzzzzz\0\0\50\0\0\70\0\0\87zzz\0\0\110\0\0\150\0\0\200\0\0\162zzzzzz\0\0\0\0\7\32zzzzzzzzzzzzzzzzzzzzz\0\0\0\0\39\142\0\28\10zzz\0\0\71\0\0\1\0\0\0\0\0\23\0\0\23\0\1\68\0\3\161\0\0\24\0\0\23\0\0\0\0\0\22\0\0\26\0\0\0\0\0\32\0\0\42\0\0\0\0\0\32\0\0\28\0\0\0\0\0\32\0\0\35\0\1\22\0\0\70\0\0\108\0\0\0\0\0\91\0\0\109\0\0\0\0\0\92\0\0\61\0\0\0\0\0\67\0\0\67\0\0\0\0\0\85\0\0\71\0\0\0\0\0\69\0\0\86\0\2\3\0\1\71\0\21\161\0\1\179\0\1\45\0\0\221\0\1\123\0\0\252zzzzzz\0\0\0\0\5\169\0\2\175\0\3\113\0\1\206\0\3\214\0\2\49\0\4\88\0\4\204\0\3\158\0\2\169\0\4\2\0\6\122\0\7\222\0\8\175\0\6\140\0\4\210\0\10\249\0\6\158\0\6\167\0\6\227\0\18\128\0\9\36\0\10\231\0\0\0\0\11\220\0\0\0\0\14\240\0\10\72\0\31\21\0\16\112\0\14\37\0\10\56\0\22\111\0\12\222zzzzzz\0\21\62zzz\0\21\54\0\7\194\0\12\158\0\16\228\0\0\0\0\0\0\0\0\0\0\0\0zzzzzzzzz\0\0\0zzz\0\0\0\0\0\4zzzzzz\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\2\63\0\1\225\0\0\139\0\0\139zzzzzz\0\0\211\0\0\56\0\0\0\0\0\0\0\0\28\0\0\41\0\5\128\0\5\190\0\0\13\0\0\56\0\2\35\0\1\159zzz\0\1\104\0\1\213\0\1\22\0\2\65\0\2\14\0\1\143\0\3\63\0\0\133\0\2\144\0\2\232\0\2\191\0\2\193\0\2\196\0\3\84\0\3\6\0\2\96\0\4\198zzzzzzzzzzzzzzzzzzzzzzzzzzz\0\13\24\0\0\0\0\0\0\0\0\33\0\0\6\0\0\0\0\5\223\0\9\158\0\11\38zzz\0\6\128\0\5\28\0\5\69zzz\0\13\43\0\15\254\0\12\15\0\2\237\0\2\172\0\3\62\0\7\103\0\6\35\0\8\51\0\6\195zzz\0\8\62\0\7\208\0\7\208\0\7\208\0\0\0\0\0\142zzz\0\0\0zzzzzzzzzzzzzzzzzzzzzzzzzzz\0\1\44\0\0\0zzz\0\0\0\0\0\0\0\0\0\0\0\0zzz\0\2\229\0\0\119zzzzzzzzz\0\0\5zzz\0\0\8\0\0\0zzzzzzzzz\0\0\95\0\0\15\0\0\46\0\0\13\0\0\78\0\0\10\0\0\56\0\0\7\0\0\86zzzzzzzzz\0\0\0\0\0\0zzzzzzzzz\0\0\0zzzzzzzzzzzzzzzzzzzzzzzzzzz\0\0\0\0\0\0\0\0\0\0\0\0zzzzzzzzz\0\0\22\0\0\13\0\0\6\0\1\113\0\0\7\0\0\15\0\0\0\0\0\7\0\0\6\0\0\7\0\0\9\0\0\14zzz\0\0\5\0\0\7\0\0\12\0\0\15\0\0\25\0\0\25\0\0\26zzz\0\0\0\0\0\20\0\0\58\0\0\0\0\0\134\0\0\179\0\0\32\0\0\0\0\0\23\0\0\23\0\0\71\0\0\236\0\1\139\0\0\36\0\0\11\0\0\89\0\0\0\0\0\72\0\0\37\0\0\67\0\1\69\0\1\70\0\6\170\0\0\0\0\0\13\0\0\63\0\0\88\0\0\6\0\0\0\0\0\0\0\0\250\0\0\23\0\0\0\0\0\12\0\0\183\0\0\20\0\0\24\0\1\247\0\0\0\0\0\0\0\0\116\0\0\91\0\0\42\0\0\54\0\1\127\0\0\64\0\0\35\0\1\132\0\30\93\0\21\110\0\46\117\0\31\40\0\10\27\0\8\161\0\0\0\0\3\193\0\65\197\0\21\254\0\0\0zzz\0\60\224\0\0\0\0\0\0\0\0\0\0\0\0zzz\0\0\0\0\0\0zzz\0\0\0\0\0\0\0\3\69\0\4\28\0\0\0\0\4\14\0\5\255\0\6\177\0\0\0\0\7\48zzz\0\6\96\0\0\0\0\6\160\0\0\0\0\7\120zzz\0\0\0\0\0\0\0\0\0\0\11\139zzzzzzzzz\0\0\3zzzzzzzzz\0\0\0zzzzzzzzz\0\21\161\0\20\162zzz\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0zzz\0\0\0zzz\0\0\0\0\0\12zzzzzz\0\0\0\0\0\0\0\0\0\0\0\12\0\0\0zzz\0\0\1zzz\0\0\0zzzzzzzzz\0\0\1zzzzzzzzzzzzzzzzzzzzzzzz\0\0\21zzzzzz\0\1\37\0\0\0\0\1\187zzzzzzzzz\0\0\25zzzzzzzzz\0\18\34zzz\0\0\250\0\0\25\0\0\50zzzzzzzzzzzzzzzzzz\0\0\0\0\0\0\0\0\240\0\0\247\0\0\233\0\0\3zzzzzzzzzzzzzzzzzzzzzzzzzzz\0\0\0\0\0\0\0\0\139\0\0\0\0\0\223\0\1\1\0\0\212\0\2\218\0\0\250\0\0\96\0\0\101\0\1\47\0\3\57\0\0\71\0\0\118\0\0\193\0\0\162\0\1\31\0\0\117\0\0\117\0\0\155\0\0\0\0\0\0\0\0\202\0\0\0\0\0\0\0\0\0\0\0\0\0\1\44\0\0\92\0\0\142\0\0\177\0\0\217zzz\0\0\0\0\0\6\0\0\0\0\0\0zzz\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0zzzzzzzzzzzzzzzzzzzzz\0\0\0\0\0\0\0\0\25\0\0\0zzzzzzzzzzzzzzz\0\10\217\0\6\242\0\6\233\0\6\39zzzzzzzzz\0\8\115zzzzzzzzz\0\11\148\0\8\115\0\3\172\0\12\7\0\1\181\0\8\148\0\7\125\0\6\124\0\3\198\0\10\227\0\12\89\0\4\123zzzzzz\0\0\31\0\0\37\0\4\57\0\2\156\0\3\3\0\4\137\0\4\142\0\2\160\0\20\98\0\15\95\0\33\208\0\46\45zzzzzzzzz\0\0\0zzz\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0zzzzzzzzz\0\0\0\0\11\62\0\0\18\0\27\233\0\30\66\0\4\220\0\3\53\0\2\111\0\5\32\0\13\137\0\19\227\0\13\162\0\31\25\0\26\193\0\33\210\0\10\86zzz\0\4\151\0\31\16\0\2\106\0\0\0\0\28\59\0\12\87\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\1\0\0\0\0\0\0\0\43\149\0\210\109\0\0\218\0\0\95zzzzzzzzzzzz\0\3\235\0\0\176\0\0\0\0\0\0\0\0\0\0\5\157\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\1\103\0\0\0\0\0\0\0\3\161\0\0\0\0\0\0\0\0\0\0\6\174\0\0\0\0\0\0\0\4\14\0\2\43\0\2\89\0\1\164\0\2\138\0\1\167\0\0\214\0\5\75\0\5\80\0\6\253\0\1\67\0\1\116\0\5\204\0\15\176\0\6\96\0\3\8\0\1\242\0\3\8\0\2\7\0\0\205\0\0\15\0\0\0\0\0\0\0\0\15\0\0\0zzzzzzzzz\0\0\167zzzzzz\0\3\151\0\1\113\0\0\88\0\1\50\0\2\50\0\2\193\0\1\169\0\12\70zzzzzzzzz\0\1\147zzz\0\0\0zzz\0\3\179\0\10\34\0\8\173\0\0\0zzzzzz\0\0\16\0\0\18\0\0\20\0\0\27\0\0\0zzz\0\0\22\0\0\48\0\0\32\0\0\37\0\0\48\0\0\0\0\0\72\0\0\87\0\0\95\0\0\66\0\0\57\0\0\0zzz\0\0\0\0\0\0zzzzzz\0\0\0zzzzzzzzzzzz\0\0\0zzzzzz\0\0\25\0\0\32\0\0\6\0\0\16zzzzzz\0\0\13\0\0\11\0\0\0\0\0\0\0\0\0\0\0\0\0\3\170\0\0\7\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0zzzzzzzzzzzzzzzzzz\0\0\0\0\0\0\0\0\13\0\0\227\0\2\138\0\2\180\0\8\36zzz\0\1\248\0\6\150\0\0\147\0\1\66\0\0\137\0\1\21\0\0\155\0\1\74\0\0\138\0\0\0\0\1\16\0\0\0zzz\0\0\0\0\0\25zzz\0\0\250zzz\0\4\43\0\1\180zzz\0\0\13\0\0\20\0\0\17\0\0\0\0\0\0\0\0\22\0\0\0\0\0\0\0\0\0zzzzzz\0\0\23\0\0\27\0\1\216zzzzzzzzzzzzzzz\0\0\3\0\0\8\0\0\7\0\0\12\0\0\9\0\0\28\0\0\30\0\0\10\0\0\10\0\0\9zzz\0\0\3\0\0\18\0\0\70\0\0\125\0\0\95zzz\0\0\10\0\0\35\0\0\60\0\0\100\0\0\110\0\0\200\0\0\100\0\1\44zzz\0\0\0\0\0\0zzzzzz\0\0\0\0\0\0\0\0\0\0\0\200\0\0\0\0\2\238\0\0\0\0\0\0\0\0\16\0\0\22zzz\0\0\71\0\2\88zzzzzzzzzzzzzzzzzzzzz\0\0\0\0\1\61\0\0\0\0\0\0zzzzzzzzzzzz\0\0\15\0\0\21\0\0\20\0\0\75\0\0\95\0\0\200\0\0\125\0\0\125\0\0\0\0\0\0zzzzzzzzzzzzzzzzzzzzz\0\8\59\0\14\110\0\1\114\0\1\194zzz\0\0\0\0\0\0zzz\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\4\226\0\0\105\0\0\196\0\0\4\0\0\203zzz\0\0\250\0\0\250\0\3\107\0\3\107\0\9\196\0\9\196\0\0\0\0\1\44\0\0\32\0\0\25\0\0\32zzzzzzzzzzzz\0\0\26\0\2\0zzz\0\0\41\0\0\36\0\0\54\0\0\54\0\0\116zzz\0\0\235\0\0\141\0\0\0\0\0\0\0\0\0\0\0\0\0\0\22\0\0\63\0\0\0\0\1\124\0\0\150\0\0\23\0\0\0\0\13\135\0\1\191\0\0\208\0\1\196\0\0\72\0\10\75\0\24\3\0\6\240\0\88\210\0\0\247\0\0\57zzzzzzzzz\0\2\44zzz\0\11\111\0\0\0\0\6\181\0\5\99zzz\0\1\91\0\1\92\0\0\30\0\0\0\0\0\150\0\0\75\0\0\45\0\0\75\0\0\75zzzzzz\0\0\25\0\0\0\0\1\194\0\1\244\0\0\0zzzzzz\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0zzzzzz\0\0\0\0\0\0zzz\0\0\0\0\0\0\0\0\0\0\0\0zzzzzz\0\0\0\0\0\0zzzzzz\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0zzz\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0zzzzzz\0\0\0zzzzzzzzzzzzzzzzzzzzz\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0zzzzzz\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0zzzzzzzzzzzzzzzzzzzzzzzz\0\10\179\0\0\25\0\0\111\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\10\104\0\2\129\0\3\54\0\12\37\0\7\92\0\9\234\0\16\31\0\39\42\0\5\83\0\0\250\0\1\119\0\1\244\0\0\30\0\0\250\0\2\188\0\11\184\0\15\160\0\5\58\0\0\44\0\0\0\0\0\0\0\7\15\0\0\50\0\0\125\0\0\250\0\1\19\0\1\94\0\0\30\0\0\30\0\0\30\0\0\30\0\1\4\0\2\89\0\12\139\0\9\12\0\0\75\0\1\244\0\0\137\0\0\150\0\0\162\0\2\188zzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzz\0\4\105\0\27\176\0\9\47\0\22\239\0\1\149\0\12\154\0\12\167\0\12\129\0\6\87\0\0\0\0\0\0\0\0\0zzzzzzzzzzzz\0\0\0\0\3\36zzzzzzzzzzzzzzzzzzzzzzzzzzz\0\0\1zzzzzzzzzzzzzzz\0\0\0zzzzzzzzzzzzzzzzzzzzzzzzzzzzzz\0\0\0\0\0\0\0\0\0\0\0\0zzzzzzzzzzzzzzzzzzzzzzzzzzzzzz\0\0\0\0\1\62zzzzzz\0\0\0\0\0\0zzzzzz\0\0\0zzzzzzzzzzzzzzzzzz\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0zzz\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0zzzzzzzzz\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\20\0\0\0zzz\0\0\20\0\0\154\0\0\115zzz\0\3\240\0\1\75zzzzzzzzzzzz\0\0\0zzz\0\0\41zzz\0\0\0\0\0\0\0\0\0\0\0\3\0\0\40\0\3\61zzzzzz\0\4\65\0\10\234\0\12\79\0\10\49\0\9\232\0\5\94\0\0\209\0\0\0\0\2\113\0\1\246\0\3\141\0\1\119\0\0\162\0\1\94\0\2\20\0\9\196\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\95\0\0\5zzz\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0zzz\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\4\226\0\1\56\0\4\226\0\6\113\0\5\220\0\0\250\0\1\244\0\1\194\0\2\138\0\3\182\0\4\76\0\0\100\0\0\170\0\1\44\0\0\62\0\1\44\0\0\200\0\0\225\0\1\119\0\1\244\0\1\244\0\0\6\0\0\13\0\0\4\0\0\23\0\0\28\0\0\23zzzzzzzzzzzz\0\1\119zzz\0\0\6zzzzzzzzzzzz\0\0\0\0\0\9zzz\0\0\15zzzzzzzzzzzzzzz\0\1\35\0\0\243zzz\0\6\192\0\0\0zzz\0\0\0zzz\0\1\165\0\17\66\0\4\254\0\2\176\0\0\1\0\0\1\0\0\1\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\1\0\0\1\0\0\1\0\0\1\0\0\1\0\0\1\0\0\1\0\0\1\0\0\1\0\0\1\0\0\1\0\0\0\0\0\1\0\0\0\0\0\0\0\0\0\0\0\0\0\0\1\0\0\1\0\0\1\0\0\1\0\0\1\0\0\1\0\0\1\0\0\0\0\0\0\0\0\0\0\0\1zzzzzz\0\0\37\0\0\44\0\0\120\0\0\22\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0zzzzzzzzzzzzzzz\0\0\6zzz\0\0\7\0\0\0zzz\0\0\15\0\0\69zzz\0\1\113\0\1\167zzz\0\0\0\0\0\0zzz\0\0\7\0\5\93\0\2\101\0\1\49\0\2\112zzz\0\2\104\0\0\0zzz\0\20\188\0\1\160zzz\0\3\161\0\4\89\0\2\138\0\4\199\0\0\54\0\0\37\0\0\121\0\8\17\0\3\154\0\2\43\0\0\0\0\0\0\0\0\0\0\0\0\0\1\194zzz\0\0\0\0\2\83\0\2\90\0\0\0\0\0\24\0\0\24\0\0\144\0\19\29\0\0\0\0\0\0\0\18\189\0\0\0\0\0\0\0\4\44\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\98\0\0\160\0\0\161\0\0\99\0\0\243\0\0\0\0\0\0zzzzzzzzzzzzzzzzzzzzzzzzzzz\0\0\0\0\0\0\0\0\4zzzzzzzzz\0\0\12\0\0\250\0\0\0\0\2\77\0\3\116zzz\0\0\205\0\0\149\0\0\234\0\0\193\0\0\50\0\0\50\0\0\75\0\0\0\0\0\100\0\0\200\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0zzz\0\8\196zzzzzzzzzzzzzzzzzz\0\0\1\0\0\1\0\0\1\0\0\8\0\0\33\0\0\10\0\0\12\0\0\28\0\0\7\0\0\130\0\0\1\0\1\187\0\0\20\0\2\116\0\0\1\0\0\25\0\0\25\0\0\25\0\0\1\0\0\2\0\0\100\0\0\150\0\0\187zzzzzz\0\4\193\0\9\242\0\0\3\0\0\2\0\18\195\0\3\196\0\10\151\0\6\114\0\0\0\0\12\62\0\7\100\0\0\10\0\0\10\0\50\23\0\0\100\0\0\100\0\1\44\0\36\250\0\4\129\0\7\137\0\0\0\0\6\45\0\1\49\0\0\245\0\0\125\0\0\24\0\4\236\0\2\154\0\0\75\0\0\0\0\0\100\0\0\0\0\0\100\0\0\100\0\0\125\0\0\125\0\1\39\0\0\1\0\0\1\0\0\1\0\0\1\0\0\1\0\0\1\0\0\1\0\0\4\0\0\5\0\10\21\0\0\2\0\0\4\0\0\250\0\1\119\0\0\180\0\4\42\0\13\50\0\0\100\0\2\38\0\0\10\0\0\12\0\0\35\0\0\35\0\0\0\0\0\250\0\0\0\0\0\250\0\1\36\0\0\244\0\2\142\0\2\113\0\2\11\0\5\239\0\0\250\0\0\250\0\10\132\0\4\204\0\7\251\0\8\197\0\0\150\0\0\150\0\3\232\0\2\248\0\4\17\0\4\240\0\10\254\0\3\218\0\3\221\0\6\103\0\12\17\0\1\19\0\18\91\0\6\236\0\12\170\0\12\96\0\7\178\0\4\174\0\6\118\0\6\124\0\5\235\0\28\100\0\18\103\0\9\193\0\8\7\0\17\213\0\10\168\0\9\232\0\6\161\0\8\251\0\14\155\0\9\13\0\14\184\0\28\65\0\14\241\0\17\126\0\16\66\0\27\104\0\10\235\0\17\192\0\35\138\0\21\60\0\14\157\0\19\89\0\0\0zzzzzz\0\0\0\0\1\106\0\0\237\0\61\196zzzzzzzzz\0\0\228\0\0\88\0\2\20\0\4\100\0\9\27\0\2\189\0\0\170\0\1\144\0\0\28\0\0\62\0\0\225\0\0\4\0\0\3\0\0\4\0\0\1\0\4\98\0\3\76\0\4\166zzz\0\5\247zzz\0\3\154\0\1\74\0\1\164\0\2\146\0\8\192\0\0\20\0\1\244\0\11\202\0\4\188\0\0\137\0\1\119\0\1\244\0\1\18\0\0\0zzz\0\2\201\0\2\130\0\2\216\0\0\0\0\0\0\0\0\0zzzzzzzzz\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0zzz\0\0\0\0\0\0\0\0\0\0\4\116\0\2\251\0\11\117\0\14\96\0\0\87\0\0\44\0\0\34\0\0\45\0\0\54\0\0\121\0\0\191\0\0\28\0\0\42\0\0\37\0\0\0\0\0\35\0\0\70\0\0\36\0\0\33\0\0\47\0\0\4\0\1\28\0\2\62\0\4\9\0\9\193\0\0\187\0\1\102\0\0\12\0\0\25\0\1\161\0\0\62\0\0\62zzzzzz\0\1\232\0\0\210\0\1\236\0\0\162\0\1\175\0\0\163\0\0\219\0\0\147\0\0\0\0\2\164\0\2\21\0\1\11\0\0\233\0\0\102\0\0\204\0\1\153\0\2\89\0\2\13\0\0\229\0\0\104\0\0\174\0\1\46\0\0\180\0\2\21\0\2\104\0\2\163\0\1\252\0\1\39\0\2\0\0\1\138\0\1\155\0\4\12\0\3\152\0\4\20\0\1\107\0\4\143\0\5\43\0\3\170\0\2\56\0\1\175\0\2\60\0\2\137\0\5\23\0\2\155\0\5\32\0\1\166\0\2\219\0\1\169\0\5\136\0\1\190\0\1\249\0\4\122\0\1\202\0\0\0\0\7\38\0\3\239\0\9\144\0\3\155\0\4\97\0\4\101\0\8\210\0\6\171\0\9\122\0\10\118\0\3\99\0\5\157\0\3\106\0\9\31\0\3\192\0\3\203\0\0\0\0\8\154\0\5\48\0\8\100\0\8\108\0\3\44\0\4\88\0\2\232\0\4\96\0\3\56\0\8\156\0\5\91\0\0\0\0\0\0\0\0\0\0\0\0\0\194\199\0\0\0zzzzzzzzz\0\10\60\0\1\114\0\2\244\0\8\19\0\15\213\0\1\255\0\9\254zzzzzzzzzzzz\0\0\0\0\0\0zzz\0\17\58\0\7\88\0\0\6\0\0\0\0\0\25\0\0\0\0\0\40\0\0\0\0\0\0\0\0\0\0\0\234zzzzzzzzzzzzzzz\0\0\5zzz\0\2\29\0\141\61\0\0\115\0\0\95\0\0\150\0\3\124\0\3\127\0\3\62\0\3\224\0\4\221\0\5\98\0\6\136\0\8\20\0\1\244\0\0\0\0\0\0\0\4\25\0\8\198\0\9\97\0\2\165\0\22\191\0\0\0\0\24\105\0\8\233\0\0\0zzz\0\6\37\0\12\80\0\38\202\0\9\167\0\32\75\0\15\175\0\34\162\0\38\60\0\7\24\0\24\165\0\11\186\0\19\222\0\7\249\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\2\33\0\0\137\0\0\0\0\0\12\0\0\10\0\0\75\0\0\21\0\0\200zzzzzz\0\4\73\0\12\147\0\5\139\0\5\51\0\31\219\0\0\0\0\23\217\0\9\84\0\11\180\0\0\0\0\28\19\0\0\0\0\3\103\0\9\117\0\0\0\0\0\0\0\0\150\0\0\0\0\10\245\0\27\128\0\11\175\0\3\233\0\11\198\0\11\14\0\5\182\0\4\166\0\6\255\0\27\164\0\19\151\0\3\129\0\3\129\0\3\129\0\5\131\0\6\66zzz\0\0\0zzz\0\5\95\0\18\22\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0zzzzzz\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\28\198\0\11\69zzzzzz\0\0\0\0\0\0\0\0\0\0\6\24zzzzzzzzz\0\7\240zzz\0\0\59\0\1\210\0\13\3\0\15\172\0\6\4\0\13\136\0\18\130\0\12\85\0\10\81\0\1\244\0\2\238\0\24\218\0\24\242zzzzzz\0\17\104\0\71\79\0\19\21\0\31\124zzz\0\39\225\0\0\62zzzzzzzzz\0\0\25zzz\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\2\36\0\0\150\0\24\124\0\73\26\0\91\180\0\68\114\0\14\186\0\1\244\0\0\1\0\1\248\0\0\1\0\0\0zzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzz\0\0\0zzz\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0zzz\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\5\0\0\10\0\0\4\0\0\6\0\0\0\0\0\62zzzzzzzzz\0\0\0\0\0\0\0\16\36\0\0\0\0\18\77\0\5\243\0\4\28\0\7\67\0\18\57\0\18\205\0\4\251\0\7\81\0\2\114\0\27\243\0\8\250\0\5\162zzzzzzzzzzzzzzz\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0zzz\0\0\0zzzzzzzzzzzz\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\5zzz\0\0\20\0\0\30\0\0\75zzz\0\29\35\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\2\181\0\2\184\0\2\186\0\2\189\0\3\138\0\8\173\0\12\170\0\9\161\0\5\217\0\65\126\0\67\112\0\67\173\0\2\160\0\2\163\0\2\165\0\2\168\0\2\171\0\2\173\0\2\176\0\2\178\0\0\50\0\0\13\0\0\0zzzzzzzzzzzzzzzzzzzzzzzzzzz\0\3\6zzz\0\2\138\0\13\207\0\11\212\0\3\213\0\3\217\0\0\16zzz\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\22\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\5\214\0\3\57\0\2\233\0\3\146\0\3\231\0\10\136\0\5\208\0\8\192\0\18\93\0\5\224\0\9\10\0\9\19\0\8\4\0\10\221\0\10\231\0\7\225\0\9\126\0\18\133\0\10\9\0\9\94\0\0\0\0\1\144\0\1\144\0\1\144\0\1\144\0\0\100\0\0\150\0\0\6\0\0\4\0\1\144\0\1\144\0\1\144\0\1\144\0\1\144\0\1\144\0\1\144\0\1\144zzz\0\1\94\0\1\94\0\1\119\0\1\44\0\4\226\0\1\119\0\0\250\0\0\250\0\0\250\0\0\0\0\0\174\0\0\32\0\0\5\0\0\1\0\0\6\0\0\6\0\0\7\0\0\5\0\0\0\0\0\0\0\0\0\0\0\0\0\4\210\0\7\66\0\0\209\0\0\0\0\8\22\0\13\1\0\17\195\0\26\51\0\0\250\0\2\171\0\2\173\0\2\176\0\2\178zzz\0\3\128\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0zzzzzzzzz\0\6\10\0\9\24zzz\0\9\34\0\12\26zzzzzz\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0zzz\0\0\0\0\0\21\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\194\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\18\104zzzzzz\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0zzzzzzzzzzzz\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0zzzzzz\0\0\25\0\1\29\0\12\31zzz\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0zzz\0\0\0zzz\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0zzzzzzzzzzzzzzz\0\0\0zzzzzzzzz\0\0\0\0\0\34\0\0\28\0\0\25\0\0\25\0\0\162\0\0\85\0\2\87\0\1\159\0\2\74\0\2\77\0\0\25\0\0\100\0\0\125\0\0\162\0\1\144zzzzzzzzzzzzzzz\0\0\56zzz\0\1\213\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0zzz\0\0\62zzzzzz\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\2\184\0\2\186\0\2\189\0\2\191\0\15\83\0\16\234\0\26\36\0\0\0\0\6\8\0\7\145\0\5\229\3\208\144\0\9\196\0\244\36\1\232\72\0\48\212\0\97\168zzz\0\19\136zzzzzz\0\0\0\0\2\178\0\3\93\0\0\29\0\0\58\0\5\26\0\11\182\0\7\73\0\4\7\0\5\131\0\7\83\0\3\117\0\3\210\0\1\144\0\1\194\0\1\244\0\2\13\0\2\38zzz\0\4\74\0\7\26\0\10\117\0\11\139\0\3\244\0\1\244\0\1\244\0\12\25\0\14\176\0\14\190zzz\0\8\221\0\8\98\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\9\83\0\10\27\0\0\0\0\0\0\0\16\141\0\16\157\0\0\200\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\5\92\0\14\82\0\8\233\0\8\241\0\4\150\0\5\135\0\5\22\0\8\109\0\12\104\0\5\204\0\5\162\0\11\87\0\16\160\0\5\46\0\10\98\0\6\242\0\6\86\0\15\101\0\10\149\0\0\0\0\0\0\0\0\0\0\0\250\0\18\12\0\16\98\0\15\59\0\10\158\0\6\148\0\9\232\0\10\189\0\8\63\0\6\18\0\6\24\0\21\49\0\19\178\0\13\186zzz\0\8\195\0\13\49\0\14\76\0\9\170\0\8\20\0\8\28\0\2\113\0\1\244\0\2\188\0\3\107\0\3\107\0\23\27\0\23\49\0\16\43\0\10\4\0\15\143\0\16\221\0\7\208\0\9\125\0\10\122\0\24\58zzz\0\26\91\0\0\0\0\0\0\0\26\107\0\24\140\0\14\84\0\9\151\0\13\95\0\14\126\0\12\209\0\9\67\0\8\155\0\31\189\0\27\79\0\19\9\0\11\203\0\19\44\0\19\62\0\13\62\0\11\246\0\12\1\0\36\109\0\33\217\0\23\150\0\14\156\0\22\48\0\24\14\0\11\199\0\12\196\0\13\215\0\37\86\0\34\178\0\0\0zzzzzzzzz\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\1\244\0\1\144\0\1\144\0\2\41\0\2\44\0\7\146\0\7\153\0\38\77\0\38\114\0\21\6zzz\0\36\156\0\36\190\0\29\211\0\22\115\0\13\232\0\19\99\0\19\129\0\16\201\0\12\34\0\13\39\0\44\20\0\38\166\0\26\241\0\16\177\0\25\34\0\27\63\0\17\94\0\15\176\0\17\1\0\50\248\0\54\188\0\48\34\0\49\148\0\34\141\0\21\103\0\32\92\0\31\187\0\16\200\0\18\50\0\19\186\0\0\0\0\0\0\0\25\20\0\0\0\0\27\233\0\9\238\0\9\238\0\4\15\0\27\211\0\21\11\0\29\172\0\6\73\0\2\154\0\1\44\0\1\244\0\0\0\0\0\0\0\0\0\0\0\0zzzzzzzzzzzz\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0zzzzzz\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\2\45\0\5\119\0\4\82\0\16\114\0\22\179\0\28\196\0\0\0\0\1\244\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0zzzzzzzzzzzz\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0zzz\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0zzzzzzzzzzzzzzzzzzzzz\0\35\30zzzzzz\0\0\30\0\0\0\0\0\50\0\0\0\0\0\0\0\0\0\0\29\254\0\30\236\0\10\61\0\21\92\0\16\212\0\34\132\0\20\200\0\43\116\0\8\184\0\10\129\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\25\249\0\13\231\0\47\247\0\5\125\0\4\33\0\18\169\0\14\251zzz\0\0\0\0\73\235\0\26\211\0\26\207\0\20\236\0\70\2\0\36\79\0\88\39\0\21\60\0\0\0\0\45\161\0\9\184\0\12\151\0\21\138\0\39\162\0\13\154\0\0\0zzz\0\60\135zzz\0\46\195zzz\0\0\211\0\1\62zzzzzz\0\2\88\0\0\0\0\0\0\0\0\0\0\32\238\0\30\74\0\42\110\0\19\21\0\6\176\0\6\78\0\26\247\0\30\194\0\7\167\0\16\44\0\7\135\0\50\75\0\58\226\0\26\68\0\23\186\0\44\26\0\0\0\0\0\0\0\0\0\0\0\0zzzzzzzzzzzzzzzzzz\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\21\229\0\15\120\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\10\0\0\10\0\0\10\0\4\0zzzzzzzzzzzz\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0zzzzzzzzz\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0zzzzzz\0\0\0\0\0\0zzzzzz\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0zzzzzz\0\35\30\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0zzzzzz\0\3\232\0\19\136\0\1\244\0\0\100\0\9\196\0\13\3\0\13\9\0\14\116\0\10\151\0\25\66\0\17\7\0\31\117\0\36\211\0\16\56zzz\0\16\7\0\0\0\0\40\176\0\20\137\0\33\36\0\30\59\0\48\42\0\31\19\0\33\214\0\39\93\0\39\130\0\57\53\0\45\251\0\46\37\0\27\178\0\74\130\0\0\0\0\48\232\0\57\67\0\62\20\0\78\124\0\67\139\0\84\157\0\97\60\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\90\120\0\0\241\0\7\152\0\8\157\0\9\131\0\132\66\0\150\148\0\99\164\0\0\0\0\25\88\0\0\40\0\0\40\0\0\200\0\0\250zzz\0\0\250zzz\0\3\232\0\1\144\0\0\46\0\0\50\0\5\220\0\7\208\0\0\0\0\2\238\0\2\238\0\3\82\0\4\76\0\4\76\0\7\208\0\7\208\0\7\208\0\0\0\0\0\0\0\0\0\0\9\196\0\9\196\0\9\196\0\7\208\0\9\196\0\0\0\0\5\220\0\0\0\0\0\81\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\48\184zzzzzzzzz\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0zzzzzz\0\9\196\0\7\208\0\9\196\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0zzzzzzzzzzzzzzzzzzzzzzzz\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0zzzzzzzzzzzzzzz\0\5\254zzzzzzzzzzzzzzzzzzzzzzzz\0\40\237\0\19\125\0\21\194\0\15\140\0\18\150\0\35\234\0\25\116zzz\0\18\86\0\27\103\0\18\122\0\18\140\0\27\183\0\37\43\0\37\79zzz\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\40\198\0\23\50\0\14\10\0\19\148\0\14\38\0\23\2\0\32\244\0\37\222\0\14\93\0\23\92\0\18\24\0\27\249\0\17\84\0\49\182\0\19\101\0\18\235\0\30\195\0\44\12\0\30\252\0\24\223\0\61\40\0\23\49\0\24\85\0\24\109\0\36\243\0\39\131\0\56\149\0\41\21\0\62\121\0\43\226zzz\0\19\76\0\52\104\0\20\255\0\19\130\0\31\122\0\31\151\0\49\103\0\34\92\0\0\0\0\1\244\0\0\0\0\0\0zzz\0\0\250\0\0\250\0\1\244\0\0\5\0\0\250zzz\0\15\67\0\35\136\0\15\96\0\15\110\0\23\13\0\23\34\0\33\127\0\25\42\0\0\0\0\1\244\0\0\0\0\0\100\0\0\100\0\1\244\0\1\244\0\1\244\0\1\244\0\3\232\0\16\35\0\23\83\0\17\143\0\0\71\0\1\50\0\0\28\0\0\240\0\0\79\0\0\40\0\9\122\0\11\131\0\42\200\0\8\183\0\13\149\0\25\14\0\29\143\0\145\166\0\30\100\0\18\174\0\34\4\0\54\53\0\0\0\0\54\155\0\27\246\0\15\173\0\96\85\0\28\107\0\20\230\0\35\62\0\33\180\0\18\68\0\16\250\0\49\160\0\35\18\0\40\32\0\32\183\0\21\161\0\31\66\0\45\65\0\31\214\0\24\86\0\28\45\0\24\179\0\3\232\0\3\232\0\0\0\0\0\0\0\0\0\0\0\0\0\39\82\0\29\231\0\36\6\0\22\115\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\39\16\0\50\123\0\30\237\0\19\133\0\27\120\0\20\216\0\31\98\0\47\48\0\53\55\0\19\243\0\33\192\0\23\122\0\40\21\0\23\165\0\67\244\0\28\147\0\27\26\0\41\121\0\57\14\0\40\133\0\30\177\0\77\202\0\29\44\0\34\224\0\35\0\0\56\26\0\56\15\0\79\134\0\53\129\0\24\146\0\70\20\0\86\12\0\26\211\0\24\237\0\37\95\0\40\131\0\58\33\0\40\210\0\61\79\0\64\166\0\41\18\0\25\237\0\36\211\0\27\175\0\46\100\0\65\48\0\66\86\0\26\128\0\44\212\0\33\94\0\49\108\0\31\52\0\78\177\0\35\153\0\33\117\0\56\18\0\78\204\0\56\127\0\43\52\0\98\76\0\41\17\0\45\223\0\46\11\0\73\29\0\73\15\0\99\33\0\75\220\0\40\47\0\101\62\0\111\149\0\36\189\0\34\204\0\55\30\0\58\165\0\88\94\0\62\165\0\86\76\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\1\244zzz\0\28\253\0\20\243\0\23\92\0\42\67\0\56\142\0\4\106\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0zzz\0\0\6\0\0\4\0\0\100\0\72\23\0\3\232\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0zzz\0\3\107\0\3\107\0\3\232\0\3\232\0\0\0\0\4\226\0\4\226zzzzzzzzzzzz\0\3\232zzz\0\3\232\0\4\101\0\4\226\0\4\226\0\5\95\0\5\95zzzzzzzzzzzzzzzzzz\0\3\232zzzzzzzzz\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0zzzzzzzzzzzzzzzzzz\0\0\31\0\0\46zzzzzz\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0zzzzzz\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0zzz\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\171\0\0\68\0\3\232\0\3\232\0\3\232\0\3\232\0\5\220\0\5\220\0\5\220\0\3\232\0\0\0\0\3\232\0\3\232\0\3\232\0\1\244\0\9\196\0\9\196\0\4\226\0\4\226\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\178\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0zzzzzzzzzzzzzzzzzz\0\0\175\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\1\84\0\3\32\0\0\0\0\0\0zzz\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0zzz\0\0\200\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0zzzzzzzzzzzzzzz\0\0\0\0\0\0zzzzzzzzzzzzzzz\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0zzz\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0zzz\0\0\250\0\0\250\0\0\250zzzzzzzzz\0\0\0zzzzzz\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\9\196\0\5\220\0\2\238\0\0\250zzz\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0zzz\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\1zzzzzzzzzzzz\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\25\92zzzzzz\0\0\0zzzzzz\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0zzzzzz\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\2\170\0\4\12\0\3\7\0\6\68\0\7\71\0\10\58\0\20\97\0\20\78\0\15\97\0\25\112\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\200\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\125\0\0\0\0\0\0\0\0\0\0\1\44\0\0\0\0\0\0\0\0\0\0\0\0\0\0\95\0\0\0\0\0\60\0\1\119\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\1\119\0\0\250\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\50\0\0\25\0\0\125\0\0\75\0\0\100\0\0\125\0\0\0\0\0\0\0\0\0\0\0\200\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\200\0\0\200\0\0\200\0\0\200\0\0\200\0\0\200\0\0\0\0\0\0\0\0\200\0\0\200\0\0\0\0\0\160\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0zzz\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\100\0\0\150\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\200\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\20\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\3\232\0\0\250\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\250\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\250\0\0\0\0\0\0\0\0\0\0\0\0\0\0\250\0\0\0\0\0\0\0\0\0zzz\0\1\44\0\1\144\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\1\244zzz\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\3\232\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\175\0\2\88\0\0\0zzz\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\2\88\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\2\188\0\0\0\0\0\0\0\0\0\0\2\238\0\0\0\0\0\0\0\0\0\0\9\196\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\2\188\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\1\244zzzzzzzzzzzzzzz\0\0\0zzzzzz\0\9\117\0\31\219zzzzzzzzzzzzzzz\0\6\17zzz\0\0\62\0\0\62\0\0\62zzzzzzzzzzzzzzz\0\0\64\0\1\144\0\0\250\0\3\232zzz\0\0\35\0\0\15zzz\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0zzz\0\0\100zzzzzz\0\0\45zzzzzzzzzzzzzzz\0\16\108\0\41\75\0\16\139\0\16\154\0\24\206\0\26\227\0\36\35\0\25\36\0\4\226\0\7\208\0\7\208\0\7\208\0\9\196\0\8\202zzz\0\9\196\0\9\196\0\8\202\0\7\208\0\7\208\0\7\208zzzzzz\0\0\38zzz\0\0\0\0\0\0\0\0\5\0\0\5\0\0\12\0\0\10zzz\0\0\25\0\0\5zzzzzzzzzzzzzzzzzz\0\0\0zzz\0\2\113zzzzzzzzzzzz\0\0\38\0\0\73\0\0\47\0\0\52\0\5\8\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\1\120\0\0\217\0\0\227\0\0\228\0\76\121\0\1\144\0\1\144zzz\0\0\12zzzzzz\0\14\105\0\4\226zzzzzzzzzzzz\0\241\240\0\0\0\0\0\0\0\16\124\0\0\0\0\0\0\0\44\116\0\103\15\0\0\0\0\33\180\0\14\24\0\65\255\0\38\61\0\47\249\0\38\131\0\28\40\0\14\251\0\20\78\0\10\16\0\50\31\0\50\180\0\30\202\0\9\93\0\6\29\0\28\151\0\14\88\0\5\213\0\0\3\0\12\176\0\19\206\0\98\220\0\10\102\0\11\3\0\8\7\0\16\65\0\19\230\0\72\207\0\17\138\0\26\6\0\33\139\0\65\41\0\125\249\0\40\134\0\35\37\0\110\58\0\0\0\0\128\83\0\84\188\0\15\243zzz\0\50\252\0\99\120\0\53\26\0\83\241\0\40\35\0\58\5\0\8\48\0\20\116\0\33\105\0\19\21\0\20\207\0\16\37\0\22\16\0\11\100zzzzzzzzzzzzzzzzzzzzz\0\0\0\0\4\96\0\8\212\0\29\140\0\12\165\0\5\105\0\37\92\0\10\58\0\0\25\0\32\18\0\25\192\0\7\192\0\7\34\0\25\252\0\34\198\0\27\6\0\52\248zzz\0\17\234zzzzzz\0\0\0\0\72\129zzz\0\87\146zzz\0\57\42\0\30\178zzzzzz\0\51\185\0\51\234\0\130\66\0\58\162\0\140\96\0\112\181\0\42\106\0\123\237\0\133\19\0\115\145\0\74\195\0\42\210\0\20\168\0\21\107\0\14\48\0\17\67\0\14\106\0\23\234\0\5\28\0\12\100\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0zzz\0\9\48\0\10\123\0\11\129\0\82\68\0\24\197\0\2\108\0\1\50\0\7\219\0\8\23\0\61\121\0\7\108\0\8\240\0\44\197\0\56\46\0\19\74zzz\0\0\0\0\0\0\0\0\0\0\84\109zzz\0\0\0zzz\0\35\235\0\0\0\0\27\180\0\34\143\0\5\126\0\5\131\0\0\0\0\25\63\0\0\50\0\0\150\0\0\200zzzzzzzzzzzzzzzzzzzzz\0\0\0zzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzz\0\0\0zzzzzzzzzzzzzzzzzzzzzzzzzzz\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\24\106\0\25\63zzzzzzzzzzzzzzzzzzzzzzzzzzz\0\0\94\0\0\142\0\0\93\0\0\87\0\1\45\0\1\46\0\22\0\0\5\76zzz\0\6\226\0\19\164\0\3\241\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0zzzzzzzzzzzz\0\22\33\0\16\102\0\20\147\0\24\200\0\63\115\0\9\238zzzzzz\0\22\148\0\15\28\0\15\43\0\22\215\0\13\53\0\18\105\0\12\82\0\32\104\0\26\219\0\94\47\0\33\71\0\50\241\0\8\44\0\62\116\0\38\157\0\26\112\0\46\87\0\31\26\0\24\248\0\62\3\0\84\115\0\125\193\0\63\31\0\26\89\0\66\33\0\27\180\0\29\58\0\20\213\0\15\246\0\0\0\0\16\131\0\35\91\0\29\13\0\38\241\0\34\34\0\18\219\0\28\98\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\68\78\0\68\142\0\55\10\0\0\50\0\14\248\0\150\59\0\120\155\0\0\0\0\121\121\0\6\18\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\5\225\0\7\20\0\0\0\0\0\0\0\0\0\0\16\176\0\13\245\0\14\2\0\35\252\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\44\157\0\24\106\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0zzzzzzzzzzzz\0\0\49\0\0\67\0\0\45\0\0\54\0\0\56\0\0\227\0\1\18\0\1\19\0\0\57\0\0\86\0\0\58\0\0\248\0\0\56\0\0\73\0\1\38\0\1\108\0\0\73\0\0\138\0\0\73\0\0\59\0\0\92\0\1\80\0\1\44\0\1\150\0\1\106\0\2\104\0\1\61\0\6\101\0\1\161\0\2\20\0\5\48\0\5\89\0\5\94\0\1\60\0\2\35\0\1\62\0\3\172\0\1\78\0\1\114\0\3\214\0\4\89\0\3\44\0\2\21\0\1\13\0\0\234\0\1\102\0\1\56\0\2\230\0\3\26\0\6\108\0\3\55\0\2\38\0\3\61\0\2\114\0\4\14\0\5\248\0\6\150\0\2\123\0\7\235\0\2\196\0\4\181\0\2\217\0\7\82\0\2\197\0\3\66\0\4\231\0\7\56\0\7\63\0\4\207\0\2\213\0\2\58\0\3\58\0\2\221\0\6\128\0\6\245\0\5\146\0\6\146\0\10\166\0\6\5\0\3\103\0\4\168\0\3\197\0\6\63\0\9\51\0\10\40\0\4\90\0\7\53\0\3\252\0\13\161\0\4\209\0\4\224\0\11\215\0\8\26\0\11\237\0\14\93\0\5\7\0\4\150\0\5\146\0\5\152\0\12\91\0\9\87\0\14\155\0\14\125\0\8\88\0\5\149\0\6\243\0\6\48\0\9\81\0\9\90\0\13\196\0\14\236\0\5\88\0\19\71\0\7\103\0\11\23\0\6\34\0\19\18\0\11\56\0\7\114\0\6\217\0\16\164\0\12\135\0\13\199\0\7\150\0\21\229\0\6\243\0\8\112\0\8\177\0\14\102\0\21\49\0\16\5\0\22\196\0\22\169\0\8\91\0\12\74\0\10\148\0\13\97\0\7\172\0\8\82\0\13\136\0\24\65\0\19\162\0\21\72\0\16\84\0\10\29\0\27\159\0\0\0\0\16\144\0\11\103\0\10\76\0\11\41\0\26\33\0\18\53\0\20\101\0\11\97\0\28\200\0\10\158\0\30\240\0\12\123\0\12\223\0\20\237\0\30\63\0\21\44\0\32\59\0\11\227\0\17\229\0\16\161\0\11\32\0\12\15\0\28\60\0\19\173\0\33\43\0\29\133\0\19\227\0\13\238\0\21\143\0\39\228\0\16\23\0\14\137\0\23\162\0\34\41\0\23\207\0\40\36\0\14\206\0\24\224\0\15\87\0\38\202\0\14\78\0\16\191\0\16\207\0\27\83\0\36\178\0\25\177\0\39\113\0\25\3\0\15\164\0\23\141\0\16\221\0\27\42\0\25\123\0\36\125\0\44\7\0\33\122\0\16\28\0\44\132\0\20\73\0\32\173\0\18\247\0\52\106\0\21\60\0\20\135\0\33\19\0\47\94\0\33\83\0\20\10\0\53\185\0\57\132\0\18\195\0\21\247\0\22\12\0\36\2\0\35\251\0\51\134\0\38\245\0\46\24\0\19\241\0\18\136\0\27\13\0\39\45\0\27\66\0\17\5\0\25\110\0\64\65\0\0\0\0\0\0\0\0\0zzz\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\18\207\0\18\225zzz\0\20\137\0\20\156\0\11\43\0\22\106zzz\0\0\0\0\22\168\0\17\13\0\20\164\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\12\203\0\15\104\0\0\0\0\31\10zzz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zzz\0\0\0\0\3\232\0\1\144\0\3\196\0\5\130\0\6\21\0\2\113\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\4\219\0\14\194\0\4\226\0\4\226\0\4\226\0\0\0\0\0\0\0\0\100\0\0\100\0\0\112\0\0\112\0\0\125\0\0\125\0\2\238\0\5\220\0\0\0\0\3\232\0\6\214\0\0\200\0\3\232\0\6\214\0\0\0\0\6\214\0\4\101\0\0\0\0\4\101\0\0\0\0\9\196\0\4\226zzz\0\27\80\0\9\203\0\37\115\0\10\169\0\14\206\0\9\10\0\0\0\0\0\0\0\0\0\0\0\0zzz\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\9\117\0\9\126\0\4\226\0\4\226\0\96\184\0\107\4\0\97\106\0\102\164\0\112\177\0\107\247\0\113\228\0\50\184\0\48\7\0\76\18\0\80\45\0\114\114\0\80\196\0\48\237\0\85\108\0\54\218\0\119\198\0\87\146\0\58\56\0\55\166\0\119\225\0\82\129\0\116\186\0\84\71\0\56\212\0\56\69\0\86\101\0\117\104\0\87\13\0\56\84\0\4\226\0\4\226\0\4\226\0\0\0\0\0\0\0\0\0\0\3\232\0\5\187\0\2\51\0\0\255\0\1\129\0\2\29\0\3\96\0\1\153\0\7\184\0\1\176\0\9\86\0\9\105\0\4\232\0\3\177\0\1\230\0\1\113zzz\0\0\0\0\0\0\0\0\0\0\64\80\0\0\0zzz\0\0\32\0\0\0\0\11\26\0\2\238\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0zzzzzzzzzzzzzzzzzzzzzzzzzzzzzz\0\0\0\0\0\0\0\1\140\0\0\0\0\0\0\0\0\0zzz\0\25\64zzz\0\0\142zzzzzz\0\2\117\0\12\10\0\14\25\0\6\214zzzzzzzzzzzz\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\24\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\16\0\8\57\0\13\150\0\17\46\0\15\248\0\20\49\0\30\90\0\0\250\0\20\107\0\1\94\0\34\255zzz\0\44\105zzz\0\0\2\0\0\5\0\2\238zzz\0\0\0\0\0\0\0\18\88\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0zzzzzzzzzzzz\0\20\135\0\13\189\0\0\25\0\15\89\0\5\220\0\0\81\0\9\196\0\0\162\0\0\48zzzzzz\0\0\131\0\0\119\0\0\0zzz\0\0\0\0\0\250\0\2\238\0\3\232\0\3\232\0\2\238zzzzzzzzzzzz\0\34\21\0\0\0zzz\0\62\3\0\42\175\0\37\120\0\53\186\0\14\191zzz\0\23\112\0\7\208\0\13\49\0\0\0\0\0\0\0\20\190\0\14\22\0\24\47\0\11\89\0\2\238\0\2\238\0\5\220\0\22\202zzzzzz\0\0\0\0\0\150zzz\0\0\0\0\0\0\0\0\0zzzzzzzzzzzz\0\1\244\0\2\238\0\3\57\0\3\57\0\3\107\0\3\107\0\3\132\0\3\182\0\3\232zzz\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\250zzzzzz\0\96\172\0\67\97\0\106\230\0\143\124\0\105\94\0\114\61\0\31\130\0\33\216\0\23\198\0\29\200\0\79\223\0\42\60\0\0\14\0\0\6\0\0\139\0\0\210zzzzzzzzzzzzzzz\0\1\244\0\2\238\0\1\244\0\1\244\0\0\125zzz\0\0\0\0\0\0\0\142\18\0\6\103\0\3\197\0\0\9\0\0\14\0\3\165\0\4\225\0\18\54zzzzzzzzzzzzzzz\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0zzzzzzzzzzzzzzz\0\0\0\0\1\244\0\0\0\0\99\51zzzzzzzzzzzzzzzzzzzzzzzzzzz\0\163\163\0\164\60\0\206\11zzz\0\19\119\0\29\112\0\21\3\0\65\152\0\53\81\0\14\82\0\21\145\0\53\8\0\35\22\0\42\201\0\23\242\0\32\185zzz\0\1\244zzzzzz\0\2\238zzzzzz\0\0\0\0\2\238\0\12\245zzz\0\0\0\0\18\89\0\5\220\0\21\144\0\7\208\0\1\119\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0zzz\0\20\172\0\73\24\0\39\79\0\37\117\0\42\78\0\94\95\0\33\50\0\31\71\0\9\23\0\17\28\0\72\4\0\137\243\0\41\138zzzzzzzzzzzz\0\0\0zzz\0\78\176zzz\0\11\98\0\67\41\0\26\247\0\35\119\0\40\194\0\15\201\0\37\188\0\37\180\0\17\189\0\20\157\0\30\155\0\11\94\0\57\12zzz\0\23\69\0\43\153\0\18\192\0\15\174\0\66\34\0\34\103\0\21\166\0\58\224\0\17\187\0\44\212\0\72\0\0\61\224\0\56\37\0\24\238\0\44\11zzzzzzzzzzzzzzzzzz\0\21\166\0\35\22\0\136\253\0\43\16\0\153\120\0\29\138\0\45\184\0\36\181\0\138\1\0\138\134\0\139\10\0\59\42\0\59\98\0\29\205\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0zzzzzz\0\0\138\0\0\208\0\9\196\0\69\132\0\23\42\0\0\0\0\99\157\0\39\254\0\157\235\0\41\184\0\2\238zzzzzz\0\33\149zzz\0\96\69\0\113\61\0\151\145\0\135\105zzzzzz\0\0\85\0\68\187\0\41\99\0\173\26\0\97\76\0\63\15\0\222\89\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\2\238\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\42\0\0\215\0\0\67\0\0\125\0\0\175\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0zzzzzzzzz\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0zzz\0\34\46\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0zzz\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0zzzzzzzzz\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\146\0\0\0zzz\0\0\0\0\0\250\0\9\196zzz\0\0\0\0\9\196\0\9\196\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\200\0\0\200\0\0\1\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0zzz\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0zzzzzzzzz\0\0\200zzzzzzzzz\0\0\0\0\107\11\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\1\244\0\0\0\0\0\0\0\2\113zzzzzzzzzzzzzzzzzzzzz\0\0\6\0\0\2\0\0\0zzzzzzzzz\0\0\0zzz\0\0\0\0\42\43zzz\0\117\192\0\13\201\0\27\250\0\58\189\0\66\84zzzzzzzzz\0\1\244zzz\0\1\244zzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzz\0\3\232\0\4\226zzzzzzzzzzzz\0\2\238\0\2\238\0\2\238\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0zzz\0\2\238\0\2\238\0\2\238\0\3\232\0\3\232\0\3\232zzz\0\0\0\0\0\0zzzzzzzzzzzzzzzzzzzzzzzz\0\0\0\0\0\0\0\0\0\0\0\0zzzzzzzzz\0\0\5zzz\0\0\10\0\0\5\0\0\45\0\0\4\0\66\42\0\79\181\0\93\89\0\65\235zzz\0\0\0\0\0\0\0\0\0\0\0\0\0\4\76\0\4\76\0\4\76\0\4\226\0\4\226\0\11\184\0\5\70\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0zzz\0\5\170\0\5\170\0\6\14\0\6\14zzz\0\0\0\0\6\160zzzzzz\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0zzzzzz\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\31\206\0\39\119\0\0\0\0\64\101zzzzzzzzzzzzzzz\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0zzzzzz\0\0\1\0\0\2zzz\0\1\252\0\5\255\0\13\253\0\20\143\0\4\101\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\27\218\0\2\125\0\3\204\0\20\42\0\15\53\0\53\22\0\61\149zzz\0\25\198\0\23\244zzzzzz\0\0\0zzzzzz\0\0\0zzzzzzzzz\0\0\0\0\0\0\0\0\0\0\24\106\0\0\150\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\250\0\0\250\0\0\0\0\0\0zzzzzzzzz\0\0\0\0\1\244\0\2\88\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\2\238\0\0\0\0\0\70\0\0\145\0\2\164\0\3\245\0\6\27\0\8\115\0\0\80\0\0\205\0\1\147\0\3\12\0\2\68\0\3\62\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\4\181\0\6\56\0\8\32zzz\0\0\168\0\0\108\0\3\130\0\1\247\0\2\66\0\5\204zzzzzz\0\7\36\0\0\200\0\1\72\0\4\180\0\2\92\0\7\108\0\6\176\0\0\0zzzzzz\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\200zzzzzz\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0zzzzzzzzzzzzzzzzzzzzz\0\13\235zzzzzzzzz\0\0\0\0\1\244\0\0\7zzzzzzzzzzzzzzz\0\0\0zzz\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\25\110zzzzzz\0\0\0\0\0\0\0\0\0\0\0\0zzzzzzzzzzzz\0\0\1\0\0\1\0\0\1zzz\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0zzz\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\3\232\0\3\232\0\3\232\0\3\232\0\3\232\0\3\232zzzzzzzzz\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0zzzzzz\0\0\1\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\250\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0zzz\0\119\192\0\132\208\0\73\134\0\75\56\0\200\25\0\178\192zzz\0\11\184\0\11\184\0\11\184\0\0\0\0\11\184\0\11\184\0\0\0zzz\0\0\0\0\0\0\0\0\0\0\0\0zzz\0\39\15\0\35\119\0\40\212\0\37\226\0\57\76\0\95\113\0\95\207\0\0\5\0\77\181\0\63\221\0\96\57\0\27\151\0\138\123\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0zzzzzzzzzzzzzzzzzzzzzzzz\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\29\38\0\0\0\0\0\0\0\33\84\0\0\0\0\0\0zzz\0\67\5\0\0\0\0\0\0\0\0\0\0\0\0zzz\0\56\128\0\0\0\0\45\135\0\106\157\0\45\218\0\0\0\0\0\0zzz\0\0\0\0\246\110\0\54\117\0\36\113\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\143\144\0\50\186\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\64\226zzzzzzzzz\0\130\253zzz\0\98\248\0\74\129\0\49\218\0\75\100zzzzzzzzz\0\65\30zzzzzz\0\0\0\0\0\0\0\0\0\0\0\0\0\34\46\0\144\17\0\153\74\0\54\41\0\80\238\0\65\19\0\97\251\0\78\173\0\168\226zzzzzzzzzzzz\0\57\35\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\40\158\0\48\237\0\33\158\0\59\98\0\33\221\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\49\176\0\49\223\0\132\43\0\113\155\0\198\52\0\93\178\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\122\227\0\196\1zzz\0\157\247\0\0\0\0\35\193\0\75\92\0\200\87\0\39\16\0\5\220\0\54\155\0\11\184\0\51\27\0\39\16\0\190\242\0\153\86zzz\0\39\16\0\104\137\0\87\113\0\55\73\0\92\125\0\53\89\0\9\196\0\9\196\0\2\163\0\2\163zzzzzzzzz\0\39\16zzzzzzzzz\0\0\0zzz\0\0\0\0\43\183\0\27\225\0\58\184\0\66\154zzzzzz\0\0\62\0\0\30\0\0\7\0\0\5\0\0\7\0\0\7\0\0\12\0\0\14\0\1\132\0\5\214\0\3\14\0\61\159\0\83\129\0\18\160\0\27\223\0\50\171\0\20\87\0\27\130\0\106\55\0\133\60\0\34\4\0\38\91\0\34\65\0\25\142\0\25\142\0\40\47\0\41\170\0\58\114\0\37\190\0\47\92\0\22\144\0\63\159\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\80\40zzz\0\7\54\0\2\199zzz\0\0\12\0\19\15\0\50\30\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\133\146\0\0\0\0\53\247\0\24\59\0\127\211\0\160\90\0\38\159\0\32\75\0\84\100\0\48\104zzz\0\54\221zzz\0\78\156\0\46\58\0\24\191\0\37\65\0\65\80\0\159\28\0\211\151\0\169\227\0\170\129\0\79\251\0\64\100\0\96\14\0\112\127\0\86\29\0\64\197\0\56\252\0\226\247\0\227\210\0\76\190\0\77\209\0\51\106\0\1\28\0\0\187\0\0\213\0\2\159\0\1\133\0\23\8\0\20\183\0\83\237\0\34\117\0\25\192\0\30\232zzzzzzzzzzzzzzzzzzzzzzzzzzz\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\31\3\0\39\41\0\117\204\0\1\208\0\0\164\0\4\63\0\3\229\0\6\185\0\6\174\0\15\129\0\18\41\0\15\131\0\19\107\0\18\131\0\30\98\0\30\216\0\28\246\0\29\47\0\41\43\0\1\240\0\4\38\0\4\106\0\8\141\0\8\96\0\6\209\0\11\69\0\27\201\0\29\47\0\32\114\0\24\173\0\28\228\0\3\106\0\5\32\0\3\146\0\6\177\0\25\69\0\11\80\0\21\162\0\160\94\0\19\107\0\24\178\0\0\250\0\35\203\0\34\109\0\4\40\0\4\40\0\3\127\0\8\126\0\9\165\0\18\41\0\9\159\0\18\41\0\24\145\0\34\107\0\30\101\0\35\3\0\54\18\0\16\124\0\15\129\0\63\163\0\18\110\0\19\107\0\21\20\0\20\162\0\30\77\0\24\113\0\15\167\0\21\19\0\27\231\0\30\214\0\21\20zzz\0\19\148\0\21\137\0\23\94\0\0\87\0\35\132\0\16\128\0\16\68\0\56\110\0\18\141\0\21\20\0\20\25\0\30\87\0\22\125\0\19\132\0\25\107\0\65\210\0\35\3\0\35\36\0\3\69\0\3\69\0\3\69\0\32\183\0\32\183\0\32\183\0\32\184\0\48\89zzz\0\157\20\0\157\173\0\0\0\0\0\0\0\31\17\0\43\141\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\53\158\0\28\180\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\35\82\0\47\125\0\0\0\0\0\0\0\0\0\0\0\0\0\90\15\0\45\49\0\45\90\0\53\104\0\40\167\0\40\204\0\34\30\0\48\53\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0zzz\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0zzz\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\2\238\0\4\76\0\4\76\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\87\0\50\95\0\0\0\0\0\0\0\0\0\0\0\0\0\0\250zzzzzz\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\87\0\0\87\0\0\112\0\0\112\0\0\112\0\0\150\0\0\150\0\0\95\0\1\44\0\0\0\0\1\44\0\1\44\0\1\44\0\1\44\0\1\44\0\1\44\0\1\44zzzzzz\0\0\0\0\0\0\0\0\4\0\0\10\0\0\188\0\0\6\0\1\144\0\4\226\0\4\226zzz\0\2\238\0\4\226\0\2\238zzzzzzzzzzzz\0\0\2\0\6\214\0\6\214zzzzzz\0\179\156\0\0\0\0\0\0\0\0\0\0\22\42\0\25\6\0\23\151\0\31\132\0\42\27\0\49\75\0\13\217\0\17\131\0\27\85\0\34\61\0\15\46\0\0\0\0\31\136\0\40\155\0\3\182zzzzzz\0\5\220\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\8zzzzzz\0\0\0zzzzzzzzzzzz\0\0\0zzzzzzzzz\0\0\0\0\1\26\0\2\210\0\0\0\0\0\0\0\0\16zzzzzzzzzzzz\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0zzzzzz\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0zzz\0\0\0\0\0\0\0\0\0zzzzzzzzzzzz\0\0\0zzz\0\0\0zzzzzzzzzzzzzzzzzzzzz\0\0\2zzzzzzzzzzzzzzzzzzzzzzzz\0\0\0zzz\0\2\88\0\19\136\0\27\88\0\0\0\0\7\208\0\39\16\0\0\250zzzzzzzzz\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0zzzzzzzzz\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0zzz\0\0\0\0\0\75\0\63\42\0\31\224\0\0\0\0\34\93\0\70\134\0\70\197zzzzzz\0\0\0\0\118\200\0\66\107\0\29\172\0\66\138\0\40\2\0\64\37\0\95\142\0\0\0\0\110\197\0\0\0\0\38\10\0\41\142\0\82\77\0\82\153\0\58\255\0\118\81zzzzzzzzzzzzzzzzzzzzzzzzzzz\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0zzzzzz\0\0\19\0\0\19\0\0\19\0\0\19\0\5\220\0\5\220\0\0\0\0\0\0\0\0\0\0\5\220\0\0\0\0\5\220\0\5\220\0\5\220\0\5\220\0\0\0\0\79\50\0\165\206\0\33\72\0\40\21\0\26\209zzz\0\0\0\0\0\0\0\34\80\0\32\217zzz\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\182\0\0\0zzzzzz\0\0\0\0\138\4\0\147\201\0\5\220zzz\0\112\211\0\189\117zzzzzz\0\136\110\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\48\68\0\27\244\0\28\239\0\27\170\0\29\39\0\41\23\0\27\190\0\53\102\0\44\114\0\45\74\0\42\228\0\69\35\0\37\2\0\77\211\0\55\237\0\98\8zzz\0\0\0\0\0\0\0\0\0zzzzzzzzzzzzzzzzzz\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\199\255\1\5\99zzz\0\0\0zzz\0\73\241\0\89\119\0\38\171\1\9\226\0\0\0\1\78\218\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\123\205\0\94\125\0\56\32\0\113\178\0\47\201\0\31\112\0\51\176\0\77\83\0\83\144\0\83\225\0\85\94\0\116\8\0\116\119\0\0\0\0\0\0\0\0\0\0\147\127\0\148\5\0\109\180\0\176\29zzzzzz\0\80\162\0\89\63\0\35\231zzz\0\113\193\0\0\0zzz\0\61\82\0\55\19\0\101\99\0\59\206zzz\0\91\156\0\70\237zzz\0\97\229\0\144\66\0\154\31zzz\0\0\75\0\0\200\0\1\244zzzzzzzzzzzzzzz\0\140\215zzz\0\141\222\0\0\62\0\1\244\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\2\88zzz\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\11\184\0\11\184\0\11\184\0\11\184\0\0\0\0\11\184\0\11\184\0\13\172\0\11\184\0\15\160\0\15\160\0\19\136\0\19\136\0\19\136\0\19\136\0\21\124\0\21\124\0\19\136\0\24\106\0\24\106\0\24\106\0\39\16\0\29\76\0\29\76\0\29\76\0\29\76zzz\0\203\227zzz\0\39\16zzz\0\39\16\0\39\16\0\39\16\0\58\152\0\58\152\0\58\152\0\58\152\0\78\32zzzzzzzzzzzz\0\58\152\0\58\152\0\58\152\0\78\32\0\0\0zzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzz\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\83\111zzz\0\0\0\0\0\0\0\127\175\0\128\45\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0zzzzzz\0\0\0zzz\0\0\0zzzzzz\0\151\215\0\129\56\0\140\204\0\156\13\0\187\253\0\150\248\0\0\0\0\0\0zzz\0\166\225\0\221\232\0\204\173\1\0\200zzz\0\0\0\0\0\0\0\0\0\0\0\0\1\6\89\0\153\243\0\153\87\0\77\134\0\197\244\0\0\0\0\249\81\0\200\52\0\200\238\0\27\88\0\39\16\0\0\0\0\0\0\0\1\244\0\7\208\0\0\0zzzzzz\0\3\232\0\39\16\0\1\244\0\78\32zzzzzzzzzzzz\0\0\0\0\0\0\0\0\0\0\15\160zzz\0\15\160zzz\0\19\136\0\19\136\0\19\136\0\0\0\0\19\136\0\21\124zzz\0\21\124\0\0\0\0\0\0\0\78\32\0\78\32\0\78\32\0\78\32\0\78\32\0\78\32\0\78\32zzzzzzzzzzzzzzzzzzzzzzzzzzzzzz\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\31\112\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0zzzzzzzzzzzzzzz\0\0\0\0\0\0zzz\0\0\0\0\0\0zzz\0\187\199zzzzzzzzzzzzzzz\0\0\0\0\0\0\0\165\167\0\0\0\0\61\182zzzzzz\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0zzzzzzzzzzzz\0\58\59\0\72\60zzz\0\76\190\0\39\16\0\0\0\0\0\0\0\0\0\0\0\0\0\142\184\0\72\8\0\0\0zzz\0\212\58\0\192\182\0\0\0zzz\0\0\0\0\0\0\0\155\6zzz\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\101\101\0\87\102zzzzzzzzzzzz\0\48\212\0\0\0\0\69\88\0\0\0\0\0\0\0\97\115\0\117\99\0\78\143\0\49\73\0\59\92\0\59\150\0\249\55\0\0\0\0\0\0\0\0\0zzz\0\23\217\0\8\157\0\6\234\0\1\99\0\2\22\0\2\105\0\0\0\0\0\0\0\3\83\0\9\58\0\5\143\0\4\129\0\0\0\0\3\138\0\4\113\0\11\38\0\10\29\0\0\0\0\12\188\0\0\0\0\3\20\0\0\0\0\5\247\0\7\128\0\3\252\0\3\85\0\237\143\0\41\152\0\57\25\0\193\232\0\131\55\0\5\51\0\199\188\0\53\17\0\50\15\0\59\63\0\8\193\0\4\7\0\4\217\0\48\67\0\135\145\0\203\138\0\18\163\0\67\57\0\124\223\0\18\157\0\35\25\0\65\54\0\109\86\0\150\35\0\18\255\0\40\224\0\75\241\0\132\40\0\198\112\0\21\237\0\51\57\0\5\121\0\16\42\0\31\158\0\57\118\0\98\53\0\160\28\0\18\121\0\37\158\0\69\228\0\115\4\0\17\164\0\68\188\0\126\133\0\206\64\0\42\57\0\136\226\0\221\12\0\23\83\0\24\47\0\0\0\0\89\127\0\162\205\0\231\50\0\61\189\0\114\183\0\188\202\0\21\6\0\85\73\0\151\63\0\237\112\0\0\0\0\11\175\0\22\219\0\44\223\0\81\209\0\61\100\0\98\10\0\32\166\0\0\0\0\96\30\0\27\236\0\71\175\0\61\245\0\54\219\0\135\235\0\32\108\0\56\142\0\0\0\0\13\31\0\0\0\0\27\211\0\51\179\0\126\92\0\25\214\0\35\177zzz\0\23\8\0\28\245\0\31\103\0\0\0\0\41\141\0\0\0\0\13\53\0\10\86\0\25\246\0\30\233\0\8\116\0\59\178\0\5\151\0\21\45\0\55\238\0\26\223\0\13\125\0\0\0\0\8\99\0\4\192\0\41\32\0\9\142\0\31\216\0\19\104\0\54\169\0\37\153\0\72\60\0\10\14\0\27\79\0\73\17\0\14\246\0\41\105\0\11\247\0\37\33\0\13\100\0\44\225\0\121\154\0\15\156\0\50\154\0\40\134\0\11\205\0\41\47\0\29\197\0\97\233\0\9\8\0\28\172\0\87\19\0\30\36\0\54\177\0\5\176\0\22\242\0\45\12\0\82\37zzz\0\47\61\0\72\10\0\83\124\0\26\209\0\18\152\0\135\144\0\0\0\0\236\64\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0zzzzzzzzzzzzzzz\0\0\0\0\248\6\0\70\25\0\253\67\0\41\43\0\0\0\0\96\235\0\232\18\0\130\118\0\93\140\0\75\30\0\27\88zzz\0\0\11zzz\0\119\155zzz\0\64\12\0\53\214\0\58\68zzz\0\34\93\0\172\110\0\202\59\0\51\114\0\61\242zzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzz\0\198\163\0\17\47\0\0\0\0\0\0zzz\0\60\169\0\202\233\0\132\37\0\74\254zzz\0\47\59zzz\0\70\104\0\56\138\0\41\174\0\37\161\0\0\0\0\0\0\0\49\251\0\34\110\0\201\100\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\132\254\0\56\146\0\4\40\0\195\77\0\22\205\0\115\230\0\246\223zzzzzz\0\48\146\0\38\255\0\101\27\0\56\30\0\0\0\0\70\168\0\50\85\0\105\225\0\85\27\0\40\212\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\53\116\0\58\59\0\77\73\0\214\140\0\172\74\0\2\113\0\2\113zzz\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0zzzzzzzzzzzzzzzzzz\0\1\194\0\0\250\0\1\244\0\9\196\0\0\0zzz\0\110\18\0\44\132\0\0\0zzz\0\0\0\0\0\0zzzzzzzzz\0\0\0\0\0\0\0\0\0zzzzzzzzzzzz\0\0\0zzzzzzzzzzzzzzz\0\0\0\0\0\0\0\0\0\0\0\0\0\58\2\0\0\0\0\0\0\0\0\0\0\60\130\0\60\97\0\81\71zzz\0\255\217\0\205\109zzzzzzzzz\0\40\212zzz\0\0\0zzzzzz\0\73\245\0\89\20\0\198\180\0\199\116\0\7\208\0\7\208\0\7\208\0\7\208\0\11\184zzz\0\201\233\0\61\159zzz\0\26\1\0\249\25\0\57\254\0\55\235\0\119\192\0\53\170\0\0\7\0\85\212\0\41\238\0\145\4\0\101\176\0\42\98\0\104\240\0\61\203\0\51\181\0\59\78\0\59\134\0\79\168\0\82\8\0\61\190\0\61\245\0\47\179\0\235\80\0\124\64\0\44\139\0\120\133\0\57\88\0\72\242\0\180\232\0\63\233\0\194\11\0\82\176\0\36\185\0\62\23\0\89\101\0\0\0\0\0\0\0\172\110\0\34\156\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\10\0\0\125\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\1\244\0\1\144\0\5\220\0\1\244\0\3\232\0\4\226zzz\0\0\0zzzzzz\0\4\226\0\4\226\0\2\238\0\2\238\0\2\238\0\2\238\0\2\238\0\0\100\0\0\0\0\2\238\0\2\238\0\0\100\0\0\100\0\0\150\0\0\250\0\0\250\0\3\232zzzzzzzzz\0\0\0\0\27\252\0\96\149\0\31\173\0\11\184\0\11\184\0\12\178\0\13\172\0\14\166\0\14\166zzzzzzzzzzzz\0\14\166\0\14\166\0\14\166\0\14\166\0\15\160\0\15\160\0\19\136\0\19\136\0\23\112\0\23\112\0\23\112\0\23\112\0\135\248\0\23\112\0\0\0\0\29\76\0\74\45\0\97\168\0\0\0\1\65\39\0\19\136zzz\0\18\170\0\21\17\0\19\136\0\19\136\0\19\136\0\19\136\0\22\188\0\37\128\0\0\0\0\78\32\0\39\16\0\39\16\0\39\16\0\39\16\0\39\16zzz\0\48\170\0\31\174\0\39\193\0\83\166\0\48\18\0\121\219\0\47\200\0\79\240\0\48\36\0\84\103\0\147\96\0\65\189zzz\0\41\98\0\75\23\0\58\174\0\0\0\0\0\0zzz\0\0\0zzzzzz\0\0\62\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0zzz\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0zzzzzzzzzzzz\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0zzzzzz\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0zzz\0\0\0zzz\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0zzzzzzzzzzzzzzzzzz\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\1\44zzz\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0zzz\0\0\0\0\0\6\0\0\7\0\0\9\0\0\10\0\0\4\0\0\10\0\0\10zzz\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\1\44\0\0\0\0\0\0\0\1\44\0\0\0zzz\0\41\65\0\73\109\0\52\119\0\77\169\0\47\10\0\70\73\0\44\178\0\51\51\0\35\55\0\39\184\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0zzz\0\1\56zzzzzz\0\0\0\0\0\0\0\19\248\0\42\126\0\42\165\0\0\0\0\34\37\0\0\0\0\0\0\0\25\217\0\37\81\0\52\243\0\44\94\0\47\106\0\37\193\0\37\230\0\21\95\0\52\124zzzzzz\0\0\1\0\0\1\0\0\25\0\0\30\0\0\32\0\0\35\0\0\37\0\0\100\0\0\60\0\0\60\0\0\75\0\0\50\0\0\50\0\0\75\0\0\12\0\0\5\0\0\70\0\0\100zzz\0\0\15\0\0\0\1\139\204\0\43\12\0\2\83\0\225\139\0\13\200\0\107\50\0\0\25\0\0\25\0\0\25\0\0\25\0\0\25\0\0\50\0\0\50\0\0\55\0\0\55\0\0\62\0\0\80\0\0\90\0\0\100\0\0\125\0\0\125\0\0\150\0\0\200\0\0\1\0\0\0zzz\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\39\16\0\0\8\0\0\8\0\0\10\0\0\5\0\0\12\0\0\12\0\0\14\0\0\18\0\0\10\0\0\0\1\60\233\0\143\38\0\15\160\0\15\160\0\15\160\0\15\160\0\15\160\0\97\164\0\19\136\0\19\136\0\19\136\0\19\136\0\19\136\0\59\231\0\70\139\0\206\114\0\207\42\0\76\231\0\107\215\0\41\78\0\46\225\0\37\33\0\65\154\0\50\28\0\70\108\0\47\32\0\56\197\0\195\66\0\63\122\0\63\122\0\88\9\0\63\122\0\60\110\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\245\127\0\243\32\0\203\61\0\0\0\0\61\107\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\129\26\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\35\31\0\35\31\0\197\191\0\0\188\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\41\65\0\23\67\0\37\31\0\52\169\0\19\136\0\1\144\0\7\208\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0zzz\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\45\0\0\16\0\0\24\0\0\30\0\0\119\0\0\120\0\0\0\0\0\21\0\0\121\0\0\36\0\1\69\0\0\236\0\0\43\0\0\47\0\47\57\0\23\178\0\0\60\0\37\244\0\60\124\0\0\0\0\68\26\0\51\85\0\43\104\0\1\85\0\0\84\0\42\23\0\49\52\0\0\139\0\0\242\0\0\70\0\0\106\0\0\163\0\0\0\0\1\122\0\2\65\0\2\67\0\0\219\0\1\31\0\1\36\0\2\164\0\1\140\0\3\232\0\62\221\0\1\159\0\48\42\0\0\242\0\48\153\0\3\182\0\44\16\0\0\0\0\66\129\0\70\193\0\78\74\0\59\193\0\60\205\0\50\59\0\23\199\0\22\131\0\56\38\0\4\214\0\51\76\0\1\118\0\0\250\0\1\121\0\1\248\0\4\243\0\104\242\0\105\85\0\105\186\0\78\32\0\156\64\0\1\178\0\4\212\0\2\58\0\0\251\0\1\81\0\1\189\0\4\144\0\1\56\0\4\17\0\0\238\0\1\102\0\1\20\0\1\30\0\1\75\0\2\226\0\3\69\0\1\25\0\1\112\0\3\79\0\3\152\0\2\119\0\5\252\0\2\235\0\7\78\0\3\7\0\4\143\0\6\174\0\6\180\0\2\135\0\4\155\0\2\205\0\3\214\0\6\52\0\7\140\0\3\113\0\7\154\0\7\214\0\2\244\0\4\228\0\6\137\0\3\157\0\5\251\0\4\216\0\8\210\0\8\12\0\13\8\0\10\194\0\11\225\0\4\18\0\4\22\0\12\4\0\9\12\0\4\172\0\6\101\0\5\45\0\8\146\0\13\225\0\7\217\0\13\251\0\19\23\0\6\102\0\10\153\0\7\254\0\13\114\0\5\231\0\7\42\0\10\139\0\15\61\0\18\86\0\6\195\0\9\196\0\13\232\0\9\83\0\20\44\0\7\113\0\12\25\0\17\124\0\20\120\0\6\253\0\11\93\0\28\38\0\14\107\0\12\104\0\8\246\0\9\7\0\21\37\0\15\235\0\26\214\0\9\42\0\17\99\0\17\115\0\9\69\0\29\135\0\15\33\0\13\4\0\19\50\0\11\3\0\30\18\0\10\69\0\7\208\0\24\50\0\12\37\0\19\192\0\11\84\0\15\204\0\12\84\0\23\99\0\31\77\0\38\125\0\21\230\0\38\198\0\13\158\0\22\37\0\19\13\0\25\199\0\14\237\0\24\231\0\40\208\0\43\107\0\14\14\0\39\147\0\26\69\0\16\110\0\23\31\0\31\242\0\17\200\0\45\126\0\51\79\0\26\249\0\18\12\0\51\227\0\55\52\0\20\11\0\30\45\0\18\222\0\26\139\0\38\129\0\20\103\0\51\181\0\29\144\0\52\244\0\37\157\0\33\154\0\30\5\0\21\75\0\25\117\0\63\81\0\24\50\0\56\13\0\65\191\0\47\32\0\67\36\0\26\211\0\45\95\0\25\124\0\51\21\0\36\82\0\30\174\0\64\166\0\44\7\0\62\190\0\64\185\0\44\137\0\26\199\0\36\222\0\49\241\0\32\130\0\65\66\0\49\207\0\68\125\0\29\235\0\70\214\0\51\59\0\33\207\0\45\134\0\53\48\0\35\29\0\70\121\0\53\10\0\65\240\0\32\61zzzzzz\0\79\81\0\4\226\0\15\160zzzzzz\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\1\69\0\0\214\0\0\189\0\0\252\0\1\90\0\3\41\0\1\217\0\3\48\0\5\150\0\2\13\0\2\187\0\2\16\0\2\40\0\2\90\0\3\229\0\6\79\0\5\193zzz\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0zzzzzz\0\6\64\0\9\51\0\5\185\0\4\191\0\6\250\0\3\70\0\3\249\0\9\168\0\9\176\0\3\167\0\16\170\0\8\227\0\6\171\0\10\150\0\5\107\0\8\250\0\15\107\0\4\252\0\13\82\0\5\5\0\23\0\0\12\26\0\7\127\0\11\73\0\15\105\0\8\215\0\13\78\0\20\196\0\24\79\0\8\77\0\35\164\0\18\109\0\10\84\0\14\102\0\11\61\0\18\71\0\26\108\0\34\2\0\10\218\0\20\150\0\46\226\0\24\48\0\14\252\0\20\227\0\27\255\0\17\129\0\26\89\0\42\203\0\48\65\0\16\152\0\34\97\0\21\179\0\39\141\0\28\196\0\21\161\0\34\132\0\61\61\0\21\222\0\61\176\0\68\166\0\29\151\0\49\29\0\42\46\0\51\140\0\34\7\0\68\75\0\51\104\0\70\168\0\33\148\0\11\184\0\11\184\0\11\184\0\11\184\0\11\184\0\11\184\0\11\184\0\11\184\0\11\184\0\0\0\0\13\172\0\13\172\0\13\172\0\13\172\0\15\160\0\15\160\0\15\160\0\15\160\0\15\160\0\15\160\0\39\16\0\193\215\0\19\136\0\19\136\0\19\136\0\19\136\0\19\136\0\19\136\0\21\124\0\21\124\0\21\124\0\21\124\0\24\106\0\29\76\0\29\76\0\29\76\0\47\137\0\71\147\0\39\16\0\39\16\0\39\16\0\39\16\0\58\152\0\58\152\0\58\152\0\58\152\0\58\152\0\58\152\0\58\152\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\114\16zzz\0\0\0\0\67\178\0\19\136\0\0\0\0\124\126\0\1\169\0\3\232\0\233\243\0\0\0\0\0\0\0\0\0\0\0\0\0\121\188\0\108\40\0\62\36\0\77\244zzz\1\2\31zzz\0\38\42zzz\0\96\36zzzzzz\0\90\76\0\53\69\0\0\0\0\41\105\0\104\236\0\66\229\0\190\147\1\20\244\0\0\0\0\69\216\0\41\4\0\1\23\0\1\228\0\0\245\0\4\15\0\1\19\0\1\48\0\3\41\0\3\242\0\2\17\0\3\29\0\1\216\0\7\78\0\1\240\0\2\97\0\5\9\0\6\32\0\0\0\0\190\130\0\81\108\0\3\215\0\6\255\0\3\50\0\11\96\0\4\65\0\5\53\0\10\113\0\10\127\0\0\3\0\7\238\0\7\197\0\12\222\0\7\29\0\16\84\0\21\218\0\8\162\0\8\188\0\17\148\0\13\60\0\0\0\0\10\95\0\18\55\0\10\115\0\28\139\0\11\179\0\17\31\0\23\98\0\26\212\0\11\139\0\21\205\0\12\90\0\0\0zzz\0\122\162\0\123\15zzz\0\61\247\0\56\68\0\85\25\0\24\106\0\0\0zzz\0\67\74\0\100\141\0\67\205\0\135\89\0\135\216zzz\0\78\53\0\0\200zzz\0\40\149\0\0\250\0\61\78\0\82\8\0\61\190\0\2\113\0\2\238\0\47\16\0\94\125\0\94\218\0\1\119\0\47\201\0\71\244\0\0\0\0\0\0zzzzzzzzzzzzzzzzzzzzzzzz\0\16\120\0\26\198\0\15\91\0\40\152\0\16\204\0\16\99\0\30\204\0\36\166\0\27\151\0\21\85\0\36\197\0\20\21\0\58\210\0\24\70\0\24\223\0\42\18\0\53\29\0\37\182\0\79\172\0\50\212\0\28\141\0\32\111\0\32\78\0\31\246\0\54\17\0\72\92\0\51\100zzz\0\85\45\0\62\108\0\38\178\0\46\156\0\40\237\0\42\58\0\64\111\0\85\18\0\63\40\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\1\168\0\1\34\0\0\253\0\1\36\0\1\81\0\3\10\0\1\229\0\3\102\0\4\199\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\4\94\0\2\71\0\9\6\0\1\188\0\2\77\0\2\156\0\6\14\0\5\45\0\4\44\0\13\126\0\3\210\0\10\50\0\4\169\0\4\94\0\7\68\0\12\226\0\8\219\0\7\218\0\24\119\0\7\232\0\15\234\0\6\149\0\8\202\0\17\76\0\21\110\0\17\126\0\33\118\0\21\178\0\12\100\0\11\214\0\12\212\0\11\236\0\24\108\0\32\175\0\24\182\0\37\238\0\19\69\0\52\35\0\55\209\0\18\9\0\19\140\0\21\48\0\32\10\0\37\86\0\46\65\0\32\131\0\25\8\0\68\133\0\73\93\0\23\168\0\27\48\0\27\73\0\41\67\0\49\146\0\66\87\0\44\163\0\93\229\0\67\156\0\100\226\0\31\220\0\38\21\0\35\127\0\63\168\0\80\97\0\60\200\0\32\19\0\45\61\0\73\217\0\45\149\0\101\116\0\108\156\0\41\105\0\75\235\0\50\30\0\100\152\0\76\15\0\0\0\0\0\0\0\0\0\0\36\42\0\0\0\0\0\0\0\0\0\0\33\147\0\15\228\0\15\243\0\25\190\0\34\133\0\25\240\0\28\29\0\16\64\0\20\140\0\19\25\0\56\1\0\0\0\0\0\0\0\19\226\0\32\20\0\54\45\0\29\60\0\48\195\0\34\92\0\78\107\0\0\0\0\31\45\0\29\63\0\46\196\0\56\112\0\71\99\0\50\154\0\75\220\0\28\178\0\110\198\0\44\180\0\42\83\0\63\57\0\80\27\0\101\80\0\71\204\0\34\176\0\112\215\0\54\171\0\52\68\0\82\1\0\84\158\0\113\120\0\86\96\0\52\24\0\0\0\0\0\0zzz\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0zzz\0\33\135\0\23\82\0\15\185\0\15\199\0\25\117\0\29\97\0\23\216\0\29\58\0\14\241\0\63\51\0\22\30\0\20\142\0\41\200\0\56\6\0\33\106\0\20\219\0\36\89\0\59\128\0\45\178\0\24\174\0\79\22\0\67\102\0\27\8\0\25\32\0\52\168\0\66\157\0\43\183\0\56\115\0\31\168\0\95\235\0\72\16\0\38\124\0\36\113\0\86\163\0\61\103\0\89\166\0\118\57\0\80\103\0\54\52\0\46\111\0\81\24\0\110\67\0\77\211\0\44\123\0\46\112\0\27\178\0\17\75\0\17\91\0\17\108\0\32\203\0\43\249\0\28\83\0\43\190\0\70\108\0\26\220\0\24\246\0\40\69\0\49\248\0\62\156\0\59\130\0\36\247\0\21\95\0\49\73\0\88\115\0\35\92\0\33\124\0\63\44\0\79\234\0\56\165\0\84\237\0\30\153\0\117\131\0\47\55\0\44\180\0\83\133\0\106\161\0\75\146\0\71\140\0\108\162\0\41\80\0\115\222\0\55\111\0\54\225\0\85\113\0\86\235\0\118\36\0\87\145\0\111\185\0\54\230\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0zzz\0\0\20\0\0\42\0\0\28\0\0\73\0\0\24\0\0\37\0\0\162\0\0\163\0\0\184\0\1\40\0\0\86\0\2\73\0\0\86\0\0\200\0\2\99\0\2\194\0\1\110\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0zzzzzzzzz\0\77\226\0\87\210\0\112\140\0\95\89\0\80\63\0\101\215\0\84\232\0\116\78\0\67\123\0\56\223\0\60\110\0\81\230\0\73\40\0\68\223\0\96\200\0\83\29\0\53\235\0\100\109\0\45\181\0\77\5\0\86\217\0\92\98\0\49\214\0\79\135\0\66\117\0\37\32\0\44\179\0\63\106\0\45\10\0\26\211\0\72\17\0\64\220\0\29\191\0\37\177\0\85\0\0\71\54\0\76\110\0\40\135\0\26\216\0\28\143\0\85\192\0\51\98\0\69\228\0\38\173\0\0\0\0\80\34\0\28\27\0\29\232\0\32\176\0\55\75\0\81\149\0\63\33\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0zzzzzz\0\14\241\0\56\61\0\56\111\0\19\136\0\19\136\0\13\16\0\1\95\0\2\97\0\1\98\0\5\81\0\1\116\0\1\218\0\4\139\0\4\195\0\6\26\0\53\115\0\3\19\0\5\153\0\2\189\0\9\159\0\3\79\0\3\223\0\7\197\0\6\111\0\9\121\0\7\33\0\12\180\0\7\231\0\3\249\0\14\243\0\12\223\0\5\77\0\4\225\0\5\236\0\59\94\0\11\239\0\9\226\0\0\0\0\10\43\0\5\159\0\16\136\0\19\79\0\14\146\0\6\218\0\6\78\0\7\168\0\11\135\0\15\109\0\17\97\0\10\66\0\9\68\0\10\11\0\20\146\0\24\56\0\16\224\0\26\87\0\9\126\0\12\247\0\22\197\0\13\16\0\35\175\0\14\160\0\15\105\0\29\60\0\31\15\0\21\166\0\51\48\0\33\249\0\18\98\0\21\11\0\23\129\0\37\220\0\47\89\0\33\77\0\19\72\0\72\161\0\26\30\0\44\48\0\23\108\0\26\95\0\28\29\0\50\106\0\60\13\0\42\166\0\33\254\0\61\107\0\37\142\0\35\75\0\41\100\0\64\13\0\84\139\0\86\4zzzzzzzzzzzzzzz\0\0\0\0\2\4\0\2\109\0\3\11\0\4\39\0\3\89\0\3\146zzzzzz\0\3\57\0\7\125\0\13\122\0\31\229\0\44\92\0\65\104\0\101\76\0\121\20\0\144\184\0\161\160\0\158\104\0\170\25\0\4\195\0\9\72\0\10\135\0\23\70\0\34\51\0\85\165\0\110\148\0\124\180\0\10\195\0\19\169\0\23\224\0\40\236\0\44\90\0\82\99\0\107\93\0\119\62\0\142\144\0\159\250\0\167\58\0\11\196\0\17\74\0\30\191\0\49\225\0\90\244\0\166\118\0\171\159\0\6\255\0\15\37\0\26\239\0\69\21\0\109\2\0\123\59\0\139\0\0\166\49\0\185\171\0\201\43\0\210\45\0\12\234\0\45\36\0\52\218\0\84\48\0\112\217\0\162\45\0\182\231\0\205\58\0\211\170\0\4\0\0\11\220\0\88\247\0\170\181\0\202\28\0\200\201\0\123\178\0\139\130\0\176\207zzz\0\196\110\0\71\91\0\80\123\0\101\254\0\119\164\0\126\203\0\11\223\0\15\221\0\21\192\0\48\228\0\127\73\0\134\201zzz\0\76\135zzzzzz\0\78\167\0\88\184\0\121\217\0\0\45\0\1\49\0\0\42\0\0\86\0\0\108\0\0\47\0\1\43\0\1\158\0\1\156\0\0\208\0\3\47\0\0\241\0\0\220\0\1\23\0\3\214\0\2\233\0\2\2zzz\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\30\65\0\69\127\0\99\221\0\124\41\0\0\1\0\0\1zzz\0\2\111\0\4\35\0\2\43\0\8\215\0\2\25\0\3\60\0\2\68\0\6\133\0\7\235\0\5\107\0\9\162\0\3\248\0\6\161\0\11\91\0\4\115\0\9\212\0\7\102\0\10\228\0\3\187\0\3\24\0\6\14\0\9\81\0\4\66\0\16\5\0\13\139\0\6\64\0\6\84\0\15\95\0\10\133\0\14\20\0\23\67\0\9\68\0\8\156\0\15\31\0\19\30\0\9\127\0\9\111\0\20\130\0\24\102\0\14\90\0\12\25\0\21\63\0\13\139\0\13\55\0\27\18\0\28\195\0\20\12\0\33\205\0\12\119\0\17\6\0\29\230\0\17\39\0\49\49\0\19\179\0\20\193\0\35\195\0\44\185\0\28\119\0\21\208\0\24\213\0\39\162\0\63\47\0\47\146\0\24\238\0\25\79\0\57\23\0\40\139\0\2\70\0\2\219\0\0\108\0\0\151\0\0\109\0\0\73\0\0\110\0\1\24\0\1\81\0\0\245\0\1\146\0\1\244\0\1\244\0\3\232\0\19\136\0\40\43\0\1\244\0\138\142\0\5\220\0\1\244\0\3\232\0\1\244\1\2\194\0\2\88\0\0\100\0\62\198\0\1\244\0\1\244\0\5\124\0\32\81\0\52\107\0\33\88\0\31\88\0\35\89\0\60\75\0\76\217\0\55\24\0\82\107\0\41\92\0\63\252\0\41\23\0\50\45\0\43\31\0\65\201\0\86\222\0\65\97\0\89\212\0\4\95\0\5\124\0\4\103\0\0\0zzzzzz\0\1\169\0\2\22\0\2\131\0\0\215\0\1\14zzz\0\13\213\0\17\90\0\4\110\0\5\143\0\4\118\0\0\0\0\3\73\0\2\141\0\3\19\0\17\152\0\10\153\0\9\20\0\33\182\0\4\183\0\3\241\0\9\128\0\7\242\0\0\33\0\0\65\0\0\24\0\0\24\0\0\44\0\0\192\0\0\52\0\0\179\0\0\84\0\0\127\0\0\54\0\0\42\0\0\68\0\1\88\0\0\245\0\1\223\0\3\199\0\1\107\0\0\105\0\0\211\0\0\212\0\2\135\0\2\181\0\0\220\0\1\206\0\1\131\0\2\162\0\1\51\0\5\98\0\1\13\0\1\155\0\4\67\0\4\144\0\2\49\0\2\211\0\1\108\0\1\109\0\1\229\0\1\167\0\5\194\0\6\42\0\4\240\0\7\110\0\3\77\0\6\52\0\3\82\0\11\9\0\2\95\0\3\111\0\7\150\0\9\212\0\5\194\0\11\60\0\6\98\0\2\192\0\3\252\0\3\163\0\9\183\0\12\150\0\8\28\0\3\176\0\8\242\0\9\4\0\4\246\0\16\11\0\4\139\0\5\132\0\5\2\0\11\11\0\13\113\0\9\61\0\16\83\0\9\144\0\5\68\0\18\186\0\4\210\0\6\113\0\5\224\0\12\244\0\17\86\0\20\106\0\11\245\0\7\61\0\10\242\0\6\161\0\21\110\0\16\32\0\5\170\0\7\145\0\18\97\0\13\230\0\21\186\0\3\232\0\16\178\0\8\130\0\26\10\0\7\22\0\27\250\0\9\127\0\8\170\0\18\106\0\22\208\0\20\30\0\8\252\0\17\110\0\9\13\0\27\50\0\8\74\0\19\7\0\10\234\0\25\144\0\20\224\0\29\170\0\5\167\0\0\0\0\7\30\0\8\146\0\21\86\0\10\114\0\34\36\0\33\17\0\21\156\0\9\216\0\11\134\0\26\253\0\22\10\0\10\203\0\25\231\0\14\203\0\40\105\0\28\43\0\13\218\0\43\150\0\15\18\0\14\1\0\36\90\0\27\123\0\46\30\0\17\2\0\17\17\0\16\189\0\14\104\0\27\114\0\29\160\0\39\167\0\27\195\0\46\6\0\23\99\0\21\188\0\61\150\0\57\242\0\41\219\0\19\107\0\22\186\0\34\94\0\56\157\0\37\98\0\24\230\0\40\72\0\65\32\0\19\133\0\63\82\0\44\177\0\23\8\0\24\189\0\56\221\0\37\143\0\27\128\0\79\9\0\29\163\0\47\130\0\26\19\0\31\194\0\56\241\0\76\51\0\51\69\0\86\196\0\30\128\0\86\214\0\61\169\0\27\227\0\31\117\0\33\121\0\77\150\0\52\54\0\88\97\0\69\187\0\37\36\0\99\68\0\35\76\0\42\49\0\39\242\0\74\127\0\99\176\0\71\199\0\108\150\0\45\177\0\103\241\0\77\41\0\38\54\0\47\132\0\43\67\0\72\32\0\105\96\0\97\207\0\73\245\0\76\69\0\49\114\0\104\187\0\44\142\0\51\93\0\49\122\0\78\167\0\103\219\0\78\131\0\106\103\0\0\0\0\15\200\0\19\48\0\26\253\0\27\23\0\56\197\0\51\208\0\23\96zzz\0\11\10\0\16\177\0\0\25\0\0\0\0\0\0\0\28\228\0\37\173\0\24\1\0\131\238\0\132\113\0\28\47\0\35\93\0\49\252zzz\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0zzz\0\11\9\0\11\184\0\11\184\0\11\184\0\11\184\0\11\184\0\11\184\0\11\184\0\13\172\0\13\172\0\13\172\0\13\172\0\13\172zzz\0\15\160\0\15\160\0\15\160\0\15\160\0\15\160\0\15\160\0\19\136\0\19\136\0\19\136\0\19\136\0\19\136\0\19\136\0\19\136zzz\0\19\136\0\19\136\0\19\136\0\19\136\0\21\124\0\21\124\0\21\124\0\21\124\0\21\124\0\21\124\0\24\106\0\24\106\0\24\106\0\24\106\0\29\76zzzzzz\0\29\76\0\29\76\0\29\76\0\29\76\0\29\76\0\39\16\0\39\16\0\39\16\0\39\16\0\58\152\0\4\226\0\58\152\0\0\0\0\58\152\0\168\134\0\169\28\0\45\21zzz\0\75\181\0\91\47zzz\0\38\239zzz\0\29\97\0\55\74\0\0\50\0\0\39\0\52\119\0\47\31\0\55\126\0\0\50\0\27\196\0\140\242\0\141\125\0\45\128zzz\0\38\53\0\57\70\0\193\106\0\0\58\0\2\216\0\11\122\0\7\237\0\21\50\0\39\92\0\39\129\0\163\183\0\49\75\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\44\182\0\35\231\0\60\25\0\75\102zzz\0\91\42\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0zzzzzzzzzzzz\0\29\76zzzzzzzzzzzzzzzzzz\0\200\218\0\251\246\0\30\208\0\34\84\0\59\231\0\29\92\0\44\53\0\54\173\0\58\121\0\112\117\0\112\224\0\7\251\0\25\162\0\2\50\0\29\40zzz\0\0\50\0\1\44\0\2\113\0\2\113\0\31\208zzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzz\0\107\189\0\0\0\0\0\0\0\100\231\0\7\222\0\13\254\0\4\58\0\7\10\0\0\53\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\78\32\0\6\87\0\16\245\0\1\170\0\1\171\0\6\111zzz\0\17\69\0\0\0zzz\0\4\124zzzzzzzzzzzzzzz\0\18\240zzzzzzzzzzzzzzzzzz\0\1\183\0\3\34\0\7\72\0\9\83\0\17\44\0\35\186\0\41\150\0\2\15\0\2\108\0\10\36\0\12\251\0\34\246\0\30\242\0\37\78\0\40\215\0\42\205\0\48\57\0\49\213\0\104\176\0\2\0\0\3\69\0\3\34\0\7\95\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\10\156\0\19\23\0\24\220\0\31\60\0\35\177\0\40\64\0\3\34\0\1\169\0\2\75\0\4\40\0\4\147\0\9\9\0\5\181\0\9\117\0\16\50\0\18\6\0\21\9\0\28\47\0\29\45\0\28\47\0\31\206\0\32\195\0\37\142\0\38\159\0\42\61\0\42\244\0\48\183\0\48\210\0\26\194\0\102\197\0\0\250\0\5\220\0\9\196\0\77\27\0\9\196\0\0\10zzz\0\35\43\0\14\166zzzzzzzzz\0\113\224\0\4\226\0\39\16\0\153\63\0\45\219\0\23\42\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\156\64\0\39\16\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\209\94\0\15\160\0\11\184\0\11\184\0\11\184\0\15\160\0\15\160\0\15\160\0\15\160\0\15\160\0\19\136\0\19\136\0\19\136\0\19\136\0\19\136\0\23\112\0\23\112\0\23\112\0\0\0\0\39\172\0\0\100\0\0\100\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\9\196\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\9\196\0\9\196\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\11\184\0\11\184\0\2\38\0\4\226zzzzzz\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\1\0\0\6\0\0\100\0\0\62\0\0\25\0\0\200\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0zzzzzz\0\0\0zzz\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0zzzzzzzzzzzz\0\3\232\0\4\226zzzzzzzzz\0\0\0\0\0\0\0\0\0\0\11\184\0\11\184\0\11\184\0\11\184\0\13\172\0\13\172\0\15\160\0\15\160\0\19\136\0\19\136\0\19\136\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\21\124\0\21\124\0\23\112\0\23\112\0\23\112\0\23\112\0\23\112\0\29\76\0\29\76\0\29\76\0\29\76\0\29\76\0\29\76\0\29\76\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0zzzzzz\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0zzzzzz\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\25zzzzzzzzzzzzzzz\0\0\0zzzzzzzzzzzzzzzzzz\0\0\0\0\1\119\0\4\226\0\9\196\0\13\172\0\23\112\0\0\25\0\0\225\0\3\232\0\9\196\0\14\166\0\0\225\0\2\238\0\7\208\0\11\184\0\19\136\0\0\150zzzzzz\0\0\0zzz\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0zzzzzz\0\0\0\0\0\0zzz\0\1\244\0\5\220\0\10\190\0\14\166\0\25\100\0\1\44\0\2\238\0\6\214\0\10\190\0\13\172\0\21\124\0\1\119\0\3\232\0\7\208\0\10\190\0\14\166\0\23\112\0\2\238\0\8\202\0\13\172\0\25\100\0\0\0\0\4\226\0\29\151\0\0\0\0\8\202\0\11\184\0\17\148\0\25\100\0\2\113\0\7\208\0\12\178\0\23\112\0\3\232\0\6\214\0\9\196\0\12\178\0\19\136\0\6\214\0\10\190\0\13\172\0\21\124\0\8\202\0\17\148\0\10\190\0\19\223\0\37\102\0\37\137\0\0\0\0\0\0\0\25\250\0\26\17\0\0\0\0\0\0\0\0\0\0\47\205\0\0\0\0\28\233\0\0\0\0\50\227\0\34\81\0\0\0zzz\0\51\171\0\34\215\0\0\0\0\0\0\0\41\28\0\41\66\0\31\14\0\31\42\0\52\33\0\39\61\0\52\129\0\39\132\0\52\224\0\53\15\0\36\35\0\36\70\0\58\67\0\58\124\0\45\112\0\45\103\0\53\17\0\71\39\0\71\105\0\53\166\0\71\239\0\54\11\0\72\115\0\54\110zzz\0\0\0\0\0\0zzzzzzzzzzzzzzz\0\0\0zzz\0\0\0zzzzzzzzzzzzzzzzzzzzzzzzzzzzzz\0\0\0zzz\0\0\0\0\0\0zzzzzz\0\0\0zzzzzzzzzzzz\0\0\0\0\0\0zzzzzzzzzzzzzzzzzzzzzzzzzzzzzz\0\0\0\0\0\0zzzzzz\0\29\236zzz\0\20\25\0\0\0\0\30\94\0\40\164\0\41\220\0\31\130\0\0\0\0\39\170\0\0\0\0\24\24zzz\0\36\109\0\24\96\0\0\0\0\36\215\0\49\79\0\37\30\0\49\174\0\49\222\0\37\137\0\38\175\0\51\196\0\54\114zzz\0\0\0\0\0\0\0\73\198\0\55\107\0\74\75\0\50\128\0\0\0\0\43\229\0\29\63\0\0\0\0\44\52\0\59\41\0\60\255\0\46\30\0\61\112\0\46\63\0\61\227\0\46\202\0\0\0\0\31\71\0\47\75zzzzzzzzzzzzzzz\0\0\0\0\0\0zzzzzzzzzzzzzzzzzzzzz\0\0\0\0\0\0zzzzzzzzzzzzzzz\0\0\0zzzzzz\0\0\0\0\0\0zzz\0\0\0zzzzzzzzzzzzzzzzzzzzzzzzzzzzzz\0\0\0zzz\0\0\0zzzzzz\0\0\0\0\0\0zzzzzzzzzzzzzzz\0\0\0\0\9\196\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0zzzzzz\0\0\17\0\0\17\0\0\17\0\0\17\0\0\213\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\106\171\0\30\103\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0zzzzzzzzz\0\0\62\0\0\62\0\0\62\0\0\62\0\0\62\0\0\62\0\0\62\0\0\62\0\0\62\0\0\62\0\0\62\0\0\62\0\0\0\0\6\113\0\3\88\0\8\152\0\4\11zzzzzz\0\0\0zzz\0\126\112\0\93\227\0\115\53\0\85\235\0\82\35\0\49\42\0\54\235\0\52\128\0\121\17\0\83\173\0\55\188\0\90\146\0\119\143\0\89\38\0\53\220\0\50\255\0\56\246\0\34\61\0\35\133\0\33\246\0\57\244\0\76\129\0\78\234\0\57\5\0\79\131\0\54\181\0\36\156\0\59\126\0\78\138\0\58\77\0\35\98\0\33\129\0\60\151\0\79\251\0\84\161\0\61\34\0\33\145\0\31\202\0\53\71\0\35\167\0\97\226\0\72\180\0\70\255\0\96\90\0\40\206\0\68\97\0\45\194\0\43\189\0\41\106\0\69\102\0\45\101\0\47\212\0\75\154\0\102\148\0\78\69\0\106\37\0\55\186\0\59\76\0\62\129\0\93\102\0\137\6\0\101\149\0\134\94\0\99\144\0\139\27\0\103\31\0\140\9\0\103\194\0\99\45\0\60\19\0\63\231\0\67\87\0\16\139\0\31\33\0\4\8\0\5\15zzzzzzzzzzzzzzz\0\0\27\0\0\15\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0zzzzzzzzzzzz\0\0\100\0\2\238\0\146\124\0\103\248\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0zzzzzzzzzzzzzzzzzz\0\19\231\0\23\104zzz\0\7\120\0\0\0\0\17\1\0\11\83\0\86\112\0\107\99\0\80\218\0\108\56\0\54\81\0\81\199\0\54\186\0\54\239\0\82\182\0\55\88\0\55\141\0\55\194\0\83\243\0\84\65\0\112\193\0\113\44\0\85\46\0\56\255\0\88\9\0\117\204\0\106\246\0\80\136\0\53\229\0\61\20\0\54\78\0\136\72\0\102\154\0\137\82\0\103\95\0\103\194\0\69\111\0\69\175\0\69\242\0\70\52\0\108\125\0\72\148\0\72\214\0\123\201\0\146\183\0\110\106\0\133\175\0\100\167\0\121\202\0\81\35\0\81\115\0\81\195\0\164\37\0\123\144\0\165\96\0\125\13\0\171\18\0\128\197\0\172\81\0\130\72\0\130\189\0\87\22\0\87\101\0\87\181\0\205\93\0\154\70\0\187\36\0\140\162\0\94\211\0\95\49\0\142\64\0\95\234\0\98\230\0\147\197\0\99\161\0\99\252\0\199\144\0\149\238\0\201\5\0\151\1zzzzzzzzzzzz\0\9\165\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0zzzzzzzzzzzz\0\21\116\0\7\196zzz\0\12\21\0\9\179\0\6\161zzzzzz\0\7\201zzzzzz\0\156\60\0\117\154\0\78\178\0\118\123\0\158\144\0\119\90\0\79\220\0\80\39\0\160\229\0\121\25\0\81\6\0\121\250\0\151\139\0\76\16\0\76\91\0\91\251\0\61\140\0\92\173\0\124\9\0\124\129\0\93\184\0\62\183\0\94\109\0\63\47\0\95\30\0\127\75\0\127\195\0\96\42\0\66\6\0\66\66\0\99\189\0\60\96\0\90\234\0\121\176\0\122\41\0\91\246\0\61\139\0\61\199\0\93\4\0\93\92\0\141\49\0\188\32\0\141\156\0\94\194\0\147\24\0\195\247\0\98\83\0\98\173\0\149\52\0\198\194\0\149\149\0\90\142\0\136\247\0\182\132\0\107\122\0\107\228\0\161\57\0\216\45\0\162\112\0\109\136\0\168\17\0\225\81\0\113\183\0\114\33\0\170\131\0\228\148\0\171\185\0\115\197\0\172\244\0\231\215zzzzzzzzzzzz\0\1\44zzzzzzzzz\0\3\45zzz\0\6\0\0\4\209\0\54\70\0\80\152\0\1\36\0\95\77\0\100\109\0\123\45\0\3\79\0\3\82\0\3\116\0\114\149\0\72\178\0\3\230zzz\0\120\154\0\121\13\0\40\128\0\60\249\0\150\248\0\151\134\0\129\198\0\41\213\0\0\0\0\40\74\0\169\23\0\169\175\0\212\221\0\6\96\0\7\174\0\45\177zzzzzz\0\7\208\0\7\208\0\3\232\0\180\192\0\86\226\0\208\182\0\209\123\0\175\200\0\78\32\0\0\175\0\0\250\0\0\175\0\146\124\0\156\64\0\0\175\0\156\64\0\0\250\0\0\100\0\0\175\0\0\250\0\1\244\0\0\250\0\1\244\0\1\244\0\0\50\0\0\100\0\0\200\0\1\94\0\1\244\0\32\125\0\0\0\0\0\0\0\22\74\0\11\239\0\58\190\0\57\254\0\18\188\0\5\33\0\1\144\0\87\228\0\48\248\0\68\92\0\175\200\0\195\80\0\112\116\0\112\220\0\0\7\0\0\7\0\0\7\0\214\216\0\214\216\0\50\88\0\2\38\0\93\153\0\179\90\0\130\101\0\176\172\1\38\188\1\50\117\0\214\184\1\42\195\1\40\38\0\225\176\1\102\255\1\90\92\1\63\22\1\158\83\0\210\11\0\94\126\0\0\0\0\0\0\0\0\0\0\180\66\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\91\67\1\38\167\1\136\23\1\33\165\0\199\236\0\91\227\0\0\0\0\131\89\0\96\72\0\135\88\1\30\26\1\107\133zzz\0\0\0\0\0\0zzzzzz\0\0\6\0\0\0\0\0\0\0\0\0\0\0\0zzzzzzzzz\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\2\114\146\0\0\7\0\0\7\0\0\52\0\0\52\0\0\232\0\1\233\0\10\50\0\29\105zzz\0\3\196\1\116\195zzzzzz\0\0\12\0\0\10\0\0\9\0\0\0\0\0\6\0\0\60zzz\1\134\160\3\13\64\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\1\44\1\85\76zzz\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0zzz\0\0\2\0\0\2zzzzzz\0\0\2zzzzzzzzz\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0zzz\0\0\0\0\0\0\0\0\0zzzzzzzzzzzzzzzzzzzzzzzz\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\1zzzzzz\0\0\0\0\0\250\0\0\125\0\0\0\0\0\250\0\0\125\0\0\0\0\0\0zzz\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0zzz\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0zzz\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\1\244\0\0\37\0\0\6\0\0\50\0\0\6\0\0\50\0\0\100\0\0\0zzzzzz\0\0\0\0\30\70\0\57\158\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\2zzz\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0zzzzzzzzz\0\0\0\0\0\0\0\0\0\0\30\200\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\2\0\44\189\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\2\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\30\183\0\0\0\0\20\160\0\0\0\0\31\41\0\41\179\0\38\221\0\29\67\0\29\95\0\39\80\0\39\118\0\29\181\0\0\0\0\0\0\0\30\10\0\20\26zzzzzzzzzzzz\0\0\0zzzzzz\0\0\0zzz\0\0\0zzz\0\0\0zzzzzzzzzzzz\0\29\209\0\0\0\0\20\6\0\0\0\0\30\66\0\40\127\0\41\184\0\31\103zzzzzzzzzzzz\0\0\0zzzzzz\0\0\0\0\29\93\0\39\77\0\39\116\0\29\179\0\0\0\0\0\0\0\30\215\0\20\162zzz\0\0\0zzz\0\0\0zzzzzzzzzzzzzzz\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0zzzzzz\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0zzz\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\34\46\0\57\158zzzzzz\0\39\208\0\39\247\0\22\63zzzzzzzzz\0\3\113zzz\0\3\113\0\3\162zzz\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0zzzzzz\0\35\218\0\128\86\0\3\182\0\45\111\0\0\35\0\1\244\0\138\155\0\97\96zzz\0\57\49\0\43\78\0\43\117\0\29\76\0\103\58\0\88\102\0\125\106\0\2\88\0\8\220\0\2\188\0\2\238\0\1\119\0\2\238zzzzzz\0\48\170\0\0\0\0\167\200\0\0\0\0\40\143\0\135\175\0\71\89zzz\0\41\36\0\39\179\0\130\71\0\35\125\0\44\137\0\44\252\0\56\114\0\159\44\0\35\71\0\87\248\0\41\112\0\1\244\0\35\147\0\44\161\0\23\227\0\59\240\0\112\113\0\101\190\0\67\242\0\22\186zzzzzzzzz\0\40\67zzzzzzzzzzzzzzzzzz\0\175\63\0\53\42\0\30\211\0\0\0\0\26\122\1\134\160\0\27\220\0\27\220\0\23\245\0\30\161\0\28\209\0\43\3\0\17\253\0\37\217\0\182\204zzz\0\131\89\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0zzzzzz\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0zzzzzzzzzzzzzzzzzzzzzzzzzzzzzz\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\125\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\137\162\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\18\154\0\0\213\0\21\136\0\0\213\0\34\46\0\0\0\0\19\136\0\18\165\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\93\153\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\41\213\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\10\0\60\135\0\162\6\0\1\44\0\11\184\0\88\248\0\192\52\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\110\1\0\17\170\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\60\84\0\59\148\0\60\197\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0zzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzz\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\50\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\184\188\0\97\168\0\97\168\0\97\168\0\97\168\0\97\168\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\1\134\160\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\1\30\40\1\31\50\0\86\120\0\130\7zzzzzz\0\88\213\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\11\254\0\23\254\0\6\192\0\0\140\0\1\152\0\0\248\0\9\196\0\3\22\0\1\253\0\1\105\0\39\16\0\0\130\0\0\225\0\0\0\0\10\156\0\6\86\0\12\249\0\3\107zzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzz\0\19\136\0\195\80\0\0\15\0\0\18\0\0\15\0\3\232\0\195\80zzz\0\29\76\0\29\76zzz\0\4\226\0\57\98\0\97\168\0\117\48zzz\0\19\136zzz\0\1\119\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\217\65\0\97\168\0\1\119\0\17\206\0\11\137\0\0\50\0\0\250\0\37\229\0\117\48\0\117\48\0\117\48\0\0\0\0\0\250\0\45\62\0\48\34zzz\0\80\205zzz\0\0\200\0\114\179\0\29\106\0\0\0\0\0\0\0\98\69\0\28\47\0\43\155\0\54\182\0\46\32\0\185\46\0\221\68\0\130\149\0\93\112\0\47\68\0\47\68\0\0\0\0\48\215\0\86\41\0\81\253\0\0\0\0\192\168\0\69\13\0\128\220\0\215\149\0\64\233\0\64\56\0\36\160\0\55\36zzzzzzzzzzzzzzzzzzzzzzzz\0\31\167\0\142\243\0\44\106\0\112\181\0\0\0\0\0\0\0\57\23\0\45\67\0\57\135\0\63\217\0\162\117\1\40\214\0\49\24\0\49\71\0\58\7\0\105\229\0\207\150\0\68\58\0\0\0zzzzzzzzzzzzzzzzzzzzzzzzzzzzzz\0\67\105\0\57\170\0\48\60\0\38\187\0\84\108\0\81\1\0\206\145\0\103\167\0\78\2\0\52\48\0\209\128\0\47\143\0\114\148\0\86\166\0\134\182\0\84\131\0\58\43\0\67\149\0\102\97\0\78\112\0\77\170\0\38\112\0\152\181\0\61\76\0\101\35\0\51\115\0\206\139\0\61\85\0\62\102\0\143\37\0\209\123\0\87\192\0\105\223\0\105\223\0\58\5zzz\0\72\230\0\191\164\0\26\58\0\53\179\0\179\206\0\40\146\0\40\182\0\40\220\0\177\204\0\53\136zzz\0\62\44\0\117\48\0\39\16\0\39\16\0\39\16\0\39\16\0\0\0\0\250\117\0\90\128zzzzzz\0\76\64\0\21\161zzzzzzzzzzzzzzz\0\0\0zzz\0\0\0zzzzzzzzzzzz\0\0\0\0\0\0zzzzzzzzzzzzzzzzzz\0\0\0zzzzzzzzz\0\66\120\0\41\177zzzzzzzzzzzzzzzzzz\0\47\180\0\56\47\0\120\42zzz\0\161\103\0\162\0\0\113\207zzzzzzzzzzzzzzzzzzzzzzzzzzz\0\0\0\0\3\36\0\5\234\0\7\235\0\7\243\0\7\46\0\8\100\0\20\25\0\12\26\0\147\207\0\203\7\0\130\103\0\81\203\0\39\16zzzzzz\0\70\95\0\158\247zzz\0\98\25\0\84\239\0\5\229\0\56\206\0\38\3\0\190\196\0\12\153\0\12\62zzz\0\255\105\0\143\140\0\51\115\0\51\162\0\77\185\0\62\102\0\62\159\0\83\203\0\76\21\0\76\97\0\15\160zzz\0\58\152\0\58\152\0\58\152\0\156\64\0\156\64\0\156\64\0\25\179\0\10\207\0\14\41\0\13\153\0\12\131\0\5\59\0\6\77\0\6\83\0\7\184\0\7\69\0\11\105\0\23\221\0\7\224\0\7\13\0\25\35\0\118\23\0\151\8\0\25\213\0\34\3zzzzzz\0\90\70\1\112\65\0\248\240\0\76\249\0\120\155\0\136\43\0\109\137\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\1\134\160zzzzzz\0\0\0\0\0\0\0\146\124\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\58\5\0\58\5\0\7\208\0\0\200\0\0\0zzzzzz\0\78\32\0\0\0\0\11\184\0\0\0\0\0\0zzzzzz\0\0\0\0\46\224zzz\0\97\168zzzzzzzzzzzzzzzzzzzzz\0\0\37\0\0\27\0\0\35\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0zzzzzzzzzzzzzzz\0\0\0zzzzzz\0\0\0\0\11\184\0\0\50\0\0\6\0\48\212\0\0\100\0\0\100\0\2\88\0\48\212\0\48\212zzz\0\1\244zzzzzz\0\0\0\0\5\220zzz\0\1\194\0\1\194\0\1\194\0\4\226\0\11\184\0\11\184\0\15\160\0\15\160\0\15\160\0\15\160\0\19\136\0\23\112zzz\0\29\76\0\11\184\0\0\5zzz\0\0\25zzz\0\0\0\0\0\0\0\0\0\0\0\0zzz\0\186\131\0\69\191\0\120\62\0\85\243\0\0\25\0\60\169\0\47\27\0\104\11\0\98\48\0\142\242\0\57\101\0\96\7\0\192\195\0\141\45\0\0\0\0\89\85zzzzzz\0\59\243\0\140\99\0\122\168\0\98\21\0\41\156\0\94\94\0\134\146\0\121\197\0\42\115\0\56\118\0\60\20\0\42\158\0\142\58\0\66\168zzzzzzzzz\0\39\47zzzzzz\0\22\126\0\28\56\0\33\252\0\40\5zzzzzzzzz\0\70\95\0\241\244\0\101\209zzz\0\58\188\0\57\97\0\68\131\0\163\225zzz\0\234\23\0\46\253\0\56\151\0\126\210\0\149\158\0\40\10\0\1\244\0\0\0\0\0\0\0\62\159\0\62\214\0\95\26\0\190\242\0\141\207\0\132\218\0\38\26\0\69\40\0\87\231\0\55\195\0\44\107\0\67\76zzz\0\0\0\0\0\0zzz\0\0\0\0\0\0zzzzzz\0\73\118\0\157\21\0\121\184\0\58\221\0\196\240\0\247\25\0\120\146\0\149\94\0\107\239\0\0\0\0\0\0\0\0\0zzzzzz\0\0\0zzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzz\0\0\0\0\0\0\0\19\136\1\114\156zzz\1\42\172\0\161\45\0\100\196\0\61\243\0\56\242\0\107\48\0\86\19\0\86\103\1\92\15\1\92\47\0\250\95\1\57\170\0\140\21zzzzzz\1\2\242\0\250\30\1\113\178\0\75\35\0\160\4zzzzzzzzzzzz\0\128\175zzzzzz\1\28\128zzzzzzzzzzzzzzzzzz\0\0\250zzz\0\0\250\1\122\244zzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzz\0\188\24zzzzzzzzzzzzzzzzzzzzzzzz\0\117\187zzz\0\106\220zzzzzz\0\136\223zzzzzz\1\24\114\0\208\116zzz\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0zzz\0\0\0zzz\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0zzz\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\123\0\0\100zzzzzz\0\6\53\0\1\244\0\0\0\0\0\0zzzzzzzzzzzzzzz\0\0\250zzzzzzzzzzzzzzz\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0zzz\0\0\0\0\0\0zzz\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\19\136\0\0\0\0\19\136zzz\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0zzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzz\0\0\0\0\0\0zzzzzz\0\0\0\1\225\4zzz\0\0\0\0\111\164zzz\0\39\47zzz\0\0\250\0\4\226\0\4\54zzzzzzzzzzzzzzzzzz\0\0\250zzz\0\40\26\0\43\137\0\28\235\0\77\105\0\38\218\0\39\0\0\51\235\0\43\108zzzzzz\0\36\16\0\95\56\0\52\219\0\63\167\0\64\99\0\68\213\0\0\0\0\0\0\0\0\0\0\50\141\0\69\80\0\74\33\0\59\134\0\0\100\0\0\75\0\0\50\0\0\0zzz\0\0\0\0\0\100\0\0\75\0\0\50zzzzzzzzz\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0zzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzz\1\1\229\0\155\76\0\155\216\0\132\128zzz\0\88\52\0\68\242\0\49\39\0\71\106\0\42\251\0\17\238\0\62\255\0\67\192\0\22\171\0\63\155\0\35\47\0\0\0\0\16\18\0\56\117\0\25\252\0\30\153\0\47\226\0\52\46\0\0\0\0\212\159\0\84\82\0\83\152\0\116\26\0\70\49\0\54\242\0\58\181\0\112\131\1\55\237\0\111\80\0\235\96\0\64\228\0\73\215\0\106\47\0\135\36\0\117\0\0\72\110\1\101\61\0\140\41\0\67\33zzzzzzzzzzzzzzzzzz\0\110\76\0\87\78\0\0\0\0\82\149zzz\0\0\0\0\76\18\0\76\88\0\107\224\0\123\3\1\37\125\1\112\40\1\25\57\1\96\229\1\27\104\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\25zzz\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\21\124\0\21\124\0\39\16\0\39\16\0\58\152\0\78\32\0\68\92\0\68\92\0\117\48\0\117\48\0\117\48zzz\0\0\0\0\21\124\0\21\124\0\39\16\0\39\16\0\58\152\0\87\228\0\0\12\0\0\2\0\0\1\0\0\50\0\0\200\0\0\0\0\48\212\1\134\160zzz\0\48\212\0\48\212\0\48\212\0\48\212\0\48\212\0\48\212\0\48\212zzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzz\1\134\160\0\48\212\0\48\212\0\48\212\0\48\212\0\48\212\0\48\212\0\48\212\0\48\212zzz\1\134\160\0\48\212\0\48\212\0\48\212\0\48\212\0\48\212\0\48\212\0\48\212\0\48\212\0\48\212\1\134\160\0\48\212\0\48\212\0\48\212\0\48\212\0\48\212\0\48\212\0\48\212\0\0\0\0\0\0\1\134\160\1\134\160\1\134\160\1\134\160\0\97\168\0\15\182\0\75\176\0\0\0\0\2\238\0\0\250\0\0\110\0\0\50\0\0\25\0\0\100\0\1\94\0\48\212\0\48\212\0\0\6\0\0\25\0\0\100\0\0\100zzzzzzzzzzzzzzz\0\0\0\0\0\0zzz\0\0\7\0\0\7\0\0\250zzzzzzzzz\0\0\0zzzzzzzzz\0\21\124\0\39\16\0\21\124\0\39\16\0\58\152\0\87\228\0\87\228\0\87\228\1\136\199\1\59\91\1\25\103\1\25\103zzz\1\25\103\1\25\103\1\25\103\1\25\103\1\25\103\1\25\103\1\25\103\1\52\205\1\64\209\0\199\25\0\206\210\0\237\195\1\62\45\1\79\54\1\154\246\1\99\243\1\118\166\1\146\43\1\121\130\1\101\17\0\0\0\1\70\169\0\235\70\1\33\254\1\74\89\1\158\113\1\55\56\3\25\51\0\235\39\0\242\58\0\63\84\0\95\85\1\89\35\0\169\171\0\148\150\0\59\180\0\98\55\1\179\168\1\155\112\0\99\88\3\36\39\0\100\24\0\125\152\1\245\24\1\247\94\1\254\56\0\130\192\0\98\107\0\172\130\0\66\20\0\124\88\0\83\49\0\100\45\0\117\246\0\100\228\0\156\101\1\146\191\0\75\50\1\163\174\0\90\235\0\121\177\0\62\189\0\188\233\0\221\48\1\155\112\0\0\0\0\159\187\1\100\24\0\64\89\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0zzzzzzzzzzzz\0\97\168\0\0\0\0\0\0\0\0\0\0\97\140\1\146\205\2\63\86\0\183\84\1\59\223\0\217\143\0\87\87\0\87\171\0\89\20\0\149\4\0\1\244\0\5\220\0\97\168zzz\0\29\76\0\29\76\0\29\76\0\58\152\0\78\32\0\97\168zzzzzzzzzzzzzzz\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0zzz\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0zzzzzz\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\97\168\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0zzzzzz\0\6\165\0\5\143\0\10\23zzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzz\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\81\250\0\82\73\0\61\240\0\103\158\0\52\0\0\52\49\0\104\195\0\78\220\0\129\241\0\98\60\0\65\109\0\138\162\0\139\44\0\104\149zzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzz\0\1\244\0\58\152\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\48\212\0\48\212\0\48\212\0\7\208\0\7\208\0\48\212\0\48\212\0\48\212\0\48\212\0\48\212\0\19\136zzz\0\48\212\0\48\212\0\48\212\0\48\212\0\48\212\0\48\212zzzzzzzzzzzzzzzzzzzzzzzzzzz\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0zzzzzz\0\0\0zzzzzzzzz\0\60\196\0\0\0\0\0\0\0\0\0zzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzz\0\0\0zzzzzzzzzzzzzzzzzz\0\0\0zzzzzz\0\0\0zzzzzzzzzzzz\1\32\83\0\217\11\1\107\9\0\204\11\0\189\244\0\88\22zzz\1\39\186\0\0\0\0\223\95\0\191\75\0\239\102\1\45\7\1\46\16\1\18\216\1\19\226\0\0\0\0\55\120\0\66\208\0\196\111zzz\0\190\20\1\97\223\0\102\20\1\77\63\0\114\61\0\120\40\0\0\0zzzzzzzzzzzz\1\84\236\0\172\171\0\65\209\0\132\35\0\66\79\0\110\238\1\22\241\0\248\140\0\84\31\0\216\59\0\79\140\0\90\184\1\25\113\0\84\189\0\214\251\0\82\85\1\2\74\0\207\110zzz\1\12\43\0\161\132\0\176\197\0\79\70\0\63\167\0\204\243\1\86\221\1\19\74\0\0\0\0\170\28\0\113\175\0\34\46\0\143\134\0\0\0\0\0\0\1\107\123\0\93\6\0\218\229\0\199\150\0\248\167\0\171\254\0\0\0\0\170\115\0\0\0\0\204\41\0\79\220\0\44\92\1\32\124zzz\0\0\0\0\8\32\0\5\120\0\3\62\0\3\62\0\3\12\0\2\68zzzzzzzzzzzz\0\7\208\1\80\99\0\101\77\1\8\45\1\82\0\1\178\199\1\178\199\1\178\199zzzzzzzzzzzzzzzzzzzzzzzzzzz\0\0\0\0\207\88\1\4\45\1\12\78\0\215\114\0\216\62\0\0\0\0\163\93\0\218\158\0\13\32\0\8\127\0\7\208\0\13\68zzz\0\9\196zzz\0\0\0\0\0\0zzz\0\97\168\0\0\0\0\0\0\0\36\228\0\0\0\0\46\117\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\97\168\0\39\16\0\39\16\0\166\234zzzzzzzzzzzz\0\76\1\0\61\9\0\117\48\0\48\212\0\3\232\0\0\0\0\3\232\0\0\0\0\32\183\0\3\232\0\2\88zzzzzz\0\48\212\0\48\212\0\48\212\0\48\212\0\6\122\0\14\51zzz\0\0\0zzz\0\0\0\0\0\0zzzzzz\0\0\0zzz\0\0\0zzzzzzzzz\0\6\44zzz\0\105\160zzzzzz\0\119\187\0\10\190\0\58\155\0\205\69\0\151\98\0\78\32zzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzz\0\0\100\0\0\50\0\0\75\0\0\75\0\0\100\0\0\50zzzzzzzzzzzzzzzzzz\0\1\44\0\1\244zzzzzzzzzzzzzzzzzz\0\94\165\0\158\76\0\0\0zzz\0\0\1zzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzz\0\39\16zzzzzz\0\0\0\0\118\38\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0zzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzz\0\78\151zzz\0\67\119\0\56\109\0\45\78\0\56\254\0\57\49zzz\0\0\0\0\0\100\0\0\50\0\0\75\0\0\100\0\0\50\0\0\75zzzzzzzzzzzz\0\0\75zzz\0\0\100\0\0\50zzz\0\0\75\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\100\0\0\50\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\15\160\0\19\136\0\48\137zzz\0\90\167\0\247\143\0\49\180\0\124\110\0\50\21\0\94\118\0\105\200\0\98\211\0\110\193\0\148\131\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\121\107\0\49\46\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0zzz\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\38\247\0\0\0zzz\0\0\0zzzzzzzzzzzzzzzzzzzzz\0\170\94\0\19\136\0\58\152zzzzzzzzz\0\0\0zzzzzzzzzzzz\0\0\1\0\0\1zzzzzzzzzzzzzzzzzzzzz\0\78\32zzzzzzzzzzzzzzz\0\7\137\0\10\21\0\7\150zzzzzzzzz\0\0\0zzzzzzzzzzzz\0\0\0zzzzzzzzz\0\0\0zzz\0\0\0\0\0\175zzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzz\0\0\0\0\0\0zzzzzzzzzzzzzzz\0\0\250zzzzzzzzzzzzzzzzzzzzz\0\0\0zzz\0\0\0zzzzzzzzzzzzzzz\0\0\0\0\0\12zzzzzzzzz\0\0\0zzz\0\24\106\0\59\188\0\61\139\0\123\136\0\123\246\0\62\52\0\62\108zzzzzz\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0zzzzzzzzzzzzzzzzzzzzzzzz\0\3\232\0\1\244\0\7\208\0\7\208\0\0\0\0\39\16\0\147\241\0\60\97\0\39\16\0\39\16\0\39\16\0\39\16\0\39\16\0\39\16\0\39\16zzzzzzzzzzzz\0\66\217\0\1\244zzz\0\7\208\0\67\206\0\0\0\0\0\0\0\0\0\0\0\0\0\1\244\0\1\244\0\1\244\0\0\0\0\49\191\0\2\238\0\2\238\0\2\238\0\15\135\0\2\238\0\158\223\0\62\91\0\83\113\0\41\221\0\4\226\0\1\244\0\4\226\0\4\226\0\4\226\0\1\244\0\39\16\0\39\16\0\39\16\0\71\16\0\141\212\0\106\143\0\1\244\0\58\152\0\58\152\0\58\152\0\158\219\0\0\175zzzzzzzzz\0\0\1\0\0\1\0\0\1\0\0\1\0\0\1\0\0\1\0\0\1\0\0\1\0\0\1\0\0\1\0\0\1\0\0\1\0\0\1\0\0\1\0\2\231\0\1\94\1\28\202\1\29\229\0\86\25\1\32\20\1\105\123\0\245\82\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\215\53\1\129\100\0\0\12\0\0\12\0\0\12zzzzzzzzzzzzzzz\0\0\0zzzzzzzzzzzzzzz\0\78\28\0\110\94\0\172\232\0\57\218\0\152\42zzz\0\130\175\1\189\183\0\113\145\2\47\199\0\60\73\0\60\128\0\151\207\0\115\168\0\139\229\0\109\87\0\92\103\1\139\161\0\117\187\0\118\39\0\124\246\1\92\15\0\150\249\0\178\90\0\208\221\0\32\213\0\18\221\0\29\115\0\27\182zzz\0\85\25\0\140\116\0\187\245\0\206\91\0\87\153\0\58\132zzz\0\50\58\0\59\37\0\235\15\0\31\118\0\71\93\0\190\47\0\59\168\0\47\231\0\240\103\0\40\55\0\84\155\0\145\216\0\34\205\0\100\175\0\202\28\0\43\250\0\122\36\0\255\99\0\49\135\0\133\191\0\143\218\0\58\200\0\77\80\0\194\0\0\1\244\0\1\244\0\1\244\0\1\244\0\96\163\0\53\166\1\31\81\0\113\71\0\65\24\0\240\177\0\67\72\0\79\58\0\185\123\0\85\1\0\41\42\0\79\137\0\52\50\0\46\209\0\69\164\0\141\157\0\246\182\0\59\109\1\9\33\0\139\183\0\140\61\0\120\165\0\124\80\0\103\248\0\104\87\0\83\196\0\84\16\0\84\93\0\0\2\0\0\50\0\101\17\0\101\117\0\58\78\0\58\135\0\73\113\0\73\185\0\39\119\0\39\157\0\0\0\0\0\0\0\211\48\0\151\134\0\159\139\0\170\240\0\214\108zzz\0\97\168\0\97\168\0\97\168\0\97\168\0\97\168\0\97\168\0\97\168\0\97\168\0\97\168\0\97\168\0\97\168\0\0\0\0\0\0\0\0\0\0\0\0zzzzzzzzz\0\1\244\0\3\232\0\3\232\0\3\232\0\3\232\0\3\232\0\3\232\0\0\0\0\2\238\0\3\232\0\9\196\0\19\136\0\39\16\0\39\16\0\0\125zzzzzz\0\117\48\0\0\0\0\1\56zzzzzzzzzzzzzzz\0\9\196\0\1\194zzzzzz\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0zzz\0\0\0zzzzzzzzzzzzzzzzzz\0\0\12zzzzzz\0\0\12\0\0\12zzz\0\0\0\0\0\5\0\0\4\0\0\0\0\0\200\0\0\20\0\0\100\0\2\113\0\0\0\0\4\40\0\4\40\0\0\0\0\3\69\0\24\106\0\0\0\0\8\159\0\3\107\0\2\165\0\0\0\0\5\255\0\5\255\0\7\8\0\6\4\0\0\0\0\0\25\0\0\25\0\0\26\0\0\19\0\0\32\0\0\26\0\0\16\0\0\5\0\0\6\0\0\150\0\0\4\0\0\5\0\0\6\0\0\5\0\0\16\0\0\16\0\0\17\0\0\17\0\0\21\0\1\194\0\1\119\0\1\119\0\0\1zzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzz\0\0\0zzzzzz\0\0\0zzzzzzzzz\0\0\0zzzzzzzzz\0\0\1\0\0\1\0\0\1\0\0\1\0\0\1\0\0\1\0\0\1\0\0\1\0\0\1\0\0\1\0\0\1\0\0\0\0\0\0\0\0\0\0\0\0\0\0\250\0\1\44\0\0\0\0\3\242\0\0\12\0\0\7\0\0\16\0\0\0\0\0\7\0\0\12\0\0\7\0\0\7\0\0\14\0\0\14\0\0\6\0\0\9\0\0\6\0\0\6\0\0\12\0\0\12zzzzzzzzzzzzzzzzzzzzzzzzzzzzzz\0\0\0\0\0\0zzzzzzzzzzzzzzzzzzzzzzzz\0\0\0zzzzzzzzz\0\5\255zzz\0\0\0\0\0\0\0\22\49\0\2\153\0\0\0\0\0\0\0\4\106\0\6\184\0\6\184\0\6\184\0\0\0\0\3\132\0\25\246\0\0\0\0\13\154\0\13\154\0\0\0\0\23\101\0\1\119\0\1\119\0\0\0\0\1\244\0\2\113\0\2\113zzz\0\0\0\0\0\0\0\0\0\0\0\5\0\0\7\0\0\7\0\0\7\0\0\0\0\0\7\0\0\10\0\0\5\0\0\5\0\0\5\0\0\10\0\0\7\0\0\4\0\0\6\0\0\14\0\0\4\0\0\6\0\0\11\0\0\4\0\0\7\0\0\6\0\0\10\0\0\1\0\0\3\0\0\5\0\0\1\0\0\2\0\0\4\0\0\3\0\0\4\0\0\2\0\0\2\0\0\2\0\0\2\0\0\8\0\0\1\0\0\9\0\0\2\0\0\3\0\0\3\0\0\3\0\0\7\0\0\3\0\0\250zzz\0\4\226\0\0\0zzzzzzzzz\0\0\100\0\0\200zzz\0\0\200\0\0\0\0\0\0\0\0\0zzz\0\0\0\0\0\1\0\0\1zzzzzz\0\0\0\0\0\250\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\25\0\0\40\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\125zzz\0\0\0\0\0\0zzzzzzzzzzzzzzzzzzzzzzzzzzzzzz\0\0\2\0\0\50zzzzzzzzzzzzzzzzzz\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\1\78\194\0\0\0\1\125\239\0\0\0zzz\0\0\12\0\0\12\0\0\12\1\175\41\0\0\0zzzzzzzzzzzz\0\0\0\0\0\0zzzzzzzzzzzzzzzzzzzzzzzz\0\0\2\0\0\50\0\0\0\0\0\125\0\0\1zzz\0\0\12\0\0\1zzz\0\0\0zzzzzz\0\0\25\0\0\0\0\0\100zzzzzzzzz\0\0\0\0\0\0\0\0\0zzz\0\0\0\0\0\0zzzzzzzzz\0\0\37\0\51\212\0\41\213\0\84\108\0\84\108\0\41\213\0\80\140\0\92\119\0\40\212\0\52\238\0\59\195\1\95\97\2\225\216\2\225\216zzz\0\0\0\0\0\0\0\0\0\0\0\0zzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzz\1\134\160zzzzzz\0\0\125zzz\0\4\226zzzzzz\0\6\214\0\5\220\0\11\184\0\9\196\0\15\160\0\29\76\0\0\2zzzzzz\0\0\0zzz\0\0\0\0\0\0zzz\0\0\0zzz\0\0\0\0\0\0\0\0\0zzz\1\64\225\0\0\100\1\67\70zzz\0\0\0\0\0\0zzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzz\0\0\12zzz\1\80\192\0\216\75zzzzzz\1\0\45\1\172\112\0\0\0\1\134\114\0\0\0\0\4\226\0\35\166\1\134\160\1\134\160\1\134\160\1\134\160\1\134\160\1\134\160\1\134\160\0\0\0\1\134\160\1\134\160\1\134\160\1\134\160\1\134\160\1\134\160\1\134\160\1\134\160\1\134\160\1\134\160\1\134\160\1\134\160\1\134\160\1\134\160zzz\1\134\160\1\134\160\1\134\160zzz\1\134\160\1\134\160zzzzzzzzz\0\33\25\0\24\233\0\0\0zzzzzz\0\84\209\0\45\155\0\29\20\0\36\123\0\87\225zzz\0\103\71zzzzzzzzz\0\35\31zzzzzz\0\168\2\0\163\45\0\243\66\0\227\5\0\165\15\0\140\151\0\95\54\0\131\178\0\99\34\0\96\72\0\0\0\0\19\136\0\78\32\1\56\128\0\145\92\0\98\110\0\101\91\0\140\43\0\105\127\0\95\206\0\93\13\0\93\105\0\138\253\0\129\179\0\122\14\0\118\141\0\119\0\0\164\150\0\177\179\0\11\184\0\120\202\0\125\73\0\124\230\0\172\187zzz\0\187\28\0\152\179\0\157\172\0\158\235\0\191\146\0\0\0\0\207\169\0\78\32\0\145\229\0\142\86\0\210\215\0\196\189\0\143\243\0\0\200zzzzzzzzzzzzzzz\0\0\200zzzzzz\0\0\12\0\184\55\0\161\222\0\241\80\0\225\49\0\163\188zzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzz\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0zzz\0\0\0zzz\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\1\119\177\0\158\19\0\136\217\0\87\131\0\91\128\0\107\193\0\78\206\0\237\66\0\166\90\0\115\82\0\57\224\0\87\39\0\58\83\0\0\0\1\27\73\0\142\47\0\68\54\0\57\13\0\68\184\1\90\211\0\86\235\1\67\190\0\89\125\0\167\166\0\144\55\1\89\183\0\225\20\0\106\3\0\72\69\0\114\162\0\99\68\1\38\39\0\82\252\0\178\90\0\98\120\0\84\62\1\8\228\0\67\167\0\121\206\0\58\83\1\101\233\0\107\195\0\57\144\0\161\189\0\46\96\0\105\48\1\36\136\0\117\107\0\47\9\0\53\100\0\64\82\0\75\192\1\180\12\1\180\12\1\180\12\1\180\12zzzzzzzzzzzzzzzzzzzzzzzz\0\0\0\0\97\150\0\0\0zzz\1\76\137\1\45\250\1\55\132\1\56\177\0\0\1\0\0\1\12\162\181\0\128\100zzz\1\98\164\0\194\179\1\146\118\0\122\148zzzzzzzzzzzzzzz\0\0\1\0\0\1zzz\0\0\1\0\0\1\0\0\1\0\0\1zzz\0\0\35\0\9\196\0\58\152\0\0\0\0\0\0\0\0\0\0\0\5\0\0\0\0\0\0\0\0\0\0\0\0\0\0\6\0\0\6\0\0\6\0\0\0\0\0\6\0\0\6zzz\0\0\0zzzzzzzzzzzzzzzzzz\0\0\25\0\0\0\0\0\0\0\0\25\0\0\0\0\0\25\0\0\0\0\0\0\1\165\254\0\0\0\0\124\45\0\70\208\0\106\159\0\0\0\0\71\157\0\92\59\0\0\0\0\0\0\0\0\12\0\0\12\0\0\12\0\0\12\0\0\12\0\0\0\0\0\12\1\91\201\1\27\203\0\114\31\0\97\162\0\98\2\1\52\177\0\84\129\0\246\50\0\68\25\0\85\109\0\120\183\0\103\65\1\145\121\0\86\168\0\222\163\0\69\210\0\0\0\0\0\0\0\0\0\0\96\38\0\233\116\0\78\30\0\113\112\0\64\177\1\90\85\0\97\192\1\71\8\0\115\137\0\98\209\1\68\86\0\199\20\0\98\198\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\1\137\216\0\0\0\0\0\0\0\0\0\0\167\145zzz\0\0\0\0\0\0\0\0\0\0\0\0\0\122\148\0\0\0\1\81\98\0\98\0\0\0\0\1\53\37\0\186\51\0\218\16\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\129\201\1\81\171\0\122\141\1\100\216\0\211\126\0\181\252\0\114\43\1\57\175\0\122\183\0\76\251\1\53\28\0\109\56\0\77\221\0\125\9\1\122\85\1\133\57\1\161\181\0\162\64\1\100\233\0\81\185\0\172\125\0\149\77\1\84\80\0\99\204\1\146\83\0\157\21\0\75\60\1\32\21\0\106\188\0\107\37\0\114\148\0\92\3\1\96\165\0\123\153\0\93\11\0\152\15\0\141\160\1\97\167\0\94\174\1\51\38\1\141\75\0\167\35\0\144\175\0\168\79\1\77\151\0\73\52\1\187\234\0\104\56zzz\1\194\0\0\0\250\0\0\50\1\49\39\0\0\50\0\0\0\0\0\50\0\0\0\0\0\0\0\0\3\0\4\226\0\4\226\0\0\175\0\0\175\0\0\175\0\1\19\0\1\19\0\1\19\0\3\107\0\3\107\0\3\107\0\15\160\0\15\160\0\15\160\0\0\0\0\15\160\0\3\107\0\0\0zzzzzzzzzzzzzzzzzzzzz\0\0\75\0\5\220zzzzzzzzz\0\4\226\0\19\136\0\16\211\0\16\211\0\5\220zzz\0\5\220\0\0\0\0\5\220zzzzzz\0\5\220\0\25\20\0\9\238\0\29\76\0\32\183\0\48\212\0\5\220zzzzzz\0\0\0\0\0\0\0\44\152\0\32\183zzz\0\14\166\0\72\230\0\83\57\0\0\0zzz\0\0\0zzz\0\58\152\0\0\0\0\0\0\0\0\0\0\0\0\0\58\152\0\30\87\0\48\215\0\98\130\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\154\99\0\154\253\0\207\115\0\109\31\0\94\16\0\109\243\1\17\54zzzzzz\0\190\15\0\66\143\0\0\0zzzzzz\0\220\235zzzzzzzzzzzzzzzzzzzzzzzzzzz\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\25zzzzzz\0\0\0\0\0\25\0\0\0\0\0\125\1\122\85\1\55\100\0\124\252\1\106\244\0\15\160\0\39\16\0\31\64\0\39\16\0\31\64\0\15\160\0\84\128\0\84\208\0\170\64\0\47\229\0\48\18\0\51\3\0\105\46\0\83\88\0\114\83\0\117\139\1\131\210\0\0\0\0\78\32\0\124\139\0\96\40\0\134\4\0\134\133\0\79\250\0\120\104\0\161\35\0\67\45\0\102\197\0\138\158\0\128\33\0\128\153\0\172\23\0\156\64\0\94\25\0\130\118\0\183\4\0\195\80\0\3\32\0\0\0\0\0\0\0\0\0\0\19\136\0\9\196\0\0\0\0\15\160\0\15\160\0\15\160\0\4\226\0\60\70\0\111\162\0\95\125\1\132\50\0\39\16\0\39\16\0\39\16\0\39\16\0\39\16\0\39\16\0\58\152\0\58\152\0\58\152\0\58\152\0\78\32\0\58\152\0\58\152\0\58\152\0\58\152\0\78\32\0\58\152\0\58\152\0\58\152\0\58\152\0\58\152\0\58\152\0\58\152zzz\0\58\152\0\58\152\0\58\152\0\58\152zzzzzz\0\0\0\0\0\0\0\0\0zzzzzz\0\0\125zzz\0\9\196\0\0\0\0\0\250\0\0\250\0\2\238\0\5\220zzzzzzzzzzzz\1\134\160\0\4\226\0\4\226\0\5\220\0\5\220\0\7\83\0\7\83zzz\0\7\83\0\7\83\0\9\196\0\0\0\0\0\0\0\9\196\0\12\53\0\9\196zzzzzz\0\13\47\0\0\0\0\0\0zzz\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0zzz\0\0\0\0\0\0\0\0\0zzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzz\0\4\251\0\11\184\0\19\136\0\39\16\0\71\230\0\133\228\0\72\111\0\180\48\0\69\67\0\135\227\0\148\24\0\109\213\0\52\152\0\98\173\0\54\89\0\101\246\0\47\2\0\100\191\0\74\222\0\124\226\0\60\91\0\60\148\0\48\212\0\114\28\5\22\21\0\58\93\0\93\1\0\125\137zzzzzz\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0zzz\0\0\0zzzzzzzzzzzzzzzzzzzzz\0\0\150\0\0\150\0\0\175zzzzzz\0\0\0zzz\0\160\55\0\121\33\0\43\41\0\43\80\0\81\64\0\81\137\0\37\151\0\80\144\0\61\133\0\102\157\0\41\82\0\41\122\0\84\87\0\62\171\0\78\99\0\104\228\0\78\245\0\40\59\0\42\139\0\42\177\0\80\25\0\40\208\0\64\188\0\107\240\0\75\133\0\82\42\0\71\165\0\133\103\0\72\45\0\179\142\0\69\3\0\135\102\0\147\148\0\109\116zzz\0\63\30\0\118\243\0\118\219\0\63\206\0\60\198\0\120\233\0\90\66\0\149\224zzzzzzzzz\0\50\223\0\95\118\0\51\66\0\96\43\0\49\2\0\105\3\0\78\8\0\130\33zzzzzzzzzzzz\0\0\0zzzzzzzzzzzzzzz\0\0\0\0\0\0\0\0\0\0\0\0zzz\0\0\0\0\0\0zzzzzzzzzzzzzzzzzz\0\0\12zzzzzzzzzzzzzzzzzzzzzzzz\1\134\160\0\4\226\0\1\119\0\40\43\0\40\43\0\0\0\0\0\0\1\134\160zzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzz\0\52\188\0\25\100\0\35\40\0\65\110\0\31\64\0\42\248\0\35\40\0\52\188\0\65\110\0\28\82\0\65\110\0\35\40\0\185\189zzzzzz\0\91\159\0\67\69\0\220\146\0\73\227\0\184\84\0\0\0zzzzzz\0\9\196\0\19\136\0\48\115\0\58\150zzz\0\58\199\0\222\247\0\48\212\0\0\0\0\0\0\0\72\204\0\0\0\0\48\212\0\0\0zzzzzzzzz\0\48\212\0\48\212\0\78\32\0\78\32\0\77\10zzz\0\58\89zzzzzzzzzzzz\0\0\0\0\62\8\0\56\85\0\0\0\0\37\241zzzzzzzzzzzzzzz\0\58\124\0\61\123\0\46\147\0\0\250\0\3\232\0\48\87\0\9\196\0\62\215\0\39\16\0\117\48\0\0\250\0\39\16\0\117\48\0\134\146\0\119\191\0\128\34\0\32\44\0\141\31\0\0\0zzzzzzzzzzzzzzzzzzzzz\0\171\102\0\62\212\1\2\242\0\63\71\0\81\19\0\87\56\0\59\48\0\0\0\0\59\166\0\60\23\0\0\1\0\0\1\0\0\1\0\0\1\0\0\1\0\0\1\0\0\1zzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzz\0\81\247\0\61\179\0\81\117\0\40\82\0\60\178\0\40\156\0\5\220\0\19\136\0\48\212\0\19\136\0\57\166\0\48\212\0\38\184\0\242\237\0\195\17\0\0\0\0\196\130\0\147\237\0\151\8\0\0\12\0\41\43\0\200\34\0\0\0\0\0\200\0\46\243\0\59\178\0\9\231\0\136\164\0\134\146\0\57\109\0\141\157\0\195\133\0\245\83\0\53\214\0\250\130\0\128\189\0\60\146zzz\0\59\178\0\255\48\0\0\0\0\84\101\0\63\132zzz\0\57\28\0\0\0\0\149\188\0\250\134zzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzz\0\212\196\0\213\137\0\214\78\0\215\13zzzzzz\1\30\7\1\27\55\0\172\202\0\0\0\0\0\0\0\58\152\0\78\32\0\78\32\0\0\0\0\24\106\0\57\158\0\252\195\0\50\173\0\99\48\0\51\11\0\61\139\0\100\66\0\51\152\0\62\52\0\101\86\0\163\225\0\206\177\0\56\79\0\242\16\0\72\226\0\150\89\0\100\155\0\60\149\0\106\54\0\61\8zzzzzz\0\0\0\1\11\153\1\2\49\0\193\245\0\190\190\0\191\110\0\131\179\0\122\209\0\123\73\0\123\193\1\0\247\0\124\175\0\248\226\0\187\1\0\183\234\0\184\153\0\127\4zzz\0\59\178zzzzzz\0\229\88\0\221\68\0\154\156\0\152\197\0\153\92\0\104\67\0\104\170\0\105\16zzzzzzzzzzzzzzzzzzzzz\0\15\160\0\15\160\0\0\0\0\0\0\0\0\0\0\15\160\0\15\160\0\148\4zzzzzz\0\4\226\0\125\0\0\156\64\0\219\91\0\211\175\0\159\93\0\157\110\0\158\5\0\107\110\0\110\178\0\111\22\0\76\44zzz\0\0\0\0\0\0\0\196\8\0\189\32\0\128\205\0\126\180\0\127\50\0\86\222\0\87\49\0\87\134zzz\0\0\0\0\0\0zzz\0\190\129\0\183\207\0\138\88\0\136\14\0\136\139\0\93\56\0\93\142\0\93\227\0\156\207\0\151\70\0\103\8\0\101\90\0\101\190\0\69\123\0\71\168\0\71\236\0\150\46\0\144\230\0\109\19\0\107\70\0\107\168\0\73\130\0\73\198\0\74\11\0\154\147\0\149\35\0\112\65\0\110\100\0\110\198\0\75\161\0\70\151\0\70\219zzz\0\5\220\0\5\220zzzzzz\0\0\200\0\0\200\0\0\200\0\0\200\0\0\200\0\58\152\0\58\152\0\58\152\0\58\152\0\78\32\0\97\168\0\97\168\0\97\168\0\195\80\0\58\152\0\58\152\0\78\32\0\39\16\0\58\152\0\58\152\0\58\152\0\0\0\0\58\152\0\58\152zzzzzz\0\58\152\0\58\152\0\78\32\0\58\152\0\78\32\0\58\152\0\97\168\0\97\168\0\58\152\0\58\152\0\58\152\0\48\212\0\68\92\0\0\0\0\58\152zzzzzzzzz\0\0\0zzz\0\0\62\0\1\144\0\1\144\0\1\144\0\1\144\0\1\144\0\1\144\0\1\144zzzzzz\0\0\0\0\0\0zzz\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\2\208\238zzzzzzzzzzzzzzzzzz\0\0\0zzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzz\0\0\0zzzzzzzzzzzzzzz\0\0\0\0\0\0zzzzzzzzz\2\211\70\2\163\21\2\165\162zzzzzzzzzzzzzzzzzzzzzzzz\0\0\146\0\0\146\0\0\0\0\0\12\0\0\25zzz\0\0\100\0\0\12\0\0\12\0\0\12zzz\0\130\76zzz\0\65\164\0\65\225\0\193\204\0\131\89\0\99\236\0\131\89\0\67\61\0\168\92\0\84\124\0\86\251\0\189\149\0\95\40\0\95\135\0\49\245\0\62\176\0\225\115\0\113\202\0\114\56zzzzzzzzzzzzzzzzzz\1\178\199\0\34\46\0\41\213\0\41\213\0\78\32\0\87\228\0\0\0\0\0\0\0\0\0\0\0\0\0\203\209\0\76\183\0\123\54\1\176\39\0\0\0zzz\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\240\23\0\137\172\0\172\180\0\207\251\0\0\0\0\0\0\0\0\0zzz\1\129\100zzz\0\0\0\0\0\30\0\86\146\0\65\97\0\218\186\0\77\70\0\66\23\0\44\56zzz\0\83\131zzz\0\67\72\0\250\30\0\250\30zzz\0\0\0\0\151\134zzzzzz\0\19\136\0\7\208\0\72\48\0\108\173\1\81\171zzzzzzzzz\0\0\0zzz\0\0\0\0\57\158zzzzzz\0\0\1\0\0\1\0\0\1\0\0\1\0\0\12zzzzzzzzzzzz\0\0\0zzzzzzzzzzzz\0\90\165\0\68\57\0\68\120\0\79\200\0\80\23\0\53\151\0\150\162\0\76\9\0\76\81\0\0\0\0\48\212\0\48\212\0\48\212\0\48\212\0\48\212\0\48\212\0\48\212\0\48\212\0\48\212\0\0\75\0\0\25\0\0\37\0\2\188\0\2\188zzz\0\0\0\0\0\0\0\5\107\0\3\34\0\1\244\0\1\244\0\2\88\0\2\238\0\1\244\0\2\238\0\3\232\0\4\226\0\9\196\0\39\16zzzzzz\0\4\226\1\179\98\1\181\17\1\156\146\1\158\39\1\97\168\1\70\195\1\79\23\0\0\0\1\74\114\1\82\219\1\93\49\1\182\19\1\2\48\1\8\184\1\26\135\1\178\237\0\0\0\1\182\6\1\103\66\0\0\0\0\209\152\0\230\110\0\247\132\1\16\22\0\0\0\0\9\196\0\9\196\0\9\196\0\9\196\0\9\196\0\9\196\0\19\136\0\15\160\0\15\160\0\19\136\0\9\196\0\15\160\0\23\112\0\19\136\0\19\136\0\19\136\0\19\136\0\23\112\0\23\112\0\23\112zzz\0\23\112\0\23\112\0\23\112\0\23\112\0\27\88\0\27\88\0\27\88\0\78\32zzz\0\78\32\0\78\32zzzzzzzzzzzzzzzzzz\0\78\32zzzzzzzzzzzz\0\78\32zzzzzzzzzzzz\0\19\136zzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzz\0\39\16\0\39\16zzzzzzzzzzzz\0\0\0\0\39\16\0\0\0\0\0\0\0\29\76\0\29\76\0\39\16\0\39\16\0\39\16\0\48\212zzz\0\48\212\0\58\152\0\48\212\0\78\32\0\48\212\0\78\32\0\78\32\0\78\32\0\78\32zzz\0\78\32\0\78\32\0\97\168\0\58\152\0\58\152\0\97\168\0\97\168\0\97\168\0\97\168\0\97\168\0\58\152\0\0\0\0\0\0zzz\0\0\0zzz\0\0\0zzz\1\89\35\0\120\175\1\27\203\0\103\155\0\235\96\0\182\75\0\130\236\1\86\251\1\145\121zzzzzzzzz\1\89\35zzzzzzzzz\0\0\27\0\0\16\0\0\33\1\100\24zzz\0\0\57\0\0\57\0\0\182\0\0\183\0\104\89\1\187\234zzz\0\0\149\0\0\24\0\0\20\0\0\16\0\161\53\0\99\206\0\0\230zzz\0\0\231zzzzzzzzzzzz\0\0\250zzzzzz\0\1\147\0\9\189\1\247\94\0\5\227\0\105\119\0\7\87\0\1\151\0\1\16\0\1\86\1\76\168\0\0\0\0\2\64\0\0\208\0\1\5\0\1\60\1\100\216\0\9\144\0\3\143\0\4\48\0\2\205\0\9\196\0\248\148\1\100\24zzzzzz\0\98\71\0\98\165\0\99\7zzzzzz\0\250\100zzzzzzzzzzzz\1\76\246zzzzzz\0\105\230\0\235\96\0\186\76\0\133\201\0\71\155zzz\1\81\171zzz\0\235\96\0\0\0\1\100\24\1\129\100\1\27\203\0\100\134\0\235\96\0\101\70\0\156\145\0\0\0\0\105\35\1\89\35\0\235\96\0\235\96\1\188\83\1\100\24\1\100\24\1\100\24\0\224\61\1\71\125\0\105\237\1\100\24\1\100\24\1\27\203\1\27\203\0\110\225\0\0\0\0\0\0\1\81\171\1\115\71zzz\1\117\249\1\145\121\0\0\0\0\235\96\0\235\96\0\235\96\0\235\96\0\235\96\0\235\96\0\235\96\0\235\96\0\235\96\0\239\23\0\140\4\0\140\136\0\172\169\0\131\8\0\130\111\0\0\0\0\224\58\0\0\0\0\9\196\0\73\182\0\9\196\0\0\0\0\49\47\0\59\63zzz\0\39\203\0\79\227\0\0\0\0\140\217\0\121\42\0\101\88\0\71\156\0\40\214\0\61\121\0\51\106\0\9\196\0\9\196\0\9\196\0\9\196\0\9\196\0\9\196\0\9\196\0\9\196\0\0\0\0\9\196\0\9\196\0\9\196\0\9\196\0\9\196\0\9\196\0\9\196\0\9\196\0\9\196\0\9\196\0\9\196\0\9\196\0\9\196\0\9\196\0\9\196\0\9\196\0\9\196\0\9\196\0\9\196\0\0\40\0\0\40\0\238\167\0\163\225\0\38\119\0\60\88\0\39\214\0\41\11\0\39\16\0\48\212\0\207\108\0\58\152\0\58\152\0\39\16\0\48\212\0\58\152\0\58\152\0\123\61\0\39\16\0\48\212\0\58\152\0\58\152\0\39\16\0\48\212\0\58\152\0\58\152\0\39\16\0\48\212\0\58\152\0\58\152\0\39\16\0\48\212\0\58\152\0\58\152\0\51\57\0\0\0\0\0\0\0\0\0\0\0\200\0\0\200\0\0\0\0\0\0\0\0\0zzzzzzzzz\0\10\105\0\13\154\0\10\124\0\16\117\0\0\0\0\5\77\0\0\0\0\0\0\0\0\0\0\41\40\0\16\134zzzzzzzzzzzzzzzzzz\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0zzz\0\27\231\0\0\0zzzzzzzzz\0\61\74\0\61\133\0\61\192\0\61\251\0\62\53\0\0\0\0\62\171\0\0\0zzzzzzzzz\0\0\0\0\0\0\0\0\0zzz\0\0\0\0\0\0\0\0\0zzz\0\0\0zzzzzz\0\121\214\0\138\244\1\85\117\0\0\0\0\0\0\0\0\0\0\0\0\0\178\106\0\0\0zzz\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\235\96\0\216\25zzz\0\0\0\0\0\0\1\114\93zzzzzz\0\0\0zzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzz\0\0\58\0\0\98\0\0\59zzzzzzzzz\0\0\0zzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzz\1\134\160\0\0\1\0\0\1\0\0\1zzz\0\0\0zzzzzz\0\0\0\0\0\5\0\0\0\0\0\4\0\0\3\0\0\5\0\0\10\0\0\0zzzzzzzzzzzz\0\0\0\0\0\0\0\0\0zzz\0\0\1\0\0\1\0\0\9\0\0\5\0\0\1\0\0\0\0\0\0\0\0\0\0\0\0\0\0\3\0\0\6\0\0\200\0\0\0\0\0\0zzz\0\0\0\0\0\0zzz\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\9\0\0\0\0\0\0\0\0\38\0\0\48\0\0\72\0\0\58\0\0\0\0\0\19\0\0\11\0\0\15\0\0\0zzz\0\0\25\0\0\10\0\0\0\0\0\15\0\0\15\0\0\15\0\0\17zzz\0\0\0\0\0\15\0\0\31\0\0\25\0\0\25\0\0\25zzz\0\0\73\0\0\115\0\0\23\0\0\86\0\0\100\0\0\255\0\3\34\0\2\65\0\1\91\0\0\218\0\0\194\0\1\112\0\0\246\0\1\53\0\4\48\0\5\155\0\7\8\0\1\173\0\1\30\0\1\103\0\2\214\0\0\0zzz\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\1\41\0\3\232\0\5\220\0\9\196\0\4\226\0\0\0\0\1\47\0\0\243\0\0\244\0\0\0\0\0\0\0\0\0zzz\0\117\48\0\117\48\0\117\48\0\117\48\0\117\48\0\117\48zzz\0\0\0\0\0\110\0\7\208\0\11\184\0\9\196\0\87\228\0\48\212\0\0\0zzzzzzzzzzzzzzzzzzzzzzzzzzz\0\0\0\0\0\0\0\0\0\0\0\0zzzzzzzzzzzzzzzzzz\0\0\0\0\0\0\0\0\0\0\0\1\0\0\1\0\0\1\0\0\1\0\0\1\0\0\1\0\0\1zzz\0\0\0\0\79\45zzz\0\81\233zzzzzz\0\130\139\0\175\5\0\185\115\0\155\80\0\73\178zzz\0\108\35\0\76\159zzz\0\0\0\0\227\52\0\234\159\1\54\223zzzzzz\1\66\215\1\76\151\1\11\12\1\18\236\0\111\170\0\228\180\0\112\121\0\246\8\0\123\41\0\184\0\0\250\163\0\251\135\0\125\234\0\115\167\0\174\55\0\118\103\0\236\88\0\178\254\0\120\176\0\180\79\0\241\195\0\240\188\0\121\127\0\182\245\0\105\32\0\211\4\0\2\238\0\3\232\0\46\224\0\122\27\0\143\210\0\144\91\0\185\63\0\216\135\0\217\83\0\146\138\0\147\22\0\147\163\1\164\242\2\16\34\1\168\18\2\20\10\1\171\38zzz\2\25\215zzzzzzzzzzzzzzzzzz\0\0\176\1\155\159\1\157\35\1\158\179\0\247\233\0\7\15\0\2\238zzzzzzzzz\1\10\136\1\56\156\1\100\191zzz\0\0\0zzzzzz\0\7\15\0\62\128\0\62\128\0\117\48\0\78\32\0\5\220\0\4\226\1\103\21zzzzzzzzz\0\0\0\0\0\0\0\0\0zzz\0\0\200\0\0\85\0\72\90zzzzzz\0\39\16\0\39\16\0\39\16\0\39\16\0\58\152\0\58\152\0\58\152\0\58\152\0\58\152\0\58\152\0\78\32\0\58\152\0\58\152\0\58\152\0\78\32\0\58\152\0\58\152\0\58\152\0\234\96\0\234\96\0\234\96\0\78\32\0\78\32\0\97\168zzz\0\58\152\0\0\0\0\58\152\0\58\152\0\58\152\1\212\192\1\212\192\1\212\192\1\212\192\1\212\192\1\212\192\1\212\192\1\212\192\1\212\192\1\212\192\1\212\192\1\212\192\1\212\192\1\212\192\1\212\192\1\212\192\1\212\192\1\212\192\0\58\152\1\36\248\0\0\0\0\0\0zzzzzzzzzzzzzzz\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0zzz\0\0\0\0\0\0zzzzzzzzzzzzzzzzzz\0\100\193\0\152\95\0\203\10\0\119\146\0\178\173\0\239\146zzzzzzzzzzzz\0\0\0\0\0\0zzz\0\0\5zzzzzzzzzzzzzzzzzz\0\0\0\0\0\0zzzzzzzzzzzz\0\0\0\0\0\0zzzzzzzzzzzzzzz\0\0\0zzz\0\0\0\0\0\0\0\0\0\0\0\0zzzzzz\0\0\0zzzzzzzzz\0\0\0zzz\0\0\0\0\17\148\0\0\0zzzzzz\0\0\0zzzzzzzzz\0\0\0zzz\0\0\0\0\0\0zzz\0\0\0\0\0\0zzz\0\0\0\0\0\0\0\0\0\0\25\100\0\58\152zzzzzz\0\14\166zzz\0\9\196\0\9\196zzzzzz\0\0\0\0\0\0\0\184\112\0\0\0zzz\0\14\166\0\217\173\0\243\205\1\3\8zzzzzzzzzzzzzzz\0\0\0\0\58\152\0\0\10zzz\0\115\227zzzzzz\0\80\54\0\98\236\0\124\30\0\9\196\0\9\196\0\78\32\0\19\136\0\0\250\0\0\250\0\0\0\0\0\250\0\0\20\0\0\2\0\117\48\0\0\0zzzzzzzzzzzzzzz\0\1\244\0\31\64\0\5\220\0\39\16\0\117\48\0\46\224\0\46\224zzzzzzzzzzzzzzz\0\24\106\0\0\0\0\0\0\0\0\0zzzzzz\0\78\32\0\97\168zzz\0\146\124\0\58\152\0\78\32\0\78\32\0\156\64\0\58\152\0\156\64\0\58\152\0\78\32\0\58\152\0\0\0\0\0\0\0\58\152\0\58\152\0\39\16\0\0\0zzz\0\23\112\0\58\152\0\58\152\1\134\160\1\134\160\0\127\222\0\66\200\0\11\184\0\15\160\0\119\83\0\149\177zzz\0\0\0\0\0\0zzzzzz\0\87\228\0\87\228zzz\0\115\14\0\173\57\0\0\0\0\11\184\0\0\0zzz\0\2\154zzzzzzzzz\0\1\244zzzzzzzzz\0\3\107\0\0\0\0\0\0\0\15\160\0\0\0zzz\0\5\220zzzzzz\0\0\0zzzzzzzzzzzz\0\5\220\0\5\220\0\5\220zzzzzzzzz\0\0\0zzz\0\78\32zzzzzzzzzzzzzzzzzzzzz\0\0\0\0\68\92\0\78\32\0\48\212zzz\0\58\152\0\23\112\0\0\0zzzzzzzzzzzzzzz\0\0\0zzzzzzzzzzzzzzzzzzzzzzzz\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\7zzz\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0zzz\0\0\3zzz\0\0\27\0\2\70\0\0\17zzzzzzzzzzzzzzzzzz\0\0\16zzzzzzzzz\0\0\0\0\0\0zzz\0\5\45\0\4\161\0\0\0\0\0\0\0\0\0\0\0\0\0\0\7\0\0\8\0\0\9\0\0\14\0\0\17\0\0\22\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\3\102\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\2\193\0\1\242\0\2\93\0\3\222\0\0\0zzz\0\0\0\0\0\0zzzzzzzzz\0\0\25\0\0\30zzz\0\0\0\0\0\0\0\0\0\0\0\0zzzzzz\0\0\0zzz\0\0\0\0\9\196\0\58\152\0\48\212\0\58\152\0\58\152\0\9\196\0\0\0\0\0\100\0\0\100\0\0\225\0\0\225\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\249\235\0\175\159\0\151\25\0\63\51\0\76\33zzzzzz\0\117\48\0\117\48\0\117\48\0\117\48\0\117\48\0\117\48\0\117\48\0\0\0\0\117\48\0\117\48\0\117\48\0\0\0\0\117\48zzzzzzzzzzzz\1\61\47\0\53\214\0\157\145\0\117\48\0\117\48zzz\0\117\48\0\117\48\0\117\48\0\117\48\0\117\48\0\117\48\0\117\48\0\117\48\0\117\48\0\117\48\0\117\48\0\117\48\0\117\48\0\64\235\0\136\147\0\117\48\0\117\48\0\117\48\0\0\0\1\75\214\0\0\0\0\0\0\0\0\6\0\40\43\0\95\171\0\95\171\0\100\50\0\106\252\0\106\252\0\151\119\0\152\210zzz\0\152\210\0\103\220zzz\0\154\46\0\155\138\0\144\173\0\152\210\0\155\138\0\79\234\0\94\28\0\154\46\0\154\46\1\57\174\0\154\46\0\171\254\0\154\46\0\154\46zzz\0\0\0\1\134\160\1\134\160\0\0\29\0\0\33\0\0\6\0\152\210\0\0\145\0\0\121\0\0\48\0\152\210\0\0\126\0\0\76\0\0\46\0\154\46\0\0\0\0\154\46\0\155\138\0\5\220\0\5\220\0\5\220\0\155\138\0\119\133\0\119\248\0\46\224\0\58\152\0\58\152\0\58\152\0\58\152\0\0\6\0\0\7\0\0\7zzz\0\0\14\0\0\12\0\0\9\0\1\28\0\0\0\0\1\30zzzzzz\0\0\23\0\0\20\0\0\1\0\0\16\0\0\1\0\0\1\0\0\0\0\0\0\0\0\0\0\81\248\1\38\39zzzzzz\0\53\214\1\58\194zzzzzz\0\117\48\0\58\152\0\58\152\0\136\184\0\136\184\0\117\48\0\117\48\0\136\184\0\117\48\0\117\48\0\117\48\0\117\48\0\136\184\0\136\184\0\58\152\0\58\152\0\117\48\0\117\48\0\117\48\0\117\48\0\117\48\0\117\48\0\117\48\0\117\48\0\117\48\0\117\48zzzzzz\0\0\50\0\0\0\0\0\125\0\5\220\0\1\144\0\0\0\0\117\48\0\117\48\0\117\48\0\117\48\0\117\48\0\117\48\0\117\48\0\117\48\0\117\48\0\117\48\0\117\48\0\117\48\0\117\48\0\117\48\0\117\48\0\117\48\0\117\48\0\117\48\0\117\48\0\117\48\0\117\48\0\117\48\0\117\48\0\117\48\0\117\48\0\117\48\0\117\48\0\117\48\0\117\48zzz\0\172\178zzzzzzzzzzzz\0\0\0\0\0\0\0\0\0zzz\0\0\52\0\0\225zzz\0\1\244\0\3\32zzzzzzzzzzzzzzz\0\0\7\0\5\220\0\8\202\0\0\0\0\0\146\0\1\144zzzzzz\0\64\179\0\64\242\0\65\50\0\98\40\0\98\135\0\101\145\0\85\120\0\85\200\0\86\24\0\129\157\0\130\17\0\130\137\0\174\172\0\175\76\0\175\232\0\132\102\0\0\0\0\120\169\0\121\30\0\0\100\0\0\0\0\117\48\0\15\160\0\15\160\0\78\32\0\195\80\0\78\32\0\195\80zzzzzzzzzzzz\0\1\46\0\17\210\0\148\198zzz\5\184\216\1\232\72zzz\0\0\0zzzzzz\0\1\244\0\58\152\0\58\152\1\95\144\1\95\144\0\78\32\0\78\32\0\78\32\0\78\32\0\78\32\0\78\32\0\117\48\0\117\48\0\117\48\0\117\48\0\117\48\0\117\48\0\58\152\0\58\152\0\58\152\0\58\152\0\58\152\0\58\152\0\39\16\0\0\0\0\39\16zzzzzz\0\0\0\0\0\0\0\0\0\0\0\0zzz\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0zzz\0\0\0\0\0\0\0\0\0\0\3\30zzzzzzzzz\0\0\200\0\1\43\0\0\120\0\0\90\0\1\99\0\1\219zzz\1\134\160\0\1\165\0\2\16\0\2\124\0\1\156\0\1\156\0\5\176\0\7\35\0\4\76\0\7\48zzz\1\34\67\0\174\194\0\0\0\0\106\46\0\79\241\1\11\124\0\80\141\0\188\174\0\189\103\0\67\229\0\123\56zzz\0\1\244\0\0\0\0\0\0\0\0\0zzzzzzzzzzzz\0\7\15\0\0\0\1\36\69\0\79\160\0\199\209\0\200\151zzzzzz\1\13\197\0\76\190\0\81\136\0\96\1\0\82\31\0\206\15\0\81\1\0\138\91\0\55\139\0\55\190\1\93\166\0\56\35\0\140\216\0\113\19\0\106\98zzzzzz\0\2\238\0\0\12\0\3\232\0\1\244\0\1\244\0\2\238\0\3\232\0\3\232\0\0\0\0\0\0zzz\0\0\6\0\88\165zzzzzzzzz\0\0\2\0\0\0zzz\0\0\0zzzzzz\0\0\15\0\0\12\0\0\10zzzzzzzzz\0\7\208\0\0\184\0\0\152\0\0\172\0\0\104\0\0\174\0\0\24\0\0\13\0\0\11\0\0\122\0\0\153\0\0\185\0\0\18\0\0\0\0\0\0\0\0\0\0\0\43\0\0\36\0\0\67\0\0\150\0\0\146\0\59\248\0\90\67\0\68\79\1\18\78\0\82\156\0\138\51\0\194\56\0\145\241\0\98\105\0\84\47\0\126\210\1\97\106\0\40\43\0\153\58\1\37\123\0\176\185\0\147\201zzzzzzzzzzzzzzzzzzzzzzzzzzz\0\0\100\0\0\100\0\3\232\0\3\232zzz\0\116\27zzzzzzzzzzzzzzzzzzzzzzzzzzz\0\0\0zzzzzzzzz\0\0\0zzzzzzzzzzzzzzzzzzzzzzzzzzzzzz\0\0\0\0\3\102\0\4\161\0\0\0\0\3\222\0\5\45\0\0\0zzzzzz\0\0\0\0\3\102\0\3\222\0\0\0\0\4\161zzz\0\5\45zzzzzz\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0zzzzzz\0\3\232\0\0\0zzzzzzzzzzzzzzzzzz\0\0\0zzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzz\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0zzz\0\0\0\0\41\121\0\14\82\0\21\144\0\14\109zzz\0\21\203zzz\0\65\125\0\87\159\0\43\247\0\59\228\0\80\42\0\60\89\0\40\99\0\41\219\0\63\6\0\84\88\0\43\122\0\65\117\0\87\151\0\65\238\0\44\29\0\45\170\0\68\189\0\91\251\0\46\39\0\69\123\0\92\246\0\69\248\0\46\207\0\43\206\0\65\245\0\88\72\0\45\135\0\68\138\0\91\186\0\69\13\0\46\52\0\47\189\0\71\223\0\96\46\0\48\68\0\72\167\0\97\56\0\73\45\0\48\246\0\50\138\0\76\21\0\101\205\0\47\126\0\71\130\0\95\181\0\72\13\0\48\53\0\49\189\0\74\227\0\100\56\0\50\74\0\75\182\0\101\82\0\76\68\0\51\6\0\52\153\0\79\47\0\105\246\0\49\98\0\74\92\0\99\134\0\74\236\0\50\35\0\51\168\0\77\199\0\104\22\0\52\61\0\78\166\0\105\66\0\79\58\0\53\3\0\54\148\0\82\43\0\109\242\0\56\155\0\85\54\0\103\44\0\77\174\0\51\252\0\53\127\0\80\139\0\107\205\0\54\27\0\81\119\0\109\6\0\82\19\0\54\236\0\56\122\0\85\5\0\113\200\0\58\155\0\88\55\0\118\11\0\88\217\0\59\113\0\61\18\0\83\50\0\111\91\0\55\229\0\84\40\0\112\163\0\84\205\0\56\192\0\58\73\0\87\195\0\117\117\0\60\135\0\91\28\0\121\236\0\91\198\0\61\101\0\54\48\0\81\146\0\109\38\0\54\195\0\82\111\0\99\209\0\75\39\0\50\74\0\52\31\0\78\123\0\105\11\0\54\38\0\81\134\0\109\25\0\82\29\0\54\241\0\56\224\0\85\159\0\114\144\0\57\125\0\86\138\0\115\205\0\87\39\0\58\78\0\60\75\0\82\34\0\109\237\0\56\179\0\85\94\0\114\60\0\85\255\0\57\139\0\59\118\0\89\131\0\119\201\0\60\29\0\90\127\0\121\23\0\91\37\0\60\251\0\62\245\0\94\195\0\126\205\0\59\38\0\89\13\0\119\47\0\89\186\0\60\11\0\61\241\0\93\67\0\124\207\0\62\163\0\94\75\0\126\48\0\94\252\0\63\142\0\65\131\0\98\160\0\131\249\0\61\127\0\92\151\0\123\238\0\93\78\0\62\111\0\64\84\0\96\220\0\129\162\0\65\13\0\97\242\0\131\21\0\98\173\0\66\6\0\67\249\0\102\85\0\136\242\0\68\183\0\106\35\0\142\5\0\96\185\0\64\187\0\66\157\0\100\78\0\134\61\0\67\96\0\101\115\0\135\199\0\102\53\0\68\101\0\70\85\0\13\244\0\106\71\0\142\58\0\73\66\0\110\69\0\147\142\0\111\15\0\74\77\0\76\87\0\103\254\0\139\50\0\69\222\0\105\50\0\140\204\0\106\0\0\70\240\0\72\220\0\109\180\0\146\210\0\75\166\0\113\228\0\152\103\0\114\183\0\76\190\0\65\6\0\98\82\0\130\251\0\65\183\0\98\236\0\119\200\0\90\150\0\60\89\0\62\139\0\94\153\0\126\13\0\64\250\0\97\212\0\130\235\0\98\250\0\65\238\0\68\64\0\103\52\0\137\122\0\68\252\0\103\217\0\138\246\0\105\12\0\69\248\0\72\90\0\99\0\0\131\234\0\68\10\0\102\113\0\137\21\0\103\167\0\69\13\0\71\90\0\107\228\0\143\191\0\72\34\0\108\153\0\145\78\0\109\220\0\73\45\0\75\140\0\114\57\0\152\42\0\70\250\0\106\220\0\143\5\0\108\38\0\72\13\0\74\84\0\112\105\0\149\198\0\75\42\0\113\39\0\151\108\0\114\126\0\76\68\0\78\157\0\118\224\0\158\95\0\73\202\0\111\28\0\148\184\0\112\119\0\74\236\0\77\49\0\116\191\0\155\143\0\78\16\0\117\137\0\157\77\0\118\241\0\79\58\0\81\145\0\123\89\0\164\86\0\84\156\0\127\94\0\170\108\0\116\149\0\77\174\0\79\239\0\120\231\0\161\22\0\80\218\0\121\189\0\162\239\0\123\50\0\82\19\0\84\102\0\127\163\0\170\11\0\87\152\0\131\222\0\176\111\0\133\100\0\88\217\0\91\75\0\138\6\0\166\100\0\83\132\0\125\195\0\168\80\0\127\72\0\84\205\0\87\28\0\131\187\0\175\134\0\90\117\0\136\44\0\182\57\0\137\198\0\91\198\0\76\6\0\113\147\0\152\68\0\76\215\0\114\200\0\153\225\0\104\156\0\70\139\0\73\27\0\109\63\0\146\128\0\75\245\0\113\127\0\152\45\0\114\85\0\77\20\0\79\202\0\119\54\0\159\212\0\80\167\0\120\127\0\161\139\0\121\92\0\81\206\0\84\152\0\126\97\0\153\82\0\79\136\0\118\215\0\159\90\0\119\184\0\80\184\0\83\106\0\124\162\0\167\23\0\84\84\0\125\255\0\168\238\0\126\231\0\85\142\0\88\83\0\131\245\0\176\229\0\82\246\0\123\249\0\166\58\0\124\232\0\84\57\0\86\230\0\129\213\0\174\22\0\87\222\0\131\73\0\176\3\0\132\62\0\89\41\0\91\234\0\137\80\0\184\25\0\86\65\0\128\226\0\172\215\0\129\225\0\87\149\0\90\59\0\134\213\0\180\205\0\91\67\0\136\90\0\182\213\0\137\96\0\92\160\0\95\90\0\142\120\0\191\6\0\96\102\0\147\201\0\198\32\0\148\214\0\90\202\0\93\110\0\139\159\0\187\61\0\94\129\0\141\56\0\189\95\0\142\76\0\95\240\0\98\168\0\147\107\0\197\171\0\99\194\0\153\0\0\205\32\0\154\22\0\103\225\0\106\189\0\159\118\0\213\193\0\97\157\0\145\225\0\195\161\0\146\254\0\99\31\0\101\210\0\152\39\0\204\2\0\102\249\0\158\1\0\211\211\0\159\36\0\107\75\0\64\145\0\66\228\0\69\61\0\71\154\0\73\251\0\76\93\0\78\198\0\73\123\0\75\183\0\77\244\0\80\56\0\82\127\0\87\24\0\89\117\0\104\185\0\108\30\0\111\130\0\114\231\0\118\76\0\121\178\0\125\23\0\128\123\0\131\224\0\135\69\0\138\170\0\142\16\0\145\116\0\148\217\0\104\185\0\108\30\0\111\130\0\114\231\0\118\76\0\121\178\0\125\23\0\128\123\0\131\224\0\135\69\0\138\170\0\142\16\0\145\116\0\148\217\0\138\177\0\143\176\0\138\56\0\142\249\0\147\190\0\152\142\0\157\103\0\162\73\0\167\46\0\172\31\0\177\25\0\182\27\0\187\33\0\192\51\0\104\185\0\108\30\0\111\130\0\114\231\0\118\76\0\121\178\0\125\23\0\128\123\0\131\224\0\135\69\0\138\170\0\142\16\0\145\116\0\148\217\0\207\105\0\214\238\0\222\129\0\230\27\0\237\199\0\245\128\1\3\225\1\11\226\1\19\239\1\28\10\1\8\103\1\15\237\1\23\128\1\31\32\0\202\194\0\210\33\0\217\142\0\225\7\0\232\134\0\240\25\0\247\184\0\255\101\1\14\20\1\22\8\1\30\9\1\38\15\1\46\42\1\54\81\1\17\223\1\27\184\1\9\193\1\18\232\1\28\31\1\37\94\1\46\181\1\56\29\1\65\148\1\75\18\1\93\217\1\103\186\1\113\162\1\123\162\0\214\114\0\222\50\0\229\250\0\0\0\0\245\186\0\253\174\1\5\168\1\13\181\0\251\104\1\2\225\1\10\95\1\17\242\1\33\71\1\41\25\1\6\63\1\15\191\1\25\79\0\0\0\1\44\152\1\54\88\1\64\41\1\74\1\1\83\241\1\93\241\1\104\1\1\114\25\1\124\73\1\134\137\1\0\111\1\9\191\1\19\31\0\0\0\1\38\7\1\47\151\1\57\55\1\66\231\1\76\159\1\86\111\1\96\79\1\106\64\1\116\55\1\126\71\0\215\239\0\223\187\0\215\37\0\222\139\0\229\254\0\237\120\0\245\5\0\252\158\1\4\69\1\11\241\1\19\177\1\27\126\1\35\87\1\43\54\0\211\72\0\218\238\0\226\161\0\234\91\0\242\40\0\232\23\0\239\119\0\246\234\0\254\106\1\5\246\1\13\137\1\21\47\1\28\226\1\36\162\1\2\75\1\11\170\1\21\25\1\30\153\1\40\33\1\49\192\1\59\112\1\77\170\1\87\179\1\97\204\1\107\245\1\82\152\1\92\8\1\101\136\0\252\130\1\5\170\1\14\233\1\24\56\1\33\152\1\42\255\1\52\126\1\62\14\1\71\165\1\90\74\1\100\67\1\110\76\1\120\92\1\130\133\0\163\189\0\169\166\0\175\147\0\164\78\0\169\209\0\175\93\0\180\238\0\186\142\0\192\55\0\197\233\0\203\160\0\215\12\0\220\254\0\226\244\0\160\65\0\166\12\0\171\225\0\177\187\0\183\163\0\189\149\0\195\145\0\201\145\0\207\160\0\193\104\0\199\8\0\204\171\0\210\94\0\222\5\0\156\196\0\162\114\0\168\42\0\173\236\0\179\179\0\185\136\0\191\102\0\197\79\0\203\59\0\209\55\0\215\60\0\221\74\0\227\93\0\233\127\0\164\219\0\158\217\0\164\116\0\0\0\0\175\199\0\181\122\0\187\60\0\193\7\0\198\220\0\204\182\0\210\158\0\216\143\0\222\139\0\228\138\0\215\40\0\222\239\0\230\188\0\221\178\0\229\30\0\236\152\0\244\24\0\251\171\1\3\75\1\10\248\1\18\170\1\26\113\1\34\68\1\42\36\0\210\130\0\218\34\0\225\206\0\233\135\0\241\72\0\255\141\0\238\144\0\245\247\0\253\112\1\4\246\1\12\137\1\20\34\1\27\206\1\35\136\1\1\89\1\10\170\1\20\17\1\29\137\1\39\16\1\48\160\1\58\72\1\76\130\1\86\123\1\96\140\1\106\173\1\116\222\1\90\176\1\100\39\0\26\250\0\20\79\0\27\47\0\14\179\0\22\34\0\14\207\0\14\221\0\22\97\0\29\244\0\23\38\0\30\250\0\36\18\0\18\25\0\27\62\0\18\58\0\18\75\0\27\137\0\36\216\0\25\24\0\36\48\0\18\42\0\27\89\0\18\77\0\18\95\0\27\169\0\38\5\0\28\159\0\42\169\0\21\104\0\32\94\0\21\144\0\32\118\0\21\183\0\43\150\0\32\244\0\47\76\0\23\187\0\35\225\0\21\160\0\32\145\0\21\202\0\44\244\0\33\254\0\24\169\0\36\216\0\24\215\0\49\150\0\25\6\0\37\99\0\50\32\0\37\168\0\27\89\0\40\220\0\27\140\0\54\250\0\27\190\0\41\113\0\51\170\0\38\209\0\71\176\0\89\243\0\72\58\0\90\157\0\72\194\0\91\74\0\73\77\0\91\244\0\55\96\0\55\147\0\0\0\0\3\102\0\4\161\0\3\222\0\5\45\0\3\102\0\4\161\0\3\222\0\5\45\0\0\200\0\3\102\0\4\161\0\0\12\0\3\222\0\5\45\0\0\12\0\0\12\0\0\12\0\3\102\0\4\161\0\3\222\0\5\45\0\3\102\0\4\161\0\3\222\0\5\45\0\0\200\0\3\102\0\4\161\0\3\222\0\5\45\0\2\238\0\0\250\0\3\102\0\4\161\0\3\222\0\5\45\0\3\102\0\4\161\0\3\222\0\5\45zzzzzz\0\3\102\0\4\161\0\3\222\0\5\45\0\3\222\0\5\45\0\3\102\0\4\161zzzzzzzzzzzzzzz\0\1\244\0\12\229zzz\0\0\4\0\0\4zzz\0\25\100zzzzzzzzzzzzzzzzzzzzzzzz\0\84\91\0\108\180\0\48\70\0\85\69\0\109\228\0\48\203\0\48\248\0\86\127\0\61\166\0\118\76\0\118\76\0\67\168zzzzzz\0\234\101\0\0\0\1\39\39\0\236\255\0\178\103\0\0\0\0\0\25\0\118\76\0\118\76\0\72\171\0\83\27\0\47\100\0\59\115\0\114\231\0\110\243\0\123\183\0\115\114zzz\0\93\12\0\163\114\0\140\159\0\88\53\0\100\151\0\83\196\0\67\66\0\118\76\0\119\201\0\240\116\0\0\0\0\11\184\0\127\92\0\73\45\0\85\67\0\70\112\0\58\152zzzzzzzzz\0\125\96zzzzzzzzz\0\72\218zzz\1\32\23\1\105\113\1\34\54zzz\0\89\248\0\143\81\0\143\81\0\252\118\0\190\20\0\254\106\0\0\0\0\0\0zzzzzzzzz\0\0\0zzz\0\0\30zzzzzz\0\159\8\0\139\99\0\80\20\0\106\207\0\96\230\0\112\187\0\151\119\0\151\119\0\151\119\0\95\101\0\89\225\0\76\228\0\154\95\0\180\201\0\97\52\0\0\0\0\0\0\0\0\0\0\108\8\0\121\249\0\68\2\0\109\49\0\68\125\0\123\184\0\0\0\0\0\0\0\0\0\0\63\26\0\76\4\0\178\8zzz\0\0\0\0\0\0\0\138\247zzz\0\66\201\0\80\110\0\140\255\0\122\16\0\108\105\0\0\0\0\83\183\0\71\154\0\59\225\0\60\22\0\72\92\0\77\27\1\96\141zzz\0\73\2\0\128\123\0\128\123\1\113\25\0\74\23\0\109\140\0\41\246\0\131\221\0\49\167\0\157\216\0\131\7\0\94\27\0\94\114\0\75\211\0\27\88\0\27\88\0\71\65\1\58\158\0\88\238\0\162\77\0\0\0\0\0\0\0\0\0\0\27\88\0\193\190\0\77\198\0\78\15\0\195\221\0\27\88\0\27\88\0\0\0\0\75\193\0\50\177zzz\0\225\238\0\226\203\0\0\0zzz\0\91\190\0\92\22\0\92\108\0\0\0zzzzzz\0\0\250\0\29\76\0\87\228\0\87\228\0\68\92\0\68\28\0\101\250\0\143\174\0\155\250zzz\0\118\104\0\149\216\0\69\63\0\127\13\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\93\239\0\55\194\0\125\249\0\136\254zzz\0\84\213\0\62\25\0\119\66\0\126\55\0\0\0\0\0\0\0\0\250\0\122\68\0\147\71\0\123\51\0\148\98\0\0\0\0\81\35\0\128\94\0\171\200\0\0\0\0\175\210\0\175\8\0\131\190\0\199\166\0\143\59\0\100\134\0\95\243\0\195\196\0\98\67\0\0\0\0\4\226\0\4\226\0\189\147\0\163\24\0\0\100\0\0\0\0\0\0\0\0\0\0\24\106\0\2\238\0\0\0\0\104\234\0\112\79\0\84\136\0\135\44\0\112\164\0\130\245\0\75\66\0\97\11\0\77\237\0\3\100\0\48\212\0\48\212\0\48\212\0\0\20\0\0\22\0\48\212\0\9\196zzz\0\58\152\0\58\152\0\58\152\0\58\152\0\117\48\0\136\184\0\136\184\0\156\64\0\136\184\0\136\184\0\117\48\0\156\64\0\156\64\0\117\48\0\117\48\0\117\48\0\2\164zzzzzz\0\0\0\0\0\0\0\0\0\0\0\0zzz\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\1\53\60\1\131\251\1\133\108\1\134\210\1\57\206\1\58\245zzzzzzzzzzzzzzzzzzzzz\1\37\82\1\38\105\1\39\136\0\151\119\0\151\119\0\89\168\0\52\61\0\65\138\0\78\239\0\170\56\0\146\109\0\73\122\0\111\130\0\111\130\0\29\40\0\34\206\0\114\107\0\97\228\0\122\215\0\82\53\0\99\5\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\5\220\0\163\175\0\163\175\0\102\95\1\0\215zzz\0\234\14\0\163\175\0\94\89\0\163\175zzz\0\3\252\0\0\0zzz\0\0\0zzz\0\0\0\0\222\37\0\143\83\0\159\212\0\128\79\1\15\87\0\112\23\1\17\72\0\112\23zzzzzzzzzzzzzzzzzzzzzzzz\1\93\252\1\25\4zzz\0\141\134\0\0\0\0\0\0zzzzzz\0\31\64\0\125\0\0\156\64\0\39\16\0\117\48\0\97\168\0\117\48\0\0\0\0\0\0zzzzzzzzzzzzzzzzzzzzz\0\0\0\0\0\0\0\0\3zzzzzzzzzzzzzzz\0\117\48\0\117\48\0\78\32\0\78\32\0\0\0\0\0\7\0\0\18zzz\0\0\50\0\0\200\0\0\0\0\51\197\0\0\0\0\0\150\0\2\88\0\3\232\0\3\232\0\0\0\0\0\0\0\0\250\0\58\152\0\0\0zzz\0\117\48zzz\0\0\0\0\117\48\0\117\48\0\117\48\0\117\48\0\117\48\0\117\48\0\117\48\0\21\124\0\117\48\0\117\48\0\117\48\0\117\48\0\117\48\0\117\48\0\117\48\0\117\48\0\117\48\0\117\48zzzzzz\0\118\76\0\118\76\0\244\6\0\251\231\1\60\1\0\253\180\0\118\76\0\248\91\0\118\76\0\84\70\0\108\162\0\90\119\0\72\166\0\125\23\0\75\47\0\125\23\0\167\36\0\107\215\0\72\38\0\120\176\1\0\39\1\65\89\1\66\121\1\2\242\1\2\242zzz\0\231\59\0\92\209\0\127\1\0\102\7\1\34\242\1\109\11\0\87\240\0\110\82\0\133\119\0\88\137\0\63\28\1\117\38\0\114\238\1\44\179\0\226\88\0\32\185\0\136\198\0\107\95\0\91\212\0\82\249\0\70\252\0\59\97\0\47\173\1\71\85\0\121\178\1\44\19\0\72\151\0\72\220\0\0\0\0\0\0\0\0\0\0\84\153\0\157\234\0\158\121\0\159\13\0\69\162\0\87\97\0\105\64\0\123\8\0\196\1\0\151\194\0\130\143\0\81\232\0\43\217\0\66\5\0\82\212\1\38\0\1\39\24\1\40\48\0\0\0\0\111\130\0\0\0\0\0\0\0\111\130\0\111\130\0\0\0\0\0\0\0\0\0zzzzzzzzzzzzzzzzzz\0\0\0\0\0\124\0\1\67\0\0\160\0\1\128\0\0\101\0\1\38\0\0\183\0\1\130\0\0\148\0\1\42\0\0\93\0\0\0\0\0\169\0\1\102\0\0\152\0\1\139\0\0\191\0\1\202\0\0\123\0\1\104\0\0\224\0\1\217\0\1\108\0\0\181\0\0\126\0\0\0\0\1\251\0\0\196\0\0\246\0\2\77\0\0\140\0\1\152\0\0\255\0\2\27\0\1\168\0\0\211\0\0\147\0\0\0zzzzzzzzzzzz\0\0\0\0\0\0zzz\0\1\69\0\3\76\0\1\153\0\4\39\0\1\74\0\3\29\1\104\226\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0zzz\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\7\208\0\1\127\0\3\228\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\1\169\0\0\254\0\2\96\0\1\44\0\2\206\0\1\46\0\2\159\0\0\0\0\0\0\0\0\0\0\154\85\0\110\222\0\89\8\0\89\92\1\117\187\0\73\62\0\135\141\0\113\94\0\40\67\0\117\72\0\125\140\0\0\0\0\165\172\0\0\0\0\0\8\0\89\2\1\41\217\0\0\8\1\44\31\0\210\227\0\90\186\0\0\8\0\182\208\1\49\216\0\143\37\0\92\111\0\115\249\0\0\8\0\16\212\0\0\8\0\0\8\0\0\8\0\48\89\0\0\8\0\234\96\0\19\136\0\0\0\0\9\196\0\0\1\0\117\37\0\100\56\0\214\152\0\152\34\0\101\90\0\67\209\0\27\190\0\158\136\0\184\115\0\176\159\0\124\202\0\213\121\0\125\175\0\214\251\0\179\200\0\72\42\1\71\182\0\87\192\0\66\11\0\99\114\0\124\197\0\83\128zzzzzzzzzzzzzzz\0\105\53\0\123\225\1\97\53\0\134\146\0\106\185zzzzzz\0\0\1\0\0\0\0\81\233\0\98\172\0\101\201\0\0\0\0\239\66\0\102\235\0\121\53\1\89\148\0\120\146\0\174\15\0\69\225\0\105\48\0\163\225\0\0\0\0\124\192\0\0\125\0\0\112\0\0\100\0\0\100\0\0\112\0\0\125\0\0\0\0\177\192\0\136\50\1\0\83\0\68\155\0\86\17\0\103\170\0\0\25\1\92\23\0\0\20\0\175\76\0\1\244\0\1\244\0\64\65\0\96\194\0\97\33\0\170\73\0\100\61\0\100\159\0\57\254\1\156\98\0\99\88\0\249\74\0\239\54\0\102\228\1\2\242\0\0\0\0\86\175\0\48\212\1\102\102\0\86\29\0\114\238\0\65\142\0\65\207\1\74\82\0\173\188\0\249\159\0\100\59\0\67\19\1\80\156\0\101\93\0\169\147\0\34\84\0\68\85\0\120\182\0\159\178\0\106\93\0\40\43\0\0\12\0\0\30\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\143\81zzzzzzzzz\0\0\6\0\0\25zzzzzzzzz\0\2\94\0\3\246\0\0\0zzzzzzzzzzzzzzzzzzzzzzzz\0\0\150zzzzzzzzz\0\0\150\0\0\150\0\0\150\0\0\150\0\0\150\0\0\150\0\0\150\0\0\150\0\0\150\0\0\150\0\0\150\0\0\150\0\0\150\0\0\5\0\0\5\0\0\0\0\0\200\0\116\178\1\76\204\0\0\200\0\0\0\0\0\200\0\0\200\0\0\200zzzzzz\0\0\200\0\0\200\0\39\16\0\19\136\0\0\10\0\0\10\0\0\100\0\19\136zzz\0\29\76\0\29\76\0\29\76\0\29\76\0\19\136\0\19\136\0\19\136\0\29\76\0\29\76\0\29\76\0\29\76\0\0\0zzzzzzzzzzzzzzzzzzzzzzzzzzzzzz\0\85\33\0\154\126\0\134\146\0\120\169\0\156\252\0\139\42\0\0\0\0\0\0\0\0\0\0\126\243\0\72\241\0\61\0\0\91\212\0\128\198\0\68\195\0\86\70\0\69\72\0\2\155\0\69\206\0\68\13\0\68\78\0\118\76\0\118\76\0\118\76\0\19\136\0\130\14\0\104\106\0\183\12\0\41\213\1\95\222\0\65\144\0\98\185\0\99\27\0\99\125\0\66\146\1\78\35\0\234\201\1\50\94\1\51\126\1\52\167\1\53\207\0\235\63\0\236\31\0\121\44\0\237\223\1\177\111\0\87\192\0\161\71\0\89\234\0\41\213\0\41\213\0\123\100\0\66\16\0\82\227\0\154\46\1\78\26\0\67\19\1\164\195\0\84\108\0\177\183\0\217\217\0\204\255\0\0\0\0\105\254\0\132\244zzz\0\107\32\0\196\111\1\71\85\0\97\241\0\0\0\0\80\77\0\163\175zzzzzz\0\163\14\0\171\137\0\98\148\0\177\126\1\168\236\0\34\84\0\102\186\1\1\191\0\70\166\0\106\90\0\133\107\0\125\175\0\143\81\0\179\200\0\163\25\0\148\28\0\172\94\0\99\16\0\41\213\0\102\140zzzzzzzzz\0\0\0\0\0\0zzz\0\183\196\1\95\240\0\105\246\0\106\88\1\10\208\0\178\126\0\0\0zzz\0\108\59\0\214\251\0\202\208\0\135\183\0\85\33\0\154\126\0\85\196\0\39\16\1\175\250zzz\0\130\139zzzzzzzzz\0\105\243\0\0\0\0\177\215\0\132\170\0\233\13\1\161\183zzz\1\164\228\0\67\152\0\177\192\0\153\231\1\85\196\0\179\192\0\103\72\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\1\24\0\1\24\0\1\24\0\1\24\0\1\24\0\1\24\0\1\64zzz\0\0\0\0\0\0\0\0\0\0\102\35\0\102\130\0\128\157\1\80\20\0\163\175\0\242\185\0\34\84\1\102\102\0\179\213\0\195\231\0\131\28\1\73\13\1\156\231\0\99\119zzzzzzzzzzzzzzz\0\173\129\0\249\62\0\100\17\0\219\247\0\155\56\0\69\58\1\4\138\1\2\242\0\104\246\0\245\193\0\0\0\0\120\146\0\39\16\0\225\178\0\242\192\1\76\204\0\84\108\1\71\91\0\100\249\1\177\177\0\41\213\1\93\118\0\245\131\0\140\205\0\176\159\0\212\181\0\227\180\0\89\67\0\214\250\1\103\145\0\132\27\0\144\153\0\171\212\0\96\183\0\113\235\0\100\30zzzzzzzzz\0\0\0zzz\0\27\190zzzzzzzzzzzzzzzzzz\0\3\102\0\3\222\0\4\161\0\5\45\0\202\208\1\83\74\0\127\178zzz\1\134\160\0\195\80zzzzzz\1\85\204\0\146\124\0\105\48zzz\0\141\69zzz\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\244\36\0\237\110\0\9\196\0\97\168\1\86\248\0\103\69\1\36\248zzzzzz\0\126\40\1\193\150\0\239\19\0\96\0zzzzzzzzz\0\48\212\0\146\200\0\98\55\0\123\60\0\120\146\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0zzz\0\0\0\0\76\101\0\87\185\0\58\4\0\54\223\0\84\249\0\87\165\0\87\246\1\162\183\0\39\16\0\0\0\0\0\0\0\0\0zzz\0\0\0\1\2\242\1\2\242\1\2\242\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\129\110\0\129\231\0\104\79\0\0\2\0\183\230\0\184\143\0\0\3\0\159\92\0\3\102\0\3\222\0\0\2\0\0\3\0\183\0\0\170\153\0\68\128\0\68\195\0\69\5\0\0\0\0\58\152\0\143\132\0\82\119\0\14\166\0\25\100\0\65\110\0\104\158\0\84\1\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\3\232\0\5\220\0\9\196\0\9\196\0\9\196zzzzzz\0\0\0\0\40\67\0\40\67\0\0\0zzzzzz\0\0\0\0\0\0\0\0\0zzz\0\0\0zzzzzzzzz\0\39\16\0\0\0zzz\0\82\225\0\0\0zzzzzzzzzzzzzzz\0\0\0zzz\0\0\0\0\87\192\0\0\0zzzzzzzzzzzzzzz\0\0\134\0\0\169\0\0\203\0\0\77\0\0\0\0\0\48\0\0\60\0\0\72\0\0\158\0\0\149\0\1\193\0\0\240\0\1\1\0\1\78\0\0\193\0\0\193\0\1\166\0\0\243\0\0\244\0\1\220\0\1\222\0\1\20\0\1\21\0\3\108\0\0\0\0\179\241\0\121\53\0\155\138\0\94\48\0\104\111\0\87\87\0\158\177\0\191\31\0\70\162\0\224\144\0\173\32\0\149\233\0\124\217\0\100\64\0\175\197\0\151\133\0\126\190\0\101\196\1\76\108\0\133\119\0\200\241\0\86\29\1\175\239\1\90\209\0\39\16\0\139\187\0\161\222\0\97\249\0\98\88\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\168\245\0\237\110\0\170\58\0\239\48\0\128\157\0\180\97\0\0\0zzz\1\101\32\0\214\251\0\143\222\0\134\146\0\81\241\0\148\18\1\74\82\0\163\225\0\133\33\0\200\118\0\125\192\0\176\98\1\166\90\0\39\16\0\131\15\0\183\205\1\96\10\1\71\85\0\212\186\0\142\84\0\142\214\0\215\4\0\143\215\0\87\192zzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzz\0\106\90\0\106\188\0\107\30\0\134\92\0\143\211\1\195\12\0\87\192\0\123\91\0\101\204\1\84\153\0\171\212\0\120\146\0\86\29\0\0\0\0\242\210\1\92\40\0\174\183\0\214\251\0\211\41\1\97\53\0\88\158\0\106\183\0\58\152\0\78\32\0\78\32\0\58\152\0\39\16\0\152\28\0\58\152\0\58\152\0\102\138\0\117\48\0\117\48\0\58\152\0\39\16zzz\0\0\75\0\183\187\1\7\237zzz\0\39\16\0\0\0\0\9\196\0\58\152zzzzzzzzzzzz\0\101\196zzzzzzzzzzzz\0\103\170zzz\0\1\147\0\69\221zzz\0\147\156zzzzzzzzzzzz\1\76\221zzzzzzzzz\1\81\234\0\217\20\0\68\23\0\179\12zzzzzz\0\34\84\1\99\219\0\27\190\0\126\40\1\193\150\0\0\0\0\57\254\0\98\183\0\0\0\0\0\0zzzzzzzzzzzzzzzzzz\0\244\166\0\140\78\0\132\4\0\132\126\1\187\48\0\142\84\0\40\43\0\161\251\1\103\154zzz\0\163\223\0\123\94\0\148\157\0\173\184zzzzzzzzz\0\0\0zzzzzzzzzzzzzzzzzzzzzzzzzzzzzz\0\0\0\0\0\0\1\153\152zzzzzz\0\39\16\0\102\140\0\102\238\0\103\80\0\103\177\0\122\26zzzzzzzzzzzzzzzzzz\0\0\0zzz\0\161\239zzz\0\251\155\0\86\29\0\0\0\0\0\0\0\119\221\0\205\20\1\87\18\1\174\110\0\163\175zzz\0\87\7\1\6\5\0\87\168\0\1\24\1\97\45\0\197\120zzz\0\232\42zzzzzz\0\100\162\0\214\251\0\0\9zzzzzzzzz\0\86\29\0\103\72\0\129\148\0\104\11\1\92\14zzz\0\39\16\0\154\46\0\2\238\0\3\232zzzzzzzzz\1\161\90\1\219\123\2\11\88\2\15\152\2\89\13\2\149\151\1\170\204\1\230\51\2\37\79\2\41\171\2\118\150\2\181\251\1\191\168\1\253\224\1\251\149\1\255\196\2\71\22\2\129\228zzzzzzzzzzzzzzzzzzzzzzzzzzz\0\0\175\0\117\197\0\141\209zzz\0\0\0zzz\0\19\136\0\19\136\0\19\136\0\19\136\0\19\136\0\19\136\0\19\136\0\19\136\0\19\136\0\19\136\0\19\136\0\19\136\0\19\136\0\0\0zzzzzzzzzzzzzzz\0\95\139zzzzzz\0\0\0zzz\0\0\0\1\41\203\1\93\76\1\142\172\0\1\24\0\0\0\0\0\0\0\0\0zzz\0\87\192\0\110\19\0\133\40\0\154\237\0\51\202\0\64\248\0\72\183\0\85\165\0\0\0\0\0\0\0\0\25\0\159\61\0\136\54\1\85\205\0\161\3\0\114\200\0\92\39\0\92\126\1\247\94\0\235\96\0\93\128\0\165\41zzz\0\109\180\0\88\26\1\81\171\0\133\44\0\156\214\0\134\45\0\134\175\0\112\169\1\196\76\0\136\50\1\199\176\3\25\51zzzzzz\1\100\24\0\139\56\1\89\35\0\104\185\0\108\30\0\111\130\0\114\231\0\118\76\0\121\178\0\125\23\0\128\123\0\131\224\0\135\69\0\138\170\0\142\16\0\145\116\0\148\217\0\171\124\0\0\0zzzzzz\0\0\0zzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzz\0\93\224\0\165\210\0\141\209\0\142\84\0\249\125\0\143\88zzz\1\179\76\2\34\62zzzzzzzzzzzz\0\183\2\1\100\24zzz\1\90\244\0\139\70\0\209\173\1\211\165\0\140\205\0\141\76\2\78\220\1\99\201\0\215\42\1\100\24\0\239\182\0\144\85\0\228\239\0\180\75\0\9\196\0\48\212\1\63\11\0\0\0\1\19\128\0\230\110\0\231\66\0\185\175\3\25\51\2\72\114zzz\1\45\104zzz\0\248\135\1\145\121\0\200\171\1\29\55\0\134\48zzzzzzzzzzzzzzzzzzzzzzzz\1\67\186zzzzzzzzzzzzzzzzzzzzzzzzzzz\0\201\100\0\58\152\2\49\49zzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzz\0\164\138\0\0\0\0\235\96\0\0\0zzz\0\89\113\0\134\168\0\90\28\0\113\16\0\136\47\1\199\152\2\74\203\0\143\81\0\141\217\0\235\96\1\77\81\0\143\92zzzzzz\0\229\2zzzzzz\0\165\199\0\122\18\0\200\118\0\134\34\1\80\156\1\89\35\0\235\96\0\0\0zzz\0\0\0zzzzzzzzz\0\0\0zzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzz\0\134\179\1\100\24\3\25\51\1\198\10\0\235\96\1\145\121\0\172\39\0\162\49\3\25\51\1\22\127\0\0\0\0\0\0\0\0\0\0\0\0\1\7\75\0\220\66\0\176\227\0\232\156\0\133\171\1\145\121\0\202\237\0\236\35\1\60\155\1\197\254\0\113\236\1\18\103\0\172\35\0\235\96\1\39\243\0\178\148\0\143\95\1\187\234zzzzzzzzzzzz\1\145\121\0\235\96\0\144\55\0\144\195\0\145\76\1\230\40\1\231\253zzz\1\235\152\1\250\135\1\125\68\2\125\188\2\127\245\1\13\58\0\128\232\0\155\60\0\140\236\0\165\254\0\94\174\3\25\51\2\84\67\1\103\33zzz\1\100\24zzzzzz\0\9\196\1\100\24\0\235\96\0\235\96\0\235\96\0\235\96\2\127\229\0\180\214\0\193\87\0\155\52\0\0\0\0\94\78\2\79\161\0\213\207\1\220\246\0\184\117\0\148\26zzzzzzzzzzzzzzz\0\228\20zzzzzzzzzzzzzzz\0\0\0zzzzzzzzzzzzzzz\1\145\121\1\100\24\0\173\193\1\61\23\0\143\81\0\149\184\0\125\57zzz\1\100\24zzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzz\0\0\0\0\0\0zzz\0\0\0\0\0\0zzzzzz\0\0\0\0\0\0zzzzzzzzzzzzzzz\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0zzzzzz\0\0\0\0\0\0zzzzzzzzzzzzzzzzzzzzz\0\0\0zzz\0\0\0zzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzz\0\0\0zzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzz\0\0\0zzzzzz\0\0\0zzzzzzzzz\0\0\0zzzzzzzzzzzzzzzzzz\0\9\46zzzzzzzzzzzzzzzzzz\0\0\3zzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzz\0\0\7\0\0\18\0\0\50\0\0\200zzzzzz\0\0\200\0\0\200zzzzzzzzzzzzzzzzzzzzzzzzzzzzzz\0\0\0zzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzz\0\0\0zzzzzzzzzzzzzzzzzzzzzzzzzzzzzz\0\0\0zzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzz\0\0\0\0\226\218\1\28\146\0\0\1\0\0\1\0\0\75zzz\0\0\0\1\12\204\0\179\213\0\130\154\0\97\168\3\3\152\0\0\0\6\22\186\1\234\115\3\3\152\6\83\80\6\89\74\3\3\152\0\243\200\0\27\190\0\140\78\1\184\13\0\176\168\0\171\212\1\188\199\0\125\178\0\161\63\0\161\210\1\152\23\1\153\174\0\98\177\0\101\206\0\170\80\0\170\243\0\97\168\0\97\168\0\171\212\0\171\212\0\130\146\0\131\12zzzzzz\4\221\129\4\225\252\6\136\160\0\0\0\6\148\107\6\35\125\0\5\220\0\6\214\0\32\183\0\35\165zzzzzzzzzzzz\6\88\247\1\177\155\1\179\50\0\171\212\0\171\212\3\3\152\8\27\163\3\3\152\0\171\212\0\99\130\6\29\90\4\26\185\3\3\152\0\0\0\0\171\212\0\101\201\3\3\152\6\70\223\1\81\7\0\241\4\1\89\148\3\208\144\1\36\248\0\0\0\3\208\144\3\208\144\3\208\144\3\208\144\3\208\144\3\208\144\3\208\144\3\208\144\3\208\144\3\208\144\3\208\144\0\14\74\0\0\150\0\2\88\0\39\16\0\78\32\0\0\0\0\0\0zzz\0\0\0\0\1\244\0\0\0\0\38\226\0\117\48\0\117\48\0\156\64\0\156\64zzz\0\117\48\0\117\48\0\117\48zzzzzzzzzzzzzzz\0\0\0zzzzzzzzzzzzzzzzzz\0\78\32zzzzzzzzzzzz\0\0\0\0\155\216\0\232\218\0\89\51\0\89\132\0\134\195\0\135\64\0\135\189\0\205\59\0\113\235\0\114\84\0\172\22\0\92\26\0\83\158\0\125\235\0\148\77\0\152\251\0\228\150\0\87\146\0\0\0\0\88\54\0\132\207\0\133\76zzz\0\134\67\0\203\6\0\112\176\0\113\24\0\170\65zzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzz\0\0\10\0\0\0zzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzz\0\0\0\0\0\0\0\45\145\0\131\133\0\146\8\0\58\161\0\162\177\0\63\249\0\120\98\0\96\167\0\27\190\0\27\190\0\27\190\0\27\190zzz\0\147\234\0\128\21\0\71\27\0\57\26\1\161\172\0\134\146zzz\0\126\184\0\163\225\0\163\225\0\163\225\0\163\225\0\218\6zzz\0\188\52\0\157\102\0\126\94\0\215\240\0\140\8\0\168\178\0\112\230\1\166\252\1\89\35\1\152\181\1\89\35\1\74\214\1\62\102\0\235\96\1\171\168\0\134\70\2\26\108\2\28\95\0\113\30\0\0\0\2\34\45\1\182\128zzz\1\185\149\1\134\160\0\97\168zzzzzzzzzzzzzzzzzz\1\16\34\1\17\35zzzzzzzzzzzz\1\91\156\0\209\81zzz\1\25\16zzzzzzzzzzzzzzzzzzzzzzzzzzzzzz\1\16\21\0\0\0\0\1\24\0\1\144\0\1\64zzzzzz\0\118\76\1\28\92\0\68\130\0\1\64\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0zzz\0\1\24\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\200\0\0\200\0\0\0zzzzzz\0\0\0\0\0\0\0\0\0\0\0\0zzz\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0zzz\0\0\0zzz\0\0\0zzz\0\1\144\0\1\144\0\1\144\0\1\144\0\1\144\0\1\144\0\1\24\0\0\0\1\16\84\1\17\99\1\46\250zzzzzzzzz\0\0\0\0\155\70zzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzz\0\0\0zzzzzzzzz\0\0\0zzzzzzzzz\0\58\152\0\0\0\0\58\152\0\58\152\0\58\152\0\58\152\0\206\45\0\103\118\0\156\113\0\208\105\0\157\140\0\97\136\0\163\44\0\81\229\0\123\76\0\165\5\0\124\59\0\83\33zzz\0\157\255\0\105\184\0\159\39\0\159\189\0\106\225\0\107\69\0\193\198\0\129\166\0\181\52\0\121\69\0\183\102zzz\0\245\83\1\21\244\0\134\48\0\124\14\0\3\168\1\26\33\0\136\54\0\136\184\0\237\192\0\114\197\0\115\49\0\240\94\0\119\19\0\119\125\0\19\136\0\19\136\0\19\136\0\19\136\0\19\136\0\78\32\0\78\32\0\156\64\0\156\64\0\0\0\0\0\0\0\4\226\0\117\48\0\0\0\0\0\0\0\0\0\0\0\0zzzzzz\0\4\226\0\7\208\1\134\160\0\39\16\0\0\0\0\0\0\0\3\102\0\3\222\0\5\45\0\4\161\0\0\0\0\0\0\0\4\161\0\5\45\0\3\102\0\3\222\0\4\161\0\5\45\0\0\0\0\0\0\0\4\161\0\5\45zzz\0\2\158\0\2\158\0\2\158\0\0\55\0\0\80\0\2\158\0\2\158\0\0\87\0\3\222\0\3\102\0\4\161\0\5\45zzz\0\5\182\0\0\150\0\0\0zzz\0\0\0zzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzz\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0zzzzzz\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\48\212\0\0\0\0\0\0\0\0\0\0\0\0\0\48\212\0\0\0\0\0\0\0\48\212\0\48\212\0\48\212\0\48\212\0\0\0\0\78\32\0\0\0\0\0\0\0\0\0\0\0\0\0\78\32\0\0\0\0\78\32\0\0\0\0\0\0\0\0\0\0\0\0\0\78\32\0\0\0\0\78\32\0\0\0\0\78\32\0\0\0\0\0\0\0\0\0\0\0\0\0\78\32zzz\0\78\32\0\78\32\0\78\32\0\78\32\0\78\32\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\117\48\0\156\64\0\0\0\0\0\0\0\117\48\0\156\64\0\58\152\0\58\152\0\117\48\0\117\48\0\234\96\0\234\96\0\234\96\0\234\96\0\234\96\0\234\96\0\234\96\0\234\96\0\234\96\0\234\96\0\234\96\0\234\96zzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzz\0\0\0\0\0\0zzz\0\0\0\0\0\0\0\195\80\0\195\80\0\195\80\0\195\80\0\195\80\0\195\80\0\195\80\0\195\80\0\195\80\0\195\80\0\195\80\0\195\80\0\195\80\0\195\80\0\195\80zzzzzzzzz\0\57\114\0\72\14\0\130\42\0\203\50\0\135\69\0\135\69\0\77\184zzz\0\195\200\0\126\213\0\155\48\0\140\51\0\224\208\0\70\2\0\84\82\0\147\209\1\27\24\0\170\121\0\199\154\0\0\0\0\150\122\0\86\117\0\138\170\0\138\170zzzzzzzzzzzz\0\4\161\0\5\45zzz\0\0\0zzz\0\105\1\0\0\0\0\84\156\0\99\163\0\85\58\0\0\0\0\107\75\0\86\36\0\101\111\0\99\218\0\109\95\0\109\95\0\0\0zzzzzz\0\0\0\0\0\0\0\0\0zzz\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\4\226\0\97\168\0\4\226\0\4\226zzzzzz\0\0\0\0\248\188\0\199\195\0\250\172\0\251\158zzz\0\208\101\0\209\43\0\157\113\0\158\6\0\135\87\0\102\104\0\136\82\0\235\96\1\54\144\0\235\96\3\25\51\2\33\168\0\157\130\0\87\90\0\65\191\0\81\206\0\102\165\0\103\6\0\77\143\0\124\143\0\125\6\0\94\27\0\146\238\0\147\121\0\110\202\0\106\26\0\106\125\0\80\40\0\128\180\0\129\43\0\97\58\0\140\254\0\141\133\0\106\88\0\122\222\2\2\144\1\131\88\1\91\237\0\225\130zzz\0\4\226\0\81\8\0\67\198\0\4\226\0\4\226\0\97\168\0\96\212\0\4\226\0\0\0\1\246\221\0\0\0\0\59\186\0\171\171\0\122\100\0\131\144\0\158\117\0\138\233\0\61\26\0\73\151\0\200\69\0\150\164\0\151\52\0\182\25\0\156\114\0\209\88\0\118\34\0\111\34\0\208\48\2\114\19\1\121\27\0\253\144\0\121\113\1\36\150\0\146\214\0\105\78\2\161\238\0\159\41\0\159\191\1\64\179\0\165\65\2\192\238\0\166\113\1\22\103\2\58\5\0\235\96\0\198\23\0\105\208\0\56\162\0\77\30\0\135\58\0\68\4\0\123\115\0\143\166\0\142\16\1\81\171\1\89\35\1\155\179\1\157\55\1\158\186\1\160\62\1\78\44\0\163\132\1\145\121\0\172\150\1\89\35\1\145\121\0\199\191\0\105\193\2\113\225\1\145\121\0\145\36\0\149\180\0\142\16\0\150\211\1\8\107\0\235\96\0\127\19\0\153\13\1\12\80\0\180\225\1\14\63\0\182\50\0\155\211\0\104\66\0\156\243\0\105\1\0\197\145\0\122\226\0\185\6\0\123\209\0\224\175\0\149\176\0\226\96\0\150\207\0\151\91\1\9\89\3\25\51\0\131\28\0\153\149\0\235\96\1\14\56\1\54\128\0\194\195\0\193\159\0\171\11\1\252\182\1\89\35\0\184\78\0\235\96\0\123\203\0\149\28\0\99\200\1\94\130\0\227\44\0\131\28\0\151\230\0\87\119\0\75\63\0\125\222\0\126\84\0\130\17\0\201\141\0\241\17\0\174\26\1\35\67\0\0\0\0\146\222\1\128\97\1\2\118\2\4\104\0\235\96\1\5\96\0\226\78\1\120\156\1\46\104\1\123\96\1\56\165\2\170\85\0\157\146\0\197\165\1\140\96zzz\1\246\207\0\170\85\0\219\145\0\146\75\1\81\171\0\147\102\0\246\153\1\115\97\2\31\45\0\241\151\1\165\109\0\138\54\0\221\236\2\55\250\0\235\96\0\235\96\0\211\9\0\198\204zzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzz\0\0\0zzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzz\0\0\0zzzzzzzzzzzzzzzzzzzzz\0\0\150zzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzz\0\0\0zzz\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\78\32zzzzzzzzzzzzzzzzzzzzz\0\0\0zzz\0\0\0zzz\0\0\0zzz\0\0\0\0\0\0\0\0\0zzzzzz\0\0\0\0\0\1\0\0\0zzzzzzzzz\0\0\0\0\0\0zzzzzzzzzzzzzzzzzzzzzzzz\0\103\53zzzzzzzzzzzzzzz\0\84\90\0\99\83\0\212\97\0\135\69zzzzzzzzzzzzzzzzzzzzzzzz\0\195\80\0\195\80\0\195\80\0\195\80\0\195\80\0\195\80\0\195\80\0\195\80\0\195\80\0\195\80\0\195\80\0\195\80\0\195\80\0\195\80\0\195\80zzz\0\201\228\0\56\191\0\100\61\0\171\126\0\132\55\0\165\219\0\233\12zzzzzz\0\0\0\0\104\171\0\126\156\0\98\244\0\53\192\0\101\43\0\95\83\0\106\18\0\99\207\0\187\2\0\82\119\0\137\245\0\125\42\0\81\87\0\142\153\0\135\69\1\24\253\1\26\4\0\212\72\0\117\48\0\117\48\0\117\48\0\117\48\0\80\79\0\67\46\0\121\238\0\0\0\0\0\0\0\0\0\0\136\234\0\144\3\0\0\0\0\84\108\0\81\85\0\122\251\0\191\40\0\124\94\0\204\236\0\239\230\0\163\175\0\234\96\0\234\96\0\234\96\0\234\96\0\234\96\0\234\96\0\234\96\0\234\96zzz\0\0\0zzzzzzzzzzzzzzzzzzzzzzzzzzzzzz\0\234\96\0\234\96\0\234\96\0\234\96\0\0\0zzzzzz\0\139\48\0\125\187\0\101\94\0\57\206\0\72\133\0\131\148\0\153\23\0\109\244\0\88\71\0\154\186\0\88\230\0\142\16\0\142\16\0\67\193\0\81\159zzzzzzzzzzzz\0\0\0zzzzzzzzzzzz\0\102\22zzzzzz\0\1\144zzz\0\1\144\0\1\144\0\1\144\0\0\0\0\1\144\0\99\212\0\160\79\1\12\47\0\27\174\0\27\174\0\0\0\0\98\204\0\123\243\0\99\131\0\117\48\0\83\136\0\125\193\0\152\28\0\118\226\0\0\0\0\27\174\0\27\174\0\138\49\0\97\168\0\145\238\0\55\231\0\53\110\0\67\10\0\0\0\0\141\140\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\1\82\234\1\84\59\1\85\139\0\195\221\0\80\158\0\67\112\0\95\80\0\99\108\0\93\173\0\0\0zzz\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0zzz\0\0\0zzzzzzzzz\0\0\0\0\2\238\0\2\165\0\9\238\0\32\183\0\0\0\0\0\0zzzzzz\0\0\0zzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzz\0\0\0\0\0\0\0\0\0zzz\0\78\32\0\48\212\0\0\0\1\25\103\1\25\103\1\25\103\1\25\103\1\25\103zzz\0\0\0zzzzzz\0\0\0\0\0\0\0\1\64\0\1\24\0\0\0\0\0\0\0\0\0zzz\0\66\232\0\0\0\0\0\0\0\4\161\0\5\45zzz\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\4\161\0\5\45\0\4\161\0\5\45zzzzzzzzz\0\0\0\0\39\16\0\0\0\0\0\0zzzzzzzzzzzzzzz\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0zzzzzzzzzzzzzzz\0\0\0zzz\0\4\234\0\2\119\0\1\119\0\0\82\0\0\27\0\0\55\0\4\161\0\5\45\0\4\161\0\5\45\0\79\137\0\79\214\0\53\109\0\112\159\0\113\11\0\85\25\0\55\149\0\54\106\1\102\124\0\216\59\0\0\0\0\0\0\0\0\0zzz\0\0\0zzzzzz\0\170\145\0\171\51\1\44\189\1\2\193\0\216\113\1\48\33\0\0\0\0\218\221zzzzzz\1\16\138\0\19\136\0\182\254\0\19\136\0\0\0\0\117\48\0\117\48\0\117\48\0\117\48\0\117\48\0\117\48\0\117\48\0\117\48\0\117\48\0\117\48\0\117\48\0\0\0\0\117\48\0\117\48\0\117\48zzz\0\0\0\0\117\48\0\117\48\0\117\48\0\117\48zzz\0\21\159\0\14\49\0\68\137\0\137\171\0\117\48\0\117\48\0\117\48\0\117\48\0\0\0\0\0\0\0\0\0zzz\0\0\0\0\117\48\0\117\48\0\117\48\0\117\48\0\117\48\0\117\48\0\117\48\0\117\48\0\117\48\0\117\48\0\117\48\0\117\48\0\117\48\0\117\48\0\0\0zzz\0\72\60\0\137\171\0\21\159\0\117\48\0\117\48\0\117\48\0\117\48\0\117\48\0\117\48\0\117\48\0\117\48\0\117\48zzz\0\1\24\0\0\6\0\0\6\0\0\0zzz\0\5\53zzzzzzzzz\1\100\24\1\25\103\1\25\103\0\97\168\0\97\168\0\0\0\0\0\0\1\100\24\1\100\24zzz\1\100\24\0\0\0zzzzzz\0\97\168\0\97\168\0\97\168\0\0\0\0\97\168zzzzzzzzz\0\229\254\0\132\43\0\132\173\0\110\253zzzzzz\0\0\0\0\0\0zzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzz\0\0\0\0\0\0\0\0\0\1\25\103\1\25\103\1\25\103\1\89\35\0\235\96\0\92\140\0\0\0\0\0\0\0\0\0zzz\0\94\60\0\177\83\0\94\231\0\119\13\0\143\95\0\168\210zzzzzz\0\164\138\0\199\24\0\238\9\1\108\197\0\114\106\0\137\206\0\162\70zzzzzzzzzzzzzzzzzzzzzzzz\0\58\152\0\0\0\0\0\0\0\0\0zzzzzz\0\0\0zzzzzz\0\179\215zzz\0\122\234\0\104\24\0\131\28\0\196\111\0\0\0zzzzzz\0\0\0\0\0\0zzz\0\0\0\0\0\0zzz\1\25\103zzz\2\75\242\1\216\30\1\99\96\0\95\30\1\145\121\0\191\166\0\216\96\0\144\199\0\242\46\0\254\186\2\53\250\1\198\139\0\182\133\0\137\107\0\235\96\0\173\20\0\235\96\1\23\3\0\244\152\0\164\237zzzzzz\0\117\48\0\136\184\0\97\168\0\117\48\0\136\184\0\113\180\0\147\242\0\115\236\0\131\143\0\255\53\0\107\91\0\199\51zzz\0\81\115\0\80\195\0\80\19\0\0\0zzzzzzzzzzzz\0\98\233zzzzzzzzzzzzzzz\0\50\206zzzzzzzzz\0\84\215zzz\0\46\75zzzzzzzzz\0\78\232zzzzzz\0\39\116zzzzzz\1\98\167\1\99\228\1\190\116\0\0\0zzzzzz\0\0\0zzz\0\0\0\0\0\0zzzzzzzzzzzz\0\0\0\0\0\0zzz\0\4\40\0\0\0\0\0\0zzzzzz\0\0\200\0\0\200\0\0\175\0\4\161\0\5\45\0\4\161\0\5\45\0\0\5\0\0\1zzzzzz\0\5\45\0\4\161zzz\1\36\248zzz\0\144\173\0\117\48zzzzzzzzz\7\165\24\0\97\234\1\138\104\0\58\152\0\192\230\0\203\157\0\136\64\0\66\192\0\68\22\0\137\195zzz\0\171\212\0\58\152\0\78\32\0\97\168\0\0\0\3\208\144zzz\0\0\0zzzzzzzzzzzzzzzzzz\0\213\129\0\112\72\0\106\252zzz\0\246\9\0\162\83\0\201\103\0\202\32\0\144\16\0\173\121\2\13\1\1\20\44zzz\0\132\197\0\159\239\0\107\8\0\107\110\3\25\51\0\244\164\2\31\73zzzzzz\0\0\0\1\40\155\0\142\2\1\1\172\2\60\30\1\111\119\2\208\48\0\173\117\0\157\124\0\197\154\1\61\99\0\106\52\1\85\42zzz\0\201\105\0\250\79\1\77\126\0\146\166\0\111\248\1\137\84\0\198\130\1\26\247\1\27\253\1\86\3\2\60\2\2\252\154\1\173\179\1\175\58\1\23\159\1\165\16\1\82\40\2\214\183\1\117\111\2\73\171\3\25\51\0\236\2\0\236\219\0\139\112\0\197\12\0\224\183\0\211\112\2\53\224\0\170\96\0\0\0\0\0\0\0\88\147\0\59\66\0\62\29\0\95\233\0\81\143\0\55\234\0\109\142\0\109\247\0\56\138\0\85\29\0\65\159\0\164\169\0\0\0\0\0\0\0\72\60\0\72\127\0\106\137\0\126\50\0\68\13\0\133\94\0\68\148\0\79\79\0\79\157\0\138\184\0\101\240\0\163\179\0\193\246\0\0\0\0\82\196\0\98\15\0\128\180\0\129\45\0\0\0\0\126\114\0\86\173\0\178\127\0\122\19\0\189\203\0\185\250\0\143\44\0\111\59\0\0\0\0\144\208\0\0\0\0\95\170\0\113\90\0\147\0zzzzzz\0\85\25zzz\0\159\156zzzzzzzzzzzzzzzzzzzzz\0\142\16zzzzzz\0\203\192zzz\0\173\236zzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzz\1\56\78\0\235\35zzz\1\59\240zzzzzzzzzzzzzzzzzz\1\160\72\1\161\204zzzzzz\1\81\214zzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzz\0\96\1zzzzzzzzzzzzzzz\0\98\28zzz\0\98\207zzzzzz\1\167\56zzz\1\140\80zzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzz\1\149\154zzzzzzzzzzzzzzzzzzzzzzzz\1\55\49\0\234\77\1\57\157\0\162\83\0\162\83\0\162\83\0\162\83\0\162\83\0\39\16\0\15\160\0\0\0\0\0\0\0\0\0zzzzzzzzz\0\0\0zzz\0\195\80\0\195\80\0\195\80\0\195\80\0\195\80\0\195\80\0\195\80\0\195\80\0\195\80\0\195\80\0\195\80\0\195\80\0\195\80\0\195\80\0\195\80\0\100\165\0\176\105\0\152\10\0\152\150zzz\0\128\13\0\128\129\0\54\1\0\101\164\0\171\212\0\81\241\0\143\174\0\117\48\0\117\48\0\117\48zzzzzzzzzzzzzzzzzz\0\131\10\0\67\165\0\162\234zzzzzzzzz\0\62\133zzz\0\100\8\1\67\189zzz\0\188\79\0\95\11\0\77\90\1\15\252\0\81\229zzz\1\1\217\0\85\72zzz\0\99\155zzz\0\112\164\0\108\134\0\53\31\0\53\31\0\96\59\0\196\176\1\26\11\0\2\238\0\227\41\0\195\111\0\163\115\0\131\63\0\172\145\0\149\103\0\124\100\0\99\224\0\111\195\0\89\2\0\74\44\0\59\155\0\0\0\0\171\178zzz\0\145\98\0\0\0\0\121\39\0\123\146\0\96\236\0\68\88\0\97\132\0\79\175\0\151\119\0\70\8\0\98\247\0\53\31\0\131\10\0\123\139\0\93\199\0\75\6\1\96\255\0\127\21\0\96\59\0\82\4\0\105\111\0\68\88\0\54\173\1\25\40\0\147\99\0\108\130\0\34\84\0\89\2\0\74\44\0\59\87\0\184\234\0\97\4\0\101\180\0\155\138\0\215\242\0\0\0\0\0\0\0\0\0\0\0\0\0\222\7\0\191\4\0\159\201\0\128\80\0\163\157\0\149\254\0\124\229\0\100\72\0\175\202\0\140\130\0\117\23\0\93\172\0\104\112\0\142\48\0\89\2\0\73\233\0\59\87\0\144\118\0\94\62\0\79\175\0\66\103\0\90\199\0\53\31\0\139\47\0\120\15\1\59\77\0\99\155\0\85\74\0\159\92\0\143\81zzz\0\193\73zzz\0\197\95\0\154\181\0\128\236zzz\0\103\35\0\139\237\0\121\36\0\96\177\0\81\1zzzzzz\0\0\0\0\84\89\0\94\234\0\2\146\0\0\0\0\214\251\0\0\0zzzzzzzzz\0\2\11\0\1\164\0\0\0\0\0\0\0\0\0\0\4\42\0\4\46\0\3\37zzz\0\93\225\0\0\0\0\0\0\0\163\175\0\159\138\0\163\175zzzzzz\0\91\87\0\115\147\0\121\201\0\62\27\0\112\134\0\160\108\0\187\88\0\199\213\0\117\23\1\134\76\0\41\213\1\164\79\0\204\206\0\96\0\0\157\171\0\160\1\0\0\0\0\128\1\0\229\144\1\155\135zzz\0\0\0\0\0\0\0\250\180\1\79\131\1\80\200\0\131\28zzz\1\153\185\0\0\0zzz\0\0\0\0\83\198\0\70\16\0\127\32\0\99\90zzzzzz\1\225\192\1\52\177\1\15\216\1\194\0\1\233\44\1\38\152zzz\0\0\0\0\235\96\0\0\0\0\246\142\0\110\100\0\186\67\1\159\94\1\160\221\0\156\226\2\12\196\0\210\167\6\155\53\0\24\106\1\89\35\0\235\96\0\155\82\0\78\84\1\145\245\0\161\97zzzzzzzzzzzz\0\0\0zzzzzzzzz\0\0\0\0\0\0\0\39\16\0\39\16\0\39\16\0\39\16\0\117\48\0\58\152zzz\0\58\152\0\117\48zzz\1\65\132zzzzzz\1\69\19\0\244\53\1\71\106\1\33\168\0\217\156zzzzzzzzzzzzzzzzzzzzzzzz\0\163\175\0\163\175\0\163\175\0\163\175zzz\0\0\0zzzzzz\0\0\0\0\0\0\0\234\96\0\234\96\0\234\96\0\234\96\0\234\96\0\234\96zzzzzz\0\235\96\0\235\96zzz\0\117\48\0\117\48zzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzz\1\70\112\0\171\253\0\197\93\1\143\129\0\50\93\0\94\202\0\114\175\0\89\163\0\255\153\1\7\92\0\198\59\0\53\12\0\66\140\0\120\191\0\94\91\0\80\180\0\61\15\0\73\142\0\128\247\0\101\112\0\127\73\0\117\244\0\137\221zzz\0\77\136\0\66\154\0\80\53\0\140\156\0\107\186\0\135\37\0\122\15\0\95\210\1\17\49\1\18\36\1\19\30zzzzzzzzz\0\50\132\0\95\22\0\76\93\0\92\101\0\81\18\0\101\183\0\163\88\0\191\64\0\122\156\0\69\235\0\105\64zzz\0\88\88\0\106\101\0\0\0\0\0\0\0\0\0\0\0\0\0\97\170\0\125\246\0\75\220\0\89\88\0\196\28\1\6\117\1\7\111\0\51\132\0\96\242\0\77\216\0\91\172\0\52\69\0\65\147\0\137\242\0\79\67\0\106\13\0\133\10\0\111\167\0\130\131zzz\0\204\156\0\205\98\1\63\107\0\162\83\0\162\83zzz\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\1\134\160\0\0\0\0\0\0zzz\0\0\0\0\0\0\0\0\0\0\104\223\0\78\244\0\51\130\0\132\148\0\64\222\0\65\29\0\160\229\0\80\189\0\79\1zzzzzz\0\196\50\0\147\100\0\144\52zzz\0\162\83zzzzzz\0\162\83\0\162\83\0\162\83zzzzzz\0\53\6\0\99\204\0\120\190\0\94\95zzzzzz\0\81\99\0\102\23\0\81\247\0\96\132\1\26\58\1\98\9\1\65\111\0\156\47\0\156\198\0\94\109\0\142\47\0\222\7\0\222\218zzz\0\0\0\0\104\35\0\104\130\0\139\218\0\70\46\0\140\223\0\100\255\0\70\240\0\71\49\0\133\242\0\134\108\0\179\222\0\81\167\0\163\236\0\117\145\0\82\153\0\85\49\0\153\231\0\155\41\0\206\186\0\103\191\0\208\60\0\149\251\0\104\225\0\105\64\0\184\129\0\185\44\0\248\65\0\125\70\0\250\3\0\178\234\0\126\157\0\118\38zzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzz\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0zzzzzz\0\0\0\0\0\0zzz\0\0\0\0\0\0zzzzzz\0\32\30zzz\0\32\30zzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzz\0\0\0zzzzzzzzzzzzzzzzzzzzzzzz\0\0\0zzzzzz\0\87\182\0\82\138\0\66\73\0\62\1\0\58\244zzzzzzzzzzzz\0\19\136\0\0\0zzz\0\0\0\0\0\200\0\0\200\0\0\150\0\0\150\0\29\76\0\29\76\0\19\136\0\19\136zzz\0\11\184\0\39\16\0\39\16\0\39\16\0\54\63\0\68\15\0\163\238\0\191\244\0\82\144\0\103\146\0\166\81\0\97\236\0\155\138\0\155\138\0\155\138\0\155\138\0\155\138\0\155\138zzzzzz\0\135\69\1\79\68\1\80\132zzz\1\15\48zzzzzzzzzzzzzzzzzzzzz\0\81\164\0\95\35\0\114\154\0\89\253\0\111\130zzz\0\106\1\0\132\254\0\160\49\0\187\151zzzzzz\0\243\241\0\188\193\0\50\133\0\119\110\0\119\110\0\125\23\0\125\23\0\125\23\0\125\23\0\125\23\0\241\132\0\155\41\0\0\25zzz\0\0\25\0\0\0zzzzzzzzzzzz\0\0\0zzz\1\100\7\0\235\96\0\163\225\0\163\225\0\163\225zzzzzzzzzzzzzzzzzz\1\23\214zzz\1\25\245\1\27\5\0\19\136\0\186\104\0\187\21zzz\0\154\240\0\181\104\0\78\6\0\0\0\0\72\44zzz\0\46\114\0\0\0zzz\0\9\196\0\9\196zzz\0\9\196\0\9\196\0\9\196\0\9\196\0\9\196\0\9\196\0\153\207\0\102\233\0\96\211\1\67\233\0\107\247\0\84\96\0\60\36\0\65\133\0\135\69\0\162\83\0\80\46\0\67\17\0\174\72zzz\0\75\63\0\94\101\0\101\15zzzzzz\0\0\0\0\0\0\0\0\0\0\9\196\0\0\0\0\0\0zzzzzzzzzzzzzzzzzzzzzzzzzzz\1\65\249\0\116\219\0\135\69\0\136\119\0\128\123\1\6\78\0\0\0\0\125\23\0\0\0zzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzz\0\57\158zzzzzzzzzzzz\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0zzzzzzzzzzzz\1\134\160\1\134\160\1\134\160\1\134\160\0\9\196\0\117\48\0\9\196\0\117\48\0\9\196\0\117\48\0\9\196\0\117\48\0\117\48\0\9\196\0\58\152\0\58\152\0\58\152\0\58\152\0\58\152\0\117\48\0\117\48\0\117\48\0\117\48\0\117\48zzzzzz\0\97\168\0\97\168\0\97\168\0\97\168\0\97\168\0\97\168\0\97\168\0\97\168\3\13\64\3\13\64\0\97\168\0\97\168\0\97\168\0\97\168\0\97\168\0\0\0\0\97\168\0\97\168\0\97\168\0\97\168\0\97\168\0\97\168\0\97\168\0\97\168\0\97\168\3\13\64\0\97\168\0\97\168\0\97\168\0\97\168\0\97\168\0\97\168\3\13\64\0\97\168\0\97\168\0\97\168\0\97\168\0\201\244\0\201\244\0\201\244\0\201\244\0\201\244\0\201\244\0\41\213\0\41\213\0\41\213\0\41\213\0\41\213\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\100\157\0\100\250\0\94\26\0\94\119\0\94\212\0\87\192zzz\0\100\175\0\41\213\0\3\102\0\3\222zzz\0\0\0\0\0\0\0\0\6zzz\0\9\196\0\2\238zzz\0\0\0\0\0\12zzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzz\0\0\0zzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzz\0\4\226\0\5\220zzz\0\0\0\0\0\0\0\5\220\0\5\220zzz\0\39\16zzz\0\149\142\0\223\125zzz\0\0\0\0\129\103\0\129\228\0\196\112zzz\0\164\46\3\3\152\1\33\192zzzzzzzzzzzzzzzzzzzzzzzz\0\0\0zzz\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\234\96\0\234\96\0\234\96\0\234\96\0\234\96\0\234\96\0\234\96\0\234\96\0\234\96\0\234\96\0\234\96\0\234\96\0\234\96\0\234\96\0\234\96\0\234\96\0\234\96\0\234\96\0\234\96\0\234\96\0\234\96\0\234\96\0\234\96\0\234\96\0\234\96\0\234\96\0\234\96\0\234\96\0\234\96\0\234\96\0\234\96\0\234\96\0\234\96\0\234\96\0\195\80\0\195\80\0\195\80\0\195\80\0\195\80\0\197\207zzz\0\169\203\0\226\249\2\58\19\2\60\30\0\235\96\0\146\166\0\216\210\0\236\58\0\244\202\1\28\219zzz\1\30\255\0\0\0\0\235\96\2\180\58\0\195\80\1\0\39\0\167\245\1\24\243\1\166\234\2\53\239\1\107\129\0\114\1\0\171\154\0\160\5\0\160\162\1\89\35\0\235\96\2\29\133\1\86\48\0\246\150\0\136\230\0\235\96\1\8\114\1\34\31\2\43\183\0\111\141\0\244\107\0\0\0\0\169\38\0\58\152\0\158\46\0\158\199\0\58\152\0\187\188\0\188\112\0\172\18\0\58\152\0\58\152\0\58\152\0\58\152\0\58\152\0\58\152\0\58\152\0\58\152\0\58\152\0\58\152\0\58\152\0\58\152\0\58\152\0\58\152\0\58\152\0\58\152\0\58\152\0\58\152\0\58\152\0\58\152\0\58\152\0\58\152\0\58\152\0\58\152\0\58\152\0\58\152\0\58\152\0\58\152\0\58\152\0\58\152\0\58\152\0\58\152zzzzzzzzzzzzzzzzzzzzzzzzzzz\0\0\0\0\167\100\0\140\1\1\165\130\0\142\16\0\226\112\0\142\5\0\171\10\0\171\167\0\172\68\2\208\66\0\203\139\1\59\0\0\235\96\1\166\201\0\159\83\0\159\239\0\137\115\0\195\137\1\86\48\0\195\171\1\162\102\2\187\228\1\38\119\0\169\51\0\141\127\2\198\10\1\89\35\3\25\51\0\143\134\0\216\14\0\115\163\1\19\18zzzzzzzzzzzzzzz\0\0\0\3\25\51\1\81\171\1\162\92zzz\1\137\84\0\211\117\0\226\95\1\36\248\2\58\5\1\145\121\0\0\0\0\0\0\1\25\164\2\206\140\1\113\74\0\244\154\0\204\149\0\0\9zzzzzz\0\15\160zzzzzz\0\0\0zzzzzz\0\98\8\0\0\146\0\196\112\0\98\153\0\148\119\0\99\88\0\124\168\0\187\178\0\125\155\0\252\34\0\151\217\0\229\164\0\152\252\1\51\20\0\180\210\1\14\43\0\186\239\1\117\10zzzzzz\0\0\0zzz\0\117\48\0\117\48\0\117\48\0\117\48\0\9\196\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\157\153\0\0\0\0\0\0\0\7\208\0\0\0\0\0\0\0\0\0zzz\0\78\32\0\78\32\0\78\32\0\78\32\0\78\32\0\78\32\0\78\32\0\78\32\0\78\32\0\78\32\0\78\32\0\78\32\0\78\32\0\78\32\0\78\32\0\78\32\0\78\32\0\9\196zzz\0\78\32\0\0\0zzzzzzzzzzzz\0\0\125zzz\0\0\60zzz\0\0\0zzzzzz\0\0\0\1\14\85zzz\0\0\0\0\5\220\0\0\0\0\0\0zzz\0\3\232zzz\0\4\226\2\71\140\1\5\155\1\6\148\0\226\85\0\227\37\0\227\251\0\0\0\0\191\96\0\192\13\0\192\191zzz\0\0\0\1\100\24\0\0\0\1\25\103\1\25\103\1\25\103\1\25\103\1\25\103\1\25\103\1\25\103\1\25\103\1\25\103\0\150\219\0\151\106\1\100\24\0\235\96\0\0\0\0\0\0\2\47\167\1\100\24zzzzzz\0\0\0\1\100\24zzz\0\0\0\0\13\172zzz\0\246\144\0\0\0\0\193\116\0\110\80\0\41\213\0\178\236\0\104\182\1\3\152\0\216\35\0\115\174\0\87\192\1\38\86\0\210\185zzz\0\170\116\0\171\28\0\235\96\0\235\96\0\235\96\0\119\1\0\0\0\0\163\225\0\87\190\0\87\192\1\2\242\0\214\251\1\100\7\1\101\76\0\107\146\0\107\241\0\120\88\0\120\208zzz\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0zzzzzz\0\0\0zzzzzz\0\195\171zzz\1\0\39\0\197\207zzz\1\0\39\0\170\104\1\1\172zzz\0\172\59zzz\1\5\88\0\134\229\0\203\23\0\135\231\0\204\159\0\109\135\0\164\232\0\110\89\0\166\34zzz\0\235\96\0\167\245\1\89\35\1\82\85\0\212\57\0\0\0\0\0\0\0\8\252\0\8\252\0\8\252\0\8\252\0\8\252\0\8\252zzz\0\0\0\0\0\0\0\0\0\0\194\49\0\0\0\0\172\18\0\167\83\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0zzzzzz\0\0\0zzz\0\4\226zzzzzzzzz\0\125\200\0\94\86\0\125\200\0\94\86\0\125\200\0\125\200\0\94\86\0\94\86\0\0\0\0\0\0\0\35\240\0\35\240\0\35\240\0\35\240\0\35\240\0\35\240\0\143\192\0\143\192zzzzzz\0\0\0\0\215\160zzz\0\215\160\0\215\160zzz\0\76\94\0\215\160\0\76\94\0\76\94\0\76\94\0\80\219\0\121\189zzz\0\39\16\1\78\70\1\88\158\1\89\227\1\177\243\1\179\138\0\171\212\0\105\72zzz\0\0\85\0\1\64\0\0\0zzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzz\0\0\155\0\0\155\0\0\155\0\0\155\0\1\144\0\1\144zzz\0\0\1\0\0\1\0\0\1\0\0\1\0\0\1\0\0\1zzzzzzzzzzzzzzz\0\0\0\0\0\1\0\0\1\0\0\1\0\0\1\0\0\1\0\0\1\0\0\1\0\0\1\0\0\1\0\0\1\0\0\1\0\0\1\0\0\1\0\0\1\0\0\27\0\48\212\0\48\212\0\48\212\0\0\0\0\0\0zzz\0\0\225\0\0\200zzzzzz\0\0\2zzz\0\0\2\0\0\250\0\0\0\0\0\0\0\0\0zzzzzzzzz\0\0\0\0\29\76\0\29\76\0\29\76\0\29\76\0\0\0zzz\0\29\76\0\0\0\0\48\212\0\48\212\0\48\212\0\48\212\0\48\212\0\48\212\0\48\212\0\48\212\0\48\212\0\48\212\0\48\212\0\48\212\1\56\139zzz\0\9\196\0\31\114\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0zzz\0\81\241\0\40\67\0\40\67\0\152\210zzz\0\152\210\0\0\0\0\104\133zzz\0\171\193\1\71\85\0\245\213\1\98\184\0\18\10\0\2\178\0\1\204zzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzz\0\0\0zzzzzzzzzzzzzzzzzzzzzzzz\0\0\0zzz\0\0\0\0\0\0\0\8\252\1\148\43\1\149\175\0\244\81\0\38\226\0\39\16zzzzzz\0\39\16\3\181\168\3\185\6\0\2\238zzz\0\0\0zzzzzzzzzzzzzzzzzzzzz\0\2\238\0\2\238\0\2\238\0\2\238zzz\2\32\165\0\0\0\0\0\0zzzzzzzzzzzzzzzzzz\0\68\92zzz\0\69\24\0\145\97\0\55\177\0\126\87\0\144\12\0\173\124\0\152\12\0\218\106\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\6\0\0\6\0\0\0\0\0\0\0\0\0\0\0\0zzz\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0zzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzz\0\0\0\0\2\178\0\1\204\0\0\0zzz\0\0\0\0\0\0zzz\0\0\0zzzzzzzzzzzz\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\1\124\248\1\124\248\2\35\152\2\12\107\2\39\174\2\41\171zzzzzz\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0zzzzzzzzzzzzzzz\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0zzzzzz\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0zzzzzzzzz\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0zzzzzzzzz\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0zzzzzzzzz\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0zzz\0\0\0zzzzzzzzz\0\0\0\0\97\168zzz\0\48\212zzz\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\50\0\0\100\0\0\125\0\0\200\0\0\0\0\0\3\0\0\12\0\0\1\0\0\25\0\0\50\0\0\100\0\0\100\0\0\160\0\0\160zzzzzzzzzzzzzzz\0\1\64zzzzzzzzz\0\0\0zzz\0\0\200\0\0\0zzzzzz\0\0\200\0\0\200\0\235\96\0\235\96zzzzzz\0\235\96\0\0\0\0\0\0zzz\0\0\0\0\0\0zzzzzzzzzzzzzzzzzzzzzzzzzzz\0\0\0\0\0\0\0\0\0zzzzzzzzzzzz\0\0\0\0\0\5zzzzzz\0\0\0zzzzzzzzzzzz\0\0\0\0\0\0zzz\0\19\136\0\19\136\0\0\0zzzzzz\0\0\0\0\0\0\0\0\0\0\0\0zzzzzzzzz\0\0\0zzzzzzzzzzzz\0\0\0zzz\0\0\0zzzzzzzzzzzz\0\0\0\0\78\32\0\0\0\0\0\0\0\0\0\0\0\0\0\148\141\0\0\0\0\48\212\0\0\0zzzzzz\0\0\0\0\0\0\0\0\0\0\117\48\0\0\0\0\117\48\0\117\48\0\117\48\0\0\0\0\0\0\0\0\0\0\0\0\0\117\48\0\0\0\0\0\0\0\117\48\0\117\48\0\0\0\0\0\0\0\0\0\0\97\168\0\97\168\0\97\168\0\97\168\0\97\168\0\97\168zzz\0\117\48\0\117\48\0\117\48\0\117\48\0\117\48\0\117\48\0\0\0\0\0\0zzz\0\0\0\0\29\76zzz\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\181\44\0\78\32zzzzzz\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0zzzzzzzzz\0\70\80\0\3\182\0\0\0\0\0\0zzz\0\0\0\1\15\105zzz\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0zzz\0\188\161\0\205\67\0\234\96\0\223\215zzz\0\19\136\0\39\16\0\0\0\0\129\122\0\0\0\0\0\0\2\26\120\1\111\188\1\113\11\0\0\0zzzzzz\0\0\0\0\0\0zzzzzzzzzzzzzzz\0\0\0\0\12\155\0\12\167\0\16\74\0\13\62\0\10\141\0\8\228\0\0\200\0\4\7\0\1\24\0\22\140\0\0\0\0\21\31\0\19\161\0\21\71\0\21\92\0\14\227\0\14\241\0\7\202\0\1\24\0\11\198\0\12\255\0\13\11\0\8\186\0\24\133\0\21\25\0\14\112\0\1\144\0\14\164\0\14\179\0\13\172\0\29\116\0\16\75\0\14\33\0\14\47\0\19\241\0\21\138\0\18\120\0\17\26\0\17\26\0\37\75\0\37\110\0\34\201\0\37\179\0\40\247\0\35\66\0\28\171\0\24\172\0\0\0\0\0\0zzz\0\0\0zzzzzz\1\145\121\0\0\0\2\4\119\0\0\0\0\101\76\0\228\195zzz\0\0\0\0\0\0\0\0\0zzz\0\0\2\0\235\96\0\0\0\0\0\0zzz\1\89\35\1\251\153\1\3\140\0\186\109\0\0\0\0\0\0\1\14\117zzz\0\117\48zzz\0\58\152\0\0\0zzz\0\0\0\0\0\0\0\0\0zzz\0\0\0\0\0\0\0\0\0\0\196\157\0\0\0\0\0\0\0\0\0\0\0\0\1\1\21\0\0\0zzzzzz\1\77\210\1\18\76\1\59\51\1\7\154\0\0\0zzz\1\52\153zzzzzz\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\2\1\133\0\0\0\0\188\150\0\144\148\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0zzz\0\0\0\1\245\238\1\247\219\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\1\29\42\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\237\19\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\170\99\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\158\157\0\0\0zzz\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\164\96\0\231\32\2\125\41\1\89\35\2\22\252\2\24\253\1\56\141\0\0\0\0\149\194\0\0\0\1\114\7\1\139\41\0\0\0\2\40\232\0\0\0\2\184\19\0\202\145\0\97\60\0\255\181\0\0\0zzzzzz\0\0\0\0\0\0\0\0\0\0\0\0\0\150\219\2\136\252\1\134\213\2\141\186\2\12\231\2\146\137\2\16\192\0\235\96\0\235\96\0\235\96\0\235\96\0\235\96zzzzzzzzzzzzzzzzzzzzzzzzzzzzzz\0\0\0zzzzzzzzzzzzzzzzzzzzzzzzzzz\0\0\0zzzzzzzzz\0\0\0\0\0\0zzzzzzzzzzzzzzzzzz\1\58\28zzzzzzzzzzzzzzzzzzzzz\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0zzz\0\0\0\0\0\0\0\0\0\0\0\0zzz\0\0\0zzz\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0zzz\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0zzzzzzzzzzzz\0\0\0zzzzzzzzzzzzzzzzzzzzzzzz\0\155\83\0\155\227\0\145\74zzz\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\117\48\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\2\1\80\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0zzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzz\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\117\48zzzzzz\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\1\60\0\0\25\0\0\0\0\0\0\0\0\0\0\0\0zzz\0\0\0\0\0\0\0\0\0zzz\0\0\0\0\0\2\0\58\152\0\217\213\0\0\0\0\0\0zzzzzzzzzzzzzzzzzzzzzzzzzzz\0\0\0zzz\0\0\0\0\99\146zzz\0\0\0\0\0\8\0\0\8\0\0\150zzzzzz\1\100\24\1\100\24\1\100\24\1\100\24zzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzz\0\0\87\0\0\0\0\1\207zzzzzzzzzzzzzzzzzzzzz\0\2\51\0\14\166\0\0\33\0\0\113zzzzzzzzzzzzzzzzzzzzz\0\1\144\0\2\38\0\0\8zzz\0\19\136\0\19\136\0\19\136\0\0\150\0\19\136\0\0\150\0\19\136zzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzz\0\0\125\0\19\136\0\0\250zzz\0\0\250zzzzzzzzzzzzzzz\0\44\236\0\44\236zzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzz\1\212\192zzzzzzzzz\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0zzzzzzzzzzzzzzzzzz\0\240\247zzzzzzzzz\0\0\0zzzzzzzzz\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0zzz\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0zzz\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0zzz\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0zzz\2\14\211\0\162\133\1\81\43\0\158\12\0\0\0zzzzzzzzz\0\0\1\0\0\3\0\0\12\0\0\25\0\0\50\0\0\100\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0zzz\0\35\31\0\0\0\0\0\0\0\0\0zzz\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0zzzzzz\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0zzzzzzzzzzzz\0\0\12\0\0\25\0\0\3zzz\0\195\80zzz\0\0\0\0\0\0\0\0\0\0\0\0zzzzzzzzz\0\0\0zzz\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\1\0\0\1\0\0\1\0\0\0zzz\0\0\0\0\0\0zzz\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\87\228\0\87\228\0\0\0\0\0\0\0\0\0\0\0\0\0\146\124\0\146\124\0\0\0\0\0\0\0\2\113\0\0\0\0\0\0\0\0\0\0\39\16\0\117\48\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0zzz\0\0\95\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0zzzzzz\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0zzz\0\0\0\0\0\0zzz\0\0\0zzzzzz\2\77\241\2\80\41\0\235\96\1\174\48\1\114\26\0\244\107\0\248\137\0\0\0\0\156\64\0\156\64\0\156\64\0\156\64\2\4\119\1\89\35\1\81\171\3\25\51\1\163\9\0\240\86\2\219\207\2\222\149\1\145\121\1\122\232\1\111\83\0\0\0\1\60\138\0\235\96\0\185\175zzz\1\0\39\1\0\39\1\36\82\0\220\51\1\173\27\2\62\91\2\208\184\2\66\203\0\156\64\0\156\64\0\180\235\2\91\125\1\89\35\0\182\92\3\25\51\0\29\76\1\30\31\0\238\61\0\191\70\1\63\231\1\65\12\0\235\96\2\115\181\1\154\243\1\156\141\0\0\0\0\156\64\0\0\0\0\117\48\0\117\48\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\24\56\1\123\198\1\125\36\0\235\96\1\141\111\1\0\208\0\250\43\0\161\162\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\216\99\0\190\131\0\191\56\1\79\59\0\240\202\0\241\165zzz\3\43\94zzz\3\208\144\0\0\0\0\0\0\0\0\0zzzzzzzzzzzzzzzzzzzzz\0\0\0\0\4\226\0\4\226\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\4\226\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\2\94\163\0\29\76\2\99\87\1\27\182\1\28\197\2\202\146\2\125\118\2\127\209\3\34\181zzz\0\194\10\0\194\191\0\172\18\0\130\197\0\196\216\0\131\179\1\90\73\2\113\109\1\214\176\1\183\68\0\142\16\0\177\4\0\148\18\0\172\18\0\230\134\1\67\73\1\22\169\1\23\176\1\70\225\1\89\35\1\89\35\1\89\35\0\235\96\0\235\96\0\235\96\0\237\177\0\238\149\0\119\191\0\120\52zzz\1\46\196\0\151\244\1\49\13\0\153\25\1\112\196\0\185\17\1\115\130\0\186\112\1\180\149\0\172\18\1\183\200\0\227\182zzzzzzzzzzzzzzzzzz\0\0\0zzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzz\0\0\200\0\0\160\0\0\50\0\9\196zzz\0\0\0\0\15\165\0\19\143\0\78\92\0\101\58zzz\0\47\57\0\54\201\0\39\16\0\39\16zzzzzz\1\25\103\1\25\103\1\25\103\1\25\103zzzzzzzzzzzzzzzzzzzzzzzzzzz\0\27\88zzzzzzzzzzzzzzzzzzzzzzzz\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\39\16\1\25\103\1\25\103\1\25\103\1\25\103zzzzzz\1\134\160zzzzzzzzzzzz\0\0\0\0\117\48zzz\0\9\196zzz\0\9\196zzzzzzzzz\0\156\64\0\93\192zzzzzz\0\0\0\0\0\0\0\0\0zzz\0\0\0zzzzzzzzzzzz\0\0\0\0\24\106\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0zzzzzzzzzzzz\0\0\0\0\0\0zzz\0\0\0\0\9\196\0\0\0\0\9\196\0\5\220\0\5\220zzzzzzzzzzzz\0\0\0zzzzzzzzz\0\0\0zzz\0\0\0\0\0\0\0\0\0\0\0\0zzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzz\0\0\12\0\0\12zzzzzzzzz\0\0\0zzz\0\0\0\0\0\0\0\0\0\0\0\0zzzzzzzzzzzz\0\0\0\0\0\0\0\0\0zzz\0\0\0\0\240\191\0\115\73\0\143\81\1\208\124\1\78\211\1\223\249\0\130\189\2\34\223\1\217\229\0\190\69\1\221\129\0\251\44\0\180\111\1\33\196\1\83\87\1\230\154\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\78\32\0\0\0\0\0\0\1\36\248\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\87\228\1\102\155\1\103\224\1\70\182\0\0\0\0\0\0\1\83\154\1\84\223\1\86\37\1\173\69\1\2\125\1\39\48\1\40\70\0\227\76\0\227\76\0\227\76\0\227\76\0\0\0\0\0\0zzzzzzzzzzzz\0\0\0\0\0\0\0\117\48\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\65\142\0\98\85\1\71\199\0\115\96\0\163\227\0\98\212\1\74\179\0\57\254\0\65\142\0\214\251\0\122\234\0\98\85\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\250\0\0\0\0\0\0\0\171\212\0\0\0\0\0\0\0\0\0\0\0\0\0\103\199\0\115\96\1\92\119\0\98\85\0\98\85\0\65\142\1\153\185\0\171\193\0\163\227\1\153\185\0\27\190\0\251\221\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\219\246\0\83\244\0\166\185\0\125\238\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\3\208\144\2\191\32\2\73\240\1\173\176\2\73\240\1\184\163\1\186\67\1\173\176\0\0\0\0\117\48\0\0\50zzz\0\19\136\0\0\0\0\7\208\0\44\36\0\2\158\0\58\152\0\78\32\0\15\160\0\0\0\0\58\152\0\0\0\0\34\46\0\18\154\0\190\160\0\195\80\0\0\0\0\0\25\0\195\80\0\195\80\0\195\80\0\195\80\0\195\80\0\195\80\0\195\80\0\195\80\0\167\48\0\66\104\0\0\137zzzzzzzzzzzzzzzzzzzzz\0\0\0\0\0\0\0\0\0\0\146\124\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0zzzzzzzzzzzzzzzzzzzzzzzzzzzzzz\0\0\0zzz\0\0\0zzzzzzzzzzzzzzzzzzzzz\0\58\152\0\0\0\0\0\0zzzzzzzzz\0\0\0zzz\0\0\0zzzzzzzzzzzz\0\0\0zzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzz\0\0\0zzzzzzzzzzzzzzz\0\0\0zzz\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0zzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzz\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\43\242zzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzz\0\182\84\0\228\196\0\229\153\1\27\233\1\75\204\0\78\32\0\146\124\0\0\0\0\146\124\0\146\124\0\146\124\0\146\124\0\146\124\0\146\124\0\146\124\0\146\124\0\146\124\0\136\184\0\136\184\0\136\184\0\136\184\0\136\184\0\136\184\0\78\32\0\78\32\0\78\32\0\78\32\0\78\32\0\78\32\0\78\32\0\78\32\0\78\32\0\78\32\0\78\32\0\78\32\0\78\32\0\78\32\0\78\32\0\78\32\0\0\0\0\9\196\0\0\0zzz\0\0\0zzzzzzzzz\0\0\0zzzzzzzzzzzzzzz\0\0\0\0\0\0\0\0\0zzz\1\232\72\1\232\72\1\232\72\1\232\72\1\232\72\1\232\72\1\232\72\1\232\72\1\232\72\1\232\72\1\232\72\1\232\72\1\232\72\1\232\72\1\232\72\1\232\72\1\232\72\1\232\72\1\232\72\1\232\72\1\232\72\1\232\72\1\232\72\1\232\72\1\232\72\1\232\72\1\232\72\1\232\72\1\232\72\1\232\72\1\232\72\1\232\72\1\232\72\1\232\72\0\0\0\0\78\32\0\0\0\0\18\10\0\0\0zzz\0\0\0zzzzzz\0\0\0\0\235\96\0\235\96\0\235\96\0\0\50\0\0\100\0\0\50\0\0\0\0\0\0\0\235\96\0\235\96\0\235\96\0\0\0\0\97\168\0\78\32\0\3\182\0\117\48\0\39\16\0\117\48\0\234\96\0\234\96\0\234\96\0\234\96\0\117\48\0\117\48\0\117\48\0\117\48\0\78\32\0\117\48\0\68\92\0\78\32\0\0\0zzz\0\0\75\0\117\48\0\117\48zzz\0\117\48zzzzzzzzz\0\117\48\0\117\48zzz\0\117\48zzzzzz\0\67\239\0\102\69\0\136\223\0\103\9\0\137\227\0\103\201\0\138\228\0\69\179\0\104\238\0\140\103\0\70\116\0\106\16\0\141\238\0\106\209\0\142\239\0\107\148\0\100\93\0\67\42\0\134\214\0\135\88zzzzzzzzz\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\87\109\0\131\157\0\176\31\0\132\145\0\164\187\0\82\175\0\124\128\0\166\159\0\125\113\0\218\144\0\84\67\0\126\220\0\169\200\0\127\208\0\171\14\0\85\214\0\129\59\0\172\241\0\130\47\0\218\144\0\209\205\0\108\3\0\147\25\0\196\229\0\148\230\0\198\107\0\99\148\0\149\241\0\200\176\0\151\194\0\202\49\0\101\122\0\185\23\0\204\123\0\154\154\0\205\252\0\103\96\0\159\183\0\213\184\0\161\147\0\2\138\0\2\138\0\2\138\0\2\138\0\2\138\0\0\0\0\232\85\0\117\71\0\175\64\0\234\250\0\176\144\0\236\194\0\119\125\0\183\81\0\245\199\0\184\166\0\247\137\0\124\236\0\186\161\0\250\52\0\187\242\0\2\138\0\2\138\0\2\138\0\2\138\0\2\138\0\2\138\0\2\138\0\2\138\0\2\138\0\2\138\0\2\138\0\2\138\0\2\138\0\2\138\0\2\138\0\2\138\0\2\138\0\2\138\0\2\138\0\2\138\0\2\138\0\2\138\0\2\138\0\2\138\0\2\138\0\2\138\0\2\138\0\2\138\0\2\138\0\2\138\0\2\138\0\2\138\0\2\138\0\2\138\0\2\138\0\2\138\0\2\138\0\2\138\0\2\138\0\2\138\0\2\138\0\2\138\0\2\138\0\2\138\0\2\138\0\2\138\0\0\0\0\137\93\0\103\101\0\103\199\0\138\224\0\87\29\0\174\218\0\131\157\0\88\15\0\212\23\0\98\214\0\148\212\0\99\154\0\174\158\0\117\191\0\175\243\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\234\96\0\234\96\0\234\96\0\0\0\0\0\0\0\0\0\0\0\0\0\127\13\0\127\135\0\128\4\0\125\238\0\58\152\0\0\0\0\146\124\0\117\48\0\146\124\0\117\48\0\9\196\0\146\124\0\0\0\0\195\80\0\195\80\0\195\80\0\0\0\0\195\80zzzzzz\2\17\72\0\0\0\0\34\46\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\29\76\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0zzz\0\0\0\0\0\0\0\0\0\0\0\0\0\0\37\0\0\12\0\17\148\0\0\12\0\17\148\0\0\0zzzzzz\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\102\15\0\58\152\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\237\0\0\0\0\58\152\0\46\224\0\244\36\0\244\36\0\244\36\0\244\36\0\244\36\0\58\152\0\0\0\0\58\152\0\58\152\0\0\0\0\0\0\0\0\0\0\117\48\0\117\48\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0zzzzzz\0\0\0\0\0\0\0\1\244\0\0\0\0\0\0zzz\0\0\0zzz\0\0\0\0\0\0zzzzzzzzzzzz\0\0\0\0\235\96\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\97\168\0\97\168\0\97\168\0\97\168\0\244\36\0\244\36\0\244\36\0\244\36\0\117\48\0\0\0\0\117\48\0\117\48\0\234\96\0\234\96\0\58\152\0\58\152\0\58\152\0\58\152\1\232\72\1\232\72\1\232\72\1\232\72\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0zzz\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0zzz\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0zzz\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0zzz\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0zzz\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\34\46\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\234\96\1\232\72\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\1\19\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0zzz\0\0\0\0\0\1\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0zzz\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\19\136\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0zzzzzz\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0zzzzzz\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\4\226\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0zzzzzzzzz\0\0\0\0\0\0\0\0\0\0\0\0\0\195\80\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0zzz\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\1\134\160\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\156\64\0\195\80zzz\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0zzzzzzzzzzzz\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0zzz\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\92\198\0\0\0\0\0\0\0\0\0zzz\0\0\0\0\0\0\0\0\0zzz\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\49\12\0\7\32\0\6\128\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0zzzzzz\0\0\0\0\0\0\0\0\0\0\0\0zzz\0\0\0\0\0\0zzz\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0zzz\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0zzz\0\0\0zzzzzzzzzzzzzzz\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0zzz\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\4\226\0\4\101zzz\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\1\24\0\1\144\0\0\200\0\1\24\0\1\64\0\1\119\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\1\244\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\99\156\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\37\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0zzzzzzzzzzzzzzzzzz\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\1\134\160\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0zzz"

  price_count = 23565
  local byte = string.byte
  function get(id)
    if id and id <= 39656 and id > 0 then
      local index = id * 3
      local a, b, c = byte(prices, index - 2, index)
      if a == 122 and b == 122 and c == 122 then return 0 end
      if b == 0 then
        if c == 0 then
          if a == 0 then return else return a * 65536 end
        else
          return a * 65536 + c
        end
      else
        return a * 65536 + b * 256 + c
      end
    end
  end
end
